package XML::IODEF::Simple::Plugin::AddMalware;

use Digest::SHA1 qw/sha1_hex/;
use Digest::MD5 qw/md5_hex/;

sub prepare {
    my $class   = shift;
    my $info    = shift;

    return unless($info->{'malware_md5'} || $info->{'malware_sha1'});
    return(1);
}

sub convert {
    my $class = shift;
    my $info = shift;
    my $iodef = shift;

    if($info->{'malware_md5'}){
        $iodef->add('IncidentEventDataAdditionalDatadtype','string');
        $iodef->add('IncidentEventDataAdditionalDatameaning','malware_md5');
        $iodef->add('IncidentEventDataAdditionalData',$info->{'malware_md5'});
    }
    if($info->{'malware_sha1'}){
        $iodef->add('IncidentEventDataAdditionalDatadtype','string');
        $iodef->add('IncidentEventDataAdditionalDatameaning','malware_sha1');
        $iodef->add('IncidentEventDataAdditionalData',$info->{'malware_sha1'});
    }

    return($iodef);
}

1;
