package Locales::DB::Territory::fa;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::fa::VERSION = '0.09';

$Locales::DB::Territory::fa::cldr_version = '2.0';

%Locales::DB::Territory::fa::code_to_name = (
    '001' => 'جهان',
    '002' => 'افریقا',
    '003' => "امریکای\ شمالی",
    '005' => "امریکای\ جنوبی",
    '009' => 'اقیانوسیه',
    '011' => "غرب\ افریقا",
    '013' => "امریکای\ مرکزی",
    '014' => "شرق\ افریقا",
    '015' => "شمال\ افریقا",
    '017' => "مرکز\ افریقا",
    '018' => "جنوب\ افریقا",
    '019' => 'امریکا',
    '021' => "شمال\ امریکا",
    '029' => 'کارائیب',
    '030' => "شرق\ آسیا",
    '034' => "جنوب\ آسیا",
    '035' => "جنوب\ شرقی\ آسیا",
    '039' => "جنوب\ اروپا",
    '053' => "استرالیا\ و\ زلاند\ نو",
    '054' => 'ملانزی',
    '057' => "ناحیهٔ\ میکرونزی",
    '061' => 'پلی‌نزی',
    '062' => "جنوب\ آسیا\ و\ آسیای\ میانه",
    142   => 'آسیا',
    143   => "آسیای\ مرکزی",
    145   => "غرب\ آسیا",
    150   => 'اروپا',
    151   => "شرق\ اروپا",
    154   => "شمال\ اروپا",
    155   => "غرب\ اروپا",
    172   => "کشورهای\ مستقل\ مشترک‌المنافع",
    200   => 'Czechoslovakia',
    419   => "امریکای\ لاتین",
    830   => "Channel\ Islands",
    'ac'  => "جزایر\ آسنسیون",
    'ad'  => 'آندورا',
    'ae'  => "امارات\ متحدهٔ\ عربی",
    'af'  => 'افغانستان',
    'ag'  => "آنتیگوا\ و\ باربودا",
    'ai'  => 'آنگیل',
    'al'  => 'آلبانی',
    'am'  => 'ارمنستان',
    'an'  => "آنتیل\ هلند",
    'ao'  => 'آنگولا',
    'aq'  => 'جنوبگان',
    'ar'  => 'آرژانتین',
    'as'  => "ساموای\ امریکا",
    'at'  => 'اتریش',
    'au'  => 'استرالیا',
    'aw'  => 'آروبا',
    'ax'  => "جزایر\ آلاند",
    'az'  => "جمهوری\ آذربایجان",
    'ba'  => "بوسنی\ و\ هرزگوین",
    'bb'  => 'باربادوس',
    'bd'  => 'بنگلادش',
    'be'  => 'بلژیک',
    'bf'  => 'بورکینافاسو',
    'bg'  => 'بلغارستان',
    'bh'  => 'بحرین',
    'bi'  => 'بوروندی',
    'bj'  => 'بنین',
    'bl'  => "سنت\ بارتیلمی",
    'bm'  => 'برمودا',
    'bn'  => 'برونئی',
    'bo'  => 'بولیوی',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'برزیل',
    'bs'  => 'باهاما',
    'bt'  => 'بوتان',
    'bv'  => "جزیره\ بووت",
    'bw'  => 'بوتسوانا',
    'by'  => 'بیلوروسی',
    'bz'  => 'بلیز',
    'ca'  => 'کانادا',
    'cc'  => "جزایر\ کوکوس\ \[کیلینگ\]",
    'cd'  => "کنگو\ \[جمهوری\ دموکراتیک\]",
    'cf'  => "جمهوری\ افریقای\ مرکزی",
    'cg'  => "کنگو\ \[جمهوری\]",
    'ch'  => 'سوئیس',
    'ci'  => "ساحل\ عاج",
    'ck'  => "جزایر\ کوک",
    'cl'  => 'شیلی',
    'cm'  => 'کامرون',
    'cn'  => 'چین',
    'co'  => 'کلمبیا',
    'cp'  => "جزایر\ کلیپرتون",
    'cr'  => 'کاستاریکا',
    'cs'  => "صربستان\ و\ مونته‌نگرو",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'کوبا',
    'cv'  => 'کیپ‌ورد',
    'cx'  => "جزیرهٔ\ کریسمس",
    'cy'  => 'قبرس',
    'cz'  => "جمهوری\ چک",
    'dd'  => "East\ Germany",
    'de'  => 'آلمان',
    'dg'  => "دیه‌گو\ گارسیا",
    'dj'  => 'جیبوتی',
    'dk'  => 'دانمارک',
    'dm'  => 'دومینیک',
    'do'  => "جمهوری\ دومینیکن",
    'dz'  => 'الجزایر',
    'ea'  => "سبته\ و\ ملیله",
    'ec'  => 'اکوادور',
    'ee'  => 'استونی',
    'eg'  => 'مصر',
    'eh'  => "صحرای\ غربی",
    'er'  => 'اریتره',
    'es'  => 'اسپانیا',
    'et'  => 'اتیوپی',
    'eu'  => "اتحادیهٔ\ اروپا",
    'fi'  => 'فنلاند',
    'fj'  => 'فیجی',
    'fk'  => "جزایر\ فالکلند\ \[ایسلاس\ مالویناس\]",
    'fm'  => 'میکرونزی',
    'fo'  => "جزایر\ فارو",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'فرانسه',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'گابون',
    'gb'  => 'بریتانیا',
    'gd'  => 'گرانادا',
    'ge'  => 'گرجستان',
    'gf'  => "گویان\ فرانسه",
    'gg'  => 'گرنزی',
    'gh'  => 'غنا',
    'gi'  => 'جبل‌الطارق',
    'gl'  => 'گرینلند',
    'gm'  => 'گامبیا',
    'gn'  => 'گینه',
    'gp'  => 'گوادلوپ',
    'gq'  => "گینهٔ\ استوایی",
    'gr'  => 'یونان',
    'gs'  => "جورجیای\ جنوبی\ و\ جزایر\ ساندویچ\ جنوبی",
    'gt'  => 'گواتمالا',
    'gu'  => 'گوام',
    'gw'  => "گینهٔ\ بیسائو",
    'gy'  => 'گویان',
    'hk'  => 'هنگ‌کنگ',
    'hm'  => "جزیرهٔ\ هرد\ و\ جزایر\ مک‌دونالد",
    'hn'  => 'هندوراس',
    'hr'  => 'کرواسی',
    'ht'  => 'هائیتی',
    'hu'  => 'مجارستان',
    'ic'  => "جزایر\ قناری",
    'id'  => 'اندونزی',
    'ie'  => 'ایرلند',
    'il'  => 'اسرائیل',
    'im'  => "جزیرهٔ\ من",
    'in'  => 'هند',
    'io'  => "مستعمره‌های\ بریتانیا\ در\ اقیانوس\ هند",
    'iq'  => 'عراق',
    'ir'  => 'ایران',
    'is'  => 'ایسلند',
    'it'  => 'ایتالیا',
    'je'  => 'جرزی',
    'jm'  => 'جامائیکا',
    'jo'  => 'اردن',
    'jp'  => 'ژاپن',
    'jt'  => "Johnston\ Island",
    'ke'  => 'کنیا',
    'kg'  => 'قرقیزستان',
    'kh'  => 'کامبوج',
    'ki'  => 'کریباتی',
    'km'  => 'کومورو',
    'kn'  => "سنت\ کیتس\ و\ نویس",
    'kp'  => "کرهٔ\ شمالی",
    'kr'  => "کرهٔ\ جنوبی",
    'kw'  => 'کویت',
    'ky'  => "جزایر\ کِیمن",
    'kz'  => 'قزاقستان',
    'la'  => 'لائوس',
    'lb'  => 'لبنان',
    'lc'  => "سنت\ لوسیا",
    'li'  => 'لیختن‌اشتاین',
    'lk'  => 'سری‌لانکا',
    'lr'  => 'لیبریا',
    'ls'  => 'لسوتو',
    'lt'  => 'لیتوانی',
    'lu'  => 'لوکزامبورگ',
    'lv'  => 'لتونی',
    'ly'  => 'لیبی',
    'ma'  => 'مراکش',
    'mc'  => 'موناکو',
    'md'  => 'مولداوی',
    'me'  => 'مونته‌نگرو',
    'mf'  => "سنت\ مارتین",
    'mg'  => 'ماداگاسکار',
    'mh'  => "جزایر\ مارشال",
    'mi'  => "Midway\ Islands",
    'mk'  => "مقدونیه\ \[جمهوری\ سابقاً\ یوگسلاو\]",
    'ml'  => 'مالی',
    'mm'  => "میانمار\ \[برمه\]",
    'mn'  => 'مغولستان',
    'mo'  => 'ماکائو',
    'mp'  => "جزایر\ ماریانای\ شمالی",
    'mq'  => 'مارتینیک',
    'mr'  => 'موریتانی',
    'ms'  => 'مونت‌سرات',
    'mt'  => 'مالت',
    'mu'  => 'موریس',
    'mv'  => 'مالدیو',
    'mw'  => 'مالاوی',
    'mx'  => 'مکزیک',
    'my'  => 'مالزی',
    'mz'  => 'موزامبیک',
    'na'  => 'نامیبیا',
    'nc'  => "کالدونیای\ جدید",
    'ne'  => 'نیجر',
    'nf'  => "جزیرهٔ\ نورفولک",
    'ng'  => 'نیجریه',
    'ni'  => 'نیکاراگوئه',
    'nl'  => 'هلند',
    'no'  => 'نروژ',
    'np'  => 'نپال',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'نائورو',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'نیوئه',
    'nz'  => "زلاند\ نو",
    'om'  => 'عمان',
    'pa'  => 'پاناما',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'پرو',
    'pf'  => "پلی‌نزی\ فرانسه",
    'pg'  => "پاپوا\ گینهٔ\ نو",
    'ph'  => 'فیلیپین',
    'pk'  => 'پاکستان',
    'pl'  => 'لهستان',
    'pm'  => "سنت\ پیر\ و\ میکلون",
    'pn'  => "جزایر\ پیت‌کرن",
    'pr'  => 'پورتوریکو',
    'ps'  => "سرزمین‌های\ فلسطینی",
    'pt'  => 'پرتغال',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'پالائو',
    'py'  => 'پاراگوئه',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'قطر',
    'qo'  => "بخش‌های\ دورافتادهٔ\ اقیانوسیه",
    're'  => 'ریونیون',
    'ro'  => 'رومانی',
    'rs'  => 'صربستان',
    'ru'  => 'روسیه',
    'rw'  => 'رواندا',
    'sa'  => 'عربستان',
    'sb'  => "جزایر\ سلیمان",
    'sc'  => 'سیشل',
    'sd'  => 'سودان',
    'se'  => 'سوئد',
    'sg'  => 'سنگاپور',
    'sh'  => "سنت\ هلن",
    'si'  => 'اسلوونی',
    'sj'  => "اسوالبارد\ و\ جان‌ماین",
    'sk'  => 'اسلواکی',
    'sl'  => 'سیرالئون',
    'sm'  => 'سان‌مارینو',
    'sn'  => 'سنگال',
    'so'  => 'سومالی',
    'sr'  => 'سورینام',
    'st'  => "سائوتومه\ و\ پرینسیپه",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'السالوادور',
    'sy'  => 'سوریه',
    'sz'  => 'سوازیلند',
    'ta'  => "تریستان\ دا\ کونا",
    'tc'  => "جزایر\ ترک\ و\ کایکوس",
    'td'  => 'چاد',
    'tf'  => "مستعمره‌های\ جنوبی\ فرانسه",
    'tg'  => 'توگو',
    'th'  => 'تایلند',
    'tj'  => 'تاجیکستان',
    'tk'  => 'توکلائو',
    'tl'  => "تیمور\ شرقی",
    'tm'  => 'ترکمنستان',
    'tn'  => 'تونس',
    'to'  => 'تونگا',
    'tr'  => 'ترکیه',
    'tt'  => "ترینیداد\ و\ توباگو",
    'tv'  => 'تووالو',
    'tw'  => 'تایوان',
    'tz'  => 'تانزانیا',
    'ua'  => 'اوکراین',
    'ug'  => 'اوگاندا',
    'um'  => "جزایر\ کوچک\ دورافتادهٔ\ ایالات\ متحده",
    'us'  => "ایالات\ متحدهٔ\ امریکا",
    'uy'  => 'اروگوئه',
    'uz'  => 'ازبکستان',
    'va'  => 'واتیکان',
    'vc'  => "سنت\ وینسنت\ و\ گرنادین",
    'vd'  => "North\ Vietnam",
    've'  => 'ونزوئلا',
    'vg'  => "جزایر\ ویرجین\ بریتانیا",
    'vi'  => "جزایر\ ویرجین\ ایالات\ متحده",
    'vn'  => 'ویتنام',
    'vu'  => 'وانواتو',
    'wf'  => "والیس\ و\ فیوتونا",
    'wk'  => "Wake\ Island",
    'ws'  => 'ساموا',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'یمن',
    'yt'  => 'مایوت',
    'za'  => "افریقای\ جنوبی",
    'zm'  => 'زامبیا',
    'zw'  => 'زیمبابوه',
    'zz'  => "ناحیهٔ\ نامشخص",
);

%Locales::DB::Territory::fa::name_to_code = (
    'britishantarcticterritory'                                       => 'bq',
    'cantonandenderburyislands'                                       => 'ct',
    'channelislands'                                                  => 830,
    'czechoslovakia'                                                  => 200,
    'dronningmaudland'                                                => 'nq',
    'eastgermany'                                                     => 'dd',
    'frenchsouthernandantarcticterritories'                           => 'fq',
    'johnstonisland'                                                  => 'jt',
    'metropolitanfrance'                                              => 'fx',
    'midwayislands'                                                   => 'mi',
    'neutralzone'                                                     => 'nt',
    'northvietnam'                                                    => 'vd',
    'pacificislandstrustterritory'                                    => 'pc',
    'panamacanalzone'                                                 => 'pz',
    "people\â\\sdemocraticrepublicofyemen"                       => 'yd',
    "u\.s\.miscellaneouspacificislands"                               => 'pu',
    'unionofsovietsocialistrepublics'                                 => 'su',
    'wakeisland'                                                      => 'wk',
    'آروبا'                                                      => 'aw',
    'آرژانتین'                                                => 'ar',
    'آسیا'                                                        => 142,
    'آسیایمرکزی'                                            => 143,
    'آلبانی'                                                    => 'al',
    'آلمان'                                                      => 'de',
    'آنتیلهلند'                                              => 'an',
    'آنتیگواوباربودا'                                  => 'ag',
    'آندورا'                                                    => 'ad',
    'آنگولا'                                                    => 'ao',
    'آنگیل'                                                      => 'ai',
    'اتحادیهٔاروپا'                                      => 'eu',
    'اتریش'                                                      => 'at',
    'اتیوپی'                                                    => 'et',
    'اردن'                                                        => 'jo',
    'ارمنستان'                                                => 'am',
    'اروپا'                                                      => 150,
    'اروگوئه'                                                  => 'uy',
    'اریتره'                                                    => 'er',
    'ازبکستان'                                                => 'uz',
    'استرالیا'                                                => 'au',
    'استرالیاوزلاندنو'                                => '053',
    'استونی'                                                    => 'ee',
    'اسرائیل'                                                  => 'il',
    'اسلواکی'                                                  => 'sk',
    'اسلوونی'                                                  => 'si',
    'اسوالباردوجان‌ماین'                           => 'sj',
    'اسپانیا'                                                  => 'es',
    'افریقا'                                                    => '002',
    'افریقایجنوبی'                                        => 'za',
    'افغانستان'                                              => 'af',
    'اقیانوسیه'                                              => '009',
    'الجزایر'                                                  => 'dz',
    'السالوادور'                                            => 'sv',
    'اماراتمتحدهٔعربی'                                => 'ae',
    'امریکا'                                                    => '019',
    'امریکایجنوبی'                                        => '005',
    'امریکایشمالی'                                        => '003',
    'امریکایلاتین'                                        => 419,
    'امریکایمرکزی'                                        => '013',
    'اندونزی'                                                  => 'id',
    'اوکراین'                                                  => 'ua',
    'اوگاندا'                                                  => 'ug',
    'اکوادور'                                                  => 'ec',
    'ایالاتمتحدهٔامریکا'                            => 'us',
    'ایتالیا'                                                  => 'it',
    'ایران'                                                      => 'ir',
    'ایرلند'                                                    => 'ie',
    'ایسلند'                                                    => 'is',
    'باربادوس'                                                => 'bb',
    'باهاما'                                                    => 'bs',
    'بحرین'                                                      => 'bh',
    'بخش‌هایدورافتادهٔاقیانوسیه'           => 'qo',
    'برزیل'                                                      => 'br',
    'برمودا'                                                    => 'bm',
    'برونئی'                                                    => 'bn',
    'بریتانیا'                                                => 'gb',
    'بلغارستان'                                              => 'bg',
    'بلژیک'                                                      => 'be',
    'بلیز'                                                        => 'bz',
    'بنگلادش'                                                  => 'bd',
    'بنین'                                                        => 'bj',
    'بوتان'                                                      => 'bt',
    'بوتسوانا'                                                => 'bw',
    'بوروندی'                                                  => 'bi',
    'بورکینافاسو'                                          => 'bf',
    'بوسنیوهرزگوین'                                      => 'ba',
    'بولیوی'                                                    => 'bo',
    'بیلوروسی'                                                => 'by',
    'تاجیکستان'                                              => 'tj',
    'تانزانیا'                                                => 'tz',
    'تایلند'                                                    => 'th',
    'تایوان'                                                    => 'tw',
    'ترکمنستان'                                              => 'tm',
    'ترکیه'                                                      => 'tr',
    'تریستانداکونا'                                      => 'ta',
    'ترینیدادوتوباگو'                                  => 'tt',
    'تونس'                                                        => 'tn',
    'تونگا'                                                      => 'to',
    'تووالو'                                                    => 'tv',
    'توکلائو'                                                  => 'tk',
    'توگو'                                                        => 'tg',
    'تیمورشرقی'                                              => 'tl',
    'جامائیکا'                                                => 'jm',
    'جبل‌الطارق'                                           => 'gi',
    'جرزی'                                                        => 'je',
    'جزایرآسنسیون'                                        => 'ac',
    'جزایرآلاند'                                            => 'ax',
    'جزایرترکوکایکوس'                                  => 'tc',
    'جزایرسلیمان'                                          => 'sb',
    'جزایرفارو'                                              => 'fo',
    'جزایرفالکلندایسلاسمالویناس'            => 'fk',
    'جزایرقناری'                                            => 'ic',
    'جزایرمارشال'                                          => 'mh',
    'جزایرماریانایشمالی'                            => 'mp',
    'جزایرویرجینایالاتمتحده'                    => 'vi',
    'جزایرویرجینبریتانیا'                          => 'vg',
    'جزایرپیت‌کرن'                                       => 'pn',
    'جزایرکلیپرتون'                                      => 'cp',
    'جزایرکوچکدورافتادهٔایالاتمتحده'    => 'um',
    'جزایرکوک'                                                => 'ck',
    'جزایرکوکوسکیلینگ'                                => 'cc',
    'جزایرکِیمن'                                            => 'ky',
    'جزیرهبووت'                                              => 'bv',
    'جزیرهٔمن'                                                => 'im',
    'جزیرهٔنورفولک'                                      => 'nf',
    'جزیرهٔهردوجزایرمک‌دونالد'               => 'hm',
    'جزیرهٔکریسمس'                                        => 'cx',
    'جمهوریآذربایجان'                                  => 'az',
    'جمهوریافریقایمرکزی'                            => 'cf',
    'جمهوریدومینیکن'                                    => 'do',
    'جمهوریچک'                                                => 'cz',
    'جنوبآسیا'                                                => '034',
    'جنوبآسیاوآسیایمیانه'                          => '062',
    'جنوباروپا'                                              => '039',
    'جنوبافریقا'                                            => '018',
    'جنوبشرقیآسیا'                                        => '035',
    'جنوبگان'                                                  => 'aq',
    'جهان'                                                        => '001',
    'جورجیایجنوبیوجزایرساندویچجنوبی'    => 'gs',
    'جیبوتی'                                                    => 'dj',
    'دانمارک'                                                  => 'dk',
    'دومینیک'                                                  => 'dm',
    'دیه‌گوگارسیا'                                       => 'dg',
    'رواندا'                                                    => 'rw',
    'روسیه'                                                      => 'ru',
    'رومانی'                                                    => 'ro',
    'ریونیون'                                                  => 're',
    'زامبیا'                                                    => 'zm',
    'زلاندنو'                                                  => 'nz',
    'زیمبابوه'                                                => 'zw',
    'سائوتومهوپرینسیپه'                              => 'st',
    'ساحلعاج'                                                  => 'ci',
    'ساموا'                                                      => 'ws',
    'ساموایامریکا'                                        => 'as',
    'سان‌مارینو'                                           => 'sm',
    'سبتهوملیله'                                            => 'ea',
    'سرزمین‌هایفلسطینی'                             => 'ps',
    'سری‌لانکا'                                             => 'lk',
    'سنتبارتیلمی'                                          => 'bl',
    'سنتلوسیا'                                                => 'lc',
    'سنتمارتین'                                              => 'mf',
    'سنتهلن'                                                    => 'sh',
    'سنتوینسنتوگرنادین'                              => 'vc',
    'سنتپیرومیکلون'                                      => 'pm',
    'سنتکیتسونویس'                                        => 'kn',
    'سنگال'                                                      => 'sn',
    'سنگاپور'                                                  => 'sg',
    'سوئد'                                                        => 'se',
    'سوئیس'                                                      => 'ch',
    'سوازیلند'                                                => 'sz',
    'سودان'                                                      => 'sd',
    'سورینام'                                                  => 'sr',
    'سوریه'                                                      => 'sy',
    'سومالی'                                                    => 'so',
    'سیرالئون'                                                => 'sl',
    'سیشل'                                                        => 'sc',
    'شرقآسیا'                                                  => '030',
    'شرقاروپا'                                                => 151,
    'شرقافریقا'                                              => '014',
    'شمالاروپا'                                              => 154,
    'شمالافریقا'                                            => '015',
    'شمالامریکا'                                            => '021',
    'شیلی'                                                        => 'cl',
    'صحرایغربی'                                              => 'eh',
    'صربستان'                                                  => 'rs',
    'صربستانومونته‌نگرو'                           => 'cs',
    'عراق'                                                        => 'iq',
    'عربستان'                                                  => 'sa',
    'عمان'                                                        => 'om',
    'غربآسیا'                                                  => 145,
    'غرباروپا'                                                => 155,
    'غربافریقا'                                              => '011',
    'غنا'                                                          => 'gh',
    'فرانسه'                                                    => 'fr',
    'فنلاند'                                                    => 'fi',
    'فیجی'                                                        => 'fj',
    'فیلیپین'                                                  => 'ph',
    'قبرس'                                                        => 'cy',
    'قرقیزستان'                                              => 'kg',
    'قزاقستان'                                                => 'kz',
    'قطر'                                                          => 'qa',
    'لائوس'                                                      => 'la',
    'لبنان'                                                      => 'lb',
    'لتونی'                                                      => 'lv',
    'لسوتو'                                                      => 'ls',
    'لهستان'                                                    => 'pl',
    'لوکزامبورگ'                                            => 'lu',
    'لیبریا'                                                    => 'lr',
    'لیبی'                                                        => 'ly',
    'لیتوانی'                                                  => 'lt',
    'لیختن‌اشتاین'                                       => 'li',
    'ماداگاسکار'                                            => 'mg',
    'مارتینیک'                                                => 'mq',
    'مالاوی'                                                    => 'mw',
    'مالت'                                                        => 'mt',
    'مالدیو'                                                    => 'mv',
    'مالزی'                                                      => 'my',
    'مالی'                                                        => 'ml',
    'ماکائو'                                                    => 'mo',
    'مایوت'                                                      => 'yt',
    'مجارستان'                                                => 'hu',
    'مراکش'                                                      => 'ma',
    'مرکزافریقا'                                            => '017',
    'مستعمره‌هایبریتانیادراقیانوسهند' => 'io',
    'مستعمره‌هایجنوبیفرانسه'                   => 'tf',
    'مصر'                                                          => 'eg',
    'مغولستان'                                                => 'mn',
    'مقدونیهجمهوریسابقاًیوگسلاو'            => 'mk',
    'ملانزی'                                                    => '054',
    'موریتانی'                                                => 'mr',
    'موریس'                                                      => 'mu',
    'موزامبیک'                                                => 'mz',
    'مولداوی'                                                  => 'md',
    'موناکو'                                                    => 'mc',
    'مونته‌نگرو'                                           => 'me',
    'مونت‌سرات'                                             => 'ms',
    'مکزیک'                                                      => 'mx',
    'میانماربرمه'                                          => 'mm',
    'میکرونزی'                                                => 'fm',
    'نائورو'                                                    => 'nr',
    'ناحیهٔمیکرونزی'                                    => '057',
    'ناحیهٔنامشخص'                                        => 'zz',
    'نامیبیا'                                                  => 'na',
    'نروژ'                                                        => 'no',
    'نپال'                                                        => 'np',
    'نیجر'                                                        => 'ne',
    'نیجریه'                                                    => 'ng',
    'نیوئه'                                                      => 'nu',
    'نیکاراگوئه'                                            => 'ni',
    'هائیتی'                                                    => 'ht',
    'هلند'                                                        => 'nl',
    'هند'                                                          => 'in',
    'هندوراس'                                                  => 'hn',
    'هنگ‌کنگ'                                                 => 'hk',
    'واتیکان'                                                  => 'va',
    'والیسوفیوتونا'                                      => 'wf',
    'وانواتو'                                                  => 'vu',
    'ونزوئلا'                                                  => 've',
    'ویتنام'                                                    => 'vn',
    'پاراگوئه'                                                => 'py',
    'پالائو'                                                    => 'pw',
    'پاناما'                                                    => 'pa',
    'پاپواگینهٔنو'                                        => 'pg',
    'پاکستان'                                                  => 'pk',
    'پرتغال'                                                    => 'pt',
    'پرو'                                                          => 'pe',
    'پلی‌نزی'                                                 => '061',
    'پلی‌نزیفرانسه'                                     => 'pf',
    'پورتوریکو'                                              => 'pr',
    'چاد'                                                          => 'td',
    'چین'                                                          => 'cn',
    'ژاپن'                                                        => 'jp',
    'کارائیب'                                                  => '029',
    'کاستاریکا'                                              => 'cr',
    'کالدونیایجدید'                                      => 'nc',
    'کامبوج'                                                    => 'kh',
    'کامرون'                                                    => 'cm',
    'کانادا'                                                    => 'ca',
    'کرهٔجنوبی'                                              => 'kr',
    'کرهٔشمالی'                                              => 'kp',
    'کرواسی'                                                    => 'hr',
    'کریباتی'                                                  => 'ki',
    'کشورهایمستقلمشترک‌المنافع'             => 172,
    'کلمبیا'                                                    => 'co',
    'کنگوجمهوری'                                            => 'cg',
    'کنگوجمهوریدموکراتیک'                          => 'cd',
    'کنیا'                                                        => 'ke',
    'کوبا'                                                        => 'cu',
    'کومورو'                                                    => 'km',
    'کویت'                                                        => 'kw',
    'کیپ‌ورد'                                                 => 'cv',
    'گابون'                                                      => 'ga',
    'گامبیا'                                                    => 'gm',
    'گرانادا'                                                  => 'gd',
    'گرجستان'                                                  => 'ge',
    'گرنزی'                                                      => 'gg',
    'گرینلند'                                                  => 'gl',
    'گواتمالا'                                                => 'gt',
    'گوادلوپ'                                                  => 'gp',
    'گوام'                                                        => 'gu',
    'گویان'                                                      => 'gy',
    'گویانفرانسه'                                          => 'gf',
    'گینه'                                                        => 'gn',
    'گینهٔاستوایی'                                        => 'gq',
    'گینهٔبیسائو'                                          => 'gw',
    'یمن'                                                          => 'ye',
    'یونان'                                                      => 'gr',
);

1;

