#!/usr/bin/perl -w

use Test::More tests => 26;

BEGIN {
	if ($] >= 5.006){
		require Fcntl; Fcntl->import(qw/SEEK_END/);
	} else {
		require POSIX; POSIX->import(qw/SEEK_END/);
	}
}

BEGIN { use_ok("MPEG::Audio::Frame") }

{
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame");
	ok($frame->bitrate, "bitrate");
	ok($frame->sample, "sample rate");
	is(length("$frame"), $frame->length, "actual length");
}
{
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame");
	ok($frame->bitrate, "bitrate");
	ok($frame->sample, "sample rate");
	is(length("$frame"), $frame->length, "actual length");
}

is(MPEG::Audio::Frame->read(*DATA), undef, "no more data on FH");

my $n = 15;
for (0 .. $n){
	seek DATA, -$_, SEEK_END;
	is(MPEG::Audio::Frame->read(*DATA), undef, "nothing $_ bytes before EOF");
}

__DATA__

this is lots of junk, and a few frames in the middle. We're supposed to get
only the frames, and nothing else.


      )3M牫T%{olMQ"yop7X7q{xa-A?&fYQ6@ o($:Po6JC<cYM^]?WT;~eb!a%ߡё:J:}v"D0 .AbPQxaoGPZmH)"*4@qX`  
OV` 
tƜ $U>Z/(Þ MG0C$AB8hA2$)31a,/˕Đvr`H "(B!`б 4d# p<,.b0nEJ!!0`Y)ЬD@}
B( lx:p1R1 $	Qy|t\b~"6&

dgskjhag
?H&N ?H?He"=?
jK??c:#f;+\?o>?5gbqO
P(%1s?????&.A"69O?'l??????y+?a*r.W"?S"PhO?f?P?r.nE|?n\.x
Si*oG@0<N?o|? Y?8	L\?1da8???,?"9 ???,"c0A
??@???x???6Ar????7 ?P??_7?p?0?0?
?D?=1sA%Yh???R??O??A0=A?E$???afbI%EM$??ffkRUUz?U?j[?<L)??}JU?}ko<??ZC#3[G2?.lӠ55TseC4VUo?khY?4u0L<
(F?h"?̰TB??8ӵ?T?4S?S3???C???5Egh????&?.
|p?u-:??[^Rߨ?Mm??e$?MTP
y
:?~]9&oRLP?FP6]A>etMC#=3?LsBphq??\`YF
	?0???sh>!h?BYt?4b?`Y?(nQ?&<

dgkuwj more ʬĩϫgaI(Q-kD1E2	Ht_Dh:iDШ]iDIi x[ƨ̊QYlԐ,}_QuNE(_     %FpaRy7/Tp务YI(F6vaᒧdb.YtS<%S
y7K!lx0T}hgfy)4٩      
