package Acme::CPANModules::Import::CPANRatings::User::davidgaramond;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-10-29'; # DATE
our $DIST = 'Acme-CPANModules-Import-CPANRatings-User-davidgaramond'; # DIST
our $VERSION = '0.002'; # VERSION

our $LIST = {description=>"This list is generated by scraping CPANRatings (cpanratings.perl.org) user page.",entries=>[{description=>"\nOk, it's not 2004 anymore, I suggest we retire or start to deprecate this module? This module now requires Perl 5.8, and Perl 5.10+ has &quot;say&quot; built in, so basically this is a module specifically for 5.8 *only*.\n",module=>"Perl6::Say",rating=>4},{description=>"\nI was looking for a simple way to transform all DateTime objects in my data structure into string (e.g. &quot;2010-07-06&quot;). After failed experiment with Data::Walk and dumping Data::Transformer due to unsightly interface, I found Data::Rmap. It's straightforward to choose.\r<br><br>My only complaint would be the name: it's not immediately searchable (I was searching for 'data modify', 'data walk', 'data traverse', 'modify data inplace', and the like). Also, the name &quot;map&quot; suggests that the function will return a copy of the data (like Perl's builtin map) instead of modifying inplace.\n",module=>"Data::Rmap",rating=>10},{description=>"\nNice interface (the analogy to File::Find certainly helps) and very straightforward to use, but one thing I can't do is modify the data inplace. I spent about an of hours trying to make Data::Walk do inplace modification, but finally gave up and use Data::Rmap instead.\n",module=>"Data::Walk",rating=>8},{description=>"\nFrankly, I don't like the interface. I suspect most people would like to just specify one callback function instead of one for each type. Also I don't like having to work with \$\$_ (\$_ should perhaps be aliased to the real data). As the Data::Transformer's POD also said, those looking for alternatives can checkout Data::Walk and Data::Rmap, which I recommend instead.\r<br>\n\n",module=>"Data::Transformer",rating=>4},{description=>"\nI find the interface rather unintuitive, because I expect data to be in \$_ (instead of type). For those looking for alternatives, see also Data::Walk (which provides breadth-first as well as depth-first) and Data::Rmap (which provides inplace modification).\r<br>\n\n",module=>"Data::Traverse",rating=>4},{description=>"\nParse::RecDescent is dead. Long live Regexp::Grammars!\r<br><br>As Damian himself has said/presented, RG is the successor for the popular PRD.\r<br><br>The docs of RG is not as complete (yet) as PRD's.\r<br><br>The PRD grammar syntax is also nicer/cleaner (due to RG having some restrictions because you are writing your grammar inside a regex).\r<br><br>RG doesn't (yet) have some of the features of PRD, like &lt;leftop&gt; and &lt;rightop&gt;. But it does have most of the features, and add a few of its own.\r<br><br>RG performs significantly faster than PRD.\r<br><br>In general, whenever you consider PRD to be a good candidate of tool to solve your problem, consider using RG.\r<br><br>But you need Perl 5.10+ to use RG, as it depends on regex features not found in older Perl.\r<br>\n\n",module=>"Regexp::Grammars",rating=>8},{description=>"\nResponding to previous comment from MB: &quot;Have you the time to do this Damian?&quot; The answer is yes, in the form of Regexp::Grammars, which Damian said himself is the successor of Parse::RecDescent.\r<br><br>To give credit to this module, PRD is very featureful and easy to use, it's very convenient to generate parsers, and the docs is quite complete. The only problem with it is, as many have pointed out, speed.\r<br><br>It is *seriously* slow, with parser generation can take up to half a second on my laptop with a moderate grammar (200-400 lines) and parsing can take seconds even minutes for a moderately long string. It is orders of magnitude slower than other parsers. Do think a few times before deciding you can take the performance hit of PRD.\r<br><br>For alternatives, try Regexp::Grammars. (Or Parse::Yapp or Parse::EYapp, as other reviewers have written.)\n",module=>"Parse::RecDescent",rating=>6},{description=>"\nSorry, just commenting the name, shouldn't it be Separate?\n",module=>"Test::Seperate",rating=>undef},{description=>"\nFrankly I prefer the name and interface of Filesys::DiskUsage. Sadly, despite the docs mentioning &quot;blocks&quot;, this module doesn't really count block usage like the Unix &quot;du&quot; command, because it doesn't take multiple hard links into account.\r<br><br>Even more sadly, Filesys::DiskUsage doesn't either.\r<br><br>I guess I'll have to do with 'system &quot;du \$file&quot;' command for now.\r<br>\n\n",module=>"File::Size",rating=>4},{description=>"\n*THE* definitive date/time handling module in Perl (and even maybe in all major programming languages). Can't believe I went through all the pain of reinventing the wheel, and using various date/time modules of various quality &amp; interface. If only I had known DateTime earlier.\r<br><br>Look no more, DateTime it is.\r<br>\n\n",module=>"DateTime",rating=>10},{description=>"\nI've been mulling over writing this kind of module (planning to call it Schema::Nested or something), but never got around to do it. Thankfully somebody stepped up and did it! Keep up the good work, will be looking forward to future releases (especially i'm hoping for some subclassing mechanism, for better reuse of schemas).\r<br>\n\n",module=>"Data::Rx",rating=>10},{description=>"\nI agree with the previous reviewer. IMO, overall this module is not necessary. Plain DBI is actually simple enough for simple cases. Maybe the author of Mysqlsimple did not realize this. Let's compare:\r<br><br>* Retrieving a single row:\r<br>\nMysqlsimple: my (\$v1,\$v2) = \$db-&gt;get_row(&quot;select v1,v2 from table&quot;);\r<br>\nDBI: my (\$v1, \$v2) = \$dbh-&gt;selectrow_array(&quot;select v1,v2 from table&quot;);\r<br><br>* Retrieving a single row (with params):\r<br>\nMysqlsimple: my (\$v1,\$v2) = \$db-&gt;get_row(&quot;select v1,v2 from table where cond1=? and cond2=?&quot;, [\$cond1,\$cond2]);\r<br>\nDBI: my (\$v1,\$v2) = \$db-&gt;selectrow_array(&quot;select v1,v2 from table where cond1=? and cond2=?&quot;, {}, \$cond1,\$cond2);\r<br><br>* Retrieving all rows with params:\r<br>\nMysqlsimple: my \$rows = \$db-&gt;get_rows(..., [\$param1, \$param2]);\r<br>\nDBI: my \$rows = \$dbh-&gt;selectall_arrayref(..., {}, \$param1, \$param2);\r<br><br>* do() with params:\r<br>\nMysqlsimple: my \$rows = \$db-&gt;do(..., [\$param1, \$param2]);\r<br>\nDBI: my \$rows = \$dbh-&gt;do(..., {}, \$param1, \$param2);\r<br><br>As you can see, the differences are minimal.\r<br>\n\n",module=>"DBI::Mysqlsimple",rating=>2},{description=>"\nModules like this deserve to be more well-known and should perhaps included in core Perl (or even become a command-line switch). I'm never comfortable with Carp and all the &quot;complexity&quot; of using it. What I wanted is simple, when debugging I want all die()'s (and perhaps warn() too, but much less often) to print a stack trace.\r<br><br>Call me inflicted with Ruby- or Python-envy, but it's been so ridiculous wanting to print out stack traces in Perl. I don't want to have to change/rewrite all my die()'s to croak() or confess()! And what about library codes which use die()?\r<br><br>Thank God somebody wrote Carp::Always.\n",module=>"Carp::Always",rating=>10},{description=>"\nI've envied Ruby users which can use just &quot;p&quot; to print out data structures instead of us which used to have to do 'use Data::Dumper; print Dumper(...);'. And even then there's this '\$VAR1 = ' garbage which 99% of the time is not wanted. Which often makes me wonder, shouldn't P in Perl stand for Practical?\r<br><br>With Data::Dump we're still a bit behind but closer. One rant is the with the doc: the pp() function should perhaps be advertised more prominently, since I suspect that's what most users want most of the time.\n",module=>"Data::Dump",rating=>10},{description=>"\nWhat a nice little module. It is by far the easiest to review ;-)\r<br><br>I have been using my own little script called &quot;pmversion&quot; which serves the same exact purpose. I guess I'll be using V from this moment on. It's amazing doing something as basic as showing a module's version had not been this easy or even easier.\r<br>\n\n",module=>"V",rating=>10},{description=>"\nTest::Unit is of course a fine module. But if you are shopping around for testing framework, I recommend you try Test::Class instead, which combines the best of two worlds. First, you get xUnit style, but I think with a slightly simpler interface. Second, you get to use all the standard Perl testing stuffs like Test::Simple, Test::More and Test::Harness. This is better because it's what most Perl modules use (so you might be more familiar with it if you're a Perl programmer), plus there are more kinds of &quot;assert&quot; functions in Test::More and friends compared to Test::Unit::Assert.\n",module=>"Test::Unit",rating=>8},{description=>"\nHere's the short story: first there's Exutils::MakeMaker, which requires make and hard to extend, but everybody uses it due to lack of alternatives. Then came Module::Build which is pure perl and easier to use for authors, but breaks compatibility. Users can no longer use the 'perl Makefile.PL &amp;&amp; make &amp;&amp; make install' mantra. Plus, it used to not support PREFIX. Plus, MB-based modules require MB which is not by default installed. This pisses *a lot* of people.\r<br><br>Lesson to learn: maintaining backward-compatibility is very important, especially for end users. I think the intention of MB is a good one, but the execution could be a bit better. For example, perhaps the &quot;Build.PL&quot; script could've still just been named &quot;Makefile.PL&quot;, couldn't it?\r<br><br>I recommend people shopping for a module installer to look at Module::Install instead. MI is a middle ground between Eu::MM and MB. It's pure perl and easy to extend but it also allows users (and CPAN.pm et al) to install modules the old way. It embeds a copy of itself in every MI-based modules, so there's no depedency hell. Best of both worlds.\n",module=>"Module::Build",rating=>6},{description=>"\nIt's about time Perl gets a complete and proper YAML parser. This is it. In the past I've been bitten by a couple of YAML's and YAML::Syck's minor bugs, in addition to several crashes (don't know how they are recently). But using YAML::XS (YAML-LibYAML) I get the feeling, for the first time, of a first class parser comparable in stability and completeness to that in Ruby and Python.\n",module=>"YAML::LibYAML",rating=>10}],summary=>"List of modules mentioned by CPANRatings user davidgaramond"};

1;
# ABSTRACT: List of modules mentioned by CPANRatings user davidgaramond

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANModules::Import::CPANRatings::User::davidgaramond - List of modules mentioned by CPANRatings user davidgaramond

=head1 VERSION

This document describes version 0.002 of Acme::CPANModules::Import::CPANRatings::User::davidgaramond (from Perl distribution Acme-CPANModules-Import-CPANRatings-User-davidgaramond), released on 2023-10-29.

=head1 DESCRIPTION

This list is generated by scraping CPANRatings (cpanratings.perl.org) user page.

This list is generated by scraping CPANRatings (cpanratings.perl.org) user page.

=head1 ACME::CPANMODULES ENTRIES

=over

=item L<Perl6::Say>

Author: L<CHORNY|https://metacpan.org/author/CHORNY>

Ok, it's not 2004 anymore, I suggest we retire or start to deprecate this module? This module now requires Perl 5.8, and Perl 5.10+ has &quot;say&quot; built in, so basically this is a module specifically for 5.8 I<only>.


Rating: 4/10

=item L<Data::Rmap>

Author: L<BOWMANBS|https://metacpan.org/author/BOWMANBS>

I was looking for a simple way to transform all DateTime objects in my data structure into string (e.g. &quot;2010-07-06&quot;). After failed experiment with Data::Walk and dumping Data::Transformer due to unsightly interface, I found Data::Rmap. It's straightforward to choose.
<br><br>My only complaint would be the name: it's not immediately searchable (I was searching for 'data modify', 'data walk', 'data traverse', 'modify data inplace', and the like). Also, the name &quot;map&quot; suggests that the function will return a copy of the data (like Perl's builtin map) instead of modifying inplace.


=item L<Data::Walk>

Author: L<GUIDO|https://metacpan.org/author/GUIDO>

Nice interface (the analogy to File::Find certainly helps) and very straightforward to use, but one thing I can't do is modify the data inplace. I spent about an of hours trying to make Data::Walk do inplace modification, but finally gave up and use Data::Rmap instead.


Rating: 8/10

=item L<Data::Transformer>

Author: L<BALDUR|https://metacpan.org/author/BALDUR>

Frankly, I don't like the interface. I suspect most people would like to just specify one callback function instead of one for each type. Also I don't like having to work with $$_ ($_ should perhaps be aliased to the real data). As the Data::Transformer's POD also said, those looking for alternatives can checkout Data::Walk and Data::Rmap, which I recommend instead.
<br>


Rating: 4/10

=item L<Data::Traverse>

Author: L<FRIEDO|https://metacpan.org/author/FRIEDO>

I find the interface rather unintuitive, because I expect data to be in $_ (instead of type). For those looking for alternatives, see also Data::Walk (which provides breadth-first as well as depth-first) and Data::Rmap (which provides inplace modification).
<br>


Rating: 4/10

=item L<Regexp::Grammars>

Author: L<DCONWAY|https://metacpan.org/author/DCONWAY>

Parse::RecDescent is dead. Long live Regexp::Grammars!
<br><br>As Damian himself has said/presented, RG is the successor for the popular PRD.
<br><br>The docs of RG is not as complete (yet) as PRD's.
<br><br>The PRD grammar syntax is also nicer/cleaner (due to RG having some restrictions because you are writing your grammar inside a regex).
<br><br>RG doesn't (yet) have some of the features of PRD, like &lt;leftop&gt; and &lt;rightop&gt;. But it does have most of the features, and add a few of its own.
<br><br>RG performs significantly faster than PRD.
<br><br>In general, whenever you consider PRD to be a good candidate of tool to solve your problem, consider using RG.
<br><br>But you need Perl 5.10+ to use RG, as it depends on regex features not found in older Perl.
<br>


Rating: 8/10

=item L<Parse::RecDescent>

Author: L<JTBRAUN|https://metacpan.org/author/JTBRAUN>

Responding to previous comment from MB: &quot;Have you the time to do this Damian?&quot; The answer is yes, in the form of Regexp::Grammars, which Damian said himself is the successor of Parse::RecDescent.
<br><br>To give credit to this module, PRD is very featureful and easy to use, it's very convenient to generate parsers, and the docs is quite complete. The only problem with it is, as many have pointed out, speed.
<br><br>It is I<seriously> slow, with parser generation can take up to half a second on my laptop with a moderate grammar (200-400 lines) and parsing can take seconds even minutes for a moderately long string. It is orders of magnitude slower than other parsers. Do think a few times before deciding you can take the performance hit of PRD.
<br><br>For alternatives, try Regexp::Grammars. (Or Parse::Yapp or Parse::EYapp, as other reviewers have written.)


Rating: 6/10

=item L<Test::Seperate>

Sorry, just commenting the name, shouldn't it be Separate?


=item L<File::Size>

Author: L<OFER|https://metacpan.org/author/OFER>

Frankly I prefer the name and interface of Filesys::DiskUsage. Sadly, despite the docs mentioning &quot;blocks&quot;, this module doesn't really count block usage like the Unix &quot;du&quot; command, because it doesn't take multiple hard links into account.
<br><br>Even more sadly, Filesys::DiskUsage doesn't either.
<br><br>I guess I'll have to do with 'system &quot;du $file&quot;' command for now.
<br>


Rating: 4/10

=item L<DateTime>

Author: L<DROLSKY|https://metacpan.org/author/DROLSKY>

I<THE> definitive date/time handling module in Perl (and even maybe in all major programming languages). Can't believe I went through all the pain of reinventing the wheel, and using various date/time modules of various quality &amp; interface. If only I had known DateTime earlier.
<br><br>Look no more, DateTime it is.
<br>


=item L<Data::Rx>

Author: L<RJBS|https://metacpan.org/author/RJBS>

I've been mulling over writing this kind of module (planning to call it Schema::Nested or something), but never got around to do it. Thankfully somebody stepped up and did it! Keep up the good work, will be looking forward to future releases (especially i'm hoping for some subclassing mechanism, for better reuse of schemas).
<br>


=item L<DBI::Mysqlsimple>

I agree with the previous reviewer. IMO, overall this module is not necessary. Plain DBI is actually simple enough for simple cases. Maybe the author of Mysqlsimple did not realize this. Let's compare:
<br><br>* Retrieving a single row:
<br>
Mysqlsimple: my ($v1,$v2) = $db-&gt;get_row(&quot;select v1,v2 from table&quot;);
<br>
DBI: my ($v1, $v2) = $dbh-&gt;selectrow_array(&quot;select v1,v2 from table&quot;);
<br><br>* Retrieving a single row (with params):
<br>
Mysqlsimple: my ($v1,$v2) = $db-&gt;get_row(&quot;select v1,v2 from table where cond1=? and cond2=?&quot;, [$cond1,$cond2]);
<br>
DBI: my ($v1,$v2) = $db-&gt;selectrow_array(&quot;select v1,v2 from table where cond1=? and cond2=?&quot;, {}, $cond1,$cond2);
<br><br>* Retrieving all rows with params:
<br>
Mysqlsimple: my $rows = $db-&gt;get_rows(..., [$param1, $param2]);
<br>
DBI: my $rows = $dbh-&gt;selectall_arrayref(..., {}, $param1, $param2);
<br><br>* do() with params:
<br>
Mysqlsimple: my $rows = $db-&gt;do(..., [$param1, $param2]);
<br>
DBI: my $rows = $dbh-&gt;do(..., {}, $param1, $param2);
<br><br>As you can see, the differences are minimal.
<br>


Rating: 2/10

=item L<Carp::Always>

Author: L<FERREIRA|https://metacpan.org/author/FERREIRA>

Modules like this deserve to be more well-known and should perhaps included in core Perl (or even become a command-line switch). I'm never comfortable with Carp and all the &quot;complexity&quot; of using it. What I wanted is simple, when debugging I want all die()'s (and perhaps warn() too, but much less often) to print a stack trace.
<br><br>Call me inflicted with Ruby- or Python-envy, but it's been so ridiculous wanting to print out stack traces in Perl. I don't want to have to change/rewrite all my die()'s to croak() or confess()! And what about library codes which use die()?
<br><br>Thank God somebody wrote Carp::Always.


=item L<Data::Dump>

Author: L<GARU|https://metacpan.org/author/GARU>

I've envied Ruby users which can use just &quot;p&quot; to print out data structures instead of us which used to have to do 'use Data::Dumper; print Dumper(...);'. And even then there's this '$VAR1 = ' garbage which 99% of the time is not wanted. Which often makes me wonder, shouldn't P in Perl stand for Practical?
<br><br>With Data::Dump we're still a bit behind but closer. One rant is the with the doc: the pp() function should perhaps be advertised more prominently, since I suspect that's what most users want most of the time.


=item L<V>

Author: L<ABELTJE|https://metacpan.org/author/ABELTJE>

What a nice little module. It is by far the easiest to review ;-)
<br><br>I have been using my own little script called &quot;pmversion&quot; which serves the same exact purpose. I guess I'll be using V from this moment on. It's amazing doing something as basic as showing a module's version had not been this easy or even easier.
<br>


=item L<Test::Unit>

Author: L<MCAST|https://metacpan.org/author/MCAST>

Test::Unit is of course a fine module. But if you are shopping around for testing framework, I recommend you try Test::Class instead, which combines the best of two worlds. First, you get xUnit style, but I think with a slightly simpler interface. Second, you get to use all the standard Perl testing stuffs like Test::Simple, Test::More and Test::Harness. This is better because it's what most Perl modules use (so you might be more familiar with it if you're a Perl programmer), plus there are more kinds of &quot;assert&quot; functions in Test::More and friends compared to Test::Unit::Assert.


Rating: 8/10

=item L<Module::Build>

Author: L<LEONT|https://metacpan.org/author/LEONT>

Here's the short story: first there's Exutils::MakeMaker, which requires make and hard to extend, but everybody uses it due to lack of alternatives. Then came Module::Build which is pure perl and easier to use for authors, but breaks compatibility. Users can no longer use the 'perl Makefile.PL &amp;&amp; make &amp;&amp; make install' mantra. Plus, it used to not support PREFIX. Plus, MB-based modules require MB which is not by default installed. This pisses I<a lot> of people.
<br><br>Lesson to learn: maintaining backward-compatibility is very important, especially for end users. I think the intention of MB is a good one, but the execution could be a bit better. For example, perhaps the &quot;Build.PL&quot; script could've still just been named &quot;Makefile.PL&quot;, couldn't it?
<br><br>I recommend people shopping for a module installer to look at Module::Install instead. MI is a middle ground between Eu::MM and MB. It's pure perl and easy to extend but it also allows users (and CPAN.pm et al) to install modules the old way. It embeds a copy of itself in every MI-based modules, so there's no depedency hell. Best of both worlds.


Rating: 6/10

=item L<YAML::LibYAML>

Author: L<INGY|https://metacpan.org/author/INGY>

It's about time Perl gets a complete and proper YAML parser. This is it. In the past I've been bitten by a couple of YAML's and YAML::Syck's minor bugs, in addition to several crashes (don't know how they are recently). But using YAML::XS (YAML-LibYAML) I get the feeling, for the first time, of a first class parser comparable in stability and completeness to that in Ruby and Python.


=back

=head1 FAQ

=head2 What is an Acme::CPANModules::* module?

An Acme::CPANModules::* module, like this module, contains just a list of module
names that share a common characteristics. It is a way to categorize modules and
document CPAN. See L<Acme::CPANModules> for more details.

=head2 What are ways to use this Acme::CPANModules module?

Aside from reading this Acme::CPANModules module's POD documentation, you can
install all the listed modules (entries) using L<cpanm-cpanmodules> script (from
L<App::cpanm::cpanmodules> distribution):

 % cpanm-cpanmodules -n Import::CPANRatings::User::davidgaramond

Alternatively you can use the L<cpanmodules> CLI (from L<App::cpanmodules>
distribution):

    % cpanmodules ls-entries Import::CPANRatings::User::davidgaramond | cpanm -n

or L<Acme::CM::Get>:

    % perl -MAcme::CM::Get=Import::CPANRatings::User::davidgaramond -E'say $_->{module} for @{ $LIST->{entries} }' | cpanm -n

or directly:

    % perl -MAcme::CPANModules::Import::CPANRatings::User::davidgaramond -E'say $_->{module} for @{ $Acme::CPANModules::Import::CPANRatings::User::davidgaramond::LIST->{entries} }' | cpanm -n

This Acme::CPANModules module also helps L<lcpan> produce a more meaningful
result for C<lcpan related-mods> command when it comes to finding related
modules for the modules listed in this Acme::CPANModules module.
See L<App::lcpan::Cmd::related_mods> for more details on how "related modules"
are found.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANModules-Import-CPANRatings-User-davidgaramond>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANModules-Import-CPANRatings-User-davidgaramond>.

=head1 SEE ALSO

L<Acme::CPANModules> - about the Acme::CPANModules namespace

L<cpanmodules> - CLI tool to let you browse/view the lists

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTOR

=for stopwords Steven Haryanto

Steven Haryanto <stevenharyanto@gmail.com>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANModules-Import-CPANRatings-User-davidgaramond>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
