package Digest::xxHash64;

use 5.008;
use strict;
use warnings;

use Exporter qw( import );

our %EXPORT_TAGS = ();
our @EXPORT_OK = qw( xxhash32 xxhash64 xxhash32_hex xxhash64_hex );
our @EXPORT = qw( );

our $VERSION = our $XS_VERSION = '0.001_01';
$VERSION = eval $VERSION;

use XSLoader;
XSLoader::load('Digest::xxHash64', $XS_VERSION);

__PACKAGE__;
__END__
=head1 NAME

Digest::xxHash64 - Calculate both 32 and 64-bit xxHash values from Perl

=head1 SYNOPSIS

    use Digest::xxHash64 qw(xxhash32 xxhash32_hex xxhash64 xxhash64_hex);

    my $content = join '', 'a' .. 'z';

    my $hash32     = xxhash32( $content, 0 );
    my $hex32      = xxhash32_hex( $content, 0 );
    my $hash64     = xxhash64( $content, 0 );
    my $hex64      = xxhash64_hex( $content, 0 );

=head1 DESCRIPTION

xxHash is an Extremely fast Hash algorithm, running at RAM speed limits. It successfully completes the SMHasher test suite which evaluates collision, dispersion and randomness qualities of hash functions. See the L<official repository|https://github.com/Cyan4973/xxHash> for more information.

=head1 FUNCTION INTERFACE

Nothing is exported by default.

=over 4

=item C<xxhash32($input, $seed)>

Returns the 32-bit hash of C<$input> using 32-bit seed C<$seed>.

=item xxhash32_hex

Returns an 8-digit hexadecimal string containing the 32-bit hash in network (big endian) order. This is what the command line utility C<xxh32sum> reports.

=item xxhash64

Returns the 64-bit hash of C<$input> using 64-bit seed C<$seed>.

Currently, if your Perl doesn't natively support 64-bit integers, this is not going to be accurate. You should still be able to use C<xxhash64_hex>. However, I have not tested this.

=item xxhash64_hex

Returns a 16-digit hexadecimal string containing the 64-bit hash in network (big endian) order. This is what the command line utility C<xxh64sum> reports.

=back

=head1 SEE ALSO

=over 4

=item L<xxHash|https://github.com/Cyan4973/xxHash>

=item L<Digest::xxHash|https://metacpan.org/pod/Digest::xxHash>

=back

=head1 AUTHOR

A. Sinan Unur E<lt>nanis@cpan.orgE<gt>

=head1 COPYRIGHT

Copyright (C) 2015 by A. Sinan Unur

=head1 LICENSE

The MIT License

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated
documentation files (the "Software"), to deal in the Software
without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to
whom the Software is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall
be included in all copies or substantial portions of the
Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT
WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT
SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

