# Generated by default/object.tt
package Paws::SageMaker::MultiModelConfig;
  use Moose;
  has ModelCacheSetting => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::MultiModelConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::MultiModelConfig object:

  $service_obj->Method(Att1 => { ModelCacheSetting => $value, ..., ModelCacheSetting => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::MultiModelConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ModelCacheSetting

=head1 DESCRIPTION

Specifies additional configuration for hosting multi-model endpoints.

=head1 ATTRIBUTES


=head2 ModelCacheSetting => Str

Whether to cache models for a multi-model endpoint. By default,
multi-model endpoints cache models so that a model does not have to be
loaded into memory each time it is invoked. Some use cases do not
benefit from model caching. For example, if an endpoint hosts a large
number of models that are each invoked infrequently, the endpoint might
perform better if you disable model caching. To disable model caching,
set the value of this parameter to C<Disabled>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

