# Generated by default/object.tt
package Paws::LocationService::CalculateRouteTruckModeOptions;
  use Moose;
  has AvoidFerries => (is => 'ro', isa => 'Bool');
  has AvoidTolls => (is => 'ro', isa => 'Bool');
  has Dimensions => (is => 'ro', isa => 'Paws::LocationService::TruckDimensions');
  has Weight => (is => 'ro', isa => 'Paws::LocationService::TruckWeight');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LocationService::CalculateRouteTruckModeOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LocationService::CalculateRouteTruckModeOptions object:

  $service_obj->Method(Att1 => { AvoidFerries => $value, ..., Weight => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LocationService::CalculateRouteTruckModeOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->AvoidFerries

=head1 DESCRIPTION

Contains details about additional route preferences for requests that
specify C<TravelMode> as C<Truck>.

=head1 ATTRIBUTES


=head2 AvoidFerries => Bool

Avoids ferries when calculating routes.

Default Value: C<false>

Valid Values: C<false> | C<true>


=head2 AvoidTolls => Bool

Avoids ferries when calculating routes.

Default Value: C<false>

Valid Values: C<false> | C<true>


=head2 Dimensions => L<Paws::LocationService::TruckDimensions>

Specifies the truck's dimension specifications including length,
height, width, and unit of measurement. Used to avoid roads that can't
support the truck's dimensions.


=head2 Weight => L<Paws::LocationService::TruckWeight>

Specifies the truck's weight specifications including total weight and
unit of measurement. Used to avoid roads that can't support the truck's
weight.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LocationService>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

