use strict;
use warnings;

use Test::More tests => 34;
use Data::Dumper;

use_ok 'Rex';
use_ok 'Rex::Commands::Iptables';

my @iptables_list_1 = (
  "# Generated by iptables-save v1.4.12 on Fri Nov 16 22:20:13 2012",
  "*nat",
  ":PREROUTING ACCEPT [831648:47063372]",
  ":INPUT ACCEPT [71162:4082850]",
  ":OUTPUT ACCEPT [159345:9708626]",
  ":POSTROUTING ACCEPT [263463:17336449]",
  "-A PREROUTING -d 1.2.3.4/32 -p tcp -m tcp --dport 25 -j DNAT --to-destination 4.3.2.1:25",
  "COMMIT",
  "*foo",
  "-A syn_flood -p tcp -m tcp --tcp-flags FIN,SYN,RST,ACK SYN -m limit --limit 25/sec --limit-burst 50 -j RETURN",
);

my $rules = Rex::Commands::Iptables::_iptables_list(@iptables_list_1);

ok( exists $rules->{nat}, "found nat tables" );
is( $rules->{nat}->[0]->[0],  "A",          "first is append" );
is( $rules->{nat}->[0]->[1],  "PREROUTING", "append to prerouting" );
is( $rules->{nat}->[0]->[2],  "d",          "should be destination" );
is( $rules->{nat}->[0]->[3],  "1.2.3.4/32", "to destination 1.2.3.4" );
is( $rules->{nat}->[0]->[4],  "p",          "should be proto" );
is( $rules->{nat}->[0]->[5],  "tcp",        "tcp" );
is( $rules->{nat}->[0]->[6],  "m",          "in module" );
is( $rules->{nat}->[0]->[7],  "tcp",        "tcp" );
is( $rules->{nat}->[0]->[8],  "dport",      "should be destination port" );
is( $rules->{nat}->[0]->[9],  "25",         "dport 25" );
is( $rules->{nat}->[0]->[10], "j",          "jump to" );
is( $rules->{nat}->[0]->[11], "DNAT",       "dnating" );
is( $rules->{nat}->[0]->[12],
  "to-destination", "should be forwarded to destination" );
is( $rules->{nat}->[0]->[13], "4.3.2.1:25", "4.3.2.1:25" );

ok( exists $rules->{foo}, "found foo table" );
is( $rules->{foo}->[0]->[0],  "A",                   "frist is append" );
is( $rules->{foo}->[0]->[1],  "syn_flood",           "append to sys_flood" );
is( $rules->{foo}->[0]->[2],  "p",                   "should use protocol" );
is( $rules->{foo}->[0]->[3],  "tcp",                 "proto tcp" );
is( $rules->{foo}->[0]->[4],  "m",                   "in module" );
is( $rules->{foo}->[0]->[5],  "tcp",                 "tcp module" );
is( $rules->{foo}->[0]->[6],  "tcp-flags",           "should match tcp flags" );
is( $rules->{foo}->[0]->[7],  "FIN,SYN,RST,ACK SYN", "only these flags" );
is( $rules->{foo}->[0]->[8],  "m",                   "should use module" );
is( $rules->{foo}->[0]->[9],  "limit",               "limit module" );
is( $rules->{foo}->[0]->[10], "limit",               "limit the bandwidth" );
is( $rules->{foo}->[0]->[11], "25/sec",              "to 25 req per second" );
is( $rules->{foo}->[0]->[12], "limit-burst",         "use burst" );
is( $rules->{foo}->[0]->[13], "50",                  "up to 50" );
is( $rules->{foo}->[0]->[14], "j",                   "jump to" );
is( $rules->{foo}->[0]->[15], "RETURN",              "RETURN" );

