/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyAttributeCollection;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyTreeWalker
implements PullProvider,
Location {
    private int startNode;
    private int currentNode;
    private int currentEvent;
    private TinyTree tree;
    private int[] treeNameCodes;
    private short[] treeDepth;
    private SchemaType[] treeTypes;
    private int[] treeNext;
    private int[] treeAlpha;
    private PipelineConfiguration pipe;
    private NamespaceBinding[] nsBuffer = new NamespaceBinding[10];

    public TinyTreeWalker(TinyNodeImpl startNode) {
        int kind = startNode.getNodeKind();
        if (kind == 2 || kind == 13) {
            throw new IllegalArgumentException("TinyTreeWalker cannot start at an attribute or namespace node");
        }
        this.startNode = startNode.getNodeNumber();
        this.tree = startNode.getTree();
        this.treeNameCodes = this.tree.getNameCodeArray();
        this.treeNext = this.tree.getNextPointerArray();
        this.treeDepth = this.tree.getNodeDepthArray();
        this.treeTypes = this.tree.getTypeArray();
        this.treeAlpha = this.tree.getAlphaArray();
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public int next() throws XPathException {
        switch (this.currentEvent) {
            case 0: {
                this.currentNode = this.startNode;
                switch (this.tree.nodeKind[this.currentNode]) {
                    case 9: {
                        this.currentEvent = 2;
                        break;
                    }
                    case 1: {
                        this.currentEvent = 4;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.currentEvent = 8;
                        break;
                    }
                    case 8: {
                        this.currentEvent = 9;
                        break;
                    }
                    case 7: {
                        this.currentEvent = 10;
                        break;
                    }
                    case 12: {
                        throw new IllegalStateException("Current node is a parent-pointer pseudo-node");
                    }
                }
                return this.currentEvent;
            }
            case 2: 
            case 4: {
                if (this.treeDepth[this.currentNode + 1] > this.treeDepth[this.currentNode]) {
                    switch (this.tree.nodeKind[++this.currentNode]) {
                        case 1: {
                            this.currentEvent = 4;
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.currentEvent = 8;
                            break;
                        }
                        case 8: {
                            this.currentEvent = 9;
                            break;
                        }
                        case 7: {
                            this.currentEvent = 10;
                            break;
                        }
                        case 12: {
                            throw new IllegalStateException("First child node must not be a parent-pointer pseudo-node");
                        }
                    }
                    return this.currentEvent;
                }
                this.currentEvent = this.currentEvent == 2 ? 3 : 5;
                return this.currentEvent;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                if (this.currentNode == this.startNode) {
                    this.currentEvent = -1;
                    return this.currentEvent;
                }
                int next = this.treeNext[this.currentNode];
                if (next > this.currentNode) {
                    this.currentNode = this.treeNext[this.currentNode];
                    do {
                        switch (this.tree.nodeKind[this.currentNode]) {
                            case 1: {
                                this.currentEvent = 4;
                                break;
                            }
                            case 3: 
                            case 4: {
                                this.currentEvent = 8;
                                break;
                            }
                            case 8: {
                                this.currentEvent = 9;
                                break;
                            }
                            case 7: {
                                this.currentEvent = 10;
                                break;
                            }
                            case 12: {
                                this.currentEvent = -1;
                                ++this.currentNode;
                            }
                        }
                    } while (this.currentEvent == -1);
                    return this.currentEvent;
                }
                this.currentNode = next;
                if (this.currentNode == -1) {
                    this.currentEvent = -1;
                    return this.currentEvent;
                }
                switch (this.tree.nodeKind[this.currentNode]) {
                    case 1: {
                        this.currentEvent = 5;
                        break;
                    }
                    case 9: {
                        this.currentEvent = 3;
                    }
                }
                return this.currentEvent;
            }
            case 3: 
            case 6: 
            case 7: {
                this.currentEvent = -1;
                return this.currentEvent;
            }
            case -1: {
                throw new IllegalStateException("Cannot call next() when input is exhausted");
            }
        }
        throw new IllegalStateException("Unrecognized event " + this.currentEvent);
    }

    public int current() {
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() throws XPathException {
        if (this.tree.nodeKind[this.currentNode] == 1) {
            if (this.treeAlpha[this.currentNode] == -1) {
                return AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION;
            }
            return new TinyAttributeCollection(this.tree, this.currentNode);
        }
        throw new IllegalStateException("getAttributes() called when current event is not ELEMENT_START");
    }

    public NamespaceBinding[] getNamespaceDeclarations() throws XPathException {
        if (this.tree.nodeKind[this.currentNode] == 1) {
            if (this.currentNode == this.startNode) {
                ArrayList list = new ArrayList();
                Iterator iter = NamespaceIterator.iterateNamespaces((NodeInfo)this.tree.getNode(this.currentNode));
                while (iter.hasNext()) {
                    list.add(iter.next());
                }
                return list.toArray(new NamespaceBinding[list.size()]);
            }
            return TinyElementImpl.getDeclaredNamespaces((TinyTree)this.tree, (int)this.currentNode, (NamespaceBinding[])this.nsBuffer);
        }
        throw new IllegalStateException("getNamespaceDeclarations() called when current event is not START_ELEMENT");
    }

    public int skipToMatchingEnd() throws XPathException {
        switch (this.currentEvent) {
            case 2: {
                this.currentEvent = 3;
                return this.currentEvent;
            }
            case 4: {
                this.currentEvent = 5;
                return this.currentEvent;
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    public void close() {
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public NodeName getNodeName() {
        switch (this.currentEvent) {
            case 4: 
            case 5: 
            case 10: {
                return new CodedName(this.treeNameCodes[this.currentNode], "", this.getNamePool());
            }
        }
        throw new IllegalStateException("getNodeName() called when its value is undefined");
    }

    public CharSequence getStringValue() throws XPathException {
        switch (this.tree.nodeKind[this.currentNode]) {
            case 3: {
                return TinyTextImpl.getStringValue((TinyTree)this.tree, (int)this.currentNode);
            }
            case 4: {
                return WhitespaceTextImpl.getStringValueCS((TinyTree)this.tree, (int)this.currentNode);
            }
            case 7: 
            case 8: {
                return this.tree.getNode(this.currentNode).getStringValue();
            }
            case 1: {
                this.currentEvent = 5;
                return TinyParentNodeImpl.getStringValueCS((TinyTree)this.tree, (int)this.currentNode);
            }
            case 12: {
                throw new IllegalStateException("Trying to get string value of a parent-pointer pseudo node");
            }
        }
        return null;
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public SchemaType getSchemaType() {
        if (this.tree.nodeKind[this.currentNode] != 1) {
            throw new IllegalStateException("getTypeAnnotation() called when current event is not ELEMENT_START or ");
        }
        if (this.treeTypes == null) {
            return Untyped.getInstance();
        }
        return this.treeTypes[this.currentNode];
    }

    public Location getSourceLocator() {
        return this;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.tree.getSystemId(this.currentNode);
    }

    public int getLineNumber() {
        return this.tree.getLineNumber(this.currentNode);
    }

    public int getColumnNumber() {
        return -1;
    }

    public Location saveLocation() {
        return new ExplicitLocation(this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
    }

    public List<UnparsedEntity> getUnparsedEntities() {
        return null;
    }
}

