/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.tika.server.ServerStatus;
import org.apache.tika.server.ServerTimeouts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaServerWatchDog {
    private static final Logger LOG = LoggerFactory.getLogger(TikaServerWatchDog.class);
    private Object[] childStatusLock = new Object[0];
    private volatile CHILD_STATUS childStatus = CHILD_STATUS.INITIALIZING;
    private volatile Instant lastPing = null;
    private ChildProcess childProcess = null;
    int restarts = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] args, final ServerTimeouts serverTimeouts) throws Exception {
        Thread pingTimer = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    long elapsed;
                    long tmpLastPing = -1L;
                    Object[] objectArray = TikaServerWatchDog.this.childStatusLock;
                    synchronized (objectArray) {
                        if (TikaServerWatchDog.this.childStatus == CHILD_STATUS.RUNNING) {
                            tmpLastPing = TikaServerWatchDog.this.lastPing.toEpochMilli();
                        }
                    }
                    if (tmpLastPing > 0L && (elapsed = Duration.between(Instant.ofEpochMilli(tmpLastPing), Instant.now()).toMillis()) > serverTimeouts.getPingTimeoutMillis()) {
                        Process processToDestroy = null;
                        try {
                            processToDestroy = ((TikaServerWatchDog)TikaServerWatchDog.this).childProcess.process;
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        TikaServerWatchDog.destroyChildForcibly(processToDestroy);
                    }
                    try {
                        Thread.sleep(serverTimeouts.getPingPulseMillis());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        pingTimer.setDaemon(true);
        pingTimer.start();
        try {
            try {
                this.childProcess = new ChildProcess(args);
                this.setChildStatus(CHILD_STATUS.RUNNING);
                while (true) {
                    if (!this.childProcess.ping()) {
                        this.setChildStatus(CHILD_STATUS.INITIALIZING);
                        this.lastPing = null;
                        this.childProcess.close();
                        LOG.info("About to restart the child process");
                        this.childProcess = new ChildProcess(args);
                        LOG.info("Successfully restarted child process -- {} restarts so far)", (Object)(++this.restarts));
                        this.setChildStatus(CHILD_STATUS.RUNNING);
                    }
                    Thread.sleep(serverTimeouts.getPingPulseMillis());
                }
            }
            catch (InterruptedException interruptedException) {
                this.setChildStatus(CHILD_STATUS.SHUTTING_DOWN);
                if (this.childProcess != null) {
                    this.childProcess.close();
                }
            }
        }
        catch (Throwable throwable) {
            this.setChildStatus(CHILD_STATUS.SHUTTING_DOWN);
            if (this.childProcess != null) {
                this.childProcess.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChildStatus(CHILD_STATUS status) {
        Object[] objectArray = this.childStatusLock;
        synchronized (this.childStatusLock) {
            this.childStatus = status;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static List<String> extractArgs(String[] args) {
        ArrayList<String> argList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-J") || args[i].equals("-spawnChild") || args[i].equals("--spawnChild")) continue;
            argList.add(args[i]);
        }
        return argList;
    }

    private static List<String> extractJVMArgs(String[] args) {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        boolean foundHeadlessOption = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-J")) {
                jvmArgs.add("-" + args[i].substring(2));
            }
            if (!args[i].contains("java.awt.headless")) continue;
            foundHeadlessOption = true;
        }
        if (!foundHeadlessOption) {
            jvmArgs.add("-Djava.awt.headless=true");
        }
        return jvmArgs;
    }

    private static synchronized void destroyChildForcibly(Process process) {
        process = process.destroyForcibly();
        try {
            boolean destroyed = process.waitFor(60L, TimeUnit.SECONDS);
            if (!destroyed) {
                LOG.error("Child process still alive after 60 seconds. Shutting down the parent.");
                System.exit(1);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class ChildProcess {
        private Thread SHUTDOWN_HOOK = null;
        Process process;
        DataInputStream fromChild;
        DataOutputStream toChild;

        private ChildProcess(String[] args) throws Exception {
            this.process = this.startProcess(args);
            this.fromChild = new DataInputStream(this.process.getInputStream());
            this.toChild = new DataOutputStream(this.process.getOutputStream());
            byte status = this.fromChild.readByte();
            if (status != ServerStatus.STATUS.OPERATING.getByte()) {
                try {
                    ServerStatus.STATUS currStatus = ServerStatus.STATUS.lookup(status);
                    throw new IOException("bad status from child process: " + (Object)((Object)currStatus));
                }
                catch (ArrayIndexOutOfBoundsException currStatus) {
                    int len = this.process.getInputStream().available();
                    byte[] msg = new byte[len + 1];
                    msg[0] = status;
                    this.process.getInputStream().read(msg, 1, len);
                    throw new IOException("Unrecognized status code; message:\n" + new String(msg, StandardCharsets.UTF_8));
                }
            }
            TikaServerWatchDog.this.lastPing = Instant.now();
        }

        public boolean ping() {
            TikaServerWatchDog.this.lastPing = Instant.now();
            try {
                this.toChild.writeByte(ServerStatus.DIRECTIVES.PING.getByte());
                this.toChild.flush();
            }
            catch (Exception e) {
                LOG.warn("Exception pinging child process", e);
                return false;
            }
            try {
                byte status = this.fromChild.readByte();
                if (status != ServerStatus.STATUS.OPERATING.getByte()) {
                    LOG.warn("Received status from child: {}", (Object)ServerStatus.STATUS.lookup(status));
                    return false;
                }
            }
            catch (Exception e) {
                LOG.warn("Exception receiving status from child", e);
                return false;
            }
            return true;
        }

        private void close() {
            try {
                this.toChild.writeByte(ServerStatus.DIRECTIVES.SHUTDOWN.getByte());
                this.toChild.flush();
            }
            catch (Exception e) {
                LOG.warn("Exception asking child to shutdown", e);
            }
            try {
                this.fromChild.close();
            }
            catch (Exception e) {
                LOG.warn("Problem shutting down reader from child", e);
            }
            try {
                this.toChild.close();
            }
            catch (Exception e) {
                LOG.warn("Problem shutting down writer to child", e);
            }
            TikaServerWatchDog.destroyChildForcibly(this.process);
        }

        private Process startProcess(String[] args) throws IOException {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            ArrayList<String> argList = new ArrayList<String>();
            List jvmArgs = TikaServerWatchDog.extractJVMArgs(args);
            List childArgs = TikaServerWatchDog.extractArgs(args);
            argList.add("java");
            if (!jvmArgs.contains("-cp") && !jvmArgs.contains("--classpath")) {
                String cp = System.getProperty("java.class.path");
                jvmArgs.add("-cp");
                jvmArgs.add(cp);
            }
            argList.addAll(jvmArgs);
            argList.add("org.apache.tika.server.TikaServerCli");
            argList.addAll(childArgs);
            argList.add("-child");
            builder.command(argList);
            Process process = builder.start();
            if (this.SHUTDOWN_HOOK != null) {
                Runtime.getRuntime().removeShutdownHook(this.SHUTDOWN_HOOK);
            }
            this.SHUTDOWN_HOOK = new Thread(() -> process.destroyForcibly());
            Runtime.getRuntime().addShutdownHook(this.SHUTDOWN_HOOK);
            return process;
        }
    }

    private static enum CHILD_STATUS {
        INITIALIZING,
        RUNNING,
        SHUTTING_DOWN;

    }
}

