/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk8;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.DatatypeConverter;
import org.apache.sis.internal.jdk8.BiFunction;
import org.apache.sis.internal.jdk8.Predicate;

public final class JDK8 {
    private static final AtomicReference<Calendar> CALENDAR = new AtomicReference();

    private JDK8() {
    }

    public static String join(CharSequence charSequence, CharSequence ... charSequenceArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (CharSequence charSequence2 : charSequenceArray) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(charSequence);
            }
            stringBuffer.append(charSequence2);
        }
        return stringBuffer.toString();
    }

    public static boolean isFinite(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    public static int compareUnsigned(long l, long l2) {
        return Long.compare(l + Long.MIN_VALUE, l2 + Long.MIN_VALUE);
    }

    public static int compareUnsigned(int n, int n2) {
        return Integer.compare(n + Integer.MIN_VALUE, n2 + Integer.MIN_VALUE);
    }

    public static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return new BigInteger(Long.toHexString(l), 16).toString();
    }

    public static long toUnsignedLong(byte by) {
        return (long)by & 0xFFL;
    }

    public static int toUnsignedInt(byte by) {
        return by & 0xFF;
    }

    public static int toIntExact(long l) {
        int n = (int)l;
        if ((long)n == l) {
            return n;
        }
        throw new ArithmeticException();
    }

    public static int incrementExact(int n) {
        if (n != Integer.MAX_VALUE) {
            return n + 1;
        }
        throw new ArithmeticException();
    }

    public static int decrementExact(int n) {
        if (n != Integer.MIN_VALUE) {
            return n - 1;
        }
        throw new ArithmeticException();
    }

    public static int addExact(int n, int n2) {
        return JDK8.toIntExact((long)n + (long)n2);
    }

    public static long addExact(long l, long l2) {
        return l + l2;
    }

    public static int subtractExact(int n, int n2) {
        return JDK8.toIntExact((long)n - (long)n2);
    }

    public static long subtractExact(long l, long l2) {
        return l - l2;
    }

    public static int multiplyExact(int n, int n2) {
        return JDK8.toIntExact((long)n * (long)n2);
    }

    public static long multiplyExact(long l, long l2) {
        return l * l2;
    }

    public static int floorDiv(int n, int n2) {
        int n3 = n / n2;
        if (n % n2 != 0 && n < 0 != n2 < 0) {
            --n3;
        }
        return n3;
    }

    public static double nextDown(double d) {
        return Math.nextAfter(d, Double.NEGATIVE_INFINITY);
    }

    public static <V> V getOrDefault(Map<?, V> map, Object object, V v) {
        V v2 = map.get(object);
        if (v2 == null && !map.containsKey(object)) {
            v2 = v;
        }
        return v2;
    }

    public static <K, V> V putIfAbsent(Map<K, V> map, K k, V v) {
        V v2 = map.put(k, v);
        if (v2 != null) {
            map.put(k, v2);
        }
        return v2;
    }

    public static <K, V> V putIfAbsentConservative(Map<K, V> map, K k, V v) {
        V v2 = map.get(k);
        if (v2 == null) {
            v2 = map.put(k, v);
        }
        return v2;
    }

    public static <K, V> boolean remove(Map<K, V> map, Object object, Object object2) {
        boolean bl;
        V v = map.get(object);
        boolean bl2 = bl = Objects.equals(v, object2) && (v != null || map.containsKey(object));
        if (bl) {
            map.remove(object);
        }
        return bl;
    }

    public static <E> boolean removeIf(Collection<E> collection, Predicate<? super E> predicate) {
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!predicate.test(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static <K, V> boolean replace(Map<K, V> map, K k, V v, V v2) {
        V v3 = map.get(k);
        if (Objects.equals(v3, v) && (v3 != null || map.containsKey(k))) {
            map.put(k, v2);
            return true;
        }
        return false;
    }

    public static <K, V> void replaceAll(Map<K, V> map, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            entry.setValue(biFunction.apply(entry.getKey(), entry.getValue()));
        }
    }

    public static <K, V> V compute(ConcurrentMap<K, V> concurrentMap, K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        V v;
        boolean bl;
        do {
            Object v2;
            if ((v = biFunction.apply(k, v2 = concurrentMap.get(k))) != null) {
                if (v2 != null) {
                    bl = concurrentMap.replace(k, v2, v);
                    continue;
                }
                bl = concurrentMap.putIfAbsent(k, v) == null;
                continue;
            }
            if (v2 != null) {
                bl = concurrentMap.remove(k, v2);
                continue;
            }
            return null;
        } while (!bl);
        return v;
    }

    public static <K, V> V merge(Map<K, V> map, K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        V v2;
        V v3 = map.get(k);
        V v4 = v2 = v3 == null ? v : biFunction.apply(v3, v);
        if (v2 == null) {
            map.remove(k);
        } else {
            map.put(k, v2);
        }
        return v2;
    }

    public static Date parseDateTime(String string) throws IllegalArgumentException {
        return DatatypeConverter.parseDateTime(string).getTime();
    }

    public static String printDateTime(Date date) {
        Calendar calendar = CALENDAR.getAndSet(null);
        if (calendar == null) {
            calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
        }
        calendar.setTime(date);
        String string = DatatypeConverter.printDateTime(calendar);
        CALENDAR.set(calendar);
        return string;
    }

    public static BufferedReader newBufferedReader(Path path) throws IOException {
        return Files.newBufferedReader(path, StandardCharsets.UTF_8);
    }

    public static BufferedWriter newBufferedWriter(Path path) throws IOException {
        return Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

