/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentiment;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.sentiment.SentimentContextGenerator;
import opennlp.tools.sentiment.SentimentEventStream;
import opennlp.tools.sentiment.SentimentFactory;
import opennlp.tools.sentiment.SentimentModel;
import opennlp.tools.sentiment.SentimentSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.featuregen.AdditionalContextFeatureGenerator;

public class SentimentME {
    public static final String OTHER = "other";
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final int DEFAULT_BEAM_SIZE = 3;
    private static String[][] EMPTY = new String[0][0];
    protected SentimentContextGenerator contextGenerator;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();
    private Sequence bestSequence;
    protected SequenceClassificationModel<String> model;
    private SequenceValidator<String> sequenceValidator;
    private SentimentFactory factory;
    private MaxentModel maxentModel;
    private SequenceCodec<String> seqCodec = new BioCodec();

    public SentimentME(SentimentModel sentModel) {
        this.model = sentModel.getSentimentModel();
        this.maxentModel = sentModel.getMaxentModel();
        this.factory = sentModel.getFactory();
        this.contextGenerator = this.factory.createContextGenerator();
    }

    public static SentimentModel train(String languageCode, ObjectStream<SentimentSample> samples, TrainingParameters trainParams, SentimentFactory factory) throws IOException {
        HashMap entries = new HashMap();
        MaxentModel sentimentModel = null;
        Object seqModel = null;
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(trainParams.getSettings());
        SentimentEventStream eventStream = new SentimentEventStream(samples, factory.createContextGenerator());
        EventTrainer trainer = TrainerFactory.getEventTrainer(trainParams.getSettings(), entries);
        sentimentModel = trainer.train(eventStream);
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        return new SentimentModel(languageCode, sentimentModel, manifestInfoEntries, factory);
    }

    public String predict(String sentence) {
        String[] tokens = this.factory.getTokenizer().tokenize(sentence);
        double[] prob = this.probabilities(tokens);
        String sentiment = this.getBestSentiment(prob);
        return sentiment;
    }

    public String getBestSentiment(double[] outcome) {
        return this.maxentModel.getBestOutcome(outcome);
    }

    public double[] probabilities(String[] text) {
        return this.maxentModel.eval(this.contextGenerator.getContext(text));
    }

    public Span[] predict2(String[] tokens) {
        return this.predict2(tokens, EMPTY);
    }

    public Span[] predict2(String[] tokens, String[][] additionalContext) {
        this.additionalContextFeatureGenerator.setCurrentContext(additionalContext);
        this.bestSequence = this.model.bestSequence((String[])tokens, (Object[])additionalContext, this.contextGenerator, this.sequenceValidator);
        List<String> c = this.bestSequence.getOutcomes();
        Span[] spans = this.seqCodec.decode(c);
        return spans;
    }
}

