# This Makefile.PL for Block-NJH was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.48.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use Config qw/%Config/;
if ($ENV{AUTOMATED_TESTING}) {
    my $is_njh = 0;
    $is_njh ||= -d '/export/home/njh';
    $is_njh ||= -d '/home/njh';
    $is_njh ||= lc($ENV{USER} // 'na') eq 'njh';
    $is_njh ||= lc($ENV{HOME} // 'na') =~ m{njh$};
    $is_njh ||= lc($ENV{PATH} // 'na') =~ m{/njh/};
    die "OS unsupported\nNJH smokers are broken, aborting tests.\n"
        if $is_njh;
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "Prevent your tests from running on NJH's broken smokers.",
  "AUTHOR" => "Chad Granum <exodist\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Block-NJH",
  "LICENSE" => "perl",
  "NAME" => "Block::NJH",
  "PREREQ_PM" => {},
  "VERSION" => "0.002",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = ();

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
