/*    TimeZone.xs
 *
 *    $Id: TimeZone.xs,v 1.3 2001/02/12 02:16:58 bstell Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "unicode/timezone.h"
#include  "picu/Locale.h"
#include  "picu/TimeZone.h"

char *TimeZone_class_string = "ICU::TimeZone";
static int debugLevel = 0;

static IV
constant_iv(char *name, int arg)
{
    errno = 0;
    switch (*name) {
#if 0
add more cases as needed
    case 'A':
        break;
#endif
    case 'L':
        if (strEQ(name, "LONG"))
            return TimeZone::LONG;
        break;
    case 'S':
        if (strEQ(name, "SHORT"))
            return TimeZone::SHORT;
        break;
    }
    errno = EINVAL;
    return 0;

/* if a value should be defined but is not */
not_there:
    errno = ENOENT;
    return 0;
}

typedef enum TimeZone::EDisplayType TimeZone__EDisplayType;

MODULE = ICU::TimeZone    PACKAGE = ICU::TimeZone  

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

IV
constant_iv(name, arg)
    char *name
    int arg

TimeZone *
createTimeZone(CLASS, id_str)
    char *CLASS;
    char *id_str;
    PREINIT:
        UnicodeString id_unistr(id_str);
    CODE:
        RETVAL = TimeZone::createTimeZone(id_unistr);
    OUTPUT:
        RETVAL

# currently does not handle all the input posibilities
const char *
TimeZone::getDisplayName(inLocale=0)
        Picu_Locale *inLocale;
    PREINIT:
        UnicodeString dispName;
        U8 *u8str;
        uint32_t u8len;
    CODE:
        if (items == 2) {
            if (!IS_LOCALE_OBJECT(ST(1))) {
                Perl_croak("var is *NOT* type %s", Locale_class_string);
            }
            THIS->getDisplayName(*inLocale->getIcuLocale(), dispName);
        }
        else {
            THIS->getDisplayName(dispName);
        }
        u8str = UnicodeStringToU8String(dispName, &u8len);
        ST(0) = sv_newmortal();
        sv_usepvn(ST(0), (char*)u8str, u8len);
    OUTPUT:

void
createAvailableIDs(CLASS, rawOffset)
        char *CLASS;
        double rawOffset;
    PREINIT:
        const UnicodeString **ids_unistr;
        int i;
        int32_t count;
        U8 *u8str;
        uint32_t u8len;
    PPCODE:
        ids_unistr = TimeZone::createAvailableIDs(rawOffset, count);
        EXTEND(SP, count);
        for (i=0; i<count; i++) {
            u8str = UnicodeStringToU8String((UnicodeString&)*ids_unistr[i], &u8len);
            SV *sv = sv_newmortal();
            sv_usepvn(sv, (char*)u8str, u8len);
            PUSHs(sv);
        }
        delete [] ids_unistr;

void
TimeZone::DESTROY()
    CODE:
        DEBUG100("TimeZone::DESTROY()");
        delete THIS;
        DEBUG100("TimeZone::DESTROY()");

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::DateFormat::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL

void
setDefault(CLASS, timezone)
        char *CLASS;
        TimeZone *timezone;
    CODE:
        TimeZone::setDefault(*timezone);

