# Copyright 2001-2005 The Apache Software Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# $Id: Preload.pm,v 1.2 2005/07/14 18:43:34 matts Exp $

use strict;
no warnings;

BEGIN {

use AxKit;
use Apache::AxKit::Language::XSP;

my $r = Apache->server();
my $dir = $r->dir_config('AxXSPPreloadDir');
my $dirh;
opendir $dirh, $dir;
while (my $file = readdir $dirh) {
        if (-f "$dir/$file") {
                my $rc = eval { do "$dir/$file" };
                warn("Could not load $file: $@") if $@;
                warn("Loading of $file failed") if !$rc;
        }
}

}
1;
__END__

=head1 NAME

Apache::AxKit::Language::XSP::Preload - preload compiled XSP scripts

=head1 SYNOPSIS

Use something similar to this in your httpd.conf:

  PerlModule AxKit
  PerlSetVar AxXSPPreloadDir /etc/apache/xsp-preload
  PerlModule Apache::AxKit::Language::XSP::Preload

=head1 DESCRIPTION

This module will preload all compiled XSP files that reside in a
configurable directory. This is good for live sites, as the memory
for this XSP code will be shared among child processes and XSP.pm
doesn't need to reparse or re-eval your code at request time.

You must put compiled XSP files into the given directory. Use
AxTraceIntermediate to have them saved to disk, and copy any *.XSP
file you want into the preload dir.

B<Warning:> Do not, never, ever set AxTraceIntermediate to the same value as
AxXSPPreloadDir. First of all, this module tries to load all files in the
preload dir, and most files generated by AxTraceIntermediate are not
preloadable, only those ending in .XSP. More importantly, regenerating
preloaded files automatically opens a whole lot of security risks.

B<The preloaded code is loaded while apache is still running as root.> So make
absolutely sure you trust these files. You should only load files you generated
yourself. On a sidenote, similar systems like HTML::Mason have this problem, too,
so don't be afraid - but be careful.

=head1 AUTHOR

Jrg Walter E<lt>jwalt@cpan.orgE<gt>

=head1 LICENSE

This module is available under the same terms as AxKit itself.

=cut
