package Markdown::Simple;

use 5.006;
use strict;
use warnings;
our $VERSION = '0.01';
use parent qw(Exporter);

require XSLoader;
XSLoader::load('Markdown::Simple', $Markdown::Simple::VERSION);

our @EXPORT = qw/markdown_to_html/;


=head1 NAME

Markdown::Simple - The great new Markdown::Simple!

=head1 VERSION

Version 0.01

=cut

=head1 SYNOPSIS

This module was 100% generated using co-pilot with the prompt:

"create a simple markdown to html perl XS module that allows you to optionally enable each element of markdown. For example I can disable the parsing of image"

then:

"great now extend with table and a few of the other options like task list"

  use Markdown::Simple;

  markdown_to_html($markdown);

  markdown_to_html($markdown, {
    images => 0, # disable images
    code => 0, # disable code blocks
    links => 0, # disable links
  });

  

=head1 AUTHOR

LNATION, C<< <email at lnation.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-markdown-simple at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=Markdown-Simple>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Markdown::Simple


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=Markdown-Simple>

=item * Search CPAN

L<https://metacpan.org/release/Markdown-Simple>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2025 by LNATION.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)


=cut

1; # End of Markdown::Simple
