package Amazon::API::STS;

use strict;
use warnings;

use parent qw{ Amazon::API };

our @API_METHODS = qw{
  AssumeRole
  AssumeRoleWithSAML
  AssumeRoleWithWebIdentity
  DecodeAuthorizationMessage
  GetAccessKeyInfo
  GetCallerIdentity
  GetFederationToken
  GetSessionToken
};

our $VERSION = '1.3.2';

sub new {
  my ( $class, @options ) = @_;

  $class = ref($class) || $class;

  my %options = ref( $options[0] ) ? %{ $options[0] } : @options;

  return $class->SUPER::new(
    { service      => 'sts',
      version      => '2011-06-15',
      api_methods  => \@API_METHODS,
      content_type => 'application/x-www-form-urlencoded',
      %options,
    }
  );
} ## end sub new

1;
