use 5.014;

use strict;
use warnings;
use routines;

use Test::Auto;
use Test::More;

=name

ore

=cut

=abstract

Sugar for Perl 5 one-liners

=cut

=synopsis

  BEGIN {
    $ENV{New_File_Temp} = 'ft';
  }

  use ore;

  $ft

=cut

=description

This package provides automatic object instantiation based on environment
variables. This package exists because I was bored and inspired by L<new>.

+=head2 examples

Simple command-line example using env vars to drive object instantiation:

  $ New_File_Temp=ft perl -More -e 'dd $ft'

  # "File::Temp"

Another simple command-line example using env vars to return a
L<Data::Object::Space> object which calls C<children> and returns an arrayref
of L<Data::Object::Space> objects:

  $ Use_DBI=dbi perl -More -e 'dd $dbi->children'

  # [
  #   ...,
  #   "DBI/DBD",
  #   "DBI/Profile",
  #   "DBI/ProfileData",
  #   "DBI/ProfileDumper",
  #   ...,
  # ]

Here's another simple command-line example using args as env vars with ordered
variable interpolation:

  $ perl -More -E 'dd $pt' New_File_Temp=ft New_Path_Tiny='pt; $ft'

  # /var/folders/pc/v4xb_.../T/JtYaKLTTSo

=cut

package main;

my $test = testauto(__FILE__);

my $subs = $test->standard;

$subs->synopsis(fun($tryable) {
  ok my $result = $tryable->result;
  ok $result->isa('File::Temp');

  $result
});

ok 1 and done_testing;
