use strict;
use warnings;
use Test::More tests => 266;
use Crypt::Mode::ECB;

my @tests;

# test vectors from http://csrc.nist.gov/publications/nistpubs/800-38a/sp800-38a.pdf
push @tests,
  { padding=>'none', key=>'2b7e151628aed2a6abf7158809cf4f3c', pt=>'6bc1bee22e409f96e93d7e117393172aae2d8a571e03ac9c9eb76fac45af8e5130c81c46a35ce411e5fbc1191a0a52eff69f2445df4f9b17ad2b417be66c3710', ct=>'3ad77bb40d7a3660a89ecaf32466ef97f5d3d58503b9699de785895a96fdbaaf43b1cd7f598ece23881b00e3ed0306887b0c785e27e8ad3f8223207104725dd4' },
  { padding=>'none', key=>'8e73b0f7da0e6452c810f32b809079e562f8ead2522c6b7b', pt=>'6bc1bee22e409f96e93d7e117393172aae2d8a571e03ac9c9eb76fac45af8e5130c81c46a35ce411e5fbc1191a0a52eff69f2445df4f9b17ad2b417be66c3710', ct=>'bd334f1d6e45f25ff712a214571fa5cc974104846d0ad3ad7734ecb3ecee4eefef7afd2270e2e60adce0ba2face6444e9a4b41ba738d6c72fb16691603c18e0e' },
  { padding=>'none', key=>'603deb1015ca71be2b73aef0857d77811f352c073b6108d72d9810a30914dff4', pt=>'6bc1bee22e409f96e93d7e117393172aae2d8a571e03ac9c9eb76fac45af8e5130c81c46a35ce411e5fbc1191a0a52eff69f2445df4f9b17ad2b417be66c3710', ct=>'f3eed1bdb5d2a03c064b5a7e3db181f8591ccb10d410ed26dc5ba74a31362870b6ed21b99ca6f4f9f153e7b1beafed1d23304b7a39f9f3ff067d8d8f9e24ecc7' },
;

# test vectors produced by Crypt::ECB
push @tests,
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>45,  key=>'9c1975bc3f89e58f790e8e1cdaeea5cc1147fa43c5da2f9ae681274bd406a663', pt=>'a99303fcd37a6c39acb2dd2f3955cbcdf2d4643cc5542019f549ca2b62a4b27a099f42e0a8fb90fc53f0f32c5402f89822215472d1a5c5e8e299090cfeb80151222922c91aa0a8e21ff07147ca62a4542cc36fb437ff2f56be51e6db4e763252960b4a02cfda2fb8a74a63c0fa',  ct=>'b52d56dfbd230e87af5d6cd122b050ba4dacfa112e214359d04626efbf57ccde810246076261e0dd7be797bc9b07b20c3a737f72822498fecc68d73ff6c057a1313684058ff1110af0e59347953e1b337b6dbcb852f9210099ea4b54482ae4d9069193d5cb22c6cdfad968a27771b38b' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>46,  key=>'11748a8de11e393c610eb582ee3534414f7187790435cdcbe1fd5f7c6db757be', pt=>'ff6da3d97b3907fcc171090bdcc97a43d98cde4bd76937eb672e3a4ce04b15de634d6c320bbe0b84304e52fbf004111f0d0671674196b3ea380f09295a04deb1f26b4d49bc239669bbed6b9316277516914ca4f30d570c156ea90f58565cbf26ead7c6d04eb411b83ef2445a914c',  ct=>'91f00f683e3a381ebadb9553db928776fa972a06ca73a31e38ba6501d0f7b27c0013dcf3b25b3206ccd2083fcc815eaa3f843fa14ceca9e54a687b69d0e515dff1cf4b756744f242955b766c87473275ffa6c2191c89ad064c4b83e95ded84514613bc5d7763ffc0b0ec2281bf36d76c' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>47,  key=>'d36ba22781e756dfe5e64bc9729e7d50bc00a24133ea90de1d77e666e9b39bb5', pt=>'a74a52d0a02d9e959127a1fa84790605828c6e1e8a9d71ff78320b1bc888affb3e19db2c5e62233ef6ab4adf89524efe369b12259925461b88d412d8276e5e80f327addee10c3e99778e0df730cf70509faef08e7c22b2142cc6201474465b47af54e99299290117eca9514a583ecf',  ct=>'1e768190063599f2be4309a27c2d1b294714bb567f231ea9ad17fe31c183b3ab2d3db1b95a3e646aa88c35d98b3ce193640e2013e643b5da787087a2a115b1f61370e42943c90c384c64b128eeaa06c98b0c7b9e9a3c2b875100c5fb9703c5e94dc394c45ffc079d2ba75ad2b342100e' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>48,  key=>'c81db73dd90c0edec5dc988ef9c23284ccf5030997c5b3ab971cd134fbfb7915', pt=>'aabc66bbf94ecaafd3368d2ad464522d86431ebdfb678d0e6bf7012614f24e760265918f5765f4ecca2fb74dc1b699d553d8dd3fc758df536e70d26729d1c06cc3c06bb4050f9b53df9b9f0977142646cbdd0a4b7efae5935505af6902b90831fa2bc01d5cede403c769815f5e926eea',  ct=>'79e038414bbff323f8ace3b38eec6a49e9b011d83531a9655037f8c12a8d0cf2ed5fd8f293edcbfc1c1876773c9f4c36279dc3893229556af897a8948a6f0cf2007447925badf65f8cb18b30efc1ce9a58fe826b973466b316277ecd11deb804fa9fb8c4f46fcf225f4484af6ff7259ee5ea601127a1882030eb31d679214f5a' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>49,  key=>'5e077065a0d1344fbf08106c0e1ceaca7b9455641291b41ccc68285770d72921', pt=>'b2ef1c2557039e56d1c01d68c8e0cc1ee632dbccb7fe2b344d3327b86844f7e428a36e55d2e7fcf53579056a067f868693ea0bae53173942ab12a1ef8b7155361648d48431b9529c5fc1d8400fcd38235037979aefd97f29b3fe949c75f457223113a2d1680061a3b89930401df2397200',  ct=>'532f55915edca9782577b1828fcb9fb4c6de41b9f0ba65d2925aadf27949c8445da27c994dc8f13cf3e37af2b2b841058b6f49cf1d32a259773fa3aae38a3d97e954be3371ef46b204deb6a0f4148623d2b2dd70ce5218dbd7930b8d81e914b17b8ebb622201b87f06bae3de1def3b27e2773d188a4a2f8b4d2d857c09113d8a' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>50,  key=>'1668a028d8da7cc4181886416ba735f22dab4df08722ba97c3eaff1eafde09a1', pt=>'a15c2358e9254c4f541d9873ce11353108901a4dba5beca1a856d42d06746dd55508eb7d8c66f506edb6ceed07f9bc5bc2d077a6d232d1ae97fec21bf3f5658c2026bb985a71bc5649aecdc76bfeadfba78ff75e60889e0dbe71c86cf6de2fd63225d7fde4452f8220c45985f9d8eaaeec01',  ct=>'456c08bbc1afa46126fe81b95f4a3fbc1ab284ff5cf45c21bed20fc21a6086b91ec3e6a8b22798491953dc8632de38812ea8e6fcc914d0603409da7911420a2de7a514722177937384cc2c63800cf66eb0e61513b141c65ab08db8aec887e5599c0e02b6660a4084985e5bdcbf29e5b46c4cca64761fb4d02a9c913153d4cc6a' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>61,  key=>'082350b5a25d440529c7aa42eff92407b21805b36b6c9123385d600011abce63', pt=>'a7382c0e4a60bf66b001bddebf0e91a7a07dfaab25b8bfb05144e1fa33859e76b9369495712c65fd238d4f9ffdc8b93ea754035fdb5b8d4ac00c4d648b5d4890ff9cf8e7c51d9d349647e0940d9e544b0580c82522c811e690b31217f63fea643a235b39924fe2f49426c0640fd1d17290b9e96cf16b4f8d02eedcc8f6',  ct=>'0b4d53297e8cc94c25fc7bd2045433743f26ce8e5bddfdeb2b725165a83971599569f42abe5820cee5ac8b70a9abde3e872b94fc3734c1f326933344c64443dc56c191c18442a963fe722dde88996fa7328ecba06da7c01637e958da30d79ea528bd478d94f89529de6c5a15704464bd8be825315cbf15044041448eb27733b9' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>62,  key=>'802612ccbea22d8557d99004907ed090ac369f44a3a6c5f4685d9e7d5d71ed32', pt=>'431a32eaeb7c7947bcb0f3cd97d75ba606befb12f10893122983a4a20ed37d3ef15067f8730c0562bc064590cf49132827f420ccf50853083ab403d6fac899c00bb3b34c3bde1900aaf887d053842ca4e08ba805e62f820631f98b594601b81eb0c892d6841f37267ac4c6ffd98fb42c2e52048ffdd51ca88b9b982821b9',  ct=>'a5c525f9994b6c33f5ab57c9b0c98eff74699d3439009103b39b2fbae5f5d4f93c86df65066a8656873ef44fbf4e71c6381e7119254d42e6e903a1c5c7ade99a3ad92b9104b8fb000af967d10e79750a5edab1706192bfcdb750398439ba22880dedc3124d37a2b6655ab7aeebf769b7d2f8142d90f897baa928107fc6a17299' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>63,  key=>'b673afee984c45eac1bce4387e9079fe82497dc597c9cfbe8e53fade93099640', pt=>'58643eb31a9951c4928ca5612f8893223a2cf03ab2db6cf9464230431edb9f87bf664e49eca86196e5708450929258f31cc0c13f95d5be45f943a41b827a5eb316407ce518943a67fd1f9b3fa1eec0c39dc142e19445372d552148c5b2190aca407f5f8d372f18a904c1beef4e54c3b6255bd458712448d6b88dcd3176c022',  ct=>'3582f853543ea393d6ac2eaa30d765def81f21da8db46c301000c0a3a30bff4c380267b8705feb48d5f16d7937140cd878fcfae99801b2908f83f1a5e84fffbab86495f9c47791a8714567f671ac7fac63921b25da5ac30d18d859c1f33d404bd9960a116eabe71098a3372199aa1fa9866ae5cf9c83b76983a9be6503fb307a' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>64,  key=>'f5f9efb5f4fe71186a91f3eb2944c4e54bf45614dff6e473fcfa9c0b885311dd', pt=>'ef06a0bcc0f1b26a41736052540c8badc53cd08c093e12a68bffc43bb5707a0d98c16ad988d811498add8fa0059a0f238badbec6cfad0184b560903ef635ec2de847af2e9a140e71095b75f420a560aa846ea5f3306380ac79af896f6c1695781488000ee3aff9e23424bdfe83deb52b1857bb54995fbda358d8ac9f6c9b2002',  ct=>'285da6c06751a6811b4a6f56ad1c3a6ee3813d695bedd8151e0282357038109e15b0c2cd9c7008ab4513a1f48ee298b750b115f7bfa906b6c481ba5e0117611a8de0386de099bf6fad8e7e85412a3dd040fcaef75fb57e1ccb23c9f3da84fed22d4d6ce31fb73abad54396449d54519b9c95cbf34eb1cf5aed4c526531c5580bd62ff10c0dd5110bab7bc3e9b0ea00b3' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>65,  key=>'d12852a3a07b7b83f55565df4fdf825a0db8ccda4a3f6598a9751d9924e9f7ce', pt=>'c58d1ab06aade14858687993232e7836ebd4fa71ca2c734efcb9a442ecff26d9ed96760b2bb5fd0de05e3cdd6292fead7c7b3fcd52867ab48bb12bb4f64c35c2efc545705abe4188251df968e1dba60fa5936eda59c36e2b10b945e9266db8484673496c4862ded7ac3bc68b8103e5433d48eb19fd756436993733e43bd5cb08e7',  ct=>'87b71b3ce97e1a0cf52b088ad3605331b63e8159f093f17153e57b47a4021c99e069c529c2dbaa4c86522a86eb1b89aff03e5b6c2c06ceee46de322598c6f4d23471d36642be5d7635577c935e5a600fa473d5a283da969ec73ed5572d6cb4eaf97a47a460d9920cf805275c904380db321286bc1c5d552093ee7016daa095d6cb151076329a592688d60aab65d4d3bb' },
  { mode=>'AES+Crypt::ECB', padding=>'standard', len=>66,  key=>'24667ee02db1e4b35984c6678dd5d3eb18ebfc3c8530c7b4cebe76aace87977a', pt=>'5ecef2891b3d9cc2dfbc44af183237cef460736313338399b1499e5aff94b08ced6a33f8765bfa3e6874b0d1bcc8f73588abcd95013db83cf1cd23aa7e6eabd71427ae460cdf46a2d3b79e9c98d69a4b124f17e292ac714e96ac544bb48707812ed7266e122560493ca13c1c78d9353f2e2a6a95163e1ddf5e09e8fd3fec0ddb4ded',  ct=>'df1b5cb5c2b9d6aa58fea48567b0b7aa02a1b06627decdf7e9a5886dfbadfb937c185ea45140776ff1976fa549e40918efb97f387b4bdc73be38bb58be6ca4a1c592d69eb2830c8523a1c1fd2b16706c1fdf61916348ca5cec4274b800bd37c831f8d96bdd3951a45ceea3d1e2228beb8e723e163810e45c1c52d1941771c9d062a7da642a8c868a13925e3aa4b1c761' },
  { mode=>'AES+Crypt::ECB', padding=>'none', len=>48,  key=>'661b5aff95cf8ab76e45b526bef583396b9eba163e10847afaac7ad36b3979cd', pt=>'9dd919c944cbdba69a3c5d5233148dc4042f36c18acb4b49704c9f87d8532168d1f75ef4bce56d729b67f55743deb3dd719498c1995dfc887465d5561985b33f8f5105ab39b6ac05f1aa27e2f0a19c72996ff4014778ec883f1a3a1d48174a24e8bcc84546c491b3da040b3fd001c4ec',  ct=>'34e43d2c24ba6c2e5c32b817171b7dd780ba3bd4d774e7a51c20b992d4c29cb570e161d43aba819155242ecf960bd363e471d19772f37669e1ca552535744df3f6a6540b85a90a67fa2c3343dcd2f2f2c9b72578b823b09405a3d917b65ae1a29a0638df46aa0b8dfb62fd1a199a281e' },
  { mode=>'AES+Crypt::ECB', padding=>'none', len=>64,  key=>'9d59c6f36300896c33d5f9adbea4831fa158e29fd2020cdcf93405671d591729', pt=>'e6daa0b28199d245fa3293f710a1a72eb92dadc63fad8a0c8b0f4cba85c350a2b133f0630dd13900c5a5067f1e5425b5272aa147e209cbd57af939a431865b9c1c928bab46d2c5b5d1e34041b9099bd09e32223181848da4a7c3ab6f1426d4f30bd51fa48e032d49285e3e1d2c7e9def030e57784c83135550cbb1fed7849d64',  ct=>'97645d39a60497d80f542f61d81f3a065562852c375f95d3709d6b51bdbd0faf6a1112524c1625550d31047acfebc567ddf39d061ef57e85c65243bec96a69b5dc53674570380cef776d4c0744bd3f9c82d47b11ce81c77a6ee014503de4adbf9c78a32e70bb916378428f9a33f3f1837bbeb559fdb1675219f83fbefc4a361b' },
;

for (@tests) {
  my ($pt, $ct, $m);
  $m = 0 if $_->{padding} eq 'none';
  $m = 1 if $_->{padding} eq 'standard';
  $m = 2 if $_->{padding} eq 'oneandzeroes';
  die "invalid padding" unless defined $m;
  $ct = Crypt::Mode::ECB->new('AES', $m)->encrypt(pack("H*",$_->{pt}), pack("H*",$_->{key}));
  $pt = Crypt::Mode::ECB->new('AES', $m)->decrypt(pack("H*",$_->{ct}), pack("H*",$_->{key}));
  ok($ct, "cipher text");
  ok($pt, "plain text");
  is(unpack("H*",$ct), $_->{ct}, 'cipher text match');
  is(unpack("H*",$pt), $_->{pt}, 'plain text match');
}

{
  my @t = (
    { padding=>1, key=>'f5f9efb5f4fe71186a91f3eb2944c4e54bf45614dff6e473fcfa9c0b885311dd', pt=>'ef06a0bcc0f1b26a41736052540c8badc53cd08c093e12a68bffc43bb5707a0d98c16ad988d811498add8fa0059a0f238badbec6cfad0184b560903ef635ec2de847af2e9a140e71095b75f420a560aa846ea5f3306380ac79af896f6c1695781488000ee3aff9e23424bdfe83deb52b1857bb54995fbda358d8ac9f6c9b2002',  ct=>'285da6c06751a6811b4a6f56ad1c3a6ee3813d695bedd8151e0282357038109e15b0c2cd9c7008ab4513a1f48ee298b750b115f7bfa906b6c481ba5e0117611a8de0386de099bf6fad8e7e85412a3dd040fcaef75fb57e1ccb23c9f3da84fed22d4d6ce31fb73abad54396449d54519b9c95cbf34eb1cf5aed4c526531c5580bd62ff10c0dd5110bab7bc3e9b0ea00b3' },
    { padding=>1, key=>'d12852a3a07b7b83f55565df4fdf825a0db8ccda4a3f6598a9751d9924e9f7ce', pt=>'c58d1ab06aade14858687993232e7836ebd4fa71ca2c734efcb9a442ecff26d9ed96760b2bb5fd0de05e3cdd6292fead7c7b3fcd52867ab48bb12bb4f64c35c2efc545705abe4188251df968e1dba60fa5936eda59c36e2b10b945e9266db8484673496c4862ded7ac3bc68b8103e5433d48eb19fd756436993733e43bd5cb08e7',  ct=>'87b71b3ce97e1a0cf52b088ad3605331b63e8159f093f17153e57b47a4021c99e069c529c2dbaa4c86522a86eb1b89aff03e5b6c2c06ceee46de322598c6f4d23471d36642be5d7635577c935e5a600fa473d5a283da969ec73ed5572d6cb4eaf97a47a460d9920cf805275c904380db321286bc1c5d552093ee7016daa095d6cb151076329a592688d60aab65d4d3bb' },
    { padding=>0, key=>'9d59c6f36300896c33d5f9adbea4831fa158e29fd2020cdcf93405671d591729', pt=>'e6daa0b28199d245fa3293f710a1a72eb92dadc63fad8a0c8b0f4cba85c350a2b133f0630dd13900c5a5067f1e5425b5272aa147e209cbd57af939a431865b9c1c928bab46d2c5b5d1e34041b9099bd09e32223181848da4a7c3ab6f1426d4f30bd51fa48e032d49285e3e1d2c7e9def030e57784c83135550cbb1fed7849d64',  ct=>'97645d39a60497d80f542f61d81f3a065562852c375f95d3709d6b51bdbd0faf6a1112524c1625550d31047acfebc567ddf39d061ef57e85c65243bec96a69b5dc53674570380cef776d4c0744bd3f9c82d47b11ce81c77a6ee014503de4adbf9c78a32e70bb916378428f9a33f3f1837bbeb559fdb1675219f83fbefc4a361b' },
  );
  for (@t) {
    my $pt = pack("H*", $_->{pt});
    my $ct = pack("H*", $_->{ct});
    my $m = Crypt::Mode::ECB->new('AES', $_->{padding});
    for my $l (1..33) {

      {
        $m->start_encrypt(pack("H*",$_->{key}));
        my $i = 0;
        my $ct = '';
        while ($i < length($pt)) {
          $ct .= $m->add(substr($pt, $i, $l));
          $i += $l;
        }
        $ct .= $m->finish;
        is(unpack("H*",$ct), $_->{ct}, "cipher text match [l=$l]");
      }

      {
        $m->start_decrypt(pack("H*",$_->{key}));
        my $i = 0;
        my $pt = '';
        while ($i < length($ct)) {
          $pt .= $m->add(substr($ct, $i, $l));
          $i += $l;
        }
        $pt .= $m->finish;
        is(unpack("H*",$pt), $_->{pt}, "plain text match  [l=$l]");
      }

    }
  }
}
