=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Cv - Package for language Chuvash

=cut

package Locale::CLDR::Locales::Cv;
# This file auto generated from Data\common\main\cv.xml
#	on Wed 15 Jan 11:22:39 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.46.0');

use v5.12.0;
use mro 'c3';
use utf8;
use feature 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'афар',
 				'ab' => 'абхаз',
 				'af' => 'африканс',
 				'agq' => 'агем',
 				'ak' => 'акан',
 				'am' => 'амхар',
 				'an' => 'арагон',
 				'ann' => 'оболо',
 				'apc' => 'левант араб',
 				'ar' => 'арап',
 				'ar_001' => 'арап литератури',
 				'arn' => 'мапуче',
 				'as' => 'ассам',
 				'asa' => 'асу',
 				'ast' => 'астури',
 				'az' => 'азербайджан',
 				'ba' => 'пушкӑрт',
 				'bal' => 'белудж',
 				'bas' => 'бас',
 				'be' => 'белорусси',
 				'bem' => 'бемба',
 				'bew' => 'батав',
 				'bez' => 'бен',
 				'bg' => 'пӑлхар',
 				'bgc' => 'харианви',
 				'bgn' => 'хӗвеланӑҫ балочи',
 				'bho' => 'бохжпури',
 				'blo' => 'ания',
 				'blt' => 'хура таи',
 				'bm' => 'бамбар',
 				'bn' => 'бенгал',
 				'bo' => 'тибет',
 				'br' => 'бретань',
 				'brx' => 'бодо',
 				'bs' => 'босни',
 				'bss' => 'акоос',
 				'byn' => 'билин',
 				'ca' => 'каталан',
 				'cad' => 'каддо',
 				'cch' => 'атсам',
 				'ccp' => 'чакма',
 				'ce' => 'чеченец',
 				'ceb' => 'себуано',
 				'cgg' => 'кига',
 				'cho' => 'чоктав',
 				'chr' => 'чероки',
 				'cic' => 'чикасав',
 				'ckb' => 'вăтаçĕр курд',
 				'ckb@alt=menu' => 'тӗп курд',
 				'ckb@alt=variant' => 'курд (соран)',
 				'co' => 'корсикан',
 				'cs' => 'чех',
 				'csw' => 'шурлӑх кри',
 				'cu' => 'чиркӳ-славян',
 				'cv' => 'чӑваш',
 				'cy' => 'валлий',
 				'da' => 'датчан',
 				'dav' => 'тайта',
 				'de' => 'нимӗҫ',
 				'de_AT' => 'австрин нимӗҫ',
 				'de_CH' => 'швейцарин нимӗҫ',
 				'dje' => 'зарма',
 				'doi' => 'догри',
 				'dsb' => 'аялти серб',
 				'dua' => 'дуал',
 				'dv' => 'мальдив',
 				'dyo' => 'диола-фоньи',
 				'dz' => 'дзонг-кэ',
 				'ebu' => 'эмбу',
 				'ee' => 'эве',
 				'el' => 'грек',
 				'en' => 'акӑлчан',
 				'en_AU' => 'австралин акӑлчан',
 				'en_CA' => 'канадӑн акӑлчан',
 				'en_GB' => 'британин акӑлчан',
 				'en_US' => 'америкӑн акӑлчан',
 				'eo' => 'эсперанто',
 				'es' => 'испани',
 				'es_419' => 'латинла америкӑн испани',
 				'es_ES' => 'европӑн испани',
 				'es_MX' => 'мексикӑн испани',
 				'et' => 'эстон',
 				'eu' => 'баск',
 				'ewo' => 'эвондо',
 				'fa' => 'фарси',
 				'fa_AF' => 'фарси (Афганистан)',
 				'ff' => 'фул',
 				'fi' => 'фин',
 				'fil' => 'филиппин',
 				'fo' => 'фарер',
 				'fr' => 'франци',
 				'fr_CA' => 'канадӑн франци',
 				'fr_CH' => 'швейцарӗн франци',
 				'frc' => 'каджун француз',
 				'frr' => 'ҫурҫӗр фризӗ',
 				'fur' => 'фриул',
 				'fy' => 'хӗвеланӑҫ фриз',
 				'ga' => 'ирланд',
 				'gaa' => 'га',
 				'gd' => 'гэль',
 				'gez' => 'геэз',
 				'gl' => 'галис',
 				'gn' => 'гуаран',
 				'gsw' => 'швейцари нимӗҫ',
 				'gu' => 'гуджарат',
 				'guz' => 'гусии',
 				'gv' => 'мэн',
 				'ha' => 'хауса',
 				'haw' => 'гавай',
 				'he' => 'иврит',
 				'hi' => 'хинди',
 				'hi_Latn' => 'хинди чӗлхи (латин)',
 				'hi_Latn@alt=variant' => 'хинди (латин)',
 				'hnj' => 'монг',
 				'hr' => 'хорват',
 				'hsb' => 'тури сорбиан',
 				'hu' => 'венгер',
 				'hy' => 'армян',
 				'ia' => 'интерлинг',
 				'id' => 'индонези',
 				'ie' => 'интерлингве',
 				'ig' => 'игбо',
 				'ii' => 'носу (сичуан)',
 				'io' => 'идо',
 				'is' => 'исланди',
 				'it' => 'итали',
 				'iu' => 'инуктитут',
 				'ja' => 'япони',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачам',
 				'jv' => 'яван',
 				'ka' => 'грузин',
 				'kaa' => 'каракалпак',
 				'kab' => 'кабиль',
 				'kaj' => 'каджи',
 				'kam' => 'камба',
 				'kcg' => 'туар',
 				'kde' => 'маконде',
 				'kea' => 'кабувердьян',
 				'ken' => 'камерун',
 				'kgp' => 'каинганг',
 				'khq' => 'койра чиини',
 				'ki' => 'куикуй',
 				'kk' => 'казах',
 				'kkj' => 'како',
 				'kl' => 'гренланди',
 				'kln' => 'календжин',
 				'km' => 'кхмер',
 				'kn' => 'каннада',
 				'ko' => 'корей',
 				'kok' => 'конкани',
 				'kpe' => 'кпелле',
 				'ks' => 'кашмир',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафи',
 				'ksh' => 'кельн',
 				'ku' => 'курд',
 				'kw' => 'корн',
 				'kxv' => 'куви',
 				'ky' => 'киргиз',
 				'la' => 'латин',
 				'lag' => 'ланго',
 				'lb' => 'люксембург',
 				'lg' => 'ганда',
 				'lij' => 'лигур',
 				'lkt' => 'лакота',
 				'lld' => 'тироль',
 				'lmo' => 'ломбард',
 				'ln' => 'лингал',
 				'lo' => 'лаос',
 				'lou' => 'луизиан креоль',
 				'lrc' => 'ҫурҫӗр лури',
 				'lt' => 'литва',
 				'ltg' => 'латгал латыш',
 				'lu' => 'луба-катанга',
 				'luo' => 'луо',
 				'luy' => 'лухья',
 				'lv' => 'латыш',
 				'mai' => 'майтхили',
 				'mas' => 'масайсем',
 				'mdf' => 'мокшан',
 				'mer' => 'меру',
 				'mfe' => 'маврика креолӗ',
 				'mg' => 'малагас',
 				'mgh' => 'макуа-мето',
 				'mgo' => 'мета',
 				'mhn' => 'мотено',
 				'mi' => 'маори',
 				'mic' => 'микмак',
 				'mk' => 'македон',
 				'ml' => 'малаялам',
 				'mn' => 'монгол',
 				'mni' => 'манипур',
 				'moh' => 'мохук',
 				'mr' => 'маратхи',
 				'ms' => 'малай',
 				'mt' => 'мальтисем',
 				'mua' => 'мундир',
 				'mul' => 'тӗрлӗ ҫемье чӗлхисем',
 				'mus' => 'крик',
 				'my' => 'бирман',
 				'myv' => 'эрзян',
 				'mzn' => 'мазандеран',
 				'naq' => 'нама',
 				'nb' => 'норвег букмол',
 				'nd' => 'ҫурҫӗр ндебеле',
 				'nds' => 'аялти нимĕç',
 				'nds_NL' => 'аялти нимĕç (Нидерланд)',
 				'ne' => 'непал',
 				'nl' => 'голланди',
 				'nl_BE' => 'фламанди',
 				'nmg' => 'квасио',
 				'nn' => 'норвег нюнорск',
 				'nnh' => 'нгиембунд',
 				'no' => 'норвег',
 				'nqo' => 'нко (манинка)',
 				'nr' => 'кӑнтӑр ндебеле',
 				'nso' => 'ҫурҫӗр сото',
 				'nus' => 'нуэр',
 				'nv' => 'навахо',
 				'ny' => 'ньяндж',
 				'nyn' => 'ньянколе',
 				'oc' => 'окситан',
 				'om' => 'оромо',
 				'or' => 'оди (ори)',
 				'os' => 'осетин',
 				'osa' => 'оседжи',
 				'pa' => 'панджаби',
 				'pap' => 'папьяменто',
 				'pcm' => 'нигер креоль',
 				'pis' => 'пиджин',
 				'pl' => 'поляк',
 				'prg' => 'прусси',
 				'ps' => 'пушту',
 				'pt' => 'португали',
 				'pt_BR' => 'бразилин португали',
 				'pt_PT' => 'европӑн португали',
 				'qu' => 'кечуа',
 				'quc' => 'киче',
 				'raj' => 'раджастан',
 				'rhg' => 'рохиндж',
 				'rif' => 'риффиан (бербер)',
 				'rm' => 'романш',
 				'rn' => 'рунди',
 				'ro' => 'румын',
 				'ro_MD' => 'молдаван',
 				'rof' => 'ромбо',
 				'ru' => 'вырӑс',
 				'rw' => 'киньяруанд',
 				'rwk' => 'руанда',
 				'sa' => 'санскрит',
 				'sah' => 'якут',
 				'saq' => 'самбуру',
 				'sat' => 'сантали',
 				'sbp' => 'сангу',
 				'sc' => 'сардин',
 				'scn' => 'сицил',
 				'sd' => 'синдхи',
 				'sdh' => 'кӑнтӑр алтай',
 				'se' => 'ҫурҫӗр саам',
 				'seh' => 'сена',
 				'ses' => 'койраборо сенни',
 				'sg' => 'санго',
 				'shi' => 'тахелхит (бербер)',
 				'shn' => 'шан',
 				'si' => 'сингал',
 				'sid' => 'сидама',
 				'sk' => 'словак',
 				'skr' => 'сирайки',
 				'sl' => 'словен',
 				'sma' => 'кӑнтӑр саам',
 				'smj' => 'луле-саам',
 				'smn' => 'инар-саам',
 				'sms' => 'колтта-саам',
 				'sn' => 'шона',
 				'so' => 'сомали',
 				'sq' => 'албан',
 				'sr' => 'серб',
 				'ss' => 'свази',
 				'ssy' => 'сахо',
 				'st' => 'кӑнтӑр сото',
 				'su' => 'сундан',
 				'sv' => 'швед',
 				'sw' => 'суахили',
 				'sw_CD' => 'суахили (Конго - Киншаса)',
 				'syr' => 'сири',
 				'szl' => 'силез',
 				'ta' => 'тамил',
 				'te' => 'телугу',
 				'teo' => 'тесо',
 				'tg' => 'таджик',
 				'th' => 'тай',
 				'ti' => 'тигринья',
 				'tig' => 'тигре',
 				'tk' => 'туркмен',
 				'tn' => 'тсвана',
 				'to' => 'тонган',
 				'tok' => 'токи пона',
 				'tpi' => 'ток писин',
 				'tr' => 'турккӑ',
 				'trv' => 'тароко',
 				'trw' => 'торвали',
 				'ts' => 'тсонга',
 				'tt' => 'тутар',
 				'twq' => 'тасавак',
 				'tyv' => 'тува',
 				'tzm' => 'Вӑтам Атлас тамазигт',
 				'ug' => 'уйгур',
 				'uk' => 'украина',
 				'und' => 'паллӑ мар чӗлхе',
 				'ur' => 'урду',
 				'uz' => 'узбек',
 				'vai' => 'ваи',
 				've' => 'венда',
 				'vec' => 'венециан',
 				'vi' => 'вьетнам',
 				'vmw' => 'макуа',
 				'vo' => 'воляпюк',
 				'vun' => 'вунджо',
 				'wa' => 'валлон (бельги)',
 				'wae' => 'вальзер (нимӗҫ)',
 				'wal' => 'воламо',
 				'wbp' => 'вальбири',
 				'wo' => 'волоф',
 				'xh' => 'кхоса',
 				'xnr' => 'кангри',
 				'xog' => 'сога',
 				'yav' => 'янгбен',
 				'yi' => 'идиш',
 				'yo' => 'йоруба',
 				'yrl' => 'ньенгату',
 				'yue' => 'кантон',
 				'za' => 'чжуан',
 				'zgh' => 'тамазигт',
 				'zh' => 'китай',
 				'zh@alt=menu' => 'ҫурҫӗр китай',
 				'zh_Hans' => 'китай, ҫӑмӑллатнӑ ҫыру',
 				'zh_Hans@alt=long' => 'ҫурҫӗр китай, ҫӑмӑллатнӑ ҫыру',
 				'zh_Hant' => 'китай, традициллӗ ҫыру',
 				'zh_Hant@alt=long' => 'ҫурҫӗр китай, традициллӗ ҫыру',
 				'zu' => 'зулу',
 				'zxx' => 'чӗлхе материал ҫук',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'адлам',
 			'Aghb' => 'кавказ албан',
 			'Ahom' => 'ахом',
 			'Arab' => 'арап',
 			'Aran' => 'насталик',
 			'Armi' => 'империри арамей',
 			'Armn' => 'армян',
 			'Avst' => 'авеста',
 			'Bali' => 'бали',
 			'Bamu' => 'бамум',
 			'Bass' => 'басса',
 			'Batk' => 'батак',
 			'Beng' => 'бангла',
 			'Bhks' => 'бхайксук',
 			'Bopo' => 'бопомофо',
 			'Brah' => 'брахми',
 			'Brai' => 'брайль',
 			'Bugi' => 'бугин',
 			'Buhd' => 'бухид',
 			'Cakm' => 'чакма',
 			'Cans' => 'канада аборигенӗсен пӗрлехи системи',
 			'Cari' => 'кари',
 			'Cham' => 'чам',
 			'Cher' => 'чероки',
 			'Chrs' => 'хорезм',
 			'Copt' => 'копт',
 			'Cpmn' => 'кипро-миной',
 			'Cprt' => 'кипр',
 			'Cyrl' => 'кириллица',
 			'Cyrs' => 'авалхи славян',
 			'Deva' => 'деванагари',
 			'Diak' => 'дивес акуру',
 			'Dogr' => 'догра',
 			'Dsrt' => 'дезерет',
 			'Dupl' => 'дюплой стенографийӗ',
 			'Egyp' => 'египет иероглифӗсем',
 			'Elba' => 'эльбасан',
 			'Elym' => 'элимей',
 			'Ethi' => 'эфиоп',
 			'Gara' => 'гарай',
 			'Geor' => 'грузин',
 			'Glag' => 'глаголица',
 			'Gong' => 'гунджала гонди',
 			'Gonm' => 'масарам гонди',
 			'Goth' => 'готика',
 			'Gran' => 'грантха',
 			'Grek' => 'грек',
 			'Gujr' => 'гуджарат',
 			'Gukh' => 'гурунг кхема',
 			'Guru' => 'гурмукхи',
 			'Hanb' => 'хэн пĕрле бопомофо',
 			'Hang' => 'хангыл',
 			'Hani' => 'хэн',
 			'Hano' => 'хануну',
 			'Hans' => 'ҫӑмӑллатнӑн китай',
 			'Hans@alt=stand-alone' => 'ҫӑмӑллатнӑ китай',
 			'Hant' => 'традициллӗн китай',
 			'Hatr' => 'хатран',
 			'Hebr' => 'еврей',
 			'Hira' => 'хирагана',
 			'Hluw' => 'анатолий иероглифӗсем',
 			'Hmng' => 'пахау хмонг',
 			'Hmnp' => 'ньякенг пуачуэ-хмонг',
 			'Hrkt' => 'япони слог',
 			'Hung' => 'авалхи венгер',
 			'Ital' => 'кивӗ чалăш',
 			'Jamo' => 'джамо',
 			'Java' => 'яван',
 			'Jpan' => 'япони',
 			'Kali' => 'кайя ли',
 			'Kana' => 'катакана',
 			'Kawi' => 'кави',
 			'Khar' => 'кхароштхи',
 			'Khmr' => 'кхмер',
 			'Khoj' => 'ходжки',
 			'Kits' => 'кидани вӗтӗ шрифт',
 			'Knda' => 'каннада',
 			'Kore' => 'корей',
 			'Krai' => 'кирата раи',
 			'Kthi' => 'кайтхи',
 			'Lana' => 'ланна',
 			'Laoo' => 'лаос',
 			'Latf' => 'фрактура латин',
 			'Latg' => 'гэль латин',
 			'Latn' => 'латин',
 			'Lepc' => 'лепча',
 			'Limb' => 'лимбу',
 			'Lina' => 'вăрăмăш А',
 			'Linb' => 'вăрăмăш Б',
 			'Lisu' => 'фрейзер',
 			'Lyci' => 'лики',
 			'Lydi' => 'лиди',
 			'Mahj' => 'махаджани',
 			'Maka' => 'макасар',
 			'Mand' => 'мандей',
 			'Mani' => 'манихей',
 			'Marc' => 'мархен',
 			'Medf' => 'обэри окаимэ',
 			'Mend' => 'менде',
 			'Merc' => 'мероит чалăш',
 			'Mero' => 'мероит',
 			'Mlym' => 'малаялам',
 			'Modi' => 'моди',
 			'Mong' => 'монгол',
 			'Mroo' => 'мро',
 			'Mtei' => 'мейтей-майек',
 			'Mult' => 'мултан',
 			'Mymr' => 'мьянма',
 			'Nagm' => 'мундар',
 			'Nand' => 'нандинагари',
 			'Narb' => 'авалхи ҫурҫӗр-араб',
 			'Nbat' => 'набатейсем',
 			'Newa' => 'нева',
 			'Nkoo' => 'нко',
 			'Nshu' => 'нюй-шу',
 			'Ogam' => 'огам',
 			'Olck' => 'ол-чики',
 			'Onao' => 'ол онал',
 			'Orkh' => 'орхон',
 			'Orya' => 'оди (ори)',
 			'Osge' => 'осейдж',
 			'Osma' => 'исмани',
 			'Ougr' => 'ватӑ уйгур',
 			'Palm' => 'пальмир',
 			'Pauc' => 'пау-синь-хау',
 			'Perm' => 'ватӑ перм',
 			'Phag' => 'Пагба (монгол тӑваткал)',
 			'Phli' => 'пехлеви (вӑтам перс)',
 			'Phlp' => 'пехлеви псалтирӗ',
 			'Phnx' => 'финик',
 			'Plrd' => 'поллард фонетики',
 			'Prti' => 'парфян',
 			'Qaag' => 'зоги (бирман)',
 			'Rjng' => 'реджанг',
 			'Rohg' => 'ханифи',
 			'Runr' => 'рун',
 			'Samr' => 'самаритян',
 			'Sarb' => 'авалхи кӑнтӑр-араб',
 			'Saur' => 'саураштра',
 			'Sgnw' => 'паллă',
 			'Shaw' => 'шовиан',
 			'Shrd' => 'шарада',
 			'Sidd' => 'сиддхам',
 			'Sind' => 'худабади',
 			'Sinh' => 'cингал',
 			'Sogd' => 'согдиан',
 			'Sogo' => 'авалхи согдиан',
 			'Sora' => 'соранг сомпенг',
 			'Soyo' => 'сойомбо',
 			'Sund' => 'сундан',
 			'Sunu' => 'сунувар',
 			'Sylo' => 'силоти нагри',
 			'Syrc' => 'сири',
 			'Syre' => 'эстранджело сири',
 			'Syrj' => 'хӗвеланӑҫ сири',
 			'Syrn' => 'хӗвелтухӑҫ сири',
 			'Tagb' => 'тагбанва',
 			'Takr' => 'такри',
 			'Tale' => 'тай-ныа',
 			'Talu' => 'лы ҫӗнӗ ҫыру',
 			'Taml' => 'тамиль',
 			'Tang' => 'тангут',
 			'Tavt' => 'тайвьет',
 			'Telu' => 'телугу',
 			'Tfng' => 'тифинаг',
 			'Tglg' => 'тагаль',
 			'Thaa' => 'таана',
 			'Thai' => 'тай',
 			'Tibt' => 'тибет',
 			'Tirh' => 'тирхута',
 			'Tnsa' => 'тасе-нага',
 			'Todr' => 'тодри',
 			'Toto' => 'тото',
 			'Tutg' => 'тулу',
 			'Ugar' => 'угарит',
 			'Vaii' => 'вай',
 			'Vith' => 'виткути',
 			'Wara' => 'варанг-кшити',
 			'Wcho' => 'ванчо',
 			'Xpeo' => 'авалхи перс',
 			'Xsux' => 'шумер-аккад савăл',
 			'Yezi' => 'езид',
 			'Yiii' => 'носу',
 			'Zanb' => 'тӑваткал забазар',
 			'Zinh' => 'еткер',
 			'Zmth' => 'математика паллисем',
 			'Zsye' => 'эмодзи',
 			'Zsym' => 'символсем',
 			'Zxxx' => 'ҫырусӑр',
 			'Zyyy' => 'пӗтӗмӗшле',
 			'Zzzz' => 'паллӑ мар ҫырулах',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'тӗнче',
 			'002' => 'Африка',
 			'003' => 'Ҫурҫӗр Америка',
 			'005' => 'Кӑнтӑр Америка',
 			'009' => 'Океани',
 			'011' => 'Анӑҫ Африка',
 			'013' => 'Тӗп Америка',
 			'014' => 'Хӗвелтухӑҫ Африка',
 			'015' => 'Ҫурҫӗр Африка',
 			'017' => 'Тӗп Африка',
 			'018' => 'Кӑнтӑр Африка',
 			'019' => 'Америка',
 			'021' => 'Ҫурҫӗр Америка регион',
 			'029' => 'Карибсем',
 			'030' => 'Хӗвелтухӑҫ Ази',
 			'034' => 'Кӑнтӑр Ази',
 			'035' => 'Кӑнтӑр хӗвелтухӑҫ Ази',
 			'039' => 'Кӑнтӑр Европа',
 			'053' => 'Австралази',
 			'054' => 'Меланези',
 			'057' => 'Микронези регион',
 			'061' => 'Полинези',
 			'142' => 'Ази',
 			'143' => 'Тӗп Ази',
 			'145' => 'Анӑҫ Ази',
 			'150' => 'Европа',
 			'151' => 'Хӗвелтухӑҫ Европа',
 			'154' => 'Ҫурҫӗр Европа',
 			'155' => 'Анӑҫ Европа',
 			'202' => 'Тропик Африка',
 			'419' => 'Латинла Америка',
 			'AC' => 'Вознесени утравӗ',
 			'AD' => 'Андорра',
 			'AE' => 'Арапсен Пӗрлешӳллӗ Эмирачӗ',
 			'AF' => 'Афганистан',
 			'AG' => 'Антигуа тата Барбуда',
 			'AI' => 'Ангилья',
 			'AL' => 'Албани',
 			'AM' => 'Армени',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктида',
 			'AR' => 'Аргентина',
 			'AS' => 'Америка Самоа',
 			'AT' => 'Австри',
 			'AU' => 'Австрали',
 			'AW' => 'Аруба',
 			'AX' => 'Аланди утравӗсем',
 			'AZ' => 'Азербайджан',
 			'BA' => 'Боснипе Герцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельги',
 			'BF' => 'Буркина-Фасо',
 			'BG' => 'Болгари',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сен-Бартелеми',
 			'BM' => 'Бермуд утравӗсем',
 			'BN' => 'Бруней-Даруссалам',
 			'BO' => 'Боливи',
 			'BQ' => 'Бонэйр, Синт-Эстатиус тата Саба',
 			'BR' => 'Бразили',
 			'BS' => 'Пахам утравӗсем',
 			'BT' => 'Бутан',
 			'BV' => 'Буве утравӗ',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларуҫ',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокос утравӗсем',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (КДР)',
 			'CF' => 'Тӗп Африка Республики',
 			'CG' => 'Конго - Браззавиль',
 			'CG@alt=variant' => 'Конго Республики',
 			'CH' => 'Швейцари',
 			'CI' => 'Кот-д’Ивуар',
 			'CK' => 'Кук утравӗсем',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Китай',
 			'CO' => 'Колумби',
 			'CP' => 'Клиппертон утравӗ',
 			'CQ' => 'Сарк',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Раштав утравӗ',
 			'CY' => 'Кипр',
 			'CZ' => 'Чехи',
 			'CZ@alt=variant' => 'Чех Республики',
 			'DE' => 'Германи',
 			'DG' => 'Диего-Гарсия',
 			'DJ' => 'Джибути',
 			'DK' => 'Дани',
 			'DM' => 'Доминика',
 			'DO' => 'Доминикан Республики',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута тата Мелилья',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстони',
 			'EG' => 'Египет',
 			'EH' => 'Анӑҫ Сахара',
 			'ER' => 'Эритрей',
 			'ES' => 'Испани',
 			'ET' => 'Эфиопи',
 			'EU' => 'Европа пӗрлешӗвӗ',
 			'EZ' => 'Еврозон',
 			'FI' => 'Финлянди',
 			'FJ' => 'Фиджи',
 			'FK' => 'Фолкленд утравӗсем',
 			'FK@alt=variant' => 'Фолкленд (Мальвински) утравӗсем',
 			'FM' => 'Микронези',
 			'FO' => 'Фарер утравӗсем',
 			'FR' => 'Франци',
 			'GA' => 'Габон',
 			'GB' => 'Аслӑ Британи',
 			'GB@alt=short' => 'Британи',
 			'GD' => 'Гренада',
 			'GE' => 'Грузи',
 			'GF' => 'Франци Гвиана',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланди',
 			'GM' => 'Гамби',
 			'GN' => 'Гвиней',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Экваториаллӑ Гвиней',
 			'GR' => 'Греци',
 			'GS' => 'Кӑнтӑр Георги тата Сандвичев утравӗсем',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвиней-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'Гонконг (САР)',
 			'HK@alt=short' => 'Гонконг',
 			'HM' => 'Херд тата Макдональд утравӗ',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорвати',
 			'HT' => 'Гаити',
 			'HU' => 'Венгри',
 			'IC' => 'Канар утравӗсем',
 			'ID' => 'Индонези',
 			'IE' => 'Ирланди',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн утравӗ',
 			'IN' => 'Инди',
 			'IO' => 'Британин территори Инди океанӗре',
 			'IO@alt=biot' => 'Британи территори Инди океанӗре',
 			'IO@alt=chagos' => 'Чагос архипелаге',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланди',
 			'IT' => 'Итали',
 			'JE' => 'Джерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Иордани',
 			'JP' => 'Япони',
 			'KE' => 'Кени',
 			'KG' => 'Киргизи',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кирибати',
 			'KM' => 'Комор утравӗсем',
 			'KN' => 'Сент-Китс тата Невис',
 			'KP' => 'КХДР',
 			'KR' => 'Корей Республики',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайман утравӗсем',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент-Люсия',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либери',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латви',
 			'LY' => 'Ливи',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Черногори',
 			'MF' => 'Сен-Мартен',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршаллов утравӗсем',
 			'MK' => 'Ҫурҫӗр Македони',
 			'ML' => 'Мали',
 			'MM' => 'Мьянма (Бирма)',
 			'MN' => 'Монголи',
 			'MO' => 'Макао (САР)',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Ҫурҫӗр Мариан утравӗсем',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритани',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврики',
 			'MV' => 'Мальдивсем',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзи',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намиби',
 			'NC' => 'Ҫӗнӗ Каледони',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк утравӗ',
 			'NG' => 'Нигери',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерланд',
 			'NO' => 'Норвеги',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Ҫӗнӗ Зеланди',
 			'NZ@alt=variant' => 'Аотеароа (Ҫӗнӗ Зеланди)',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Франци Полинези',
 			'PG' => 'Папуа — Ҫӗнӗ Гвиней',
 			'PH' => 'Филиппинсем',
 			'PK' => 'Пакистан',
 			'PL' => 'Польша',
 			'PM' => 'Сен-Пьер & Микелон',
 			'PN' => 'Питкэрн утравӗсем',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Палестинӑн территорийӗсем',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португали',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Тулаш Океани',
 			'RE' => 'Реюньон',
 			'RO' => 'Румыни',
 			'RS' => 'Серби',
 			'RU' => 'Раҫҫей',
 			'RW' => 'Руанда',
 			'SA' => 'Сауд Аравийӗ',
 			'SB' => 'Соломон утравӗсем',
 			'SC' => 'Сейшел утравӗсем',
 			'SD' => 'Судан',
 			'SE' => 'Швеци',
 			'SG' => 'Сингапур',
 			'SH' => 'Сӑваплӑ Елена утравӗ',
 			'SI' => 'Словени',
 			'SJ' => 'Шпицберген тата Ян-Майен',
 			'SK' => 'Словаки',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Кӑнтӑр Судан',
 			'ST' => 'Сан-Томе тата Принсипи',
 			'SV' => 'Сальвадор',
 			'SX' => 'Синт-Мартен',
 			'SY' => 'Сири',
 			'SZ' => 'Эсватини',
 			'SZ@alt=variant' => 'Свазиленд',
 			'TA' => 'Тристан-да-Кунья',
 			'TC' => 'Тёркс тата Кайкос утравӗсем',
 			'TD' => 'Чад',
 			'TF' => 'Франци Кӑнтӑр территорийӗсем',
 			'TG' => 'Того',
 			'TH' => 'Таиланд',
 			'TJ' => 'Таджикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Хӗвелтухӑҫ Тимор',
 			'TL@alt=variant' => 'Тимор-Лесте',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турци',
 			'TT' => 'Тринидад тата Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзани',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'Тулашӗнчи утравӗсем (АПШ)',
 			'UN' => 'Пӗрлешӳллӗ Нацисен Организацийӗ',
 			'US' => 'Пӗрлешӗннӗ Штатсем',
 			'US@alt=short' => 'АПШ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Винсент тата Гренадины',
 			'VE' => 'Венесуэла',
 			'VG' => 'Британин Виргини утравӗсем',
 			'VI' => 'Виргини утравӗсем (АПШ)',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис тата Футуна',
 			'WS' => 'Самоа',
 			'XA' => 'псевдакцентсем',
 			'XB' => 'псевд-Bidi',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотта',
 			'ZA' => 'Кӑнтӑр Африка Республики',
 			'ZM' => 'Замби',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'паллӑ мар регион',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1901' => 'Нимӗҫ йӑлана кӗнӗ орфографийӗ',
 			'1994' => 'Стандартизациленӗ резьян орфографийӗ',
 			'1996' => '1996 ҫултан пуҫласа нимӗҫ орфографийӗн правилисем',
 			'1606NICT' => 'Француз каярахпа вӑтам ӗмӗрӗ 1606 ҫулччен',
 			'1694ACAD' => 'Француз ирхи çĕнĕ вăхăт',
 			'1959ACAD' => 'Академи',
 			'ABL1943' => '1943 ҫулхи орфографийӗ',
 			'AKUAPEM' => 'AKUAPEM локализаци',
 			'ALALC97' => 'ALALC97 локализаци',
 			'ALUKU' => 'Алукулу диалекчӗ',
 			'ANPEZO' => 'ANPEZO локализаци',
 			'AO1990' => 'AO1990 орфографийӗ',
 			'ARANES' => 'ARANES локализаци',
 			'ARKAIKA' => 'ARKAIKA локализаци',
 			'ASANTE' => 'ASANTE локализаци',
 			'AUVERN' => 'AUVERN локализаци',
 			'BAKU1926' => 'Унификациленӗ тӗрӗк-латин алфавичӗ',
 			'BALANKA' => 'BALANKA локализаци',
 			'BARLA' => 'BARLA локализаци',
 			'BASICENG' => 'BASICENG локализаци',
 			'BAUDDHA' => 'BAUDDHA локализаци',
 			'BCIAV' => 'BCIAV локализаци',
 			'BCIZBL' => 'BCIZBL локализаци',
 			'BISCAYAN' => 'BISCAYAN локализаци',
 			'BISKE' => 'Сан-Гиоргио диалекчӗ',
 			'BLASL' => 'BLASL локализаци',
 			'BOHORIC' => 'Бохорич алфавичӗ',
 			'BOONT' => 'Бунтлинг',
 			'BORNHOLM' => 'BORNHOLM локализаци',
 			'CISAUP' => 'CISAUP локализаци',
 			'COLB1945' => 'COLB1945 локализаци',
 			'CORNU' => 'CORNU локализаци',
 			'CREISS' => 'CREISS локализаци',
 			'DAJNKO' => 'DAJNKO локализаци',
 			'EKAVSK' => 'EKAVSK локализаци',
 			'EMODENG' => 'EMODENG локализаци',
 			'FASCIA' => 'FASCIA локализаци',
 			'FODOM' => 'FODOM локализаци',
 			'FONIPA' => 'Тӗнчери фонетика алфавичӗ',
 			'FONKIRSH' => 'FONKIRSH локализаци',
 			'FONNAPA' => 'FONNAPA локализаци',
 			'FONUPA' => 'Урал чӗлхисен фонетика алфавичӗ',
 			'FONXSAMP' => 'FONXSAMP локализаци',
 			'GALLO' => 'GALLO локализаци',
 			'GASCON' => 'GASCON локализаци',
 			'GHERD' => 'GHERD локализаци',
 			'GRCLASS' => 'GRCLASS локализаци',
 			'GRITAL' => 'GRITAL локализаци',
 			'GRMISTR' => 'GRMISTR локализаци',
 			'HEPBURN' => 'HEPBURN локализаци',
 			'HOGNORSK' => 'HOGNORSK локализаци',
 			'HSISTEMO' => 'HSISTEMO локализаци',
 			'IJEKAVSK' => 'IJEKAVSK локализаци',
 			'ITIHASA' => 'ITIHASA локализаци',
 			'IVANCHOV' => 'IVANCHOV локализаци',
 			'JAUER' => 'JAUER локализаци',
 			'JYUTPING' => 'JYUTPING локализаци',
 			'KKCOR' => 'Пӗтӗмӗшле орфографийӗ',
 			'KOCIEWIE' => 'KOCIEWIE локализаци',
 			'KSCOR' => 'KSCOR локализаци',
 			'LAUKIKA' => 'LAUKIKA локализаци',
 			'LEMOSIN' => 'LEMOSIN локализаци',
 			'LENGADOC' => 'LENGADOC локализаци',
 			'LIPAW' => 'Резьян чӗлхин липовецла диалекчӗ',
 			'LTG1929' => 'LTG1929 локализаци',
 			'LTG2007' => 'LTG2007 локализаци',
 			'LUNA1918' => 'LUNA1918 локализаци',
 			'METELKO' => 'METELKO локализаци',
 			'MONOTON' => 'Пӗр кĕвĕллĕ',
 			'NDYUKA' => 'NDYUKA локализаци',
 			'NEDIS' => 'Надиж диалекчӗ',
 			'NEWFOUND' => 'NEWFOUND локализаци',
 			'NICARD' => 'NICARD локализаци',
 			'NJIVA' => 'Гнива-нжив диалекчӗ',
 			'NULIK' => 'NULIK локализаци',
 			'OSOJS' => 'Осеакла-осоянла диалект',
 			'OXENDICT' => 'OXENDICT локализаци',
 			'PAHAWH2' => 'PAHAWH2 локализаци',
 			'PAHAWH3' => 'PAHAWH3 локализаци',
 			'PAHAWH4' => 'PAHAWH4 локализаци',
 			'PAMAKA' => 'PAMAKA локализаци',
 			'PEANO' => 'PEANO локализаци',
 			'PEHOEJI' => 'PEHOEJI локализаци',
 			'PETR1708' => 'PETR1708 локализаци',
 			'PINYIN' => 'Пиньинь локализаци',
 			'POLYTON' => 'Нумай тонлӑ',
 			'POSIX' => 'Компьютер',
 			'PROVENC' => 'PROVENC локализаци',
 			'PUTER' => 'PUTER локализаци',
 			'REVISED' => 'Ҫӗнӗрен пӑхса тухнӑ орфографийӗ',
 			'RIGIK' => 'RIGIK локализаци',
 			'ROZAJ' => 'Резьян',
 			'RUMGR' => 'RUMGR локализаци',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Англо-шотланди',
 			'SCOUSE' => 'Ливерпуль',
 			'SIMPLE' => 'Ансат',
 			'SOLBA' => 'Столици-солбицки диалект',
 			'SOTAV' => 'SOTAV локализаци',
 			'SPANGLIS' => 'SPANGLIS локализаци',
 			'SURMIRAN' => 'SURMIRAN локализаци',
 			'SURSILV' => 'SURSILV локализаци',
 			'SUTSILV' => 'SUTSILV локализаци',
 			'SYNNEJYL' => 'SYNNEJYL локализаци',
 			'TAILO' => 'TAILO локализаци',
 			'TARASK' => 'Тарашкевиц',
 			'TONGYONG' => 'TONGYONG локализаци',
 			'TUNUMIIT' => 'TUNUMIIT локализаци',
 			'UCCOR' => 'Пӗрлешӳллӗ орфографийӗ',
 			'UCRCOR' => 'Пӗрлешӳллӗ ҫӗнӗрен пӑхса тухнӑ орфографийӗ',
 			'ULSTER' => 'ULSTER локализаци',
 			'UNIFON' => 'UNIFON локализаци',
 			'VAIDIKA' => 'VAIDIKA локализаци',
 			'VALBADIA' => 'VALBADIA локализаци',
 			'VALENCIA' => 'Валенси',
 			'VALLADER' => 'VALLADER локализаци',
 			'VECDRUKA' => 'VECDRUKA локализаци',
 			'VIVARAUP' => 'VIVARAUP локализаци',
 			'WADEGILE' => 'Уэйд – Джайлз системи',
 			'XSISTEMO' => 'XSISTEMO локализаци',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'çулталăк кĕнеки',
 			'cf' => 'валюта формачӗ',
 			'collation' => 'сортировка йӗрки',
 			'currency' => 'валюта',
 			'hc' => 'вӑхӑт формачӗ (12- е 24-сехет)',
 			'lb' => 'çĕнĕ йĕркерен пуçла стилӗ',
 			'ms' => 'виҫев системи',
 			'numbers' => 'цифрисем',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{будда çулталăк кĕнеки},
 				'chinese' => q{китай çулталăк кĕнеки},
 				'coptic' => q{копт çулталăк кĕнеки},
 				'dangi' => q{данги çулталăк кĕнеки},
 				'ethiopic' => q{эфиопи çулталăк кĕнеки},
 				'ethiopic-amete-alem' => q{амете-алем эфиопи çулталăк кĕнеки},
 				'gregorian' => q{грегориан календарӗ},
 				'hebrew' => q{еврей çулталăк кĕнеки},
 				'indian' => q{инди наци çулталăк кĕнеки},
 				'islamic' => q{хиджра çулталăк кĕнеки},
 				'islamic-civil' => q{хиджра граждан çулталăк кĕнеки (таблици)},
 				'islamic-rgsa' => q{хиджра çулталăк кĕнеки (Сауд Аравийӗ)},
 				'islamic-tbla' => q{хиджра çулталăк кĕнеки (таблица, астрономи тапхӑрӗ)},
 				'islamic-umalqura' => q{хиджра çулталăк кĕнеки (Умм аль-Кура)},
 				'iso8601' => q{календарӗ ISO-8601},
 				'japanese' => q{япони çулталăк кĕнеки},
 				'persian' => q{перси çулталăк кĕнеки},
 				'roc' => q{Миньго çулталăк кĕнеки},
 			},
 			'cf' => {
 				'account' => q{финанс формачӗ},
 				'standard' => q{валюта стандартлӑ формачӗ},
 			},
 			'collation' => {
 				'big5han' => q{йӑлана кӗнӗ китай - big5},
 				'compat' => q{иртнĕ сортировка йӗрки},
 				'dictionary' => q{сортировка йӗрки словарĕ},
 				'ducet' => q{Юникодри яланхи сортировка йӗрки},
 				'emoji' => q{эмодзи сортировка йӗрки},
 				'eor' => q{Европа сортировка правилисем},
 				'gb2312han' => q{китай сортировкӑн ансат йӗрки - GB2312},
 				'phonebook' => q{телефон кӗнекине сортировка йӗрке},
 				'pinyin' => q{пиньинь сортировка йӗрки},
 				'search' => q{шырани},
 				'searchjl' => q{хангыльти пуҫламӑш килӗшӳпе шырав},
 				'standard' => q{стандартлӑ сортировка},
 				'stroke' => q{йĕр сортировка йӗрке},
 				'traditional' => q{йӑлана кӗнӗ сортировка йӗрки},
 				'unihan' => q{уҫҫисем тӑрӑх, унтан йӗрсем тӑрӑх сортировка},
 				'zhuyin' => q{чжуинь сортировка йӗрки},
 			},
 			'hc' => {
 				'h11' => q{12-сехет (0-11) вӑхӑт формачӗ},
 				'h12' => q{12-сехет (1-12) вӑхӑт формачӗ},
 				'h23' => q{24-сехет (0-23) вӑхӑт формачӗ},
 				'h24' => q{24-сехет (1-24) вӑхӑт формачӗ},
 			},
 			'lb' => {
 				'loose' => q{çĕнĕ йĕркерен пуçла ирӗклӗ стилӗ},
 				'normal' => q{çĕнĕ йĕркерен пуçла яланхи стилӗ},
 				'strict' => q{çĕнĕ йĕркерен пуçла хаяр стилӗ},
 			},
 			'ms' => {
 				'metric' => q{метрикăлла виçев пĕрчисем},
 				'uksystem' => q{британи виҫев системи},
 				'ussystem' => q{америка виҫев системи},
 			},
 			'numbers' => {
 				'ahom' => q{ахом цифрисем},
 				'arab' => q{араб-инди цифрисем},
 				'arabext' => q{араб-инди цифрисем анлӑ системи},
 				'armn' => q{армян цифрисем},
 				'armnlow' => q{аялти регистрти армян цифрисем},
 				'bali' => q{бали цифрисем},
 				'beng' => q{бенгали цифрисем},
 				'brah' => q{брахмӑллӑ цифрӑсем},
 				'cakm' => q{чакма цифрисем},
 				'cham' => q{чам цифрисем},
 				'cyrl' => q{çырулăхе славян цифрисем},
 				'deva' => q{деванагари цифрисем},
 				'diak' => q{дайвз акуру цифрисем},
 				'ethi' => q{эфиопи цифрисем},
 				'fullwide' => q{тулли сарлакăш цифрисем},
 				'gara' => q{гарай цифрисем},
 				'geor' => q{грузин цифрисем},
 				'gong' => q{гунджала гонди цифрисем},
 				'gonm' => q{масарам гонди цифрисем},
 				'grek' => q{грек цифрисем},
 				'greklow' => q{аялти регистрти грек цифрисем},
 				'gujr' => q{гуджарати цифрисем},
 				'gukh' => q{гурунги кхема цифрисем},
 				'guru' => q{гурмукхи цифрисем},
 				'hanidec' => q{китай вуншарлă цифрисем},
 				'hans' => q{китай ансат цифрисем},
 				'hansfin' => q{китай ансат финанс цифрисем},
 				'hant' => q{китай йăлана кĕнĕ цифрисем},
 				'hantfin' => q{китай йăлана кĕнĕ финанс цифрисем},
 				'hebr' => q{иврит цифрисем},
 				'hmng' => q{пахау цифрисем},
 				'hmnp' => q{наякинг пуачу хмонг цифрисем},
 				'java' => q{яван цифрисем},
 				'jpan' => q{япони цифрисем},
 				'jpanfin' => q{япони финанс цифрисем},
 				'kali' => q{кайя ли цифрисем},
 				'kawi' => q{кави цифрисем},
 				'khmr' => q{кхмер цифрисем},
 				'knda' => q{каннад цифрисем},
 				'krai' => q{кират рай цифрисем},
 				'lana' => q{ланна цифрисем},
 				'lanatham' => q{тай тхам цифрисем},
 				'laoo' => q{лаос цифрисем},
 				'latn' => q{хальхи араб цифрисем},
 				'lepc' => q{лепча цифрисем},
 				'limb' => q{лимб цифрисем},
 				'mathbold' => q{математика самăр цифрисем},
 				'mathdbl' => q{математика хăвăл цифрисене},
 				'mathmono' => q{математика цифрисем},
 				'mathsanb' => q{математика самăр сан-сериф цифрисем},
 				'mathsans' => q{математика сан-сериф цифрисем},
 				'mlym' => q{малаялам цифрисем},
 				'modi' => q{моди цифрисем},
 				'mong' => q{монгол цифрисем},
 				'mroo' => q{мро цифрисем},
 				'mtei' => q{манипури цифрисем},
 				'mymr' => q{бирман цифрисем},
 				'mymrepka' => q{бирман тухӑҫӗнчи пво карен цифрисем},
 				'mymrpao' => q{бирман пао цифрисем},
 				'mymrshan' => q{бирман шан цифрисем},
 				'mymrtlng' => q{бирман таи лаи цифрисем},
 				'nagm' => q{наг мундари цифрисем},
 				'nkoo' => q{нко цифрисем},
 				'olck' => q{ол-чики цифрисем},
 				'onao' => q{ол онал цифрисем},
 				'orya' => q{ория цифрисем},
 				'osma' => q{исмания цифрисем},
 				'outlined' => q{самăр цифрисем},
 				'rohg' => q{ханифи цифрисем},
 				'roman' => q{рим цифрисем},
 				'romanlow' => q{аялти регистрти рим цифрисем},
 				'saur' => q{саураштра цифрисем},
 				'shrd' => q{шарада цифрисем},
 				'sind' => q{худавади цифрисем},
 				'sinh' => q{синхала цифрисем},
 				'sora' => q{сора-сомпенг цифрисем},
 				'sund' => q{судан цифрисем},
 				'sunu' => q{сунвари цифрисем},
 				'takr' => q{такри цифрисем},
 				'talu' => q{ҫӗнӗ тай-лю цифрисем},
 				'taml' => q{тамильти йӑлана кӗнӗ цифрисем},
 				'tamldec' => q{тамиль цифрисем},
 				'telu' => q{телугу цифрисем},
 				'thai' => q{тай цифрисем},
 				'tibt' => q{тибет цифрисем},
 				'tirh' => q{тирхута цифрисем},
 				'tnsa' => q{тангса цифрисем},
 				'vaii' => q{вай цифрисем},
 				'wara' => q{варанг-кшити цифрисем},
 				'wcho' => q{ванчо цифрисем},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{Метрикӑлла},
 			'UK' => q{Акӑлчан},
 			'US' => q{Америка},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Чӗлхе: {0}',
 			'script' => 'Ҫырулӑх: {0}',
 			'region' => 'Регион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[{а́} {е́} {и́} {о́} {у́} {ы́} {э́} {ю́} {я́}]},
			index => ['АӐ', 'Б', 'В', 'Г', 'Д', 'ЕӖЁ', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Ҫ', 'Т', 'УӲ', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{[аӑ б в г д еӗё ж з и й к л м н о п р с ҫ т уӳ ф х ц ч ш щ ъ ы ь э ю я]},
			numbers => qr{[\- ‑ , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘‚ "“„ « » ( ) \[ \] \{ \} § @ * / \& #]},
		};
	},
EOT
: sub {
		return { index => ['АӐ', 'Б', 'В', 'Г', 'Д', 'ЕӖЁ', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Ҫ', 'Т', 'УӲ', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{„},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(меби{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(меби{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(теби{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(теби{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(пеби{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(пеби{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(эксби{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(эксби{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(зеби{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(зеби{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(йоби{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(йоби{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(деци{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(деци{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(пико{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(пико{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(фемто{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(фемто{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(атто{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(атто{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(санти{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(санти{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(зепто{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(зепто{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(иокто{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(иокто{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(ронто{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(ронто{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(милли{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(милли{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(квекто{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(квекто{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(микро{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(микро{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(нано{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(нано{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(экса{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(экса{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(гекто{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(гекто{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(зетта{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(зетта{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(иотта{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(иотта{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(ронна{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(ронна{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(кветта{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(кветта{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ирĕклĕн ӳкнин хăвăртланăвĕ),
						'other' => q({0} ирĕклĕн ӳкнин хăвăртланăвĕ),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ирĕклĕн ӳкнин хăвăртланăвĕ),
						'other' => q({0} ирĕклĕн ӳкнин хăвăртланăвĕ),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(тӑваткал ҫеккунтра метр),
						'other' => q(тӑваткал ҫеккунтра {0} метр),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(тӑваткал ҫеккунтра метр),
						'other' => q(тӑваткал ҫеккунтра {0} метр),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(кĕтесле минут),
						'other' => q({0} кĕтесле минут),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(кĕтесле минут),
						'other' => q({0} кĕтесле минут),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(кĕтесле çеккунт),
						'other' => q({0} кĕтесле çеккунт),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(кĕтесле çеккунт),
						'other' => q({0} кĕтесле çеккунт),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(градус),
						'other' => q({0} градус),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(градус),
						'other' => q({0} градус),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(радиан),
						'other' => q({0} радиан),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(радиан),
						'other' => q({0} радиан),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(çавра),
						'other' => q({0} çавра),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(çавра),
						'other' => q({0} çавра),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(акр),
						'other' => q({0} акр),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(акр),
						'other' => q({0} акр),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(дунам),
						'other' => q({0} дунам),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(дунам),
						'other' => q({0} дунам),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(гектар),
						'other' => q({0} гектар),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(гектар),
						'other' => q({0} гектар),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(тӑваткал сантиметр),
						'other' => q({0} тӑваткал сантиметр),
						'per' => q({0}/тӑваткал сантиметр),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(тӑваткал сантиметр),
						'other' => q({0} тӑваткал сантиметр),
						'per' => q({0}/тӑваткал сантиметр),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(тӑваткал фут),
						'other' => q({0} тӑваткал фут),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(тӑваткал фут),
						'other' => q({0} тӑваткал фут),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(тӑваткал дюйм),
						'other' => q({0} тӑваткал дюйм),
						'per' => q({0}/тӑваткал дюйм),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(тӑваткал дюйм),
						'other' => q({0} тӑваткал дюйм),
						'per' => q({0}/тӑваткал дюйм),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(тӑваткал километр),
						'other' => q({0} тӑваткал километр),
						'per' => q({0}/тӑваткал километр),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(тӑваткал километр),
						'other' => q({0} тӑваткал километр),
						'per' => q({0}/тӑваткал километр),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(тӑваткал метр),
						'other' => q({0} тӑваткал метр),
						'per' => q({0}/тӑваткал метр),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(тӑваткал метр),
						'other' => q({0} тӑваткал метр),
						'per' => q({0}/тӑваткал метр),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(тӑваткал миля),
						'other' => q({0} тӑваткал миля),
						'per' => q({0}/тӑваткал миля),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(тӑваткал миля),
						'other' => q({0} тӑваткал миля),
						'per' => q({0}/тӑваткал миля),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(тӑваткал ярд),
						'other' => q({0} тӑваткал ярд),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(тӑваткал ярд),
						'other' => q({0} тӑваткал ярд),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(объект),
						'other' => q({0} объект),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(объект),
						'other' => q({0} объект),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(карат),
						'other' => q({0} карат),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(карат),
						'other' => q({0} карат),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(децилитрӑ миллиграмм),
						'other' => q({0} децилитрӑ миллиграмм),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(децилитрӑ миллиграмм),
						'other' => q({0} децилитрӑ миллиграмм),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(литрлӑх миллимоль),
						'other' => q({0} литрлӑх миллимоль),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(литрлӑх миллимоль),
						'other' => q({0} литрлӑх миллимоль),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(моль),
						'other' => q({0} моль),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(моль),
						'other' => q({0} моль),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(процент),
						'other' => q({0} процент),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(процент),
						'other' => q({0} процент),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(промиллĕ),
						'other' => q({0} промиллĕ),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(промиллĕ),
						'other' => q({0} промиллĕ),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(миллионмĕш пайĕ),
						'other' => q({0} миллионмĕш пайĕ),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(миллионмĕш пайĕ),
						'other' => q({0} миллионмĕш пайĕ),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(промириад),
						'other' => q({0} промириад),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(промириад),
						'other' => q({0} промириад),
					},
					# Long Unit Identifier
					'concentr-portion-per-1e9' => {
						'name' => q(миллиардмĕш пайĕ),
						'other' => q({0} миллиардмĕш пайĕ),
					},
					# Core Unit Identifier
					'portion-per-1e9' => {
						'name' => q(миллиардмĕш пайĕ),
						'other' => q({0} миллиардмĕш пайĕ),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(çĕр километрах литр),
						'other' => q(çĕр километрах {0} литр),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(çĕр километрах литр),
						'other' => q(çĕр километрах {0} литр),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(километрлӑх литр),
						'other' => q(километрлӑх {0} литр),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(километрлӑх литр),
						'other' => q(километрлӑх {0} литр),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(галлон ҫине миля),
						'other' => q({0} галлон ҫине миля),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(галлон ҫине миля),
						'other' => q({0} галлон ҫине миля),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(импери галлон ҫинче миля),
						'other' => q({0} импери галлон ҫинче миля),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(импери галлон ҫинче миля),
						'other' => q({0} импери галлон ҫинче миля),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} хӗвелтухӑҫ тӑрӑхӗ),
						'north' => q({0} ҫурҫӗр тӑрӑхӗ),
						'south' => q({0} кӑнтӑр тӑрӑхӗ),
						'west' => q({0} анăҫ тӑрӑхӗ),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} хӗвелтухӑҫ тӑрӑхӗ),
						'north' => q({0} ҫурҫӗр тӑрӑхӗ),
						'south' => q({0} кӑнтӑр тӑрӑхӗ),
						'west' => q({0} анăҫ тӑрӑхӗ),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(бит),
						'other' => q({0} бит),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(бит),
						'other' => q({0} бит),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(байт),
						'other' => q({0} байт),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(байт),
						'other' => q({0} байт),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(гигабит),
						'other' => q({0} гигабит),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(гигабит),
						'other' => q({0} гигабит),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(гигабайт),
						'other' => q({0} гигабайт),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(гигабайт),
						'other' => q({0} гигабайт),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(килобит),
						'other' => q({0} килобит),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(килобит),
						'other' => q({0} килобит),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(килобайт),
						'other' => q({0} килобайт),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(килобайт),
						'other' => q({0} килобайт),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(мегабит),
						'other' => q({0} мегабит),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(мегабит),
						'other' => q({0} мегабит),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(мегабайт),
						'other' => q({0} мегабайт),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(мегабайт),
						'other' => q({0} мегабайт),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(петабайт),
						'other' => q({0} петабайт),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(петабайт),
						'other' => q({0} петабайт),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(терабит),
						'other' => q({0} терабит),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(терабит),
						'other' => q({0} терабит),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(терабайт),
						'other' => q({0} терабайт),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(терабайт),
						'other' => q({0} терабайт),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ӗмӗрсем),
						'other' => q({0} ӗмӗрсем),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ӗмӗрсем),
						'other' => q({0} ӗмӗрсем),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(кун),
						'other' => q({0} кун),
						'per' => q({0} кунне),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(кун),
						'other' => q({0} кун),
						'per' => q({0} кунне),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(вунҫуллӑх),
						'other' => q({0} вунҫуллӑх),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(вунҫуллӑх),
						'other' => q({0} вунҫуллӑх),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(сехет),
						'other' => q({0} сехет),
						'per' => q({0} сехетре),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(сехет),
						'other' => q({0} сехет),
						'per' => q({0} сехетре),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(микроҫеккунт),
						'other' => q({0} микроҫеккунт),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(микроҫеккунт),
						'other' => q({0} микроҫеккунт),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(миллиҫеккунт),
						'other' => q({0} миллиҫеккунт),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(миллиҫеккунт),
						'other' => q({0} миллиҫеккунт),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(минут),
						'other' => q({0} минут),
						'per' => q({0} минутра),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(минут),
						'other' => q({0} минут),
						'per' => q({0} минутра),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(уйăхсем),
						'other' => q({0} уйӑхсем),
						'per' => q({0}/уйӑх),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(уйăхсем),
						'other' => q({0} уйӑхсем),
						'per' => q({0}/уйӑх),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(наноҫеккунт),
						'other' => q({0} наноҫеккунт),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(наноҫеккунт),
						'other' => q({0} наноҫеккунт),
					},
					# Long Unit Identifier
					'duration-night' => {
						'name' => q(ҫӗрсем),
						'other' => q({0} ҫӗрсем),
						'per' => q({0}/ҫӗр),
					},
					# Core Unit Identifier
					'night' => {
						'name' => q(ҫӗрсем),
						'other' => q({0} ҫӗрсем),
						'per' => q({0}/ҫӗр),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(чӗрӗк),
						'other' => q({0} чӗрӗк),
						'per' => q({0}/чӗрӗк),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(чӗрӗк),
						'other' => q({0} чӗрӗк),
						'per' => q({0}/чӗрӗк),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ҫеккунт),
						'other' => q({0} ҫеккунт),
						'per' => q({0}/ҫеккунтра),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ҫеккунт),
						'other' => q({0} ҫеккунт),
						'per' => q({0}/ҫеккунтра),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(эрне),
						'other' => q({0} эрне),
						'per' => q({0}/эрнере),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(эрне),
						'other' => q({0} эрне),
						'per' => q({0}/эрнере),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ҫулталӑксем),
						'other' => q({0} ҫулталӑксем),
						'per' => q({0} ҫулталӑкра),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ҫулталӑксем),
						'other' => q({0} ҫулталӑксем),
						'per' => q({0} ҫулталӑкра),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(ампер),
						'other' => q({0} ампер),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(ампер),
						'other' => q({0} ампер),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(миллиампер),
						'other' => q({0} миллиампер),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(миллиампер),
						'other' => q({0} миллиампер),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ом),
						'other' => q({0} ом),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ом),
						'other' => q({0} ом),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(вольт),
						'other' => q({0} вольт),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(вольт),
						'other' => q({0} вольт),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(британи ӑшӑ единици),
						'other' => q({0} британи ӑшӑ единици),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(британи ӑшӑ единици),
						'other' => q({0} британи ӑшӑ единици),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(калори),
						'other' => q({0} калори),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(калори),
						'other' => q({0} калори),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(электронвольт),
						'other' => q({0} электронвольт),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(электронвольт),
						'other' => q({0} электронвольт),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(джоуль),
						'other' => q({0} джоуль),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(джоуль),
						'other' => q({0} джоуль),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(килокалори),
						'other' => q({0} килокалори),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(килокалори),
						'other' => q({0} килокалори),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(килоджоуль),
						'other' => q({0} килоджоуль),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(килоджоуль),
						'other' => q({0} килоджоуль),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(киловатт-сехет),
						'other' => q({0} киловатт-сехет),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(киловатт-сехет),
						'other' => q({0} киловатт-сехет),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(америка терм),
						'other' => q({0} америка терм),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(америка терм),
						'other' => q({0} америка терм),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(çĕр километрах киловатт-сехет),
						'other' => q(çĕр километрах {0} киловатт-сехет),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(çĕр километрах киловатт-сехет),
						'other' => q(çĕр километрах {0} киловатт-сехет),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(ньютон),
						'other' => q({0} ньютон),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(ньютон),
						'other' => q({0} ньютон),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(кĕренке-вăй),
						'other' => q({0} кĕренке-вăй),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(кĕренке-вăй),
						'other' => q({0} кĕренке-вăй),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(гигагерц),
						'other' => q({0} гигагерц),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(гигагерц),
						'other' => q({0} гигагерц),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(герц),
						'other' => q({0} герц),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(герц),
						'other' => q({0} герц),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(килогерц),
						'other' => q({0} килогерц),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(килогерц),
						'other' => q({0} килогерц),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(мегагерц),
						'other' => q({0} мегагерц),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(мегагерц),
						'other' => q({0} мегагерц),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(эм),
						'other' => q({0} эм),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(эм),
						'other' => q({0} эм),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(мегапиксельсем),
						'other' => q({0} Мпкс),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(мегапиксельсем),
						'other' => q({0} Мпкс),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(пиксельсем),
						'other' => q({0} пиксельсем),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(пиксельсем),
						'other' => q({0} пиксельсем),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(сантиметрпалан пиксель тачӑлӑхӗ),
						'other' => q({0} сантиметрпалан пиксель тачӑлӑхӗ),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(сантиметрпалан пиксель тачӑлӑхӗ),
						'other' => q({0} сантиметрпалан пиксель тачӑлӑхӗ),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(дюймпалан пиксель тачӑлӑхӗ),
						'other' => q({0} дюймпалан пиксель тачӑлӑхӗ),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(дюймпалан пиксель тачӑлӑхӗ),
						'other' => q({0} дюймпалан пиксель тачӑлӑхӗ),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(астрономилле пĕрчĕ),
						'other' => q({0} астрономилле пĕрчĕ),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(астрономилле пĕрчĕ),
						'other' => q({0} астрономилле пĕрчĕ),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(сантиметр),
						'other' => q({0} сантиметр),
						'per' => q({0}/сантиметр),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(сантиметр),
						'other' => q({0} сантиметр),
						'per' => q({0}/сантиметр),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(дециметр),
						'other' => q({0} дециметр),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(дециметр),
						'other' => q({0} дециметр),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(ҫӗр радиусӗ),
						'other' => q({0} ҫӗр радиусӗ),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(ҫӗр радиусӗ),
						'other' => q({0} ҫӗр радиусӗ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(тинӗс чалӑш),
						'other' => q({0} тинӗс чалӑш),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(тинӗс чалӑш),
						'other' => q({0} тинӗс чалӑш),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(фурлонгсем),
						'other' => q({0} фурлонгсем),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(фурлонгсем),
						'other' => q({0} фурлонгсем),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(километр),
						'other' => q({0} км),
						'per' => q({0}/километр),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(километр),
						'other' => q({0} км),
						'per' => q({0}/километр),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(çуттăн çулĕ),
						'other' => q({0} çуттăн çулĕ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(çуттăн çулĕ),
						'other' => q({0} çуттăн çулĕ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(метр),
						'other' => q({0} метр),
						'per' => q({0}/метр),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(метр),
						'other' => q({0} метр),
						'per' => q({0}/метр),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(микрометр),
						'other' => q({0}микрометр),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(микрометр),
						'other' => q({0}микрометр),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(миля),
						'other' => q({0} миля),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(миля),
						'other' => q({0} миля),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(скандинави милли),
						'other' => q({0} скандинави милли),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(скандинави милли),
						'other' => q({0} скандинави милли),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(миллиметр),
						'other' => q({0} миллиметр),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(миллиметр),
						'other' => q({0} миллиметр),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(нанометр),
						'other' => q({0} нанометр),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(нанометр),
						'other' => q({0} нанометр),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(тинӗс милли),
						'other' => q({0} тинӗс милли),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(тинӗс милли),
						'other' => q({0} тинӗс милли),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(парçек),
						'other' => q({0} парçек),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(парçек),
						'other' => q({0} парçек),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пикометр),
						'other' => q({0} пикометр),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пикометр),
						'other' => q({0} пикометр),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(типографи пункчӗ),
						'other' => q({0} типографи пункчӗ),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(типографи пункчӗ),
						'other' => q({0} типографи пункчӗ),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(хӗвел радиусӗ),
						'other' => q({0} хӗвел радиусӗ),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(хӗвел радиусӗ),
						'other' => q({0} хӗвел радиусӗ),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ярд),
						'other' => q({0} ярд),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ярд),
						'other' => q({0} ярд),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(кандела),
						'other' => q({0} кандела),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(кандела),
						'other' => q({0} кандела),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(люмен),
						'other' => q({0} люмен),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(люмен),
						'other' => q({0} люмен),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(люкс),
						'other' => q({0} люкс),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(люкс),
						'other' => q({0} люкс),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(хĕвел çутатаслăхĕ),
						'other' => q({0} хĕвел çутатаслăхĕ),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(хĕвел çутатаслăхĕ),
						'other' => q({0} хĕвел çутатаслăхĕ),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(метрикăлла карат),
						'other' => q({0} метрикăлла карат),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(метрикăлла карат),
						'other' => q({0} метрикăлла карат),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(массăн атомла пĕрчи),
						'other' => q({0} массăн атомла пĕрчи),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(массăн атомла пĕрчи),
						'other' => q({0} массăн атомла пĕрчи),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(Ҫӗр масси),
						'other' => q({0} Ҫӗр масси),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(Ҫӗр масси),
						'other' => q({0} Ҫӗр масси),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(гран),
						'other' => q({0} гран),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(гран),
						'other' => q({0} гран),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(грамм),
						'other' => q({0} грамм),
						'per' => q({0}/грамм),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(грамм),
						'other' => q({0} грамм),
						'per' => q({0}/грамм),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(килограмм),
						'other' => q({0} килограмм),
						'per' => q({0}/килограмм),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(килограмм),
						'other' => q({0} килограмм),
						'per' => q({0}/килограмм),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(микрограмм),
						'other' => q({0} микрограмм),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(микрограмм),
						'other' => q({0} микрограмм),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(миллиграмм),
						'other' => q({0} миллиграмм),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(миллиграмм),
						'other' => q({0} миллиграмм),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(унци),
						'other' => q({0} унци),
						'per' => q({0}/унци),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(унци),
						'other' => q({0} унци),
						'per' => q({0}/унци),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(трой унци),
						'other' => q({0} трой унци),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(трой унци),
						'other' => q({0} трой унци),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(кĕренке),
						'other' => q({0} кĕренке),
						'per' => q({0}/кĕренке),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(кĕренке),
						'other' => q({0} кĕренке),
						'per' => q({0}/кĕренке),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(Хӗвел масси),
						'other' => q({0} Хӗвел масси),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(Хӗвел масси),
						'other' => q({0} Хӗвел масси),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(стоун),
						'other' => q({0} стоун),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(стоун),
						'other' => q({0} стоун),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(америка тонна),
						'other' => q({0} америка тонна),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(америка тонна),
						'other' => q({0} америка тонна),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(метрикăлла тонна),
						'other' => q({0} метрикăлла тонна),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(метрикăлла тонна),
						'other' => q({0} метрикăлла тонна),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(гигаватт),
						'other' => q({0} гигаватт),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(гигаватт),
						'other' => q({0} гигаватт),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(лаша вӑйӗ),
						'other' => q({0} лаша вӑйӗ),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(лаша вӑйӗ),
						'other' => q({0} лаша вӑйӗ),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(киловатт),
						'other' => q({0} киловатт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(киловатт),
						'other' => q({0} киловатт),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(мегаватт),
						'other' => q({0} мегаватт),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(мегаватт),
						'other' => q({0} мегаватт),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(милливатт),
						'other' => q({0} милливатт),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(милливатт),
						'other' => q({0} милливатт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ватт),
						'other' => q({0} ватт),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ватт),
						'other' => q({0} ватт),
					},
					# Long Unit Identifier
					'power2' => {
						'other' => q(тӑваткал {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'other' => q(тӑваткал {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'other' => q(кубла {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'other' => q(кубла {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(физикăлла атмосфера),
						'other' => q({0} физикăлла атмосфера),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(физикăлла атмосфера),
						'other' => q({0} физикăлла атмосфера),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(бар),
						'other' => q({0} бар),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(бар),
						'other' => q({0} бар),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(гектопаскаль),
						'other' => q({0} гектопаскаль),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(гектопаскаль),
						'other' => q({0} гектопаскаль),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(чĕркĕмĕл юпи дюйм),
						'other' => q(чĕркĕмĕл юпи {0} дюйм),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(чĕркĕмĕл юпи дюйм),
						'other' => q(чĕркĕмĕл юпи {0} дюйм),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(килопаскаль),
						'other' => q({0} килопаскаль),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(килопаскаль),
						'other' => q({0} килопаскаль),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(мегапаскаль),
						'other' => q({0} мегапаскаль),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(мегапаскаль),
						'other' => q({0} мегапаскаль),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(миллибар),
						'other' => q({0} миллибар),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(миллибар),
						'other' => q({0} миллибар),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(чĕркĕмĕл юпи миллиметр),
						'other' => q(чĕркĕмĕл юпи {0} миллиметр),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(чĕркĕмĕл юпи миллиметр),
						'other' => q(чĕркĕмĕл юпи {0} миллиметр),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(паскаль),
						'other' => q({0} паскаль),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(паскаль),
						'other' => q({0} паскаль),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(тӑваткал дюйм кӗренке),
						'other' => q(тӑваткал дюйм {0} кӗренке),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(тӑваткал дюйм кӗренке),
						'other' => q(тӑваткал дюйм {0} кӗренке),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(Бофорт шкали ҫинчи балл),
						'other' => q({0} Бофорт шкали ҫинчи балл),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(Бофорт шкали ҫинчи балл),
						'other' => q({0} Бофорт шкали ҫинчи балл),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(сехетре километр),
						'other' => q(сехетре {0} километр),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(сехетре километр),
						'other' => q(сехетре {0} километр),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(тĕвĕ),
						'other' => q({0} тĕвĕ),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(тĕвĕ),
						'other' => q({0} тĕвĕ),
					},
					# Long Unit Identifier
					'speed-light-speed' => {
						'name' => q(ҫутӑ хӑвӑртлӑхӗ),
						'other' => q({0} ҫутӑ хӑвӑртлӑхӗ),
					},
					# Core Unit Identifier
					'light-speed' => {
						'name' => q(ҫутӑ хӑвӑртлӑхӗ),
						'other' => q({0} ҫутӑ хӑвӑртлӑхӗ),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(ҫеккунтра метр),
						'other' => q(ҫеккунтра {0} метр),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(ҫеккунтра метр),
						'other' => q(ҫеккунтра {0} метр),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(сехетре миля),
						'other' => q(сехетре {0} миля),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(сехетре миля),
						'other' => q(сехетре {0} миля),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(Цельсий градусĕ),
						'other' => q({0} Цельсий градусĕ),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(Цельсий градусĕ),
						'other' => q({0} Цельсий градусĕ),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(Фаренгейт градусĕ),
						'other' => q({0} Фаренгейт градусĕ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(Фаренгейт градусĕ),
						'other' => q({0} Фаренгейт градусĕ),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(Кельвин),
						'other' => q({0} Кельвин),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(Кельвин),
						'other' => q({0} Кельвин),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(ньютон-метр),
						'other' => q({0} ньютон-метр),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(ньютон-метр),
						'other' => q({0} ньютон-метр),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(кĕренке-фут),
						'other' => q({0} кĕренке-фут),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(кĕренке-фут),
						'other' => q({0} кĕренке-фут),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(акр-фут),
						'other' => q({0} акр-фут),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(акр-фут),
						'other' => q({0} акр-фут),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(баррель),
						'other' => q({0} баррель),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(баррель),
						'other' => q({0} баррель),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(бушел),
						'other' => q({0} бушел),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(бушел),
						'other' => q({0} бушел),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(сантилитр),
						'other' => q({0} сантилитр),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(сантилитр),
						'other' => q({0} сантилитр),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(кубла сантиметр),
						'other' => q({0} кубла сантиметр),
						'per' => q({0}/кубла сантиметр),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(кубла сантиметр),
						'other' => q({0} кубла сантиметр),
						'per' => q({0}/кубла сантиметр),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(кубла фут),
						'other' => q({0} кубла фут),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(кубла фут),
						'other' => q({0} кубла фут),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(кубла дюйм),
						'other' => q({0} кубла дюйм),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(кубла дюйм),
						'other' => q({0} кубла дюйм),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(кубла километр),
						'other' => q({0} кубла километр),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(кубла километр),
						'other' => q({0} кубла километр),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(кубла метр),
						'other' => q({0} кубла метр),
						'per' => q({0}/кубла метр),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(кубла метр),
						'other' => q({0} кубла метр),
						'per' => q({0}/кубла метр),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(кубла милли),
						'other' => q({0} кубла милли),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(кубла милли),
						'other' => q({0} кубла милли),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(кубла ярд),
						'other' => q({0} кубла ярд),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(кубла ярд),
						'other' => q({0} кубла ярд),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(чашӑк),
						'other' => q({0} чашӑк),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(чашӑк),
						'other' => q({0} чашӑк),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(курка-метрлӑ),
						'other' => q({0} курка-метрлӑ),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(курка-метрлӑ),
						'other' => q({0} курка-метрлӑ),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(децилитр),
						'other' => q({0} децилитр),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(децилитр),
						'other' => q({0} децилитр),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(пылак апат кашӑкӗ),
						'other' => q({0} пылак апат кашӑкӗ),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(пылак апат кашӑкӗ),
						'other' => q({0} пылак апат кашӑкӗ),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(импери пылак апат кашӑкӗ),
						'other' => q({0} импери пылак апат кашӑкӗ),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(импери пылак апат кашӑкӗ),
						'other' => q({0} импери пылак апат кашӑкӗ),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(шĕвĕ драхма),
						'other' => q({0} шĕвĕ драхма),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(шĕвĕ драхма),
						'other' => q({0} шĕвĕ драхма),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(тумлам),
						'other' => q({0} тумлам),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(тумлам),
						'other' => q({0} тумлам),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(шӗвӗ унци),
						'other' => q({0} шӗвӗ унци),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(шӗвӗ унци),
						'other' => q({0} шӗвӗ унци),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(импери шӗвӗ унци),
						'other' => q({0} импери шӗвӗ унци),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(импери шӗвӗ унци),
						'other' => q({0} импери шӗвӗ унци),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(галлон),
						'other' => q({0} галлон),
						'per' => q({0}/галлон),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(галлон),
						'other' => q({0} галлон),
						'per' => q({0}/галлон),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(импери галлон),
						'other' => q({0} импери галлон),
						'per' => q({0}/импери галлон),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(импери галлон),
						'other' => q({0} импери галлон),
						'per' => q({0}/импери галлон),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(гектолитр),
						'other' => q({0} гектолитр),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(гектолитр),
						'other' => q({0} гектолитр),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(чӗркке),
						'other' => q({0} чӗркке),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(чӗркке),
						'other' => q({0} чӗркке),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(литр),
						'other' => q({0} литр),
						'per' => q({0}/литр),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(литр),
						'other' => q({0} литр),
						'per' => q({0}/литр),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(мегалитр),
						'other' => q({0} мегалитр),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(мегалитр),
						'other' => q({0} мегалитр),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(миллилитр),
						'other' => q({0} миллилитр),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(миллилитр),
						'other' => q({0} миллилитр),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(чĕптĕм),
						'other' => q({0} чĕптĕм),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(чĕптĕм),
						'other' => q({0} чĕптĕм),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(пинт),
						'other' => q({0} пинт),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(пинт),
						'other' => q({0} пинт),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(пинт-метрлӑ),
						'other' => q({0} пинт-метрлӑ),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(пинт-метрлӑ),
						'other' => q({0} пинт-метрлӑ),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(кварт),
						'other' => q({0} кварт),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(кварт),
						'other' => q({0} кварт),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(импери кварт),
						'other' => q({0} импери кварт),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(импери кварт),
						'other' => q({0} импери кварт),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(апат кашӑкӗ),
						'other' => q({0} апат кашӑкӗ),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(апат кашӑкӗ),
						'other' => q({0} апат кашӑкӗ),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(чей кашӑкӗ),
						'other' => q({0} чей кашӑкӗ),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(чей кашӑкӗ),
						'other' => q({0} чей кашӑкӗ),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Ки{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Ки{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Ми{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Ми{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Ги{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Ги{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ти{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ти{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Пи{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Пи{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Эи{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Эи{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Зи{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Зи{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Йи{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Йи{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(д{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(д{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(п{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(п{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ф{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ф{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(а{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(а{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(с{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(с{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(з{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(з{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(и{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(и{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(р{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(р{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(м{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(м{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(кв{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(кв{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(мк{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(мк{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(н{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(н{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(Э{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(Э{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(И{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(И{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(Р{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(Р{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(Кв{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(Кв{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(g),
						'other' => q({0}g),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(g),
						'other' => q({0}g),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(м/ҫ²),
						'other' => q({0} м/ҫ²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(м/ҫ²),
						'other' => q({0} м/ҫ²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(минут),
						'other' => q({0} минут),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(минут),
						'other' => q({0} минут),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(çеккунт),
						'other' => q({0} çеккунт),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(çеккунт),
						'other' => q({0} çеккунт),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(градус),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(градус),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(рад),
						'other' => q({0} рад),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(рад),
						'other' => q({0} рад),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(çавра),
						'other' => q({0} çавра),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(çавра),
						'other' => q({0} çавра),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(акр),
						'other' => q({0} акр),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(акр),
						'other' => q({0} акр),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(дунам),
						'other' => q({0} дунам),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(дунам),
						'other' => q({0} дунам),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(га),
						'other' => q({0} га),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(га),
						'other' => q({0} га),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(фт²),
						'other' => q({0} фт²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(фт²),
						'other' => q({0} фт²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(дюйм²),
						'other' => q({0} дюйм²),
						'per' => q({0}/дюйм²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(дюйм²),
						'other' => q({0} дюйм²),
						'per' => q({0}/дюйм²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(ми²),
						'other' => q({0} ми²),
						'per' => q({0}/ми²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(ми²),
						'other' => q({0} ми²),
						'per' => q({0}/ми²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(ярд²),
						'other' => q({0} ярд²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(ярд²),
						'other' => q({0} ярд²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(объект),
						'other' => q({0} объект),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(объект),
						'other' => q({0} объект),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(кар),
						'other' => q({0} кар),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(кар),
						'other' => q({0} кар),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(мг/дл),
						'other' => q({0} мг/дл),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(мг/дл),
						'other' => q({0} мг/дл),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(моль),
						'other' => q({0} моль),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(моль),
						'other' => q({0} моль),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(л/100 км),
						'other' => q({0} л/100 км),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(л/100 км),
						'other' => q({0} л/100 км),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(л/км),
						'other' => q({0} л/км),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(л/км),
						'other' => q({0} л/км),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ми/гал),
						'other' => q({0} ми/гал),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ми/гал),
						'other' => q({0} ми/гал),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ми/имп. гал),
						'other' => q({0} ми/имп. гал),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ми/имп. гал),
						'other' => q({0} ми/имп. гал),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(бит),
						'other' => q({0} бит),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(бит),
						'other' => q({0} бит),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(Б),
						'other' => q({0} Б),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(Б),
						'other' => q({0} Б),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Гбит),
						'other' => q({0} Гбит),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Гбит),
						'other' => q({0} Гбит),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(Гб),
						'other' => q({0} Гб),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(Гб),
						'other' => q({0} Гб),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(кбит),
						'other' => q({0} кбит),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(кбит),
						'other' => q({0} кбит),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(Кб),
						'other' => q({0} Кб),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(Кб),
						'other' => q({0} Кб),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Мбит),
						'other' => q({0} Мбит),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Мбит),
						'other' => q({0} Мбит),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(Мб),
						'other' => q({0} Мб),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(Мб),
						'other' => q({0} Мб),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(Пб),
						'other' => q({0} Пб),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(Пб),
						'other' => q({0} Пб),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Тбит),
						'other' => q({0} Тбит),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Тбит),
						'other' => q({0} Тбит),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(Тб),
						'other' => q({0} Тб),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(Тб),
						'other' => q({0} Тб),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ӗмӗр),
						'other' => q({0} ӗмӗр),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ӗмӗр),
						'other' => q({0} ӗмӗр),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(к.),
						'other' => q({0} к.),
						'per' => q({0}/к.),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(к.),
						'other' => q({0} к.),
						'per' => q({0}/к.),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(внҫл),
						'other' => q({0} внҫл),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(внҫл),
						'other' => q({0} внҫл),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(схт),
						'other' => q({0} схт),
						'per' => q({0}/схт),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(схт),
						'other' => q({0} схт),
						'per' => q({0}/схт),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(мкҫ),
						'other' => q({0} мкҫ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(мкҫ),
						'other' => q({0} мкҫ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(мҫ),
						'other' => q({0} мҫ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(мҫ),
						'other' => q({0} мҫ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(уйӑх),
						'other' => q({0} уйӑх),
						'per' => q({0}/уйӑх),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(уйӑх),
						'other' => q({0} уйӑх),
						'per' => q({0}/уйӑх),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(нҫ),
						'other' => q({0} нҫ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(нҫ),
						'other' => q({0} нҫ),
					},
					# Long Unit Identifier
					'duration-night' => {
						'name' => q(ҫрсм),
						'other' => q({0} ҫрсм),
						'per' => q({0}/ҫӗр),
					},
					# Core Unit Identifier
					'night' => {
						'name' => q(ҫрсм),
						'other' => q({0} ҫрсм),
						'per' => q({0}/ҫӗр),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(чрк),
						'other' => q({0} чрк),
						'per' => q({0}/чрк),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(чрк),
						'other' => q({0} чрк),
						'per' => q({0}/чрк),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ҫ),
						'other' => q({0} ҫ),
						'per' => q({0}/ҫ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ҫ),
						'other' => q({0} ҫ),
						'per' => q({0}/ҫ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(эрн.),
						'other' => q({0} эрн.),
						'per' => q({0}/эрн.),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(эрн.),
						'other' => q({0} эрн.),
						'per' => q({0}/эрн.),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ҫул.),
						'other' => q({0} ҫул.),
						'per' => q({0}/ҫул),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ҫул.),
						'other' => q({0} ҫул.),
						'per' => q({0}/ҫул),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(А),
						'other' => q({0} А),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(А),
						'other' => q({0} А),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(мА),
						'other' => q({0} мА),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(мА),
						'other' => q({0} мА),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(Ом),
						'other' => q({0} Ом),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(Ом),
						'other' => q({0} Ом),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(В),
						'other' => q({0} В),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(В),
						'other' => q({0} В),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(БӐЕ),
						'other' => q({0} БӐЕ),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(БӐЕ),
						'other' => q({0} БӐЕ),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(кал),
						'other' => q({0} кал),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(кал),
						'other' => q({0} кал),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(эВ),
						'other' => q({0} эВ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(эВ),
						'other' => q({0} эВ),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(Дж),
						'other' => q({0} Дж),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(Дж),
						'other' => q({0} Дж),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(ккал),
						'other' => q({0} ккал),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(ккал),
						'other' => q({0} ккал),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(кДж),
						'other' => q({0} кДж),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(кДж),
						'other' => q({0} кДж),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(КВт⋅схт),
						'other' => q({0} КВт⋅схт),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(КВт⋅схт),
						'other' => q({0} КВт⋅схт),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(АПШ терм),
						'other' => q({0} АПШ терм),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(АПШ терм),
						'other' => q({0} АПШ терм),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(кВт⋅ч/100 км),
						'other' => q({0} кВт⋅ч/100 км),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(кВт⋅ч/100 км),
						'other' => q({0} кВт⋅ч/100 км),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(Н),
						'other' => q({0} Н),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(Н),
						'other' => q({0} Н),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(крнк-вăй),
						'other' => q({0} крнк-вăй),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(крнк-вăй),
						'other' => q({0} крнк-вăй),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(ГГц),
						'other' => q({0} ГГц),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(ГГц),
						'other' => q({0} ГГц),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Гц),
						'other' => q({0} Гц),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Гц),
						'other' => q({0} Гц),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(кГц),
						'other' => q({0} кГц),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(кГц),
						'other' => q({0} кГц),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(МГц),
						'other' => q({0} МГц),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(МГц),
						'other' => q({0} МГц),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(эм),
						'other' => q({0} эм),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(эм),
						'other' => q({0} эм),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(Мпкс),
						'other' => q({0} Мпкс),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(Мпкс),
						'other' => q({0} Мпкс),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(пкс),
						'other' => q({0} пкс),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(пкс),
						'other' => q({0} пкс),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(пкс/см),
						'other' => q({0} пкс/см),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(пкс/см),
						'other' => q({0} пкс/см),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(пкс/дюйм),
						'other' => q({0} пкс/дюйм),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(пкс/дюйм),
						'other' => q({0} пкс/дюйм),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(а.п.),
						'other' => q({0} а.п.),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(а.п.),
						'other' => q({0} а.п.),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(дм),
						'other' => q({0} дм),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(дм),
						'other' => q({0} дм),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(ҫӗр р-сӗ),
						'other' => q({0} ҫӗр р-сӗ),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(ҫӗр р-сӗ),
						'other' => q({0} ҫӗр р-сӗ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(тнс.члш.),
						'other' => q({0} тнс.члш.),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(тнс.члш.),
						'other' => q({0} тнс.члш.),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(фт),
						'other' => q({0} фт),
						'per' => q({0}/фт),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(фт),
						'other' => q({0} фт),
						'per' => q({0}/фт),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(фрл),
						'other' => q({0} фрл),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(фрл),
						'other' => q({0} фрл),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ç.ç.),
						'other' => q({0} ç.ç.),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ç.ç.),
						'other' => q({0} ç.ç.),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(мкм),
						'other' => q({0} мкм),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(мкм),
						'other' => q({0} мкм),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ми),
						'other' => q({0} ми),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ми),
						'other' => q({0} ми),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(ск.ми),
						'other' => q({0} ск.ми),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(ск.ми),
						'other' => q({0} ск.ми),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(мм),
						'other' => q({0} мм),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(мм),
						'other' => q({0} мм),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(нм),
						'other' => q({0} нм),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(нм),
						'other' => q({0} нм),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(тнс.ми),
						'other' => q({0} тнс.ми),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(тнс.ми),
						'other' => q({0} тнс.ми),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(пк),
						'other' => q({0} пк),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(пк),
						'other' => q({0} пк),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пм),
						'other' => q({0} пм),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пм),
						'other' => q({0} пм),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(пкт),
						'other' => q({0} пкт),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(пкт),
						'other' => q({0} пкт),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(хӗвел р-с),
						'other' => q({0} хӗвел р-с),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(хӗвел р-с),
						'other' => q({0} хӗвел р-с),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ярд),
						'other' => q({0} ярд),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ярд),
						'other' => q({0} ярд),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(кд),
						'other' => q({0} кд),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(кд),
						'other' => q({0} кд),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(лм),
						'other' => q({0} лм),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(лм),
						'other' => q({0} лм),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(лк),
						'other' => q({0} лк),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(лк),
						'other' => q({0} лк),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(кар),
						'other' => q({0} кар),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(кар),
						'other' => q({0} кар),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(Да),
						'other' => q({0} Да),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(Да),
						'other' => q({0} Да),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(Ҫӗр масси),
						'other' => q({0} Ҫӗр масси),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(Ҫӗр масси),
						'other' => q({0} Ҫӗр масси),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(гран),
						'other' => q({0} гран),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(гран),
						'other' => q({0} гран),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(мкг),
						'other' => q({0} мкг),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(мкг),
						'other' => q({0} мкг),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(мг),
						'other' => q({0} мг),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(мг),
						'other' => q({0} мг),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(унц.),
						'other' => q({0} унц.),
						'per' => q({0}/унц.),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(унц.),
						'other' => q({0} унц.),
						'per' => q({0}/унц.),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(тр. унц.),
						'other' => q({0} тр. унц.),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(тр. унц.),
						'other' => q({0} тр. унц.),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(крнк),
						'other' => q({0} крнк),
						'per' => q({0}/крнк),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(крнк),
						'other' => q({0} крнк),
						'per' => q({0}/крнк),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(Хӗвел масси),
						'other' => q({0} Хӗвел масси),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(Хӗвел масси),
						'other' => q({0} Хӗвел масси),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(стн),
						'other' => q({0} стн),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(стн),
						'other' => q({0} стн),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(амер. т),
						'other' => q({0} амер. т),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(амер. т),
						'other' => q({0} амер. т),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(т),
						'other' => q({0} т),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(т),
						'other' => q({0} т),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(ГВт),
						'other' => q({0} ГВт),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(ГВт),
						'other' => q({0} ГВт),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(л.в.),
						'other' => q({0} л.в.),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(л.в.),
						'other' => q({0} л.в.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(КВт),
						'other' => q({0} КВт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(КВт),
						'other' => q({0} КВт),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(Мвт),
						'other' => q({0} МВт),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(Мвт),
						'other' => q({0} МВт),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(мВт),
						'other' => q({0} мВт),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(мВт),
						'other' => q({0} мВт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(Вт),
						'other' => q({0} Вт),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(Вт),
						'other' => q({0} Вт),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(атм),
						'other' => q({0} атм),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(атм),
						'other' => q({0} атм),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(бар),
						'other' => q({0} бар),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(бар),
						'other' => q({0} бар),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(гПа),
						'other' => q({0} гПа),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(гПа),
						'other' => q({0} гПа),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ч.ю. дюйм),
						'other' => q(ч.ю. {0} дюйм),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ч.ю. дюйм),
						'other' => q(ч.ю. {0} дюйм),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(кПа),
						'other' => q({0} кПа),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(кПа),
						'other' => q({0} кПа),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(МПа),
						'other' => q({0} МПа),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(МПа),
						'other' => q({0} МПа),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(мбар),
						'other' => q({0} мбар),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(мбар),
						'other' => q({0} мбар),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(ч.ю. мм),
						'other' => q(ч.ю. {0} мм),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(ч.ю. мм),
						'other' => q(ч.ю. {0} мм),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(Па),
						'other' => q({0} Па),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(Па),
						'other' => q({0} Па),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(дюйм² крнк),
						'other' => q(дюйм² {0} крнк),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(дюйм² крнк),
						'other' => q(дюйм² {0} крнк),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(Бфт),
						'other' => q({0} Бфт),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(Бфт),
						'other' => q({0} Бфт),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(км/схт),
						'other' => q({0} км/схт),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(км/схт),
						'other' => q({0} км/схт),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(тĕвĕ),
						'other' => q({0} тĕвĕ),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(тĕвĕ),
						'other' => q({0} тĕвĕ),
					},
					# Long Unit Identifier
					'speed-light-speed' => {
						'name' => q(ҫутӑ хврт),
						'other' => q({0} ҫутӑ хврт),
					},
					# Core Unit Identifier
					'light-speed' => {
						'name' => q(ҫутӑ хврт),
						'other' => q({0} ҫутӑ хврт),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(м/ҫ),
						'other' => q({0} м/ҫ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(м/ҫ),
						'other' => q({0} м/ҫ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ми/схт),
						'other' => q({0} ми/схт),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ми/схт),
						'other' => q({0} ми/схт),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(К),
						'other' => q({0} К),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(К),
						'other' => q({0} К),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(Н⋅м),
						'other' => q({0} Н⋅м),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(Н⋅м),
						'other' => q({0} Н⋅м),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(крнк-фт),
						'other' => q({0} крнк-фт),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(крнк-фт),
						'other' => q({0} крнк-фт),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(акр-фт),
						'other' => q({0} акр-фт),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(акр-фт),
						'other' => q({0} акр-фт),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(барр.),
						'other' => q({0} барр.),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(барр.),
						'other' => q({0} барр.),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(буш.),
						'other' => q({0} буш.),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(буш.),
						'other' => q({0} буш.),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(сл),
						'other' => q({0} сл),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(сл),
						'other' => q({0} сл),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(см³),
						'other' => q({0} см³),
						'per' => q({0}/см³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(см³),
						'other' => q({0} см³),
						'per' => q({0}/см³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(фт³),
						'other' => q({0} фт³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(фт³),
						'other' => q({0} фт³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(дюйм³),
						'other' => q({0} дюйм³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(дюйм³),
						'other' => q({0} дюйм³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(км³),
						'other' => q({0} км³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(км³),
						'other' => q({0} км³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ми³),
						'other' => q({0} ми³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ми³),
						'other' => q({0} ми³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(ярд³),
						'other' => q({0} ярд³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(ярд³),
						'other' => q({0} ярд³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(чашӑк),
						'other' => q({0} чашӑк),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(чашӑк),
						'other' => q({0} чашӑк),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(крк-мтрл),
						'other' => q({0} крк-мтрл),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(крк-мтрл),
						'other' => q({0} крк-мтрл),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(дл),
						'other' => q({0} дл),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(дл),
						'other' => q({0} дл),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(плк.апат кшк.),
						'other' => q({0} плк.апат кшк.),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(плк.апат кшк.),
						'other' => q({0} плк.апат кшк.),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(имп.плк. апат кшк.),
						'other' => q({0} имп.плк.апат кшк.),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(имп.плк. апат кшк.),
						'other' => q({0} имп.плк.апат кшк.),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(шĕвĕ др.),
						'other' => q({0} шĕвĕ др.),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(шĕвĕ др.),
						'other' => q({0} шĕвĕ др.),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(тмлм),
						'other' => q({0} тмлм),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(тмлм),
						'other' => q({0} тмлм),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(шӗвӗ унци),
						'other' => q({0} шӗвӗ унци),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(шӗвӗ унци),
						'other' => q({0} шӗвӗ унци),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(имп.шӗвӗ унци),
						'other' => q({0} импери шӗвӗ унци),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(имп.шӗвӗ унци),
						'other' => q({0} импери шӗвӗ унци),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(гал.),
						'other' => q({0} гал.),
						'per' => q({0}/гал.),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(гал.),
						'other' => q({0} гал.),
						'per' => q({0}/гал.),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(имп.гал.),
						'other' => q({0} имп.гал.),
						'per' => q({0}/имп.гал.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(имп.гал.),
						'other' => q({0} имп.гал.),
						'per' => q({0}/имп.гал.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(гл),
						'other' => q({0} гл),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(гл),
						'other' => q({0} гл),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(чӗркке),
						'other' => q({0} чӗркке),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(чӗркке),
						'other' => q({0} чӗркке),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(Мл),
						'other' => q({0} Мл),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(Мл),
						'other' => q({0} Мл),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(мл),
						'other' => q({0} мл),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(мл),
						'other' => q({0} мл),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(чптм),
						'other' => q({0} чптм),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(чптм),
						'other' => q({0} чптм),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(пинт),
						'other' => q({0} пинт),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(пинт),
						'other' => q({0} пинт),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(мпт),
						'other' => q({0} мпт),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(мпт),
						'other' => q({0} мпт),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(кварт),
						'other' => q({0} кварт),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(кварт),
						'other' => q({0} кварт),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(имп.кварт),
						'other' => q({0} имп.кварт),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(имп.кварт),
						'other' => q({0} имп.кварт),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(апт.кшк.),
						'other' => q({0} апт.кшк.),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(апт.кшк.),
						'other' => q({0} апт.кшк.),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ч.кшк.),
						'other' => q({0} ч.кшк.),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ч.кшк.),
						'other' => q({0} ч.кшк.),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(енӗ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(енӗ),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Ки{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Ки{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Ми{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Ми{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Ги{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Ги{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ти{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ти{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Пи{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Пи{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Эи{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Эи{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Зи{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Зи{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Йи{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Йи{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(д{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(д{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(п{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(п{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ф{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ф{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(а{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(а{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(с{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(с{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(з{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(з{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(и{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(и{0}),
					},
					# Long Unit Identifier
					'10p-27' => {
						'1' => q(р{0}),
					},
					# Core Unit Identifier
					'27' => {
						'1' => q(р{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(м{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(м{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(кв{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(кв{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(мк{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(мк{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(н{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(н{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(Э{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(Э{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(г{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(И{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(И{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(Р{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(Р{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(Кв{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(Кв{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(g),
						'other' => q({0}g),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(g),
						'other' => q({0}g),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(м/ҫ²),
						'other' => q({0} м/ҫ²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(м/ҫ²),
						'other' => q({0} м/ҫ²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(минут),
						'other' => q({0} минут),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(минут),
						'other' => q({0} минут),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(çеккунт),
						'other' => q({0} çеккунт),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(çеккунт),
						'other' => q({0} çеккунт),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(градус),
						'other' => q({0} градус),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(градус),
						'other' => q({0} градус),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(радиан),
						'other' => q({0} радиан),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(радиан),
						'other' => q({0} радиан),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(çавра),
						'other' => q({0} çавра),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(çавра),
						'other' => q({0} çавра),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(акр),
						'other' => q({0} акр),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(акр),
						'other' => q({0} акр),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(дунам),
						'other' => q({0} дунам),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(дунам),
						'other' => q({0} дунам),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(га),
						'other' => q({0} га),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(га),
						'other' => q({0} га),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(фт²),
						'other' => q({0} фт²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(фт²),
						'other' => q({0} фт²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(дюйм²),
						'other' => q({0} дюйм²),
						'per' => q({0}/дюйм²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(дюйм²),
						'other' => q({0} дюйм²),
						'per' => q({0}/дюйм²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(ми²),
						'other' => q({0} ми²),
						'per' => q({0}/ми²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(ми²),
						'other' => q({0} ми²),
						'per' => q({0}/ми²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(ярд²),
						'other' => q({0} ярд²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(ярд²),
						'other' => q({0} ярд²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(объект),
						'other' => q({0} объект),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(объект),
						'other' => q({0} объект),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(карат),
						'other' => q({0} карат),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(карат),
						'other' => q({0} карат),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(мг/дл),
						'other' => q({0} мг/дл),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(мг/дл),
						'other' => q({0} мг/дл),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(моль),
						'other' => q({0} моль),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(моль),
						'other' => q({0} моль),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(л/100 км),
						'other' => q({0} л/100 км),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(л/100 км),
						'other' => q({0} л/100 км),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(л/км),
						'other' => q({0} л/км),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(л/км),
						'other' => q({0} л/км),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(ми/гал),
						'other' => q({0} ми/гал),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(ми/гал),
						'other' => q({0} ми/гал),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(мили/имп. гал),
						'other' => q({0} ми/имп. гал),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(мили/имп. гал),
						'other' => q({0} ми/имп. гал),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} х. т.),
						'north' => q({0} ҫ. т.),
						'south' => q({0} к. т.),
						'west' => q({0} а. т.),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} х. т.),
						'north' => q({0} ҫ. т.),
						'south' => q({0} к. т.),
						'west' => q({0} а. т.),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(бит),
						'other' => q({0} бит),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(бит),
						'other' => q({0} бит),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(байт),
						'other' => q({0} байт),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(байт),
						'other' => q({0} байт),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Гбит),
						'other' => q({0} Гбит),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Гбит),
						'other' => q({0} Гбит),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(Гбайт),
						'other' => q({0} Гбайт),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(Гбайт),
						'other' => q({0} Гбайт),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(кбит),
						'other' => q({0} кбит),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(кбит),
						'other' => q({0} кбит),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(Кбайт),
						'other' => q({0} Кбайт),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(Кбайт),
						'other' => q({0} Кбайт),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Мбит),
						'other' => q({0} Мбит),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Мбит),
						'other' => q({0} Мбит),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(Мбайт),
						'other' => q({0} Мбайт),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(Мбайт),
						'other' => q({0} Мбайт),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(Пбайт),
						'other' => q({0} Пбайт),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(Пбайт),
						'other' => q({0} Пбайт),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Тбит),
						'other' => q({0} Тбит),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Тбит),
						'other' => q({0} Тбит),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(Тбайт),
						'other' => q({0} Тбайт),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(Тбайт),
						'other' => q({0} Тбайт),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ӗмӗр),
						'other' => q({0} ӗмӗр),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ӗмӗр),
						'other' => q({0} ӗмӗр),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(кун),
						'other' => q({0} кун),
						'per' => q({0}/кун),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(кун),
						'other' => q({0} кун),
						'per' => q({0}/кун),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(вунҫул),
						'other' => q({0} вунҫул),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(вунҫул),
						'other' => q({0} вунҫул),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(сехет),
						'other' => q({0} сехет),
						'per' => q({0}/сехет),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(сехет),
						'other' => q({0} сехет),
						'per' => q({0}/сехет),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(мкҫ),
						'other' => q({0} мкҫ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(мкҫ),
						'other' => q({0} мкҫ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(мҫ),
						'other' => q({0} мҫ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(мҫ),
						'other' => q({0} мҫ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(уйӑх),
						'other' => q({0} уйӑх),
						'per' => q({0}/уйӑх),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(уйӑх),
						'other' => q({0} уйӑх),
						'per' => q({0}/уйӑх),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(нҫ),
						'other' => q({0} нҫ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(нҫ),
						'other' => q({0} нҫ),
					},
					# Long Unit Identifier
					'duration-night' => {
						'name' => q(ҫӗрсем),
						'other' => q({0} ҫӗрсем),
						'per' => q({0}/ҫӗр),
					},
					# Core Unit Identifier
					'night' => {
						'name' => q(ҫӗрсем),
						'other' => q({0} ҫӗрсем),
						'per' => q({0}/ҫӗр),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(чӗрӗк),
						'other' => q({0} чӗрӗк),
						'per' => q({0}/чӗрӗк),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(чӗрӗк),
						'other' => q({0} чӗрӗк),
						'per' => q({0}/чӗрӗк),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ҫ),
						'other' => q({0} ҫ),
						'per' => q({0}/ҫ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ҫ),
						'other' => q({0} ҫ),
						'per' => q({0}/ҫ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(эрне),
						'other' => q({0} эрне),
						'per' => q({0}/эрне),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(эрне),
						'other' => q({0} эрне),
						'per' => q({0}/эрне),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ҫулсем),
						'other' => q({0} ҫулсем),
						'per' => q({0}/ҫул),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ҫулсем),
						'other' => q({0} ҫулсем),
						'per' => q({0}/ҫул),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(А),
						'other' => q({0} А),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(А),
						'other' => q({0} А),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(мА),
						'other' => q({0} мА),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(мА),
						'other' => q({0} мА),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(Ом),
						'other' => q({0} Ом),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(Ом),
						'other' => q({0} Ом),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(В),
						'other' => q({0} В),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(В),
						'other' => q({0} В),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(БӐЕ),
						'other' => q({0} БӐЕ),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(БӐЕ),
						'other' => q({0} БӐЕ),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(кал),
						'other' => q({0} кал),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(кал),
						'other' => q({0} кал),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(эВ),
						'other' => q({0} эВ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(эВ),
						'other' => q({0} эВ),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(Дж),
						'other' => q({0} Дж),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(Дж),
						'other' => q({0} Дж),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(ккал),
						'other' => q({0} ккал),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(ккал),
						'other' => q({0} ккал),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(кДж),
						'other' => q({0} кДж),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(кДж),
						'other' => q({0} кДж),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(КВт⋅сехет),
						'other' => q({0} КВт⋅сехет),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(КВт⋅сехет),
						'other' => q({0} КВт⋅сехет),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(АПШ терм),
						'other' => q({0} АПШ терм),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(АПШ терм),
						'other' => q({0} АПШ терм),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(кВт⋅ч/100 км),
						'other' => q({0} кВт⋅ч/100 км),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(кВт⋅ч/100 км),
						'other' => q({0} кВт⋅ч/100 км),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(Н),
						'other' => q({0} Н),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(Н),
						'other' => q({0} Н),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(кĕренке-вăй),
						'other' => q({0} кĕренке-вăй),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(кĕренке-вăй),
						'other' => q({0} кĕренке-вăй),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(ГГц),
						'other' => q({0} ГГц),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(ГГц),
						'other' => q({0} ГГц),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Гц),
						'other' => q({0} Гц),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Гц),
						'other' => q({0} Гц),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(кГц),
						'other' => q({0} кГц),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(кГц),
						'other' => q({0} кГц),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(МГц),
						'other' => q({0} МГц),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(МГц),
						'other' => q({0} МГц),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(эм),
						'other' => q({0} эм),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(эм),
						'other' => q({0} эм),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(мегапиксельсем),
						'other' => q({0} Мпкс),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(мегапиксельсем),
						'other' => q({0} Мпкс),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(пиксельсем),
						'other' => q({0} пкс),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(пиксельсем),
						'other' => q({0} пкс),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(пкс/см),
						'other' => q({0} пкс/см),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(пкс/см),
						'other' => q({0} пкс/см),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(пкс/дюйм),
						'other' => q({0} пкс/дюйм),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(пкс/дюйм),
						'other' => q({0} пкс/дюйм),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(а.п.),
						'other' => q({0} а.п.),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(а.п.),
						'other' => q({0} а.п.),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(дм),
						'other' => q({0} дм),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(дм),
						'other' => q({0} дм),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(ҫӗр радиусӗ),
						'other' => q({0} ҫӗр радиусӗ),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(ҫӗр радиусӗ),
						'other' => q({0} ҫӗр радиусӗ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(тинӗс чалӑш),
						'other' => q({0} тинӗс чалӑш),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(тинӗс чалӑш),
						'other' => q({0} тинӗс чалӑш),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(фт),
						'other' => q({0} фт),
						'per' => q({0}/фт),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(фт),
						'other' => q({0} фт),
						'per' => q({0}/фт),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(фурлонгсем),
						'other' => q({0} фрл),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(фурлонгсем),
						'other' => q({0} фрл),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(çуттăн çулĕ),
						'other' => q({0} çуттăн çулĕ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(çуттăн çулĕ),
						'other' => q({0} çуттăн çулĕ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(мкм),
						'other' => q({0} мкм),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(мкм),
						'other' => q({0} мкм),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ми),
						'other' => q({0} ми),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ми),
						'other' => q({0} ми),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(ск.ми),
						'other' => q({0} ск.ми),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(ск.ми),
						'other' => q({0} ск.ми),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(мм),
						'other' => q({0} мм),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(мм),
						'other' => q({0} мм),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(нм),
						'other' => q({0} нм),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(нм),
						'other' => q({0} нм),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(тнс.ми),
						'other' => q({0} тинӗс милли),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(тнс.ми),
						'other' => q({0} тинӗс милли),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(пк),
						'other' => q({0} пк),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(пк),
						'other' => q({0} пк),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пм),
						'other' => q({0} пм),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пм),
						'other' => q({0} пм),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(пкт),
						'other' => q({0} пкт),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(пкт),
						'other' => q({0} пкт),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(хӗвел радиусӗ),
						'other' => q({0} хӗвел радиусӗ),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(хӗвел радиусӗ),
						'other' => q({0} хӗвел радиусӗ),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ярд),
						'other' => q({0} ярд),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ярд),
						'other' => q({0} ярд),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(кд),
						'other' => q({0} кд),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(кд),
						'other' => q({0} кд),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(лм),
						'other' => q({0} лм),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(лм),
						'other' => q({0} лм),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(лк),
						'other' => q({0} лк),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(лк),
						'other' => q({0} лк),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(карат),
						'other' => q({0} карат),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(карат),
						'other' => q({0} карат),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(дальтон),
						'other' => q({0} дальтон),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(дальтон),
						'other' => q({0} дальтон),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(Ҫӗр масси),
						'other' => q({0} Ҫӗр масси),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(Ҫӗр масси),
						'other' => q({0} Ҫӗр масси),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(гран),
						'other' => q({0} гран),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(гран),
						'other' => q({0} гран),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(мкг),
						'other' => q({0} мкг),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(мкг),
						'other' => q({0} мкг),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(мг),
						'other' => q({0} мг),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(мг),
						'other' => q({0} мг),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(унци),
						'other' => q({0} унци),
						'per' => q({0}/унци),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(унци),
						'other' => q({0} унци),
						'per' => q({0}/унци),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(трой унци),
						'other' => q({0} трой унци),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(трой унци),
						'other' => q({0} трой унци),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(кĕренке),
						'other' => q({0} кĕренке),
						'per' => q({0}/кĕренке),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(кĕренке),
						'other' => q({0} кĕренке),
						'per' => q({0}/кĕренке),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(Хӗвел масси),
						'other' => q({0} Хӗвел масси),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(Хӗвел масси),
						'other' => q({0} Хӗвел масси),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(стоун),
						'other' => q({0} стоун),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(стоун),
						'other' => q({0} стоун),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(амер. тонна),
						'other' => q({0} амер. тонна),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(амер. тонна),
						'other' => q({0} амер. тонна),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(тонна),
						'other' => q({0} тонна),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(тонна),
						'other' => q({0} тонна),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(ГВт),
						'other' => q({0} ГВт),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(ГВт),
						'other' => q({0} ГВт),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(л.в.),
						'other' => q({0} л.в.),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(л.в.),
						'other' => q({0} л.в.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(КВт),
						'other' => q({0} КВт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(КВт),
						'other' => q({0} КВт),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(МВт),
						'other' => q({0} МВт),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(МВт),
						'other' => q({0} МВт),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(мВт),
						'other' => q({0} мВт),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(мВт),
						'other' => q({0} мВт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(Вт),
						'other' => q({0} Вт),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(Вт),
						'other' => q({0} Вт),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(атмосфера),
						'other' => q({0} атмосфера),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(атмосфера),
						'other' => q({0} атмосфера),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(бар),
						'other' => q({0} бар),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(бар),
						'other' => q({0} бар),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(гПа),
						'other' => q({0} гПа),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(гПа),
						'other' => q({0} гПа),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(чĕркĕмĕл юпи дюйм),
						'other' => q(чĕркĕмĕл юпи {0} дюйм),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(чĕркĕмĕл юпи дюйм),
						'other' => q(чĕркĕмĕл юпи {0} дюйм),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(кПа),
						'other' => q({0} кПа),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(кПа),
						'other' => q({0} кПа),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(МПа),
						'other' => q({0} МПа),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(МПа),
						'other' => q({0} МПа),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(мбар),
						'other' => q({0} мбар),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(мбар),
						'other' => q({0} мбар),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(чĕркĕмĕл юпи мм),
						'other' => q(чĕркĕмĕл юпи {0} мм),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(чĕркĕмĕл юпи мм),
						'other' => q(чĕркĕмĕл юпи {0} мм),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(Па),
						'other' => q({0} Па),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(Па),
						'other' => q({0} Па),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(дюйм² кӗренке),
						'other' => q(дюйм² {0} кӗренке),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(дюйм² кӗренке),
						'other' => q(дюйм² {0} кӗренке),
					},
					# Long Unit Identifier
					'speed-beaufort' => {
						'name' => q(Бофорт балл),
						'other' => q({0} Бофорт балл),
					},
					# Core Unit Identifier
					'beaufort' => {
						'name' => q(Бофорт балл),
						'other' => q({0} Бофорт балл),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(км/сехет),
						'other' => q({0} км/сехет),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(км/сехет),
						'other' => q({0} км/сехет),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(тĕвĕ),
						'other' => q({0} тĕвĕ),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(тĕвĕ),
						'other' => q({0} тĕвĕ),
					},
					# Long Unit Identifier
					'speed-light-speed' => {
						'name' => q(ҫутӑ хӑвӑрт),
						'other' => q({0} ҫутӑ хӑвӑрт),
					},
					# Core Unit Identifier
					'light-speed' => {
						'name' => q(ҫутӑ хӑвӑрт),
						'other' => q({0} ҫутӑ хӑвӑрт),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(м/ҫ),
						'other' => q({0} м/ҫ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(м/ҫ),
						'other' => q({0} м/ҫ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ми/сехет),
						'other' => q({0} ми/сехет),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ми/сехет),
						'other' => q({0} ми/сехет),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(К),
						'other' => q({0} К),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(К),
						'other' => q({0} К),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(Н⋅м),
						'other' => q({0} Н⋅м),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(Н⋅м),
						'other' => q({0} Н⋅м),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(кĕренке-фут),
						'other' => q({0} кĕренке-фут),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(кĕренке-фут),
						'other' => q({0} кĕренке-фут),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(акр-фут),
						'other' => q({0} акр-фут),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(акр-фут),
						'other' => q({0} акр-фут),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(барр.),
						'other' => q({0} барр.),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(барр.),
						'other' => q({0} барр.),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(буш.),
						'other' => q({0} буш.),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(буш.),
						'other' => q({0} буш.),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(сл),
						'other' => q({0} сл),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(сл),
						'other' => q({0} сл),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(см³),
						'other' => q({0} см³),
						'per' => q({0}/см³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(см³),
						'other' => q({0} см³),
						'per' => q({0}/см³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(фт³),
						'other' => q({0} фт³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(фт³),
						'other' => q({0} фт³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(дюйм³),
						'other' => q({0} дюйм³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(дюйм³),
						'other' => q({0} дюйм³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(км³),
						'other' => q({0} км³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(км³),
						'other' => q({0} км³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ми³),
						'other' => q({0} ми³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ми³),
						'other' => q({0} ми³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(ярд³),
						'other' => q({0} ярд³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(ярд³),
						'other' => q({0} ярд³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(чашӑк),
						'other' => q({0} чашӑк),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(чашӑк),
						'other' => q({0} чашӑк),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(курка-метрлӑ),
						'other' => q({0} курка-метрлӑ),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(курка-метрлӑ),
						'other' => q({0} курка-метрлӑ),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(дл),
						'other' => q({0} дл),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(дл),
						'other' => q({0} дл),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(плк.апат кшк.),
						'other' => q({0} плк.апат кшк.),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(плк.апат кшк.),
						'other' => q({0} плк.апат кшк.),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(имп. пылак апат кашӑкӗ),
						'other' => q({0} имп.пылак апат кашӑкӗ),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(имп. пылак апат кашӑкӗ),
						'other' => q({0} имп.пылак апат кашӑкӗ),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(шĕвĕ драхма),
						'other' => q({0} шĕвĕ драхма),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(шĕвĕ драхма),
						'other' => q({0} шĕвĕ драхма),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(тумлам),
						'other' => q({0} тумлам),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(тумлам),
						'other' => q({0} тумлам),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(шӗвӗ унци),
						'other' => q({0} шӗвӗ унци),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(шӗвӗ унци),
						'other' => q({0} шӗвӗ унци),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(импери шӗвӗ унци),
						'other' => q({0} импери шӗвӗ унци),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(импери шӗвӗ унци),
						'other' => q({0} импери шӗвӗ унци),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(гал.),
						'other' => q({0} гал.),
						'per' => q({0}/гал.),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(гал.),
						'other' => q({0} гал.),
						'per' => q({0}/гал.),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(импери галлон),
						'other' => q({0} импери галлон),
						'per' => q({0}/импери галлон),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(импери галлон),
						'other' => q({0} импери галлон),
						'per' => q({0}/импери галлон),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(гл),
						'other' => q({0} гл),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(гл),
						'other' => q({0} гл),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(чӗркке),
						'other' => q({0} чӗркке),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(чӗркке),
						'other' => q({0} чӗркке),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(мегалитр),
						'other' => q({0} мегалитр),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(мегалитр),
						'other' => q({0} мегалитр),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(мл),
						'other' => q({0} мл),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(мл),
						'other' => q({0} мл),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(чĕптĕм),
						'other' => q({0} чĕптĕм),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(чĕптĕм),
						'other' => q({0} чĕптĕм),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(пинт),
						'other' => q({0} пинт),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(пинт),
						'other' => q({0} пинт),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(мпт),
						'other' => q({0} мпт),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(мпт),
						'other' => q({0} мпт),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(кварт),
						'other' => q({0} кварт),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(кварт),
						'other' => q({0} кварт),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(импери кварт),
						'other' => q({0} импери кварт),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(импери кварт),
						'other' => q({0} импери кварт),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(апат кашӑкӗ),
						'other' => q({0} апат кашӑкӗ),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(апат кашӑкӗ),
						'other' => q({0} апат кашӑкӗ),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(чей кашӑкӗ),
						'other' => q({0} чей кашӑкӗ),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(чей кашӑкӗ),
						'other' => q({0} чей кашӑкӗ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:çапла|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ҫук|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0} тата {1}),
				2 => q({0} тата {1}),
		} }
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'group' => q( ),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'other' => '0 пин',
				},
				'10000' => {
					'other' => '00 пин',
				},
				'100000' => {
					'other' => '000 пин',
				},
				'1000000' => {
					'other' => '0 миллион',
				},
				'10000000' => {
					'other' => '00 миллион',
				},
				'100000000' => {
					'other' => '000 миллион',
				},
				'1000000000' => {
					'other' => '0 миллиард',
				},
				'10000000000' => {
					'other' => '00 миллиард',
				},
				'100000000000' => {
					'other' => '000 миллиард',
				},
				'1000000000000' => {
					'other' => '0 триллион',
				},
				'10000000000000' => {
					'other' => '00 триллион',
				},
				'100000000000000' => {
					'other' => '000 триллион',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0 пин',
				},
				'10000' => {
					'other' => '00 пин',
				},
				'100000' => {
					'other' => '000 пин',
				},
				'1000000' => {
					'other' => '0 млн',
				},
				'10000000' => {
					'other' => '00 млн',
				},
				'100000000' => {
					'other' => '000 млн',
				},
				'1000000000' => {
					'other' => '0 млрд',
				},
				'10000000000' => {
					'other' => '00 млрд',
				},
				'100000000000' => {
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'other' => '000 трлн',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0 %',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорра песийӗ),
				'other' => q(Андорра песийӗ),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(АПЭ дирхамӗ),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Афган афганийӗ \(1927–2002\)),
				'other' => q(Афган афганийӗ \(1927–2002\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(афганийӗ),
			},
		},
		'ALK' => {
			display_name => {
				'currency' => q(Албани лек),
				'other' => q(Албани лек),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(Албани лекӗ),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(Армяни драмӗ),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(Нидерланд Антиллиан гульденӗ),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(Ангола кванзӗ),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(Ангола кванзӗ \(1977–1991\)),
				'other' => q(Ангола кванзӗ \(1977–1991\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Ангола ҫӗнӗ кванзӗ \(1990–2000\)),
				'other' => q(Ангола ҫӗнӗ кванзӗ \(1990–2000\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(Ангола деноминаци хыҫҫӑн кванзӗ \(1995–1999\)),
				'other' => q(Ангола деноминаци хыҫҫӑн кванзӗ \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(Аргентин аусталӗ),
				'other' => q(Аргентин аусталӗ),
			},
		},
		'ARL' => {
			display_name => {
				'currency' => q(Аргентин песийӗ лей \(1970–1983\)),
				'other' => q(Аргентин песийӗ лей \(1970–1983\)),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(Аргентин песийӗ \(1881–1970\)),
				'other' => q(Аргентин песийӗ \(1881–1970\)),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(Аргентин песийӗ \(1983–1985\)),
				'other' => q(Аргентин песийӗ \(1983–1985\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(Аргентина песийӗ),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Австри шиллинг),
				'other' => q(Австри шиллинг),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(Австрали долларӗ),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Аруба флоринӗ),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(Азербайджан маначӗ \(1993–2006\)),
				'other' => q(Азербайджан маначӗ \(1993–2006\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Азербайджан маначӗ),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Боснипе Герцеговина динар \(1992–1994\)),
				'other' => q(Боснипе Герцеговина динар \(1992–1994\)),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(Боснипе Герцеговина конвертланакан марки),
			},
		},
		'BAN' => {
			display_name => {
				'currency' => q(Боснипе Герцеговина ҫӗнӗ динар \(1994–1997\)),
				'other' => q(Боснипе Герцеговина ҫӗнӗ динар \(1994–1997\)),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(Барбадос долларӗ),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Бангладеш таки),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Бельги конвертланакан франк),
				'other' => q(Бельги конвертланакан франк),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Бельги франк),
				'other' => q(Бельги франк),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Бельги франк \(финанс\)),
				'other' => q(Бельги франк \(финанс\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Болгари хытӑ левӗ),
				'other' => q(Болгари хытӑ левӗ),
			},
		},
		'BGM' => {
			display_name => {
				'currency' => q(Болгари социалистсен левӗ),
				'other' => q(Болгари социалистсен левӗ),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(Болгари левӗ),
			},
		},
		'BGO' => {
			display_name => {
				'currency' => q(Болгари левӗ \(1879–1952\)),
				'other' => q(Болгари левӗ \(1879–1952\)),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Бахрейн динарӗ),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Бурунди франкӗ),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Бермуд долларӗ),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Бруней долларӗ),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(Боливи боливианӗ),
			},
		},
		'BOL' => {
			display_name => {
				'currency' => q(Боливи боливианӗ \(1863–1963\)),
				'other' => q(Боливи боливианӗ \(1863–1963\)),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(Боливи песийӗ),
				'other' => q(Боливи песийӗ),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(Боливи мвдол),
				'other' => q(Боливи мвдол),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(Бразили ҫӗнӗ крузейро \(1967–1986\)),
				'other' => q(Бразили ҫӗнӗ крузейро \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(Бразили крузадо),
				'other' => q(Бразили крузадо),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(Бразили крузейро \(1990–1993\)),
				'other' => q(Бразили крузейро \(1990–1993\)),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(Бразили реалӗ),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(Бразили ҫӗнӗ крузадо \(1989–1990\)),
				'other' => q(Бразили ҫӗнӗ крузадо \(1989–1990\)),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(Бразили крузейро \(1993–1994\)),
				'other' => q(Бразили крузейро \(1993–1994\)),
			},
		},
		'BRZ' => {
			display_name => {
				'currency' => q(Бразили крузейро \(1942–1967\)),
				'other' => q(Бразили крузейро \(1942–1967\)),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Багам долларӗ),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Бутан нгултрумӗ),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(Бирман кьят),
				'other' => q(Бирман кьят),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Ботсвана пули),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Белорусси тенкӗ \(1994–1999\)),
				'other' => q(Белорусси тенкӗ \(1994–1999\)),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(Беларуҫ тенкӗ),
				'other' => q(Беларуҫ тенки),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(Белорусси тенкӗ \(2000–2016\)),
				'other' => q(Белорусси тенкӗ \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Белиз долларӗ),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(Канада долларӗ),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Конголези франкӗ),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR евро),
				'other' => q(WIR евро),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(Швейцари франкӗ),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR франк),
				'other' => q(WIR франк),
			},
		},
		'CLE' => {
			display_name => {
				'currency' => q(Чили эскудо),
				'other' => q(Чили эскудо),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(Чили расчет единици \(UF\)),
				'other' => q(Чили расчет единици \(UF\)),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Чили песийӗ),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(Китай офшор юанӗ),
			},
		},
		'CNX' => {
			display_name => {
				'currency' => q(Китай халӑх банкӗн доллар),
				'other' => q(Китай халӑх банкӗн доллар),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(Китай юанӗ),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Колумби песийӗ),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(Колумби чӑн тивĕçлĕ единици),
				'other' => q(Колумби чӑн тивĕçлĕ единици),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Коста-Рика колонӗ),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(Серби динарӗ \(2002–2006\)),
				'other' => q(Серби динарӗ \(2002–2006\)),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословак хытӑ кронӗ),
				'other' => q(Чехословак хытӑ кронӗ),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(Куба конвертланакан песийӗ),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Куба песийӗ),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(Кабо-Верде эскудӗ),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипр фунчӗ),
				'other' => q(Кипр фунчӗ),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(Чехи кронӗ),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(Хӗвелтухӑҫ Германи марки),
				'other' => q(Хӗвелтухӑҫ Германи марки),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Германи марки),
				'other' => q(Германи марки),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Джибути франкӗ),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(Дани кронӗ),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Доминикан песийӗ),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Алжир динарӗ),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(Эквадор сукре),
				'other' => q(Эквадор сукре),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(Эквадор яланхи хаклӑхӑн единици),
				'other' => q(Эквадор яланхи хаклӑхӑн единици),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(Эстон кронӗ),
				'other' => q(Эстон кронӗ),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Египет фунчӗ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Эритрей накфӗ),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(Испани песета \(А\)),
				'other' => q(Испани песета \(А\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(Испани конвертланакан песета),
				'other' => q(Испани конвертланакан песета),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Испани песета),
				'other' => q(Испани песета),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(Эфиопи бырӗ),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(евро),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Фин марка),
				'other' => q(Фин марка),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Фиджи долларӗ),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Факланд утравӗсен фунчӗ),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Француз франк),
				'other' => q(Француз франк),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(Британи фунчӗ),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(Грузин купон),
				'other' => q(Грузин купон),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Грузи ларийӗ),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Гана седи \(1979–2007\)),
				'other' => q(Гана седи \(1979–2007\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(Гана седийӗ),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(Гибралтар фунчӗ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(Гамби даласийӗ),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(Гвиней франкӗ),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(Гвиней сили),
				'other' => q(Гвиней сили),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(Экваториаллă Гвиней эквель),
				'other' => q(Экваториаллă Гвиней эквель),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Грек драхми),
				'other' => q(Грек драхма),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Гватемала кетсалӗ),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(Гвиней-Бисау эскудо),
				'other' => q(Гвиней-Бисау эскудо),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвиней-Бисау песийӗ),
				'other' => q(Гвиней-Бисау песийӗ),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Гайана долларӗ),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(Гонконг долларӗ),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Гондурас лемпирӗ),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хорват динар),
				'other' => q(Хорват динар),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(Хорвати куни),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Гаити гурдӗ),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(Венгри форинчӗ),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Индонези рупийӗ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирланди фунчӗ),
				'other' => q(Ирланди фунчӗ),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Израиль фунчӗ),
				'other' => q(Израиль фунчӗ),
			},
		},
		'ILR' => {
			display_name => {
				'currency' => q(Израиль шекель \(1980–1985\)),
				'other' => q(Израиль шекель \(1980–1985\)),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(Ҫӗнӗ Израиль шекелӗ),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(Инди рупийӗ),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Ирак динарӗ),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Иран риалӗ),
			},
		},
		'ISJ' => {
			display_name => {
				'currency' => q(Исланди кронӗ \(1918–1981\)),
				'other' => q(Исланди кронӗ \(1918–1981\)),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(Исланди кронӗ),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Итали лира),
				'other' => q(Итали лира),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Ямайка долларӗ),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Иордан динарӗ),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(Япони иени),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Кени шиллингӗ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(Киргиз сомӗ),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Камбоджа риелӗ),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Комора франкӗ),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(КХДР вони),
			},
		},
		'KRH' => {
			display_name => {
				'currency' => q(Корей хван),
				'other' => q(Корей хван),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(Корей вони \(1945–1953\)),
				'other' => q(Корей вони \(1945–1953\)),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(Корей вони),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Кувейт динарӗ),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Кайман утравӗсен долларӗ),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(Казах тенгейӗ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Лаос кипӗ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Ливан фунчӗ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Шри-ланка рупийӗ),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(Либери долларӗ),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесото лотийӗ),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(Литва лит),
				'other' => q(Литва лит),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литва талон),
				'other' => q(Литва талон),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(Люксембург конвертланакан франк),
				'other' => q(Люксембург конвертланакан франк),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Люксембург франк),
				'other' => q(Люксембург франк),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(Люксембург финанс франк),
				'other' => q(Люксембург финанс франк),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(Латви лат),
				'other' => q(Латви лат),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(Латви тенкĕ),
				'other' => q(Латви тенкĕ),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Ливи динарӗ),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Марокко дирхамӗ),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокко франк),
				'other' => q(Марокко франк),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(Монако франк),
				'other' => q(Монако франк),
			},
		},
		'MDC' => {
			display_name => {
				'currency' => q(Молдова купон),
				'other' => q(Молдова купон),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(Молдова лайӗ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Малагаси ариарийӗ),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(Малагаси франк),
				'other' => q(Малагаси франк),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(Македони денарӗ),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(Македони динар \(1992–1993\)),
				'other' => q(Македони динар \(1992–1993\)),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Мали франк),
				'other' => q(Мали франк),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(Мьянман кьятӗ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(Монголи тугрикӗ),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Макао патаки),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(Мавритани угийӗ \(1973–2017\)),
				'other' => q(Мавритани угийӗ \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(Мавритани угийӗ),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Мальта лира),
				'other' => q(Мальта лира),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(Мальта фунчӗ),
				'other' => q(Мальта фунчӗ),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Маврики рупийӗ),
			},
		},
		'MVP' => {
			display_name => {
				'currency' => q(Мальдив рупийӗ \(1947–1981\)),
				'other' => q(Мальдив рупийӗ \(1947–1981\)),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Мальдивсен руфийӗ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Малави квачӗ),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(Мексика песийӗ),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(Мексика кӗмӗл песийӗ \(1861–1992\)),
				'other' => q(Мексика кӗмӗл песийӗ \(1861–1992\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(Мексика инвестици единици \(UDI\)),
				'other' => q(Мексика инвестици единици \(UDI\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Малайзи ринггичӗ),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбик эскудо),
				'other' => q(Мозамбик эскудо),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Мозамбик метикал \(1980–2006\)),
				'other' => q(Мозамбик метикал \(1980–2006\)),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Мозамбик метикалӗ),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(Намиби долларӗ),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(Нигери найрӗ),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(Никарагуа кордобӗ \(1988–1991\)),
				'other' => q(Никарагуа кордобӗ \(1988–1991\)),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Никарагуа кордобӗ),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Нидерланд гульден),
				'other' => q(Нидерланд гульден),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(Норвеги кронӗ),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Непал рупийӗ),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(Ҫӗнӗ Зеланди долларӗ),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Оман риалӗ),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Панама бальбоа),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(Перу инти),
				'other' => q(Перу инти),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Перу солӗ),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(Перу соль \(1863–1965\)),
				'other' => q(Перу соль \(1863–1965\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(Папуа – Ҫӗнӗ Гвиней кини),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(Филиппин песийӗ),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(пакистан рупийӗ),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(Польша злотыйӗ),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Польша злотыйӗ \(1950–1995\)),
				'other' => q(Польша злотыйӗ \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португали эскудо),
				'other' => q(Португали эскудо),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Парагвай гуаранӗ),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Катар риалӗ),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(Родези доллар),
				'other' => q(Родези доллар),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Румыни лейӗ \(1952–2006\)),
				'other' => q(Румыни лейӗ \(1952–2006\)),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(Румыни лейӗ),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(Серби динарӗ),
			},
		},
		'RUB' => {
			symbol => '₽',
			display_name => {
				'currency' => q(Раҫҫей тенкӗ),
				'other' => q(Раҫҫей тенки),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Раҫҫей тенкӗ \(1991–1998\)),
				'other' => q(Раҫҫей тенки \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Руанда франкӗ),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Сауд риялӗ),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(Соломон утравӗсен долларӗ),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Сейшел рупийӗ),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Судан динар \(1992–2007\)),
				'other' => q(Судан динар \(1992–2007\)),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Судан фунчӗ),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(Судан фунчӗ \(1957–1998\)),
				'other' => q(Судан фунчӗ \(1957–1998\)),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(Швеци кронӗ),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Сингапур долларӗ),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(Сӑваплӑ Елена утравӗн фунчӗ),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словени толар),
				'other' => q(Словени толар),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словак кронӗ),
				'other' => q(Словак кронӗ),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(леонӗ),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(леонӗ \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(Сомали шиллингӗ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(Суринам долларӗ),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринам гульден),
				'other' => q(Суринам гульден),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(Кӑнтӑр Судан фунчӗ),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(Сан-Томе и Принсипи добра),
				'other' => q(Сан-Томе и Принсипи добра),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(Сан-Томе тата Принсипи добрӗ),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Совет тенкӗ),
				'other' => q(Совет тенки),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(Сальвадор колон),
				'other' => q(Сальвадор колон),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Сири фунчӗ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Свази лилангенийӗ),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(Таиланд барӗ),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таджик тенкӗ),
				'other' => q(Таджик тенки),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(Таджик сомонийӗ),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркмен маначӗ \(1993–2009\)),
				'other' => q(Туркмен маначӗ \(1993–2009\)),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(Туркмен маначӗ),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Тунези динарӗ),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Тонган паанги),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тимор эскудо),
				'other' => q(Тимор эскудо),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Турци лира \(1922–2005\)),
				'other' => q(Турци лира \(1922–2005\)),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(Турци лири),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(Тринидад тата Тобаго долларӗ),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(Ҫӗнӗ Тайван долларӗ),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Танзани шиллингӗ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(Украина гривни),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(Украина карбованец),
				'other' => q(Украина карбованец),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Уганда шиллинг \(1966–1987\)),
				'other' => q(Уганда шиллинг \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Уганда шиллингӗ),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(АПШ долларӗ),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(АПШ долларӗ ыранхи кун),
				'other' => q(АПШ долларӗ ыранхи кун),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(АПШ долларӗ паянхи кун),
				'other' => q(АПШ долларӗ паянхи кун),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(Уругвай песийӗ \(индексаци хыҫҫӑн единици\)),
				'other' => q(Уругвай песийӗ \(индексаци хыҫҫӑн единици\)),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвай песийӗ \(1975–1993\)),
				'other' => q(Уругвай песийӗ \(1975–1993\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Уругвай песийӗ),
			},
		},
		'UYW' => {
			display_name => {
				'currency' => q(Уругвай номиналлӑ индексаци единици),
				'other' => q(Уругвай номиналлӑ индексаци единици),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Узбек сумӗ),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венесуэла боливарӗ \(1871–2008\)),
				'other' => q(Венесуэла боливарӗ \(1871–2008\)),
			},
		},
		'VED' => {
			display_name => {
				'currency' => q(Суверенлă боливарӗ),
				'other' => q(Суверенлă боливарӗ),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(Венесуэль боливарӗ \(2008–2018\)),
				'other' => q(Венесуэль боливарӗ \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(Венесуэла боливарӗ),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(Вьетнам донгӗ),
			},
		},
		'VNN' => {
			display_name => {
				'currency' => q(Вьетнам донг \(1978–1985\)),
				'other' => q(Вьетнам донг \(1978–1985\)),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Вануату ватуйӗ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Самоа тали),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(Тӗп Африка КФА франкӗ),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(кӗмӗл),
				'other' => q(Трой унци кӗмӗл),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(ылтӑн),
				'other' => q(Трой унци ылтӑн),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(Европа хутлă единици),
				'other' => q(Европа хутлă единици),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(Европа укҫа единици),
				'other' => q(Европа укҫа единици),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(Европа расчет единицисем \(XBС\)),
				'other' => q(Европа расчет единицисем \(XBС\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(Европа расчет единицисем \(XBD\)),
				'other' => q(Европа расчет единицисем \(XBD\)),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(Хӗвелтухӑҫ Карибсем долларӗ),
			},
		},
		'XCG' => {
			display_name => {
				'currency' => q(Кариб гульден),
				'other' => q(Кариб гульден),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(ятарлӑ заемлени прависем \(СДР\)),
				'other' => q(ятарлӑ заемлени прависем \(СДР\)),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(Европа валюта единици),
				'other' => q(Европа валюта единици),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(Франци ылтӑн франк),
				'other' => q(Франци ылтӑн франк),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(Франци UIC-франк),
				'other' => q(Франци UIC-франк),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(КФА ВСЕАО франкӗ),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(паллади),
				'other' => q(Трой унци паллади),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(Франци Лӑпкӑ океан франкӗ),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(платина),
				'other' => q(Трой унци платина),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(RINET фонд единици),
				'other' => q(RINET фонд единици),
			},
		},
		'XSU' => {
			display_name => {
				'currency' => q(сукре),
				'other' => q(сукре),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(тĕрĕслев валют код),
				'other' => q(тĕрĕслев валют код),
			},
		},
		'XUA' => {
			display_name => {
				'currency' => q(ADB расчет единици),
				'other' => q(ADB расчет единици),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(паллӑ мар валюта),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Йемен динар),
				'other' => q(Йемен динар),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Йемен риалӗ),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Югослави хытӑ динарӗ \(1966–1990\)),
				'other' => q(Югослави хытӑ динарӗ \(1966–1990\)),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(Югослави ҫӗнӗ динарӗ \(1994–2002\)),
				'other' => q(Югослави ҫӗнӗ динарӗ \(1994–2002\)),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Югослави конвертланакан динарӗ \(1990–1992\)),
				'other' => q(Югослави конвертланакан динарӗ \(1990–1992\)),
			},
		},
		'YUR' => {
			display_name => {
				'currency' => q(Югослави реформӑланӑ динарӗ \(1992–1993\)),
				'other' => q(Югослави реформӑланӑ динарӗ \(1992–1993\)),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Кӑнтӑр Африка рэндӗ \(финанс\)),
				'other' => q(Кӑнтӑр Африка рэндӗ \(финанс\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Кӑнтӑр Африка рэндӗ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замби квачи \(1968–2012\)),
				'other' => q(Замби квачи \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Замби квачи),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Ҫӗнӗ заир \(1993–1998\)),
				'other' => q(Ҫӗнӗ заир \(1993–1998\)),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заир \(1971–1993\)),
				'other' => q(Заир \(1971–1993\)),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабве доллар \(1980–2008\)),
				'other' => q(Зимбабве доллар \(1980–2008\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(Зимбабве доллар \(2009\)),
				'other' => q(Зимбабве доллар \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(Зимбабве доллар \(2008\)),
				'other' => q(Зимбабве доллар \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'chinese' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'кăрлач',
							'на­рăс',
							'пуш',
							'ака',
							'çу',
							'çĕртме',
							'утă',
							'çурла',
							'авăн',
							'юпа',
							'чÿк',
							'раштав'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
			},
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'тот',
							'бабэ',
							'хатур',
							'кихак',
							'тубэ',
							'амшир',
							'барамхат',
							'бармуда',
							'башнас',
							'бауна',
							'абиб',
							'мисра',
							'наси'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'тот',
							'бабэ',
							'хатур',
							'кихак',
							'тубэ',
							'амшир',
							'барамхат',
							'бармуда',
							'башнас',
							'бауна',
							'абиб',
							'мисра',
							'наси'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'тот',
							'бабэ',
							'хатур',
							'кихак',
							'тубэ',
							'амшир',
							'барамхат',
							'бармуда',
							'башнас',
							'бауна',
							'абиб',
							'мисра',
							'наси'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'тот',
							'бабэ',
							'хатур',
							'кихак',
							'тубэ',
							'амшир',
							'барамхат',
							'бармуда',
							'башнас',
							'бауна',
							'абиб',
							'мисра',
							'наси'
						],
						leap => [
							
						],
					},
				},
			},
			'dangi' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'кăрлач',
							'на­рăс',
							'пуш',
							'ака',
							'çу',
							'çĕртме',
							'утă',
							'çурла',
							'авăн',
							'юпа',
							'чÿк',
							'раштав'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'мескерем',
							'текемт',
							'хедар',
							'тахсас',
							'тер',
							'якатит',
							'магабит',
							'миазия',
							'генбот',
							'сэнэ',
							'хамлэ',
							'нахасэ',
							'эпагомен'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мескерем',
							'текемт',
							'хедар',
							'тахсас',
							'тер',
							'якатит',
							'магабит',
							'миазия',
							'генбот',
							'сэнэ',
							'хамлэ',
							'нахасэ',
							'эпагомен'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'мескерем',
							'текемт',
							'хедар',
							'тахсас',
							'тер',
							'якатит',
							'магабит',
							'миазия',
							'генбот',
							'сэнэ',
							'хамлэ',
							'нахасэ',
							'эпагомен'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мескерем',
							'текемт',
							'хедар',
							'тахсас',
							'тер',
							'якатит',
							'магабит',
							'миазия',
							'генбот',
							'сэнэ',
							'хамлэ',
							'нахасэ',
							'эпагомен'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'кӑр.',
							'нар.',
							'пуш',
							'ака',
							'ҫу',
							'ҫӗр.',
							'утӑ',
							'ҫур.',
							'авӑн',
							'юпа',
							'чӳк',
							'раш.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'кӑрлач',
							'нарӑс',
							'пуш',
							'ака',
							'ҫу',
							'ҫӗртме',
							'утӑ',
							'ҫурла',
							'авӑн',
							'юпа',
							'чӳк',
							'раштав'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'К',
							'Н',
							'П',
							'А',
							'Ҫ',
							'Ҫ',
							'У',
							'Ҫ',
							'А',
							'Ю',
							'Ч',
							'Р'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'тишрей',
							'хешван',
							'кислев',
							'тевет',
							'шеват',
							'адар I',
							'адар',
							'нисан',
							'ияр',
							'сиван',
							'таммуз',
							'ав',
							'элул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'тишрей',
							'хешван',
							'кислев',
							'тевет',
							'шеват',
							'адар I',
							'адар',
							'нисан',
							'ияр',
							'сиван',
							'таммуз',
							'ав',
							'элул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'тишрей',
							'хешван',
							'кислев',
							'тевет',
							'шеват',
							'адар I',
							'адар',
							'нисан',
							'ияр',
							'сиван',
							'таммуз',
							'ав',
							'элул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'тишрей',
							'хешван',
							'кислев',
							'тевет',
							'шеват',
							'адар I',
							'адар',
							'нисан',
							'ияр',
							'сиван',
							'таммуз',
							'ав',
							'элул'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'чайтра',
							'ваисакха',
							'джанштха',
							'асадха',
							'сравана',
							'бхадра',
							'азвина',
							'картика',
							'аграхайана',
							'пауза',
							'магха',
							'пхалгуна'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'чайтра',
							'ваисакха',
							'джанштха',
							'асадха',
							'сравана',
							'бхадра',
							'азвина',
							'картика',
							'аграхайана',
							'пауза',
							'магха',
							'пхалгуна'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'чайтра',
							'ваисакха',
							'джанштха',
							'асадха',
							'сравана',
							'бхадра',
							'азвина',
							'картика',
							'аграхайана',
							'пауза',
							'магха',
							'пхалгуна'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'чайтра',
							'ваисакха',
							'джанштха',
							'асадха',
							'сравана',
							'бхадра',
							'азвина',
							'картика',
							'аграхайана',
							'пауза',
							'магха',
							'пхалгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'мух.',
							'саф.',
							'раб. I',
							'раб. II',
							'джум. I',
							'джум. II',
							'радж.',
							'шааб.',
							'рам.',
							'шав.',
							'зуль-к.',
							'зуль-х.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мухаррам',
							'сафар',
							'раби-уль-авваль',
							'раби-уль-ахир',
							'джумад-уль-авваль',
							'джумад-уль-ахир',
							'раджаб',
							'шаабан',
							'рамадан',
							'шавваль',
							'зуль-каада',
							'зуль-хиджжа'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'мух.',
							'саф.',
							'раб. I',
							'раб. II',
							'джум. I',
							'джум. II',
							'радж.',
							'шааб.',
							'рам.',
							'шав.',
							'зуль-к.',
							'зуль-х.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'мухаррам',
							'сафар',
							'раби-уль-авваль',
							'раби-уль-ахир',
							'джумад-уль-авваль',
							'джумад-уль-ахир',
							'раджаб',
							'шаабан',
							'рамадан',
							'шавваль',
							'зуль-каада',
							'зуль-хиджжа'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'фарвардин',
							'ордибехешт',
							'хордад',
							'тир',
							'мордад',
							'шахривер',
							'мехр',
							'абан',
							'азер',
							'дей',
							'бахман',
							'эсфанд'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'фарвардин',
							'ордибехешт',
							'хордад',
							'тир',
							'мордад',
							'шахривер',
							'мехр',
							'абан',
							'азер',
							'дей',
							'бахман',
							'эсфанд'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'фарвардин',
							'ордибехешт',
							'хордад',
							'тир',
							'мордад',
							'шахривер',
							'мехр',
							'абан',
							'азер',
							'дей',
							'бахман',
							'эсфанд'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'фарвардин',
							'ордибехешт',
							'хордад',
							'тир',
							'мордад',
							'шахривер',
							'мехр',
							'абан',
							'азер',
							'дей',
							'бахман',
							'эсфанд'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'тун.',
						tue => 'ытл.',
						wed => 'юн.',
						thu => 'кӗҫ.',
						fri => 'эр.',
						sat => 'шӑм.',
						sun => 'выр.'
					},
					wide => {
						mon => 'тунтикун',
						tue => 'ытларикун',
						wed => 'юнкун',
						thu => 'кӗҫнерникун',
						fri => 'эрнекун',
						sat => 'шӑматкун',
						sun => 'вырсарникун'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'Т',
						tue => 'Ы',
						wed => 'Ю',
						thu => 'К',
						fri => 'Э',
						sat => 'Ш',
						sun => 'В'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-мӗш кв.',
						1 => '2-мӗш кв.',
						2 => '3-мӗш кв.',
						3 => '4-мӗш кв.'
					},
					wide => {0 => '1-мӗш квартал',
						1 => '2-мӗш квартал',
						2 => '3-мӗш квартал',
						3 => '4-мӗш квартал'
					},
				},
			},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'бэ'
			},
			narrow => {
				'0' => 'бэ'
			},
			wide => {
				'0' => 'будда эра'
			},
		},
		'chinese' => {
		},
		'coptic' => {
			abbreviated => {
				'0' => 'Диокл.ҫтчн',
				'1' => 'Диокл.хҫн'
			},
			narrow => {
				'0' => 'Дкл.ҫтчн',
				'1' => 'Дкл.хҫн'
			},
			wide => {
				'0' => 'Диоклетиан ҫитиччен',
				'1' => 'Диоклетиан хыҫҫӑн'
			},
		},
		'dangi' => {
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'прн.эрчнх.',
				'1' => 'прн.смн.'
			},
			narrow => {
				'0' => 'прн.эрчнх.',
				'1' => 'прн.смн.'
			},
			wide => {
				'0' => 'пирĕн эрăчченхи (Христус пурнăçланничен)',
				'1' => 'пирĕн самана'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'п. э.',
				'1' => 'х. э.'
			},
			wide => {
				'0' => 'Христос ҫуралнӑ кунччен',
				'1' => 'Христос ҫуралнӑ кунран'
			},
		},
		'hebrew' => {
			wide => {
				'0' => 'çут тĕнче пулса кайни'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'Сака'
			},
			narrow => {
				'0' => 'Сака'
			},
			wide => {
				'0' => 'Сака'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'хиджра хҫн'
			},
			narrow => {
				'0' => 'х-ра хҫн'
			},
			wide => {
				'0' => 'хиджра хыҫҫӑн'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'Тайка тпхр. (645–650)',
				'1' => 'Хакути тпхр. (650–671)',
				'2' => 'Хакухо тпхр. (672–686)',
				'3' => 'Сючё тпхр. (686–701)',
				'4' => 'Тайхо тпхр. (701–704)',
				'5' => 'Кёюн тпхр. (704–708)',
				'6' => 'Вадо тпхр. (708–715)',
				'7' => 'Рэйки тпхр. (715–717)',
				'8' => 'Ёро тпхр. (717–724)',
				'9' => 'Дзинки тпхр. (724–729)',
				'10' => 'Темпьё тпхр. (729–749)',
				'11' => 'Т.-кампо тпхр. (749–749)',
				'12' => 'Темпьё-Сьохо тпхр. (749-757)',
				'13' => 'Темпьё-Ходзи тпхр. (757-765)',
				'14' => 'Темпьё-Ходзи тпхр. (765-767)',
				'15' => 'Джинго-Кёюн тпхр. (767-770)',
				'16' => 'Хоки тпхр. (770–780)',
				'17' => 'Теньё тпхр. (781–782)',
				'18' => 'Енряку тпхр. (782–806)',
				'19' => 'Дайдо тпхр. (806–810)',
				'20' => 'Конин тпхр. (810–824)',
				'21' => 'Тентьо тпхр. (824–834)',
				'22' => 'Шова тпхр. (834–848)',
				'23' => 'Кайо тпхр. (848–851)',
				'24' => 'Ниндзю тпхр. (851–854)',
				'25' => 'Сайко тпхр. (854–857)',
				'26' => 'Теннан тпхр. (857–859)',
				'27' => 'Йоган тпхр. (859–877)',
				'28' => 'Генкей тпхр. (877–885)',
				'29' => 'Нинна тпхр. (885–889)',
				'30' => 'Кампьё тпхр. (889–898)',
				'31' => 'Сьотай тпхр. (898–901)',
				'32' => 'Энги тпхр. (901–923)',
				'33' => 'Ентьо тпхр. (923–931)',
				'34' => 'Сьёхэй тпхр. (931–938)',
				'35' => 'Тенгьо тпхр. (938–947)',
				'36' => 'Тенрияку тпхр. (947–957)',
				'37' => 'Тентоку тпхр. (957–961)',
				'38' => 'Ова тпхр. (961–964)',
				'39' => 'Кохо тпхр. (964–968)',
				'40' => 'Анна тпхр. (968–970)',
				'41' => 'Тенроку тпхр. (970–973)',
				'42' => 'Теньен тпхр. (973–976)',
				'43' => 'Дзьоген тпхр. (976–978)',
				'44' => 'Тенген тпхр. (978–983)',
				'45' => 'Ейкан тпхр. (983–985)',
				'46' => 'Канна тпхр. (985–987)',
				'47' => 'Ейен тпхр. (987–989)',
				'48' => 'Ейсо тпхр. (989–990)',
				'49' => 'Сёряку тпхр. (990–995)',
				'50' => 'Тётоку тпхр. (995–999)',
				'51' => 'Тёхо тпхр. (999–1004)',
				'52' => 'Канко тпхр. (1004–1012)',
				'53' => 'Тёва тпхр. (1012–1017)',
				'54' => 'Каннин тпхр. (1017–1021)',
				'55' => 'Дзиан тпхр. (1021–1024)',
				'56' => 'Мандзю тпхр. (1024–1028)',
				'57' => 'Тёгэн тпхр. (1028–1037)',
				'58' => 'Тёряку тпхр. (1037–1040)',
				'59' => 'Тёкю тпхр. (1040–1044)',
				'60' => 'Катоку тпхр. (1044–1046)',
				'61' => 'Эйсо тпхр. (1046–1053)',
				'62' => 'Тэнги тпхр. (1053–1058)',
				'63' => 'Кохэй тпхр. (1058–1065)',
				'64' => 'Дзиряку тпхр. (1065–1069)',
				'65' => 'Энкю тпхр. (1069–1074)',
				'66' => 'Сёхо тпхр. (1074–1077)',
				'67' => 'Сёряку тпхр. (1077–1081)',
				'68' => 'Эйхо тпхр. (1081–1084)',
				'69' => 'Отоку тпхр. (1084–1087)',
				'70' => 'Кандзи тпхр. (1087–1094)',
				'71' => 'Кахо тпхр. (1094–1096)',
				'72' => 'Эйтё тпхр. (1096–1097)',
				'73' => 'Сётоку тпхр. (1097–1099)',
				'74' => 'Кова тпхр. (1099–1104)',
				'75' => 'Тёдзи тпхр. (1104–1106)',
				'76' => 'Касё тпхр. (1106–1108)',
				'77' => 'Тэннин тпхр. (1108–1110)',
				'78' => 'Тэнъэй тпхр. (1110–1113)',
				'79' => 'Эйкю тпхр. (1113–1118)',
				'80' => 'Гэнъэй тпхр. (1118–1120)',
				'81' => 'Хоан тпхр. (1120–1124)',
				'82' => 'Тэндзи тпхр. (1124–1126)',
				'83' => 'Дайдзи тпхр. (1126–1131)',
				'84' => 'Тэнсё тпхр. (1131–1132)',
				'85' => 'Тёсё тпхр. (1132–1135)',
				'86' => 'Хоэн тпхр. (1135–1141)',
				'87' => 'Эйдзи тпхр. (1141–1142)',
				'88' => 'Кодзи тпхр. (1142–1144)',
				'89' => 'Тэнё тпхр. (1144–1145)',
				'90' => 'Кюан тпхр. (1145–1151)',
				'91' => 'Нимпэй тпхр. (1151–1154)',
				'92' => 'Кюдзю тпхр. (1154–1156)',
				'93' => 'Хогэн тпхр. (1156–1159)',
				'94' => 'Хэйдзи тпхр. (1159–1160)',
				'95' => 'Эйряку тпхр. (1160–1161)',
				'96' => 'Охо тпхр. (1161–1163)',
				'97' => 'Тёкан тпхр. (1163–1165)',
				'98' => 'Эйман тпхр. (1165–1166)',
				'99' => 'Нинъан тпхр. (1166–1169)',
				'100' => 'Као тпхр. (1169–1171)',
				'101' => 'Сёан тпхр. (1171–1175)',
				'102' => 'Ангэн тпхр. (1175–1177)',
				'103' => 'Дзисё тпхр. (1177–1181)',
				'104' => 'Ёва тпхр. (1181–1182)',
				'105' => 'Дзюэй тпхр. (1182–1184)',
				'106' => 'Гэнрюку тпхр. (1184–1185)',
				'107' => 'Бундзи тпхр. (1185–1190)',
				'108' => 'Кэнкю тпхр. (1190–1199)',
				'109' => 'Сёдзи тпхр. (1199–1201)',
				'110' => 'Кэннин тпхр. (1201–1204)',
				'111' => 'Гэнкю тпхр. (1204–1206)',
				'112' => 'Кэнъэй тпхр. (1206–1207)',
				'113' => 'Сёгэн тпхр. (1207–1211)',
				'114' => 'Кэнряку тпхр. (1211–1213)',
				'115' => 'Кэмпо тпхр. (1213–1219)',
				'116' => 'Сёкю тпхр. (1219–1222)',
				'117' => 'Дзёо тпхр. (1222–1224)',
				'118' => 'Гэннин тпхр. (1224–1225)',
				'119' => 'Кароку тпхр. (1225–1227)',
				'120' => 'Антэй тпхр. (1227–1229)',
				'121' => 'Канки тпхр. (1229–1232)',
				'122' => 'Дзёэй тпхр. (1232–1233)',
				'123' => 'Тэмпуку тпхр. (1233–1234)',
				'124' => 'Бунряку тпхр. (1234–1235)',
				'125' => 'Катэй тпхр. (1235–1238)',
				'126' => 'Рякунин тпхр. (1238–1239)',
				'127' => 'Энъо тпхр. (1239–1240)',
				'128' => 'Ниндзи тпхр. (1240–1243)',
				'129' => 'Кангэн тпхр. (1243–1247)',
				'130' => 'Ходзи тпхр. (1247–1249)',
				'131' => 'Кэнтё тпхр. (1249–1256)',
				'132' => 'Когэн тпхр. (1256–1257)',
				'133' => 'Сёка тпхр. (1257–1259)',
				'134' => 'Сёгэн тпхр. (1259–1260)',
				'135' => 'Бунъо тпхр. (1260–1261)',
				'136' => 'Котё тпхр. (1261–1264)',
				'137' => 'Бунъэй тпхр. (1264–1275)',
				'138' => 'Кэндзи тпхр. (1275–1278)',
				'139' => 'Коан тпхр. (1278–1288)',
				'140' => 'Сёо тпхр. (1288–1293)',
				'141' => 'Эйнин тпхр. (1293–1299)',
				'142' => 'Сёан тпхр. (1299–1302)',
				'143' => 'Кэнгэн тпхр. (1302–1303)',
				'144' => 'Кагэн тпхр. (1303–1306)',
				'145' => 'Токудзи тпхр. (1306–1308)',
				'146' => 'Энкэй тпхр. (1308–1311)',
				'147' => 'Отё тпхр. (1311–1312)',
				'148' => 'Сёва тпхр. (1312–1317)',
				'149' => 'Бумпо тпхр. (1317–1319)',
				'150' => 'Гэно тпхр. (1319–1321)',
				'151' => 'Гэнкё тпхр. (1321–1324)',
				'152' => 'Сётю тпхр. (1324–1326)',
				'153' => 'Карэки тпхр. (1326–1329)',
				'154' => 'Гэнтоку тпхр. (1329–1331)',
				'155' => 'Гэнко тпхр. (1331–1334)',
				'156' => 'Кэмму тпхр. (1334–1336)',
				'157' => 'Энгэн тпхр. (1336–1340)',
				'158' => 'Кококу тпхр. (1340–1346)',
				'159' => 'Сёхэй тпхр. (1346–1370)',
				'160' => 'Кэнтоку тпхр. (1370–1372)',
				'161' => 'Бунтю тпхр. (1372–1375)',
				'162' => 'Иэндзю тпхр. (1375–1379)',
				'163' => 'Коряку тпхр. (1379–1381)',
				'164' => 'Кова тпхр. (1381–1384)',
				'165' => 'Гэнтю тпхр. (1384–1392)',
				'166' => 'Мэйтоку тпхр. (1384–1387)',
				'167' => 'Какэй тпхр. (1387–1389)',
				'168' => 'Коо тпхр. (1389–1390)',
				'169' => 'Мэйтоку тпхр. (1390–1394)',
				'170' => 'Оэй тпхр. (1394–1428)',
				'171' => 'Сётё тпхр. (1428–1429)',
				'172' => 'Эйкё тпхр. (1429–1441)',
				'173' => 'Какицу тпхр. (1441–1444)',
				'174' => 'Банъан тпхр. (1444–1449)',
				'175' => 'Хотоку тпхр. (1449–1452)',
				'176' => 'Кётоку тпхр. (1452–1455)',
				'177' => 'Косё тпхр. (1455–1457)',
				'178' => 'Тёроку тпхр. (1457–1460)',
				'179' => 'Кансё тпхр. (1460–1466)',
				'180' => 'Бунсё тпхр. (1466–1467)',
				'181' => 'Онин тпхр. (1467–1469)',
				'182' => 'Буммэй тпхр. (1469–1487)',
				'183' => 'Тёкё тпхр. (1487–1489)',
				'184' => 'Энтоку тпхр. (1489–1492)',
				'185' => 'Мэйо тпхр. (1492–1501)',
				'186' => 'Бунки тпхр. (1501–1504)',
				'187' => 'Эйсё тпхр. (1504–1521)',
				'188' => 'Тайэй тпхр. (1521–1528)',
				'189' => 'Кёроку тпхр. (1528–1532)',
				'190' => 'Тэммон тпхр. (1532–1555)',
				'191' => 'Кодзи тпхр. (1555–1558)',
				'192' => 'Эйроку тпхр. (1558–1570)',
				'193' => 'Гэнки тпхр. (1570–1573)',
				'194' => 'Тэнсё тпхр. (1573–1592)',
				'195' => 'Бунроку тпхр. (1592–1596)',
				'196' => 'Кэйтё тпхр. (1596–1615)',
				'197' => 'Гэнва тпхр. (1615–1624)',
				'198' => 'Канъэй тпхр. (1624–1644)',
				'199' => 'Сёхо тпхр. (1644–1648)',
				'200' => 'Кэйан тпхр. (1648–1652)',
				'201' => 'Сё тпхр. (1652–1655)',
				'202' => 'Мэйряку тпхр. (1655–1658)',
				'203' => 'Мандзи тпхр. (1658–1661)',
				'204' => 'Камбун тпхр. (1661–1673)',
				'205' => 'Эмпо тпхр. (1673–1681)',
				'206' => 'Тэнва тпхр. (1681–1684)',
				'207' => 'Дзёкё тпхр. (1684–1688)',
				'208' => 'Гэнроку тпхр. (1688–1704)',
				'209' => 'Хоэй тпхр. (1704–1711)',
				'210' => 'Сётоку тпхр. (1711–1716)',
				'211' => 'Кёхо тпхр. (1716–1736)',
				'212' => 'Гэмбун тпхр. (1736–1741)',
				'213' => 'Кампо тпхр. (1741–1744)',
				'214' => 'Энкё тпхр. (1744–1748)',
				'215' => 'Канъэн тпхр. (1748–1751)',
				'216' => 'Хоряку тпхр. (1751–1764)',
				'217' => 'Мэйва тпхр. (1764–1772)',
				'218' => 'Анъэй тпхр. (1772–1781)',
				'219' => 'Тэммэй тпхр. (1781–1789)',
				'220' => 'Кансэй тпхр. (1789–1801)',
				'221' => 'Кёва тпхр. (1801–1804)',
				'222' => 'Бунка тпхр. (1804–1818)',
				'223' => 'Бунсэй тпхр. (1818–1830)',
				'224' => 'Тэмпо тпхр. (1830–1844)',
				'225' => 'Кока тпхр. (1844–1848)',
				'226' => 'Каэй тпхр. (1848–1854)',
				'227' => 'Ансэй тпхр. (1854–1860)',
				'228' => 'Манъэн тпхр. (1860–1861)',
				'229' => 'Бункю тпхр. (1861–1864)',
				'230' => 'Гендзи тпхр. (1864–1865)',
				'231' => 'Кейо тпхр. (1865–1868)',
				'232' => 'Мэйдзи тпхр.',
				'233' => 'Тайсьо тпхр.',
				'234' => 'Сьова тпхр.',
				'235' => 'Хэйсэй тпхр.',
				'236' => 'Рэйва тпхр.'
			},
			narrow => {
				'0' => 'Тайка (645–650)',
				'1' => 'Хакути (650–671)',
				'2' => 'Хакухо (672–686)',
				'3' => 'Сючё (686–701)',
				'4' => 'Тайхо (701–704)',
				'5' => 'Кёюн (704–708)',
				'6' => 'Вадо (708–715)',
				'7' => 'Рэйки (715–717)',
				'8' => 'Ёро (717–724)',
				'9' => 'Дзинки (724–729)',
				'10' => 'Темпьё (729–749)',
				'11' => 'Темпьё-кампо (749–749)',
				'12' => 'Темпьё-Сьохо (749-757)',
				'13' => 'Темпьё-Ходзи (757-765)',
				'14' => 'Темпьё-Ходзи (765-767)',
				'15' => 'Джинго-Кёюн (767-770)',
				'16' => 'Хоки (770–780)',
				'17' => 'Теньё (781–782)',
				'18' => 'Енряку (782–806)',
				'19' => 'Дайдо (806–810)',
				'20' => 'Конин (810–824)',
				'21' => 'Тентьо (824–834)',
				'22' => 'Шова (834–848)',
				'23' => 'Кайо (848–851)',
				'24' => 'Ниндзю (851–854)',
				'25' => 'Сайко (854–857)',
				'26' => 'Теннан (857–859)',
				'27' => 'Йоган (859–877)',
				'28' => 'Генкей (877–885)',
				'29' => 'Нинна (885–889)',
				'30' => 'Кампьё (889–898)',
				'31' => 'Сьотай (898–901)',
				'32' => 'Энги (901–923)',
				'33' => 'Ентьо (923–931)',
				'34' => 'Сьёхэй (931–938)',
				'35' => 'Тенгьо (938–947)',
				'36' => 'Тенрияку (947–957)',
				'37' => 'Тентоку (957–961)',
				'38' => 'Ова (961–964)',
				'39' => 'Кохо (964–968)',
				'40' => 'Анна (968–970)',
				'41' => 'Тенроку (970–973)',
				'42' => 'Теньен (973–976)',
				'43' => 'Дзьоген (976–978)',
				'44' => 'Тенген (978–983)',
				'45' => 'Ейкан (983–985)',
				'46' => 'Канна (985–987)',
				'47' => 'Ейен (987–989)',
				'48' => 'Ейсо (989–990)',
				'49' => 'Сёряку (990–995)',
				'50' => 'Тётоку (995–999)',
				'51' => 'Тёхо (999–1004)',
				'52' => 'Канко (1004–1012)',
				'53' => 'Тёва (1012–1017)',
				'54' => 'Каннин (1017–1021)',
				'55' => 'Дзиан (1021–1024)',
				'56' => 'Мандзю (1024–1028)',
				'57' => 'Тёгэн (1028–1037)',
				'58' => 'Тёряку (1037–1040)',
				'59' => 'Тёкю (1040–1044)',
				'60' => 'Катоку (1044–1046)',
				'61' => 'Эйсо (1046–1053)',
				'62' => 'Тэнги (1053–1058)',
				'63' => 'Кохэй (1058–1065)',
				'64' => 'Дзиряку (1065–1069)',
				'65' => 'Энкю (1069–1074)',
				'66' => 'Сёхо (1074–1077)',
				'67' => 'Сёряку (1077–1081)',
				'68' => 'Эйхо (1081–1084)',
				'69' => 'Отоку (1084–1087)',
				'70' => 'Кандзи (1087–1094)',
				'71' => 'Кахо (1094–1096)',
				'72' => 'Эйтё (1096–1097)',
				'73' => 'Сётоку (1097–1099)',
				'74' => 'Кова (1099–1104)',
				'75' => 'Тёдзи (1104–1106)',
				'76' => 'Касё (1106–1108)',
				'77' => 'Тэннин (1108–1110)',
				'78' => 'Тэнъэй (1110–1113)',
				'79' => 'Эйкю (1113–1118)',
				'80' => 'Гэнъэй (1118–1120)',
				'81' => 'Хоан (1120–1124)',
				'82' => 'Тэндзи (1124–1126)',
				'83' => 'Дайдзи (1126–1131)',
				'84' => 'Тэнсё (1131–1132)',
				'85' => 'Тёсё (1132–1135)',
				'86' => 'Хоэн (1135–1141)',
				'87' => 'Эйдзи (1141–1142)',
				'88' => 'Кодзи (1142–1144)',
				'89' => 'Тэнё (1144–1145)',
				'90' => 'Кюан (1145–1151)',
				'91' => 'Нимпэй (1151–1154)',
				'92' => 'Кюдзю (1154–1156)',
				'93' => 'Хогэн (1156–1159)',
				'94' => 'Хэйдзи (1159–1160)',
				'95' => 'Эйряку (1160–1161)',
				'96' => 'Охо (1161–1163)',
				'97' => 'Тёкан (1163–1165)',
				'98' => 'Эйман (1165–1166)',
				'99' => 'Нинъан (1166–1169)',
				'100' => 'Као (1169–1171)',
				'101' => 'Сёан (1171–1175)',
				'102' => 'Ангэн (1175–1177)',
				'103' => 'Дзисё (1177–1181)',
				'104' => 'Ёва (1181–1182)',
				'105' => 'Дзюэй (1182–1184)',
				'106' => 'Гэнрюку (1184–1185)',
				'107' => 'Бундзи (1185–1190)',
				'108' => 'Кэнкю (1190–1199)',
				'109' => 'Сёдзи (1199–1201)',
				'110' => 'Кэннин (1201–1204)',
				'111' => 'Гэнкю (1204–1206)',
				'112' => 'Кэнъэй (1206–1207)',
				'113' => 'Сёгэн (1207–1211)',
				'114' => 'Кэнряку (1211–1213)',
				'115' => 'Кэмпо (1213–1219)',
				'116' => 'Сёкю (1219–1222)',
				'117' => 'Дзёо (1222–1224)',
				'118' => 'Гэннин (1224–1225)',
				'119' => 'Кароку (1225–1227)',
				'120' => 'Антэй (1227–1229)',
				'121' => 'Канки (1229–1232)',
				'122' => 'Дзёэй (1232–1233)',
				'123' => 'Тэмпуку (1233–1234)',
				'124' => 'Бунряку (1234–1235)',
				'125' => 'Катэй (1235–1238)',
				'126' => 'Рякунин (1238–1239)',
				'127' => 'Энъо (1239–1240)',
				'128' => 'Ниндзи (1240–1243)',
				'129' => 'Кангэн (1243–1247)',
				'130' => 'Ходзи (1247–1249)',
				'131' => 'Кэнтё (1249–1256)',
				'132' => 'Когэн (1256–1257)',
				'133' => 'Сёка (1257–1259)',
				'134' => 'Сёгэн (1259–1260)',
				'135' => 'Бунъо (1260–1261)',
				'136' => 'Котё (1261–1264)',
				'137' => 'Бунъэй (1264–1275)',
				'138' => 'Кэндзи (1275–1278)',
				'139' => 'Коан (1278–1288)',
				'140' => 'Сёо (1288–1293)',
				'141' => 'Эйнин (1293–1299)',
				'142' => 'Сёан (1299–1302)',
				'143' => 'Кэнгэн (1302–1303)',
				'144' => 'Кагэн (1303–1306)',
				'145' => 'Токудзи (1306–1308)',
				'146' => 'Энкэй (1308–1311)',
				'147' => 'Отё (1311–1312)',
				'148' => 'Сёва (1312–1317)',
				'149' => 'Бумпо (1317–1319)',
				'150' => 'Гэно (1319–1321)',
				'151' => 'Гэнкё (1321–1324)',
				'152' => 'Сётю (1324–1326)',
				'153' => 'Карэки (1326–1329)',
				'154' => 'Гэнтоку (1329–1331)',
				'155' => 'Гэнко (1331–1334)',
				'156' => 'Кэмму (1334–1336)',
				'157' => 'Энгэн (1336–1340)',
				'158' => 'Кококу (1340–1346)',
				'159' => 'Сёхэй (1346–1370)',
				'160' => 'Кэнтоку (1370–1372)',
				'161' => 'Бунтю (1372–1375)',
				'162' => 'Иэндзю (1375–1379)',
				'163' => 'Коряку (1379–1381)',
				'164' => 'Кова (1381–1384)',
				'165' => 'Гэнтю (1384–1392)',
				'166' => 'Мэйтоку (1384–1387)',
				'167' => 'Какэй (1387–1389)',
				'168' => 'Коо (1389–1390)',
				'169' => 'Мэйтоку (1390–1394)',
				'170' => 'Оэй (1394–1428)',
				'171' => 'Сётё (1428–1429)',
				'172' => 'Эйкё (1429–1441)',
				'173' => 'Какицу (1441–1444)',
				'174' => 'Банъан (1444–1449)',
				'175' => 'Хотоку (1449–1452)',
				'176' => 'Кётоку (1452–1455)',
				'177' => 'Косё (1455–1457)',
				'178' => 'Тёроку (1457–1460)',
				'179' => 'Кансё (1460–1466)',
				'180' => 'Бунсё (1466–1467)',
				'181' => 'Онин (1467–1469)',
				'182' => 'Буммэй (1469–1487)',
				'183' => 'Тёкё (1487–1489)',
				'184' => 'Энтоку (1489–1492)',
				'185' => 'Мэйо (1492–1501)',
				'186' => 'Бунки (1501–1504)',
				'187' => 'Эйсё (1504–1521)',
				'188' => 'Тайэй (1521–1528)',
				'189' => 'Кёроку (1528–1532)',
				'190' => 'Тэммон (1532–1555)',
				'191' => 'Кодзи (1555–1558)',
				'192' => 'Эйроку (1558–1570)',
				'193' => 'Гэнки (1570–1573)',
				'194' => 'Тэнсё (1573–1592)',
				'195' => 'Бунроку (1592–1596)',
				'196' => 'Кэйтё (1596–1615)',
				'197' => 'Гэнва (1615–1624)',
				'198' => 'Канъэй (1624–1644)',
				'199' => 'Сёхо (1644–1648)',
				'200' => 'Кэйан (1648–1652)',
				'201' => 'Сё (1652–1655)',
				'202' => 'Мэйряку (1655–1658)',
				'203' => 'Мандзи (1658–1661)',
				'204' => 'Камбун (1661–1673)',
				'205' => 'Эмпо (1673–1681)',
				'206' => 'Тэнва (1681–1684)',
				'207' => 'Дзёкё (1684–1688)',
				'208' => 'Гэнроку (1688–1704)',
				'209' => 'Хоэй (1704–1711)',
				'210' => 'Сётоку (1711–1716)',
				'211' => 'Кёхо (1716–1736)',
				'212' => 'Гэмбун (1736–1741)',
				'213' => 'Кампо (1741–1744)',
				'214' => 'Энкё (1744–1748)',
				'215' => 'Канъэн (1748–1751)',
				'216' => 'Хоряку (1751–1764)',
				'217' => 'Мэйва (1764–1772)',
				'218' => 'Анъэй (1772–1781)',
				'219' => 'Бунка (1804–1818)',
				'220' => 'Кансэй (1789–1801)',
				'221' => 'Кёва (1801–1804)',
				'222' => 'Бунка (1804–1818)',
				'223' => 'Бунсэй (1818–1830)',
				'224' => 'Тэмпо (1830–1844)',
				'225' => 'Кока (1844–1848)',
				'226' => 'Каэй (1848–1854)',
				'227' => 'Ансэй (1854–1860)',
				'228' => 'Манъэн (1860–1861)',
				'229' => 'Бункю (1861–1864)',
				'230' => 'Гендзи (1864–1865)',
				'231' => 'Кейо (1865–1868)',
				'232' => 'Мэйдзи',
				'233' => 'Тайсьо',
				'234' => 'Сьова',
				'235' => 'Хэйсэй',
				'236' => 'Рэйва'
			},
			wide => {
				'0' => 'Тайка тапхăрĕ (645–650)',
				'1' => 'Хакути тапхăрĕ (650–671)',
				'2' => 'Хакухо тапхăрĕ (672–686)',
				'3' => 'Сючё тапхăрĕ (686–701)',
				'4' => 'Тайхо тапхăрĕ (701–704)',
				'5' => 'Кёюн тапхăрĕ (704–708)',
				'6' => 'Вадо тапхăрĕ (708–715)',
				'7' => 'Рэйки тапхăрĕ (715–717)',
				'8' => 'Ёро тапхăрĕ (717–724)',
				'9' => 'Дзинки тапхăрĕ (724–729)',
				'10' => 'Темпьё тапхăрĕ (729–749)',
				'11' => 'Темпьё тапхăрĕ (749–749)',
				'12' => 'Темпьё-Сьохо тапхăрĕ (749-757)',
				'13' => 'Темпьё-Ходзи тапхăрĕ (757-765)',
				'14' => 'Темпьё-Ходзи тапхăрĕ (765-767)',
				'15' => 'Джинго-Кёюн тапхăрĕ (767-770)',
				'16' => 'Хоки тапхăрĕ (770–780)',
				'17' => 'Теньё тапхăрĕ (781–782)',
				'18' => 'Енряку тапхăрĕ (782–806)',
				'19' => 'Дайдо тапхăрĕ (806–810)',
				'20' => 'Конин тапхăрĕ (810–824)',
				'21' => 'Тентьо тапхăрĕ (824–834)',
				'22' => 'Шова тапхăрĕ (834–848)',
				'23' => 'Кайо тапхăрĕ (848–851)',
				'24' => 'Ниндзю тапхăрĕ (851–854)',
				'25' => 'Сайко тапхăрĕ (854–857)',
				'26' => 'Теннан тапхăрĕ (857–859)',
				'27' => 'Йоган тапхăрĕ (859–877)',
				'28' => 'Генкей тапхăрĕ (877–885)',
				'29' => 'Нинна тапхăрĕ (885–889)',
				'30' => 'Кампьё тапхăрĕ (889–898)',
				'31' => 'Сьотай тапхăрĕ (898–901)',
				'32' => 'Энги тапхăрĕ (901–923)',
				'33' => 'Ентьо тапхăрĕ (923–931)',
				'34' => 'Сьёхэй тапхăрĕ (931–938)',
				'35' => 'Тенгьо тапхăрĕ (938–947)',
				'36' => 'Тенрияку тапхăрĕ (947–957)',
				'37' => 'Тентоку тапхăрĕ (957–961)',
				'38' => 'Ова тапхăрĕ (961–964)',
				'39' => 'Кохо тапхăрĕ (964–968)',
				'40' => 'Анна тапхăрĕ (968–970)',
				'41' => 'Тенроку тапхăрĕ (970–973)',
				'42' => 'Теньен тапхăрĕ (973–976)',
				'43' => 'Дзьоген тапхăрĕ (976–978)',
				'44' => 'Тенген тапхăрĕ (978–983)',
				'45' => 'Ейкан тапхăрĕ (983–985)',
				'46' => 'Канна тапхăрĕ (985–987)',
				'47' => 'Ейен тапхăрĕ (987–989)',
				'48' => 'Ейсо тапхăрĕ (989–990)',
				'49' => 'Сёряку тапхăрĕ (990–995)',
				'50' => 'Тётоку тапхăрĕ (995–999)',
				'51' => 'Тёхо тапхăрĕ (999–1004)',
				'52' => 'Канко тапхăрĕ (1004–1012)',
				'53' => 'Тёва тапхăрĕ (1012–1017)',
				'54' => 'Каннин тапхăрĕ (1017–1021)',
				'55' => 'Дзиан тапхăрĕ (1021–1024)',
				'56' => 'Мандзю тапхăрĕ (1024–1028)',
				'57' => 'Тёгэн тапхăрĕ (1028–1037)',
				'58' => 'Тёряку тапхăрĕ (1037–1040)',
				'59' => 'Тёкю тапхăрĕ (1040–1044)',
				'60' => 'Катоку тапхăрĕ (1044–1046)',
				'61' => 'Эйсо тапхăрĕ (1046–1053)',
				'62' => 'Тэнги тапхăрĕ (1053–1058)',
				'63' => 'Кохэй тапхăрĕ (1058–1065)',
				'64' => 'Дзиряку тапхăрĕ (1065–1069)',
				'65' => 'Энкю тапхăрĕ (1069–1074)',
				'66' => 'Сёхо тапхăрĕ (1074–1077)',
				'67' => 'Сёряку тапхăрĕ (1077–1081)',
				'68' => 'Эйхо тапхăрĕ (1081–1084)',
				'69' => 'Отоку тапхăрĕ (1084–1087)',
				'70' => 'Кандзи тапхăрĕ (1087–1094)',
				'71' => 'Кахо тапхăрĕ (1094–1096)',
				'72' => 'Эйтё тапхăрĕ (1096–1097)',
				'73' => 'Сётоку тапхăрĕ (1097–1099)',
				'74' => 'Кова тапхăрĕ (1099–1104)',
				'75' => 'Тёдзи тапхăрĕ (1104–1106)',
				'76' => 'Касё тапхăрĕ (1106–1108)',
				'77' => 'Тэннин тапхăрĕ (1108–1110)',
				'78' => 'Тэнъэй тапхăрĕ (1110–1113)',
				'79' => 'Эйкю тапхăрĕ (1113–1118)',
				'80' => 'Гэнъэй тапхăрĕ (1118–1120)',
				'81' => 'Хоан тапхăрĕ (1120–1124)',
				'82' => 'Тэндзи тапхăрĕ (1124–1126)',
				'83' => 'Дайдзи тапхăрĕ (1126–1131)',
				'84' => 'Тэнсё тапхăрĕ (1131–1132)',
				'85' => 'Тёсё тапхăрĕ (1132–1135)',
				'86' => 'Хоэн тапхăрĕ (1135–1141)',
				'87' => 'Эйдзи тапхăрĕ (1141–1142)',
				'88' => 'Кодзи тапхăрĕ (1142–1144)',
				'89' => 'Тэнё тапхăрĕ (1144–1145)',
				'90' => 'Кюан тапхăрĕ (1145–1151)',
				'91' => 'Нимпэй тапхăрĕ (1151–1154)',
				'92' => 'Кюдзю тапхăрĕ (1154–1156)',
				'93' => 'Хогэн тапхăрĕ (1156–1159)',
				'94' => 'Хэйдзи тапхăрĕ (1159–1160)',
				'95' => 'Эйряку тапхăрĕ (1160–1161)',
				'96' => 'Охо тапхăрĕ (1161–1163)',
				'97' => 'Тёкан тапхăрĕ (1163–1165)',
				'98' => 'Эйман тапхăрĕ (1165–1166)',
				'99' => 'Нинъан тапхăрĕ (1166–1169)',
				'100' => 'Као тапхăрĕ (1169–1171)',
				'101' => 'Сёан тапхăрĕ (1171–1175)',
				'102' => 'Ангэн тапхăрĕ (1175–1177)',
				'103' => 'Дзисё тапхăрĕ (1177–1181)',
				'104' => 'Ёва тапхăрĕ (1181–1182)',
				'105' => 'Дзюэй тапхăрĕ (1182–1184)',
				'106' => 'Гэнрюку тапхăрĕ (1184–1185)',
				'107' => 'Бундзи тапхăрĕ (1185–1190)',
				'108' => 'Кэнкю тапхăрĕ (1190–1199)',
				'109' => 'Сёдзи тапхăрĕ (1199–1201)',
				'110' => 'Кэннин тапхăрĕ (1201–1204)',
				'111' => 'Гэнкю тапхăрĕ (1204–1206)',
				'112' => 'Кэнъэй тапхăрĕ (1206–1207)',
				'113' => 'Сёгэн тапхăрĕ (1207–1211)',
				'114' => 'Кэнряку тапхăрĕ (1211–1213)',
				'115' => 'Кэмпо тапхăрĕ (1213–1219)',
				'116' => 'Сёкю тапхăрĕ (1219–1222)',
				'117' => 'Дзёо тапхăрĕ (1222–1224)',
				'118' => 'Гэннин тапхăрĕ (1224–1225)',
				'119' => 'Кароку тапхăрĕ (1225–1227)',
				'120' => 'Антэй тапхăрĕ (1227–1229)',
				'121' => 'Канки тапхăрĕ (1229–1232)',
				'122' => 'Дзёэй тапхăрĕ (1232–1233)',
				'123' => 'Тэмпуку тапхăрĕ (1233–1234)',
				'124' => 'Бунряку тапхăрĕ (1234–1235)',
				'125' => 'Катэй тапхăрĕ (1235–1238)',
				'126' => 'Рякунин тапхăрĕ (1238–1239)',
				'127' => 'Энъо тапхăрĕ (1239–1240)',
				'128' => 'Ниндзи тапхăрĕ (1240–1243)',
				'129' => 'Кангэн тапхăрĕ (1243–1247)',
				'130' => 'Ходзи тапхăрĕ (1247–1249)',
				'131' => 'Кэнтё тапхăрĕ (1249–1256)',
				'132' => 'Когэн тапхăрĕ (1256–1257)',
				'133' => 'Сёка тапхăрĕ (1257–1259)',
				'134' => 'Сёгэн тапхăрĕ (1259–1260)',
				'135' => 'Бунъо тапхăрĕ (1260–1261)',
				'136' => 'Котё тапхăрĕ (1261–1264)',
				'137' => 'Бунъэй тапхăрĕ (1264–1275)',
				'138' => 'Кэндзи тапхăрĕ (1275–1278)',
				'139' => 'Коан тапхăрĕ (1278–1288)',
				'140' => 'Сёо тапхăрĕ (1288–1293)',
				'141' => 'Эйнин тапхăрĕ (1293–1299)',
				'142' => 'Сёан тапхăрĕ (1299–1302)',
				'143' => 'Кэнгэн тапхăрĕ (1302–1303)',
				'144' => 'Кагэн тапхăрĕ (1303–1306)',
				'145' => 'Токудзи тапхăрĕ (1306–1308)',
				'146' => 'Энкэй тапхăрĕ (1308–1311)',
				'147' => 'Отё тапхăрĕ (1311–1312)',
				'148' => 'Сёва тапхăрĕ (1312–1317)',
				'149' => 'Бумпо тапхăрĕ (1317–1319)',
				'150' => 'Гэно тапхăрĕ (1319–1321)',
				'151' => 'Гэнкё тапхăрĕ (1321–1324)',
				'152' => 'Сётю тапхăрĕ (1324–1326)',
				'153' => 'Карэки тапхăрĕ (1326–1329)',
				'154' => 'Гэнтоку тапхăрĕ (1329–1331)',
				'155' => 'Гэнко тапхăрĕ (1331–1334)',
				'156' => 'Кэмму тапхăрĕ (1334–1336)',
				'157' => 'Энгэн тапхăрĕ (1336–1340)',
				'158' => 'Кококу тапхăрĕ (1340–1346)',
				'159' => 'Сёхэй тапхăрĕ (1346–1370)',
				'160' => 'Кэнтоку тапхăрĕ (1370–1372)',
				'161' => 'Бунтю тапхăрĕ (1372–1375)',
				'162' => 'Иэндзю тапхăрĕ (1375–1379)',
				'163' => 'Коряку тапхăрĕ (1379–1381)',
				'164' => 'Кова тапхăрĕ (1381–1384)',
				'165' => 'Гэнтю тапхăрĕ (1384–1392)',
				'166' => 'Мэйтоку тапхăрĕ (1384–1387)',
				'167' => 'Какэй тапхăрĕ (1387–1389)',
				'168' => 'Коо тапхăрĕ (1389–1390)',
				'169' => 'Мэйтоку тапхăрĕ (1390–1394)',
				'170' => 'Оэй тапхăрĕ (1394–1428)',
				'171' => 'Сётё тапхăрĕ (1428–1429)',
				'172' => 'Эйкё тапхăрĕ (1429–1441)',
				'173' => 'Какицу тапхăрĕ (1441–1444)',
				'174' => 'Банъан тапхăрĕ (1444–1449)',
				'175' => 'Хотоку тапхăрĕ (1449–1452)',
				'176' => 'Кётоку тапхăрĕ (1452–1455)',
				'177' => 'Косё тапхăрĕ (1455–1457)',
				'178' => 'Тёроку тапхăрĕ (1457–1460)',
				'179' => 'Кансё тапхăрĕ (1460–1466)',
				'180' => 'Бунсё тапхăрĕ (1466–1467)',
				'181' => 'Онин тапхăрĕ (1467–1469)',
				'182' => 'Буммэй тапхăрĕ (1469–1487)',
				'183' => 'Тёкё тапхăрĕ (1487–1489)',
				'184' => 'Энтоку тапхăрĕ (1489–1492)',
				'185' => 'Мэйо тапхăрĕ (1492–1501)',
				'186' => 'Бунки тапхăрĕ (1501–1504)',
				'187' => 'Эйсё тапхăрĕ (1504–1521)',
				'188' => 'Тайэй тапхăрĕ (1521–1528)',
				'189' => 'Кёроку тапхăрĕ (1528–1532)',
				'190' => 'Тэммон тапхăрĕ (1532–1555)',
				'191' => 'Кодзи тапхăрĕ (1555–1558)',
				'192' => 'Эйроку тапхăрĕ (1558–1570)',
				'193' => 'Гэнки тапхăрĕ (1570–1573)',
				'194' => 'Тэнсё тапхăрĕ (1573–1592)',
				'195' => 'Бунроку тапхăрĕ (1592–1596)',
				'196' => 'Кэйтё тапхăрĕ (1596–1615)',
				'197' => 'Гэнва тапхăрĕ (1615–1624)',
				'198' => 'Канъэй тапхăрĕ (1624–1644)',
				'199' => 'Сёхо тапхăрĕ (1644–1648)',
				'200' => 'Кэйан тапхăрĕ (1648–1652)',
				'201' => 'Сё тапхăрĕ (1652–1655)',
				'202' => 'Мэйряку тапхăрĕ (1655–1658)',
				'203' => 'Мандзи тапхăрĕ (1658–1661)',
				'204' => 'Камбун тапхăрĕ (1661–1673)',
				'205' => 'Эмпо тапхăрĕ (1673–1681)',
				'206' => 'Тэнва тапхăрĕ (1681–1684)',
				'207' => 'Дзёкё тапхăрĕ (1684–1688)',
				'208' => 'Гэнроку тапхăрĕ (1688–1704)',
				'209' => 'Хоэй тапхăрĕ (1704–1711)',
				'210' => 'Сётоку тапхăрĕ (1711–1716)',
				'211' => 'Кёхо тапхăрĕ (1716–1736)',
				'212' => 'Гэмбун тапхăрĕ (1736–1741)',
				'213' => 'Кампо тапхăрĕ (1741–1744)',
				'214' => 'Энкё тапхăрĕ (1744–1748)',
				'215' => 'Канъэн тапхăрĕ (1748–1751)',
				'216' => 'Хоряку тапхăрĕ (1751–1764)',
				'217' => 'Мэйва тапхăрĕ (1764–1772)',
				'218' => 'Анъэй тапхăрĕ (1772–1781)',
				'219' => 'Тэммэй тапхăрĕ (1781–1789)',
				'220' => 'Кансэй тапхăрĕ (1789–1801)',
				'221' => 'Кёва тапхăрĕ (1801–1804)',
				'222' => 'Бунка тапхăрĕ (1804–1818)',
				'223' => 'Бунсэй тапхăрĕ (1818–1830)',
				'224' => 'Тэмпо тапхăрĕ (1830–1844)',
				'225' => 'Кока тапхăрĕ (1844–1848)',
				'226' => 'Каэй тапхăрĕ (1848–1854)',
				'227' => 'Ансэй тапхăрĕ (1854–1860)',
				'228' => 'Манъэн тапхăрĕ (1860–1861)',
				'229' => 'Бункю тапхăрĕ (1861–1864)',
				'230' => 'Гендзи тапхăрĕ (1864–1865)',
				'231' => 'Кейо тапхăрĕ (1865–1868)',
				'232' => 'Мэйдзи тапхăрĕ',
				'233' => 'Тайсьо тапхăрĕ',
				'234' => 'Сьова тапхăрĕ',
				'235' => 'Хэйсэй тапхăрĕ',
				'236' => 'Рэйва тапхăрĕ'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'перс ҫулӗ'
			},
			narrow => {
				'0' => 'перс ҫ.'
			},
			wide => {
				'0' => 'перси ҫулӗ'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'К.р-ки нкс.трн.',
				'1' => 'Миньго'
			},
			narrow => {
				'0' => 'Миньго ҫтчн',
				'1' => 'Миньго'
			},
			wide => {
				'0' => 'Китай республикин никӗсӗ таран',
				'1' => 'Миньго'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'dangi' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, d MMMM y 'ҫ'. G},
			'long' => q{d MMMM y 'ҫ'. G},
			'medium' => q{d MMM y 'ҫ'. G},
			'short' => q{dd.MM.y G},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y 'ҫ'.},
			'long' => q{d MMMM y 'ҫ'.},
			'medium' => q{d MMM y 'ҫ'.},
			'short' => q{dd.MM.y},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'dangi' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'chinese' => {
		},
		'coptic' => {
		},
		'dangi' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			EHm => q{ccc HH:mm},
			EHms => q{ccc HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{ccc, h:mm a},
			Ehms => q{ccc, h:mm:ss a},
			Gy => q{y 'ҫ'. G},
			GyMMM => q{LLL y 'ҫ'. G},
			GyMMMEd => q{E, d MMM y 'ҫ'. G},
			GyMMMd => q{d MMM y 'ҫ'. G},
			GyMd => q{dd.MM.y G},
			MEd => q{E, dd.MM},
			MMMEd => q{ccc, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			y => q{y 'ҫ'. G},
			yyyy => q{y 'ҫ'. G},
			yyyyM => q{MM.y G},
			yyyyMEd => q{E, dd.MM.y G},
			yyyyMMM => q{LLL y 'ҫ'. G},
			yyyyMMMEd => q{E, d MMM y 'ҫ'. G},
			yyyyMMMM => q{LLLL y 'ҫ'. G},
			yyyyMMMd => q{d MMM y 'ҫ'. G},
			yyyyMd => q{dd.MM.y G},
			yyyyQQQ => q{QQQ y 'ҫ'. G},
			yyyyQQQQ => q{QQQQ y 'ҫ'. G},
		},
		'gregorian' => {
			EBhm => q{ccc, h:mm B},
			EBhms => q{ccc, h:mm:ss B},
			Ed => q{ccc, d},
			Ehms => q{E h:mm:ss a},
			Gy => q{y 'ҫ'. G},
			GyMMM => q{LLL y 'ҫ'. G},
			GyMMMEd => q{E, d MMM y 'ҫ'. G},
			GyMMMd => q{d MMM y 'ҫ'. G},
			GyMd => q{dd.MM.y GGGGG},
			MEd => q{E, dd.MM},
			MMMEd => q{ccc, d MMM},
			MMMMW => q{MMMM W-'мӗш' 'эрни'},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			yM => q{MM.y},
			yMEd => q{ccc, dd.MM.y 'ҫ'.},
			yMMM => q{LLL y 'ҫ'.},
			yMMMEd => q{E, d MMM y 'ҫ'.},
			yMMMM => q{LLLL y 'ҫ'.},
			yMMMd => q{d MMM y 'ҫ'.},
			yMd => q{dd.MM.y},
			yQQQ => q{QQQ y 'ҫ'.},
			yQQQQ => q{QQQQ y 'ҫ'.},
			yw => q{w-'мӗш' 'эрни' Y 'ҫ'.},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
		'coptic' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
		'dangi' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
		'ethiopic' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
		'generic' => {
			Gy => {
				G => q{y 'ҫ'. G – y 'ҫ'. G},
				y => q{y–y 'ҫҫ'. G},
			},
			GyM => {
				G => q{MM.y G – MM.y G},
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			GyMEd => {
				G => q{ccc, dd.MM.y G – ccc, dd.MM.y G},
				M => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y G},
			},
			GyMMM => {
				G => q{LLL y 'ҫ'. G – LLL y 'ҫ'. G},
				M => q{LLL – LLL y 'ҫ'. G},
				y => q{LLL y – LLL y 'ҫҫ'. G},
			},
			GyMMMEd => {
				G => q{ccc, d MMM y 'ҫ'. G – ccc, d MMM y 'ҫ'. G},
				M => q{ccc, d MMM – ccc, d MMM y 'ҫ'. G},
				d => q{ccc, d MMM – ccc, d MMM y 'ҫ'. G},
				y => q{ccc, d MMM y – ccc, d MMM y 'ҫҫ'. G},
			},
			GyMMMd => {
				G => q{d MMM y 'ҫ'. G – d MMM y 'ҫ'. G},
				M => q{d MMM – d MMM y 'ҫ'. G},
				d => q{d–d MMM y 'ҫ'. G},
				y => q{d MMM y – d MMM y 'ҫҫ'. G},
			},
			GyMd => {
				G => q{dd.MM.y G – dd.MM.y G},
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMMEd => {
				M => q{ccc, d MMM – ccc, d MMM},
				d => q{ccc, d MMM – ccc, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			y => {
				y => q{y–y 'ҫҫ'. G},
			},
			yM => {
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			yMEd => {
				M => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y G},
			},
			yMMM => {
				M => q{LLL – LLL y 'ҫ'. G},
				y => q{LLL y 'ҫ'. – LLL y 'ҫ'. G},
			},
			yMMMEd => {
				M => q{ccc, d MMM – ccc, d MMM y 'ҫ'. G},
				d => q{ccc, d MMM – ccc, d MMM y 'ҫ'. G},
				y => q{ccc, d MMM y 'ҫ'. – ccc, d MMM y 'ҫ'. G},
			},
			yMMMM => {
				M => q{LLLL – LLLL y 'ҫ'. G},
				y => q{LLLL y 'ҫ'. – LLLL y 'ҫ'. G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y 'ҫ'. G},
				d => q{d–d MMM y 'ҫ'. G},
				y => q{d MMM y 'ҫ'. – d MMM y 'ҫ'. G},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
		},
		'gregorian' => {
			Gy => {
				G => q{y 'ҫ'. G – y 'ҫ'. G},
				y => q{y–y 'ҫҫ'. G},
			},
			GyM => {
				G => q{MM.y G – MM.y G},
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			GyMEd => {
				G => q{ccc, dd.MM.y G – ccc, dd.MM.y G},
				M => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y G},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y G},
			},
			GyMMM => {
				G => q{LLL y 'ҫ'. G – LLL y 'ҫ'. G},
				M => q{LLL – LLL y 'ҫ'. G},
				y => q{LLL y – LLL y 'ҫҫ'. G},
			},
			GyMMMEd => {
				G => q{ccc, d MMM y 'ҫ'. G – ccc, d MMM y 'ҫ'. G},
				M => q{ccc, d MMM – ccc, d MMM y 'ҫ'. G},
				d => q{ccc, d MMM – ccc, d MMM y 'ҫ'. G},
				y => q{ccc, d MMM y – ccc, d MMM y 'ҫҫ'. G},
			},
			GyMMMd => {
				G => q{d MMM y 'ҫ'. G – d MMM y 'ҫ'. G},
				M => q{d MMM – d MMM y 'ҫ'. G},
				d => q{d–d MMM y 'ҫ'. G},
				y => q{d MMM y – d MMM y 'ҫҫ'. G},
			},
			GyMd => {
				G => q{dd.MM.y G – dd.MM.y G},
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{ccc, dd.MM.y – ccc, dd.MM.y},
				d => q{ccc, dd.MM.y – ccc, dd.MM.y},
				y => q{ccc, dd.MM.y – ccc, dd.MM.y},
			},
			yMMM => {
				M => q{LLL – LLL y 'ҫ'.},
				y => q{LLL y 'ҫ'. – LLL y 'ҫ'.},
			},
			yMMMEd => {
				M => q{ccc, d MMM – ccc, d MMM y 'ҫ'.},
				d => q{ccc, d – ccc, d MMM y 'ҫ'.},
				y => q{ccc, d MMM y 'ҫ'. – ccc, d MMM y 'ҫ'.},
			},
			yMMMM => {
				M => q{LLLL – LLLL y 'ҫ'.},
				y => q{LLLL y 'ҫ'. – LLLL y 'ҫ'.},
			},
			yMMMd => {
				M => q{d MMM – d MMM y 'ҫ'.},
				d => q{d–d MMM y 'ҫ'.},
				y => q{d MMM y 'ҫ'. – d MMM y 'ҫ'.},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
		'hebrew' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
		'indian' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
		'islamic' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
		'japanese' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
		'persian' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
		'roc' => {
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
		},
	} },
);

has 'cyclic_name_sets' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'dangi' => {
			'solarTerms' => {
				'format' => {
					'abbreviated' => {
						0 => q(ҫуркунне пуҫланать),
						1 => q(ҫумӑр шывӗ),
						2 => q(хурт-кӑпшанкӑ вӑранать),
						3 => q(çурхи кунпа çĕр танлашăвĕ),
						4 => q(йăлтăр та янкӑр уяр),
						5 => q(тӗштырӑ ҫумӑр),
						6 => q(ҫу пуҫланать),
						7 => q(тулли тырӑ),
						8 => q(пучахри тырӑ),
						9 => q(кун таврӑнни),
						10 => q(лĕп ăшă),
						11 => q(шăрăх),
						12 => q(кӗркунне пуҫланать),
						13 => q(шӑрӑх вӗҫленни),
						14 => q(шурӑ сывлӑм),
						15 => q(кӗркунне кунпа ҫӗр танлашни),
						16 => q(сивӗ сывлӑм),
						17 => q(сивӗтет),
						18 => q(хӗл пуҫланать),
						19 => q(юр ҫуни),
						20 => q(вӑйлӑ юр ҫӑвать),
						21 => q(кун хутшӑнни),
						22 => q(вӑйсӑр сивӗ),
						23 => q(хаяр сивĕ),
					},
					'narrow' => {
						0 => q(ҫуркунне пуҫланать),
						1 => q(ҫумӑр шывӗ),
						2 => q(хурт-кӑпшанкӑ вӑранать),
						3 => q(çурхи кунпа çĕр танлашăвĕ),
						4 => q(йăлтăр та янкӑр уяр),
						5 => q(тӗштырӑ ҫумӑр),
						6 => q(ҫу пуҫланать),
						7 => q(тулли тырӑ),
						8 => q(пучахри тырӑ),
						9 => q(кун таврӑнни),
						10 => q(лĕп ăшă),
						11 => q(шăрăх),
						12 => q(кӗркунне пуҫланать),
						13 => q(шӑрӑх вӗҫленни),
						14 => q(шурӑ сывлӑм),
						15 => q(кӗркунне кунпа ҫӗр танлашни),
						16 => q(сивӗ сывлӑм),
						17 => q(сивӗтет),
						18 => q(хӗл пуҫланать),
						19 => q(юр ҫуни),
						20 => q(вӑйлӑ юр ҫӑвать),
						21 => q(кун хутшӑнни),
						22 => q(вӑйсӑр сивӗ),
						23 => q(хаяр сивĕ),
					},
					'wide' => {
						0 => q(ҫуркунне пуҫланать),
						1 => q(ҫумӑр шывӗ),
						2 => q(хурт-кӑпшанкӑ вӑранать),
						3 => q(çурхи кунпа çĕр танлашăвĕ),
						4 => q(йăлтăр та янкӑр уяр),
						5 => q(тӗштырӑ ҫумӑр),
						6 => q(ҫу пуҫланать),
						7 => q(тулли тырӑ),
						8 => q(пучахри тырӑ),
						9 => q(кун таврӑнни),
						10 => q(лĕп ăшă),
						11 => q(шăрăх),
						12 => q(кӗркунне пуҫланать),
						13 => q(шӑрӑх вӗҫленни),
						14 => q(шурӑ сывлӑм),
						15 => q(кӗркунне кунпа ҫӗр танлашни),
						16 => q(сивӗ сывлӑм),
						17 => q(сивӗтет),
						18 => q(хӗл пуҫланать),
						19 => q(юр ҫуни),
						20 => q(вӑйлӑ юр ҫӑвать),
						21 => q(кун хутшӑнни),
						22 => q(вӑйсӑр сивӗ),
						23 => q(хаяр сивĕ),
					},
				},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q({0} ҫуллахи вӑхӑчӗ),
		regionFormat => q({0} стандартлӑ вӑхӑчӗ),
		'Acre' => {
			long => {
				'daylight' => q#Акри ҫуллахи вӑхӑчӗ#,
				'generic' => q#Акри вӑхӑчӗ#,
				'standard' => q#Акри стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ACST Acre#,
				'generic' => q#ACT Acre#,
				'standard' => q#ACT Acre#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#Афганистан вӑхӑчӗ#,
			},
			short => {
				'standard' => q#AFT#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиджан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмэра#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Банги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавиль#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каир#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-эс-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Джибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эль-Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Джуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревиль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуту#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишо#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монрови#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нджамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Тӗп Африка вӑхӑчӗ#,
			},
			short => {
				'standard' => q#CAT#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Хӗвелтухӑҫ Африка вӑхӑчӗ#,
			},
			short => {
				'standard' => q#EAT#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Кӑнтӑр Африка вӑхӑчӗ#,
			},
			short => {
				'standard' => q#SAST#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Анӑҫ Африка ҫуллахи вӑхӑчӗ#,
				'generic' => q#Анӑҫ Африка вӑхӑчӗ#,
				'standard' => q#Анӑҫ Африка стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#WAST#,
				'generic' => q#WAT#,
				'standard' => q#WAT#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Аляска ҫуллахи вӑхӑчӗ#,
				'generic' => q#Аляска вӑхӑчӗ#,
				'standard' => q#Аляска стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#AKDT#,
				'generic' => q#AKT#,
				'standard' => q#AKST#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#Алматы ҫуллахи вӑхӑчӗ#,
				'generic' => q#Алматы вӑхӑчӗ#,
				'standard' => q#Алматы стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ALMT DST#,
				'generic' => q#ALMT#,
				'standard' => q#ALMT#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазонка ҫуллахи вӑхӑчӗ#,
				'generic' => q#Амазонка вӑхӑчӗ#,
				'standard' => q#Амазонка стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#AMST#,
				'generic' => q#AMT#,
				'standard' => q#AMT#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкоридж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилья#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуаина#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио-Гальегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Сальта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан-Луис Сан-Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуая#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсьон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Баия#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баия-де-Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белен#,
		},
		'America/Belize' => {
			exemplarCity => q#Белиз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа-Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойсе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кеймбридж-Бей#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампу-Гранди#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайенна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман утравӗсем#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чиуауа#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#Сьюдад-Хуарес#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал-Харбор#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Денмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон-Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Сальвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нельсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс-Бей#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус-Бей#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд-Терк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупа#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякиль#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гайана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Галифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Гавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Эрмосильо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсберг, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Телл-Сити, Индиана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вевей, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсеннес, Индиана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Уинамак, Индиана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Джуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтиселло, Кентукки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендейк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла-Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анджелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуэр-Принс-Куотер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиника#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Масатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтеррей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норонья#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бойла, Ҫурҫӗр Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центр, Ҫурҫӗр Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Сейлем, Ҫурҫӗр Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт-оф-Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порту-Велью#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта-Аренас#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин-Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Реджайна#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резольют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Риу-Бранку#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарен#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто-Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорсбисунн#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сен-Бартелеми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент-Джонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент-Люсия#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент-Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт-Керрент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Виннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Тӗп Америка ҫуллахи вӑхӑчӗ#,
				'generic' => q#Тӗп Америка вӑхӑчӗ#,
				'standard' => q#Тӗп Америка стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#CDT#,
				'generic' => q#CT#,
				'standard' => q#CST#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Хӗвелтухӑҫ Америка ҫуллахи вӑхӑчӗ#,
				'generic' => q#Хӗвелтухӑҫ Америка вӑхӑчӗ#,
				'standard' => q#Хӗвелтухӑҫ Америка стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#EDT#,
				'generic' => q#ET#,
				'standard' => q#EST#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Ҫуллахи ту вӑхӑчӗ (Ҫурҫӗр Америка)#,
				'generic' => q#Ту вӑхӑчӗ (Ҫурҫӗр Америка)#,
				'standard' => q#Стандартлӑ ту вӑхӑчӗ (Ҫурҫӗр Америка)#,
			},
			short => {
				'daylight' => q#MDT#,
				'generic' => q#MT#,
				'standard' => q#MST#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Лӑпкӑ океан ҫуллахи вӑхӑчӗ#,
				'generic' => q#Лӑпкӑ океан вӑхӑчӗ#,
				'standard' => q#Лӑпкӑ океан стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#PDT#,
				'generic' => q#PT#,
				'standard' => q#PST#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#Анадырь ҫуллахи вӑхӑчӗ#,
				'generic' => q#Анадырь вӑхӑчӗ#,
				'standard' => q#Анадырь стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ANAST#,
				'generic' => q#ANAT#,
				'standard' => q#ANAT#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дейвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон-д’Юрвиль Дюмон-д’Юрвиль#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мердо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сёва#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролль#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Апиа ҫуллахи вӑхӑчӗ#,
				'generic' => q#Апиа вӑхӑчӗ#,
				'standard' => q#Апиа стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#SST Samoa Apia DST#,
				'generic' => q#SST Samoa Apia#,
				'standard' => q#SST Samoa Apia#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#Актау ҫуллахи вӑхӑчӗ#,
				'generic' => q#Актау вӑхӑчӗ#,
				'standard' => q#Актау стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ALMT Aktau DST#,
				'generic' => q#ALMT Aktau#,
				'standard' => q#ALMT Aktau#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#Актобе ҫуллахи вӑхӑчӗ#,
				'generic' => q#Актобе вӑхӑчӗ#,
				'standard' => q#Актобе стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#AQTT DST#,
				'generic' => q#AQTT#,
				'standard' => q#AQTT#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Арап ҫуллахи вӑхӑчӗ#,
				'generic' => q#Арап вӑхӑчӗ#,
				'standard' => q#Арап стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ADT Arabia#,
				'generic' => q#AST Arabia#,
				'standard' => q#AST Arabia#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгйир#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентина ҫуллахи вӑхӑчӗ#,
				'generic' => q#Аргентина вӑхӑчӗ#,
				'standard' => q#Аргентина стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ARST#,
				'generic' => q#ART#,
				'standard' => q#ART#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Анӑҫ Аргентина ҫуллахи вӑхӑчӗ#,
				'generic' => q#Анӑҫ Аргентина вӑхӑчӗ#,
				'standard' => q#Анӑҫ Аргентина стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#WARST#,
				'generic' => q#WART#,
				'standard' => q#WART#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Армени ҫуллахи вӑхӑчӗ#,
				'generic' => q#Армени вӑхӑчӗ#,
				'standard' => q#Армени стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#AMST Armenia#,
				'generic' => q#AMT Armenia#,
				'standard' => q#AMT Armenia#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алматы#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадырь#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атырау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калькутта#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеврон#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Гонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Джакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Джаяпура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Иерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Петропавловск-Камчатски#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандыга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала-Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Маскат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никоси#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Уральск#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхеньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#Костанай#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кызылорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Янгон#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Эр-Рияд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хошимин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин утравӗ#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколымск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайбэй#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхимпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан-Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Усть-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вьентьян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантика ҫуллахи вӑхӑчӗ#,
				'generic' => q#Атлантика вӑхӑчӗ#,
				'standard' => q#Атлантика стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ADT#,
				'generic' => q#AT#,
				'standard' => q#AST#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азор утравӗсем#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуд утравӗсем#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канар утравӗсем#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо-Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарер утравӗсем#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкьявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Кӑнтӑр Георги#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Сӑваплӑ Елена утравӗ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стэнли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен-Хилл#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Юкла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд-Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Тӗп Австрали ҫуллахи вӑхӑчӗ#,
				'generic' => q#Тӗп Австрали вӑхӑчӗ#,
				'standard' => q#Тӗп Австрали стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ACDT#,
				'generic' => q#ACST#,
				'standard' => q#ACST#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Тӗп Австрали анӑҫ ҫуллахи вӑхӑчӗ#,
				'generic' => q#Тӗп Австрали анӑҫ вӑхӑчӗ#,
				'standard' => q#Тӗп Австрали анӑҫ стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ACWDT#,
				'generic' => q#ACWST#,
				'standard' => q#ACWST#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Хӗвелтухӑҫ Австрали ҫуллахи вӑхӑчӗ#,
				'generic' => q#Хӗвелтухӑҫ Австрали вӑхӑчӗ#,
				'standard' => q#Хӗвелтухӑҫ Австрали стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#AEDT#,
				'generic' => q#AEST#,
				'standard' => q#AEST#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Анӑҫ Австрали ҫуллахи вӑхӑчӗ#,
				'generic' => q#Анӑҫ Австрали вӑхӑчӗ#,
				'standard' => q#Анӑҫ Австрали стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#AWDT#,
				'generic' => q#AWST#,
				'standard' => q#AWST#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Азербайджан ҫуллахи вӑхӑчӗ#,
				'generic' => q#Азербайджан вӑхӑчӗ#,
				'standard' => q#Азербайджан стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#AZST#,
				'generic' => q#AZT#,
				'standard' => q#AZT#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азор утравӗсен ҫуллахи вӑхӑчӗ#,
				'generic' => q#Азор утравӗсен вӑхӑчӗ#,
				'standard' => q#Азор утравӗсен стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#AZOST#,
				'generic' => q#AZOT#,
				'standard' => q#AZOT#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладеш ҫуллахи вӑхӑчӗ#,
				'generic' => q#Бангладеш вӑхӑчӗ#,
				'standard' => q#Бангладеш стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#BDT Bangladesh#,
				'generic' => q#BST Bangladesh#,
				'standard' => q#BST Bangladesh#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутан вӑхӑчӗ#,
			},
			short => {
				'standard' => q#BTT#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливи вӑхӑчӗ#,
			},
			short => {
				'standard' => q#BOT#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразили ҫуллахи вӑхӑчӗ#,
				'generic' => q#Бразили вӑхӑчӗ#,
				'standard' => q#Бразили стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#BRST#,
				'generic' => q#BRT#,
				'standard' => q#BRT#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Бруней-Даруссалам вӑхӑчӗ#,
			},
			short => {
				'standard' => q#BNT#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Кабо-Верде ҫуллахи вӑхӑчӗ#,
				'generic' => q#Кабо-Верде вӑхӑчӗ#,
				'standard' => q#Кабо-Верде стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#CVST#,
				'generic' => q#CVT#,
				'standard' => q#CVT#,
			},
		},
		'Casey' => {
			long => {
				'standard' => q#Кейси вӑхӑчӗ#,
			},
			short => {
				'standard' => q#CAST#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Чаморро вӑхӑчӗ#,
			},
			short => {
				'standard' => q#ChST#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатем ҫуллахи вӑхӑчӗ#,
				'generic' => q#Чатем вӑхӑчӗ#,
				'standard' => q#Чатем стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#CHADT#,
				'generic' => q#CHAST#,
				'standard' => q#CHAST#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чили ҫуллахи вӑхӑчӗ#,
				'generic' => q#Чили вӑхӑчӗ#,
				'standard' => q#Чили стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#CLST#,
				'generic' => q#CLT#,
				'standard' => q#CLT#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Китай ҫуллахи вӑхӑчӗ#,
				'generic' => q#Китай вӑхӑчӗ#,
				'standard' => q#Китай стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#CST China DST#,
				'generic' => q#CST China#,
				'standard' => q#CST China#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Раштав утравӗн вӑхӑчӗ#,
			},
			short => {
				'standard' => q#CXT#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокос утравӗсен вӑхӑчӗ#,
			},
			short => {
				'standard' => q#CCT#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумби ҫуллахи вӑхӑчӗ#,
				'generic' => q#Колумби вӑхӑчӗ#,
				'standard' => q#Колумби стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#COST#,
				'generic' => q#COT#,
				'standard' => q#COT#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Кукӑн утравӗсен ҫуллахи вӑхӑчӗ#,
				'generic' => q#Кукӑн утравӗсен вӑхӑчӗ#,
				'standard' => q#Кукӑн утравӗсен стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#CKT DST#,
				'generic' => q#CKT#,
				'standard' => q#CKT#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Куба ҫуллахи вӑхӑчӗ#,
				'generic' => q#Куба вӑхӑчӗ#,
				'standard' => q#Куба стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#CDT Cuba#,
				'generic' => q#CST Cuba#,
				'standard' => q#CST Cuba#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Дейвис вӑхӑчӗ#,
			},
			short => {
				'standard' => q#DAVT#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Дюмон-д’Юрвиль вӑхӑчӗ#,
			},
			short => {
				'standard' => q#DDUT#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Хӗвелтухӑҫ Тимор вӑхӑчӗ#,
			},
			short => {
				'standard' => q#TLT#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Мӑнкун утравӗн ҫуллахи вӑхӑчӗ#,
				'generic' => q#Мӑнкун утравӗн вӑхӑчӗ#,
				'standard' => q#Мӑнкун утравӗн стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#EASST#,
				'generic' => q#EAST#,
				'standard' => q#EAST#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Эквадор вӑхӑчӗ#,
			},
			short => {
				'standard' => q#ECT Ecuador#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Пӗтӗм тӗнчери координацилене вӑхӑчӗ#,
			},
			short => {
				'standard' => q#ПТКВ (UTC)#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Паллӑ мар хула#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астрахань#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афинсем#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бюзинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q#Ирланди стандартлӑ вӑхӑчӗ#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хельсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Мэн утравӗ#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Стамбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Джерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лиссабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Британи ҫуллахи вӑхӑчӗ#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Мариехамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Мускав#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопье#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софи#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокгольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Ульяновск#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вильнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Тӗп Европа ҫуллахи вӑхӑчӗ#,
				'generic' => q#Тӗп Европа вӑхӑчӗ#,
				'standard' => q#Тӗп Европа стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#CEST#,
				'generic' => q#CET#,
				'standard' => q#CET#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Хӗвелтухӑҫ Европа ҫуллахи вӑхӑчӗ#,
				'generic' => q#Хӗвелтухӑҫ Европа вӑхӑчӗ#,
				'standard' => q#Хӗвелтухӑҫ Европа стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#EEST#,
				'generic' => q#EET#,
				'standard' => q#EET#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Инҫет-хӗвелтухӑҫ Европа вӑхӑчӗ#,
			},
			short => {
				'standard' => q#FEET#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Анӑҫ Европа ҫуллахи вӑхӑчӗ#,
				'generic' => q#Анӑҫ Европа вӑхӑчӗ#,
				'standard' => q#Анӑҫ Европа стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#WEST#,
				'generic' => q#WET#,
				'standard' => q#WET#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолкленд утравӗсен ҫуллахи вӑхӑчӗ#,
				'generic' => q#Фолкленд утравӗсен вӑхӑчӗ#,
				'standard' => q#Фолкленд утравӗсен стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#FKST#,
				'generic' => q#FKT#,
				'standard' => q#FKT#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фиджи ҫуллахи вӑхӑчӗ#,
				'generic' => q#Фиджи вӑхӑчӗ#,
				'standard' => q#Фиджи стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#FJT Summer#,
				'generic' => q#FJT#,
				'standard' => q#FJT#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Франци Гвиана вӑхӑчӗ#,
			},
			short => {
				'standard' => q#GFT#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Франци Кӑнтӑрпа Антарктика территорийӗсен вӑхӑчӗ#,
			},
			short => {
				'standard' => q#TAAF#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Гринвичпа вӑтам вӑхӑчӗ#,
			},
			short => {
				'standard' => q#GMT#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагос утравӗсен вӑхӑчӗ#,
			},
			short => {
				'standard' => q#GALT#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбье вӑхӑчӗ#,
			},
			short => {
				'standard' => q#GAMT#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Грузи ҫуллахи вӑхӑчӗ#,
				'generic' => q#Грузи вӑхӑчӗ#,
				'standard' => q#Грузи стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#GEST#,
				'generic' => q#GET#,
				'standard' => q#GET#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Гилбертӑн утравӗсен вӑхӑчӗ#,
			},
			short => {
				'standard' => q#GIT#,
			},
		},
		'Greenland' => {
			long => {
				'daylight' => q#Гренланди ҫуллахи вӑхӑчӗ#,
				'generic' => q#Гренланди вӑхӑчӗ#,
				'standard' => q#Гренланди стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#GNSST#,
				'generic' => q#GNST#,
				'standard' => q#GNST#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Хӗвелтухӑҫ Гринланди ҫуллахи вӑхӑчӗ#,
				'generic' => q#Хӗвелтухӑҫ Гринланди вӑхӑчӗ#,
				'standard' => q#Хӗвелтухӑҫ Гринланди стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#EGST#,
				'generic' => q#EGT#,
				'standard' => q#EGT#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Анӑҫ ҫуллахи вӑхӑчӗ#,
				'generic' => q#Анӑҫ Гринланди вӑхӑчӗ#,
				'standard' => q#Анӑҫ Гринланди стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#WGST#,
				'generic' => q#WGT#,
				'standard' => q#WGT#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#Гуам стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'standard' => q#GST Guam#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Перси залив вӑхӑчӗ#,
			},
			short => {
				'standard' => q#GST Gulf#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гайана вӑхӑчӗ#,
			},
			short => {
				'standard' => q#GYT#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Гавайи Алеут ҫуллахи вӑхӑчӗ#,
				'generic' => q#Гавайи Алеут вӑхӑчӗ#,
				'standard' => q#Гавайи Алеут стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#HDT#,
				'generic' => q#HST#,
				'standard' => q#HST#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Гонконг ҫуллахи вӑхӑчӗ#,
				'generic' => q#Гонконг вӑхӑчӗ#,
				'standard' => q#Гонконг стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#HKT DST#,
				'generic' => q#HKT#,
				'standard' => q#HKT#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховд ҫуллахи вӑхӑчӗ#,
				'generic' => q#Ховд вӑхӑчӗ#,
				'standard' => q#Ховд стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#HOVST#,
				'generic' => q#HOVT#,
				'standard' => q#HOVT#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Инди вӑхӑчӗ#,
			},
			short => {
				'standard' => q#IST Indian#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариву#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Раштав утравӗ#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос утравӗсем#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморсем#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Маэ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдивсем#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврикий#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюньон#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Инди океанӗ вӑхӑчӗ#,
			},
			short => {
				'standard' => q#IOT#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Индокитай вӑхӑчӗ#,
			},
			short => {
				'standard' => q#ICT#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Тӗп Индонези вӑхӑчӗ#,
			},
			short => {
				'standard' => q#CIT#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Хӗвелтухӑҫ Индонези вӑхӑчӗ#,
			},
			short => {
				'standard' => q#EIT#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Анӑҫ Индонези вӑхӑчӗ#,
			},
			short => {
				'standard' => q#WIT#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Иран ҫуллахи вӑхӑчӗ#,
				'generic' => q#Иран вӑхӑчӗ#,
				'standard' => q#Иран стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#IRST DST#,
				'generic' => q#IRST#,
				'standard' => q#IRST#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Иркутск ҫуллахи вӑхӑчӗ#,
				'generic' => q#Иркутск вӑхӑчӗ#,
				'standard' => q#Иркутск стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#IRKST#,
				'generic' => q#IRKT#,
				'standard' => q#IRKT#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Израиль ҫуллахи вӑхӑчӗ#,
				'generic' => q#Израиль вӑхӑчӗ#,
				'standard' => q#Израиль стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#IDT#,
				'generic' => q#IST Israel#,
				'standard' => q#IST Israel#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Япони ҫуллахи вӑхӑчӗ#,
				'generic' => q#Япони вӑхӑчӗ#,
				'standard' => q#Япони стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#JST DST#,
				'generic' => q#JST#,
				'standard' => q#JST#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#Петропавловск-Камчаткăри ҫуллахи вӑхӑчӗ#,
				'generic' => q#Петропавловск-Камчаткăри вӑхӑчӗ#,
				'standard' => q#Петропавловск-Камчаткăри стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#PETDT#,
				'generic' => q#PETT#,
				'standard' => q#PETST#,
			},
		},
		'Kazakhstan' => {
			long => {
				'standard' => q#Казахстан вӑхӑчӗ#,
			},
			short => {
				'standard' => q#Казахстан вхч#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Хӗвелтухӑҫ Казахстан вӑхӑчӗ#,
			},
			short => {
				'standard' => q#Хӗвелтухӑҫ Казахстан вхч#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Анӑҫ Казахстан вӑхӑчӗ#,
			},
			short => {
				'standard' => q#Анӑҫ Казахстан вхч#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Корей ҫуллахи вӑхӑчӗ#,
				'generic' => q#Корей вӑхӑчӗ#,
				'standard' => q#Корей стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#KST DST#,
				'generic' => q#KST#,
				'standard' => q#KST#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Косрае вӑхӑчӗ#,
			},
			short => {
				'standard' => q#KOST#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Красноярск ҫуллахи вӑхӑчӗ#,
				'generic' => q#Красноярск вӑхӑчӗ#,
				'standard' => q#Красноярск стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#KRAST#,
				'generic' => q#KRAT#,
				'standard' => q#KRAT#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Киргизи вӑхӑчӗ#,
			},
			short => {
				'standard' => q#KGT#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#Ланка вӑхӑчӗ#,
			},
			short => {
				'standard' => q#SLST#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Лайн утравӗсен вӑхӑчӗ#,
			},
			short => {
				'standard' => q#LINT#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд-Хау ҫуллахи вӑхӑчӗ#,
				'generic' => q#Лорд-Хау вӑхӑчӗ#,
				'standard' => q#Лорд-Хау стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#LHST Summer#,
				'generic' => q#LHST#,
				'standard' => q#LHST#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#Макао ҫуллахи вӑхӑчӗ#,
				'generic' => q#Макао вӑхӑчӗ#,
				'standard' => q#Макао стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#MST Macao DST#,
				'generic' => q#MST Macao#,
				'standard' => q#MST Macao#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магадан ҫуллахи вӑхӑчӗ#,
				'generic' => q#Магадан вӑхӑчӗ#,
				'standard' => q#Магадан стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#MAGST#,
				'generic' => q#MAGT#,
				'standard' => q#MAGT#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малайзи вӑхӑчӗ#,
			},
			short => {
				'standard' => q#MYT#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Мальдивсем вӑхӑчӗ#,
			},
			short => {
				'standard' => q#MVT#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркизас утравӗсен вӑхӑчӗ#,
			},
			short => {
				'standard' => q#MART#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршалл утравӗсен вӑхӑчӗ#,
			},
			short => {
				'standard' => q#MHT#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маврикий ҫуллахи вӑхӑчӗ#,
				'generic' => q#Маврикий вӑхӑчӗ#,
				'standard' => q#Маврикий стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#MUST#,
				'generic' => q#MUT#,
				'standard' => q#MUT#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Моусон вӑхӑчӗ#,
			},
			short => {
				'standard' => q#MAWT#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Мексика Лӑпкӑ океан ҫуллахи вӑхӑчӗ#,
				'generic' => q#Мексика Лӑпкӑ океан вӑхӑчӗ#,
				'standard' => q#Мексика Лӑпкӑ океан стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#PDTM#,
				'generic' => q#PSTM#,
				'standard' => q#PSTM#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Улан-Батор ҫуллахи вӑхӑчӗ#,
				'generic' => q#Улан-Батор вӑхӑчӗ#,
				'standard' => q#Улан-Батор стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#ULAST#,
				'generic' => q#ULAT#,
				'standard' => q#ULAT#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Мускав ҫуллахи вӑхӑчӗ#,
				'generic' => q#Мускав вӑхӑчӗ#,
				'standard' => q#Мускав стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#MSD#,
				'generic' => q#MSK#,
				'standard' => q#МСК#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мьянма вӑхӑчӗ#,
			},
			short => {
				'standard' => q#MMT#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науру вӑхӑчӗ#,
			},
			short => {
				'standard' => q#NRT#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Непал вӑхӑчӗ#,
			},
			short => {
				'standard' => q#NPT#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Ҫӗнӗ Каледони ҫуллахи вӑхӑчӗ#,
				'generic' => q#Ҫӗнӗ Каледони вӑхӑчӗ#,
				'standard' => q#Ҫӗнӗ Каледони стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#NDT New Caledonia#,
				'generic' => q#NCT#,
				'standard' => q#NCT#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Ҫӗнӗ Зеланди ҫуллахи вӑхӑчӗ#,
				'generic' => q#Ҫӗнӗ Зеланди вӑхӑчӗ#,
				'standard' => q#Ҫӗнӗ Зеланди стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#NZDT#,
				'generic' => q#NZST#,
				'standard' => q#NZST#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Ньюфаундленд ҫуллахи вӑхӑчӗ#,
				'generic' => q#Ньюфаундленд вӑхӑчӗ#,
				'standard' => q#Ньюфаундленд стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#NDT#,
				'generic' => q#NST#,
				'standard' => q#NST#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуэ вӑхӑчӗ#,
			},
			short => {
				'standard' => q#NUT#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#Норфолк ҫуллахи вӑхӑчӗ#,
				'generic' => q#Норфолк вӑхӑчӗ#,
				'standard' => q#Норфолк стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#NFDT#,
				'generic' => q#NFT#,
				'standard' => q#NFT#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернанду-ди-Норонья ҫуллахи вӑхӑчӗ#,
				'generic' => q#Фернанду-ди-Норонья вӑхӑчӗ#,
				'standard' => q#Фернанду-ди-Норонья стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#FNST#,
				'generic' => q#FNT#,
				'standard' => q#FNT#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#Мариансен ҫурҫӗрти утравӗсем вӑхӑчӗ#,
			},
			short => {
				'standard' => q#ChST NMI#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосибирск ҫуллахи вӑхӑчӗ#,
				'generic' => q#Новосибирск вӑхӑчӗ#,
				'standard' => q#Новосибирск стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#NOVST#,
				'generic' => q#NOVT#,
				'standard' => q#NOVT#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омск ҫуллахи вӑхӑчӗ#,
				'generic' => q#Омск вӑхӑчӗ#,
				'standard' => q#Омск стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#OMSST#,
				'generic' => q#OMST#,
				'standard' => q#OMST#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвиль#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Мӑнкун утравӗ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфате#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиджи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос утравӗсем#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбье утравӗсем#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			short => {
				'daylight' => q#Гавай ҫуллахи вӑхӑчӗ#,
				'generic' => q#Гавай стандартлӑ вӑхӑчӗ#,
				'standard' => q#Гавай стандартлӑ вӑхӑчӗ#,
			},
		},
		'Pacific/Kanton' => {
			exemplarCity => q#Кантон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваджалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маджуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркизас утравӗсем#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидуэй#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго-Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкэрн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпеи#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уэйк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уоллис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пакистан ҫуллахи вӑхӑчӗ#,
				'generic' => q#Пакистан вӑхӑчӗ#,
				'standard' => q#Пакистан стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#PKT DST#,
				'generic' => q#PKT#,
				'standard' => q#PKT#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палау вӑхӑчӗ#,
			},
			short => {
				'standard' => q#PWT#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа — Ҫӗнӗ Гвиней вӑхӑчӗ#,
			},
			short => {
				'standard' => q#PGT#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагвай ҫуллахи вӑхӑчӗ#,
				'generic' => q#Парагвай вӑхӑчӗ#,
				'standard' => q#Парагвай стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#PYST#,
				'generic' => q#PYT#,
				'standard' => q#PYT#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перу ҫуллахи вӑхӑчӗ#,
				'generic' => q#Перу вӑхӑчӗ#,
				'standard' => q#Перу стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#EDT Peru#,
				'generic' => q#PET#,
				'standard' => q#PET#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филиппинсем ҫуллахи вӑхӑчӗ#,
				'generic' => q#Филиппинсем вӑхӑчӗ#,
				'standard' => q#Филиппинсем стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#PST Philippine DST#,
				'generic' => q#PST Philippine#,
				'standard' => q#PST Philippine#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Феникс вӑхӑчӗ#,
			},
			short => {
				'standard' => q#PHOT#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сен-Пьер тата Микелон ҫуллахи вӑхӑчӗ#,
				'generic' => q#Сен-Пьер тата Микелон вӑхӑчӗ#,
				'standard' => q#Сен-Пьер тата Микелон стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#PMDT#,
				'generic' => q#PMST#,
				'standard' => q#PMST#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкэрн вӑхӑчӗ#,
			},
			short => {
				'standard' => q#PST Pitcairn#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понпеи вӑхӑчӗ#,
			},
			short => {
				'standard' => q#PONT#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Пхеньян#,
			},
			short => {
				'standard' => q#PYT Korea#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#Кызылорда ҫуллахи вӑхӑчӗ#,
				'generic' => q#Кызылорда вӑхӑчӗ#,
				'standard' => q#Кызылорда стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#QYZT DST#,
				'generic' => q#QYZT#,
				'standard' => q#QYZT#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реюньон вӑхӑчӗ#,
			},
			short => {
				'standard' => q#RET#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротера вӑхӑчӗ#,
			},
			short => {
				'standard' => q#ROTT#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалин ҫуллахи вӑхӑчӗ#,
				'generic' => q#Сахалин вӑхӑчӗ#,
				'standard' => q#Сахалин стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#SAKST#,
				'generic' => q#SAKT#,
				'standard' => q#SAKT#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#Самар ҫуллахи вӑхӑчӗ#,
				'generic' => q#Самар вӑхӑчӗ#,
				'standard' => q#Самар стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#SAMST#,
				'generic' => q#SAMT#,
				'standard' => q#SAMT#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоа ҫуллахи вӑхӑчӗ#,
				'generic' => q#Самоа вӑхӑчӗ#,
				'standard' => q#Самоа стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#SST Samoa DST#,
				'generic' => q#SST Samoa#,
				'standard' => q#SST Samoa#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сейшел утравӗсен вӑхӑчӗ#,
			},
			short => {
				'standard' => q#SCT#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапур вӑхӑчӗ#,
			},
			short => {
				'standard' => q#SGT#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломон вӑхӑчӗ#,
			},
			short => {
				'standard' => q#SBT#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Кӑнтӑр Георги вӑхӑчӗ#,
			},
			short => {
				'standard' => q#GST#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринам вӑхӑчӗ#,
			},
			short => {
				'standard' => q#SRT#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Сёва вӑхӑчӗ#,
			},
			short => {
				'standard' => q#SYOT#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Таити вӑхӑчӗ#,
			},
			short => {
				'standard' => q#TAHT#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Тайпей ҫуллахи вӑхӑчӗ#,
				'generic' => q#Тайпей вӑхӑчӗ#,
				'standard' => q#Тайпей стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#TWT DST#,
				'generic' => q#TWT#,
				'standard' => q#TWT#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Таджикистан вӑхӑчӗ#,
			},
			short => {
				'standard' => q#TJT#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелау вӑхӑчӗ#,
			},
			short => {
				'standard' => q#TKT#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонга ҫуллахи вӑхӑчӗ#,
				'generic' => q#Тонга вӑхӑчӗ#,
				'standard' => q#Тонга стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#TOST#,
				'generic' => q#TOT#,
				'standard' => q#TOT#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Трук вӑхӑчӗ#,
			},
			short => {
				'standard' => q#CHUT#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Туркменистан ҫуллахи вӑхӑчӗ#,
				'generic' => q#Туркменистан вӑхӑчӗ#,
				'standard' => q#Туркменистан стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#TMT DST#,
				'generic' => q#TMT#,
				'standard' => q#TMT#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалу вӑхӑчӗ#,
			},
			short => {
				'standard' => q#TVT#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвай ҫуллахи вӑхӑчӗ#,
				'generic' => q#Уругвай вӑхӑчӗ#,
				'standard' => q#Уругвай стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#UYST#,
				'generic' => q#UYT#,
				'standard' => q#UYT#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Узбекистан ҫуллахи вӑхӑчӗ#,
				'generic' => q#Узбекистан вӑхӑчӗ#,
				'standard' => q#Узбекистан стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#UZT DST#,
				'generic' => q#UZT#,
				'standard' => q#UZT#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануату ҫуллахи вӑхӑчӗ#,
				'generic' => q#Вануату вӑхӑчӗ#,
				'standard' => q#Вануату стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#VUT DST#,
				'generic' => q#VUT#,
				'standard' => q#VUT#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венесуэла вӑхӑчӗ#,
			},
			short => {
				'standard' => q#VnzlT#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивосток ҫуллахи вӑхӑчӗ#,
				'generic' => q#Владивосток вӑхӑчӗ#,
				'standard' => q#Владивосток стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#VLAST#,
				'generic' => q#VLAT#,
				'standard' => q#VLAT#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоград ҫуллахи вӑхӑчӗ#,
				'generic' => q#Волгоград вӑхӑчӗ#,
				'standard' => q#Волгоград стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#VOLST#,
				'generic' => q#VOLT#,
				'standard' => q#VOLT#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Восток вӑхӑчӗ#,
			},
			short => {
				'standard' => q#VOST#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Уэйк вӑхӑчӗ#,
			},
			short => {
				'standard' => q#WAKT#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Уоллис тата Футуна вӑхӑчӗ#,
			},
			short => {
				'standard' => q#WFT#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Якутск ҫуллахи вӑхӑчӗ#,
				'generic' => q#Якутск вӑхӑчӗ#,
				'standard' => q#Якутск стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#YAKST#,
				'generic' => q#YAKT#,
				'standard' => q#YAKT#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Екатеринбург ҫуллахи вӑхӑчӗ#,
				'generic' => q#Екатеринбург вӑхӑчӗ#,
				'standard' => q#Екатеринбург стандартлӑ вӑхӑчӗ#,
			},
			short => {
				'daylight' => q#YEKST#,
				'generic' => q#YEKT#,
				'standard' => q#YEKT#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#Юкон вӑхӑчӗ#,
			},
			short => {
				'standard' => q#YST#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
