use strict;
use warnings;

package App::Embra::Role::SitePublisher;
$App::Embra::Role::SitePublisher::VERSION = '0.001'; # TRIAL
# ABSTRACT: something that publishs files to a site

use Method::Signatures;
use Moo::Role;


with 'App::Embra::Role::Plugin';

requires 'publish_site';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Role::SitePublisher - something that publishs files to a site

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This role should be implemented by any plugin which publishes your site. It requires plugins provide a C<publish_site> method, which will be called as the final step of collating your site.

Plugins which implement this role can access the site's files via the C<L<files|App::Embra/files>> attribute of its C<L<embra|App::Embra::Role::Plugin/embra>> attribute, and should publish all files.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
