use strict;
use warnings;

package App::Embra::Role::FileTransformer;
$App::Embra::Role::FileTransformer::VERSION = '0.001'; # TRIAL
# ABSTRACT: something that transforms file content, but not into its publishable form

use Method::Signatures;
use Moo::Role;


with 'App::Embra::Role::Plugin';

requires 'transform_files';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Role::FileTransformer - something that transforms file content, but not into its publishable form

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This role should be implemented by any plugin which alters a file's content. It requires plugins provide a C<transform_files> method, which will be called early in the process of collating your site.

Plugins which implement this role can access the site's files via the C<L<files|App::Embra/files>> attribute of its C<L<embra|App::Embra::Role::Plugin/embra>> attribute.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
