use strict;
use warnings;

package App::Embra::Plugin::Favicon;
$App::Embra::Plugin::Favicon::VERSION = '0.001'; # TRIAL
# ABSTRACT: adds a favicon

use Moo;
use Method::Signatures;



has 'filename' => (
    is => 'ro',
    default => sub { 'favicon.ico' },
);

has 'file' => (
    is => 'lazy',
    default => method {
        App::Embra::File->new( name => $self->filename )
    },
);

has 'fragment' => (
    is => 'ro',
    default => method { qq{<link rel="icon" type="image/x-icon" href="${ \  $self->file->name }">} },
    init_arg => undef,
);

has 'clipboard' => (
    is => 'ro',
    default => 'head',
    init_arg => undef,
);

with 'App::Embra::Role::Snippet';

method gather_files {
    $self->add_file( App::Embra::File->new( name => $self->filename ) );
}

with 'App::Embra::Role::FileGatherer';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Plugin::Favicon - adds a favicon

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This plugin will add the HTML to the site to include a favicon. You must add the file separately, and then pass the filename to this plugin.

=head1 ATTRIBUTES

=head2 filename

The name of the favicon. Defaults to F<favicon.ico>.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
