/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public final class InstanceOfExpression
extends UnaryExpression {
    ItemType targetType;
    int targetCardinality;

    public InstanceOfExpression(Expression source, SequenceType target) {
        super(source);
        this.targetType = target.getPrimaryType();
        if (this.targetType == null) {
            throw new IllegalArgumentException("Primary item type must not be null");
        }
        this.targetCardinality = target.getCardinality();
    }

    protected OperandRole getOperandRole() {
        return this.targetType instanceof DocumentNodeTest ? OperandRole.ABSORB : OperandRole.INSPECT;
    }

    public ItemType getRequiredItemType() {
        return this.targetType;
    }

    public int getRequiredCardinality() {
        return this.targetCardinality;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Expression operand = this.getBaseExpression();
        if (operand instanceof Literal) {
            Literal lit = Literal.makeLiteral(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()));
            ExpressionTool.copyLocationInfo(this, lit);
            return lit;
        }
        if (Cardinality.subsumes(this.targetCardinality, operand.getCardinality())) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            int relation = th.relationship(operand.getItemType(), this.targetType);
            if (relation == 0 || relation == 2) {
                Literal lit = Literal.makeLiteral(BooleanValue.TRUE);
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            if (!(relation != 4 || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(operand.getCardinality()))) {
                Literal lit = Literal.makeLiteral(BooleanValue.FALSE);
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e = super.optimize(visitor, contextInfo);
        if (e != this) {
            return e;
        }
        if (Cardinality.subsumes(this.targetCardinality, this.getBaseExpression().getCardinality())) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            int relation = th.relationship(this.getBaseExpression().getItemType(), this.targetType);
            if (relation == 0 || relation == 2) {
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            if (!(relation != 4 || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(this.getBaseExpression().getCardinality()))) {
                return Literal.makeLiteral(BooleanValue.FALSE);
            }
        }
        return this;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.targetType == ((InstanceOfExpression)other).targetType && this.targetCardinality == ((InstanceOfExpression)other).targetCardinality;
    }

    public int hashCode() {
        return super.hashCode() ^ this.targetType.hashCode() ^ this.targetCardinality;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression copy(RebindingMap rebindings) {
        InstanceOfExpression exp = new InstanceOfExpression(this.getBaseExpression().copy(rebindings), SequenceType.makeSequenceType(this.targetType, this.targetCardinality));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public UType getStaticUType(UType contextItemType) {
        return UType.BOOLEAN;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        SequenceIterator iter = this.getBaseExpression().iterate(context);
        return this.isInstance(iter, context);
    }

    private boolean isInstance(SequenceIterator iter, XPathContext context) throws XPathException {
        Item item;
        int count = 0;
        while ((item = iter.next()) != null) {
            ++count;
            if (!this.targetType.matches(item, context.getConfiguration().getTypeHierarchy())) {
                iter.close();
                return false;
            }
            if (count != 2 || Cardinality.allowsMany(this.targetCardinality)) continue;
            iter.close();
            return false;
        }
        return count != 0 || (this.targetCardinality & 0x2000) != 0;
    }

    public String getExpressionName() {
        return "instance";
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("instance", this);
        if (this.targetCardinality == 8192) {
            out.emitAttribute("of", "empty-sequence()");
        } else {
            out.emitAttribute("of", this.targetType.toString() + Cardinality.getOccurrenceIndicator(this.targetCardinality));
        }
        if ("JS".equals(out.getOption("target"))) {
            int targetVersion = out.getIntOption("targetVersion", 1);
            out.emitAttribute("jsTest", this.targetType.generateJavaScriptItemTypeTest(this.getBaseExpression().getItemType(), targetVersion));
        }
        this.getBaseExpression().export(out);
        out.endElement();
    }

    public String toString() {
        String occ = Cardinality.getOccurrenceIndicator(this.targetCardinality);
        return "(" + this.getBaseExpression().toString() + " instance of " + this.targetType.toString() + occ + ")";
    }

    public String toShortString() {
        String occ = Cardinality.getOccurrenceIndicator(this.targetCardinality);
        return this.getBaseExpression().toShortString() + " instance of " + this.targetType.toString() + occ;
    }

    public String getStreamerName() {
        return "InstanceOf";
    }
}

