#!/usr/bin/pugs

use v6;
use Test;

plan 9;

# L<S12/"Construction and Initialization" /you can clone an object, changing some of the attributes:/>
class Foo { 
    has $.attr; 
    method set_attr ($attr) { $.attr = $attr; }
    method get_attr () { $.attr }
}

my $a = Foo.new(:attr(13));
isa_ok($a, 'Foo');
is($a.get_attr(), 13, '... got the right attr value');

my $c = $a.clone();
isa_ok($c, 'Foo');
is($c.get_attr(), 13, '... cloned object retained attr value');
my $val;
lives_ok {
    $val = $c =:= $a;
}, "... cloned object isn't identity equal to the original object";
ok($val.defined && !$val, "... cloned object isn't identity equal to the original object");

my $d;
lives_ok {
    $d = $a.clone(attr => 42)
}, '... cloning with supplying a new attribute value', :todo<feature>;

my $val;
lives_ok {
   $val = $d.get_attr()
}, '... getting attr from cloned value', :todo<feature>;

is($val, 42, '... cloned object has proper attr value', :todo<feature>);
