#!/usr/bin/perl -w
#
# Make sure the VT102 module can handle tabs and tab stops.
#
# Copyright (C) Andrew Wood
# NO WARRANTY - see COPYING.
#

require Term::VT102;
require 't/testbase';

my $tabs = "a\tb\tc\td\te\tf\tg\th\ti\tj\tk";
run_tests ([(
  [ 80, 9,
    "Line 1\r". $tabs ."\r\nLine 2\e[3g\r\nLine 3\r" . $tabs . "\r\n" .
    "Line 4\e[3g\e[9G\eHt\e[17G\eHt\e[25G\eHt\e[33G\eHt\e[41G\eHt\e[49G\eHt\e[57G\eHt\e[65G\eHt\e[73G\eHt\r\n" .
    "Line 5\r" . $tabs . "\r\n" .
    "Line 6\e[17G\e[gT\r" . $tabs . "\r\n" .
    "Line 7\e[3g\e[5G\eHt\e[10G\eHt\e[15G\eHt\e[20G\eHt\r\n" .
    "Line 8\r" . $tabs . "\r\n",
    "aine 1\0\0b\0\0\0\0\0\0\0c\0\0\0\0\0\0\0d\0\0\0\0\0\0\0e\0\0\0\0\0\0\0f\0\0\0\0\0\0\0g\0\0\0\0\0\0\0h\0\0\0\0\0\0\0i\0\0\0\0\0\0\0j\0\0\0\0\0\0k",
    "Line 2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",
    "aine 3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0k",
    "Line 4\0\0t\0\0\0\0\0\0\0t\0\0\0\0\0\0\0t\0\0\0\0\0\0\0t\0\0\0\0\0\0\0t\0\0\0\0\0\0\0t\0\0\0\0\0\0\0t\0\0\0\0\0\0\0t\0\0\0\0\0\0\0t\0\0\0\0\0\0\0",
    "aine 5\0\0b\0\0\0\0\0\0\0c\0\0\0\0\0\0\0d\0\0\0\0\0\0\0e\0\0\0\0\0\0\0f\0\0\0\0\0\0\0g\0\0\0\0\0\0\0h\0\0\0\0\0\0\0i\0\0\0\0\0\0\0j\0\0\0\0\0\0k",
    "aine 6\0\0b\0\0\0\0\0\0\0T\0\0\0\0\0\0\0c\0\0\0\0\0\0\0d\0\0\0\0\0\0\0e\0\0\0\0\0\0\0f\0\0\0\0\0\0\0g\0\0\0\0\0\0\0h\0\0\0\0\0\0\0i\0\0\0\0\0\0k",
    "Linet7\0\0\0t\0\0\0\0t\0\0\0\0t\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",
    "aineb8\0\0\0c\0\0\0\0d\0\0\0\0e\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0k",
    "\0" x 80
  ]
)]);

# EOF
