use strict;
use warnings;
use Test::More;
use Geo::Coordinates::OSGB 'll_to_grid';

my @test_input = (
    "TP01,49.92226393730,-6.29977752014,100.000",
    "TP02,49.96006137820,-5.20304609998,124.269",
    "TP03,50.43885825610,-4.10864563561,215.251",
    "TP04,50.57563665000,-1.29782277240,94.688",
    "TP05,50.93127937910,-1.45051433700,100.405",
    "TP06,51.40078220140,-3.55128349240,112.371",
    "TP07,51.37447025550,1.44454730409,99.439",
    "TP08,51.42754743020,-2.54407618349,104.018",
    "TP09,51.48936564950,-0.11992557180,66.057",
    "TP10,51.85890896400,-4.30852476960,81.351",
    "TP11,51.89436637350,0.89724327012,75.274",
    "TP12,52.25529381630,-2.15458614387,101.526",
    "TP13,52.25160951230,-0.91248956970,131.594",
    "TP14,52.75136687170,0.40153547065,66.431",
    "TP15,52.96219109410,-1.19747655922,93.825",
    "TP16,53.34480280190,-2.64049320810,88.411",
    "TP17,53.41628516040,-4.28918069756,100.776",
    "TP18,53.41630925420,-4.28917792869,100.854",
    "TP19,53.77911025760,-3.04045490691,64.940",
    "TP20,53.80021519630,-1.66379168242,215.609",
    "TP21,54.08666318080,-4.63452168212,84.366",
    "TP22,54.11685144290,-0.07773133187,86.778",
    "TP23,54.32919541010,-4.38849118133,94.503",
    "TP24,54.89542340420,-2.93827741149,93.542",
    "TP25,54.97912273660,-1.61657685184,125.878",
    "TP26,55.85399952950,-4.29649016251,71.617",
    "TP27,55.92478265510,-3.29479219337,119.032",
    "TP28,57.00606696050,-5.82836691850,68.494",
    "TP29,57.13902518960,-2.04856030746,108.611",
    "TP30,57.48625000720,-4.21926398555,66.178",
    "TP31,57.81351838410,-8.57854456076,100.001",
    "TP32,58.21262247180,-7.59255560556,140.404",
    "TP33,58.51560361300,-6.26091455533,115.026",
    "TP34,58.58120461280,-3.72631022121,98.634",
    "TP35,59.03743871190,-3.21454001115,100.000",
    "TP36,59.09335035320,-4.41757674598,100.000",
    "TP37,59.09671617400,-5.82799339844,140.716",
    "TP38,59.53470794490,-1.62516966058,100.000",
    "TP39,59.85409913890,-1.27486910356,149.890",
    "TP40,60.13308091660,-2.07382822798,140.716",
);
my %test_output = (
    TP01 => "91492.146,11318.804,46.519,2,7803,92.139,-81.209,53.484,2,7804,92.159,-81.196,53.475,2,8505,92.153,-81.176,53.477,2,8504,92.137,-81.187,53.487,2,92.14556,-81.19532,53.48144",
    TP02 => "170370.718,11572.405,71.264,1,7882,93.528,-80.507,53.007,1,7883,93.535,-80.497,53.003,1,8584,93.533,-80.475,53.002,1,8583,93.526,-80.485,53.005,1,93.52863,-80.48986,53.00477",
    TP03 => "250359.811,62016.569,163.097,1,43713,94.023,-79.322,52.159,1,43714,94.020,-79.295,52.140,1,44415,94.020,-79.297,52.142,1,44414,94.019,-79.318,52.160,1,94.02192,-79.31459,52.15407",
    TP04 => "449816.371,75335.861,48.589,1,53025,96.942,-79.741,46.113,1,53026,96.981,-79.740,46.090,1,53727,96.977,-79.723,46.097,1,53726,96.938,-79.723,46.119,1,96.96839,-79.73310,46.09925",
    TP05 => "438710.920,114792.250,54.056,1,80353,96.865,-78.965,46.353,1,80354,96.896,-78.943,46.330,1,81055,96.878,-78.942,46.342,1,81054,96.867,-78.938,46.364,1,96.87508,-78.94188,46.34900",
    TP06 => "292184.870,168003.465,60.646,1,118061,94.580,-77.818,51.726,1,118062,94.581,-77.815,51.702,1,118763,94.594,-77.795,51.720,1,118762,94.593,-77.799,51.742,1,94.58115,-77.81618,51.72515",
    TP07 => "639821.835,169565.858,55.149,1,119109,101.578,-79.979,44.302,1,119110,101.610,-79.995,44.284,1,119811,101.625,-79.957,44.285,1,119810,101.595,-79.940,44.304,1,101.61110,-79.96580,44.28986",
    TP08 => "362269.991,169978.690,54.485,1,119533,95.577,-77.811,49.538,1,119534,95.600,-77.807,49.505,1,120235,95.630,-77.802,49.510,1,120234,95.614,-77.803,49.543,1,95.58303,-77.80988,49.53253",
    TP09 => "530624.974,178388.464,20.544,1,125309,98.555,-78.581,45.518,1,125310,98.565,-78.588,45.500,1,126011,98.569,-78.577,45.510,1,126010,98.557,-78.571,45.528,1,98.56169,-78.57977,45.51320",
    TP10 => "241124.584,220332.641,27.613,1,154462,93.853,-77.235,53.728,1,154463,93.859,-77.264,53.710,1,155164,93.859,-77.212,53.735,1,155163,93.853,-77.188,53.754,1,93.85318,-77.21656,53.73809",
    TP11 => "599445.590,225722.826,30.207,1,158325,100.416,-78.692,45.069,1,158326,100.421,-78.678,45.053,1,159027,100.400,-78.660,45.058,1,159026,100.382,-78.648,45.074,1,100.39407,-78.65910,45.06748",
    TP12 => "389544.190,261912.153,51.998,1,183351,96.151,-77.131,49.517,1,183352,96.141,-77.150,49.490,1,184053,96.148,-77.127,49.513,1,184052,96.148,-77.111,49.540,1,96.14798,-77.11840,49.52766",
    TP13 => "474335.969,262047.755,83.982,1,184137,98.092,-77.584,47.618,1,184138,98.103,-77.570,47.589,1,184839,98.109,-77.556,47.593,1,184838,98.095,-77.561,47.622,1,98.09508,-77.57806,47.61160",
    TP14 => "562180.547,319784.995,20.912,1,224182,100.723,-77.063,45.526,1,224183,100.744,-77.088,45.512,1,224884,100.770,-77.077,45.505,1,224883,100.743,-77.041,45.519,1,100.74233,-77.04679,45.51885",
    TP15 => "454002.834,340834.943,45.275,1,238794,98.521,-75.815,48.582,1,238795,98.542,-75.854,48.535,1,239496,98.567,-75.796,48.547,1,239495,98.566,-75.783,48.594,1,98.56450,-75.79971,48.55043",
    TP16 => "357455.843,383290.436,36.779,1,268841,96.158,-73.723,51.643,1,268842,96.166,-73.733,51.610,1,269543,96.163,-73.697,51.612,1,269542,96.156,-73.694,51.645,1,96.16002,-73.71512,51.63186",
    TP17 => "247958.971,393492.909,46.335,1,275741,93.503,-73.380,54.462,1,275742,93.530,-73.374,54.449,1,276443,93.525,-73.340,54.432,1,276442,93.499,-73.346,54.444,1,93.52361,-73.35555,54.44105",
    TP18 => "247959.241,393495.583,46.413,1,275741,93.503,-73.380,54.462,1,275742,93.530,-73.374,54.449,1,276443,93.525,-73.340,54.432,1,276442,93.499,-73.346,54.444,1,93.52361,-73.35546,54.44100",
    TP19 => "331534.564,431920.794,12.658,1,302463,95.395,-72.187,52.294,1,302464,95.417,-72.193,52.272,1,303165,95.419,-72.156,52.270,1,303164,95.393,-72.144,52.292,1,95.40442,-72.14955,52.28235",
    TP20 => "422242.186,433818.701,165.912,1,303956,98.484,-72.529,49.706,1,303957,98.521,-72.545,49.651,1,304658,98.541,-72.515,49.650,1,304657,98.504,-72.500,49.705,1,98.50714,-72.50533,49.69721",
    TP21 => "227778.330,468847.388,29.335,3,328296,92.414,-70.980,55.036,3,328297,92.455,-70.980,55.013,3,328998,92.461,-70.939,55.025,3,328997,92.420,-70.941,55.047,3,92.44763,-70.94293,55.03096",
    TP22 => "525745.670,470703.214,41.232,1,329996,102.153,-72.424,45.558,1,329997,102.180,-72.426,45.523,1,330698,102.192,-72.388,45.536,1,330697,102.165,-72.387,45.572,1,102.17968,-72.39609,45.54584",
    TP23 => "244780.636,495254.887,39.891,3,347240,93.096,-69.758,54.643,3,347241,93.134,-69.733,54.604,3,347942,93.125,-69.682,54.591,3,347941,93.087,-69.706,54.628,3,93.11920,-69.72416,54.61176",
    TP24 => "339921.145,556034.761,41.107,1,390096,96.519,-67.740,52.454,1,390097,96.552,-67.749,52.433,1,390798,96.553,-67.709,52.421,1,390797,96.520,-67.701,52.443,1,96.54631,-67.74334,52.43547",
    TP25 => "424639.355,565012.703,76.574,1,396490,99.617,-67.829,49.329,1,396491,99.647,-67.833,49.283,1,397192,99.688,-67.812,49.279,1,397191,99.666,-67.810,49.325,1,99.63679,-67.82954,49.30385",
    TP26 => "256340.925,664697.269,17.459,1,465721,93.431,-63.051,54.173,1,465722,93.465,-63.066,54.153,1,466423,93.469,-63.022,54.139,1,466422,93.430,-63.010,54.160,1,93.43960,-63.02298,54.15798",
    TP27 => "319188.434,670947.534,66.388,1,470691,96.103,-63.096,52.647,1,470692,96.131,-63.106,52.614,1,471393,96.163,-63.098,52.581,1,471392,96.121,-63.054,52.615,1,96.10579,-63.09651,52.64361",
    TP28 => "167634.202,797067.144,13.192,1,558865,91.376,-57.008,55.300,1,558866,91.409,-57.020,55.303,1,559567,91.428,-56.974,55.306,1,559566,91.396,-56.962,55.305,1,91.39633,-57.00880,55.30211",
    TP29 => "397160.491,805349.736,58.933,1,564703,99.422,-58.420,49.682,1,564704,99.456,-58.429,49.657,1,565405,99.449,-58.401,49.653,1,565404,99.415,-58.393,49.677,1,99.42122,-58.40950,49.67846",
    TP30 => "267056.768,846176.972,13.260,1,593313,95.249,-56.666,52.969,1,593314,95.287,-56.681,52.920,1,594015,95.294,-56.655,52.902,1,594014,95.253,-56.641,52.953,1,95.28714,-56.67436,52.91770",
    TP31 => "9587.909,899448.996,42.013,15,630209,87.931,-50.965,57.985,15,630210,87.877,-50.993,57.982,15,630911,87.894,-51.034,57.992,15,630910,87.912,-50.990,57.995,15,87.90350,-50.99550,57.98850",
    TP32 => "71713.132,938516.404,83.732,15,657610,90.649,-50.904,56.682,15,657611,90.682,-50.924,56.667,15,658312,90.702,-50.891,56.665,15,658311,90.669,-50.872,56.680,15,90.68089,-50.89794,56.67153",
    TP33 => "151968.652,966483.780,58.921,4,677318,93.633,-51.549,56.129,4,677319,93.662,-51.566,56.108,4,678020,93.681,-51.542,56.098,4,678019,93.650,-51.525,56.119,4,93.66841,-51.55103,56.10527",
    TP34 => "299721.891,967202.992,46.021,1,678167,97.247,-53.604,52.633,1,678168,97.272,-53.615,52.602,1,678869,97.280,-53.586,52.598,1,678868,97.255,-53.574,52.628,1,97.26467,-53.60333,52.61251",
    TP35 => "330398.323,1017347.016,47.956,7,713248,98.317,-52.985,52.048,7,713249,98.348,-53.001,52.021,7,713950,98.342,-52.985,52.032,7,713949,98.308,-52.972,52.059,7,98.32306,-52.98424,52.04430",
    TP36 => "261596.778,1025447.602,46.445,15,718787,96.760,-52.404,53.563,15,718788,96.776,-52.425,53.538,15,719489,96.796,-52.393,53.547,15,719488,96.781,-52.371,53.572,15,96.77825,-52.39825,53.55500",
    TP37 => "180862.461,1029604.114,85.349,15,721510,95.603,-50.526,55.368,15,721511,95.631,-50.546,55.351,15,722212,95.650,-50.521,55.369,15,722211,95.620,-50.502,55.385,15,95.63660,-50.52512,55.36659",
    TP38 => "421300.525,1072147.239,51.049,15,751894,100.519,-52.762,48.956,15,751895,100.547,-52.779,48.929,15,752596,100.549,-52.758,48.928,15,752595,100.522,-52.741,48.956,15,100.52516,-52.76120,48.95056",
    TP39 => "440725.073,1107878.448,100.989,6,776448,101.452,-52.342,48.891,6,776449,101.481,-52.357,48.872,6,777150,101.492,-52.336,48.895,6,777149,101.463,-52.324,48.916,6,101.48032,-52.33286,48.90126",
    TP40 => "395999.668,1138728.951,90.015,15,798134,101.061,-51.402,50.714,15,798135,101.082,-51.405,50.670,15,798836,101.095,-51.392,50.704,15,798835,101.073,-51.389,50.748,15,101.08994,-51.39455,50.70099",
);

plan tests => scalar @test_input;

for my $input_line (@test_input) {
    my ($id, $lat, $lon, @rest) = split ",", $input_line;
    my ($e, $n, $ht, $dm, $ix, $lle, $lln, @junk) = split ",", $test_output{$id};
    my ($got_e, $got_n) = ll_to_grid($lat, $lon); 
    is("$e, $n", "$got_e, $got_n", $id);
}


