package ICU::Calendar;
#
#    Calendar.pm
#
#    $Id: Calendar.pm,v 1.3 2001/08/15 05:33:12 mrperl Exp $
#
#    Copyright (c) 2000 Brian Stell and James
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

use strict;
use Carp;
use vars qw(@ISA %EXPORT_TAGS $AUTOLOAD);

use Exporter;
@ISA = qw(Exporter);

use ICU;


%EXPORT_TAGS = (
    EDateFields => [qw(
ERA
YEAR
MONTH
WEEK_OF_YEAR
WEEK_OF_MONTH
DATE DAY_OF_YEAR
DAY_OF_WEEK
DAY_OF_WEEK_IN_MONTH
AM_PM
HOUR
HOUR_OF_DAY
MINUTE
SECOND
MILLISECOND
ZONE_OFFSET
DST_OFFSET
YEAR_WOY
DOW_LOCAL
FIELD_COUNT
DAY_OF_MONTH
DATE
)],

    EDaysOfWeek => [qw(
SUNDAY
MONDAY
TUESDAY
WEDNESDAY
THURSDAY
FRIDAY
SATURDAY
)],

    EMonths => [qw(
JANUARY
FEBRUARY
MARCH
APRIL
MAY
JUNE
JULY
AUGUST
SEPTEMBER
OCTOBER
NOVEMBER
DECEMBER
UNDECIMBER
)],


    EAmpm => [qw(
AM
PM
)],
);

Exporter::export_tags();

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "$constname not defined" if $constname eq 'constant_iv';
    my $val = constant_iv($constname, @_ ? $_[0] : 0);
    if ($! != 0) { 
        if ($! =~ /Invalid/) {
            $AutoLoader::AUTOLOAD = $AUTOLOAD;
            goto &AutoLoader::AUTOLOAD;
        }
        else {
                croak "Your vendor has not defined ICU::Calendar macro $constname";
        }
    }
    no strict 'refs';
    *$AUTOLOAD = sub { $val };
    goto &$AUTOLOAD;
}

1;

__END__

=head1 NAME

ICU::Calendar - Perl extension for International Components for Unicode

=head1 SYNOPSIS

  use ICU::Calendar qw( :EDateFields :EDaysOfWeek :EMonths :EAmpm );

=head1 DESCRIPTION

API # with C style prototypes for clarity

my $calendar = createInstance( [ \\$status ] );

my $calendar = createInstance( $zoneToAdopt, [ \\$status ] );
# TimeZone *zoneToAdopt; 

my $debugLevel = setDebugLevel( [ $new_debug_level ] );

my $udate = $calendar->getTime( [ \\$status ] ); # UDate udate;

$calendar->setTime($date, [ \\$status ] );

$calendar->roll($field, $up, \\$status);
# Calendar__EDateFields field; UBool up; 

$calendar->adoptTimeZone($zone);
# TimeZone *zone;

$calendar->setTimeZone($zone);
# TimeZone *zone;

my $timezone= $calendar->getTimeZone();
# TimeZone *timezone;

$calendar->setLenient($lenient);
# UBool lenient;

my $value = $calendar->isLenient();
# UBool value;

$calendar->setFirstDayOfWeek($value);
# Calendar__EDaysOfWeek value;

my $value = $calendar->getFirstDayOfWeek();
# Calendar__EDaysOfWeek value;

$calendar->setMinimalDaysInFirstWeek($value);
# uint8_t value;

my $value = $calendar->getMinimalDaysInFirstWeek();
# uint8_t value;

my $value = $calendar->getActualMinimum($field, [ \\$status ] );
# Calendar__EDateFields field; int32_t value;

my $value = $calendar->getActualMaximum($field, $status);
# Calendar__EDateFields field; int32_t value

my $value = $calendar->get($field, $status);
# Calendar__EDateFields field; int32_t value;

my $value = $calendar->isSet($field);
# Calendar__EDateFields field; UBool value

$calendar->set($field, $value);
# Calendar__EDateFields field; int32_t value;

$calendar->set($year, $month, $date);
# int32_t year, month, date;

$calendar->set($year, $month, $date, $hour, $minute);

$calendar->set($year, $month, $date, $hour, $minute, $second);

$calendar->clear();

$calendar->clear_field($field);
# Calendar__EDateFields field;

