/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.util.Map;
import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.BinaryStatResponse;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class StatCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        String key = cmd.getKey();
        for (MemcachedServer ss : server.getBucket().activeServers()) {
            for (Map.Entry<String, String> stat : ss.getStats().entrySet()) {
                if (key != null && !key.equals(stat.getKey())) continue;
                client.sendResponse(new BinaryStatResponse(cmd, stat.getKey(), stat.getValue()));
            }
        }
        client.sendResponse(new BinaryResponse(cmd, ErrorCode.SUCCESS));
    }
}

