package Duadua::Parser::Bot::GooglebotMobile;
use strict;
use warnings;
use Duadua::Util;

sub try {
    my ($class, $d) = @_;

    return unless index($d->ua, 'oogle') > -1;

    if ( index($d->ua, 'googleweblight') > -1 ) {
        my $h = {
            name   => 'googleweblight',
            is_bot => 1,
        };

        return Duadua::Util->set_os($d, $h);
    }

    if ( index($d->ua, 'AdsBot-Google-Mobile') > -1 && index($d->ua, 'AdsBot-Google-Mobile-') == -1 ) {
        my $h = {
            name => 'AdsBot-Google-Mobile',
            is_bot => 1,
        };

        return Duadua::Util->set_os($d, $h);
    }

    if ( index($d->ua, 'AdsBot-Google-Mobile-Apps') > -1 ) {
        return {
            name   => 'AdsBot-Google-Mobile-Apps',
            is_bot => 1,
        };
    }

    if ( (index($d->ua, 'SAMSUNG-SGH-E250/') == 0 || index($d->ua, 'DoCoMo/') == 0)
            && index($d->ua, ' Googlebot-Mobile/') > -1 ) {
        return {
            name   => 'Googlebot-Mobile',
            is_bot => 1,
        };
    }

    if ( index($d->ua, 'DuplexWeb-Google') > -1 ) {
        my $h = {
            name   => 'DuplexWeb-Google',
            is_bot => 1,
        };

        if ($d->opt_version) {
            my ($version) = ($d->ua =~ m!DuplexWeb-Google/([\d.]+)!);
            $h->{version} = $version if $version;
        }

        return Duadua::Util->set_os($d, $h);

    }
}

1;

__END__

=head1 METHODS

=head2 try

Do parse


=head1 AUTHOR

Dai Okabayashi E<lt>bayashi@cpan.orgE<gt>


=head1 LICENSE

C<Duadua> is free software; you can redistribute it and/or modify it under the terms of the Artistic License 2.0. (Note that, unlike the Artistic License 1.0, version 2.0 is GPL compatible by itself, hence there is no benefit to having an Artistic 2.0 / GPL disjunction.) See the file LICENSE for details.

=cut
