package Task::BeLike::PHIPS;

use strict;
use warnings;
use 5.010;
use vars qw{$VERSION};

BEGIN {
    $VERSION = '0.1.1';
}
 
1;

__END__

=head1 NAME

Task::BeLike::PHIPS - My favourite and frequently used modules


=head1 VERSION

version 0.1.1

=head1 TASK CONTENTS

=head2 Perl development tools

=head3 L<Modern::Perl>

=head3 L<Devel::NYTProf>

=head3 L<DDP>

=head3 L<Module::Install>

=head3 L<Perl::Tidy>

=head3 L<Perl::Critic>

=head3 L<Perl6::Export::Attrs>

=head3 L<ExtUtils::MakeMaker>

=head3 L<Module::Install::GithubMeta>

=head3 L<Module::Starter::PBP>


=head2 Web

=head3 L<IO::Socket::SSL>

=head3 L<Mojolicious>

=head3 L<Plack>

=head3 L<WWW::Mechanize>

=head3 L<WWW::RobotRules>

=head3 L<WWW::UserAgent::Random>

=head3 L<LWP>

=head3 L<LWP::Protocol::https>

=head3 L<WebService::Amazon::Route53>


=head2 Events

=head3 L<EV>

=head3 L<AnyEvent>


=head2 Testing

=head3 L<Test::Perl::Critic>

=head3 L<Test::Pod::Coverage>


=head2 Shell tools

=head3 L<Term::ReadKey>

=head3 L<Term::ReadLine::Gnu>

=head3 L<Daemon::Control>

=head3 L<Proc::Daemon>

=head3 L<App::Ack>


=head2 Data manipulation

=head3 L<YAML::XS>

=head3 L<PDL>

=head3 L<Time::Duration>


=head2 CPAN

=head3 L<App::cpanoutdated>

=head3 L<Pod::Cpandoc>


=head2 Database

=head3 L<DBIx::Connector>



=head1 AUTHOR

Mark Phillips  C<< <phips@cpan.org> >>


=head1 LICENCE AND COPYRIGHT

Copyright (c) 2013, Mark Phillips C<< <phips@cpan.org> >>. All rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.

=cut

# vim: set ts=4 sw=4 et:
