use v6.c;

use Method::Also;
use NativeCall;

use GLib::Raw::Types;
use GLib::Raw::Signal;

use GLib::Value;

# STATIC CLASS

use GLib::Roles::StaticClass;

# Should be roles into GLib::Roles:: Object, at some point!
class GLib::Signal {
  also does GLib::Roles::StaticClass;

  # method new_valist (Str() $signal_name, GType $itype, GSignalFlags $signal_flags, GClosure() $class_closure, GSignalAccumulator $accumulator, gpointer $accu_data, GSignalCMarshaller $c_marshaller, GType $return_type, guint $n_params, va_list $args) {
  #   g_signal_new_valist($signal_name, $itype, $signal_flags, $class_closure, $accumulator, $accu_data, $c_marshaller, $return_type, $n_params, $args);
  # }

  # NOT A CONSTRUCTOR!!
  method newv (
    Str()              $signal_name,
    Int()              $itype,
    Int()              $signal_flags,
    GClosure()         $class_closure,
    GSignalAccumulator $accumulator,
    gpointer           $accu_data,
    GSignalCMarshaller $c_marshaller,
    Int()              $return_type,
    Int()              $n_params,
    CArray[uint64]     $param_types
  ) {
    my guint ($sf, $np) = ($signal_flags, $n_params);
    my uint64 ($it, $rt) = ($itype, $return_type);
    g_signal_newv(
      $signal_name,
      $it,
      $sf,
      $class_closure,
      $accumulator,
      $accu_data,
      $c_marshaller,
      $rt,
      $n_params,
      $param_types
    );
  }

  method accumulator_first_wins (
    GSignalInvocationHint $ihint,
    GValue()              $return_accu,
    GValue()              $handler_return,
    gpointer              $dummy           = Pointer
  )
    is also<accumulator-first-wins>
  {
    g_signal_accumulator_first_wins(
      $ihint,
      $return_accu,
      $handler_return,
      $dummy
    );
  }

  method accumulator_true_handled (
    GSignalInvocationHint $ihint,
    GValue()              $return_accu,
    GValue()              $handler_return,
    gpointer              $dummy           = Pointer
  )
    is also<accumulator-true-handled>
  {
    g_signal_accumulator_true_handled(
      $ihint,
      $return_accu,
      $handler_return,
      $dummy
    );
  }

  method add_emission_hook (
    Int()               $signal_id,
    GQuark              $detail,
    GSignalEmissionHook $hook_func,
    gpointer            $hook_data    = Pointer,
                        &data_destroy = %DEFAULT-CALLBACKS<GDestroyNotify>
  )
    is also<add-emission-hook>
  {
    my guint $sid = $signal_id;

    g_signal_add_emission_hook(
      $sid,
      $detail,
      $hook_func,
      $hook_data,
      &data_destroy
    );
  }

  method chain_from_overridden (
    GValue() $instance_and_params,
    GValue() $return_value
  )
    is also<chain-from-overridden>
  {
    g_signal_chain_from_overridden($instance_and_params, $return_value);
  }

  method connect_closure (
    GObject()  $instance,
    Str()      $detailed_signal,
    GClosure() $closure,
    Int()      $after
  )
    is also<connect-closure>
  {
    my gboolean $a = $after;

    g_signal_connect_closure($instance, $detailed_signal, $closure, $a);
  }

  method connect_closure_by_id (
    GObject()  $instance,
    Int()      $signal_id,
    GQuark     $detail,
    GClosure() $closure,
    Int()      $after
  )
    is also<connect-closure-by-id>
  {
    my gboolean $a = $after;
    my guint $sid = $signal_id;

    g_signal_connect_closure_by_id($instance, $sid, $detail, $closure, $a);
  }

  method connect_data (
    GObject()      $instance,
    Str()          $detailed_signal,
                   &c_handler,
    gpointer       $data             = Pointer,
    GClosureNotify $destroy_data     = Pointer,
    Int()          $connect_flags    = 0
  )
    is also<
      connect-data
      connect
    >
  {
    my guint $cf = $connect_flags;

    g_signal_connect_data(
      $instance,
      $detailed_signal,
      &c_handler,
      $data,
      $destroy_data,
      $cf
    );
  }

  method connect_after (
    GObject() $instance,
    Str()     $detailed_signal,
              &c_handler,
    gpointer  $data             = Pointer
  )
    is also<connect-after>
  {
    self.connect_data(
      $instance,
      $detailed_signal,
      &c_handler,
      $data,
      Pointer,
      G_CONNECT_AFTER
    );
  }

  method connect_swapped (
    GObject() $instance,
    Str()     $detailed_signal,
              &c_handler,
    gpointer  $data             = Pointer
  )
    is also<connect-swapped>
  {
    self.connect_data(
      $instance,
      $detailed_signal,
      &c_handler,
      $data,
      Pointer,
      G_CONNECT_SWAPPED
    );
  }

  # method emit_valist (
  #   GObject() $instance,
  #   guint $signal_id,
  #   GQuark $detail,
  #   va_list $var_args
  # ) {
  #   g_signal_emit_valist($instance, $signal_id, $detail, $var_args);
  # }

  method disconnect_by_func (
    GObject() $instance,
    gpointer  $func,
    gpointer  $data       = Pointer
  )
    is also<disconnect-by-func>
  {
    self.handlers_disconnect_matched(
      $instance,
      G_SIGNAL_MATCH_FUNC +| G_SIGNAL_MATCH_DATA,
      0, 0, GClosure,
      $func,
      $data
    );
  }

  multi method emitv (
    GValue()  $instance_and_params,
    Int()     $signal_id,
    GQuark    $detail,
             :$raw                  = False
  ) {
    my $v = GValue.new;

    samewith($instance_and_params, $signal_id, $v);

    $v ??
      ( $raw ?? $v !! GLib::Value.new($v) )
      !!
      Nil;
  }
  multi method emitv (
    GValue() $instance_and_params,
    Int()    $signal_id,
    GQuark   $detail,
    GValue() $return_value
  ) {
    my guint $sid = $signal_id;

    g_signal_emitv($instance_and_params, $sid, $detail, $return_value);
  }

  method get_invocation_hint (GObject() $instance)
    is also<get-invocation-hint>
  {
    g_signal_get_invocation_hint($instance);
  }

  method handler_block (GObject() $instance, Int() $handler_id)
    is also<handler-block>
  {
    my gulong $hid = $handler_id;

    g_signal_handler_block($instance, $hid);
  }

  method handler_disconnect (GObject() $instance, Int() $handler_id)
    is also<handler-disconnect>
  {
    my gulong $hid = $handler_id;

    g_signal_handler_disconnect($instance, $handler_id);
  }

  method handler_find (
    GObject()  $instance,
    Int()      $mask,
    Int()      $signal_id,
    GQuark     $detail,
    GClosure() $closure,
    gpointer   $func,
    gpointer   $data
  )
    is also<handler-find>
  {
    my guint ($m, $sid) = ($mask, $signal_id);

    g_signal_handler_find(
      $instance,
      $m,
      $sid,
      $detail,
      $closure,
      $func,
      $data
    );
  }

  method handler_is_connected (GObject() $instance, Int() $handler_id)
    is also<handler-is-connected>
  {
    my gulong $hid = $handler_id;

    g_signal_handler_is_connected($instance, $hid);
  }

  method handler_unblock (GObject() $instance, gulong $handler_id)
    is also<handler-unblock>
  {
    g_signal_handler_unblock($instance, $handler_id);
  }

  method handlers_block_matched (
    GObject()  $instance,
    Int()      $mask,
    Int()      $signal_id,
    GQuark     $detail,
    GClosure() $closure,
    gpointer   $func,
    gpointer   $data
  )
    is also<handlers-block-matched>
  {
    my guint ($m, $sid) = ($mask, $signal_id);

    g_signal_handlers_block_matched(
      $instance,
      $m,
      $sid,
      $detail,
      $closure,
      $func,
      $data
    );
  }

  method handlers_destroy (GObject() $instance) is also<handlers-destroy> {
    g_signal_handlers_destroy($instance);
  }

  method handlers_disconnect_matched (
    GObject()  $instance,
    Int()      $mask,
    Int()      $signal_id,
    GQuark     $detail,
    GClosure() $closure,
    gpointer   $func,
    gpointer   $data
  )
    is also<handlers-disconnect-matched>
  {
    my guint ($m, $sid) = ($mask, $signal_id);

    g_signal_handlers_disconnect_matched(
      $instance,
      $m,
      $sid,
      $detail,
      $closure,
      $func,
      $data
    );
  }

  method handlers_unblock_matched (
    GObject()  $instance,
    Int()      $mask,
    Int()      $signal_id,
    GQuark     $detail,
    GClosure() $closure,
    gpointer   $func,
    gpointer   $data
  )
    is also<handlers-unblock-matched>
  {
    my guint ($m, $sid) = ($mask, $signal_id);

    g_signal_handlers_unblock_matched(
      $instance,
      $m,
      $sid,
      $detail,
      $closure,
      $func,
      $data
    );
  }

  method has_handler_pending (
    GObject() $instance,
    Int()     $signal_id,
    GQuark    $detail,
    Int()     $may_be_blocked
  )
    is also<has-handler-pending>
  {
    my guint $sid = $signal_id;
    my gboolean $m = $may_be_blocked.so.Int;;

    so g_signal_has_handler_pending($instance, $sid, $detail, $m);
  }

  method list_ids (Int() $itype, :$raw = False) is also<list-ids> {
    my GType $i    = $itype;
    my guint $nids = 0;

    my $ids = g_signal_list_ids($i, $nids);
    return Nil  unless  $ids;
    return $ids if      $raw;

    CArrayToArray($ids, $nids);
  }

  method lookup (Str() $name, Int() $itype) {
    my uint64 $it = $itype;

    g_signal_lookup($name, $it);
  }

  method name (Int() $signal_id) {
    my guint $sid = $signal_id;

    g_signal_name($sid);
  }

  method override_class_closure (
    Int()      $signal_id,
    Int()      $instance_type,
    GClosure() $class_closure
  )
    is also<override-class-closure>
  {
    my guint $sid = $signal_id;
    my uint64 $it = $instance_type;

    g_signal_override_class_closure($sid, $it, $class_closure);
  }

  method override_class_handler (
    Str()     $signal_name,
    Int()     $instance_type,
    GCallback $class_handler
  )
    is also<override-class-handler>
  {
    my uint64 $it = $instance_type;

    g_signal_override_class_handler($signal_name, $it, $class_handler);
  }

  proto method parse_name (|)
    is also<parse-name>
  { * }

  multi method parse_name (
    Str()  $detailed_signal,
    Int()  $itype,
    Int()  $force_detail_quark,
          :$all                 = True
  ) {
    samewith($detailed_signal, $itype, $, $, $force_detail_quark, :$all);
  }
  multi method parse_name (
    Str()   $detailed_signal,
    Int()   $itype,
            $signal_id_p         is rw,
            $detail_p            is rw,
    Int()   $force_detail_quark,
           :$all                        = False
  ) {
    my gboolean $f    = $force_detail_quark;
    my guint    $sidp = 0;
    my uint64   $it   = $itype;

    my $cdp = CArray[uint32].new;
    my $rc  = g_signal_parse_name(
      $detailed_signal,
      $it,
      $sidp,
      $cdp,
      $force_detail_quark
    );

    ($signal_id_p, $detail_p) = ($sidp, $cdp[0]);
    $all.not ?? $rc !! ($rc, $signal_id_p, $detail_p);
  }

  multi method query (Int() $signal_id) {
    my $q = GSignalQuery.new;

    samewith($signal_id, $q);
    $q;
  }
  multi method query (Int() $signal_id, GSignalQuery $query) {
    my guint $sid = $signal_id;

    g_signal_query($sid, $query);
  }

  method remove_emission_hook (Int() $signal_id, Int() $hook_id)
    is also<remove-emission-hook>
  {
    my guint $sid = $signal_id;
    my gulong $hi = $hook_id;

    g_signal_remove_emission_hook($sid, $hi);
  }

  method set_va_marshaller (
    Int()                $signal_id,
    Int()                $instance_type,
    GSignalCVaMarshaller $va_marshaller
  )
    is also<set-va-marshaller>
  {
    my guint $sid = $signal_id;
    my uint64 $it = $instance_type;

    g_signal_set_va_marshaller($sid, $it, $va_marshaller);
  }

  method stop_emission (
    GObject() $instance,
    Int()     $signal_id,
    GQuark    $detail
  )
    is also<stop-emission>
  {
    my guint $sid = $signal_id;

    g_signal_stop_emission($instance, $sid, $detail);
  }

  method stop_emission_by_name (GObject() $instance, Str() $detailed_signal)
    is also<stop-emission-by-name>
  {
    g_signal_stop_emission_by_name($instance, $detailed_signal);
  }

}
