/* $Id: UIVMLogBookmark.h $ */
/** @file
 * VBox Qt GUI - UIVMLogViewer class declaration.
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#ifndef FEQT_INCLUDED_SRC_logviewer_UIVMLogBookmark_h
#define FEQT_INCLUDED_SRC_logviewer_UIVMLogBookmark_h
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

/* Qt includes: */
#include <QString>

struct UIVMLogBookmark
{
    UIVMLogBookmark(){}
    UIVMLogBookmark(int iLineNumber, int iCursorPosition, const QString &strBlockText)
        : m_iLineNumber(iLineNumber)
        , m_iCursorPosition(iCursorPosition)
        , m_strBlockText(strBlockText){}

    bool operator==(const UIVMLogBookmark& otherBookmark) const
    {
        return m_iLineNumber == otherBookmark.m_iLineNumber;
    }

    int m_iLineNumber;
    int m_iCursorPosition;
    QString m_strBlockText;
};

#endif /* !FEQT_INCLUDED_SRC_logviewer_UIVMLogBookmark_h */
