use Game::Quest::ImageLibrary;

class Room {

	has $!x;
	has $!y;
	has $!w; ### width
	has $!h; ### height

	has $!background-imagelibrary;

	has @!sprites; ### list with entities which need blitting and updating

	submethod BUILD(:$x, :$y) {
		.init($x,$y);
	}

	multi method init($x, $y) {
		.x = $x;
		.y = $y;

		.background-imagelibrary = ImageLibrary.new;
	}

	multi method add-sprite($sprite) {
		push (.sprites, $sprite);
	}

	multi method add-background-image($filename) {
		.imagelibrary.add-image($filename);
	}
}
