/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.config.ConfigValue;

public class AnnotatedConfig
implements Config {
    private final Map<String, Map<String, String>> config;

    public AnnotatedConfig(Object obj) {
        HashMap<String, Map> values = new HashMap<String, Map>();
        Deque<Field> allConfigValues = this.findConfigFields(obj.getClass());
        for (Field field : allConfigValues) {
            Object value;
            if (Collection.class.isAssignableFrom(field.getType())) {
                throw new ConfigException("Collection fields may not be used for configuration: " + field, new Object[0]);
            }
            if (Map.class.isAssignableFrom(field.getType())) {
                throw new ConfigException("Map fields may not be used for configuration: " + field, new Object[0]);
            }
            field.setAccessible(true);
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new ConfigException("Unable to read field: " + field, new Object[0]);
            }
            if (value == null) continue;
            ConfigValue annotation = field.getAnnotation(ConfigValue.class);
            Map section = values.getOrDefault(annotation.section(), new HashMap());
            section.put(annotation.name(), String.valueOf(value));
            values.put(annotation.section(), section);
        }
        this.config = ImmutableMap.copyOf(values);
    }

    private Deque<Field> findConfigFields(Class<?> clazz) {
        ArrayDeque<Field> toSet = new ArrayDeque<Field>();
        HashSet toVisit = new HashSet();
        toVisit.add(clazz);
        HashSet<Class> seen = new HashSet<Class>();
        while (!toVisit.isEmpty()) {
            clazz = (Class)toVisit.iterator().next();
            toVisit.remove(clazz);
            seen.add(clazz);
            Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getAnnotation(ConfigValue.class) != null).forEach(toSet::addFirst);
            Class toAdd = clazz.getSuperclass();
            if (!Object.class.equals(toAdd) && !seen.contains(toAdd)) {
                toVisit.add(toAdd);
            }
            Arrays.stream(clazz.getInterfaces()).filter(face -> !seen.contains(face)).forEach(toVisit::add);
        }
        return toSet;
    }

    @Override
    public Optional<String> get(String section, String option) {
        Objects.requireNonNull(section, "Section name not set");
        Objects.requireNonNull(option, "Option name not set");
        Map<String, String> sec = this.config.get(section);
        if (sec == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(sec.get(option));
    }
}

