/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class JreHttpClient
implements HttpClient {
    private final URL url;

    private JreHttpClient(URL url) {
        if (!url.getProtocol().toLowerCase().startsWith("http")) {
            throw new IllegalArgumentException("Base URL must be an http URL: " + url);
        }
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse execute(HttpRequest request, boolean followRedirects) throws IOException {
        URL url = new URL(this.url.toString() + request.getUri());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setInstanceFollowRedirects(followRedirects);
            for (Object name : request.getHeaderNames()) {
                for (String value : request.getHeaders((String)name)) {
                    connection.addRequestProperty((String)name, value);
                }
            }
            connection.setRequestProperty("Content-length", String.valueOf(request.getContent().length));
            connection.setRequestMethod(request.getMethod().toString());
            connection.setDoInput(true);
            if (request.getMethod() == HttpMethod.POST) {
                Object name;
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                name = null;
                try {
                    os.write(request.getContent());
                }
                catch (Throwable throwable) {
                    name = throwable;
                    throw throwable;
                }
                finally {
                    if (os != null) {
                        if (name != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)name).addSuppressed(throwable);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            HttpResponse response = new HttpResponse();
            response.setStatus(connection.getResponseCode());
            for (Map.Entry entry : connection.getHeaderFields().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    response.addHeader((String)entry.getKey(), value);
                }
            }
            InputStream is = connection.getErrorStream();
            if (is == null) {
                is = connection.getInputStream();
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Object object = null;
                try {
                    int count;
                    byte[] data = new byte[1024];
                    while ((count = is.read(data, 0, data.length)) != -1) {
                        byteArrayOutputStream.write(data, 0, count);
                    }
                    byteArrayOutputStream.flush();
                    response.setContent(byteArrayOutputStream.toByteArray());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (byteArrayOutputStream != null) {
                        if (object != null) {
                            try {
                                byteArrayOutputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            byteArrayOutputStream.close();
                        }
                    }
                }
            }
            finally {
                is.close();
            }
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            connection.disconnect();
        }
    }

    @Override
    public void close() throws IOException {
    }

    public static class Factory
    implements HttpClient.Factory {
        @Override
        public HttpClient createClient(URL url) {
            return new JreHttpClient(Objects.requireNonNull(url, "Base URL must be set"));
        }
    }
}

