// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Created by postproc-shortwords 1.7 on 2009-01-29 16:13:04
// From input file /tmp/langdet_v25_12cjk_sort.utf8
// See compact_lang_det.cc for usage
//
#include "cld2tablesummary.h"

namespace CLD2 {


// Suppressed:
//    az-Arab az-Cyrl ku-Latn tg-Arab za-Hani zzb-Latn zze-Latn zzh-Latn ru-Latn

// Remapped:
//    xxx-Latn=>ut-Latn sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl

static const int kCjkDeltaBiBuildDate = 20090129;    // yyyymmdd

// Nil-grams: 18 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC ORIYA INUKTITUT

// Uni-grams: 6 languages
//     Japanese Korean Chinese VIETNAMESE ChineseT ZHUANG

// Words/Quads/CjkBis: 3 languages in range Japanese..ChineseT:
//     Japanese Chinese ChineseT

static const uint32 kCjkDeltaBiSize = 8192;    // Bucket count
static const uint32 kCjkDeltaBiKeyMask = 0xfffff000;    // Mask hash key
static const char* const kCjkDeltaBiRecognizedLangScripts = "";

// 35201 possible entries:
// 27364 filled (77%), 30 merged (0%), 7807 dropped (22%)
static const IndirectProbBucket4 kCjkDeltaBi[kCjkDeltaBiSize] = {
  // key[4], words[4] in UTF-8
  // value[4]
  { {0xf90ee001,0xf93a8002,0x00000003,0x00000003}},	// [000] 到前, 需外,   ,
  { {0xf822f004,0xf834f004,0xfb75e004,0xf9180005}},	//   事事, 任事, 会直, 区利
  { {0xfa4c9006,0xf8371007,0xf9458005,0xfb7e4005}},	//   青海, 她一, 行免, 逃犯
  { {0xf91dc001,0xf91cc008,0xfb4f6001,0xfa771005}},	//   加厚, 加型, 已索, 活是
  { {0xf943a009,0xf5b14004,0xf48ab00a,0xf5bf400a}},	//   等基, 花苑, 年退, 忠臣
  { {0xfa859001,0xf946c004,0xf4be3005,0xfa82b005}},	//   利情, 王德, 市鹿, 正性
  { {0xfb75400b,0xfa54d006,0xf8135009,0xf9246001}},	//   回版, 定性, 四中, 種商
  { {0xfa50700c,0xfb700005,0xfa66100a,0xfa80900d}},	//   受日, 店管, 里沙, 院投
  { {0xf934400b,0xf90c4009,0xf8175008,0xf5b90001}},	//   四国, 援助, 土交, 常菜
  { {0xf5c04001,0xfa7b100c,0x00000003,0x00000003}},	//   搭車, 別比,   ,
  { {0xf9414007,0xf827700e,0xfa653005,0xfb4a6002}},	//   指引, 界中, 界朋, 德盛
  { {0xfb56c008,0xfb5cc004,0xf82fd001,0xf922e005}},	//   人病, 触犯, 防人, 席大
  { {0xfb4fe00f,0xf92f200c,0xf9122005,0xfa767002}},	//   新生, 崑山, 新就, 示技
  { {0xf9180001,0xf83a9001,0xf818b004,0xf4a67004}},	//   人全, 卸任, 址之, 用集
  { {0xf5a6400f,0xf8409009,0xf59f0004,0xf9496005}},	//   名表, 模以, 但要, 税字
  { {0xf5b28001,0xfb6dc00c,0x00000003,0x00000003}},	//   議買, 著美,   ,
  { {0xf596e00b,0xf9448001,0xfb5f6001,0x00000003}},	// [010] 期設, 有家, 面禁,
  { {0xfb8b2007,0x00000003,0x00000003,0x00000003}},	//   盎然,   ,   ,
  { {0xf92d4001,0xfa84b001,0xf91c0005,0xf59b800c}},	//   化商, 本東, 旧市, 時考
  { {0xfa4bd00f,0xf913a006,0xf9458004,0xf934a00c}},	//   民服, 使命, 行再, 生完
  { {0xf9340006,0xf5c28001,0xfa88b005,0xf5ba200c}},	//   会在, 正負, 周永, 容詳
  { {0xfb76800f,0xf92cc00c,0xfa70700c,0x00000003}},	//   食物, 我忘, 陰暗,
  { {0xf9462009,0xfb7de009,0xf8265004,0xf5ab4004}},	//   位在, 的答, 式三, 海航
  { {0xf49eb007,0xfb84a001,0xf9316004,0xf5aea005}},	//   大都, 屋純, 林巴, 泳装
  { {0xf80c7004,0xf9296005,0x00000003,0x00000003}},	//   取上, 木制,   ,
  { {0xfa83b009,0xfa5b300c,0xf58be002,0xf9136002}},	//   口数, 一探, 打著, 穿刺
  { {0xf93e0009,0xf9182001,0xfa72d008,0xfa68700c}},	//   的只, 出可, 己放, 收手
  { {0xf92c8004,0x00000003,0x00000003,0x00000003}},	//   道口,   ,   ,
  { {0xf93d6005,0xf5c6e00c,0x00000003,0x00000003}},	//   丁家, 種能,   ,
  { {0xfb7b0006,0xf920e004,0x00000003,0x00000003}},	//   品生, 信函,   ,
  { {0xf9126004,0xf4a8d004,0xfb50c00c,0xf4c45010}},	//   国富, 在阿, 到物, 半透
  { {0xf945200f,0xfa8a9006,0xf5920007,0xfb876008}},	//   合唱, 快捷, 比起, 名簿
  { {0xfb844006,0xfa541007,0xf9390001,0xf92ee001}},	// [020] 玉米, 際書, 府委, 我常
  { {0xf91c2009,0xfa4d1007,0xf9198001,0xf814f004}},	//   大内, 結業, 別名, 惟一
  { {0xfa513009,0xf592a004,0xf5b38008,0xf9200008}},	//   算收, 会考, 共職, 財形
  { {0xf935c006,0xf8361004,0xf5bf400c,0xf4937005}},	//   多家, 建之, 你解, 好食
  { {0xf5a4c004,0xfa51f001,0xf92e6001,0xf5c18008}},	//   位考, 力指, 北商, 無職
  { {0xf9100001,0xf59aa005,0xfa51500c,0xf9318005}},	//   英名, 扁豆, 比方, 葛市
  { {0xf5b64007,0xfa4c300e,0xf81d5005,0xf4ac5010}},	//   人認, 結成, 必不, 体院
  { {0xf942a007,0xf9304007,0xfa6e300c,0xfa817005}},	//   計分, 評定, 念書, 握新
  { {0xf5a38009,0xf9440005,0xfb57e00c,0xf58e4005}},	//   合自, 位合, 出火, 提花
  { {0xfb6da008,0xfa5a500c,0xf930200a,0xf9386005}},	//   筑紫, 省時, 織化, 辞去
  { {0xf5c5e00b,0xf80d9009,0xfa5d5008,0xf9358004}},	//   可能, 受上, 堂本, 脚印
  { {0xf80a3001,0xf9476004,0xf8267002,0x00000003}},	//   習作, 里屯, 序介,
  { {0xf90ec00b,0xf8159007,0xfa5db001,0xfb5b800c}},	//   進化, 站主, 者最, 入端
  { {0xf9138006,0xf934c009,0xfa51d007,0xfa4d5002}},	//   国土, 些年, 毛料, 向毒
  { {0xf9372004,0xfa81b008,0xf9266005,0xfa6b500a}},	//   也大, 測所, 在必, 水揚
  { {0xf5aea00b,0xf8329004,0xf9428005,0x00000003}},	//   新車, 国住, 予必,
  { {0xf92ae00e,0xfa7b3007,0xfb6d8001,0xf4a3f004}},	// [030] 体力, 游泳, 成群, 是金
  { {0xfa88b00f,0xfa65d009,0xf4a25004,0xf4c43004}},	//   用書, 伊朗, 六部, 及配
  { {0xfb7b0004,0xfb840004,0xf8241008,0xf946e004}},	//   作状, 告牌, 床下, 量小
  { {0xf93ec007,0xf826f001,0xf92c6005,0xf915a005}},	//   市家, 和他, 他先, 活密
  { {0xf932a004,0xf91a6005,0xfa71f005,0x00000003}},	//   慕尼, 度先, 稿源,
  { {0xfa60f007,0xf946c00c,0x00000003,0x00000003}},	//   假村, 看家,   ,
  { {0xf5c3400c,0xfb754005,0xfb6a400c,0x00000003}},	//   搭船, 瘟病, 間美,
  { {0xfa761007,0xf594c007,0xf497d007,0xfb62a004}},	//   彼此, 料表, 方通, 口素
  { {0xf5b0c007,0xf941a001,0xf8487008,0xfb64a001}},	//   細表, 卉商, 太一, 良物
  { {0xf916a007,0xf8183005,0xfa82f005,0x00000003}},	//   主委, 果会, 止水,
  { {0xf910c005,0x00000003,0x00000003,0x00000003}},	//   女入,   ,   ,
  { {0xf5c42005,0xfa56100c,0xfb7b8002,0x00000003}},	//   售者, 料格, 攀登,
  { {0xf92c4005,0xfb58600c,0x00000003,0x00000003}},	//   向参, 此看,   ,
  { {0xfb774001,0xf9278005,0xfa6a500c,0xf81d7005}},	//   記申, 在化, 家比, 射作
  { {0xf918400b,0xf911a009,0xf923e004,0xf9186001}},	//   古屋, 台建, 中制, 室友
  { {0xf947e006,0xfb4ec009,0xf93ee007,0xfa505008}},	//   今年, 右的, 者園, 抗性
  { {0xf4ad100f,0xfa571008,0xf48c500c,0xf4a1500a}},	// [040] 休金, 語源, 場風, 本題
  { {0xfff66009,0xfb832004,0xf822f00c,0xfa673002}},	//   妞ゆ, 率由, 橋上, 才活
  { {0xf5b4e009,0xf92a8004,0xf5ae200c,0xf59aa00c}},	//   百色, 含山, 想見, 果農
  { {0xfb7ca007,0xf9252004,0xf493b001,0xf919a00c}},	//   裁示, 岩市, 西都, 別小
  { {0xf947400f,0xfa675007,0xf9418004,0xfa877008}},	//   前出, 前方, 勇士, 器洗
  { {0xf9414004,0xf9122004,0xf8483005,0xf839300d}},	//   吉市, 就加, 士也, 以事
  { {0xfa7b700c,0xf940200a,0xfb538005,0x00000003}},	//   哥斯, 宅建, 施生,
  { {0xfb754009,0xfb65e009,0xf910a004,0xf81c1001}},	//   功的, 路由, 女大, 心位
  { {0xf943600c,0xfa613005,0xf5b7e00c,0xfa619005}},	//   三座, 了武, 司行, 安文
  { {0xf92cc006,0xfb4f6006,0xfa505004,0xfb870001}},	//   青年, 台的, 取更, 後研
  { {0xf80d9006,0xf938e004,0xfa83b005,0x00000003}},	//   得不, 九大, 口新,
  { {0xf943c00f,0xfa819005,0x00000003,0x00000003}},	//   友善, 中暑,   ,
  { {0xf4993007,0xfb58a004,0xf817b004,0xf911e005}},	//   容連, 任状, 回中, 影公
  { {0xfa623001,0xf93ea00c,0xf4c7d005,0xfb6ca005}},	//   有民, 善加, 税配, 策程
  { {0xf938a009,0xf5916004,0xf5a8e001,0xf83db005}},	//   回国, 些老, 牌起, 管上
  { {0xf81c900e,0xf8179004,0xf48ff004,0xf819d005}},	//   省令, 潜伏, 甲酸, 持上
  { {0xf831f004,0xf944c005,0xfb4d800c,0xf90a2005}},	// [050] 就中, 事化, 場現, 年先
  { {0xf927600f,0xf5ad2004,0xf4a93001,0xfb7de005}},	//   推展, 荷花, 骨骼, 宅的
  { {0xfa75d00e,0xf91ce005,0xfa661005,0x00000003}},	//   固有, 入困, 告是,
  { {0xf823f009,0xf9422009,0xf4c43001,0xf928a001}},	//   介会, 合市, 及重, 未必
  { {0xfb87200e,0xfa73700a,0x00000003,0x00000003}},	//   告白, 好感,   ,
  { {0xf5912007,0xf908c007,0xf5c76001,0xf92dc001}},	//   受花, 家名, 快要, 我叫
  { {0xf8243007,0xf5a96001,0xfa54b00c,0xfa4bf00d}},	//   積上, 買車, 生損, 毒死
  { {0xf912a004,0xfb78a004,0xf926e001,0xf91a6004}},	//   使公, 激烈, 用原, 腹地
  { {0xf4a7500c,0x00000003,0x00000003,0x00000003}},	//   庫銀,   ,   ,
  { {0xf8473005,0xf92a4005,0xf82c7005,0x00000003}},	//   天你, 徒弟, 整中,
  { {0xf49cd004,0xf942a004,0x00000003,0x00000003}},	//   性食, 等八,   ,
  { {0xf9416009,0xfa81b007,0xfb80e008,0xf5c40004}},	//   分区, 本概, 奉納, 目考
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa6e7007,0xf5c82007,0xf9420001,0xfb6f0004}},	//   已捐, 復育, 光夜, 化素
  { {0xf4c3d009,0xfa81900e,0xf93b0009,0xf9220001}},	//   三鹿, 中村, 局公, 業外
  { {0xf9428006,0xf838d004,0xf943e001,0xf832b004}},	//   争取, 人交, 友分, 柱人
  { {0xfb758004,0xf5c04008,0xf5a70005,0xfb5be005}},	// [060] 折算, 面舞, 同自, 大繁
  { {0xf5c6600f,0xfa5fb005,0x00000003,0x00000003}},	//   用者, 清欠,   ,
  { {0xf490900e,0xf83f1005,0xfb66e005,0xfa4eb002}},	//   雲長, 客上, 物物, 我死
  { {0xf8393006,0xfa559007,0xf83b1004,0x00000003}},	//   以下, 站查, 以享,
  { {0xf91c2006,0xfa873007,0xf9220004,0xf9212004}},	//   大幅, 種新, 中化, 口婚
  { {0xfb790001,0xf5a4a001,0xf943a004,0xfa6a3005}},	//   作答, 益者, 立各, 件投
  { {0xfa4bd006,0xf5928009,0xfa669007,0xf49df001}},	//   排查, 会要, 而我, 造食
  { {0xfa84f004,0xf80b7010,0x00000003,0x00000003}},	//   端正, 間伐,   ,
  { {0xfa5ef009,0xf92f6004,0xf82bf004,0xfa891005}},	//   黄浦, 孕前, 海信, 在澳
  { {0xf82b7007,0xf93e8009,0xf93a4007,0x00000003}},	//   件人, 梅州, 要吃,
  { {0xfb5e4009,0xf911a001,0xf9214001,0xf9246005}},	//   造粒, 印出, 校地, 是努
  { {0xf91b200f,0xf9132009,0xf9444004,0xf9270004}},	//   接受, 西大, 前安, 浮山
  { {0xf5c9a008,0xf80fb004,0xfa86b005,0x00000003}},	//   士試, 得中, 利或,
  { {0xf933000e,0xf944c004,0xf942c004,0x00000003}},	//   博多, 及分, 安利,
  { {0xf4c7d005,0x00000003,0x00000003,0x00000003}},	//   前防,   ,   ,
  { {0xfa591004,0xf9146001,0xf5bac00c,0xf93ac00c}},	//   州数, 白宮, 度認, 犀利
  { {0xfa5c700f,0xf8219005,0xf92c8005,0x00000003}},	// [070] 市民, 分便, 村宅,
  { {0xf93e8009,0xf81ab004,0xfb5a4001,0xf91e6004}},	//   病原, 十余, 幹細, 性健
  { {0xf90c4006,0xf945400f,0xf5c1c007,0xf817f005}},	//   年全, 消失, 衣著, 停了
  { {0xf9386009,0xf9266001,0x00000003,0x00000003}},	//   保公, 表布,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa67b00f,0xfb7a6001,0xfb81e00c,0xf909e00a}},	//   意思, 一秒, 合美, 慶子
  { {0xf8265009,0xf81a3007,0xfb72600e,0x00000003}},	//   届中, 府人, 通省,
  { {0xf5c36004,0xfa791008,0xf4acf00c,0x00000003}},	//   本路, 為替, 筒靴,
  { {0xf9432009,0xfa885007,0xf9474004,0xf929e005}},	//   万家, 火星, 届国, 当告
  { {0xfa5c1006,0xf919e006,0xf92a0009,0xfa667001}},	//   禁止, 入境, 航天, 小手
  { {0xf80d7001,0xfb74c004,0xfa67b00c,0x00000003}},	//   他付, 教用, 福感,
  { {0xf597e00b,0xf5adc008,0xf594a00c,0xfb74c005}},	//   期購, 暴走, 料自, 留用
  { {0xf9330001,0xfa52d004,0xfa72d008,0xf59e6005}},	//   力士, 博文, 統派, 如荼
  { {0xf944c009,0x00000003,0x00000003,0x00000003}},	//   名市,   ,   ,
  { {0xf4b8f00c,0x00000003,0x00000003,0x00000003}},	//   一里,   ,   ,
  { {0xfb5ca001,0xf82ed004,0xf94b600a,0x00000003}},	//   入眼, 数不, 騎兵,
  { {0xf928400b,0xf922c009,0xf80ef001,0xfa791005}},	// [080] 全員, 良反, 近似, 判文
  { {0xf8111004,0xf9240001,0xf5b26001,0xfb67e00c}},	//   供不, 本工, 能見, 部矯
  { {0xfb7c4006,0xfa575004,0xfa85b001,0xf9278005}},	//   各界, 察活, 物指, 天健
  { {0xf91ce009,0xfb646008,0xf93d4004,0xfa6b5005}},	//   入地, 公社, 求公, 扶活
  { {0xf913600c,0xfa83d00c,0x00000003,0x00000003}},	//   失其, 港村,   ,
  { {0xfa5e3005,0x00000003,0x00000003,0x00000003}},	//   的早,   ,   ,
  { {0xf90ac004,0xfa4df004,0xf93aa005,0xf915e00c}},	//   家屯, 金森, 一外, 任君
  { {0xf4a7b00f,0xfb840005,0x00000003,0x00000003}},	//   全部, 肉精,   ,
  { {0xf80f5006,0xfb790009,0xf9304004,0xfa825001}},	//   外交, 作研, 外延, 業普
  { {0xfb816007,0xfb65c004,0xf9486004,0x00000003}},	//   安的, 磨粉, 税分,
  { {0xfb796007,0xf5b22001,0xf920c005,0xf90b8005}},	//   技的, 誰能, 代写, 究出
  { {0xfa7cd00f,0xf945a009,0xf914e004,0xf934200c}},	//   性感, 同市, 好大, 力吸
  { {0xf9358006,0xf9446009,0xfb708005,0x00000003}},	//   蒙古, 三家, 字相,
  { {0xf933a00c,0x00000003,0x00000003,0x00000003}},	//   厚底,   ,   ,
  { {0xf91a4005,0xfb580005,0x00000003,0x00000003}},	//   方就, 方生,   ,
  { {0xf9406004,0xf8267004,0xfb84c004,0xf48fb00c}},	//   分含, 告信, 珍稀, 異驚
  { {0xfb854009,0xfa72d008,0xfa64100a,0x00000003}},	// [090] 里程, 熱樹, 光施,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9230007,0xf5a64008,0xf90c0004,0xfa79500c}},	//   業別, 立製, 起学, 工植
  { {0xfb86600c,0x00000003,0x00000003,0x00000003}},	//   重物,   ,   ,
  { {0xf9180006,0xf58fa00f,0xfa779004,0xf48f1001}},	//   人在, 違規, 医患, 地銀
  { {0xf929c007,0xf946c007,0xf81cf004,0xf4acb001}},	//   未取, 鍋具, 千余, 取額
  { {0xfa59500b,0xfa7ed00e,0xf4bc5008,0xfa791001}},	//   一時, 遠慮, 時金, 決書
  { {0xfb80c004,0xfa5bb001,0xf9220005,0xf590200a}},	//   清灰, 言日, 中取, 演論
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf91d4009,0xfa7f9004,0xfb5a8004,0xfb664008}},	//   大化, 加日, 日租, 編纂
  { {0xf9302009,0xf933c007,0xfa5e5008,0xfa715005}},	//   取号, 望大, 元本, 台次
  { {0xf8409001,0xf933e005,0xf92c200a,0x00000003}},	//   業一, 多外, 金問,
  { {0xfa63b004,0xfb776001,0xf90a400a,0xf5a72005}},	//   按日, 高粱, 更後, 越西
  { {0xf9314007,0xf90a400e,0xf4a91004,0xfb6d0004}},	//   比基, 直後, 八部, 向生
  { {0xfa82900b,0xfb8b000f,0xf4c4300c,0xf92e400c}},	//   中止, 明細, 版連, 託商
  { {0xf92d8004,0xfb6b0008,0x00000003,0x00000003}},	//   化定, 習用,   ,
  { {0xfa591009,0xf9398004,0xf9320004,0xf4c19004}},	// [0a0] 州新, 企合, 会刊, 文革
  { {0xf9228005,0xf929600c,0xf821d005,0xf830f00d}},	//   是及, 木偶, 等九, 数中
  { {0xfb7f4004,0xf9288005,0x00000003,0x00000003}},	//   装物, 在履,   ,
  { {0xfa755004,0xf830d005,0x00000003,0x00000003}},	//   款收, 柱会,   ,
  { {0xf4c91006,0xfb7d0001,0xfb4cc00a,0xf91c4005}},	//   小麦, 的片, 具現, 性内
  { {0xfa65d00c,0x00000003,0x00000003,0x00000003}},	//   橋接,   ,   ,
  { {0xf915e009,0xf9334004,0xfa623001,0x00000003}},	//   人合, 料市, 月時,
  { {0xf5b24009,0xfa7a9004,0xf5bd8001,0xfa76f004}},	//   印花, 容整, 性腫, 点歌
  { {0xf937600a,0x00000003,0x00000003,0x00000003}},	//   語字,   ,   ,
  { {0xf9192006,0xfa5e9001,0xfb758008,0xfb87600c}},	//   以及, 市深, 類等, 行義
  { {0xfa5eb009,0xfa855009,0xfa59b004,0xfa717001}},	//   理意, 良性, 川新, 放手
  { {0xf93ce006,0xf5bd4009,0xf81f900c,0xfa63900c}},	//   市外, 武警, 指上, 看懂
  { {0xf839b00e,0xf915e005,0x00000003,0x00000003}},	//   健一, 区光,   ,
  { {0xf5af200e,0xfa6b1008,0xf4be9004,0xfa57f001}},	//   進路, 強法, 的院, 真想
  { {0xfb67c001,0xfb83a00d,0x00000003,0x00000003}},	//   利空, 残的,   ,
  { {0xf9416004,0xf826d004,0x00000003,0x00000003}},	//   涉密, 行体,   ,
  { {0xf4bc1004,0xf9248001,0xfb63e00a,0x00000003}},	// [0b0] 七里, 可快, 端科,
  { {0xfb7e4005,0x00000003,0x00000003,0x00000003}},	//   射用,   ,   ,
  { {0xfa5ab007,0xfb4b8001,0xf9180008,0xf5aa4004}},	//   壁掛, 兵籍, 寸前, 男装
  { {0xf91e2009,0xf4b05004,0xfa88d004,0xf93f000c}},	//   峡市, 研部, 部沿, 的刻
  { {0xf9354006,0xf9324007,0xfa525007,0xf92c4009}},	//   期内, 動出, 動方, 姐姐
  { {0xf9256004,0xfb4d2004,0xf82ed001,0xf91b6004}},	//   天内, 康状, 異位, 除国
  { {0xfa889007,0xfa5a500c,0x00000003,0x00000003}},	//   全攻, 一打,   ,
  { {0xf595a005,0xfb48a00a,0x00000003,0x00000003}},	//   会走, 家紋,   ,
  { {0xfa625001,0xfa6a5001,0x00000003,0x00000003}},	//   有打, 水手,   ,
  { {0xf9198002,0x00000003,0x00000003,0x00000003}},	//   出到,   ,   ,
  { {0xf5bd000c,0x00000003,0x00000003,0x00000003}},	//   入職,   ,   ,
  { {0xfa655001,0xf9364005,0xf817700c,0xf9108005}},	//   下探, 也取, 原任, 走得
  { {0xfa56b00f,0xf933a005,0xf9474005,0xf90f200c}},	//   生涯, 余力, 前基, 害停
  { {0xf4c2900e,0x00000003,0x00000003,0x00000003}},	//   須項,   ,   ,
  { {0xf826d004,0xfa7c9001,0xf5c7e004,0xf90a5005}},	//   及主, 因有, 在路, 暴富
  { {0xf4a7f007,0xfa71d00e,0xfb552004,0xf820d004}},	//   木馬, 西村, 国画, 按上
  { {0xfb84c009,0xf595800c,0x00000003,0x00000003}},	// [0c0] 殊的, 忘返,   ,
  { {0xf9102009,0xfa5bd008,0xfa62f00c,0xfa869005}},	//   就如, 時折, 先機, 利比
  { {0xf920c006,0xf947a00f,0xf82d5009,0xfa7a5001}},	//   六十, 損害, 育一, 入愛
  { {0xf4b8300f,0xf5a30004,0xfb5ae005,0xf946600c}},	//   生長, 有良, 以答, 開平
  { {0xf82d1004,0xfb72c00c,0xf4b19002,0x00000003}},	//   年交, 定範, 且都,
  { {0xfa7b700f,0xf4c3b007,0xfb756007,0xfb656009}},	//   工業, 合適, 生紙, 目用
  { {0xf824f005,0xf5c5e005,0xf8275005,0xfa51f00c}},	//   及供, 可追, 城三, 定授
  { {0xf92ac004,0xf9410008,0xf48e1001,0xf911e00c}},	//   未履, 祇園, 足額, 到尾
  { {0xf4ac1001,0xf916000c,0xf5c1200c,0x00000003}},	//   餐食, 人尊, 臭豆,
  { {0xfb706009,0xfa6e7007,0xf9288001,0xfb6da008}},	//   他直, 平時, 木工, 民票
  { {0xfa55d008,0xfa789005,0xfa853005,0x00000003}},	//   務改, 容或, 是武,
  { {0xfb68e006,0xf90f0006,0xf81b9005,0xf93c200a}},	//   全社, 新局, 一交, 千尋
  { {0xf594000b,0xfa4ef009,0xfa5c3004,0x00000003}},	//   候補, 著成, 的残,
  { {0xf93a200e,0x00000003,0x00000003,0x00000003}},	//   紀少,   ,   ,
  { {0xf5c04004,0xf5948001,0x00000003,0x00000003}},	//   口行, 生車,   ,
  { {0xf9314007,0xf4bff001,0xf4c55001,0xf4a5f00c}},	//   受傷, 分駐, 橋頭, 在野
  { {0xf9168001,0xf93e2004,0xf5c7a001,0xf93c000c}},	// [0d0] 出心, 心公, 表著, 心凌
  { {0xf9412009,0x00000003,0x00000003,0x00000003}},	//   假冒,   ,   ,
  { {0xf937400e,0xfa6eb004,0xfa7bf005,0x00000003}},	//   期大, 困残, 性所,
  { {0xf9276009,0xf80e3008,0xfb860001,0xf9464004}},	//   天大, 五三, 完的, 洋女
  { {0xf58d8001,0xf4a0300c,0x00000003,0x00000003}},	//   笑著, 加防,   ,
  { {0xfa7b7006,0xfa5e7007,0xf9350004,0xf91b2005}},	//   学教, 各業, 定区, 永平
  { {0xf58fe001,0xf91b2004,0xfb496001,0xfb84a00c}},	//   何者, 古建, 陶笛, 車燃
  { {0xf820b006,0xf91de005,0xf591c005,0xfb79a005}},	//   集中, 次反, 毛豆, 磁炉
  { {0xf49a300e,0xfb620007,0xf5c36001,0xfb5e800c}},	//   日高, 正義, 代課, 象站
  { {0xf9322007,0xfb50000e,0xfa5c3001,0xfb89a004}},	//   定型, 由美, 品正, 量相
  { {0xf9400008,0xf93b8008,0xfa7c9005,0x00000003}},	//   文堂, 着工, 否是,
  { {0xfa559004,0x00000003,0x00000003,0x00000003}},	//   站日,   ,   ,
  { {0xf91ba006,0xf92e8009,0xf5ab2001,0xf80ca00c}},	//   常年, 他在, 護腕, 世事
  { {0xf91c8009,0xf4acd001,0xfb78c001,0xf814900c}},	//   度在, 取量, 神疾, 期事
  { {0xf91fa009,0xf80da007,0xf9386001,0xf9228004}},	//   加固, 向他, 初審, 慢地
  { {0xf8279004,0xf93de001,0xf943c004,0xfa54b002}},	//   小作, 市別, 立分, 生才
  { {0xf94a2004,0xfb63a001,0xf9288008,0xf814d005}},	// [0e0] 李大, 連環, 館大, 多交
  { {0xfa4bd001,0xfb85a00c,0x00000003,0x00000003}},	//   我把, 型管,   ,
  { {0xfb80c005,0xf9348005,0x00000003,0x00000003}},	//   光等, 君山,   ,
  { {0xf8419004,0xfa77100c,0xf9260005,0x00000003}},	//   索信, 她所, 用刀,
  { {0xf9296006,0xf81d3009,0x00000003,0x00000003}},	//   在其, 幅下,   ,
  { {0xf5c26006,0xf9446004,0xf92cc001,0xfa52f001}},	//   中路, 告如, 園場, 教服
  { {0xfa5f5007,0xf59f0009,0xfb892007,0xfb80c004}},	//   爆料, 的若, 階研, 奇瑞
  { {0xf4b77005,0xf4c3d00c,0x00000003,0x00000003}},	//   夜里, 葉酸,   ,
  { {0xf937a009,0xfa7b7007,0xf5c3c001,0xf9388004}},	//   回公, 照消, 種行, 膜回
  { {0xf93aa007,0xfa693004,0x00000003,0x00000003}},	//   持商, 明朗,   ,
  { {0xf8423009,0xfa4f9009,0xfb872009,0xf8439004}},	//   止使, 苗木, 郊社, 售不
  { {0xf93ae009,0xfa6b9001,0xf80f7001,0xf59ac004}},	//   十多, 場機, 湖人, 菜花
  { {0xf5a62004,0xf935c001,0xfa55d001,0xf5910001}},	//   前街, 務出, 務方, 林育
  { {0xf9416006,0xf591c001,0xf948800c,0xf90fe002}},	//   指南, 五色, 美力, 到喜
  { {0xfa75900f,0xf9456006,0xfa5b1007,0xf92c6004}},	//   落格, 秋季, 要我, 他合
  { {0xfa81900e,0xfa7d100e,0xf9346004,0xf48e3001}},	//   本最, 造技, 域合, 女郎
  { {0xf81dd006,0xfb81a001,0xf841f008,0xf93ec004}},	// [0f0] 市交, 先等, 勢丹, 市延
  { {0xf58e2009,0xf58ee00c,0xfa5bf00c,0xfa5a900c}},	//   得超, 向調, 心手, 所措
  { {0xfa4b9009,0xf4a15008,0xfa6fd004,0x00000003}},	//   青浦, 信長, 声望,
  { {0xfb506001,0xfa4b700c,0x00000003,0x00000003}},	//   已申, 間成,   ,
  { {0xf5c8200f,0xf58b2008,0xfa79d004,0xfa71100a}},	//   彩色, 提言, 除法, 河湾
  { {0xfa49f009,0xf4931004,0xf830f00c,0xf8437005}},	//   易有, 国集, 唱作, 苯乙
  { {0xf5c2c006,0xf4a0700e,0xfb882008,0xfb512001}},	//   可行, 中野, 界特, 米白
  { {0xfb5da005,0xf93aa00a,0xf5c8c00c,0xfb4ce00c}},	//   你留, 技士, 質超, 起由
  { {0xf943a004,0xf938e001,0xfa71100c,0xf491b00a}},	//   之内, 所名, 地探, 報館
  { {0xfa859001,0xf8153001,0xf940e004,0xf5ad8005}},	//   助旅, 定使, 等名, 署要
  { {0xf90c5006,0xf8467009,0xf93de007,0x00000003}},	//   年在, 在了, 情境,
  { {0xf5a4c001,0xf8149004,0xf4b55005,0x00000003}},	//   手腕, 期下, 生集,
  { {0xf4c0d004,0xfb740004,0xfb4aa005,0xf592a00c}},	//   三里, 秘籍, 家物, 底色
  { {0xfa577006,0xfa64d005,0xf931e00c,0x00000003}},	//   原来, 把文, 換商,
  { {0xfa7bf00f,0xfb4d200e,0xf928e009,0xf92dc001}},	//   大概, 併用, 用好, 道家
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf930400f,0xf5a2200c,0xfa50700c,0xfb666005}},	// [100] 外島, 分起, 字根, 是破
  { {0xfa807006,0xfb65e009,0xf924c004,0xf93bc005}},	//   次性, 用税, 公地, 市包
  { {0xfa797007,0xf4a65007,0xf831b001,0xf8090005}},	//   人想, 助餐, 政作, 排上
  { {0xfa895004,0xf90b9004,0xf598c004,0xf59a800c}},	//   洪洞, 究基, 血肉, 所著
  { {0xf93f400f,0xf5a28007,0xfb4fc007,0xfa577001}},	//   寄出, 等著, 音純, 募活
  { {0xf9368009,0xf4937007,0xf5aa6007,0xf4bcb009}},	//   功夫, 尿酸, 島親, 抄送
  { {0xf9416004,0xfa617001,0xfa7d9004,0xfa699001}},	//   分出, 分方, 学改, 長手
  { {0xf918e007,0xf9426004,0xfa809001,0xfa6d5001}},	//   諸多, 了年, 口流, 水游
  { {0xf9384006,0xf92fa005,0xf9416005,0xf913600c}},	//   潜力, 得公, 爆出, 穿出
  { {0xf910a004,0xfa69500c,0xfa54100c,0x00000003}},	//   称外, 德拉, 紙材,
  { {0xf5c54008,0xfa6bb00c,0x00000003,0x00000003}},	//   目論, 其施,   ,
  { {0xf80da004,0xf4bf500c,0xfa5a3005,0xfb4de00c}},	//   向世, 理高, 秀村, 音版
  { {0xfa791008,0xf845b004,0xfa725004,0xf90a3001}},	//   丹波, 售中, 国残, 年合
  { {0xfb69c009,0xf91cc00e,0xfb8a4004,0xf93d400c}},	//   体版, 欧州, 明知, 品報
  { {0xf91b400c,0x00000003,0x00000003,0x00000003}},	//   岸山,   ,   ,
  { {0xf93d2007,0xf9212005,0x00000003,0x00000003}},	//   千多, 口多,   ,
  { {0xfb864001,0xf945a002,0x00000003,0x00000003}},	// [110] 行秘, 菊展,   ,
  { {0xf90a9006,0xf92d2008,0xfb66200c,0xf9420005}},	//   零售, 金回, 普照, 胆地
  { {0xf822f00a,0xfa52100c,0xf831f005,0x00000003}},	//   之介, 力減, 山亭,
  { {0xfa745001,0xf930a00c,0xf844100d,0xf9468002}},	//   房收, 字尾, 京交, 小和
  { {0xf5c1a006,0xf93b6006,0xf49b5007,0xf8241004}},	//   形象, 最大, 書長, 益不
  { {0xf49a900f,0xf5a6e001,0xfa8bb00c,0x00000003}},	//   健食, 里裕, 輪海,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9320004,0xf940e004,0xf9432005,0xf59fc005}},	//   会及, 泉城, 粉加, 覆膜
  { {0xf9382004,0xfa4bf005,0xf928e005,0x00000003}},	//   州学, 民每, 身全,
  { {0xf9442009,0xf9374007,0xf5a60001,0xfa88f001}},	//   位及, 作坊, 後者, 部施
  { {0xfb5e6009,0xf93c0001,0xf830700c,0x00000003}},	//   模的, 所值, 穿上,
  { {0xfb66e004,0xfb554004,0xf9440001,0xf93d8004}},	//   周生, 活着, 等值, 老家
  { {0xf91d6006,0xfa643009,0xfa697009,0xf59d0004}},	//   性化, 克思, 家指, 品能
  { {0xf93c600e,0xfa685009,0xf9474001,0xfb530008}},	//   丁寧, 柏林, 富含, 己申
  { {0xfb4ba004,0xfa78d005,0x00000003,0x00000003}},	//   家相, 区春,   ,
  { {0xfb53800f,0x00000003,0x00000003,0x00000003}},	//   放置,   ,   ,
  { {0xf934a001,0xf5c34001,0xfb4ce00c,0xfb75400c}},	// [120] 愛地, 業貸, 色等, 記科
  { {0xf840f009,0xfa625001,0xf5a96001,0xf82fd005}},	//   中了, 祈求, 買越, 史任
  { {0xf91fa004,0xf80fe005,0x00000003,0x00000003}},	//   加基, 志代,   ,
  { {0xf59e200c,0xf595400c,0x00000003,0x00000003}},	//   寄託, 高苑,   ,
  { {0xf9332006,0xf8361009,0xf9394001,0xfa7d7004}},	//   沙市, 人介, 勝出, 学活
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf5af6004,0xfa66700c,0x00000003,0x00000003}},	//   数超, 下深,   ,
  { {0xf595c001,0xfa66d004,0xf9282008,0xfa55d00a}},	//   定買, 殊性, 用加, 喘息
  { {0xfa7d9009,0xf59f0004,0xfb78000c,0xf82d7005}},	//   学方, 了老, 原石, 念中
  { {0xf928200f,0xf9408009,0xf4a5b00e,0xfa617001}},	//   全宣, 分娩, 部隊, 分批
  { {0xf49e7004,0xf4895001,0xfa5f7004,0xfa5c7001}},	//   信集, 收高, 病是, 終成
  { {0xf92f8001,0xf9366001,0xfb5d600c,0xf93c2005}},	//   受庫, 土化, 珠的, 黄先
  { {0xf9324001,0xf9366008,0xf91dc00a,0xf5a1400a}},	//   動基, 期化, 信希, 資質
  { {0xf9266008,0xfa52f004,0xfa63f00c,0xfa71f005}},	//   在宅, 定教, 合業, 避暑
  { {0xf58d0009,0xfa87b004,0x00000003,0x00000003}},	//   他要, 用温,   ,
  { {0xf825d006,0xf5c84005,0xfa88100c,0x00000003}},	//   事人, 横行, 質手,
  { {0xf9198006,0xf831f008,0xf910100c,0x00000003}},	// [130] 出台, 山中, 新契,
  { {0xf92d8004,0xfa853008,0xfb67c00d,0x00000003}},	//   桓台, 置法, 猫的,
  { {0xf847f009,0xf9308004,0xf5912005,0xfa5a100a}},	//   用中, 法向, 算起, 要最
  { {0xf8361006,0xf922e00f,0xfb80600f,0xf58c6009}},	//   人事, 代役, 商用, 青色
  { {0xf9290004,0xf90c5004,0xf938a001,0xf90ff005}},	//   用平, 直售, 詞典, 平在
  { {0xfa631001,0xf93f2001,0xfa78500a,0xf5a3e005}},	//   手把, 順心, 層構, 腊肉
  { {0xf934c004,0xf4b1d00c,0x00000003,0x00000003}},	//   生城, 動連,   ,
  { {0xf90c1009,0xfb486005,0x00000003,0x00000003}},	//   巴南, 件版,   ,
  { {0xfa507007,0xf4cad001,0xf93e4001,0xf92ae001}},	//   算方, 乎都, 必勝, 成名
  { {0xf4c1f001,0xfa5e9001,0xfa87f00a,0x00000003}},	//   指頭, 組業, 絨毯,
  { {0xf9298009,0xfa78f001,0xfa5e5001,0xfa6af00c}},	//   在年, 出油, 分月, 乎想
  { {0xf9260002,0x00000003,0x00000003,0x00000003}},	//   斯山,   ,   ,
  { {0xf5c10009,0xfa65d001,0xfa6d700c,0xfa4c1005}},	//   索表, 躍投, 已持, 易摩
  { {0xf4c29001,0xf818b008,0xfa71f005,0xf5ab000a}},	//   合高, 最下, 即整, 水装
  { {0xf5b8800b,0xfa767006,0xfb5b8004,0xf92ac004}},	//   相談, 示最, 日第, 莒南
  { {0xf90cf00f,0xf49a5004,0xf92d8005,0xf58cc005}},	//   男女, 日通, 取定, 子身
  { {0xf4c79001,0xf9139004,0xfb59e005,0x00000003}},	// [140] 位音, 国原, 改稿,
  { {0xf90b100b,0xfb5be009,0xfa599009,0xfb502001}},	//   起動, 大突, 言情, 失禁
  { {0xf93c400e,0xf93f0007,0xf93ca004,0xf91be005}},	//   境問, 者協, 各参, 学回
  { {0xf90fd004,0xfa7db001,0xfa819005,0xfa4ef005}},	//   育健, 象棋, 次水, 著提
  { {0xfa4d5004,0xf4a37001,0xf91ca00c,0x00000003}},	//   化文, 業都, 別呼,
  { {0xfb534007,0xf943a004,0xf935c001,0x00000003}},	//   鋼筋, 有健, 生原,
  { {0xfb61200f,0xf5b2a006,0xf9101004,0xf5a4400c}},	//   短片, 西路, 花名, 上認
  { {0xfa5e9006,0xf90f3007,0xf4abf008,0xfb55400c}},	//   情感, 色可, 術部, 抽空
  { {0xf48b5008,0xfb63c001,0xf921a005,0xfa75100c}},	//   兵隊, 業環, 公允, 系服
  { {0xf9294007,0xf5b30004,0xf9406004,0xf928000c}},	//   全地, 国者, 率分, 用客
  { {0xf59de004,0xf821d008,0xf499b005,0xf947c005}},	//   居装, 計上, 交金, 名共
  { {0xfb80e009,0xf497f004,0xfb684004,0xf8363004}},	//   粉碎, 出部, 在管, 画作
  { {0xf90d700f,0xfb56c004,0xf83b9005,0xf59a800d}},	//   職場, 翻番, 略中, 夜蛾
  { {0xf82a900e,0xfb6bc00e,0x00000003,0x00000003}},	//   護保, 金等,   ,
  { {0xf80bc004,0xf90dd004,0xf93ea005,0x00000003}},	//   村三, 致地, 内回,
  { {0xfa7a9008,0xf93e8004,0xf91d6001,0xf91a6005}},	//   奥村, 密安, 性取, 除公
  { {0xf819d007,0xfb85e00c,0xfa70d005,0x00000003}},	// [150] 省下, 屋特, 新景,
  { {0xf4bc5006,0xf837f004,0xf92f4004,0xf91a8001}},	//   市食, 人享, 外大, 選入
  { {0xfb500004,0xfa6e9004,0x00000003,0x00000003}},	//   害物, 渲染,   ,
  { {0xf5c6000e,0xf4903007,0xf9170001,0xf9410004}},	//   景色, 東門, 人四, 者家
  { {0xfb73c004,0xfa689001,0xfb67800c,0xf5a20005}},	//   会研, 行施, 彩系, 肉菜
  { {0xf828300b,0xf80c4004,0xfa77b00c,0xfa6f9005}},	//   二人, 当中, 去污, 山泉
  { {0xf83c3006,0xfb85e00c,0x00000003,0x00000003}},	//   大了, 位研,   ,
  { {0xf5a56009,0xf93de00c,0xf9446005,0x00000003}},	//   上虞, 久居, 告市,
  { {0xf5980006,0xf5c1800e,0xf9332001,0xfb706005}},	//   作者, 本規, 力彩, 得特
  { {0xf49ad00f,0xf910b005,0xfb710005,0xfa78100c}},	//   知道, 地全, 牛玉, 頸椎
  { {0xf9416004,0xf92b0004,0xf5918001,0xf9272004}},	//   三包, 成小, 換言, 用当
  { {0xf910700f,0xf9486009,0xf5b36001,0xfb584001}},	//   新店, 式在, 山茶, 此等
  { {0xfb7fe004,0xfa65b005,0xfb7f6005,0xf92e800c}},	//   的瓶, 名成, 布署, 得勝
  { {0xf80ca006,0xfb7e8008,0xf5912008,0xfa80b005}},	//   外事, 准看, 法表, 院林
  { {0xf825b001,0xf946e004,0xf921e00c,0xfa551005}},	//   下令, 刊出, 夢工, 定改
  { {0xf9125004,0xfa70d004,0xf90fd001,0xf9230001}},	//   峰山, 新是, 東刊, 業入
  { {0xf5910004,0xfa6e9001,0xfa809004,0x00000003}},	// [160] 南至, 防法, 院法,
  { {0xf916a008,0x00000003,0x00000003,0x00000003}},	//   活字,   ,   ,
  { {0xf93fa00f,0xfb5e4001,0xf822f005,0xf9190005}},	//   旅客, 員終, 程上, 空出
  { {0xf912b00b,0xf5a52005,0xf823f005,0x00000003}},	//   製品, 下良, 及今,
  { {0xf4c1b001,0xf935c001,0xf9342001,0xf5966001}},	//   了避, 務基, 換券, 生質
  { {0xf83b300f,0xfa67700f,0xfb610009,0x00000003}},	//   令人, 同業, 班的,
  { {0xf90d7006,0xf837f001,0xf9310001,0xfa56d005}},	//   更好, 改作, 栗地, 存根
  { {0xfa6cd00f,0xfa5e5001,0xf4c53004,0xfa843005}},	//   色效, 億普, 名高, 是投
  { {0xfa87b001,0xf947a004,0xfb786004,0xf93de004}},	//   利津, 名女, 属登, 市健
  { {0xf93c0004,0xf92e8005,0x00000003,0x00000003}},	//   心同, 化利,   ,
  { {0xf8144004,0xf92f2001,0xf946a001,0xfa669005}},	//   力使, 向右, 行回, 同成
  { {0xf8457006,0xf93b8007,0xf4c1b00c,0xfb814005}},	//   是人, 品店, 光采, 分群
  { {0xfa65b001,0xf92c200c,0x00000003,0x00000003}},	//   不打, 我小,   ,
  { {0xf9464001,0x00000003,0x00000003,0x00000003}},	//   式合,   ,   ,
  { {0xfa5c3001,0xf4b55001,0xf83dd004,0xfb782005}},	//   一想, 務連, 卡上, 保用
  { {0xf5a7800b,0xf93c0004,0xf5c3800c,0xf935400c}},	//   意識, 裁庭, 京華, 期居
  { {0xfb7c600e,0xfa643007,0xf491f008,0xf5b0a00c}},	// [170] 一環, 有想, 板金, 調行
  { {0xf820d007,0xfb80a001,0xf5aee00c,0x00000003}},	//   商代, 理第, 地認,
  { {0xfb62c004,0xf949400a,0xfa69b00c,0x00000003}},	//   中管, 明太, 男服,
  { {0xfa6eb00f,0xf823f006,0xf83c1006,0xf835f009}},	//   詳情, 事会, 以人, 任会
  { {0xfa71f001,0xf5ab0001,0xf90bb001,0xf917c001}},	//   報本, 康軒, 念堂, 書後
  { {0xfa6f3007,0xf8385004,0x00000003,0x00000003}},	//   地時, 交下,   ,
  { {0xf4caf007,0xf945e001,0xfb814001,0xf90db005}},	//   低音, 和密, 商登, 育内
  { {0xf5a66009,0xf9198001,0xfa5fd004,0xfa5b700a}},	//   不良, 別再, 理提, 市淀
  { {0xfb7ba007,0xf4923007,0xf4bd1007,0xf82a5004}},	//   所示, 話連, 頂部, 直不
  { {0xf909f009,0xf5c2800e,0xfa55d004,0xfb646005}},	//   家属, 院議, 感悟, 修站
  { {0xf59fc008,0xf9173004,0xfa4d1010,0x00000003}},	//   勃起, 固原, 術政,
  { {0xf928c00a,0xfa55500c,0xf4b6900c,0xfa615002}},	//   怪奇, 機指, 賞魚, 肉桂
  { {0xf9103001,0xf92e2008,0xf5a6600c,0xf935c005}},	//   山堂, 科口, 事農, 孟州
  { {0xf918400f,0xfb7f4004,0xfa4ab004,0xf90ff00a}},	//   盤後, 分理, 青林, 想外
  { {0xfb7ee00f,0xfb5a8009,0xfa653004,0xf91a400c}},	//   的照, 学等, 糊搜, 方報
  { {0xf5c1e00b,0xf826d009,0xfb8b0009,0xfa82f001}},	//   監視, 上交, 税申, 正方
  { {0xf9350009,0xfa731008,0xf4a87001,0xf917500c}},	// [180] 定出, 共施, 坪頂, 紹各
  { {0xfb678007,0xf91a8007,0xf826f004,0xf935a001}},	//   夫球, 此可, 不交, 做家
  { {0xf93d4006,0xf9212004,0xfb57400c,0xf940e005}},	//   私声, 欣喜, 出神, 等前
  { {0xfa51500f,0xfa659008,0xfa85100c,0xf8197005}},	//   法支, 植民, 可扣, 障中
  { {0xf92f6001,0xf5b1a005,0x00000003,0x00000003}},	//   店全, 胰腺,   ,
  { {0xfa543004,0xfa787005,0x00000003,0x00000003}},	//   料成, 示波,   ,
  { {0xf9426006,0xf9304009,0xf90a5001,0xf49ff001}},	//   月内, 首家, 年刊, 遠都
  { {0xf93ba001,0xf9402004,0xfb656005,0xf92f200c}},	//   一入, 宅区, 枯燥, 紗店
  { {0xf945800e,0xf9115008,0xfa689004,0xf5b76001}},	//   遊園, 新婦, 行抽, 麻辣
  { {0xf91e8001,0xf822500a,0xf927e00c,0x00000003}},	//   員分, 奉仕, 末假,
  { {0xf923a006,0xfb86600e,0xf92bc001,0xf823b001}},	//   第六, 同盟, 倒入, 見了
  { {0xf48bb00b,0xfa4c7007,0xf932c004,0x00000003}},	//   年金, 拖把, 多内,
  { {0xf9296008,0xf80c6004,0xfb7f6001,0xf82e700c}},	//   優子, 子体, 萄籽, 想什
  { {0xfa809007,0xfa79b008,0x00000003,0x00000003}},	//   業技, 健所,   ,
  { {0xf9308009,0xf92f8004,0xf5a90005,0xf911700c}},	//   林匹, 林在, 富起, 深南
  { {0xf90cb006,0xf93e8007,0xf5a10004,0xfb80c005}},	//   更加, 商完, 担起, 等程
  { {0xf90c900b,0xf90f7009,0xfb842007,0xf5c7a004}},	// [190] 整形, 新密, 洋生, 部被
  { {0xf4be5007,0xf492b008,0xfa7cf005,0xfa5e1005}},	//   市都, 熱電, 以抵, 沃斯
  { {0xf944e009,0xf9376009,0xfa7bd004,0xf93ba00c}},	//   不包, 真履, 大最, 送外
  { {0xf93ba004,0xfb85400c,0x00000003,0x00000003}},	//   老外, 月異,   ,
  { {0xf93b8006,0xf90fb007,0xf8481004,0x00000003}},	//   一大, 育大, 被依,
  { {0xfb6ec001,0xf5a1c00c,0xfa6fd005,0xf922200c}},	//   著生, 合而, 柳林, 正副
  { {0xf9438006,0xf8245009,0xfa87300e,0xf4a4f004}},	//   有大, 反上, 編成, 是面
  { {0xf4bc700f,0xf9448001,0xfa79300a,0xf81b3002}},	//   時間, 月入, 常滑, 局代
  { {0xf9338007,0xf82a5004,0xf82c5004,0xf5a3c005}},	//   站商, 年事, 康人, 案被
  { {0xfa6df009,0xfa747004,0xf9496008,0x00000003}},	//   段性, 施是, 明器,
  { {0xf83a9007,0xfa4d5004,0xfa609001,0xfa6e5001}},	//   度下, 化指, 商港, 女最
  { {0xf908d004,0xf5c16008,0x00000003,0x00000003}},	//   家免, 本軍,   ,
  { {0xfa56d006,0xf8313009,0x00000003,0x00000003}},	//   官方, 新信,   ,
  { {0xfa51f001,0xfb5e4001,0xf825500c,0x00000003}},	//   力教, 瞧瞧, 籍作,
  { {0xfa5e9001,0xf940800c,0x00000003,0x00000003}},	//   商服, 宇博,   ,
  { {0xfb7f2004,0x00000003,0x00000003,0x00000003}},	//   居用,   ,   ,
  { {0xf818e009,0xf5b86001,0xfb82c004,0x00000003}},	// [1a0] 一事, 書者, 等物,
  { {0xf490b007,0xf8231004,0xf820d001,0xf92f8004}},	//   由高, 例不, 有事, 殖基
  { {0xfa5a500f,0xf93f2007,0xf4bc9001,0xfa64100c}},	//   送時, 的她, 千送, 月既
  { {0xfb65a00f,0xfb520001,0xf9262004,0xf934a001}},	//   助理, 共犯, 用如, 高商
  { {0xfa80b004,0xfa789001,0xf9446001,0xf927c00c}},	//   中求, 書摘, 月大, 助基
  { {0xf9302009,0xfa7f1008,0xf9346008,0xf9396005}},	//   引力, 無機, 紛失, 保函
  { {0xf920e008,0xfa70b001,0xfb82e008,0xf5c6a001}},	//   中堅, 到您, 應義, 磨豆
  { {0xf9320004,0xf82f1004,0xfb798008,0xfb69000c}},	//   定安, 新企, 節約, 棒等
  { {0xfb6c2007,0x00000003,0x00000003,0x00000003}},	//   酒精,   ,   ,
  { {0xf934c009,0xf4b4f001,0xf9326005,0xf918f00c}},	//   多大, 機送, 何国, 書借
  { {0xf8317004,0xfa7e9005,0xfa54b005,0x00000003}},	//   地交, 加或, 望海,
  { {0xfa85300c,0x00000003,0x00000003,0x00000003}},	//   普林,   ,   ,
  { {0xf5a56005,0x00000003,0x00000003,0x00000003}},	//   不辜,   ,   ,
  { {0xf818a00f,0xf5a56007,0xf83db004,0xf5a6e005}},	//   保代, 行袋, 亡事, 式要
  { {0xf92b200b,0xf4a03006,0xf5c6e005,0xfb7e200c}},	//   結局, 那里, 天路, 熄火
  { {0xfb6ae00e,0xfb5c0007,0xfb73a001,0xfa50100c}},	//   染症, 查照, 教站, 五斗
  { {0xf93f8004,0xf930600c,0x00000003,0x00000003}},	// [1b0] 内可, 算基,   ,
  { {0xf5b10001,0xfa589001,0x00000003,0x00000003}},	//   地設, 技授,   ,
  { {0xf919b001,0xf944800c,0xfb63000c,0xfa65f005}},	//   確地, 才名, 潭稻, 王春
  { {0xfa649004,0xfa66d005,0x00000003,0x00000003}},	//   予撤, 名条,   ,
  { {0xfa6d5004,0xfa83f001,0xf90fd00c,0xf931a00c}},	//   水浸, 般性, 東半, 比值
  { {0xf8122001,0xfa747004,0xf945400c,0xfb5c800c}},	//   多事, 款活, 先到, 工申
  { {0xf82a5009,0xfb582001,0xfa645005,0xf947e00d}},	//   年下, 出端, 克星, 和古
  { {0xf5a1c001,0xf5a78004,0xf83a3005,0xf8425005}},	//   合肌, 菊花, 以会, 散中
  { {0xf81c5006,0xf59d0007,0xf943600e,0xf9452005}},	//   的不, 品追, 均年, 合影
  { {0xf82e7007,0xf9398001,0xfa705004,0xfb826004}},	//   想一, 一幅, 使有, 午的
  { {0xf4c61004,0xfa633004,0xf80ae004,0x00000003}},	//   前途, 枇杷, 限不,
  { {0xfa4c7006,0xfb83a006,0xfa751006,0xf814a005}},	//   他有, 滋病, 稽查, 原上
  { {0xf80ce004,0xf91a9005,0xfa82900c,0xfa667005}},	//   道交, 判庭, 支手, 行思
  { {0xf4a19008,0xf91bb00c,0xf9125005,0x00000003}},	//   本銀, 層平, 新德,
  { {0xf818e00f,0xf93dc00f,0xf4997001,0xf920e005}},	//   一下, 時刻, 人音, 面在
  { {0xf4aa900e,0xf9127008,0xf48b700a,0x00000003}},	//   披露, 現存, 護部,
  { {0xfa78b004,0xf836d005,0xf940600c,0x00000003}},	// [1c0] 人武, 去五, 待命,
  { {0xfb6ac006,0xfa67b008,0xfb4e6008,0xf8090005}},	//   成立, 同条, 至福, 倒下
  { {0xfa793004,0xfa85d005,0xf58c600c,0x00000003}},	//   室文, 斯曼, 道設,
  { {0xfb70a004,0x00000003,0x00000003,0x00000003}},	//   街社,   ,   ,
  { {0xf944c009,0xfa70b004,0xfb56c004,0xfb5c0005}},	//   名参, 害性, 特等, 性突
  { {0xf938a004,0xfa5d3008,0xf81b2004,0xf5a6a004}},	//   什哈, 境機, 市事, 床股
  { {0xf93ea006,0xf9220007,0xf4a95004,0xf90b3008}},	//   七大, 業化, 排量, 買得
  { {0xfb5f0008,0xf812200c,0x00000003,0x00000003}},	//   止等, 供作,   ,
  { {0xf5bcc007,0xfa7d7005,0xfa65300c,0xf48b300c}},	//   大賞, 加清, 富月, 水高
  { {0xf941e004,0xfb7fa004,0xf4ab300c,0xf58ea010}},	//   理就, 理生, 源需, 委規
  { {0xfb614006,0xf4a31007,0xf8421001,0xf90c5005}},	//   独立, 可送, 正修, 康医
  { {0xf5be0007,0xfa7d1001,0xf93f2001,0xf4aa1001}},	//   採行, 素描, 者外, 間開
  { {0xf9115004,0xf5b8a004,0xf9478004,0xf8126005}},	//   新学, 方航, 行可, 定低
  { {0xf93d6009,0xf821b009,0xfb868004,0xf9312001}},	//   品德, 月下, 名第, 換屋
  { {0xf4c55005,0x00000003,0x00000003,0x00000003}},	//   名通,   ,   ,
  { {0xfb55c006,0xf911b005,0xfb67c00c,0x00000003}},	//   去的, 使土, 叫的,
  { {0xfb7f2007,0xfa5c9009,0xf9117008,0xf91ec004}},	// [1d0] 分組, 嫁接, 新古, 面合
  { {0xf5924004,0xfa837001,0x00000003,0x00000003}},	//   脚踏, 良教,   ,
  { {0xf9330009,0xf945a004,0xfa6c500c,0x00000003}},	//   会力, 同参, 家收,
  { {0xf944a005,0xf9105010,0xf92c0002,0x00000003}},	//   前小, 報元, 我前,
  { {0xf81b2009,0xfb57c00c,0xfa56300c,0x00000003}},	//   市之, 人研, 紙新,
  { {0xfa83700f,0xf92d8009,0xf92b8001,0xfa729005}},	//   副教, 取多, 自到, 都明
  { {0xf80f6007,0xfa5ed001,0xf91c700c,0xfa729005}},	//   著他, 約採, 接典, 能明
  { {0xf5a66006,0xf81e7009,0xfb5a8004,0xf59d8001}},	//   立足, 了三, 敦煌, 者認
  { {0xf9298004,0xfb49e001,0xf92c600a,0xfb57800c}},	//   在巴, 起終, 打席, 示結
  { {0xf91cf001,0xf5bd4008,0xf9141004,0xfa6c700a}},	//   你和, 加茂, 施得, 塵機
  { {0xf81e7006,0xf5a7e007,0xf944e00e,0xf4a2b004}},	//   的中, 軌跡, 配布, 京金
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf4c63008,0xf58ee004,0xf8138001,0xf5c4400c}},	//   同通, 向西, 四代, 修者
  { {0xfb84a00c,0xf5a9e00a,0xf9304005,0x00000003}},	//   半的, 強要, 耗大,
  { {0xfa729005,0xf5c0600c,0xfb81800c,0x00000003}},	//   好最, 業融, 盈盈,
  { {0xf842d007,0xfa5a9009,0xf90f5004,0xf90dd004}},	//   代人, 所未, 即停, 育均
  { {0xf910b004,0xfa68b001,0xfb6be008,0xf934800d}},	// [1e0] 地在, 小札, 民税, 域及
  { {0xfa669004,0xfb706008,0xf9418004,0xfa78f005}},	//   同提, 得点, 有必, 方是
  { {0xf81c0009,0xfa861001,0xf92cc004,0xf935800c}},	//   布之, 天我, 源在, 星君
  { {0xfb7d400f,0xf81b200e,0xf835f004,0xfb776004}},	//   頂端, 市下, 区今, 回用
  { {0xf818e00e,0xf5ad6009,0xfa62f001,0xfa4f5004}},	//   一例, 巴西, 先期, 向新
  { {0xfa78f006,0xfb85e009,0xf5a56001,0x00000003}},	//   根本, 熊猫, 事解,
  { {0xf90d900c,0x00000003,0x00000003,0x00000003}},	//   色布,   ,   ,
  { {0xf938e004,0xf9228004,0xfa551001,0xf4a5300a}},	//   所反, 是啊, 領悟, 華鏡
  { {0xfb638009,0xf599e009,0xf5aee007,0xfa84f001}},	//   副秘, 品行, 細菌, 淮提
  { {0xfb528006,0xf5946001,0xfa5af00d,0x00000003}},	//   国税, 生計, 壁江,
  { {0xfb58400f,0xf4c3f005,0xf8299005,0xf83dd005}},	//   群益, 三都, 号上, 象不
  { {0xf80de007,0x00000003,0x00000003,0x00000003}},	//   街一,   ,   ,
  { {0xfa549009,0xf9199007,0xf80fa008,0xf9496004}},	//   站或, 選取, 投与, 明在
  { {0xfb5b0009,0xf9320001,0x00000003,0x00000003}},	//   典礼, 且其,   ,
  { {0xfb844007,0xfb766009,0xf92dc004,0xfa4dd004}},	//   玉石, 高素, 列前, 少是
  { {0xfa85b00f,0xf923e004,0xfa4dd004,0xf920800a}},	//   用手, 售市, 民是, 員室
  { {0xf923a006,0xfa541001,0xf5a5c00a,0xf9340005}},	// [1f0] 冬季, 力方, 俊輔, 力出
  { {0xf81c000f,0xf49a9002,0x00000003,0x00000003}},	//   布下, 肥食,   ,
  { {0xf5bd4007,0xf90e9004,0xf49b500a,0xfa655005}},	//   你要, 地合, 入館, 秋梢
  { {0xfb7c4001,0xf4905005,0xfb54c005,0x00000003}},	//   終生, 台酒, 好管,
  { {0xf826f004,0xf93aa004,0xf926c008,0xfa55d004}},	//   意什, 技含, 推定, 熟期
  { {0xf5bca009,0xf8491001,0x00000003,0x00000003}},	//   大蒜, 自保,   ,
  { {0xfb4ac001,0xfb72400c,0xf4acb00a,0x00000003}},	//   護神, 動空, 首里,
  { {0xf832b007,0xfb72e004,0xf5b1c005,0xfa6f7005}},	//   都一, 定理, 共被, 台旅
  { {0xf9350007,0xf8223001,0xf48fb008,0xfb5a200c}},	//   定基, 光休, 防除, 蒸籠
  { {0xf9470009,0xfa71f004,0xfa861001,0xf91b7005}},	//   不健, 新格, 適感, 接利
  { {0xf90e7009,0xfb558004,0xf5b2e001,0xfb7f0001}},	//   米市, 国白, 己能, 的翻
  { {0xf5bbc00b,0xfb5b600b,0xfb4ac00f,0xfb82e009}},	//   大規, 日目, 男生, 合生
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa4d1004,0xf8237005,0xf9340005,0xfa4db00a}},	//   金星, 奈何, 婚夫, 成樹
  { {0xf9422004,0xfa727008,0xf909f00a,0x00000003}},	//   万大, 東武, 拷問,
  { {0xfb674007,0xf9240004,0xf822d004,0xf918f004}},	//   骨科, 中巴, 事争, 区出
  { {0xf90a3001,0xf5a6600c,0xfb59c005,0x00000003}},	// [200] 起分, 不肯, 容相,
  { {0xf92f8004,0xfb6dc004,0xf839f005,0xf4bd500c}},	//   化吸, 成相, 船使, 超重
  { {0xf90af00f,0xf593c00c,0xf822f00a,0x00000003}},	//   家庭, 教講, 立上,
  { {0xfb62a00b,0xf821f00e,0xf925a004,0xfb6f6004}},	//   連絡, 資信, 可吸, 得用
  { {0xf9169006,0xf920c009,0xf920a001,0x00000003}},	//   出境, 索字, 趣商,
  { {0xf4c69004,0xf90a3004,0xf826f00c,0xfa7b100d}},	//   昌邑, 海分, 族企, 查暗
  { {0xf5c0c005,0x00000003,0x00000003,0x00000003}},	//   季豆,   ,   ,
  { {0xf5bbc004,0xfb7f4001,0xfa563004,0xfb520001}},	//   以胡, 婆的, 期投, 由第
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa63d006,0xfa7bf004,0xf92e8004,0xf9248005}},	//   友情, 以撤, 取利, 是巨
  { {0xf81f8004,0xf4c1b001,0xf5912001,0xfb72e001}},	//   万事, 合開, 法辨, 驚爆
  { {0xf9292001,0xf8178004,0xfb61e005,0xf92f600d}},	//   周報, 土人, 院特, 店在
  { {0xfb4e6006,0xf4b47004,0xf93ae004,0xf8178004}},	//   味着, 会面, 持多, 期人
  { {0xf8178007,0xf8319004,0xfb76a001,0xf4b61005}},	//   真人, 湾事, 生種, 候都
  { {0xf9199004,0xf4c63005,0x00000003,0x00000003}},	//   出地, 下都,   ,
  { {0xf911700b,0xf4c2300e,0xfb518004,0xf49a1004}},	//   議員, 計量, 款等, 点都
  { {0xf835f009,0xf8309007,0xf922c005,0xf58d200c}},	// [210] 区上, 想你, 代医, 間調
  { {0xfa49f004,0xfa87700a,0xf820200d,0x00000003}},	//   当手, 師求, 者交,
  { {0xf94ac006,0xf9436006,0xf90ff00f,0xf9189009}},	//   美国, 三大, 到府, 方志
  { {0xf83ad001,0xfa78b001,0xfb6ee001,0xf4aaf005}},	//   券使, 懸掛, 我相, 冒雨
  { {0xf9103006,0xfb86800c,0xfb6ee00c,0xfb5a600d}},	//   山市, 事細, 賑災, 泥生
  { {0xfb54600e,0xfa549009,0xfa779001,0xf9262004}},	//   乾燥, 高清, 基法, 用市
  { {0xf947c004,0xfb792005,0xfb87200c,0xf5b1c00d}},	//   名山, 最突, 融知, 佳肴
  { {0xfa4f7006,0xf4bcd001,0xf8293001,0xf93fc001}},	//   宗旨, 境遇, 夏令, 約報
  { {0xf943a004,0xfb85c001,0x00000003,0x00000003}},	//   下内, 律系,   ,
  { {0xf59f2009,0xf9484005,0xf910b010,0x00000003}},	//   集装, 李勇, 宿免,
  { {0xf90ad009,0xf4b49007,0xf9179004,0xfb69200c}},	//   件公, 力防, 点内, 巨石
  { {0xf93a0006,0xfb80e001,0xf936a001,0xf92e8004}},	//   所属, 宅男, 折出, 比前
  { {0xfb548005,0x00000003,0x00000003,0x00000003}},	//   国独,   ,   ,
  { {0xf915b009,0xf911d009,0xf4909004,0xfb5c4001}},	//   国平, 宿州, 就高, 度研
  { {0xf9446009,0xf9426004,0xf8395004,0xf820c00c}},	//   光台, 哈密, 方信, 三事
  { {0xfb48a001,0xf9328008,0xf9396004,0xf930600c}},	//   家看, 愛子, 障公, 外場
  { {0xf82cf006,0xf4c75009,0xf5c0c00c,0x00000003}},	// [220] 史上, 上都, 難者,
  { {0xf92f8007,0xfa5a3009,0xf5c50009,0xf492700c}},	//   動名, 品流, 是解, 放通
  { {0xf9394007,0xf5c16007,0xf937e001,0xf9262005}},	//   府全, 次買, 生平, 利州
  { {0xf840f006,0xf49a9007,0xf48db001,0xf942a00c}},	//   代会, 急速, 年音, 有取
  { {0xfa803007,0xf9135001,0xfa5e100c,0xfa85900c}},	//   遠東, 深具, 濃湯, 良方
  { {0xf90b1007,0xf9101001,0xfb5b2005,0x00000003}},	//   海底, 到回, 接穗,
  { {0xf5a4e001,0xfa851004,0xf5ab4008,0xf59f8001}},	//   位者, 天最, 家試, 約能
  { {0xfb554004,0xf4c35004,0xf92ae005,0xfa4d9005}},	//   押物, 程量, 成反, 捐活
  { {0xf92ae004,0xf9392004,0xfa7e9005,0x00000003}},	//   成倍, 果在, 次教,
  { {0xf5bba009,0xfb656001,0xfb640004,0xf8373005}},	//   以解, 嫩的, 本知, 方企
  { {0xf819a006,0xf944c005,0xf92e200c,0xfb5e2005}},	//   作中, 上内, 五合, 性管
  { {0xf5b0a001,0xf919b004,0xf93a800a,0x00000003}},	//   報記, 点入, 作国,
  { {0xfa85b007,0xf5912001,0xf927e005,0xf917700c}},	//   物料, 動著, 器公, 攻勢
  { {0xf5a68008,0x00000003,0x00000003,0x00000003}},	//   立花,   ,   ,
  { {0xf8120006,0xfa7ff004,0xfb824004,0xf9350005}},	//   通事, 客文, 月球, 熟品
  { {0xf9316001,0xf48b5001,0xf5a3400c,0x00000003}},	//   投審, 水通, 見規,
  { {0xfb83c009,0xfa80300e,0xf835f004,0xf59a8001}},	// [230] 版物, 解明, 建三, 往返
  { {0xf9398004,0xfb7f400a,0x00000003,0x00000003}},	//   一居, 元社,   ,
  { {0xf82e100e,0xf914b004,0xf9402001,0xf93f6001}},	//   右上, 国客, 宅出, 的命
  { {0xf915100f,0xfb866004,0xf90e1004,0xfb6a4004}},	//   找到, 同生, 已婚, 粒生
  { {0xfa88b009,0xf4a69007,0xf593a001,0xf934e005}},	//   利水, 旨願, 甘菊, 会去
  { {0xf91f5004,0xfb4fe001,0xf5c5400a,0x00000003}},	//   大巴, 山美, 助言,
  { {0xf945a009,0xfa5c1007,0xf59c2008,0xfb57000c}},	//   下大, 心服, 着色, 系目
  { {0xf80c2005,0xf91fd005,0xf594600c,0xf90df00d}},	//   少企, 面写, 食草, 平及
  { {0xfa79b001,0xfa4e5004,0xf9199004,0xfa73b001}},	//   人海, 取暖, 点大, 落成
  { {0xf59d400e,0xfb4c0004,0x00000003,0x00000003}},	//   故車, 年研,   ,
  { {0xf920100f,0xfb72e008,0xfb846008,0xfb7d6004}},	//   加值, 供用, 前立, 善盟
  { {0xf9109007,0xfa7a900c,0xf5b98005,0x00000003}},	//   色印, 入機, 区花,
  { {0xf82eb009,0xf8172009,0xf820c004,0xf4941001}},	//   台上, 生信, 三下, 社造
  { {0xf92e4006,0xf8317007,0xf9304004,0xfa5dd004}},	//   五届, 現今, 五周, 情概
  { {0xfa783009,0xf92e4004,0xfb85c005,0x00000003}},	//   移栽, 岐山, 屋登,
  { {0xf4979004,0xfb77e001,0xfb64000a,0xf4a8f00c}},	//   区青, 思緒, 瞭然, 質高
  { {0xf826d008,0xf828d001,0xf4a1700c,0xfa517005}},	// [240] 和五, 然一, 代道, 北水
  { {0xfb7f4007,0xf5bb6001,0xf5ab0001,0xf5a9e00c}},	//   商紙, 券買, 溶解, 礎設
  { {0xf932e004,0xf81fa004,0xf4c53008,0xf93fc004}},	//   些在, 分保, 同開, 病因
  { {0xf5c06001,0xf913d004,0xf93e600d,0x00000003}},	//   你走, 国当, 的催,
  { {0xf831b001,0xf917500a,0x00000003,0x00000003}},	//   承保, 根元,   ,
  { {0xf5a46007,0xfb866007,0xf488700e,0xf5b60004}},	//   再見, 小熊, 扶養, 国茶
  { {0xfb856004,0xf93ce001,0xf58ac004,0xf92c200a}},	//   及科, 市取, 染者, 子回
  { {0xf5aa600c,0xf91af010,0x00000003,0x00000003}},	//   島航, 工受,   ,
  { {0xfa59b006,0xfa571006,0xfa6f9006,0xf946c009}},	//   思想, 非法, 印文, 上大
  { {0xf94a2001,0xf92a600c,0xf58fc002,0x00000003}},	//   奏家, 優劣, 撕裂,
  { {0xf946e006,0xfb5a2008,0xfa87b005,0xfb838005}},	//   不大, 除用, 物活, 王秀
  { {0xfb62e001,0x00000003,0x00000003,0x00000003}},	//   宣示,   ,   ,
  { {0xf814800e,0xfb690007,0xfa76f00c,0xfa75d005}},	//   牛乳, 航線, 出愛, 出消
  { {0xfa72100c,0xf5bcc005,0xfb79000c,0xfa7af005}},	//   地想, 大舞, 果糖, 知法
  { {0xfa5f3006,0xf83ef00f,0xfb740009,0xfa683008}},	//   的核, 面介, 料生, 完治
  { {0xf83ff008,0xf9434004,0xf5a4c00c,0xf947c00c}},	//   信中, 洋局, 合調, 和度
  { {0xfb7ec007,0xf921f007,0xf815a005,0x00000003}},	// [250] 垂直, 業委, 期会,
  { {0xfa5db009,0xfa60f004,0xf4b59001,0x00000003}},	//   市武, 文成, 生魚,
  { {0xf9231007,0xf9211004,0xf49c7004,0xfa6d7004}},	//   業工, 信平, 急避, 育概
  { {0xf917100f,0xfa4c100e,0xfa82900a,0x00000003}},	//   人力, 子機, 本民,
  { {0xf9356007,0xfb870007,0xf946000d,0x00000003}},	//   原商, 籍登, 今在,
  { {0xf82ef00f,0xf93cc00b,0xf846d009,0xfa7ff004}},	//   到低, 還元, 用作, 校本
  { {0xf93bc009,0xfa669007,0xfa6a3004,0xfa75300a}},	//   市居, 行星, 更手, 白樺
  { {0xf499d007,0xfb746005,0x00000003,0x00000003}},	//   接送, 食等,   ,
  { {0xfa509006,0xf9308004,0xf4b2d008,0xf5a7e005}},	//   南方, 南出, 香里, 李老
  { {0xf914700f,0xf9330001,0xfa80b004,0xf59f800c}},	//   現出, 務名, 次改, 情路
  { {0xf92d8007,0xf91c100a,0xfa72f010,0x00000003}},	//   鎖定, 肥大, 社民,
  { {0xf4c2300c,0xfa6a3005,0xf824a00d,0x00000003}},	//   予退, 架林, 届七,
  { {0xf4a2b00f,0xf4a7d007,0xf92e6004,0xf4c0b001}},	//   瞬間, 風雨, 向学, 宅防
  { {0xfa77b007,0xfb52600c,0x00000003,0x00000003}},	//   人投, 抽筋,   ,
  { {0xf836b007,0xfa765004,0xf9494001,0xf938800c}},	//   幹事, 活提, 踏入, 孜孜
  { {0xf945e00e,0xfb510001,0xf5a4a00c,0xfa70900d}},	//   個別, 由生, 車考, 平武
  { {0xfb83c00f,0xfa62b00b,0xf9430004,0xf58b6004}},	// [260] 合目, 資格, 等六, 限超
  { {0xf5974007,0xfa503001,0xf5c40001,0xf94b400c}},	//   斜背, 外海, 置要, 乎其
  { {0xf93ca00f,0xf910d007,0xf93c8001,0xf946a004}},	//   一場, 育場, 各局, 立卷
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa70f001,0xf913b005,0xfb4f000a,0xfa5c1005}},	//   報期, 国向, 獲物, 要探
  { {0xf9434007,0xf594a00a,0xf92ee005,0xfb6e2005}},	//   誇張, 付資, 栗子, 金短
  { {0xf4bdb006,0xf93de009,0xf92ac004,0xfb51a00a}},	//   黄金, 内心, 道内, 想環
  { {0xf81d4002,0x00000003,0x00000003,0x00000003}},	//   包予,   ,   ,
  { {0xf928000e,0xf947a004,0xf58be004,0xfa881005}},	//   用形, 及具, 向行, 在探
  { {0xfa66d009,0xfa729004,0xf921700a,0x00000003}},	//   藏族, 危旧, 衣子,
  { {0xfa65500f,0x00000003,0x00000003,0x00000003}},	//   才招,   ,   ,
  { {0xf9350007,0xfa78f008,0xf93c800a,0xf5bbe00a}},	//   生堂, 診日, 最年, 知財
  { {0xf9428004,0xfa83b008,0xf9263005,0xfa73b00c}},	//   三化, 維新, 全封, 尾港
  { {0xf946c009,0xf81fa004,0xf917d001,0xf81dc00c}},	//   之年, 率上, 移入, 充一
  { {0xfa7b9007,0xfa5fd001,0xf48f9005,0xf92c000a}},	//   入本, 約新, 数高, 苑前
  { {0xf823c009,0xf82eb001,0xf5afa001,0xf934e005}},	//   始了, 地介, 報載, 叙利
  { {0xf926d001,0xfa7fb005,0xfb688005,0x00000003}},	// [270] 身守, 凡未, 在知,
  { {0xf4c31008,0xfa4dd00a,0x00000003,0x00000003}},	//   有馬, 策機,   ,
  { {0xf8242006,0xf8162004,0xf5b2600a,0x00000003}},	//   上下, 九三, 抱負,
  { {0xf940a009,0xf93ec004,0xf4be7008,0xfb4aa001}},	//   病害, 如家, 理運, 谷生
  { {0xf8262005,0xf8270005,0xf5c66005,0xf943e005}},	//   不享, 同他, 用装, 程勘
  { {0xf59a6004,0xfa52b008,0xf4c71004,0xf946e005}},	//   一角, 務案, 小黄, 和宗
  { {0xf93e6006,0xf814a004,0xf9187005,0x00000003}},	//   的公, 速下, 翻唱,
  { {0xf92ce006,0xf918f009,0xfa809009,0xfa631004}},	//   限公, 区基, 次活, 合材
  { {0xf80b2009,0xfa767001,0xfb52a001,0xf92ba005}},	//   当作, 主打, 放生, 恒大
  { {0xf90d1007,0xf58fa001,0xf946000c,0xf813600c}},	//   浴室, 底要, 今周, 供代
  { {0xf597a007,0xf5ab4009,0xf926d005,0x00000003}},	//   果要, 践行, 修好,
  { {0xf8457001,0xfa7a1001,0xf83ef001,0xf8168005}},	//   可任, 方格, 面下, 初二
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb5a2006,0xfa4ed001,0xfb84000c,0x00000003}},	//   方米, 糖業, 光社,
  { {0xf80dc005,0x00000003,0x00000003,0x00000003}},	//   化也,   ,   ,
  { {0xfa7cb007,0xfb61e004,0xf92ea005,0x00000003}},	//   你有, 本病, 得土,
  { {0xf5910004,0xf48e7001,0xfb6fc00c,0xfa50f00d}},	// [280] 北至, 已逐, 敗犬, 佛手
  { {0xf4a09008,0xfa62f001,0xfa79f005,0xfb52a00c}},	//   中退, 律手, 交投, 話確
  { {0xf9322006,0xfa611006,0xf923300e,0xfa531004}},	//   四川, 光明, 本全, 写明
  { {0xf58a6001,0xfa53900a,0x00000003,0x00000003}},	//   誓言, 勘案,   ,
  { {0xfa649009,0xfa7ff001,0xf940c004,0x00000003}},	//   事法, 客指, 病危,
  { {0xf9364009,0xf83b3004,0xf4c9d001,0xf4b79001}},	//   州分, 交人, 式音, 生選
  { {0xfa4e3009,0xfb4b8009,0xf8433009,0xfa59b004}},	//   外投, 水生, 班主, 言文
  { {0xf93ee00f,0xf91cd00f,0xfa78500e,0xf910f001}},	//   市場, 日報, 常時, 到可
  { {0xf92a0004,0xf9103001,0xfa7d9005,0x00000003}},	//   体同, 防偽, 加文,
  { {0xf5944009,0xf92a0004,0xf92f600a,0x00000003}},	//   高血, 当同, 金台,
  { {0xfb866005,0xf9472005,0xfa88500c,0x00000003}},	//   名目, 嫌受, 晨曦,
  { {0xf80f8009,0xf910d009,0xf926b00e,0xfa61b004}},	//   外人, 想大, 適化, 按文
  { {0xf4987001,0xf4c7d00c,0xf4add00c,0xf82e500a}},	//   人面, 城門, 店門, 段使
  { {0xf4c03007,0xfb862001,0xfb52a00c,0x00000003}},	//   分達, 見疾, 週知,
  { {0xfa783004,0xf934e00c,0xfa607002,0x00000003}},	//   此案, 多工, 密措,
  { {0xf5b76001,0xf5ac400c,0xf5bf400c,0xfa719002}},	//   任董, 家買, 映象, 到死
  { {0xfa66700e,0xf5bf6004,0xf944c00c,0xf915d00a}},	// [290] 配慮, 院要, 下化, 主務
  { {0xf940a007,0xf5b5c001,0xf5a4600c,0xf9350005}},	//   安安, 芽耳, 操行, 生如
  { {0xf5a86009,0xfa739001,0x00000003,0x00000003}},	//   藏自, 能感,   ,
  { {0xfb7e0009,0xf93fa001,0xf92dc008,0xf93ca001}},	//   包的, 各報, 算式, 送入
  { {0xfa7dd006,0xf5968001,0x00000003,0x00000003}},	//   照本, 生表,   ,
  { {0xf91bd00f,0xfb6ac006,0xf9408009,0xf91df007}},	//   入口, 未知, 争先, 占卜
  { {0xfb72e00b,0xf91f100b,0xf9310001,0x00000003}},	//   換算, 次回, 供完,
  { {0xf944800f,0xfa76b009,0xfa895008,0xfa787004}},	//   有其, 区情, 怪我, 添新
  { {0xfb5a8007,0xfa60f001,0xfa4bf005,0x00000003}},	//   工科, 假民, 子思,
  { {0xf82a7001,0xf4b9f008,0xf945a00c,0x00000003}},	//   乎人, 最速, 重回,
  { {0xf939a00f,0xf5c40007,0xf9161004,0xf9233005}},	//   一切, 普考, 人告, 中培
  { {0xfa87300b,0xf9193009,0xf9131001,0xfb86e00c}},	//   普段, 相当, 能充, 位照
  { {0xf9183009,0xf911f009,0xf943c005,0x00000003}},	//   任命, 找品, 立商,
  { {0xfa6df004,0xfa78f004,0x00000003,0x00000003}},	//   年海, 方支,   ,
  { {0xf83cd009,0xf820e004,0xfa57900c,0xf594600a}},	//   因不, 但中, 星書, 高脂
  { {0xfb6d0009,0xf9267004,0xfa7fd001,0xf5b30005}},	//   世私, 周密, 惠房, 国超
  { {0xf93c8001,0xf92c000c,0xfb6c6005,0x00000003}},	// [2a0] 送大, 我再, 析研,
  { {0xf4959001,0xfa60f005,0x00000003,0x00000003}},	//   能都, 薇捐,   ,
  { {0xf9406004,0xf595e001,0xfb7fa005,0xf935a010}},	//   了太, 料調, 内短, 江原
  { {0xf90d700a,0x00000003,0x00000003,0x00000003}},	//   雲市,   ,   ,
  { {0xf92ba006,0xfb64c009,0xf9243009,0xfb590001}},	//   村合, 物等, 路北, 空空
  { {0xf8371009,0xfa4f7009,0xf8214008,0xf8134004}},	//   人会, 抗洪, 光一, 写一
  { {0xfa5b3007,0xfa7c3004,0xf9366008,0xfb54e001}},	//   求才, 度投, 速化, 都無
  { {0xf5cb6006,0xf58cc004,0xfb862005,0xf9259005}},	//   截至, 子被, 告第, 在先
  { {0xf4c4f009,0xfb498009,0xf91b9004,0xfa5f7001}},	//   告通, 家秘, 查公, 片消
  { {0xf91b9009,0xfa657001,0xf4c0900c,0xf842700c}},	//   知公, 行歌, 沉醉, 解你
  { {0xf4afb006,0xf9402009,0xfa643001,0xfb89600a}},	//   五金, 宅基, 合採, 小竹
  { {0xf93fa009,0xfa509001,0xf49dd005,0x00000003}},	//   薄弱, 法成, 秦都,
  { {0xfa65f005,0x00000003,0x00000003,0x00000003}},	//   菌清,   ,   ,
  { {0xf91b1006,0xf845d004,0xfa655004,0xf8168005}},	//   学品, 修中, 告提, 料件
  { {0xf92d8001,0xf80a2001,0x00000003,0x00000003}},	//   化博, 道下,   ,
  { {0xfb71e004,0xf9408001,0xfa7d9001,0xf9416005}},	//   会版, 升官, 次月, 三居
  { {0xf8439007,0xf926f001,0xf9179004,0xfa807001}},	// [2b0] 可供, 修平, 治学, 管控
  { {0xf4c09007,0xf947c00c,0x00000003,0x00000003}},	//   者都, 和弦,   ,
  { {0xf93ea006,0xf49a5001,0xfa55700c,0x00000003}},	//   商城, 此部, 乘法,
  { {0xfb564007,0xf4bef009,0xfa89b001,0xfa60b001}},	//   死神, 的除, 努比, 者想
  { {0xf9147004,0xf923b00c,0x00000003,0x00000003}},	//   份公, 種型,   ,
  { {0xf9243004,0x00000003,0x00000003,0x00000003}},	//   路南,   ,   ,
  { {0xf928f001,0xf91dd00a,0x00000003,0x00000003}},	//   火化, 条及,   ,
  { {0xfa641004,0xfa6e1004,0xfb7fe001,0xfb49c008}},	//   合正, 欲望, 者無, 護福
  { {0xfb846009,0xfb804001,0xf92ce004,0xf93ee004}},	//   立科, 指的, 殖小, 考入
  { {0xf942c007,0xf941e007,0xfb6f2005,0xf833300c}},	//   事先, 理報, 外管, 眼介
  { {0xf598e008,0x00000003,0x00000003,0x00000003}},	//   紀行,   ,   ,
  { {0xf91cd00f,0xfb502006,0xf5a90001,0xf91ab00c}},	//   工具, 色社, 件裁, 司出
  { {0xf8134007,0xfb676004,0xf946c001,0xf93bc00d}},	//   定保, 含着, 看其, 言建
  { {0xfa681007,0xfa833004,0xfb8a4005,0xf90c300c}},	//   序法, 班查, 式破, 海堤
  { {0xf91a7004,0xf911300a,0xfa7bd005,0xf5aa000a}},	//   度很, 右岸, 否成, 整脈
  { {0xf9478004,0xf9470001,0xfa809001,0xf92c800a}},	//   小宝, 植入, 業最, 化型
  { {0xfa843009,0xf92d0001,0xfb4ba004,0xf4a2b004}},	// [2c0] 是法, 我喜, 究相, 路透
  { {0xf921f00f,0xfa819004,0xf9314001,0xfa5e9005}},	//   夢幻, 中民, 展售, 浅析
  { {0xfa6bf009,0xf9362007,0xf92ca007,0xf4979001}},	//   年投, 感冒, 駐外, 人道
  { {0xf5ba2008,0xf5b44001,0xf916f005,0xf4c09005}},	//   常設, 拿起, 主在, 文通
  { {0xfb8a6005,0x00000003,0x00000003,0x00000003}},	//   迎登,   ,   ,
  { {0xf93ec005,0x00000003,0x00000003,0x00000003}},	//   考大,   ,   ,
  { {0xf82d3006,0xfb7f2006,0xfb666004,0xf83df001}},	//   年人, 的特, 在病, 次低
  { {0xf90ff001,0xf93fc00c,0xfa88f005,0x00000003}},	//   影城, 篇小, 被注,
  { {0xfa7ad004,0xfb4ec004,0x00000003,0x00000003}},	//   以法, 耳病,   ,
  { {0xf927b006,0xfa5eb006,0xf8395004,0xf943c005}},	//   在全, 市海, 交会, 予全
  { {0xf9151009,0xf9372004,0xfa539004,0xf4c3d005}},	//   能大, 搞得, 站文, 案部
  { {0xfa4dd00f,0xf9442007,0xf8236001,0xf9310001}},	//   街所, 刊名, 埋伏, 旗山
  { {0xf946e004,0xf4a8d00a,0xfb5e4005,0xf93d200c}},	//   植大, 優香, 大知, 流報
  { {0xf9308006,0xfa763007,0xf938e007,0xf917f004}},	//   北区, 抽水, 祝大, 区八
  { {0xf81bc00b,0xf83fb00f,0xfa505009,0xfb7ce001}},	//   一人, 章主, 取水, 心痛
  { {0xf82ba00f,0xf9295004,0xfb52a001,0xf941a00c}},	//   延伸, 峨山, 政目, 有勇
  { {0xf823c00f,0x00000003,0x00000003,0x00000003}},	// [2d0] 有人,   ,   ,
  { {0xf81e8006,0xf9181007,0xf49c9004,0x00000003}},	//   担保, 示全, 警部,
  { {0xf92fa00f,0xf946a009,0xf910b004,0x00000003}},	//   字可, 小城, 使城,
  { {0xf59b0009,0xf93fa00c,0x00000003,0x00000003}},	//   私舞, 商借,   ,
  { {0xfa7bf009,0xf945c007,0xf8124004,0xfa86d004}},	//   以此, 行品, 会不, 利推
  { {0xf945e004,0xf4b6f005,0xf49cf00c,0xfa58d00a}},	//   上取, 域面, 度面, 所掌
  { {0xf4a0700f,0xf8246009,0xf81d6007,0xf847f008}},	//   搭配, 位不, 者介, 利便
  { {0xf92f4007,0xfa725004,0xfa53d008,0xfb5c4001}},	//   五四, 国手, 換性, 春特
  { {0xf5966009,0xf49df005,0xf498300c,0x00000003}},	//   生自, 大造, 常需,
  { {0xfb7a6004,0xfa635001,0xf9400001,0x00000003}},	//   威的, 月投, 者大,
  { {0xfa581004,0xf946000c,0x00000003,0x00000003}},	//   霞浦, 程司,   ,
  { {0xf9326001,0xfb7c2001,0xfb60a004,0xf9127005}},	//   定式, 的羊, 面答, 泰康
  { {0xfa51100c,0x00000003,0x00000003,0x00000003}},	//   著新,   ,   ,
  { {0xfa5ef006,0xf824c004,0xf82ac001,0xf599e001}},	//   清洗, 免一, 場一, 要認
  { {0xfa82900e,0xf824a001,0xfa567005,0xfa53b005}},	//   六本, 月人, 保每, 多投
  { {0xfa61f005,0xfa85700c,0xfa84d00d,0x00000003}},	//   理数, 詩情, 路正,
  { {0xf9173006,0xf9448001,0xf9291005,0x00000003}},	// [2e0] 任公, 三場, 末全,
  { {0xf4bf5006,0xfa81900e,0xf935a001,0xf911b005}},	//   内部, 索条, 原定, 使原
  { {0xf92c9005,0xf90a5005,0xf5c5e00c,0x00000003}},	//   他告, 其外, 木認,
  { {0xf4c55004,0xfb7d6004,0xf48ed004,0xfa73d00a}},	//   和配, 善生, 米高, 駿河
  { {0xf9412009,0xf4afd00e,0xf5b8a004,0xf90c7001}},	//   泉市, 首都, 人股, 宵夜
  { {0xf90ff00e,0xf923b001,0x00000003,0x00000003}},	//   想化, 可做,   ,
  { {0xfa575001,0xf8333004,0xf499d005,0xf922f005}},	//   作手, 眼下, 交道, 断学
  { {0xfa605004,0xfa687001,0xf91d5004,0xfa63d010}},	//   了抗, 式早, 池市, 刊案
  { {0xf925d004,0xfa6b9001,0xfa5e100c,0xf90ff002}},	//   器和, 家方, 的挫, 影后
  { {0xfa7b7004,0xf9257001,0xf48bb001,0x00000003}},	//   日是, 浩帆, 然都,
  { {0xfb6be004,0xf5b12004,0xf5a80008,0xfa5f9004}},	//   体用, 使者, 前職, 球新
  { {0xf945200f,0xfa793004,0xf4a29004,0xfa6a7008}},	//   合報, 吸毒, 庭院, 美智
  { {0xfa84f009,0xf947600c,0xf5b3400c,0x00000003}},	//   京海, 城半, 東農,
  { {0xfb4c000e,0xfb630008,0xfa6ef004,0xf90f1001}},	//   然環, 中略, 新意, 防刮
  { {0xf83b9009,0xfa5cb004,0xfa5b5004,0x00000003}},	//   度会, 市投, 求每,
  { {0xfa66d006,0xfa639007,0xf81c2001,0xf9492005}},	//   越来, 安死, 考下, 夏大
  { {0xf9223006,0xf58dc00c,0x00000003,0x00000003}},	// [2f0] 中全, 我身,   ,
  { {0xfb61800f,0xf9279008,0xf48cb005,0xfa6e3005}},	//   連結, 部外, 年面, 段改
  { {0xf4b55004,0xfa643005,0xf4b4f00c,0x00000003}},	//   高限, 前消, 土銀,
  { {0xf5a24006,0xf9185004,0x00000003,0x00000003}},	//   三角, 建公,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf930a009,0xf5982004,0xfa88d001,0xf826000c}},	//   南岸, 潜艇, 部政, 看人
  { {0xf8146009,0xfa7cd004,0xf94a6001,0xf947e001}},	//   会中, 大民, 礎入, 行員
  { {0xfa643004,0xf942e004,0xf916f001,0xf9354005}},	//   位朋, 型合, 容忍, 会国
  { {0xf80c6006,0xf8268004,0xf90d3005,0xf4ad300c}},	//   易中, 位中, 年医, 黑道
  { {0xf9121006,0xf5c0c009,0xfb620007,0xf9283009}},	//   好又, 散装, 本篇, 罪嫌
  { {0xf5a4e004,0xfa771008,0xf935e004,0xfa83b005}},	//   合能, 費支, 高利, 中深
  { {0xf8148005,0xfb81800c,0x00000003,0x00000003}},	//   真三, 載率,   ,
  { {0xfb7e8004,0xf93e8001,0xfb770008,0x00000003}},	//   分立, 胃口, 語科,
  { {0xf4909007,0xf9121001,0xf4c75004,0xfb694001}},	//   山高, 異味, 行部, 質生
  { {0xf5976009,0xf933400c,0xf927b002,0x00000003}},	//   喜迎, 定停, 木器,
  { {0xf9302001,0x00000003,0x00000003,0x00000003}},	//   委外,   ,   ,
  { {0xf935e006,0xfa4d7004,0xfa695004,0xfb6cc001}},	// [300] 多年, 化氛, 茶文, 袖珍
  { {0xfa629001,0xf9109004,0xf49e700a,0xfa73d005}},	//   杉林, 泰得, 次項, 西柳
  { {0xf920b00f,0xf80dc00f,0x00000003,0x00000003}},	//   索引, 店住,   ,
  { {0xf5ad8006,0xfb552005,0xf91b5005,0xf81d6005}},	//   仲裁, 份特, 大先, 者下
  { {0xf9207007,0xf946c001,0xf924d004,0xf927b00c}},	//   正品, 下場, 置土, 含各
  { {0xfa62d00f,0xf4a3b007,0xf9181009,0xfa5db005}},	//   效果, 差額, 示器, 持水
  { {0xf925f007,0xfa4f1001,0xfb86e005,0xfb80e00c}},	//   復原, 底有, 殊群, 泉美
  { {0xf934a006,0xf934c00f,0xf9430007,0xf9442007}},	//   做大, 通工, 崇德, 融合
  { {0xf827400f,0xf91cf007,0xf83c3001,0xfb6c2005}},	//   服人, 加倍, 接任, 向着
  { {0xf8365006,0xf9470004,0xf9454004,0xfb7e8008}},	//   缺乏, 不履, 先地, 分程
  { {0xf9195006,0xf5a44001,0xf90ab005,0xf937600c}},	//   吸引, 見聞, 件差, 依土
  { {0xfb73600f,0xf5b0a004,0xfa575005,0xf92c700c}},	//   站的, 新跨, 保果, 習平
  { {0xf92e9007,0xfa805008,0xf8439004,0xfa681001}},	//   科別, 員採, 目不, 積水
  { {0xf4b9f00f,0xf80ce00e,0xf9410010,0x00000003}},	//   品配, 間以, 者制,
  { {0xf5a5800f,0xfb69a009,0xfb5e8004,0xfb66a008}},	//   守護, 排的, 亡率, 目白
  { {0xf93c4006,0xf9326004,0xf935600c,0xfa5c3005}},	//   的同, 定小, 定值, 的恋
  { {0xfa61f004,0xf827e00a,0xf913900a,0xfa6b5005}},	// [310] 理新, 慎一, 社在, 究性
  { {0xf810800f,0xfb74a004,0xf5c56001,0xfa653005}},	//   投保, 多管, 義者, 合数
  { {0xf819e009,0xf5a28001,0xfa753005,0x00000003}},	//   一会, 安街, 湾海,
  { {0xf90e5004,0xfb50c004,0xf58d4005,0x00000003}},	//   即免, 沿着, 化覆,
  { {0xfb6be00f,0xf9131009,0xf92fb004,0xf946a005}},	//   我看, 都必, 法参, 每名
  { {0xf8443009,0xfb7a4004,0xfa5c100a,0xf58f400c}},	//   京人, 作特, 心拍, 志航
  { {0xf913f001,0xf93d6004,0xf937000c,0x00000003}},	//   政即, 要延, 生因,
  { {0xf5a48004,0xf81c8004,0xf919f00c,0xf915b00c}},	//   下角, 要交, 券可, 移居
  { {0xf914300e,0xf91b500c,0x00000003,0x00000003}},	//   精度, 給分,   ,
  { {0xfb58c007,0xfb5dc009,0xf91b100c,0xfa665005}},	//   人照, 学社, 工快, 式拉
  { {0xf91b1006,0xf8487009,0xf497f001,0xf8214004}},	//   日志, 在交, 出風, 理以
  { {0xf9211004,0xf4c7100c,0xf828600a,0x00000003}},	//   本合, 富達, 猶予,
  { {0xfb71600f,0xf9408009,0xf924d009,0xf83a9004}},	//   法第, 了在, 是公, 群中
  { {0xfa7ed009,0xf949a005,0xfa65300d,0x00000003}},	//   院有, 住国, 富案,
  { {0xfa4cb004,0xf93d6005,0xf49bb00a,0xf4c3d00c}},	//   柑橘, 居城, 来院, 秋香
  { {0xfb528009,0xfa725009,0xf499b009,0xf828e001}},	//   国美, 板栗, 缺陷, 其一
  { {0xf5976006,0xfa67f001,0xf82fe00c,0xfb62c00c}},	// [320] 凝聚, 像我, 到九, 面破
  { {0xf5928005,0xf8220005,0x00000003,0x00000003}},	//   多老, 雇佣,   ,
  { {0xfb5c2009,0xf91a9001,0xf822c005,0xf838d00d}},	//   大病, 查察, 月会, 示交
  { {0xfb758008,0x00000003,0x00000003,0x00000003}},	//   通称,   ,   ,
  { {0xf93e200f,0xf91b7009,0xf93e0007,0xf4ad3004}},	//   者均, 以公, 者必, 村金
  { {0xf91d7006,0xfa607001,0xfb74c001,0xfb4b6005}},	//   大全, 升教, 生美, 件移
  { {0xf91d5004,0xf4ba1001,0xfa81700c,0x00000003}},	//   忠市, 送過, 管收,
  { {0xfa729006,0xf93a6009,0xfb67a008,0xfa7b1005}},	//   施意, 要包, 器用, 判死
  { {0xf5c08007,0xf9438008,0x00000003,0x00000003}},	//   業規, 秋元,   ,
  { {0xfa699009,0xfa5bd007,0xf5b86007,0xf49df001}},	//   低温, 所沿, 示設, 員額
  { {0xfb59200f,0xf80c6006,0xfa4f9004,0xfb60a001}},	//   出現, 当代, 志是, 業禁
  { {0xf490500f,0xfb6c000c,0xf945c010,0x00000003}},	//   平面, 打火, 上委,
  { {0xf945e008,0xfb52c00a,0xfa81b00d,0x00000003}},	//   個入, 話相, 中打,
  { {0xf9283007,0xfb4da001,0xf8463008,0xf835d005}},	//   叫做, 已的, 用促, 任丘
  { {0xf9233006,0xf845b006,0xf9213009,0xfa71d004}},	//   本周, 目中, 本届, 山港
  { {0xfa6b700f,0xfa77b00b,0xfa82f004,0xfb686004}},	//   水果, 相手, 口日, 票管
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	// [330]   ,   ,   ,
  { {0xf82a0001,0xf59b8004,0xf9153004,0xfa7e9002}},	//   具一, 市老, 格外, 砧板
  { {0xfa59d001,0xf8248001,0xfa559004,0xfb740005}},	//   征服, 益促, 通海, 力空
  { {0xfa7af004,0xf91ab00c,0xf947e00d,0x00000003}},	//   来投, 司基, 免地,
  { {0xf911900f,0xfa87f004,0xfa85d001,0xf83f300d}},	//   申報, 全本, 用服, 院住
  { {0xf5ab000c,0x00000003,0x00000003,0x00000003}},	//   礎課,   ,   ,
  { {0xf9231011,0xf9127004,0xf4927004,0xf8224004}},	//   催化, 新兵, 施配, 案一
  { {0xf945e00b,0xf5a38001,0xf81c2004,0xfa78300c}},	//   納得, 型要, 市会, 盤手
  { {0xf8226006,0xf9354007,0xf92fb004,0xfa641001}},	//   万人, 非合, 南天, 益服
  { {0xfa60900c,0xf90c100c,0xf90f700c,0xfb7dc00a}},	//   充槽, 制台, 新分, 時系
  { {0xfb6d6004,0xfb7dc008,0xf9109004,0x00000003}},	//   得益, 療系, 色地,
  { {0xfa69700f,0xfb6ee001,0xfb4c600c,0x00000003}},	//   式書, 協約, 念真,
  { {0xfb698005,0xfa67f002,0x00000003,0x00000003}},	//   在直, 不敵,   ,
  { {0xf90f5001,0xf90a1004,0xf9213008,0xf946800c}},	//   到心, 刷品, 本尊, 開山
  { {0xf499d004,0xfb488001,0xf943e004,0xfa583004}},	//   以附, 家等, 很差, 速混
  { {0xf5ac200f,0xf9285001,0xf93d6004,0x00000003}},	//   水質, 早報, 私家,
  { {0xfa5f1009,0xfb58e004,0xfa5c7004,0xf922f004}},	// [340] 千方, 区空, 威性, 屯市
  { {0xf9177006,0xfb888006,0xf9231004,0xf9197004}},	//   方各, 行社, 口出, 查同
  { {0xf90cd00b,0xf494500e,0xfa653009,0xfa739004}},	//   進呈, 函館, 合新, 好民
  { {0xfa701009,0xfb4fc00e,0xfa811004,0xf825600c}},	//   新成, 花粉, 既是, 誌上
  { {0xf4b39007,0xf947c00c,0x00000003,0x00000003}},	//   望遠, 敏原,   ,
  { {0xf9279001,0xf9199005,0xf4b0100c,0xfb66e005}},	//   部帖, 出声, 受難, 用真
  { {0xfa669001,0xf82b4004,0xfa659004,0xf910900c}},	//   下海, 海世, 行明, 地優
  { {0xf9376001,0xf9243005,0xf9267005,0xf4c1100c}},	//   機出, 京医, 部包, 集邦
  { {0xf5b0c006,0xf9279008,0xf9325001,0xf92e7002}},	//   西藏, 貨店, 際域, 子到
  { {0xf93a800f,0xfb58e004,0xfa6e7001,0xfb74e010}},	//   品分, 基点, 女時, 会系
  { {0xf8266007,0xfb848005,0xf9480002,0x00000003}},	//   屋仲, 上突, 而入,
  { {0xf921d009,0xfb870001,0xf4bdf008,0xfb6ce005}},	//   公元, 位系, 境部, 易系
  { {0xf913b001,0xfa4bb005,0xf8248005,0xf93f2005}},	//   嘿嘿, 休手, 合以, 理密
  { {0xfa86700f,0xf81dc009,0xfa6d7001,0xf9149001}},	//   皮書, 内一, 水漾, 諾基
  { {0xfb82a004,0xfb55c004,0xf9209005,0x00000003}},	//   切相, 幻片, 股吧,
  { {0xf59d2009,0xfa7f3004,0xfb6b2001,0xf930d005}},	//   繁育, 悠悠, 雪白, 志平
  { {0xf927b009,0xf92c7004,0xf9135001,0xf91b500a}},	// [350] 在在, 向各, 由報, 永山
  { {0xf4c65005,0xf816000c,0x00000003,0x00000003}},	//   再部, 增一,   ,
  { {0xf8401004,0xf5a36004,0xf93de001,0xfb846004}},	//   口上, 有股, 考取, 越秀
  { {0xf9309008,0xf48a7008,0xf9127005,0xf945a00a}},	//   法少, 貴重, 声声, 洋古
  { {0xf9101008,0xfa7dd001,0xf916b004,0xf840d005}},	//   宰府, 校歌, 竹安, 中俄
  { {0xf9434009,0xf915b005,0xfa67700c,0x00000003}},	//   万年, 系密, 行普,
  { {0xf5904001,0xf9143004,0xf824a00c,0xfb668002}},	//   受試, 都取, 額一, 骨的
  { {0xf9143001,0xf9233001,0xfb4b600c,0xf58f8005}},	//   能取, 良心, 件登, 挑起
  { {0xfa67b006,0xfb504007,0xf9380001,0xf83af005}},	//   上海, 深的, 生危, 敦促
  { {0xfb61a001,0xf90b3004,0xf9165004,0xfa89300a}},	//   業結, 海北, 空前, 八潮
  { {0xf92e300c,0xfb86c00c,0x00000003,0x00000003}},	//   且又, 及煤,   ,
  { {0xfa869004,0xf9269001,0xfa677004,0xf5a3000c}},	//   器托, 種出, 脊柱, 洋行
  { {0xfa72f001,0xf80ca004,0xf49d900c,0xf93c800a}},	//   共政, 首例, 你集, 退場
  { {0xf4a09005,0xfa4e700c,0x00000003,0x00000003}},	//   中需, 取捨,   ,
  { {0xf9125004,0xf9376005,0xfb81a005,0xf910b005}},	//   西太, 作同, 密相, 阿富
  { {0xfa4a9009,0x00000003,0x00000003,0x00000003}},	//   材有,   ,   ,
  { {0xfb82c00f,0xfb660004,0xf594800c,0xf59b0005}},	// [360] 築物, 早熟, 付者, 求越
  { {0xf91e1007,0xfa81f001,0xfa881004,0xf590200c}},	//   加州, 口湖, 被曝, 挖起
  { {0xfa4f5009,0xf93ec004,0xf9259004,0xf5c58004}},	//   化活, 各学, 在合, 路西
  { {0xfb51e007,0xfb640004,0xf492b001,0xf928d00c}},	//   山第, 中直, 花鳥, 親居
  { {0xf945e006,0xf4bfb001,0xf5a96001,0x00000003}},	//   程建, 久遠, 小腹,
  { {0xf90ad007,0xfa757001,0xf92e7008,0xf5b04005}},	//   家可, 施放, 準優, 想路
  { {0xf48b1006,0xf93e4006,0xfa4f7004,0xf4a6b004}},	//   更高, 的差, 化方, 用通
  { {0xfa5ed006,0xf92f7012,0xf92b3004,0xfb512005}},	//   病毒, 化出, 体土, 新章
  { {0xfa87b00e,0xf8256004,0xf92e7008,0x00000003}},	//   利活, 晋中, 視化,
  { {0xf825c006,0xf9259007,0xf9189001,0xfb4b2005}},	//   行一, 可出, 出巡, 段等
  { {0xf90b3006,0xf9287002,0x00000003,0x00000003}},	//   海南, 物到,   ,
  { {0xfb7ea005,0xf826800c,0xfb72e00d,0x00000003}},	//   商税, 手乳, 会留,
  { {0xf9163004,0xfa67d004,0xf5bda004,0xf595e001}},	//   区名, 名新, 大良, 紙製
  { {0xfa56d004,0xf8356008,0x00000003,0x00000003}},	//   川旅, 系企,   ,
  { {0xf59f0007,0xf59c4009,0xf833c007,0xf934d001}},	//   了要, 各行, 格一, 娘娘
  { {0xf90e900f,0xfb83a006,0xfb562007,0xfa771005}},	//   侵害, 程的, 出納, 方意
  { {0xf5a38009,0xf5b58004,0xf59d6004,0xf48d7002}},	// [370] 事考, 任考, 病菌, 已送
  { {0xfb7e2006,0xf9143009,0xfa665009,0xf908b00c}},	//   的用, 好全, 降温, 件完
  { {0xfb86000f,0xf936b001,0xfb4a8004,0xfa65700c}},	//   刊物, 回原, 家火, 洋污
  { {0xf9460007,0xf9129004,0xf8453004,0xf9131005}},	//   名店, 白城, 路以, 施分
  { {0xfb706009,0xf942c00c,0xfa88d005,0xfa745005}},	//   法生, 事合, 用款, 追溯
  { {0xf9259004,0xf4c3f001,0xf929f004,0xf91bf001}},	//   在哈, 手震, 未在, 此地
  { {0xf8272008,0xf83e3004,0xfa5b1001,0x00000003}},	//   名以, 大交, 菜水,
  { {0xf9223009,0xf4c45008,0xf9325004,0xfa56b008}},	//   中在, 上階, 定前, 生息
  { {0xfa509006,0xf91d1009,0xfb5a6008,0xfa6cd001}},	//   北方, 入家, 度版, 色消
  { {0xf8234006,0xf93dc008,0xfb86200c,0xf930900c}},	//   文件, 脅威, 二篇, 北出
  { {0xf5ba4001,0xf935d008,0xf592c005,0xf944600c}},	//   入識, 通年, 会超, 合勤
  { {0xfa7f9001,0xf4c77001,0xf4b1b004,0xf83a5005}},	//   夢時, 車音, 辛集, 来会
  { {0xf90d3004,0xfb846001,0x00000003,0x00000003}},	//   史名, 才看,   ,
  { {0xfa65b009,0xf5b9c009,0xfa56900e,0xf918100c}},	//   上投, 知要, 高性, 示周
  { {0xfa86b001,0xfa5f100a,0xf496f005,0x00000003}},	//   雨揚, 境政, 方配,
  { {0xf4c0900c,0xfa61700d,0x00000003,0x00000003}},	//   順風, 誉情,   ,
  { {0xf93d2004,0xf934700c,0xf931700c,0xf9331005}},	// [380] 求售, 力值, 力小, 望全
  { {0xfa60900f,0xf8254001,0x00000003,0x00000003}},	//   切換, 而下,   ,
  { {0xf8270006,0xf831a004,0xfb4e2004,0xfb4a600c}},	//   上人, 寿保, 牲畜, 奶糖
  { {0xfb722009,0xf59b400c,0xfa725005,0xf5ab600a}},	//   定程, 一解, 地海, 美貴
  { {0xfb526005,0xf593e00a,0xf935d005,0xfa63d00d}},	//   国界, 際費, 高士, 程指
  { {0xf947e00e,0xfa585009,0xf5a64008,0xf48d900c}},	//   和室, 州日, 小計, 場都
  { {0xf934f006,0xf90f1009,0xf91af004,0xf93d4004}},	//   食品, 台式, 津南, 的凝
  { {0xf9263008,0xf90b3001,0xfb6d000c,0x00000003}},	//   利回, 起受, 金瓜,
  { {0xfb7b8001,0xfa7a1001,0xfa77b00c,0x00000003}},	//   市私, 盤挫, 陸橋,
  { {0xf845f006,0xf90d100e,0xf80c2004,0xfa61b00c}},	//   物保, 液型, 村住, 片森
  { {0xfb74800f,0xf82e4001,0x00000003,0x00000003}},	//   通管, 害低,   ,
  { {0xfb4ce007,0xf9185008,0xf841d001,0x00000003}},	//   場無, 固形, 面人,
  { {0xfa54d006,0xfa5bf005,0x00000003,0x00000003}},	//   生意, 局派,   ,
  { {0xf4a0900f,0xf946c005,0x00000003,0x00000003}},	//   業銀, 下年,   ,
  { {0xf9165009,0xfa859009,0xf4a9900e,0xf5972001}},	//   区小, 器有, 太鼓, 真象
  { {0xfb83c00f,0xfa6bd004,0xf82fc00c,0xfa5bf00c}},	//   友的, 起正, 失事, 所施
  { {0xf821c004,0xf4aff008,0xf9229001,0xf934d001}},	// [390] 三会, 化防, 可安, 記官
  { {0xf940e001,0xfb50c004,0xfa781001,0xf837e005}},	//   商加, 数目, 旺斯, 常事
  { {0xf9345009,0xfb7b8007,0xfa89300a,0x00000003}},	//   会公, 言給, 推敲,
  { {0xfb692006,0xf9466009,0xf92b7007,0xf934f009}},	//   部署, 位公, 自已, 高尚
  { {0xf59e8006,0xf58ee007,0xf92c5004,0xfa635001}},	//   理行, 金貸, 易公, 洋流
  { {0xf5af8007,0xf9213007,0xf830400c,0xfa61900c}},	//   山脈, 本刊, 共一, 切注
  { {0xfb808001,0xfa613002,0x00000003,0x00000003}},	//   載版, 光技,   ,
  { {0xf5c72001,0xf923300c,0x00000003,0x00000003}},	//   種花, 設基,   ,
  { {0xf58be001,0xf91e3004,0xf8396004,0xfa865005}},	//   卓著, 学地, 裸体, 可溶
  { {0xfa6f7001,0xf5a6c008,0x00000003,0x00000003}},	//   想我, 益費,   ,
  { {0xf4a2900b,0xfb6d200a,0xf5b52005,0xfb54600c}},	//   本金, 子短, 尼迪, 現空
  { {0xf9367006,0xfb7b8007,0xf81ca004,0xf5aa2001}},	//   也在, 需知, 品主, 強者
  { {0xfb89a009,0x00000003,0x00000003,0x00000003}},	//   小白,   ,   ,
  { {0xfb84a009,0xf9125001,0xfb868005,0xf814c00d}},	//   及的, 到台, 每立, 域不
  { {0xfb80a004,0xf941c00c,0xf90fb005,0xf926b00c}},	//   商独, 商平, 地力, 種常
  { {0xf947e006,0xfa82900a,0xf91ed005,0x00000003}},	//   上年, 中枢, 面很,
  { {0xf8130009,0xf917f008,0xf92d9004,0xfa5af004}},	// [3a0] 通会, 主幹, 北安, 局是
  { {0xfa86f007,0xfb84c004,0xfb4f2004,0xfa781004}},	//   快手, 之策, 米生, 除按
  { {0xf82ee001,0xfa867004,0xfa57500c,0x00000003}},	//   想了, 目核, 作態,
  { {0xf944e006,0xf940e006,0xf81ac009,0xf595e008}},	//   上升, 内地, 品供, 熟語
  { {0xfb644008,0xf91d300c,0xf92eb00d,0x00000003}},	//   央病, 因市, 得借,
  { {0xfb5c4009,0x00000003,0x00000003,0x00000003}},	//   性病,   ,   ,
  { {0xfb766009,0xf494d007,0xfa7b1005,0xf90d700d}},	//   保税, 偽造, 弥漫, 晴好
  { {0xf599c00f,0xf92e7007,0xf4c77004,0x00000003}},	//   流行, 向左, 藏高,
  { {0xf9153004,0xfa705004,0xf93f6004,0xf9460005}},	//   值在, 地投, 的函, 名志
  { {0xf92af001,0xf4aef001,0xf829c004,0xfb88800c}},	//   園周, 柔順, 虎中, 小種
  { {0xf5a5800f,0xfa54b007,0xfb72e004,0xfb7ba004}},	//   看解, 生植, 井然, 市燃
  { {0xf9237004,0xf825c001,0xf4b4300a,0xfb55200a}},	//   般可, 見交, 葛飾, 電界
  { {0xfb7ae007,0xf91d7004,0xf5c32005,0xf9141002}},	//   果然, 大在, 是考, 都委
  { {0xf9454009,0xf831a009,0xf91a7009,0xf9133001}},	//   二届, 地人, 特困, 山山
  { {0xf4bff004,0xf90d1001,0xf93ee004,0xf91ad004}},	//   了金, 場大, 市巴, 斤左
  { {0xfa5c9004,0xfa87d004,0xfa615004,0x00000003}},	//   品来, 旨是, 率比,
  { {0xf5b7c004,0xf947e004,0xf9426005,0xf847f005}},	// [3b0] 刻苦, 行卡, 三岔, 身会
  { {0xfa547009,0xf9211004,0xfa50700d,0x00000003}},	//   功案, 代初, 隔断,
  { {0xf933f00f,0xf4bf3007,0xfa71f004,0xfa879005}},	//   記型, 集集, 由是, 助性
  { {0xfa4d5004,0xfb63e001,0xfa77d00c,0xfb54a00c}},	//   取教, 業競, 人林, 鬼神
  { {0xf5a36004,0xf4bff001,0xf5a78001,0xf90ff005}},	//   事要, 均需, 量記, 女在
  { {0xf8160009,0xfb754005,0x00000003,0x00000003}},	//   属企, 期病,   ,
  { {0xf946e006,0xfa6a7009,0xfa77b001,0xf92c700c}},	//   同志, 号文, 人法, 向善
  { {0xfa4cd006,0xf490b007,0xf5b5c001,0x00000003}},	//   排水, 到部, 登者,
  { {0xfb66a006,0xf8210009,0xf9369004,0xf4b6d004}},	//   彩票, 商信, 期全, 非金
  { {0xf9231004,0xfa5db004,0xf4af300c,0x00000003}},	//   口基, 市浦, 北青,
  { {0xfa799007,0xf9444004,0xfa701004,0x00000003}},	//   司或, 合学, 新提,
  { {0xf926d001,0xfb50e004,0xf4bd5001,0xf9105005}},	//   夫先, 山生, 超額, 新引
  { {0xf832c004,0xfa507004,0xf5a4000c,0xf814400a}},	//   使中, 孕期, 手肘, 換便
  { {0xfb66e009,0xf92db001,0x00000003,0x00000003}},	//   用生, 打到,   ,
  { {0xf949c006,0xf91b5004,0xf9293004,0xf80d0004}},	//   小平, 大合, 用就, 道人
  { {0xf81cc004,0xf9440004,0xf948e004,0xf816e005}},	//   的七, 立多, 行地, 域中
  { {0xfb794006,0xf92fd009,0xf827c001,0xfa4a700c}},	// [3c0] 作用, 他国, 後代, 間流
  { {0xf5b88001,0xf93d8004,0xf4bfd00c,0xf80ea00c}},	//   人董, 宅小, 的陷, 結伴
  { {0xf93a7006,0xf82f800e,0xfb64c004,0xfa62d001}},	//   要内, 甲信, 利等, 守望
  { {0xf81ee004,0xf8350004,0xf4c67004,0xf948e002}},	//   商企, 好交, 把那, 塌地
  { {0xfb882007,0xf943c00e,0xfa65b004,0xf91ef004}},	//   後登, 計士, 程控, 面告
  { {0xfa5d3006,0xfa4e7009,0xfa59f008,0xfa773001}},	//   求是, 受教, 九段, 出機
  { {0xf5a1c007,0xf8252004,0x00000003,0x00000003}},	//   合行, 上会,   ,
  { {0xfb7fa001,0xfb75400c,0xf59fe00c,0x00000003}},	//   各由, 原的, 者蔡,
  { {0xf8254006,0xf926900d,0x00000003,0x00000003}},	//   不会, 在写,   ,
  { {0xfb58e001,0xfa623004,0xf5b1e008,0xf4b6f001}},	//   人系, 光村, 己責, 機連
  { {0xf92c9005,0xfa6c7005,0xf9187005,0x00000003}},	//   向分, 水景, 除城,
  { {0xf8427006,0xf8314004,0xfb806005,0xfa739005}},	//   第九, 即便, 担相, 放是
  { {0xfa6a700f,0xfa7db00e,0xf821a007,0xf928f007}},	//   明書, 加減, 月三, 親切
  { {0xf5c9e00b,0xf9418009,0xf9428009,0xf938b00c}},	//   自身, 均在, 奉化, 保加
  { {0xfa687009,0xf9195001,0xf59d600c,0x00000003}},	//   税指, 人命, 省議,
  { {0xf9109001,0xf83ff004,0x00000003,0x00000003}},	//   地坪, 面会,   ,
  { {0xfb81200c,0xf92f5005,0x00000003,0x00000003}},	// [3d0] 三禁, 金已,   ,
  { {0xf4a7b00e,0xfa753004,0xf9381001,0xfa523001}},	//   風邪, 治意, 生共, 講機
  { {0xf9305007,0xfb700007,0xf93ea004,0xfa4e7004}},	//   且全, 底片, 但同, 南沙
  { {0xf948c007,0xf5990004,0xf937b008,0xfb7a2005}},	//   小客, 州花, 硝子, 潜移
  { {0xf93a3009,0xfa53f00c,0x00000003,0x00000003}},	//   封市, 定未,   ,
  { {0xf833000f,0xf59c4008,0xf5bfc001,0xf912b002}},	//   替代, 一色, 形者, 深吸
  { {0xf4a8f007,0xf5ab2001,0xfa809001,0xf926d001}},	//   部都, 念車, 管治, 編定
  { {0xf4911006,0xf4c83004,0xfb6e2001,0xf4b05005}},	//   地面, 每隔, 窗的, 梗阻
  { {0xf93de00f,0xf9127005,0x00000003,0x00000003}},	//   超商, 西在,   ,
  { {0xf9297006,0xf4acd00e,0xfa80d004,0xf93fe004}},	//   表彰, 子部, 口情, 文局
  { {0xfb87e006,0xf5a5c009,0xfb56e009,0xf9399004}},	//   仍然, 二要, 任用, 保平
  { {0xfa4e1004,0x00000003,0x00000003,0x00000003}},	//   子汽,   ,   ,
  { {0xf9363004,0xf91d9008,0xf8236005,0xf9277005}},	//   九届, 性器, 型住, 被封
  { {0xf90d9006,0xf815800f,0xfb4ac004,0xf8230008}},	//   年国, 期付, 海科, 載中
  { {0xf9233006,0xfa857007,0xf91a7007,0xfb6f6004}},	//   口岸, 可接, 特地, 外知
  { {0xf92f7009,0xfb62e004,0xf919500c,0xfb4f8005}},	//   化基, 代特, 以和, 地率
  { {0xf5c5a00e,0xf93c7009,0xfa66100c,0xf4a85005}},	// [3e0] 用車, 要大, 今早, 火速
  { {0xf81b0009,0xf9267009,0xfb78a008,0xf8332001}},	//   市三, 部内, 所等, 能了
  { {0xfa55f006,0xfb80a00f,0xfa677009,0xf80bc007}},	//   生成, 等等, 前沿, 科介
  { {0xf826e006,0xf948c004,0xf4bfd001,0xfb872005}},	//   小企, 同德, 的雷, 位特
  { {0xfa533006,0xf946e009,0xf917f008,0xf911f005}},	//   四是, 名学, 主役, 使当
  { {0xf914300f,0xf58e6006,0xfb75c007,0xf90eb005}},	//   拿到, 提起, 食神, 地告
  { {0xf92e700b,0xf5b08007,0xf9414001,0x00000003}},	//   科大, 異質, 棉布,
  { {0xfa5fb00e,0xfb590005,0x00000003,0x00000003}},	//   妄想, 空缺,   ,
  { {0xf947000b,0xfb7ec004,0xf92df008,0xf49cd004}},	//   名古, 千瓦, 南小, 大邑
  { {0xf915b009,0xfa7e9007,0xf9257001,0xfa6cf005}},	//   国女, 管教, 端出, 起数
  { {0xf4a51001,0xf93e7004,0xfa87d004,0xf91c900a}},	//   可連, 求平, 物油, 左利
  { {0xf93bd006,0xf5c6a001,0xfa7cb008,0xf9375001}},	//   十八, 全記, 奥深, 州南
  { {0xf92db006,0xf594e006,0xfa6dd006,0xf489b004}},	//   提出, 也要, 史文, 海量
  { {0xfb81e00b,0xf5a86007,0xf4b57001,0xf498300c}},	//   理由, 行貸, 生高, 幹道
  { {0xf945c00f,0xf845b005,0xf912500c,0xfb500002}},	//   越南, 在事, 政志, 到神
  { {0xf9239004,0xf937f004,0xf9211005,0xf5c44005}},	//   正地, 生女, 中写, 修装
  { {0xf5c30006,0xf834c009,0xf91b3001,0xfa4c3004}},	// [3f0] 是要, 国代, 入外, 金所
  { {0xf9309001,0xf4c27008,0xf82fc005,0xfa71900c}},	//   北基, 安達, 地会, 東林
  { {0xf947c006,0xfa63d004,0xfa4bf008,0xf9289001}},	//   同学, 半月, 成機, 部入
  { {0xfb732007,0xfa845007,0xfb6ce004,0xf5948008}},	//   四種, 種情, 民盟, 減衰
  { {0xfa73b004,0xf4c91001,0xf49cf005,0x00000003}},	//   施提, 歌陶, 春雷,
  { {0xf91f7007,0xf9163004,0xf4a71004,0xfa863001}},	//   客問, 区前, 在黑, 天打
  { {0xf91c5007,0xf924f004,0xfa4f100c,0xfb50e005}},	//   接出, 公家, 底按, 音画
  { {0xfb620001,0xf8362001,0xfa5d7005,0xfa59d005}},	//   業策, 示事, 如既, 所思
  { {0xfa783004,0xf9143004,0xf92d300c,0xf926d00c}},	//   出本, 好在, 我回, 縫合
  { {0xf93db006,0xfb630007,0xf4acd007,0xf48a5001}},	//   老年, 業知, 視野, 德高
  { {0xf9287001,0xfb4d2004,0xf93ab004,0xf9460008}},	//   全座, 年翻, 最全, 王寺
  { {0xf833200f,0xf5bee006,0xfa841008,0xf4a6d00a}},	//   政信, 造良, 設整, 物部
  { {0xf5a82007,0xfa669001,0x00000003,0x00000003}},	//   明者, 歌機,   ,
  { {0xfa735009,0xf93c5007,0xf92e3004,0xfa6a100c}},	//   便携, 裁員, 唐山, 噴泉
  { {0xf5a54006,0xf5a30007,0xfa5c7004,0xf8429005}},	//   同行, 談話, 的漏, 公休
  { {0xf81f0009,0xf9287009,0xfa7c3001,0xf819c005}},	//   考人, 部大, 度法, 作代

  { {0xf9119005,0x00000003,0x00000003,0x00000003}},	// [400] 地去,   ,   ,
  { {0xf82ee00c,0xf4ac700c,0x00000003,0x00000003}},	//   到二, 滑順,   ,
  { {0xfb60e004,0xfa66900c,0x00000003,0x00000003}},	//   播的, 行感,   ,
  { {0xf4afd00f,0xf4af7001,0xf90bf004,0xf5c1600c}},	//   店面, 字部, 零就, 業補
  { {0xfb862001,0xf5b06008,0xfb732005,0xf91af00a}},	//   籍編, 進課, 力物, 日動
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa4f7007,0x00000003,0x00000003,0x00000003}},	//   取方,   ,   ,
  { {0xf8404006,0xf92f7007,0xf921b001,0xf9331005}},	//   中介, 取出, 解委, 望在
  { {0xf4a19004,0xf8473004,0xf92a5001,0xfa6f9005}},	//   中金, 用互, 迫害, 台文
  { {0xf9347009,0xfb762004,0xf819c001,0xf81c200c}},	//   四平, 宝玉, 要下, 時作
  { {0xfb7ca00b,0xf8276004,0xfb5c2005,0xf9121005}},	//   省略, 意了, 健知, 好合
  { {0xfa733005,0xf943600a,0x00000003,0x00000003}},	//   松林, 開局,   ,
  { {0xfa6cb008,0xf5bf0008,0xf8479005,0xf58b400c}},	//   冷房, 造設, 在享, 術賞
  { {0xf4903004,0xf4c13005,0x00000003,0x00000003}},	//   地道, 有退,   ,
  { {0xf58e4001,0xf93f9004,0xf58d4001,0xfa5ef004}},	//   化街, 境地, 準者, 者投
  { {0xfb83a006,0xf926b009,0xf8102008,0xf93e100c}},	//   立的, 在四, 街並, 千八
  { {0xf9133005,0xfa60d005,0xf945c005,0xf92c300c}},	// [410] 就失, 胆探, 越受, 近市
  { {0xf4c4b005,0x00000003,0x00000003,0x00000003}},	//   益集,   ,   ,
  { {0xf918500b,0xfb580009,0xfa5e1009,0xf5b2600a}},	//   人公, 区物, 心是, 東財
  { {0xf8204004,0xf93db004,0xfa70100c,0xf822c005}},	//   者人, 装品, 報所, 指使
  { {0xfa6c7006,0xfa67f004,0xf5c6a005,0x00000003}},	//   直播, 菌性, 利街,
  { {0xf92c7004,0xf8362001,0xfa52100c,0xf946c00d}},	//   外先, 示下, 力招, 行唐
  { {0xf92fd00f,0xfa6cb008,0xf930b005,0xf4af7005}},	//   他命, 護施, 北岸, 南首
  { {0xf5ac8009,0xf5be0005,0xfa6b1005,0xf4bc700c}},	//   海西, 亦菲, 援指, 約配
  { {0xfa825001,0xf8268005,0x00000003,0x00000003}},	//   蔬果, 伍中,   ,
  { {0xf849700b,0xf8134009,0xf5a06001,0xf592e004}},	//   自体, 会作, 分身, 料行
  { {0xf4c8f007,0xf93d7002,0x00000003,0x00000003}},	//   明道, 禁制,   ,
  { {0xf8256001,0xfa5cd004,0xfa685004,0x00000003}},	//   位作, 持改, 架有,
  { {0xf5a70009,0xf9279004,0xfa72b004,0x00000003}},	//   富裕, 在努, 能最,
  { {0xfa675004,0xf937700c,0xf815c005,0x00000003}},	//   界杯, 依原, 非住,
  { {0xf4b0f00e,0xf9317001,0xf592c001,0xfb74a004}},	//   衛隊, 力宏, 力評, 功立
  { {0xf9187006,0xfb86c007,0xfa6cf009,0xf5aa8001}},	//   出口, 意積, 海新, 場融
  { {0xfa69d007,0xf58f6004,0xfb56a008,0xf830c004}},	// [420] 然我, 北街, 容等, 房二
  { {0xf90ef004,0xfa4c5004,0xfb6aa00a,0xfb4fe00a}},	//   台前, 桐梓, 成等, 花王
  { {0xf5b58009,0xfb67c00e,0xfa4b1008,0xf91b3001}},	//   施落, 用目, 子明, 書共
  { {0xf81b2006,0xf940d001,0x00000003,0x00000003}},	//   如下, 梅地,   ,
  { {0xfb4b6007,0xf90eb008,0xf82c4005,0x00000003}},	//   更生, 環型, 起以,
  { {0xfa4cf006,0xfa641004,0xfb84c00c,0xf91eb00c}},	//   成本, 仍按, 型研, 座命
  { {0xf9440009,0xf8394004,0xf90db005,0x00000003}},	//   廊坊, 来三, 直就,
  { {0xf596400a,0x00000003,0x00000003,0x00000003}},	//   備課,   ,   ,
  { {0xf917f007,0xfb57e009,0xfb83a004,0xfb576004}},	//   司名, 麻疹, 嘉祥, 点燃
  { {0xf916d008,0xfa64b001,0xf920100c,0xf8296005}},	//   主優, 名流, 代同, 夏人
  { {0xf5c4a006,0xf5ae2001,0xf82e8008,0xfa5fb005}},	//   差距, 育補, 色体, 善新
  { {0xf9323006,0xf5a18009,0x00000003,0x00000003}},	//   会同, 切身,   ,
  { {0xf9249009,0xf598c001,0xf90ed005,0x00000003}},	//   京国, 所見, 女写,
  { {0xf839c00f,0xfa5db004,0xf4bb500c,0xf813c00a}},	//   入一, 内所, 一造, 傘下
  { {0xfa71d009,0xf93d7008,0xf92c7005,0xf9259005}},	//   就是, 桃子, 取安, 央在
  { {0xfa4e9004,0xf91d9004,0xf91d7004,0xf9197001}},	//   向来, 性在, 性循, 船員
  { {0xf5a8a00f,0xfa639007,0xfa519007,0xfa63d005}},	// [430] 量販, 有此, 法正, 事拘
  { {0xf925b005,0xf941300c,0x00000003,0x00000003}},	//   在半, 者年,   ,
  { {0xf81b0006,0xf816200b,0xf5b7400b,0xf9444007}},	//   十九, 付中, 樹脂, 反光
  { {0xf4b77008,0xfb6bc00c,0xfb75c00c,0xf932500d}},	//   高騰, 我等, 生真, 定免
  { {0xf8404009,0xfa8ad004,0xfa83d008,0xf922500a}},	//   中下, 只接, 本武, 召喚
  { {0xfa5eb004,0xfb860001,0xf58bc005,0x00000003}},	//   情民, 融研, 少而,
  { {0xf59ac007,0xfa707009,0xf91a9004,0xf840a008}},	//   局表, 阿拉, 交公, 頭一
  { {0xf93f5007,0xf5a68004,0xf9431004,0xf4b25008}},	//   心平, 上解, 版回, 線量
  { {0xfa747008,0xf9141005,0xfa7af00c,0x00000003}},	//   製本, 放学, 貸放,
  { {0xf4a8f00b,0xf5a6a004,0xfa4b3004,0x00000003}},	//   快適, 不解, 寒潮,
  { {0xf4c5500f,0xfa885004,0xfb584008,0xf4c7300c}},	//   介面, 八期, 室等, 里部
  { {0xfb6da006,0xf5c7e001,0xf8362005,0xfb84c010}},	//   得税, 質計, 示例, 不燃
  { {0xf90f5001,0xfa783004,0xfb558004,0xf946800c}},	//   到它, 方提, 白白, 開報
  { {0xfa5cd004,0xfa6af004,0x00000003,0x00000003}},	//   持方, 酷暑,   ,
  { {0xf949800f,0xf929700f,0xfa711004,0xf4bc9001}},	//   住宿, 全家, 即改, 市鼓
  { {0xf9369009,0xfb7d2004,0xfb6cc004,0xf9161004}},	//   期在, 品申, 捐物, 格大
  { {0xfa81f004,0xf80f800c,0x00000003,0x00000003}},	// [440] 口或, 繕住,   ,
  { {0xf5c62004,0xfb682008,0xf93a100c,0xf91b7005}},	//   是走, 部監, 停工, 性合
  { {0xf80d0004,0xfa67900c,0xfa5bb00c,0x00000003}},	//   析中, 後搭, 言治,
  { {0xf945a004,0xf9365004,0xfb4b6008,0x00000003}},	//   完小, 州商, 康用,
  { {0xf942f001,0xfb7c6001,0xf594a001,0xfa58b00c}},	//   事半, 嫁給, 生菌, 喜怒
  { {0xf5a3a007,0xfb55e004,0xf912d004,0xf4acb001}},	//   效表, 区玉, 国参, 民通
  { {0xfb7de009,0xfa607007,0xf4afd004,0xfa78f001}},	//   市知, 指教, 五道, 殺死
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb62e007,0xf82d600a,0xf92cf00c,0xf92e300c}},	//   本研, 憲一, 成可, 著各
  { {0xfa64b00f,0xf5990001,0xf90f300c,0xfb87c00c}},	//   看法, 神農, 到十, 名由
  { {0xfa4d1009,0xf922f008,0xf916300c,0xfa81f005}},	//   民提, 支局, 建完, 本框
  { {0xf83b8006,0xf4c49004,0xf9351004,0xf5a5400c}},	//   大事, 嘉陵, 生参, 月議
  { {0xf93e500f,0xf81b8001,0xf5952004,0x00000003}},	//   心客, 係企, 期考,
  { {0xf4a9300b,0xf931500c,0xfb72e005,0x00000003}},	//   推進, 力反, 教界,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf80dc004,0xfb60e001,0x00000003,0x00000003}},	//   南二, 業病,   ,
  { {0xfa711001,0xf826c005,0xf821e010,0x00000003}},	// [450] 音書, 告以, 昇中,
  { {0xf9347004,0xf9494005,0x00000003,0x00000003}},	//   期合, 偏大,   ,
  { {0xf925900e,0xfa515004,0xf9223001,0xfa4f7008}},	//   天候, 投注, 業全, 準決
  { {0xfa82700f,0xf92ff007,0xfb76c001,0xf9259005}},	//   夢想, 街口, 生第, 央周
  { {0xf5a04001,0xfb7f0004,0xfa5e7004,0xf4b59005}},	//   商自, 它相, 的播, 生通
  { {0xfa59b001,0x00000003,0x00000003,0x00000003}},	//   言教,   ,   ,
  { {0xfa761001,0xfb616001,0x00000003,0x00000003}},	//   固服, 無異,   ,
  { {0xf839400e,0xf4a07004,0xf934900c,0xf90cd005}},	//   交付, 六里, 原光, 育先
  { {0xfa64500f,0xf4895009,0xf948e007,0xf9445001}},	//   手機, 件集, 而其, 合度
  { {0xfb51400b,0xfa637008,0xf4af3005,0xf93b9005}},	//   調理, 始時, 受青, 求如
  { {0xf92e1007,0xf4a7b00c,0xf9119002,0x00000003}},	//   我可, 風雪, 害到,
  { {0xf934b00f,0xf91cd004,0xf4981008,0xf81c600c}},	//   原始, 度公, 浸透, 心企
  { {0xfa549005,0xfa715005,0x00000003,0x00000003}},	//   星手, 稿指,   ,
  { {0xfb7c200c,0xfb700002,0xf91b1010,0x00000003}},	//   心碎, 仕留, 工士,
  { {0xf9367007,0xf822e004,0xf92b1004,0xfa709002}},	//   紙張, 下三, 成像, 到未
  { {0xfb71200f,0xf945b00b,0xf915b001,0xfa4d300c}},	//   引用, 前回, 白平, 少棒
  { {0xfa4db007,0xfb51c005,0xf945b002,0x00000003}},	// [460] 材書, 台相, 才回,
  { {0xf9421004,0xf5a16001,0xfb5c0005,0xf5a4c00c}},	//   崇左, 載超, 以登, 車者
  { {0xf58e6009,0xf5b12004,0xf818e00c,0x00000003}},	//   或被, 地解, 技二,
  { {0xf91b5006,0xf938b009,0xfa86700a,0x00000003}},	//   健全, 址及, 置決,
  { {0xf9349004,0xf58e6004,0xf5c06005,0xf48eb00c}},	//   期届, 魔芋, 代要, 平順
  { {0xf4a15006,0xf910b001,0xf5bc8005,0xf939d005}},	//   公里, 河堤, 健脾, 持安
  { {0xf8200009,0xf92d500e,0xf9129005,0x00000003}},	//   分体, 金子, 共大,
  { {0xfa831005,0xf5a66005,0x00000003,0x00000003}},	//   京林, 同舟,   ,
  { {0xf8180004,0xf8244005,0xfa4bb002,0x00000003}},	//   回信, 程也, 黑手,
  { {0xfa729001,0xf4c21004,0xf943500c,0xf83b8005}},	//   放榜, 肉食, 合動, 大下
  { {0xf5c06001,0xf90ed00a,0xfb87c00c,0x00000003}},	//   業認, 哲夫, 族生,
  { {0xfb6f4004,0xfb4fe004,0xf9307001,0xf920700c}},	//   取群, 困生, 託基, 客回
  { {0xfb538008,0xfb676005,0xfa6ad00c,0xf8366005}},	//   現物, 在答, 場概, 建住
  { {0xfb7c8004,0xf93b9004,0xfb838005,0xf82bc00a}},	//   最直, 要取, 予答, 強中
  { {0xf821a006,0xf9231005,0xfa60d00c,0xf90e500d}},	//   授予, 公外, 情深, 柳城
  { {0xfb7a400f,0xf80de001,0xf4c83008,0xf90e5004}},	//   送私, 字一, 界選, 石城
  { {0xf8240004,0xf91b3008,0xfa5f9004,0xfa587001}},	// [470] 上三, 健太, 分枝, 原水
  { {0xf80fe006,0xf5c30001,0xfb59e001,0xf847f005}},	//   南京, 可言, 哥的, 暨中
  { {0xf499500a,0xf9361005,0xf93c9005,0xfb81a00a}},	//   別養, 属市, 澄城, 版等
  { {0xf922b009,0xfb55600e,0xf815e004,0xfa85d00c}},	//   是完, 頻繁, 回企, 物招
  { {0xfa605004,0xf5c32005,0xf945b00c,0x00000003}},	//   包方, 冬虫, 見大,
  { {0xf9255006,0xf9197001,0xf4b4900c,0xfb520002}},	//   路建, 根大, 甘願, 到眼
  { {0xfa801009,0xfa65b004,0x00000003,0x00000003}},	//   凡本, 立性,   ,
  { {0xf90c9006,0xf49bd007,0xf941d001,0xf91f500c}},	//   年公, 接連, 片可, 你加
  { {0xf91d5004,0xf927f004,0xf4bf3004,0xf9289005}},	//   大努, 未及, 逃避, 表座
  { {0xfb804006,0xfb818004,0xf832800a,0xf90ef005}},	//   率的, 有病, 己主, 育全
  { {0xfa4c9001,0xf91e3005,0xf59aa00c,0x00000003}},	//   他手, 信参, 局自,
  { {0xfb51a009,0xf9195004,0xfa885004,0xf48af008}},	//   女父, 以完, 在武, 職金
  { {0xf932700b,0xf926f001,0xf49ef004,0xf90e300c}},	//   婚式, 修女, 校食, 場場
  { {0xfb706004,0xf93af004,0xfb7ce008,0xf9261005}},	//   受群, 市先, 療用, 用局
  { {0xf8396004,0xfa545001,0xf93d5004,0xf9443004}},	//   勤保, 四格, 心向, 泉山
  { {0xfb630006,0xf4c5900f,0xf5a5800e,0xf5926005}},	//   路的, 車道, 請負, 做老
  { {0xfa5dd001,0xf8258005,0xf83fa00d,0x00000003}},	// [480] 情時, 屋信, 素以,
  { {0xfb548008,0xfa78300c,0x00000003,0x00000003}},	//   鬼畜, 室效,   ,
  { {0xf946f009,0xf916f004,0xfb74a00c,0xfa8a3005}},	//   名度, 尼康, 江美, 被抽
  { {0xf934b00f,0xfa88d005,0x00000003,0x00000003}},	//   備取, 漫漫,   ,
  { {0xfa5eb007,0xf913b004,0xf93a3001,0xf8094005}},	//   各校, 国少, 局刑, 互不
  { {0xfb5b0005,0x00000003,0x00000003,0x00000003}},	//   瓦的,   ,   ,
  { {0xfb798006,0xf4997007,0xfa6b7008,0x00000003}},	//   搜索, 日配, 究活,
  { {0xf93ab00a,0x00000003,0x00000003,0x00000003}},	//   一太,   ,   ,
  { {0xf90c9007,0xfa701009,0xfa817008,0xf83c2004}},	//   年冬, 新材, 公明, 学体
  { {0xf9213009,0xf8384005,0x00000003,0x00000003}},	//   象山, 永仁,   ,
  { {0xfa6a900f,0xfa6b9007,0xf943b004,0xf9143005}},	//   水族, 究方, 月全, 格均
  { {0xf92d700e,0xf91e1004,0xfa593013,0x00000003}},	//   外務, 模小, 猝死,
  { {0xfb740004,0xf5b1a001,0xfb72c005,0x00000003}},	//   会用, 由自, 多病,
  { {0xfa873004,0xf9107004,0xfa66b004,0x00000003}},	//   天池, 新北, 行村,
  { {0xf80ec00e,0xfb862004,0xfa7eb004,0x00000003}},	//   北九, 位用, 章或,
  { {0xfb6e6006,0xfb87c00e,0xf5980001,0xf9175004}},	//   受理, 上競, 保自, 区属
  { {0xf837e00b,0xf5950004,0xf92bb005,0x00000003}},	// [490] 主人, 期要, 粒度,
  { {0xf595000c,0xf828200c,0xfb786010,0x00000003}},	//   真要, 而人, 真琴,
  { {0xfb7e2004,0xf9151005,0x00000003,0x00000003}},	//   的票, 款已,   ,
  { {0xf4c6d007,0xf923d005,0xf9389005,0xf90d3002}},	//   軌道, 是土, 最合, 場工
  { {0xfa6fb009,0xfa79900c,0xfb88c00c,0x00000003}},	//   史性, 此江, 量累,
  { {0xfb642009,0xf49f3008,0xf92ed004,0xf92ef005}},	//   差的, 員限, 村容, 得当
  { {0xf81a2001,0x00000003,0x00000003,0x00000003}},	//   所云,   ,   ,
  { {0xf91c1009,0xf915d004,0xf8324004,0xf5a0a008}},	//   学子, 国山, 好事, 理責
  { {0xf90b7006,0xf9221004,0xf499300d,0x00000003}},	//   年初, 中只, 霸道,
  { {0xf4971007,0xfa5c5001,0xfa66d004,0x00000003}},	//   登革, 的才, 量明,
  { {0xf9429006,0xf92f100f,0xfa663007,0xfb826001}},	//   指出, 策宣, 積木, 授的
  { {0xf944d00f,0xfb6ce004,0xf90c7001,0xf82ea00c}},	//   開店, 少生, 起司, 地三
  { {0xf92e700f,0xfa79d001,0xf599a001,0xf921900a}},	//   子地, 懸浮, 所記, 無制
  { {0xf92f3009,0xf840c004,0x00000003,0x00000003}},	//   民就, 六一,   ,
  { {0xfb83c009,0xf5a98009,0xf9107005,0x00000003}},	//   看病, 起行, 新南,
  { {0xfb870001,0xf5966004,0xf910f005,0x00000003}},	//   位移, 功耗, 使市,
  { {0xfb824001,0xfa53300c,0xf946f005,0xfa7eb00c}},	// [4a0] 了然, 四支, 小市, 次招
  { {0xfb7ea00c,0xf90a900c,0x00000003,0x00000003}},	//   商美, 瓷博,   ,
  { {0xf5b6a004,0xf80b0004,0xf5bd2004,0xfb8a8005}},	//   人考, 源不, 苦苦, 低点
  { {0xfa813001,0xf909d005,0xf93ed005,0xf594000c}},	//   波斯, 件原, 善学, 宛芸
  { {0xfb59e001,0xf5c0600c,0xf90eb00c,0xfa893005}},	//   書第, 加起, 念報, 被本
  { {0xfb538009,0xf498b007,0xf5b3400c,0xf93a900d}},	//   国生, 書通, 放自, 甜味
  { {0xf921100f,0xfa845004,0xfa7f9004,0xfb5ac004}},	//   業務, 公房, 加活, 学籍
  { {0xfa4c7004,0xf4adb001,0x00000003,0x00000003}},	//   向旅, 著重,   ,
  { {0xf9445007,0xf8460004,0xfa601004,0xfa5d3005}},	//   等到, 利保, 者撤, 包月
  { {0xfb51e00c,0x00000003,0x00000003,0x00000003}},	//   到精,   ,   ,
  { {0xf9193009,0xf5c28007,0xfb778004,0xf8396004}},	//   人寿, 業設, 域特, 急事
  { {0xfb75c007,0x00000003,0x00000003,0x00000003}},	//   生生,   ,   ,
  { {0xf5a94007,0xfa5f7007,0xf9381009,0xf93cf004}},	//   件者, 均有, 生就, 市太
  { {0xf8418006,0xfa609004,0xfa7a100c,0xf4c0300c}},	//   第二, 盆景, 她想, 必選
  { {0xf9205007,0xf9425009,0xf9293007,0xf93c5004}},	//   口名, 合各, 用報, 千名
  { {0xfb74c006,0xf91e1004,0xf91b7004,0xfa83b00c}},	//   通知, 否具, 大及, 修服
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	// [4b0]   ,   ,   ,
  { {0xf81dc007,0xf9103005,0xf92e500c,0xf910d005}},	//   的互, 平公, 柔和, 足基
  { {0xfb886005,0xf5a3c00c,0x00000003,0x00000003}},	//   住用, 等諸,   ,
  { {0xf5ac200c,0xf494700a,0xfa615005,0x00000003}},	//   水自, 百選, 震抗,
  { {0xf5b96008,0xf931500c,0xfb7aa005,0x00000003}},	//   容赦, 力再, 持理,
  { {0xfa7c700e,0xf942d007,0xf8324004,0xf910b001}},	//   日放, 消定, 好下, 己做
  { {0xf943f004,0xf93cd005,0xf820200d,0x00000003}},	//   上又, 持基, 情交,
  { {0xf9133004,0xf49cf00a,0xfa55500d,0x00000003}},	//   好四, 大韓, 料模,
  { {0xf93c5009,0xfa6e9001,0xfa6ad005,0xfa66d005}},	//   的希, 到消, 海桐, 立水
  { {0xf5a20004,0xf4be9004,0xf93b500c,0x00000003}},	//   万象, 理配, 局因,
  { {0xfa88d00f,0xf4b49001,0xf949b00c,0xfb828005}},	//   全政, 生開, 低差, 升空
  { {0xf9335001,0xf936b001,0xf918500c,0xf4b4700c}},	//   供客, 保市, 油引, 通造
  { {0xf928b00f,0xf9127008,0xf4a0f005,0xfa6a500a}},	//   推出, 由度, 校都, 競演
  { {0xf915f004,0xf48f5001,0xf926d005,0xf91f900c}},	//   活多, 膳食, 置好, 蔡志
  { {0xf928700c,0xfa68700c,0x00000003,0x00000003}},	//   物地, 究月,   ,
  { {0xf5c22007,0xfb6f2004,0xf83ac001,0xfb63c004}},	//   短袖, 向申, 常人, 置税
  { {0xf4ad5004,0xf94a1001,0xf5a64002,0xf81fa00d}},	// [4c0] 村道, 疏失, 才被, 的仲
  { {0xf90c700c,0xf931f00c,0xf922d005,0x00000003}},	//   具履, 法判, 臭口,
  { {0xf946900f,0xf8312005,0xf5a70005,0x00000003}},	//   才可, 估中, 界自,
  { {0xf911f004,0xf91a1001,0xfb61a00a,0x00000003}},	//   地国, 陸客, 慣習,
  { {0xf81c0001,0xf946d004,0xf497b00c,0xf81fe005}},	//   市付, 桌子, 人違, 均住
  { {0xf8252004,0xfa7c1005,0xfb766005,0x00000003}},	//   免了, 以欺, 滞留,
  { {0xf9239005,0xf9311005,0xf922700c,0x00000003}},	//   京公, 字地, 犬夜,
  { {0xf91e7009,0x00000003,0x00000003,0x00000003}},	//   校内,   ,   ,
  { {0xfa711001,0xf59fc004,0xf90cf001,0xf82f2005}},	//   新正, 者解, 迷失, 数企
  { {0xfa4e9007,0xf90bd009,0xfa65d005,0x00000003}},	//   向日, 陵市, 和情,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf934900f,0xf8148009,0xf9177005,0xf9203005}},	//   期刊, 会代, 方庄, 次宣
  { {0xf4b9d004,0xf4c75001,0xf5a4e00c,0x00000003}},	//   流配, 行風, 積蓄,
  { {0xf826a009,0xf9215001,0xf58ca004,0xf5ac2001}},	//   位代, 客可, 成虫, 整表
  { {0xf83ba009,0xf829c004,0xfa625004,0xf92b900c}},	//   性事, 明中, 率控, 墓園
  { {0xf843c004,0xfb6b800c,0x00000003,0x00000003}},	//   置不, 粒眠,   ,
  { {0xf93cf007,0xf92c7009,0xfa85f005,0xf94ab005}},	// [4d0] 各分, 外合, 全明, 明国
  { {0xfb870004,0xfa82d004,0xf93b900c,0xfb6ce005}},	//   位登, 本投, 品受, 易登
  { {0xfa66d007,0xf932d008,0xf9489005,0xfa86b002}},	//   名次, 法廷, 税官, 利措
  { {0xf4b39001,0xf93a9004,0xfa65d005,0xf9185010}},	//   換連, 繁忙, 上林, 区六
  { {0xf92cb009,0xfa81b009,0xf824e005,0x00000003}},	//   化名, 断提, 又使,
  { {0xf8144009,0xf5a2600a,0xf49ed00c,0xf921f005}},	//   存一, 了致, 大音, 断引
  { {0xf844200b,0xfb5a400e,0xfa65b004,0xf5a08005}},	//   本人, 古物, 上法, 病能
  { {0xf946100f,0xfb5a2007,0x00000003,0x00000003}},	//   名字, 查站,   ,
  { {0xfa65100f,0xf80e8005,0xf9331005,0xfb69c00c}},	//   友推, 五不, 厚厚, 庫系
  { {0xfb74200f,0xfa85b007,0xf948b004,0x00000003}},	//   定義, 助教, 式公,
  { {0xf5a4e007,0xfb764001,0xf923f001,0xfb4bd004}},	//   合製, 初等, 可增, 家社
  { {0xfa55b009,0xf935b008,0xfa669001,0xf8348004}},	//   回族, 備工, 歌星, 睾丸
  { {0xf929d006,0xfb888001,0xfa70f00d,0x00000003}},	//   夫妻, 行現, 山洞,
  { {0xf812a001,0xfa70d001,0xfa815004,0xf4bef00c}},	//   紙上, 英招, 解惑, 心酸
  { {0xf491f001,0xf4c8d004,0xfa74300a,0xf4a3700c}},	//   報馬, 李金, 現性, 頭都
  { {0xf938b001,0xf828c004,0x00000003,0x00000003}},	//   一圈, 家二,   ,
  { {0xf598a007,0xf94a300e,0xf91a1005,0xf918b005}},	// [4e0] 所載, 規制, 入内, 刻地
  { {0xfa5c7009,0xf80dc001,0xfa739001,0xf5982005}},	//   的每, 他作, 東段, 期走
  { {0xf5b9e001,0xf945d00d,0x00000003,0x00000003}},	//   方調, 行封,   ,
  { {0xfa893004,0x00000003,0x00000003,0x00000003}},	//   迪拜,   ,   ,
  { {0xfb77400c,0xf5b8c00d,0x00000003,0x00000003}},	//   勝秘, 空警,   ,
  { {0xfa50f007,0xf944f004,0xf9207004,0xfa51700c}},	//   望有, 及存, 校大, 展業
  { {0xf93a9006,0xf5966001,0xf945d005,0xf5ca000c}},	//   要切, 站起, 同各, 質表
  { {0xf90c700e,0xf90b3001,0xf910f00c,0x00000003}},	//   具工, 買受, 印可,
  { {0xf92a7007,0xf5914009,0xf8176009,0xf8456008}},	//   徒刑, 投身, 果不, 浮世
  { {0xf4c1300f,0xf49db008,0xfb50e004,0xfa4ac008}},	//   有需, 信開, 影碟, 源泉
  { {0xfb53a007,0xf91b5008,0xfa72d008,0xf592e001}},	//   命科, 健在, 英樹, 際航
  { {0xf920100f,0xf5bb2009,0xf4c1d004,0xf9215004}},	//   業合, 度考, 合配, 次地
  { {0xf9115006,0xf59dc001,0xfb856008,0xf91a3005}},	//   数学, 心自, 紋章, 急忙
  { {0xfb7ca00f,0xf829c004,0xf92bb008,0xf5c4e00c}},	//   一直, 城中, 術協, 抬起
  { {0xf9419001,0xf945b004,0xfb84e005,0x00000003}},	//   圈圈, 界市, 床症,
  { {0xf5b5000b,0xfa60d00e,0xf819c001,0xfb61000a}},	//   電車, 資材, 私下, 中症
  { {0xf94a9009,0xf92bf008,0xfa5cd005,0xf845e005}},	// [4f0] 税区, 排出, 市抗, 潮中
  { {0xf845e004,0xf5a7a005,0xfa7fd002,0x00000003}},	//   置中, 不菲, 代有,
  { {0xfb4ab00e,0xf4aef008,0xfb5a4001,0xfa64b005}},	//   水着, 乖離, 改由, 再掀
  { {0xfa895004,0xf80aa004,0xf926f001,0xfb65800c}},	//   在海, 易促, 置平, 可確
  { {0xfb5d0005,0xfa7e100c,0x00000003,0x00000003}},	//   急状, 校所,   ,
  { {0xf921d006,0xfa7b3006,0xfb782007,0xf5b54004}},	//   第十, 接或, 作站, 国船
  { {0xf90f700f,0xfb6b8007,0xf93f3004,0xf92cd005}},	//   新商, 優異, 理分, 化小
  { {0xfa5d9009,0xf5b7e004,0x00000003,0x00000003}},	//   故意, 根菜,   ,
  { {0xf936d00f,0xfb6ba008,0xfa65d001,0xf5b8000a}},	//   高出, 未然, 行概, 核融
  { {0xfa645007,0xf58e6008,0xf4b09004,0xfa667001}},	//   位服, 世論, 帕金, 式手
  { {0xf810a009,0xfb51a008,0xf9451005,0xfa72d00c}},	//   五中, 称略, 名将, 山派
  { {0xf93ed009,0xf5c78009,0xfb6d600e,0xfb5ce005}},	//   如其, 用航, 論理, 入田
  { {0xf91d100d,0xfa713002,0x00000003,0x00000003}},	//   章名, 至政,   ,
  { {0xf4ae7006,0xf93e7006,0xfa63d006,0xfb58e00a}},	//   抗震, 了很, 程教, 相生
  { {0xf91c1009,0xf9223007,0xf9379004,0xf91b7008}},	//   入大, 業周, 原区, 否定
  { {0xf5a48005,0xfa71d005,0xf5a3c00a,0x00000003}},	//   再融, 山景, 益計,
  { {0xfa6ab001,0xfa5af004,0xf4a39004,0xf90ef004}},	// [500] 場最, 往是, 本面, 育在
  { {0xfa705001,0xfb734005,0x00000003,0x00000003}},	//   地法, 尚生,   ,
  { {0xf8112009,0xf919b007,0xfb864007,0xf9183008}},	//   些不, 出家, 蛋白, 人差
  { {0xfa73100e,0xf838e004,0xf9473004,0xf4a81005}},	//   西武, 常会, 益好, 在院
  { {0xf92af004,0xf845e005,0x00000003,0x00000003}},	//   倒在, 目代,   ,
  { {0xf92e5004,0xf90e300c,0x00000003,0x00000003}},	//   子已, 場年,   ,
  { {0xfa66d004,0xfb7e8004,0xfb536004,0xfa627005}},	//   名校, 商界, 湿疹, 三旗
  { {0xf9241006,0xf93a9009,0xf59e8004,0xf5aae004}},	//   本医, 品商, 内膜, 年考
  { {0xf92df00a,0x00000003,0x00000003,0x00000003}},	//   北小,   ,   ,
  { {0xf4a1b00e,0xf8478009,0xf829600c,0xf93a700c}},	//   中間, 八一, 奏人, 流分
  { {0xfa4fc001,0xf8198005,0x00000003,0x00000003}},	//   志業, 果中,   ,
  { {0xfb65800b,0xf5b1e006,0xf49df00e,0xfa7c5007}},	//   天皇, 新能, 無題, 知書
  { {0xfb558006,0xf92fd009,0x00000003,0x00000003}},	//   活的, 林公,   ,
  { {0xfb6c000f,0xf945700e,0xf80e8001,0xf93d3001}},	//   金積, 冊子, 五位, 況報
  { {0xf5996004,0xf4c3700c,0xfa71d00d,0x00000003}},	//   一考, 看需, 山是,
  { {0xf5926006,0xf90ff001,0xf91b7004,0xf58d0005}},	//   法追, 已出, 永德, 外要
  { {0xf90a7006,0xf92c7007,0xfa749009,0xfb64a004}},	// [510] 年同, 我心, 放松, 公署
  { {0xfa60b006,0xf943b004,0xf9413004,0xf911100a}},	//   草案, 月在, 等品, 話回
  { {0xf910700f,0xf92d9001,0x00000003,0x00000003}},	//   由各, 窗型,   ,
  { {0xf94a3004,0xfa4bc00c,0x00000003,0x00000003}},	//   量地, 道法,   ,
  { {0xfb60400b,0xf932b007,0xfa5b5009,0xfa50c004}},	//   設立, 站安, 要投, 法排
  { {0xfb644009,0xf58b8004,0xf80c8004,0xfb828005}},	//   京特, 炒股, 近万, 三祖
  { {0xf8246009,0xf9341004,0xfb6d0001,0xf4c5500a}},	//   仍不, 多在, 我猜, 事院
  { {0xf9325004,0xf4ad1005,0xfb4e300c,0x00000003}},	//   婚前, 向非, 石牌,
  { {0xfb50f007,0xfa54f007,0xfa875004,0xfb5f4004}},	//   想知, 感激, 在投, 性状
  { {0xf4a6d006,0xfb7f0001,0xfb85c00a,0xfa739005}},	//   利部, 的玻, 下略, 尼族
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf947f005,0x00000003,0x00000003,0x00000003}},	//   行巡,   ,   ,
  { {0xfa6ad007,0xf944f00c,0x00000003,0x00000003}},	//   起源, 下全,   ,
  { {0xf90a300f,0xf848a006,0xfa547009,0xfa7ab009}},	//   買商, 在人, 期有, 武昌
  { {0xfa673004,0xfa80f004,0xf92d9004,0xfa4fa004}},	//   反治, 口文, 向北, 向更
  { {0xfa69d001,0x00000003,0x00000003,0x00000003}},	//   收成,   ,   ,
  { {0xf82f4005,0x00000003,0x00000003,0x00000003}},	// [520] 防中,   ,   ,
  { {0xf832a006,0xfb696007,0xf81f0001,0xf92d3004}},	//   社会, 質疑, 各主, 当好
  { {0xf5b1600e,0xf93eb001,0xfb6a2005,0xfa723005}},	//   阿蘇, 梅子, 体税, 新数
  { {0xf4c55007,0xf9419001,0x00000003,0x00000003}},	//   同配, 月合,   ,
  { {0xf8134004,0xf8432004,0xf9351004,0xfa63d001}},	//   些中, 播主, 盟市, 草油
  { {0xf93f1007,0xf92f1001,0xf5a7c005,0xf932700c}},	//   旅店, 袖口, 不衰, 定問
  { {0xf93ad006,0xf938d006,0xf91a700e,0xf93d1009}},	//   一周, 一届, 交差, 市在
  { {0xfb896001,0xf93a3004,0xf4be9004,0xf5a7200a}},	//   伏特, 菜基, 超限, 後輪
  { {0xfa87b004,0xf9427004,0xf8460004,0xf931f00c}},	//   助活, 合分, 售信, 多合
  { {0xfa5cd00f,0xf90dd001,0xfa649005,0xfb57400c}},	//   悄悄, 伴唱, 又添, 紹的
  { {0xf4a29004,0xfa7b7005,0x00000003,0x00000003}},	//   中院, 略是,   ,
  { {0xfb5a4005,0xfa781005,0x00000003,0x00000003}},	//   古玩, 除涉,   ,
  { {0xfa87d00c,0xfa7dd005,0xf925d005,0xfa5cb010}},	//   助方, 学施, 景好, 考欄
  { {0xfa5fb00f,0xf92ff001,0xf5960001,0xf937700c}},	//   分機, 兔兔, 料製, 作後
  { {0xf9347004,0xfa591004,0xfa65f004,0xfa5b7001}},	//   四害, 局意, 程改, 送法
  { {0xf9285004,0xf92d9004,0xfa6ed004,0x00000003}},	//   叫停, 向南, 液或,
  { {0xfa76500f,0xf946300e,0xfb87800e,0xf9259009}},	// [530] 移民, 不全, 再現, 在很
  { {0xfa7b5007,0xf9319008,0xf9239005,0xfb60c005}},	//   別注, 動可, 央及, 模相
  { {0xfb66800f,0xfa66500e,0xfb7e0007,0x00000003}},	//   推理, 構想, 濃縮,
  { {0xf81e0004,0xf59ba004,0xf91b1004,0xfa7bf00c}},	//   如人, 市考, 武威, 照所
  { {0xf931d006,0xf93df009,0xf913b001,0xf59ae00c}},	//   法学, 布在, 共場, 果茶
  { {0xf5bac00f,0xf9213005,0x00000003,0x00000003}},	//   接近, 中力,   ,
  { {0xfa6a5007,0xf5980004,0xfa50a005,0xf948d005}},	//   伴手, 菜豆, 演播, 美原
  { {0xf9205004,0x00000003,0x00000003,0x00000003}},	//   口前,   ,   ,
  { {0xfa4e4007,0xf93af004,0xf9175004,0xfa64d001}},	//   且有, 市合, 建功, 計方
  { {0xf4b61007,0xf4a4b001,0xf944d001,0xfa793005}},	//   神魂, 煮食, 計出, 方欣
  { {0xf9301008,0xfb73e005,0xfa88500c,0xfa67d002}},	//   腔外, 多糖, 跨校, 不敷
  { {0xf927d007,0xf9287004,0xf931f005,0xf5ba000c}},	//   含商, 注度, 多哈, 知者
  { {0xf5c06008,0xfa4c2001,0xf9367008,0xf4c7b005}},	//   加護, 我怎, 粘度, 二院
  { {0xf9417004,0xfa85f005,0x00000003,0x00000003}},	//   了去, 旨意,   ,
  { {0xf914d005,0xfa7cd002,0x00000003,0x00000003}},	//   鬼子, 你手,   ,
  { {0xf58f4006,0xfa81d005,0x00000003,0x00000003}},	//   法行, 中投,   ,
  { {0xfb5bc00c,0xfa7d300a,0xfa861005,0xfb70400d}},	// [540] 入監, 大洗, 港海, 店系
  { {0xf5ae8004,0xf9431005,0xf9267005,0xf9359005}},	//   平考, 王光, 用密, 速崛
  { {0xfa65f001,0xf80da004,0xf5b88001,0xfb89c001}},	//   事書, 取保, 容著, 量精
  { {0xfa567004,0x00000003,0x00000003,0x00000003}},	//   保意,   ,   ,
  { {0xf8432009,0x00000003,0x00000003,0x00000003}},	//   中人,   ,   ,
  { {0xf8432001,0xf9143004,0xf90dd004,0xf93d7005}},	//   席人, 格切, 淳安, 品具
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf90c3001,0xfb71600a,0xf489b00c,0x00000003}},	//   極力, 衛省, 買量,
  { {0xfb6fe00f,0xf8118001,0xf93fd00c,0xf5b1600c}},	//   研習, 際企, 皇后, 艾草
  { {0xf8394006,0xf59dc00e,0xf9267007,0xfb7fa001}},	//   相互, 療費, 部宅, 約申
  { {0xf90e1009,0xf92c7009,0xfa793009,0xf90bd004}},	//   平同, 当加, 方正, 件好
  { {0xf912b00f,0xf5aac009,0xf5b1c009,0xf91cb008}},	//   共工, 年要, 新西, 度差
  { {0xf9203004,0xf8324004,0xf8364004,0x00000003}},	//   因就, 山信, 缺位,
  { {0xfb864005,0xfb6e400c,0x00000003,0x00000003}},	//   洋石, 科管,   ,
  { {0xfa861006,0xf9445004,0xf9093001,0xf9285005}},	//   表明, 半小, 家境, 只小
  { {0xfb7ee00f,0xfa7f1007,0xfb58e004,0xf9389004}},	//   情緒, 大海, 人登, 作原
  { {0xf92b3006,0xf92df004,0xf9277004,0xfa5c5001}},	// [550] 成品, 得市, 用得, 賀新
  { {0xfa7ab004,0xf92d9004,0xfa72d005,0xfa6cd00c}},	//   入村, 向受, 就曾, 極投
  { {0xf920f00c,0x00000003,0x00000003,0x00000003}},	//   連忙,   ,   ,
  { {0xfa5b5006,0xfb6f6009,0xfa723009,0xf940d001}},	//   求意, 化示, 新新, 篇回
  { {0xfb6e8009,0xf80ec001,0xf5a14001,0xf9117001}},	//   他用, 受保, 有要, 音平
  { {0xf5b1a007,0xf5ab6001,0xf48d3004,0xf9263004}},	//   抱著, 創見, 夷陵, 暨市
  { {0xf9281006,0xfb5c4009,0xfb553007,0xf92d5004}},	//   革命, 大片, 都知, 体平
  { {0xf8302009,0xfb553001,0xf9201005,0xfa65f00a}},	//   山企, 能知, 中很, 植林
  { {0xf93bf009,0xf90c3007,0xfa7f3004,0xf93df00a}},	//   七届, 家地, 股民, 七周
  { {0xfa60b00f,0xf92af004,0xf8462004,0xfa589001}},	//   商業, 提名, 用企, 需有
  { {0xfa64b001,0xf4a35004,0xf9169008,0xf9449005}},	//   又方, 是集, 電卓, 届市
  { {0xf592c001,0xf4a6f001,0xf944b004,0xf5c62004}},	//   供自, 全食, 又出, 在老
  { {0xf828c009,0xfb7e6004,0xf9413008,0xfb7fe00c}},	//   件不, 分等, 理室, 情無
  { {0xfb68000f,0xf81ac009,0xfb75600a,0xf80ca005}},	//   利社, 要会, 備管, 化二
  { {0xfb52f001,0xf93fb005,0x00000003,0x00000003}},	//   落的, 待加,   ,
  { {0xf49dd009,0xf9217005,0xfa68d005,0xf93d500c}},	//   大院, 京同, 和扶, 賃契
  { {0xf945f00f,0xfb4c300e,0xf827a001,0xf92d1004}},	// [560] 同分, 偶然, 式作, 源公
  { {0xfb59c00f,0xf846c009,0xf5a66004,0xf911b008}},	//   書目, 在会, 洋葱, 調停
  { {0xf92cd00c,0xf91b1005,0xf80d0005,0xf499f00d}},	//   取式, 撤出, 材中, 以集
  { {0xf5ac0007,0x00000003,0x00000003,0x00000003}},	//   直航,   ,   ,
  { {0xfa5f1001,0xf946300a,0xf943b00c,0x00000003}},	//   者林, 不器, 手心,
  { {0xf4a75006,0xf4981007,0xfa6a9004,0xf90e1005}},	//   含量, 登陸, 家注, 践基
  { {0xf4aff001,0xf930f001,0x00000003,0x00000003}},	//   世音, 減半,   ,
  { {0xfa510007,0xf91af004,0xfa56f001,0xfa5ef005}},	//   違法, 孤寡, 生正, 者法
  { {0xfa817004,0x00000003,0x00000003,0x00000003}},	//   冬明,   ,   ,
  { {0xfb6c8009,0xf492300e,0xf5aaa001,0xf916300c}},	//   化程, 調達, 場規, 人完
  { {0xf91c7006,0xf9451006,0xfa4c4009,0xf4a19007}},	//   大力, 越多, 子村, 業金
  { {0xf9319008,0xfb62a005,0xf93e500c,0xf943300c}},	//   毛布, 可程, 心形, 片印
  { {0xfa61b001,0xfb52500a,0xf90bb00a,0xf80da00a}},	//   計月, 報管, 張市, 救世
  { {0xf9423006,0xfb654007,0xfa827009,0xf90bf008}},	//   理念, 央研, 是按, 創元
  { {0xf9231006,0xfb5d4009,0xf935d001,0xf58d6004}},	//   六大, 性研, 嘟嘟, 算草
  { {0xfb81800c,0x00000003,0x00000003,0x00000003}},	//   三篇,   ,   ,
  { {0xfa5db009,0xf9289009,0xf936d004,0xf5a6800d}},	// [570] 内最, 在去, 高基, 和近
  { {0xf8464007,0xf8250005,0x00000003,0x00000003}},	//   表一, 上乘,   ,
  { {0xf5bc8001,0xf820e004,0xf4bfd004,0xfb4c5005}},	//   日落, 率也, 者造, 年用
  { {0xf9289005,0xf929700c,0xfb4db002,0x00000003}},	//   全健, 全島, 念珠,
  { {0xf92cb007,0xfa7d1009,0xfb87400e,0xf946f004}},	//   取名, 大投, 後編, 床医
  { {0xfa4aa00b,0xfa791009,0xfa566005,0xfa54800a}},	//   提案, 以按, 州文, 愛想
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf92df004,0xfa86300c,0x00000003,0x00000003}},	//   志参, 販毒,   ,
  { {0xfa6c5009,0xf942f009,0xf9179004,0xf5b9e004}},	//   直是, 程安, 方商, 来考
  { {0xf83e600b,0xf8248007,0xf5afc007,0xf4913001}},	//   大人, 合主, 議記, 己青
  { {0xf917d001,0xfa6cf001,0xfa585008,0xfa4e800c}},	//   出外, 買新, 非決, 跑步
  { {0xf81d6009,0xf9339001,0xf4a13004,0xfb54d005}},	//   情介, 料分, 衣食, 施素
  { {0xf490b007,0xf923f004,0xfb48d00c,0xfa5a900c}},	//   政重, 公大, 制疏, 品暇
  { {0xf9355006,0xfb83e009,0xf92b7004,0xf9285005}},	//   会尽, 等社, 当当, 用学
  { {0xf82ae00b,0xf82a6004,0xfb764001,0xfa62300c}},	//   件中, 意侵, 期研, 震旦
  { {0xfb764009,0xf940100c,0xf908500c,0xfa73b00a}},	//   真研, 情大, 然又, 都民
  { {0xf941f001,0xfb752001,0xf90bf005,0xf5ba800c}},	// [580] 安娜, 料索, 件平, 入菜
  { {0xf830e00f,0xf90bf007,0xf8230005,0xf4afd005}},	//   女人, 延平, 始下, 引黄
  { {0xf5c0a004,0xfa7cd004,0xf941b00c,0xfa7a5005}},	//   中老, 学本, 又安, 浸泡
  { {0xf940b004,0xf818c008,0xf90fb00c,0xfa83300c}},	//   分可, 紀伊, 新定, 正施
  { {0xf592c009,0xfb5ce004,0xf4a1f008,0x00000003}},	//   芙蓉, 章立, 院選,
  { {0xf911b004,0x00000003,0x00000003,0x00000003}},	//   湾同,   ,   ,
  { {0xfb4f7007,0xfb81c004,0xfa4ee005,0x00000003}},	//   走的, 理石, 志提,
  { {0xfa558006,0xf9317001,0xf92c9004,0x00000003}},	//   原料, 供市, 向商,
  { {0xfb4bd007,0xf8302004,0xf8414005,0xf58e000c}},	//   家精, 史使, 中会, 俐落
  { {0xf8414006,0xfa69700c,0xf933f00d,0x00000003}},	//   席会, 康橋, 付和,
  { {0xf81d600f,0xf91f9008,0xfa67700c,0xfb5c400a}},	//   情事, 形市, 明手, 童相
  { {0xf8366009,0xf949d007,0xf819a008,0xf5c3a004}},	//   人住, 小女, 府中, 本解
  { {0xf4bf3007,0xfa86f001,0xfb4f5001,0xf9109004}},	//   分項, 全感, 害羞, 由分
  { {0xfb57b008,0xf5ba0001,0xfa75d004,0xf912300c}},	//   常版, 方能, 施新, 能先
  { {0xfa659006,0xfb6d6005,0xfa71300c,0xf5a7800a}},	//   前期, 算等, 米格, 養育
  { {0xfa807009,0xfa68f009,0xf8256010,0x00000003}},	//   巡查, 疏散, 積依,
  { {0xf58f6007,0xfa63f004,0x00000003,0x00000003}},	// [590] 受著, 很是,   ,
  { {0xf80fe006,0xf941f00b,0xfb5ce006,0xf9409007}},	//   北京, 午前, 章程, 三合
  { {0xfa683006,0xf4b6d004,0xfa6b9005,0xf9109005}},	//   双方, 也面, 家根, 新快
  { {0xfb6a4001,0xf4c7d004,0xf92bd00c,0x00000003}},	//   習生, 霍邱, 休後,
  { {0xfb714007,0xf93ad007,0xfa763004,0xfa7bb004}},	//   何種, 品定, 出明, 学思
  { {0xf9279006,0xfa588001,0xfa578004,0xfb60200c}},	//   在哪, 保業, 孝感, 正積
  { {0xfa5b7006,0xffdaa009,0xfa7f3008,0xf840400c}},	//   一旦, 宸ヤ, 大抵, 業下
  { {0xf9231009,0xf8352009,0xfa783004,0xf93ff004}},	//   中去, 施以, 交有, 病学
  { {0xfa5d9008,0xfa80500a,0xf92b1005,0x00000003}},	//   装技, 止機, 青壮,
  { {0xf93a300c,0xf91bd00c,0xf48f5010,0xfa4fa014}},	//   持式, 群山, 地雄, ｗ杯
  { {0xf58ee005,0xfa6a9005,0x00000003,0x00000003}},	//   少能, 税方,   ,
  { {0xf910500f,0xf4a8f007,0xfb49d00e,0xf4c47002}},	//   異動, 全都, 家畜, 上需
  { {0xf9381007,0xfb6f8004,0xf8252008,0xfa83700c}},	//   生報, 化相, 程修, 可指
  { {0xf941b00f,0xf4c49007,0xf931b004,0xf92b5005}},	//   月刊, 不需, 何加, 体向
  { {0xf92b5009,0xf918b004,0xfa6d9008,0xf5c3a001}},	//   当向, 尺度, 撲滅, 業課
  { {0xf82d0009,0xf5c84005,0x00000003,0x00000003}},	//   育事, 在股,   ,
  { {0xfb740009,0xf4a49001,0x00000003,0x00000003}},	// [5a0] 供稿, 良風,   ,
  { {0xfa71f007,0xfb87e004,0xfa651005,0xfa4ec00c}},	//   政成, 上直, 例是, 南朝
  { {0xfa6f1006,0xf92b9001,0xf9381001,0xfb6d2005}},	//   声明, 契合, 察到, 向科
  { {0xfb61000b,0xf49dd009,0xfa7e3004,0xf944f005}},	//   本版, 大面, 校概, 下在
  { {0xf940b006,0xf90e900f,0xf942b004,0xf8192008}},	//   三届, 石堂, 三周, 所一
  { {0xf92db005,0xfa4ac00c,0x00000003,0x00000003}},	//   林同, 間故,   ,
  { {0xf9397009,0xfb764009,0xf4c57001,0xfa645001}},	//   果公, 神病, 坊間, 月旦
  { {0xf90d3010,0x00000003,0x00000003,0x00000003}},	//   荷台,   ,   ,
  { {0xfb680001,0xf4c23001,0xf81d6005,0x00000003}},	//   岩石, 有黑, 情下,
  { {0xf9379015,0xf5ae800c,0x00000003,0x00000003}},	//   原出, 困計,   ,
  { {0xf597c009,0xf91e5004,0xf5a5e001,0x00000003}},	//   生能, 大医, 益表,
  { {0xfa677001,0xfb5f4004,0xfa703005,0xfb5a3005}},	//   乎有, 形美, 新排, 油箱
  { {0xf5a32001,0xfa6f900c,0xfa6cf005,0x00000003}},	//   談起, 想打, 海泰,
  { {0xfb60c009,0xfb51b004,0xf825e001,0x00000003}},	//   患病, 地特, 見人,
  { {0xf8466009,0xfa55600c,0x00000003,0x00000003}},	//   物体, 聘法,   ,
  { {0xf924b00f,0xfb62200e,0xf4ae5007,0xfa771004}},	//   適合, 庭用, 志願, 改意
  { {0xf4c6b005,0xf81e8005,0xf90a9005,0xf59d600c}},	// [5b0] 不靠, 包保, 康宝, 故而
  { {0xfa66b008,0xf4ac1001,0xfb688004,0xf837c004}},	//   下段, 向量, 您知, 移交
  { {0xfa4f4006,0xfb5dc005,0xf944d005,0x00000003}},	//   少数, 卡等, 始化,
  { {0xf90b1006,0xfb79400c,0x00000003,0x00000003}},	//   水分, 作編,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf59ba007,0xf9461004,0xfb4d3001,0xf5bfe001}},	//   持著, 上在, 年登, 正草
  { {0xf9439001,0xf49a7008,0xf4c6d005,0x00000003}},	//   手品, 艦隊, 二道,
  { {0xf8366006,0xfa671004,0xfb6ce001,0xfb4f300c}},	//   出一, 名来, 近生, 僵直
  { {0xfa5e5006,0xf93b3004,0xf5b7000c,0xf4c8b00c}},	//   的是, 茂名, 刻迫, 菌防
  { {0xf937900c,0xfb8a6005,0xfa75d00c,0xf9369005}},	//   依刑, 明特, 能深, 速在
  { {0xf926f005,0xf93bd00d,0x00000003,0x00000003}},	//   目就, 送器,   ,
  { {0xf5a66007,0xf93ef004,0xf5b8000c,0x00000003}},	//   前輩, 集市, 腹膜,
  { {0xfa6ff004,0xfb6de004,0xf911d005,0xf9433005}},	//   就意, 成社, 乱差, 残忍
  { {0xf83c8006,0xfa707005,0x00000003,0x00000003}},	//   大会, 板有,   ,
  { {0xf5b10004,0xfa50a001,0xfa59c005,0x00000003}},	//   岳西, 法源, 一折,
  { {0xf4903001,0xfb76c005,0xfa7bf00c,0xfa56400a}},	//   深邃, 川的, 工日, 沙汰
  { {0xf939d001,0xf9333004,0xfa5ff004,0xf90b1001}},	// [5c0] 一四, 些公, 清淤, 谷底
  { {0xf5a7a006,0xfb77c005,0xfa6a1005,0xf930f005}},	//   上述, 属第, 福海, 魔御
  { {0xf4af300b,0xf941d007,0xfa582004,0xf9471005}},	//   展開, 有四, 生数, 及常
  { {0xf909b00f,0xfa67d008,0xf811c004,0xf92cb005}},	//   康城, 上段, 何信, 化反
  { {0xf9287009,0xf5922001,0xf5a4c005,0xfa5eb00c}},	//   全大, 泛舟, 不考, 善校
  { {0xf5b06007,0xf5904001,0xfa887002,0x00000003}},	//   育課, 動記, 天敵,
  { {0xf90eb007,0xfa82d004,0xf829c001,0xf9341001}},	//   新屋, 口性, 究保, 記名
  { {0xf8256009,0xf943f001,0xf909f004,0xf93ef004}},	//   型中, 上合, 件向, 商参
  { {0xf944f004,0xf8486001,0xf90cf005,0xfa4fa002}},	//   下周, 表你, 致大, 或政
  { {0xfa578006,0xf9441009,0xf80a4008,0xf92dd00a}},	//   宜昌, 不合, 互作, 宗像
  { {0xf840400a,0x00000003,0x00000003,0x00000003}},	//   形作,   ,   ,
  { {0xfa72d00e,0xfb868001,0xfb5a7001,0xf4c5f001}},	//   能時, 再犯, 吸盤, 積達
  { {0xf941500b,0xf9135009,0xfa87d004,0xf5bf8004}},	//   文字, 箱地, 用支, 面考
  { {0xf8120004,0xfa63d00c,0xfb662005,0x00000003}},	//   脚下, 把消, 部私,
  { {0xf90a7009,0x00000003,0x00000003,0x00000003}},	//   年完,   ,   ,
  { {0xf943500a,0xf5be400a,0x00000003,0x00000003}},	//   合展, 採血,   ,
  { {0xf92c7006,0xf5a12009,0xf942b001,0xfb748001}},	// [5d0] 首先, 三要, 月四, 高約
  { {0xfb642004,0xfb734004,0xf91c100c,0xf9231005}},	//   京移, 備礁, 工出, 景如
  { {0xf5c82009,0xf4c4f005,0xf4b81005,0xf4b4700a}},	//   在解, 位集, 原防, 標達
  { {0xfb886005,0xf90bf00c,0x00000003,0x00000003}},	//   式用, 水底,   ,
  { {0xf813c004,0xf9449001,0xf49df005,0xfa4c2002}},	//   料供, 積小, 大鼠, 我明
  { {0xf4be1004,0xfa7a5004,0xf49e500c,0x00000003}},	//   居高, 方新, 締酒,
  { {0xf5908009,0xfb720004,0xf929d00c,0xfa641002}},	//   列腺, 定等, 腫大, 宋朝
  { {0xf939d001,0xf90ff004,0xf5aec004,0xf826a004}},	//   品屋, 地察, 新行, 融中
  { {0xfb6da006,0xfa6a3009,0xfb706007,0xf930f004}},	//   提示, 年有, 店特, 志就
  { {0xf49cf006,0xfa4dc00b,0xfa82300f,0xfa671005}},	//   大道, 得意, 正本, 名查
  { {0xf58f400f,0xf9461009,0xf5b88001,0xf9441005}},	//   演講, 上周, 示解, 上届
  { {0xfa546006,0xf8388004,0xfa510008,0xf93b300c}},	//   定本, 室二, 換案, 所宣
  { {0xf81ec006,0xf9287004,0xfa6cf001,0xfb7ea004}},	//   了不, 利地, 防手, 集美
  { {0xf94ad006,0xf814a001,0xf5c4a004,0x00000003}},	//   美好, 償事, 本色,
  { {0xf9107006,0xf4c51007,0xfa5f100c,0x00000003}},	//   数字, 手部, 心放,
  { {0xf9429008,0xfa6ad008,0xfa4ee004,0xf4b2d005}},	//   光協, 刷機, 苗期, 会隆
  { {0xfa58c001,0xf5a42004,0xfb740001,0xf913b004}},	// [5e0] 一有, 手脚, 托福, 挽回
  { {0xf912f006,0xfa55a004,0xf912b004,0xfb692004}},	//   百姓, 料来, 松土, 用由
  { {0xf938d00f,0xf9361005,0x00000003,0x00000003}},	//   一半, 余平,   ,
  { {0xf5b42009,0xf9465004,0xfb86c004,0x00000003}},	//   国航, 今冬, 及群,
  { {0xf81e4007,0xfa4f4004,0xf948b005,0xf940d00c}},	//   者付, 民新, 明察, 有半
  { {0xfa68f005,0xfb884005,0xf80d800c,0x00000003}},	//   希捷, 椎病, 著上,
  { {0xf910d00e,0xf83de007,0x00000003,0x00000003}},	//   便局, 加保,   ,
  { {0xf939d005,0xf925300a,0xf599c00c,0x00000003}},	//   仁和, 支度, 況行,
  { {0xf596e00f,0xf5a1c008,0xf9343001,0xf5b18005}},	//   思考, 文責, 記小, 山自
  { {0xf4c9d001,0x00000003,0x00000003,0x00000003}},	//   像都,   ,   ,
  { {0xf5c78009,0xf5a6a009,0xf8398004,0xfa7fd004}},	//   用自, 立起, 查不, 象是
  { {0xfb81c007,0xf9451008,0xfa73d001,0xf9235002}},	//   理申, 不備, 能打, 辣味
  { {0xfa6dd016,0xfa721001,0xf92b7001,0x00000003}},	//   史料, 冰河, 雪山,
  { {0xf909700f,0xf5af4009,0xfb658004,0xf91b3001}},	//   買屋, 地考, 可缺, 書報
  { {0xfa727009,0xf5b1200c,0xf90b9005,0x00000003}},	//   地段, 共賞, 年土,
  { {0xf4a3b00e,0xfa4c2004,0xfb5a7004,0xfa641001}},	//   支障, 当支, 核管, 車手
  { {0xfa65f006,0xf4c7b007,0xf81bc00c,0x00000003}},	// [5f0] 立方, 而造, 懂了,
  { {0xf93c3006,0xf81bc009,0xf81c0004,0xf828a004}},	//   十六, 秀人, 吃上, 明作
  { {0xfa82f007,0xf5972007,0xfb73c001,0xfb842004}},	//   代書, 作計, 官等, 屋租
  { {0xf9095007,0xfa582007,0xf9253004,0xfa805008}},	//   島商, 生新, 副巡, 衣所
  { {0xfa7dd00c,0x00000003,0x00000003,0x00000003}},	//   因果,   ,   ,
  { {0xfb7b0007,0xfb4e1001,0xf83b0004,0xfa613004}},	//   局第, 場競, 斤以, 理日
  { {0xf80c400f,0xfa5d6001,0xfa853004,0xfb5c3005}},	//   我一, 促成, 央投, 吧的
  { {0xf9321007,0xf9101009,0xfa58a004,0xf932f008}},	//   多半, 想在, 回放, 多忙
  { {0xf9191007,0xf942f001,0x00000003,0x00000003}},	//   工安, 看守,   ,
  { {0xf91db007,0xf5c2a004,0xfa62d001,0xf83a8008}},	//   造力, 中解, 安森, 左上
  { {0xfb7c4009,0xf93f500e,0xfa78d004,0xf941d005}},	//   求真, 複合, 区活, 隆平
  { {0xf91f500f,0xf93c5007,0xf594000d,0x00000003}},	//   加坡, 所地, 定被,
  { {0xf9445006,0xfa5a4009,0xf8234007,0xf83e8004}},	//   等地, 局提, 等你, 性人
  { {0xf9135007,0xfb6e4001,0xf9345001,0xfa50a001}},	//   政室, 外研, 定可, 投機
  { {0xf820e006,0xfa5d0001,0xfa647005,0xfa5d4005}},	//   了中, 約情, 位每, 包案
  { {0xf81ca00f,0xfa56a007,0xf4953008,0xfa5a600c}},	//   私人, 原木, 費量, 府核
  { {0xfb59d004,0xf80ee004,0x00000003,0x00000003}},	// [600] 入突, 湖中,   ,
  { {0xfa5ac009,0xf8352004,0xf4bcd00c,0xfa79b00c}},	//   威望, 能交, 心高, 日持
  { {0xf80b2001,0xfb4b1005,0x00000003,0x00000003}},	//   限企, 海燕,   ,
  { {0xfb4bb008,0xf5b2a004,0xf9479004,0xf80dc001}},	//   件簿, 好老, 明同, 準作
  { {0xfb4db005,0xf90fd005,0xf90d3005,0x00000003}},	//   哲理, 碳化, 蒲式,
  { {0xf939100b,0xfa783007,0xfa633001,0xf58b8008}},	//   舞台, 改成, 泉渡, 源装
  { {0xf5a48009,0xfb62400e,0xf940d004,0xfa62f001}},	//   上要, 短編, 有及, 看有
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa83f007,0xf5b0a004,0xf83fa001,0xf817c004}},	//   口水, 史起, 造人, 非中
  { {0xf8094004,0xfa8b9004,0xfb7a800c,0x00000003}},	//   倒伏, 浪新, 作白,
  { {0xf92b300e,0xfa631004,0xfb58b001,0xf938b004}},	//   成十, 效提, 確無, 非国
  { {0xf845a009,0x00000003,0x00000003,0x00000003}},	//   在三,   ,   ,
  { {0xfa7ab00f,0xf48e500f,0xf83ba006,0xf58bc009}},	//   入我, 飲食, 查中, 当自
  { {0xfb84e00f,0xfa5ac009,0xfa713004,0xfa4fa005}},	//   版社, 最早, 由提, 或承
  { {0xfa77d001,0xfa65f004,0xf838800c,0x00000003}},	//   伸手, 和文, 出你,
  { {0xfb73e004,0xf91b7004,0xf93cb005,0x00000003}},	//   些特, 性很, 秀年,
  { {0xfb7c400c,0x00000003,0x00000003,0x00000003}},	// [610] 的灌,   ,   ,
  { {0xf5b26006,0xf910b006,0xfb652005,0xf5a1600c}},	//   施行, 械化, 利福, 指著
  { {0xfa711009,0xf9481008,0xf93b9005,0x00000003}},	//   就成, 量子, 求参,
  { {0xf8200001,0xf848200c,0xfa73d005,0xf93d500c}},	//   片一, 奪下, 款本, 碁峰
  { {0xf844c001,0x00000003,0x00000003,0x00000003}},	//   置作,   ,   ,
  { {0xf90eb004,0xfa6e100c,0x00000003,0x00000003}},	//   走光, 石手,   ,
  { {0xf5bd0004,0xfb89400c,0xfa51600c,0x00000003}},	//   春茶, 式登, 著更,
  { {0xf59f6001,0xf80d8005,0x00000003,0x00000003}},	//   分記, 首付,   ,
  { {0xfb61e007,0xf942f004,0xfb6a4004,0xf918900a}},	//   業研, 立安, 航班, 治具
  { {0xf81e6009,0x00000003,0x00000003,0x00000003}},	//   理上,   ,   ,
  { {0xfb6e8001,0xfb676001,0xf91c9004,0xfb85e00c}},	//   取物, 崩盤, 来函, 型系
  { {0xfa867005,0xfa6b900c,0x00000003,0x00000003}},	//   在拆, 整成,   ,
  { {0xf81b6009,0xf83a6004,0xf492b001,0xf48ed005}},	//   市住, 急会, 能需, 数配
  { {0xfb850005,0x00000003,0x00000003,0x00000003}},	//   合申,   ,   ,
  { {0xf92bb00e,0xfa789004,0xf927900a,0xfa62d002}},	//   自家, 容未, 全化, 之扉
  { {0xfb75600f,0xfa7f100b,0xfb828005,0xfa57a00c}},	//   原理, 形態, 有答, 期書
  { {0xfa711001,0xfa66b004,0xf4b35004,0xfa78100c}},	// [620] 右方, 越性, 通金, 人早
  { {0xf810c00f,0xf92b9007,0xfa5c8009,0xfb51f005}},	//   動休, 毒宣, 求提, 到百
  { {0xf93ab009,0xf8352004,0xf8232005,0xf83f000a}},	//   一只, 任不, 事不, 映中
  { {0xf9195004,0xfa741001,0xf92db002,0x00000003}},	//   建好, 押標, 向快,
  { {0xf942500f,0xfa7d9004,0xf92a9001,0xf91bb001}},	//   順延, 加沙, 打屁, 知客
  { {0xfb577004,0xfa4f000c,0xf5c9200c,0xfa4c4002}},	//   治素, 我拿, 木色, 子我
  { {0xfa841004,0xfa83b00c,0xf593c005,0xfa5a0005}},	//   播更, 六河, 厚街, 喜来
  { {0xf911500a,0x00000003,0x00000003,0x00000003}},	//   英子,   ,   ,
  { {0xf813e007,0xf8404004,0xfb56d001,0xfa62900c}},	//   站保, 象信, 遺症, 授教
  { {0xf93b1009,0xf5a08001,0xf9141008,0xf4905001}},	//   市及, 切記, 国志, 育音
  { {0xf81c2006,0xfa82d006,0xfb6ea008,0xf9493004}},	//   参保, 本法, 北線, 族学
  { {0xf9115004,0xf9193001,0xfb83e00c,0x00000003}},	//   困学, 工友, 等精,
  { {0xf922d009,0xf93ab004,0xfb5c7005,0xf4bdb00c}},	//   可再, 作平, 接相, 者需
  { {0xf944f004,0xf91e7004,0xf8186004,0xfa831004}},	//   上写, 性医, 果作, 路旅
  { {0xf5bde004,0xf8408004,0x00000003,0x00000003}},	//   大解, 庭住,   ,
  { {0xfa4ee009,0xfb499004,0xf9365004,0xf92d7005}},	//   得成, 号等, 生志, 民得
  { {0xfa867001,0x00000003,0x00000003,0x00000003}},	// [630] 可水,   ,   ,
  { {0xf5af2009,0xf849e007,0xf9475005,0xf92cf005}},	//   地要, 夫人, 反哺, 村初
  { {0xfb812004,0xfa63d004,0xf82d2008,0xfa75d005}},	//   者直, 草根, 赴任, 区月
  { {0xfb79e005,0x00000003,0x00000003,0x00000003}},	//   持立,   ,   ,
  { {0xf91b9004,0xf836e004,0xf946b00c,0x00000003}},	//   性告, 点介, 後向,
  { {0xf91ad004,0xfb878005,0xf4b6f005,0x00000003}},	//   知当, 前社, 土面,
  { {0xfb51b006,0xf4be7001,0xfa62a00c,0x00000003}},	//   地点, 商開, 指油,
  { {0xfa55000e,0xf918d001,0xf933f004,0xfb5e5001}},	//   拘束, 出健, 多只, 無私
  { {0xf9233009,0xfb4b3004,0x00000003,0x00000003}},	//   搭建, 海盗,   ,
  { {0xf4ae5004,0xf5c06008,0xfb76c004,0xf93f100c}},	//   得高, 模試, 高空, 分心
  { {0xf5b7800c,0xfb81e00a,0x00000003,0x00000003}},	//   書計, 草線,   ,
  { {0xf92e5007,0xfb7f6004,0xfa63200c,0xf80d400c}},	//   成地, 居第, 先民, 成你
  { {0xfa54200b,0xf90e9009,0xfb6f8005,0x00000003}},	//   多摩, 石市, 取相,
  { {0xfb876009,0xfa4de001,0xfa655005,0xf835a005}},	//   界第, 間更, 位搜, 治久
  { {0xf80ec007,0xfb4b1001,0xf4bc5005,0xfa5a000c}},	//   比一, 島素, 吃透, 所感
  { {0xf922100f,0xf841a004,0xf59ca004,0x00000003}},	//   業優, 京住, 考考,
  { {0xfb4eb007,0xf5a20008,0xf90a7001,0xf92cb005}},	// [640] 育研, 奇跡, 買多, 寒地
  { {0xf939b007,0xf9123004,0xf837c008,0xf9441005}},	//   作客, 好啊, 治以, 上刊
  { {0xf9289006,0xfb52f007,0xf58a8001,0xfb82800c}},	//   表大, 命的, 道要, 有研
  { {0xf4c4f004,0xf917d004,0xf836e004,0xf4bfb005}},	//   届高, 活区, 点事, 理非
  { {0xf8374009,0xf8254008,0xf92d9005,0x00000003}},	//   任中, 事中, 店和,
  { {0xf4a59001,0xfb886001,0xfb66e005,0xfb54700a}},	//   宮部, 牌社, 彩瞬, 社系
  { {0xfa7fb00f,0xf93f5009,0xf9463004,0xfa6b1001}},	//   加油, 者在, 事国, 海拔
  { {0xf82c200f,0xfb87a015,0xf812200c,0xfb51b005}},	//   收件, 小生, 些作, 使生
  { {0xf9331004,0xf59cc00a,0xf82c000c,0xfb7fe00c}},	//   站式, 布資, 德信, 情簡
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9435006,0xf8238001,0xf9241005,0xf5c8c002}},	//   程序, 手一, 售各, 雪芙
  { {0xf919700f,0xfb507009,0xf821a004,0xf5a3c004}},	//   書店, 新窗, 合上, 型超
  { {0xf923d004,0x00000003,0x00000003,0x00000003}},	//   可喜,   ,   ,
  { {0xfa4dc006,0xf4b8100c,0x00000003,0x00000003}},	//   南昌, 州郡,   ,
  { {0xf59e200f,0xf93c5004,0xf595400c,0xf59e4005}},	//   的表, 局就, 期者, 求落
  { {0xfb59f007,0xfa799004,0xf934100c,0x00000003}},	//   伸縮, 此期, 記前,
  { {0xfa79b00f,0xf496d005,0xfa71d00a,0xfa4fe00c}},	// [650] 入最, 人集, 房機, 林昭
  { {0xfa5fc00f,0xf92bd00b,0xfa671007,0xfa863001}},	//   分期, 結婚, 名日, 表所
  { {0xfa865007,0xfa7bb009,0xf93ad001,0xf938d005}},	//   可收, 日正, 省力, 作当
  { {0xf92db001,0x00000003,0x00000003,0x00000003}},	//   吐司,   ,   ,
  { {0xf939b004,0xfa7a9001,0xf927b00a,0x00000003}},	//   保山, 司治, 浩司,
  { {0xfa71700b,0xf91d3004,0xfb551001,0xfa701004}},	//   失敗, 入年, 命盤, 新源
  { {0xf5c36006,0x00000003,0x00000003,0x00000003}},	//   公路,   ,   ,
  { {0xf8386009,0xfb4e5007,0xf90a1004,0xf5a7a005}},	//   建中, 音美, 家子, 上走
  { {0xfb50b009,0xfa747001,0xf93d3004,0xf8388005}},	//   地用, 現方, 者合, 令不
  { {0xf5a7c004,0xf5b6e001,0xf9311005,0xf59c000c}},	//   不走, 方行, 些同, 心而
  { {0xfb64d009,0xf9233009,0xf82b6001,0x00000003}},	//   微生, 硬化, 島以,
  { {0xf826a005,0xf92f9005,0x00000003,0x00000003}},	//   序不, 金家,   ,
  { {0xf948100e,0xf5ca2001,0xf9475001,0xf591e00c}},	//   美堂, 喪葬, 服役, 奔走
  { {0xf9293009,0xf9189001,0x00000003,0x00000003}},	//   排名, 油庫,   ,
  { {0xf9119006,0xf5b08001,0xf9207008,0xf928100c}},	//   新建, 承載, 負傷, 含多
  { {0xfb6d8007,0xfa70f007,0xfa67f008,0xfb6ec004}},	//   受玉, 異業, 同日, 村特
  { {0xfb56300f,0xfa6e9008,0x00000003,0x00000003}},	// [660] 基礎, 進法,   ,
  { {0xf4b15008,0xf925500a,0x00000003,0x00000003}},	//   動部, 路出,   ,
  { {0xfb776001,0xf9461004,0xfa893004,0xf489b004}},	//   保生, 名列, 周新, 收非
  { {0xf9455004,0xf8476004,0xfa60e005,0x00000003}},	//   型公, 被一, 切期,
  { {0xfa70f007,0xfa717007,0xfb7b4001,0xfb896004}},	//   到本, 想想, 呂秀, 明用
  { {0xf914f009,0x00000003,0x00000003,0x00000003}},	//   国学,   ,   ,
  { {0xfb589001,0xfb5b1008,0xfb501004,0xfb593005}},	//   出無, 学省, 液相, 交站
  { {0xfb7e2001,0xfa63a001,0xf80f2004,0xfa59e005}},	//   心第, 洋情, 答了, 省残
  { {0xfb7fa007,0xfa4d0004,0x00000003,0x00000003}},	//   指紋, 柑果,   ,
  { {0xfb4f5006,0xf8248004,0xfa883001,0xf945f004}},	//   新的, 不乏, 崩潰, 立基
  { {0xf827a009,0xf8244004,0xfa5c8001,0x00000003}},	//   二中, 床位, 的族,
  { {0xf90c5006,0xf938d00e,0xf9373009,0x00000003}},	//   海区, 一冊, 生学,
  { {0xf59fc00f,0xfb7c8001,0xf948700a,0xf8488005}},	//   情趣, 要知, 像化, 周以
  { {0xf91f7004,0xf825a00c,0x00000003,0x00000003}},	//   信得, 牌一,   ,
  { {0xfa5d6009,0xf5920004,0xfa877004,0x00000003}},	//   心提, 会越, 在林,
  { {0xf4901001,0xf91a1005,0xfa877005,0xf909700c}},	//   米飯, 常公, 木林, 海型
  { {0xfb762007,0xf9265009,0xfa4ce007,0xf4b1d001}},	// [670] 料申, 用各, 間接, 供高
  { {0xfa875009,0xfa63e005,0xfa4d800c,0x00000003}},	//   在法, 下拘, 科林,
  { {0xfa7bd009,0xfb7c4001,0xf4afd001,0xf93cd005}},	//   学期, 求生, 著頭, 元包
  { {0xf92f900f,0xf938b004,0xf90eb004,0xf9469008}},	//   展局, 作向, 新宋, 融公
  { {0xfa79100c,0x00000003,0x00000003,0x00000003}},	//   人書,   ,   ,
  { {0xfb820006,0xf9251006,0xf5a52001,0xfa713004}},	//   文章, 是加, 合花, 新模
  { {0xf594a006,0xf59d6008,0xf9153004,0x00000003}},	//   生行, 突起, 麻城,
  { {0xf92d5004,0xfb599001,0xfa6ab004,0xf4a61001}},	//   伐加, 出異, 家森, 您需
  { {0xf9343007,0xfb6ea001,0xfb655001,0xfa62600a}},	//   高屏, 拖累, 早療, 文春
  { {0xfb7a6006,0xf83a4009,0xfa66400c,0x00000003}},	//   品的, 奥会, 手拿,
  { {0xf5b4a005,0xfb67700a,0x00000003,0x00000003}},	//   好解, 風習,   ,
  { {0xf918d006,0xfa84b00e,0xf5a4c004,0xf91f7005}},	//   出入, 斬新, 例自, 照年
  { {0xf92c7008,0xfa783004,0xf92d900c,0xfb4ab005}},	//   子園, 改提, 外力, 水秀
  { {0xf93cb006,0xf91bb009,0xf498f007,0xf828c004}},	//   突出, 以加, 基酸, 序中
  { {0xf9435009,0xf90a7009,0xf919d004,0xf58e200c}},	//   晋城, 然在, 知如, 科董
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf91a100f,0xf844e006,0xf5b24007,0xfb4d3005}},	// [680] 日商, 是中, 穿著, 年画
  { {0xfb4eb004,0xf82b200c,0xf4c5b00c,0x00000003}},	//   台等, 買五, 車違,
  { {0xfa84d006,0xfa62e007,0xf5b24004,0xf59f4005}},	//   副本, 下有, 地走, 了超
  { {0xf90b9009,0xf4c33001,0xf8252004,0xfb6f6005}},	//   巴塞, 克里, 同上, 店用
  { {0xf942f006,0xfb688004,0xfa632001,0xf496f00c}},	//   下半, 在系, 型手, 空隙
  { {0xfa592007,0xf916d004,0xf8124004,0xf933d005}},	//   所所, 点半, 通住, 尚志
  { {0xfb82800f,0xf4af500c,0xfb84200c,0x00000003}},	//   指示, 法重, 葉石,
  { {0xf91c1004,0xf9343005,0xfb86200d,0x00000003}},	//   津区, 高小, 昌盛,
  { {0xfb50300b,0xf918b009,0xf9305008,0x00000003}},	//   防災, 出大, 純利,
  { {0xfa711004,0xf90d300d,0xf944d00d,0x00000003}},	//   就提, 捷地, 重威,
  { {0xfb6ba004,0xf82f8004,0xfb5b700d,0x00000003}},	//   堪称, 数万, 以独,
  { {0xf934900d,0x00000003,0x00000003,0x00000003}},	//   料列,   ,   ,
  { {0xf91e5006,0xf9455007,0xf92f5001,0x00000003}},	//   学家, 版地, 斗南,
  { {0xf911b007,0xfa5ae001,0xf93cf001,0xf83a4001}},	//   細出, 一早, 各商, 書信
  { {0xf4ba500c,0x00000003,0x00000003,0x00000003}},	//   作選,   ,   ,
  { {0xf91eb009,0xfa61000c,0x00000003,0x00000003}},	//   大国, 情海,   ,
  { {0xf921f004,0xf5a0c001,0xfb5c100c,0x00000003}},	// [690] 解在, 超迷, 急照,
  { {0xf825e004,0xfa7a100c,0xf5910005,0xf49ff002}},	//   始人, 凹槽, 引航, 辣鍋
  { {0xf9299001,0xf49b5008,0xf8220008,0xf9453005}},	//   全場, 別館, 授与, 伊川
  { {0xf911f00b,0xf4ba5007,0xf90c5001,0xf48e1004}},	//   許可, 一間, 場全, 曲阜
  { {0xfa640006,0xf946d004,0xfa61a008,0xfa562005}},	//   上有, 前宣, 誉教, 搞清
  { {0xf8162001,0xfb844001,0xf916b004,0xfb5e100c}},	//   域互, 洋科, 空心, 你真
  { {0xf9441006,0xfa570004,0xf82e2001,0xf9119005}},	//   上半, 属材, 想事, 声大
  { {0xfa765006,0xf4bcd007,0xf59dc004,0xf92df005}},	//   出所, 心願, 者要, 得参
  { {0xf5bc400f,0xfa81d004,0xf8226004,0xfb63b004}},	//   座談, 中法, 文主, 皮炎
  { {0xf49b5005,0xf91bb00c,0xf93e900c,0x00000003}},	//   度集, 春夢, 的奢,
  { {0xfa5fe006,0xf940d009,0xf81d4009,0xfb77e005}},	//   集成, 了公, 十佳, 生米
  { {0xfb519009,0xf92cb004,0xf920b001,0xf93e3001}},	//   地登, 他希, 員出, 它可
  { {0xfa70900f,0xfb5ff004,0xf90a3001,0xf92ed004}},	//   板橋, 加社, 收受, 湖公
  { {0xf816c007,0xf49bb004,0xf4af7004,0xf92db001}},	//   初一, 健院, 南靖, 抓到
  { {0xfa85f00b,0xf93d500f,0xfa7ed009,0xf812c001}},	//   用意, 約定, 因是, 料上
  { {0xf4bb3009,0xf92bb009,0xf923d004,0x00000003}},	//   老金, 酒吧, 端州,
  { {0xfa5f200f,0xfb62b007,0xf4ae7004,0xfb792004}},	// [6a0] 理情, 可看, 得通, 果用
  { {0xf829c007,0xfa81d007,0xf92ff009,0xf4943005}},	//   件作, 業投, 法分, 西陵
  { {0xfa5aa004,0xf4b11001,0xfa75b001,0xf80dc005}},	//   作格, 盛開, 都想, 套住
  { {0xf9471007,0xf9399007,0xf829e001,0xfb4c3001}},	//   行協, 要先, 明代, 買盤
  { {0xfa65e00f,0xf937b006,0xf5b6c007,0xf59f800a}},	//   下殺, 非公, 人者, 射能
  { {0xfb728001,0x00000003,0x00000003,0x00000003}},	//   動社,   ,   ,
  { {0xf843200f,0xf81fe009,0xf5bd0005,0xfa85300a}},	//   業人, 率低, 大荒, 憩所
  { {0xf921f001,0xf938d001,0xfb669008,0xf919900c}},	//   冬必, 回味, 在留, 懸崖
  { {0xfb7d8007,0xfa7d3009,0xfa7a5004,0xf930f00a}},	//   各科, 大朗, 春晚, 比叡
  { {0xf929b004,0xfb864005,0x00000003,0x00000003}},	//   冒充, 届第,   ,
  { {0xf4b49006,0xf5ba0004,0xf4c59001,0xfa65e001}},	//   站首, 改落, 而需, 開春
  { {0xfb79a00f,0xf5c4e007,0xf9109009,0xf8246001}},	//   一片, 物袋, 米左, 上住
  { {0xfa6df006,0x00000003,0x00000003,0x00000003}},	//   平洋,   ,   ,
  { {0xf92d5004,0xf4a5d001,0xf917500c,0x00000003}},	//   子口, 用配, 人借,
  { {0xf59ac00b,0xf92b3001,0xfb67b005,0xf922700c}},	//   時計, 未命, 含的, 宣宣
  { {0xf9367001,0x00000003,0x00000003,0x00000003}},	//   搞定,   ,   ,
  { {0xfa6ae001,0xfb80e004,0xf91ab005,0xf818e010}},	// [6b0] 場時, 按程, 以当, 堀之
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb86000a,0xfb6a500c,0x00000003,0x00000003}},	//   型特, 徒生,   ,
  { {0xf598a006,0xf93f3006,0xf5a3e007,0xf4c07004}},	//   回落, 理商, 刊載, 分部
  { {0xf90ed009,0xf9491007,0xf5c94004,0xfa747008}},	//   地完, 行家, 八路, 国支
  { {0xfa4c600f,0xfa871001,0xf48b1005,0x00000003}},	//   取消, 部民, 年集,
  { {0xf92f5007,0xf934d004,0x00000003,0x00000003}},	//   我已, 星城,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf820400f,0xf9147006,0xf5aec004,0xfa799005}},	//   情人, 派出, 新貌, 略意
  { {0xfa5fc00f,0xf9199004,0xf90e1005,0x00000003}},	//   病患, 接再, 女双,
  { {0xf5b96007,0xfb72e005,0xfa873005,0xf48ff00c}},	//   日誌, 些用, 周排, 害風
  { {0xf93bb007,0xf5b50009,0xf913b008,0xf93fb005}},	//   一刻, 治行, 西国, 了初
  { {0xf4ba3007,0xf9255004,0xfb7f2001,0xf92f7005}},	//   品送, 修志, 宅火, 外医
  { {0xf926d004,0xf5bf2008,0xf5a56001,0x00000003}},	//   紫光, 造解, 額補,
  { {0xf949f001,0xf90df005,0xf5a5000c,0xf5b3a010}},	//   美夢, 育力, 鍋身, 政調
  { {0xfb7d2001,0xf93f7005,0xfa59200a,0xfa67c005}},	//   心生, 促就, 藝春, 行探
  { {0xfa4e200e,0xfa6d3009,0xfa4a4004,0xf5912008}},	// [6c0] 筑波, 色明, 体意, 飛躍
  { {0xfb7c0004,0xf5a4000c,0xfa60c00c,0xfb51500c}},	//   局稽, 先設, 有拉, 石災
  { {0xfa70b004,0xf84ae008,0xf5b80001,0xfb7a6004}},	//   使每, 怪人, 方舟, 要病
  { {0xf9333004,0xf918f001,0xf90eb00a,0xf920900a}},	//   余市, 常勝, 甲南, 設問
  { {0xf90cf001,0x00000003,0x00000003,0x00000003}},	//   強弱,   ,   ,
  { {0xfa4ce005,0xfa530005,0xfa4b200c,0xf930300c}},	//   他每, 厚望, 成所, 沖刷
  { {0xf8326004,0xfa4b000c,0x00000003,0x00000003}},	//   能介, 源服,   ,
  { {0xfa4d800c,0x00000003,0x00000003,0x00000003}},	//   受消,   ,   ,
  { {0xf93df009,0xf941f004,0xfb635001,0xfa6a4008}},	//   担心, 又名, 札特, 琶湖
  { {0xf8252004,0xfb6c7008,0xf93d9004,0xfa6a4005}},	//   及依, 科病, 黄土, 年按
  { {0xf92a7006,0xf58d0009,0xfb5b700a,0xfa5ac00c}},	//   虫害, 首要, 性版, 送折
  { {0xf9187007,0xf92db007,0xf9255008,0xfa5fc004}},	//   基因, 科全, 修得, 射液
  { {0xf916300f,0xf946300c,0xf924900c,0x00000003}},	//   呼吸, 和尚, 奮力,
  { {0xf927f006,0xfb64900e,0xf82fe009,0x00000003}},	//   在公, 第百, 育人,
  { {0xfa56a006,0xfb7fc00f,0xf935b00f,0xf9317009}},	//   保持, 理科, 領取, 供参
  { {0xf919d006,0xfa56a007,0xf810c001,0xf918d005}},	//   春市, 料更, 五代, 方利
  { {0xf5a68001,0xfa4a0001,0xfa58c00c,0xfa84900c}},	// [6d0] 行補, 道有, 一按, 可推
  { {0xf91a9004,0xfb85c005,0xf927700c,0xf814c005}},	//   以向, 上答, 岩層, 期仍
  { {0xf5b08005,0xf5c66005,0xf497d00c,0x00000003}},	//   台街, 器装, 虹通,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf92cd004,0xf90ff004,0xf8440005,0xf4925005}},	//   他城, 地土, 修企, 汽配
  { {0xf912100f,0xf9475009,0xf9185009,0xf4c09004}},	//   弱勢, 意内, 示公, 密部
  { {0xfa666009,0xf945f004,0xf92ed004,0xfb643004}},	//   位是, 上只, 得少, 本特
  { {0xfa4c4007,0xfa642004,0xfb565001,0xf939b00c}},	//   我所, 守本, 系科, 作夢
  { {0xf5bde002,0x00000003,0x00000003,0x00000003}},	//   大董,   ,   ,
  { {0xf4bd7009,0xfb611007,0xf915d009,0xf9255005}},	//   市院, 業率, 白山, 路基
  { {0xf498f00e,0xf9125001,0xf92bb001,0xf9377005}},	//   書類, 印地, 耐力, 阜城
  { {0xfb7c600e,0xf9265008,0xfa566001,0xfa775005}},	//   境省, 利子, 願池, 出村
  { {0xf5c7a007,0xf83f400c,0xf49c300c,0x00000003}},	//   彩虹, 因信, 大順,
  { {0xfa7cd00b,0xfb760001,0xfa620001,0x00000003}},	//   日新, 務社, 症患,
  { {0xf9435007,0xf927f005,0x00000003,0x00000003}},	//   友名, 在冬,   ,
  { {0xf945100a,0x00000003,0x00000003,0x00000003}},	//   和光,   ,   ,
  { {0xfa670009,0xf9453004,0xfa723004,0xf9119004}},	// [6e0] 量最, 事公, 新泰, 由北
  { {0xfa5be007,0xfa78b007,0xf5992008,0xfb5e5004}},	//   一書, 樹木, 作自, 大系
  { {0xfb72c006,0xf81d4001,0x00000003,0x00000003}},	//   站立, 項事,   ,
  { {0xf940b006,0xf92dd004,0xf91bb004,0xfa6a2004}},	//   有很, 他原, 座城, 海旅
  { {0xf927b007,0xfa646001,0xf91bd00c,0xfb589005}},	//   部全, 手感, 度原, 点研
  { {0xf5b9a00f,0xf9427001,0xf92b7004,0xf4a5f008}},	//   書表, 合商, 子元, 表題
  { {0xf4b5700a,0xf491f00c,0xfb5d700c,0x00000003}},	//   回開, 異鬼, 締約,
  { {0xf83c200b,0xf4be5008,0xf942f00c,0xf916900c}},	//   日以, 布院, 安可, 空品
  { {0xf910700f,0xfb7f4001,0xfb6d5005,0xf8356005}},	//   山分, 的穿, 怖片, 死一
  { {0xfb818004,0xf9227005,0xfa6ba00c,0xf944700c}},	//   了特, 代加, 德斯, 拉到
  { {0xf9267007,0xf81aa001,0xf824400c,0x00000003}},	//   用分, 要付, 型作,
  { {0xf5b1e00b,0xf9349004,0xf5aca001,0xf4ae1001}},	//   新製, 会加, 場設, 外道
  { {0xfa59c015,0xfa6be001,0xfa78100c,0xfb76400d}},	//   持消, 然想, 油桐, 料箱
  { {0xf9485009,0xf946b001,0xfa713004,0xfa59c004}},	//   族宗, 位加, 新校, 老有
  { {0xfa793001,0xf917d001,0xf926d005,0xfa510005}},	//   油污, 活出, 在初, 志数
  { {0xf92cd00f,0xf5c22004,0xf4b9b00c,0xfb66100d}},	//   鑑定, 既能, 往高, 梯田
  { {0xf4b9f00f,0xf814c001,0xfb8a2001,0x00000003}},	// [6f0] 流量, 四件, 意田,
  { {0xf4c4700f,0xf90a9004,0xf5c06004,0xfb599001}},	//   名額, 年城, 断行, 春美
  { {0xfa4ce00c,0xf4889005,0x00000003,0x00000003}},	//   或技, 零配,   ,
  { {0xf9495009,0xfb886007,0xfa859005,0x00000003}},	//   意大, 牌精, 是核,
  { {0xf8424004,0xfa600001,0xf93f1001,0x00000003}},	//   代中, 片所, 球券,
  { {0xf8264004,0xfa4e2001,0xfb60b001,0x00000003}},	//   坊中, 民扣, 無知,
  { {0xfb681006,0xf5bfa004,0xf90ad005,0xf91eb005}},	//   只看, 次被, 康向, 素含
  { {0xf4c4d00b,0xfb81a004,0xfb794001,0xf91a9005}},	//   友達, 分社, 神父, 典奥
  { {0xf4bb3007,0xfa60c007,0xf9357004,0xfb4ab001}},	//   一面, 三洋, 会平, 強生
  { {0xfa5b2009,0xf943b008,0xf9133005,0x00000003}},	//   市残, 案外, 放北,
  { {0xf5be0007,0xf4c33008,0xfb6bd008,0xf92d7005}},	//   大象, 有面, 親父, 易平
  { {0xfa4a8001,0xfa76b008,0xfa7c3005,0xfa54e00a}},	//   寒暑, 抹消, 以核, 線治
  { {0xf4b8d00f,0xf5a6200c,0xf5c5e00c,0x00000003}},	//   夜間, 反著, 部認,
  { {0xf5a6a00f,0xfa5ec009,0xf93d500c,0xfb80e005}},	//   歌詞, 分明, 時客, 理素
  { {0xf826a00f,0xf814c006,0xf4c2f007,0xfa81f004}},	//   意事, 期不, 屋開, 中旗
  { {0xf923f001,0xfa4d2005,0xf92a1005,0xfa4f400c}},	//   種問, 当放, 未央, 近新
  { {0xfb830009,0xfa58c009,0xf5b26005,0xf90b900c}},	// [700] 合科, 着手, 宿豫, 年原
  { {0xf9225006,0xfa84d001,0xf81f0004,0xf812e004}},	//   中央, 佩服, 居世, 盛世
  { {0xfb81a004,0xfa79f002,0x00000003,0x00000003}},	//   有率, 妤投,   ,
  { {0xfa76500e,0xf4be9001,0xf92f5004,0xfb5c5005}},	//   決意, 情速, 笑声, 大留
  { {0xfa7db007,0x00000003,0x00000003,0x00000003}},	//   警政,   ,   ,
  { {0xf918900f,0xf9391004,0xf91f5001,0xf93bd00c}},	//   登山, 言反, 象動, 堂必
  { {0xfb615009,0xfa704001,0xf4a1b001,0x00000003}},	//   揭秘, 報時, 業道,
  { {0xf90c1009,0xfa604009,0xf5bf8001,0xfb4e300c}},	//   水北, 理或, 信自, 場直
  { {0xf826800c,0x00000003,0x00000003,0x00000003}},	//   車代,   ,   ,
  { {0xfa61c002,0x00000003,0x00000003,0x00000003}},	//   密政,   ,   ,
  { {0xfa65e009,0x00000003,0x00000003,0x00000003}},	//   同情,   ,   ,
  { {0xf9225007,0xf5a96001,0xf92cd00a,0x00000003}},	//   代客, 騎著, 化問,
  { {0xfb5b7006,0xf8178009,0xfa859004,0xfb770004}},	//   秦皇, 感人, 目是, 肝病
  { {0xf9347004,0xfb6e9001,0xfa86b001,0xf4b4700a}},	//   会客, 向盤, 森房, 多面
  { {0xfa56c001,0xfa6d2005,0x00000003,0x00000003}},	//   募普, 赴日,   ,
  { {0xf9451009,0xf9469004,0xf5c6400c,0x00000003}},	//   名商, 位客, 可買,
  { {0xf93f3006,0xf5998007,0xf939d001,0x00000003}},	// [710] 内外, 一者, 送及,
  { {0xf814a006,0xfa81d004,0xf90c5001,0xfa700002}},	//   会信, 代末, 起出, 到星
  { {0xf59de008,0xf9309004,0xf91ed004,0x00000003}},	//   市若, 引向, 性国,
  { {0xf80ca009,0xf948b004,0xf9119004,0xf920b00c}},	//   易信, 城域, 由受, 員基
  { {0xfa4f8004,0xfa5e4005,0xf944b00a,0x00000003}},	//   何意, 者拘, 須入,
  { {0xf5a5a001,0xfa6f8002,0x00000003,0x00000003}},	//   而要, 至我,   ,
  { {0xfa658009,0xf5b22009,0xf934d001,0xf5c1c001}},	//   合整, 灰色, 原名, 本考
  { {0xfa4b6004,0xf92ad008,0xf4c7300c,0xf91a500a}},	//   当成, 習志, 式集, 相姦
  { {0xfb523001,0xfa787008,0x00000003,0x00000003}},	//   精的, 系新,   ,
  { {0xf936300f,0xf9461007,0xfb683004,0xfb794004}},	//   生動, 額外, 用章, 神状
  { {0xfa877004,0xfa4ca008,0xf924b004,0xf920500c}},	//   在抗, 外構, 港公, 加地
  { {0xf9299006,0xfa723001,0xf5a1c004,0xfa815005}},	//   全年, 由正, 豆芽, 京残
  { {0xf826a00e,0xf5bc6007,0xf93bb004,0xf8128005}},	//   意下, 試著, 退役, 会企
  { {0xf947d006,0xf4bd7007,0xfb68b004,0xf945f005}},	//   前已, 市面, 在特, 同商
  { {0xf849a00f,0xf838c00f,0xf5be6001,0xf58e2008}},	//   優仕, 此一, 亡者, 金設
  { {0xfb66f009,0xf81ee001,0xf92d7004,0xfb51f001}},	//   器租, 分一, 民宗, 虱目
  { {0xf5966007,0x00000003,0x00000003,0x00000003}},	// [720] 原著,   ,   ,
  { {0xf4aad005,0xf845c005,0xf90bf00a,0xfb5b300c}},	//   当高, 您介, 整列, 書由
  { {0xf937d004,0xfb563005,0xf59a000c,0xf837c005}},	//   期国, 格略, 流言, 系以
  { {0xf4aa900e,0xf927f008,0xf8296004,0xfa70c005}},	//   身長, 天国, 起上, 想武
  { {0xf932f00f,0xfa690009,0xfb7e0001,0xf9155005}},	//   動地, 迎提, 心目, 格全
  { {0xfa5f2004,0xfa74f005,0xfb7be005,0x00000003}},	//   理清, 好此, 市率,
  { {0xf92ad00b,0xfb7e6001,0xfb53d005,0x00000003}},	//   習得, 迄目, 放矢,
  { {0xfa656006,0xfa7eb009,0x00000003,0x00000003}},	//   二手, 加注,   ,
  { {0xf93e1006,0xf5aca00e,0x00000003,0x00000003}},	//   市容, 長調,   ,
  { {0xfb5f1009,0xf8114004,0xfb52d005,0x00000003}},	//   加班, 研人, 放碑,
  { {0xfb786007,0xfb85a004,0x00000003,0x00000003}},	//   依第, 名科,   ,
  { {0xf5ab8006,0xf4ae7001,0xf91b5004,0xf4b5d004}},	//   致辞, 受雇, 否存, 熟食
  { {0xf839a001,0xf9473001,0xf8242005,0xf840000c}},	//   步一, 行外, 立保, 連三
  { {0xf4973007,0xf9401009,0xfa7cb004,0xfa602001}},	//   方送, 超出, 学普, 超方
  { {0xf9357006,0xf4ba5009,0xf90c100c,0x00000003}},	//   教学, 一道, 件共,
  { {0xf9357006,0xfb842009,0xfb85e004,0xf83a8001}},	//   留学, 合素, 事特, 查作
  { {0xfa6c0004,0xfa78b005,0xf90d300a,0xf93fb010}},	// [730] 收新, 活更, 護制, 雄山
  { {0xf92af006,0xf917f004,0x00000003,0x00000003}},	//   八年, 活常,   ,
  { {0xfb85e007,0xf916f001,0xfa6b4001,0xfa54800a}},	//   立空, 確切, 起湖, 原案
  { {0xfa7d3009,0xf93eb004,0xfb804001,0xf81fc004}},	//   大旗, 了同, 率約, 的估
  { {0xf91e500b,0x00000003,0x00000003,0x00000003}},	//   次元,   ,   ,
  { {0xf934f009,0xfb870001,0xfa817004,0xf498700c}},	//   付宝, 操盤, 敬意, 層配
  { {0xfa5dc004,0xf494b001,0xf8488004,0xf931d005}},	//   球比, 落閣, 部交, 法另
  { {0xf90d500e,0xfa6b4004,0xfb58f001,0x00000003}},	//   兵器, 海湖, 陸生,
  { {0xfa6d800c,0xfb7d800c,0x00000003,0x00000003}},	//   張旭, 要直,   ,
  { {0xf9125009,0x00000003,0x00000003,0x00000003}},	//   能及,   ,   ,
  { {0xf90f3009,0xf91db005,0x00000003,0x00000003}},	//   平原, 大冬,   ,
  { {0xf9115006,0xf8328008,0xf4c0500c,0xf8242005}},	//   承包, 報交, 劇魅, 立依
  { {0xfb77800b,0xfa65e00f,0xf5b38001,0xfa829005}},	//   回目, 行時, 格認, 是手
  { {0xf4b0f00e,0xf9095009,0xf9193008,0xf91a9005}},	//   供開, 海安, 日吉, 触及
  { {0xfa64c009,0xfa568007,0xfa789004,0xfb6d900c}},	//   前所, 期末, 竹溪, 林益
  { {0xf9337004,0xfa5d6001,0xf48cd004,0x00000003}},	//   会向, 境民, 海防,
  { {0xf9219009,0xfa7cf00c,0xfa831005,0x00000003}},	// [740] 京城, 你才, 口方,
  { {0xf928700b,0xf83b0009,0xf9329004,0xf9459004}},	//   訪問, 学一, 会堂, 位向
  { {0xfa837008,0xf4b45008,0xf4c5f00c,0x00000003}},	//   華料, 通院, 削骨,
  { {0xfa710001,0xf4b3900c,0xf5b8400c,0xf82de00c}},	//   花枝, 多道, 常要, 整件
  { {0xfb7c4004,0x00000003,0x00000003,0x00000003}},	//   的界,   ,   ,
  { {0xfa57a009,0xfa600009,0xfb5fd007,0xf9421005}},	//   原油, 蓄水, 面紙, 分困
  { {0xfb6ad00e,0xfb826001,0xfa859001,0xfb52b008}},	//   限界, 光緒, 可改, 失点
  { {0xfa5c8006,0xf8476005,0xf943300a,0xf949f00a}},	//   的意, 士一, 程前, 美形
  { {0xfb786008,0xf826600a,0xfb5d900c,0x00000003}},	//   稜線, 和也, 靠站,
  { {0xf9109004,0xfb553005,0xf93a700c,0xfa530005}},	//   由商, 任美, 況分, 法援
  { {0xfa570001,0xfa6f200c,0xf5a50002,0xf91f700d}},	//   距教, 該注, 服者, 院参
  { {0xf912100b,0xf48e3009,0xfa883008,0xf926100c}},	//   放射, 色食, 用条, 佩岑
  { {0xf93bb006,0xf92d9007,0xfa4e800e,0xf9439001}},	//   要在, 子座, 結晶, 合庫
  { {0xf947d005,0x00000003,0x00000003,0x00000003}},	//   小姑,   ,   ,
  { {0xfa656001,0xf910b004,0xfa74000c,0xfa7b1005}},	//   益捐, 鹿城, 槽洗, 淤泥
  { {0xf823e004,0xfa853001,0xfa79f00c,0xfa4bc00c}},	//   告上, 央法, 伸港, 間比
  { {0xfa7d3009,0xf930b001,0xf59bc00c,0x00000003}},	// [750] 性法, 雕塑, 持身,
  { {0xf5cb2007,0xf92c7001,0xf931700c,0xf5b3c00c}},	//   質調, 我吃, 四局, 能耐
  { {0xf4a0100c,0xf92db005,0xf921f005,0xf93bb00d}},	//   正里, 科在, 那只, 禁在
  { {0xf4bc9009,0xf82b0001,0xf48df001,0xfb613004}},	//   市道, 件代, 防通, 院第
  { {0xf8364006,0xfb743001,0xfa5b6001,0xf937300c}},	//   人不, 料科, 私法, 停刊
  { {0xfa700001,0xf9157008,0xf912b004,0xf8202005}},	//   到期, 去問, 西公, 内交
  { {0xf5c5c009,0xfa6bc001,0xf48af004,0xf48dd00c}},	//   用菌, 制汽, 海青, 場週
  { {0xf90ef00c,0xfa64e00c,0x00000003,0x00000003}},	//   念念, 立措,   ,
  { {0xf90df005,0xfb691005,0xf9125005,0xfa4d0005}},	//   水号, 猫猫, 花垣, 黑洞
  { {0xf59a4009,0xf5a74001,0x00000003,0x00000003}},	//   要考, 籍調,   ,
  { {0xf5c1a009,0xfa869007,0xf4c2d001,0xf919d001}},	//   本要, 種方, 泉飯, 貸利
  { {0xf90f900f,0xfb4c1007,0xf5c2a00c,0xfb6b900c}},	//   新娘, 買給, 業解, 酒管
  { {0xf90a7009,0xf4ca1007,0xfb565004,0xf9473004}},	//   其在, 城邦, 建美, 量元
  { {0xf942b001,0xf5c64004,0xf936500c,0xf80c8005}},	//   合婚, 在考, 生字, 笑了
  { {0xfb762008,0xf9399004,0xf9353005,0x00000003}},	//   留米, 要合, 生各,
  { {0xf4a7b001,0xf58c4001,0x00000003,0x00000003}},	//   庫集, 科考,   ,
  { {0xfa5da00c,0xf947d00d,0x00000003,0x00000003}},	// [760] 係採, 鼎城,   ,
  { {0xfa62e007,0xf5b96007,0xfa67400c,0xfa55000c}},	//   下拉, 日行, 反攻, 線方
  { {0xf4b93009,0xfa6f400e,0xf5b82004,0xf81b0008}},	//   芝麻, 議所, 出路, 最中
  { {0xf9231009,0xfa662004,0xf5ace005,0x00000003}},	//   是市, 名或, 海英,
  { {0xf8254006,0xf5a1c004,0x00000003,0x00000003}},	//   之中, 将追,   ,
  { {0xfa5c6007,0xf935100a,0xf844000d,0x00000003}},	//   的植, 牟婁, 旬以,
  { {0xfa5ea007,0xf925d009,0xf93d1009,0xfb493001}},	//   分泌, 在同, 如在, 島的
  { {0xf911b006,0xfa50a007,0xf91ff001,0xf92bf00d}},	//   走出, 動感, 既定, 析原
  { {0xf4c31007,0xf91ed001,0xfb7d6001,0xfa85900c}},	//   手鍊, 性命, 的租, 可方
  { {0xf8476009,0xf5940004,0xf935b004,0xfb553004}},	//   周五, 会表, 写入, 鼻炎
  { {0xfb59d006,0xfa71800f,0xfb589004,0xfb657004}},	//   常用, 新春, 核病, 港特
  { {0xf9189007,0xf919b009,0xf927b009,0xf5bfc007}},	//   人加, 以市, 部在, 面談
  { {0xf935f004,0xfa787005,0x00000003,0x00000003}},	//   虞市, 点投,   ,
  { {0xf93db009,0xf5a7e004,0xf4abd001,0xf944f00c}},	//   的姓, 上致, 暑開, 看哪
  { {0xf912700f,0xf5a98001,0x00000003,0x00000003}},	//   到家, 荷葉,   ,
  { {0xf825e004,0xfa620005,0xf4b5500c,0x00000003}},	//   届世, 商新, 期順,
  { {0xfa656004,0xf9403004,0xf80a0005,0x00000003}},	// [770] 益提, 超常, 酒会,
  { {0xfb7dc009,0xfa670004,0xf8282004,0x00000003}},	//   考研, 同或, 行交,
  { {0xfb50300e,0xfb755005,0xf919100c,0x00000003}},	//   由紀, 定社, 層分,
  { {0xfa604009,0xf59ea009,0xf92c3001,0xfa514004}},	//   崇文, 概述, 休市, 洗浴
  { {0xf5c7a007,0xfb601007,0xf49e1004,0xfb5e700c}},	//   末考, 業版, 大麦, 員約
  { {0xf9147004,0xfb603008,0xf4c1900a,0xf936b00c}},	//   好公, 設等, 扇風, 烘培
  { {0xf940300f,0xf838600b,0xf9421009,0xf8362008}},	//   商店, 人中, 分地, 格交
  { {0xf5a7a001,0xfa526005,0xf5bc0005,0x00000003}},	//   行設, 定明, 接警,
  { {0xf81d600f,0xf9197004,0xfb585004,0xf92bf004}},	//   超低, 人平, 人独, 村富
  { {0xf82ec009,0xfa65e00e,0xfb531004,0xf48f5005}},	//   走上, 開日, 山石, 地黄
  { {0xf93dd006,0xfa62e006,0xfa664004,0xf4b7900a}},	//   境外, 立案, 把本, 丘陵
  { {0xfb7bc004,0xfb691005,0xf5b5c005,0x00000003}},	//   市禅, 用石, 落花,
  { {0xfa7ed001,0xfa5e6005,0xf4a4f00a,0xf9271005}},	//   因斯, 心正, 本郵, 置就
  { {0xf91d7006,0xf847a00b,0xfb7e0008,0xf9259004}},	//   浦区, 風俗, 久留, 部合
  { {0xf919b00f,0xf92a7004,0xfa831004,0xf916d00c}},	//   特別, 体参, 路清, 方始
  { {0xf4c2b009,0xf92a7005,0xfb63700c,0xfa650005}},	//   很高, 当参, 息率, 王洪
  { {0xfa5aa00f,0xf4c1d001,0xf9435008,0xf591000c}},	// [780] 最末, 效降, 立小, 引自
  { {0xfa598001,0xf820e001,0xf9203004,0xf595a001}},	//   作息, 光事, 面功, 食補
  { {0xfa7bb001,0xfa65c005,0xfa78b005,0x00000003}},	//   入探, 前村, 竹木,
  { {0xf5a0e009,0xf9225007,0xfb651001,0x00000003}},	//   文苑, 馬力, 利積,
  { {0xf93df009,0xf5c0c004,0xfa640005,0x00000003}},	//   元化, 中考, 上按,
  { {0xfa83f004,0xf81f2001,0xfa622001,0xfa82f00a}},	//   中段, 億人, 等我, 中澤
  { {0xfa642009,0xf5a98008,0xf9281001,0xfb5e500c}},	//   不按, 小西, 火力, 大稻
  { {0xf92d1009,0xfa75a007,0xfb838001,0xf594600c}},	//   村土, 活情, 有照, 域計
  { {0xf9433004,0xf4aaf004,0xf5afc00c,0xfa654005}},	//   切地, 当通, 山背, 希拉
  { {0xfb58300f,0xf83d2007,0xf595c008,0xf919b00c}},	//   建置, 入侵, 舞踏, 出其
  { {0xfb567004,0xf83f8004,0xf5b20004,0xf4955001}},	//   出突, 止一, 汰落, 費送
  { {0xf5bac001,0xf930100c,0xf91dd005,0xf490300c}},	//   芸芸, 塔塔, 度好, 色都
  { {0xfa652005,0xfa54a005,0x00000003,0x00000003}},	//   把思, 料或,   ,
  { {0xf914500f,0xfa578007,0xf8218001,0xf918700c}},	//   房家, 府服, 等了, 人客
  { {0xfa4dc008,0xfa4b6004,0xf90c5001,0xf916d005}},	//   化機, 当提, 海基, 出切
  { {0xf5ac0001,0xfa750004,0xf90b500c,0x00000003}},	//   年薔, 放数, 海倫,
  { {0xf909f009,0xfa71600e,0xf9453004,0xf9397001}},	// [790] 康市, 調教, 半夜, 門商
  { {0xf947d009,0xf921f004,0xf843a005,0xfa738005}},	//   税前, 索出, 灯会, 白果
  { {0xf82fa009,0xf5c54001,0x00000003,0x00000003}},	//   新供, 皮質,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf931f006,0xfb808004,0xf939f001,0xfb83a00a}},	//   通告, 了用, 勝地, 争点
  { {0xfa67200f,0xf9137005,0xfa57a00d,0x00000003}},	//   上書, 款外, 真核,
  { {0xfa57a009,0xf9483004,0xf5c0a001,0xfb5c5002}},	//   作意, 小店, 席裁, 以穿
  { {0xfb527004,0xf9387004,0xf9301004,0xf9441005}},	//   声称, 州出, 志学, 不很
  { {0xf8406001,0xf9423005,0xfa7d9005,0x00000003}},	//   正一, 密地, 模效,
  { {0xf8128009,0xf923f00e,0xf9473008,0xf817c008}},	//   定一, 諮問, 和彩, 速乾
  { {0xf5c0c004,0xf83aa005,0xf945d005,0xfb735010}},	//   峡西, 交中, 克大, 煙突
  { {0xf48f7004,0xf8308001,0xfa6dc001,0xfa52a00c}},	//   地集, 異世, 鳴曲, 站消
  { {0xf58f0008,0xf9287002,0x00000003,0x00000003}},	//   街角, 助地,   ,
  { {0xf941500b,0xf83ac006,0xf832a009,0xf81b6005}},	//   安心, 度不, 共交, 持体
  { {0xf9179004,0xfa57a001,0xf81ba004,0xf83cc00c}},	//   人当, 借書, 局以, 惠下
  { {0xf934b00f,0xf9119006,0xf820e004,0xf812e004}},	//   料庫, 新区, 光下, 写下
  { {0xf5b42007,0xfb68d00c,0xf49f500a,0x00000003}},	// [7a0] 白質, 器皿, 股間,
  { {0xf92fd006,0xf5c62004,0x00000003,0x00000003}},	//   外国, 在要,   ,
  { {0xf5c56007,0xf9177009,0xf5a5a004,0xfa5ea005}},	//   目表, 缺少, 名近, 待提
  { {0xf90eb006,0xfa65200f,0xf93ad004,0xf90cd00c}},	//   新型, 而有, 品博, 卵子
  { {0xf9109001,0xfa4ec004,0xf5948001,0xf83d6008}},	//   報備, 林果, 機袋, 邦人
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa554004,0xfa86b001,0xf9311005,0xfb7ac00c}},	//   定承, 目格, 宗地, 膜異
  { {0xfb633007,0xf5a4400a,0x00000003,0x00000003}},	//   斯的, 光課,   ,
  { {0xf58cc001,0x00000003,0x00000003,0x00000003}},	//   近距,   ,   ,
  { {0xf93f9007,0xf5b68004,0xf912500c,0x00000003}},	//   的女, 示要, 東加,
  { {0xfb4a9004,0xf93ef001,0xfb687008,0xf82a600c}},	//   年税, 旅展, 秩父, 場介
  { {0xf83a6001,0xf925d008,0xf91d7004,0xf9227004}},	//   以作, 央公, 警句, 院就
  { {0xfa8a9007,0xf4c23004,0xf91dd004,0xf93f3001}},	//   質採, 三道, 性公, 者優
  { {0xfb61b006,0xf593e009,0xf821c001,0xfa70200c}},	//   解答, 会自, 先下, 課方
  { {0xfa5fa006,0xf81dc009,0xf4bf9001,0xf4bb1008}},	//   包括, 担一, 超連, 退院
  { {0xf5a42001,0xfa7a000d,0x00000003,0x00000003}},	//   閉詳, 工文,   ,
  { {0xf5a58008,0xfa65e00c,0xf93cb005,0xf840a005}},	// [7b0] 前菜, 再打, 品区, 客体
  { {0xf9267006,0xfa570008,0xf5c22001,0xf82c400a}},	//   注射, 官房, 波西, 買主
  { {0xf5a3a001,0xfa742001,0xf9289005,0x00000003}},	//   下者, 政新, 物家,
  { {0xf90c700f,0xf946f004,0xf9313005,0xf925d010}},	//   海岸, 上医, 抗冰, 貨屋
  { {0xf94a1006,0xfb84e00a,0xf832200a,0xf945d002}},	//   小康, 上率, 東中, 才子
  { {0xf4be9005,0x00000003,0x00000003,0x00000003}},	//   内食,   ,   ,
  { {0xf5970004,0xf924f004,0xf913300c,0x00000003}},	//   思茅, 是形, 東平,
  { {0xf4b83007,0xf597200c,0x00000003,0x00000003}},	//   障通, 果車,   ,
  { {0xf91ef004,0xf4af1004,0xf49b3005,0xf919500c}},	//   造公, 金都, 亥革, 司媒
  { {0xf9473006,0xf82a8009,0xf5bc0004,0xfa829008}},	//   不容, 年不, 大考, 波新
  { {0xf9205006,0xfa5ea004,0xf944100a,0xf58d2005}},	//   占地, 求新, 上告, 体落
  { {0xf90c5001,0xf934d001,0x00000003,0x00000003}},	//   護履, 魚座,   ,
  { {0xf4b37006,0xf936d009,0xf92a1009,0xf9267001}},	//   通道, 期公, 青川, 義店
  { {0xf9207004,0xfb76b001,0xf927d005,0x00000003}},	//   卡卡, 原物, 在差,
  { {0xf91b9004,0xf59f2001,0xf5a0c00c,0x00000003}},	//   以形, 心能, 草草,
  { {0xf83ce009,0xf5a0c007,0xf8232001,0xfb6e700a}},	//   度中, 情色, 腋下, 金無
  { {0xfa7f1008,0xfa6fc00c,0xf832e005,0xfa5e0005}},	// [7c0] 財源, 想投, 板中, 病故
  { {0xf4bc3009,0xfb852001,0xfa893001,0xf93ab005}},	//   老院, 益生, 航機, 品存
  { {0xf4b1700e,0x00000003,0x00000003,0x00000003}},	//   肛門,   ,   ,
  { {0xfa5bc006,0xf946b009,0xfa740004,0xf81de004}},	//   品推, 牌子, 好抗, 求以
  { {0xf5a4c007,0xf8352008,0xf93a9004,0xfa5ae005}},	//   上者, 施主, 要写, 仁果
  { {0xfa7ef00e,0xf827200a,0xfa66c00d,0x00000003}},	//   次期, 再交, 告急,
  { {0xfa66e006,0xf92f7009,0xf8150004,0xf90fb005}},	//   同比, 民兵, 星企, 新做
  { {0xf4ae3001,0xfb72900c,0x00000003,0x00000003}},	//   店集, 投社,   ,
  { {0xf938f00f,0xf5c0a009,0xf8138009,0xfb67b009}},	//   回報, 中要, 余万, 在用
  { {0xf8344009,0xf92b100c,0x00000003,0x00000003}},	//   放以, 間多,   ,
  { {0xfa784001,0xf90e1001,0xf5bbe00c,0xf821e005}},	//   刻板, 女同, 大裁, 震中
  { {0xf927d00f,0xf5a6a008,0xfa899005,0x00000003}},	//   優先, 再設, 骨架,
  { {0xf940f005,0xfa716005,0xf9373010,0x00000003}},	//   率增, 由拒, 江古,
  { {0xf5b22008,0xf93b900c,0xfa672002,0x00000003}},	//   己負, 局勤, 和您,
  { {0xfb7f8001,0xf49ab008,0xf9119001,0xfa73000c}},	//   升等, 日限, 音山, 命故
  { {0xf939d005,0xfb6d9005,0xf9161005,0xf5b8200a}},	//   保康, 北等, 国兵, 治製
  { {0xf4c47001,0xf90cd004,0xf821e005,0x00000003}},	// [7d0] 下道, 年加, 月不,
  { {0xf5bc0006,0xfa77c007,0xf4c69004,0xf9465004}},	//   接触, 常有, 行食, 鞋帽
  { {0xf5a06001,0xf919b001,0xf8320005,0xf943300c}},	//   必能, 空地, 款一, 載加
  { {0xfa4fe008,0xfa61e004,0xfa82d004,0xf5a84005}},	//   北本, 升本, 索更, 住自
  { {0xf4af100c,0xf49c700c,0x00000003,0x00000003}},	//   五集, 步都,   ,
  { {0xf914100a,0x00000003,0x00000003,0x00000003}},	//   兼務,   ,   ,
  { {0xf9167004,0xfb789001,0xfa4d400c,0x00000003}},	//   任姓, 作祟, 我我,
  { {0xf90c300f,0xf9471009,0xf9207004,0xfa8b1004}},	//   水庫, 不去, 代市, 剪板
  { {0xf9355001,0xf949700a,0xf49a300c,0xfa52a00d}},	//   生分, 意工, 查高, 投洽
  { {0xf80f2004,0xf9329004,0xf9383004,0xf934f001}},	//   他信, 会市, 属学, 線基
  { {0xf917f00c,0xfa84b00c,0xf944100d,0x00000003}},	//   傻傻, 助消, 不屈,
  { {0xf82ca006,0xfa766007,0xf92a9009,0xfb707005}},	//   年中, 出最, 易市, 首破
  { {0xf590a008,0xf9261004,0x00000003,0x00000003}},	//   動詞, 景山,   ,
  { {0xf90db009,0xf9215009,0xfa68c004,0xf9481004}},	//   年平, 本完, 界新, 配制
  { {0xf80ca001,0x00000003,0x00000003,0x00000003}},	//   我了,   ,   ,
  { {0xf94af006,0xfa7fd00e,0xfb6b3004,0xf497100c}},	//   美女, 加湿, 体生, 空飛
  { {0xf83ba007,0xfa80900a,0xf497b00a,0xf4bdd010}},	// [7e0] 座位, 素朴, 陸運, 久雄
  { {0xfb56f007,0xfa50a004,0xfa71c004,0xf817400a}},	//   容積, 何提, 跳水, 膜下
  { {0xf81b2006,0xf9265006,0xf4c59009,0xf830e009}},	//   一中, 壮大, 上道, 使企
  { {0xf91b5009,0xf93d1004,0xf8296005,0xfa73800c}},	//   入全, 蓄存, 藏主, 調方
  { {0xf91b900e,0xf595a009,0xf91cb009,0xf947b009}},	//   大和, 属行, 惠及, 明城
  { {0xf5a96001,0xfa790001,0xf924d001,0xfa5f4004}},	//   低自, 券期, 可可, 理文
  { {0xf936f006,0xf92e1004,0xf90ff001,0xf937f00c}},	//   保密, 他当, 地原, 保志
  { {0xfa59a00f,0xfa4de007,0xfa516004,0xf9411004}},	//   作業, 休息, 力明, 商学
  { {0xf8382009,0xf829600c,0xf91c3005,0x00000003}},	//   常住, 族主, 日建,
  { {0xf9483004,0xf93a300c,0xf49dd005,0x00000003}},	//   行健, 停役, 学都,
  { {0xfb85e00f,0xfa67c009,0x00000003,0x00000003}},	//   介紹, 漏洞,   ,
  { {0xf4a6100b,0xf5aec004,0xfa53600c,0x00000003}},	//   部門, 葵花, 供正,
  { {0xfa58c00b,0xf9433009,0xf5bc000c,0x00000003}},	//   作成, 文号, 大胃,
  { {0xfb4ff008,0xfb860005,0xf497d005,0xfa5ce00c}},	//   帳票, 床用, 相配, 送書
  { {0xf82a800a,0xf9369005,0xfa7ce002,0x00000003}},	//   年位, 神力, 入深,
  { {0xfb623004,0xfa5dc004,0x00000003,0x00000003}},	//   中用, 射源,   ,
  { {0xf935b00f,0xfb593009,0xf92d9001,0xf9457005}},	// [7f0] 定地, 区社, 店後, 双倍
  { {0xf4c5700b,0xfb78300c,0xf948f00c,0x00000003}},	//   構造, 感細, 里家,
  { {0xf59e8006,0xf8240009,0xf5c94004,0x00000003}},	//   商行, 月中, 在走,
  { {0xfb6cf006,0xfb59f006,0xf82e2004,0xf948b004}},	//   成犯, 日的, 平不, 明原
  { {0xf94a5004,0xf944b001,0xf4ab7008,0xf944f005}},	//   意其, 消基, 間限, 月国
  { {0xf819000f,0xfa82f006,0xf90b7004,0xf4c09005}},	//   一位, 支持, 海天, 内都
  { {0xf838e007,0xf82f2001,0xfa7c6005,0xfb50900d}},	//   司保, 到什, 接方, 鹿牌
  { {0xfb85200e,0xf8146004,0xf8210001,0x00000003}},	//   律第, 多中, 有位,
  { {0xf9105009,0xf90ff001,0xfa4f8008,0x00000003}},	//   山庄, 地借, 聖書,
  { {0xf9355009,0xfa70c007,0xf4c6b008,0xfb64b004}},	//   多国, 已收, 和酒, 普生
  { {0xf90ef001,0xf940300a,0xf59ca00a,0x00000003}},	//   細名, 棄却, 老若,
  { {0xf828800c,0x00000003,0x00000003,0x00000003}},	//   其事,   ,   ,
  { {0xf90fb001,0xfb5e9004,0xf8176001,0xfa66000c}},	//   報刊, 性特, 生任, 及注
  { {0xf922700f,0xf5bbe004,0xfb757001,0xf934300c}},	//   本土, 大要, 料符, 記問
  { {0xfb7cb00f,0xf91d5001,0xf8478004,0xfb6fb005}},	//   吃的, 因各, 用他, 或百
  { {0xf4aaf009,0xfa740009,0xfb52f00c,0xfa78c00c}},	//   子里, 能投, 尾科, 此所

  { {0xfa5ee001,0xfb63100d,0x00000003,0x00000003}},	// [800] 分所, 中移,   ,
  { {0xfa524007,0xf90c900a,0x00000003,0x00000003}},	//   誕樹, 偵察,   ,
  { {0xf8354004,0xfb7bd00c,0x00000003,0x00000003}},	//   都人, 一睹,   ,
  { {0xfa5d2004,0xfb6f900c,0xf8332005,0xf90bd005}},	//   市温, 北火, 国万, 年当
  { {0xf5c5e001,0xf5a4400c,0xf935900c,0x00000003}},	//   笨蛋, 手膜, 願委,
  { {0xf4af900f,0xf917b004,0xf80d6001,0xf838e00c}},	//   南部, 核合, 近五, 司依
  { {0xfb5c100f,0xf9131004,0xf4be7001,0xf5b8a00a}},	//   日盤, 使学, 逃離, 常資
  { {0xf9491006,0xf91e7004,0xfa5f8004,0xf92df005}},	//   小学, 信分, 心新, 他向
  { {0xf91df00f,0xf9151001,0xf942b00c,0xf91bf005}},	//   員名, 彼得, 合多, 度向
  { {0xf5b94007,0xfb49d004,0xf8118001,0xf9151004}},	//   別載, 件生, 力一, 妻双
  { {0xf9407004,0xfa4c0005,0xf93ab00a,0x00000003}},	//   理利, 源搜, 紀夫,
  { {0xfb84a004,0xfb779004,0xf9461001,0xfb689005}},	//   予登, 土特, 行充, 在登
  { {0xf92b5004,0xf5c46008,0xfb697010,0xf4be7010}},	//   成千, 華街, 快眠, 集運
  { {0xfa800007,0xf5a7000c,0x00000003,0x00000003}},	//   信業, 車船,   ,
  { {0xf91d5009,0xf93db005,0xfa79800c,0xfa4c800c}},	//   警大, 心店, 查服, 習曲
  { {0xfb787001,0xf82fc00c,0xfa798002,0x00000003}},	//   障生, 報事, 知服,
  { {0xfb5ff004,0xf9227004,0xf81ec005,0xf489f00c}},	// [810] 探秘, 本域, 心以, 然間
  { {0xf942f007,0xf4a85007,0xf9207001,0xf4c8900c}},	//   篇已, 質量, 形塑, 行都
  { {0xfa5f2007,0xfa784005,0xf5a6800c,0xf910d005}},	//   考書, 交涉, 小行, 岳区
  { {0xf939d00c,0xf91d5005,0x00000003,0x00000003}},	//   保德, 武大,   ,
  { {0xfa5da006,0xf81e4004,0xf91e300c,0x00000003}},	//   的提, 七中, 試地,
  { {0xf92f9008,0xf8442005,0xf81e4005,0xfb88e00c}},	//   金制, 催人, 布中, 行環
  { {0xf4909001,0xf91cd001,0xf4af7001,0xf9123004}},	//   便配, 座向, 村長, 能很
  { {0xf9115001,0xfb87e001,0xf841200c,0xf937500c}},	//   平平, 行無, 代作, 棟別
  { {0xf4c23007,0xf91d100c,0x00000003,0x00000003}},	//   贈送, 別家,   ,
  { {0xf8256009,0xf5c3c004,0xf8376001,0xf91d9004}},	//   事代, 中走, 任代, 大差
  { {0xfa4c4007,0xfa4ec00c,0x00000003,0x00000003}},	//   我最, 託機,   ,
  { {0xfa68a009,0xf93b900a,0x00000003,0x00000003}},	//   式是, 退去,   ,
  { {0xfb52f009,0xf9433009,0xf90f1001,0xf9461004}},	//   尿素, 很少, 細小, 行内
  { {0xfb74d001,0xf9313001,0x00000003,0x00000003}},	//   娘秘, 望同,   ,
  { {0xf9401009,0xfa4fc001,0xfa73a008,0xf5c34005}},	//   内大, 比我, 百景, 散落
  { {0xfa648004,0xfa6ec004,0x00000003,0x00000003}},	//   位描, 育林,   ,
  { {0xfa6f600f,0xf80bc004,0xfa76000c,0xfa5aa005}},	// [820] 農業, 当他, 呼日, 血汗
  { {0xf92dd007,0xf82a4007,0xf919b004,0xf910b001}},	//   取回, 長久, 方区, 曲張
  { {0xf9385009,0xfa6ea009,0xf938d004,0xf9229001}},	//   增大, 育法, 保学, 形報
  { {0xf9187001,0xf91b7004,0xfa87b001,0xfa734005}},	//   人夢, 健壮, 推推, 就新
  { {0xf48f9009,0xfb4c3004,0xf925d004,0xfb5d7004}},	//   想道, 其父, 在完, 大用
  { {0xf916d001,0x00000003,0x00000003,0x00000003}},	//   方型,   ,   ,
  { {0xf948f004,0xfa6be004,0xfb860004,0xfa606001}},	//   每季, 水排, 立相, 者書
  { {0xf4b7f004,0x00000003,0x00000003,0x00000003}},	//   神面,   ,   ,
  { {0xf818400e,0xf930f007,0xfa520007,0xf845c00e}},	//   回以, 法受, 法接, 部下
  { {0xf918700f,0xf90a7004,0xfa4c0001,0xf91d700c}},	//   書分, 收利, 秒殺, 給出
  { {0xfa5ca009,0xf5afe007,0xf843a004,0xf81fa005}},	//   品添, 由行, 京中, 万不
  { {0xf829a001,0x00000003,0x00000003,0x00000003}},	//   具下,   ,   ,
  { {0xf9347004,0xfb4ff001,0xf930f004,0xf924b005}},	//   会形, 女用, 得失, 京平
  { {0xf5964004,0xf494b001,0xf93cb004,0x00000003}},	//   保行, 能面, 送去,
  { {0xfa859009,0xfa66a007,0xf942d004,0xf926d004}},	//   在有, 里民, 吉利, 温差
  { {0xfa566009,0xf9319002,0x00000003,0x00000003}},	//   生殖, 力十,   ,
  { {0xfa714009,0xfb6ad007,0xfb57d007,0xf92eb004}},	// [830] 声波, 未登, 活空, 向区
  { {0xf929d007,0xf58e8004,0xf9259001,0xf5a5400c}},	//   自取, 他表, 全又, 袋設
  { {0xf9139007,0xf59c4009,0xfa5fe007,0xfb4e5008}},	//   政司, 的背, 篇所, 即納
  { {0xfa82a006,0xfa762007,0xfb82300e,0xfa5f0001}},	//   公民, 人手, 喉科, 密技
  { {0xf5ca200f,0xf810800e,0xf92bd004,0xf81f0001}},	//   優良, 途中, 向型, 待他
  { {0xfb5c3004,0xf499b001,0xfa792005,0xf92ab005}},	//   奥特, 日送, 相成, 被其
  { {0xf946300f,0xf590200e,0xfb89c007,0xf8404001}},	//   配取, 五輪, 小米, 搭上
  { {0xfb83a001,0xf4a6f004,0xfa66800c,0xfa76000c}},	//   有系, 用非, 屋新, 示有
  { {0xf91cb004,0xfa87500c,0xf9155005,0x00000003}},	//   以共, 士技, 能容,
  { {0xfa5cc008,0xfa871008,0xf4ba1001,0xfb50500a}},	//   品改, 用材, 菜鳥, 右端
  { {0xf9481009,0xf93c1001,0x00000003,0x00000003}},	//   行大, 一命,   ,
  { {0xf92ed009,0xf5bba001,0xfa5f4004,0xf92bd00c}},	//   外公, 入設, 理指, 棒大
  { {0xf943b009,0xf9117007,0xfa7d2008,0xfb6c7004}},	//   合利, 山北, 撥水, 疑的
  { {0xfa65c009,0xfb789005,0xf93a500a,0x00000003}},	//   告或, 作真, 節子,
  { {0xf5974007,0xf9375004,0xfa576004,0xfb4d9004}},	//   州街, 生室, 生来, 色球
  { {0xfa510009,0xfa4fc004,0xf4a3300c,0xfb5b900c}},	//   得新, 林景, 季都, 查第
  { {0xf48ef006,0xf9347009,0xf5afe009,0xf49a5009}},	// [840] 数量, 佛山, 害虫, 知通
  { {0xf59cc004,0x00000003,0x00000003,0x00000003}},	//   考者,   ,   ,
  { {0xf58ee001,0xfa68c00c,0xfa88500c,0xf81a000c}},	//   達者, 家歌, 被我, 要住
  { {0xf9431009,0xf5bb4004,0xf93db001,0xf5b18004}},	//   切割, 度超, 心志, 放行
  { {0xf93d9009,0xf926f004,0xfb761001,0xfa5fe005}},	//   的少, 在土, 食習, 分村
  { {0xf825600f,0xf91bb004,0xf932f001,0xf911100c}},	//   行事, 性同, 投地, 誰可
  { {0xf8336006,0xfa632001,0xf8460008,0xfa51a00c}},	//   都会, 事服, 在住, 拔河
  { {0xf918b00e,0xf8336009,0xfb4d9004,0xf927f005}},	//   古品, 能会, 更申, 洪安
  { {0xf90d3004,0xf9291005,0xfb7bb00c,0xf917d002}},	//   号地, 浪博, 需特, 方做
  { {0xf9281009,0xfb6d7007,0xfb66f001,0xf9445001}},	//   未完, 託等, 微米, 車城
  { {0xf9119007,0xfb76b007,0xf5b6c001,0xf9123004}},	//   新出, 衝突, 值走, 命安
  { {0xf82b600f,0xfa7e4008,0xf819a008,0xfa63e001}},	//   然人, 信濃, 夜中, 安政
  { {0xf4a37009,0xfa66e004,0xf90ad005,0xf821c00d}},	//   是高, 小流, 年如, 万中
  { {0xf5bd0009,0xf9117007,0xf4c83001,0xfa67c001}},	//   以赴, 山南, 後遺, 籍新
  { {0xf5bde00b,0xf845c00b,0xf4ac9009,0xf942b004}},	//   大臣, 部例, 村集, 万国
  { {0xf939b006,0xfa4de004,0xfa660004,0xf5990001}},	//   要及, 南明, 同文, 賞花
  { {0xfb7bb008,0xf5a2a001,0xf839c00c,0xfb64b005}},	// [850] 終的, 載表, 惹人, 景目
  { {0xfb689009,0xf5aa6009,0xf91fb004,0xfb4e500c}},	//   全知, 水行, 校在, 仲生
  { {0xf9329001,0xf944900c,0x00000003,0x00000003}},	//   香奈, 把心,   ,
  { {0xfa86f004,0xfa77e005,0x00000003,0x00000003}},	//   物普, 区未,   ,
  { {0xf49a1009,0xf5900007,0xf937d004,0xf5b66004}},	//   以高, 違者, 作参, 尼西
  { {0xfb72100f,0xf82a0001,0xf926d001,0xf92bb004}},	//   研究, 家休, 注定, 科及
  { {0xf821e006,0xf9293004,0xfa5be005,0xf4bed00c}},	//   案例, 青城, 一核, 久違
  { {0xf5a7a00e,0xfa80200a,0x00000003,0x00000003}},	//   美肌, 席有,   ,
  { {0xfb82500f,0xf9199006,0xfb4c5001,0xf59d6004}},	//   合的, 特大, 海空, 的跟
  { {0xf4a3d00a,0xfa644002,0x00000003,0x00000003}},	//   本邦, 床服,   ,
  { {0xfb4c1001,0xf816c001,0xf93d5005,0xf9237005}},	//   場研, 願人, 者吊, 良宇
  { {0xf93cb006,0xfa4b6004,0xf9363004,0xfb677004}},	//   品出, 体材, 回密, 墨盒
  { {0xfb83f004,0xfb4ed001,0xf591200c,0xfb55900c}},	//   安社, 細紋, 四行, 幼犬
  { {0xfb87000a,0xfa706005,0x00000003,0x00000003}},	//   不祥, 鹿泉,   ,
  { {0xf9125001,0xf5912001,0xfa50200a,0xf92ff00c}},	//   仰山, 盛行, 桔梗, 法商
  { {0xfa5dc005,0xf5ab0005,0x00000003,0x00000003}},	//   元投, 年超,   ,
  { {0xf8230006,0xf934b009,0xf9451007,0xf4c55001}},	// [860] 三中, 力地, 授兼, 里里
  { {0xfa4ec00f,0xf94a1004,0xfb535005,0xf91c7010}},	//   取本, 小巷, 西移, 工呼
  { {0xf943f009,0xf9199001,0xfa526005,0xf90bf00a}},	//   三国, 除契, 会意, 直列
  { {0xfa58c007,0xf81f0009,0xfb55b009,0xf8256009}},	//   作提, 元人, 国石, 行下
  { {0xfa4f0004,0x00000003,0x00000003,0x00000003}},	//   得拒,   ,   ,
  { {0xf915d00c,0xfb507005,0x00000003,0x00000003}},	//   治官, 米糠,   ,
  { {0xf93fb006,0xfa76200c,0xfa7ba005,0x00000003}},	//   的就, 命更, 春播,
  { {0xf5a4c001,0xfa5b2004,0xf948d001,0xfb521005}},	//   介質, 十期, 後山, 花灯
  { {0xf8336006,0xfa650007,0xf922b008,0xf9207004}},	//   格下, 請注, 季大, 宣威
  { {0xf922b007,0xfb77f004,0xf9461001,0xfa80400a}},	//   正大, 生石, 里崇, 信条
  { {0xf93cb006,0xf90d500f,0xf9455007,0xf91b5005}},	//   境内, 防局, 車借, 入在
  { {0xf941700b,0xfa85e001,0xfb73f005,0x00000003}},	//   文庫, 修業, 余生,
  { {0xf9189007,0xf91c7009,0xfa4ee00c,0x00000003}},	//   人因, 学化, 抗感,
  { {0xfa628007,0xfa50c008,0xfa82a00c,0xfa7ea00d}},	//   合指, 南房, 可把, 素或
  { {0xf9199006,0xfb4ab00e,0xfb77d008,0xf90b500c}},	//   区地, 件目, 功績, 極富
  { {0xfb872007,0xf5a5e008,0xf5bc2005,0x00000003}},	//   服系, 車輪, 性胃,
  { {0xf8144004,0xfb4fb00c,0x00000003,0x00000003}},	// [870] 通中, 己看,   ,
  { {0xf82fe00f,0xf90e9009,0xf80e0001,0xfb59d005}},	//   共事, 新安, 南一, 泥的
  { {0xfa7e0005,0xf93ad002,0x00000003,0x00000003}},	//   次明, 作影,   ,
  { {0xf820e009,0xf5b24004,0xfa4fe004,0xfa752004}},	//   三位, 使自, 受本, 施日
  { {0xf8244009,0xf5a3000e,0xf9473004,0x00000003}},	//   上不, 型車, 同利,
  { {0xf93ff006,0xfb57700c,0xfa67400a,0xf92cb002}},	//   分子, 出結, 族旅, 世和
  { {0xfa548004,0xf5966004,0xfb86900c,0xf91fb005}},	//   供新, 域自, 後生, 校周
  { {0xfb573001,0xfa6c2001,0xfb5a9004,0xf947300d}},	//   任第, 冷漠, 春生, 名建
  { {0xfa806001,0xf93f3005,0xf931b00c,0x00000003}},	//   客機, 内化, 四億,
  { {0xfa88100f,0xf5c16008,0xf913f008,0xfa77400a}},	//   用正, 公認, 国展, 特技
  { {0xf948f00b,0xf8314007,0xfa528009,0xfb709008}},	//   美少, 到你, 定所, 法科
  { {0xfa87200f,0xf4be700f,0xf93ed004,0xf8432004}},	//   全民, 故障, 境入, 是促
  { {0xf5a86007,0xfb5cf008,0xf5a90001,0x00000003}},	//   茶葉, 加納, 而致,
  { {0xfa71e008,0xf918d005,0xf8318005,0xf90f3005}},	//   放流, 交市, 数以, 育公
  { {0xf910900f,0xf9217009,0xf5c04008,0xf9099004}},	//   史地, 信念, 芭蕉, 起名
  { {0xf93e9009,0xfb6b5004,0xfb83f004,0xfa63e00a}},	//   心学, 番石, 看留, 安房
  { {0xfb62300b,0xf9431009,0xf5bc0004,0xfa552001}},	// [880] 面白, 有公, 性要, 記機
  { {0xf9243004,0xfa7fe005,0x00000003,0x00000003}},	//   售商, 次普,   ,
  { {0xf939b006,0xfb84f009,0xf919300e,0xfb613001}},	//   品安, 名的, 日光, 代租
  { {0xf839c009,0xf8122007,0xf5ade00e,0xf8152004}},	//   以促, 通位, 防衛, 候中
  { {0xf9263007,0xf81c0001,0xf92b5008,0xf8254005}},	//   可到, 境介, 成元, 下中
  { {0xf9481004,0xf9461004,0xf914f005,0x00000003}},	//   同建, 行必, 嚼字,
  { {0xf947d009,0xf82b2005,0xfa64800c,0xfb4cf005}},	//   式向, 低估, 光海, 液等
  { {0xf920300f,0xf488d00c,0xfa67200d,0x00000003}},	//   連同, 收送, 和木,
  { {0xfa4ca00c,0xf93eb00a,0xfa65c00c,0x00000003}},	//   向教, 境大, 里昂,
  { {0xfb833004,0xfa7e200a,0xf937d00c,0x00000003}},	//   王立, 武東, 真偽,
  { {0xf59c000c,0xf4903005,0x00000003,0x00000003}},	//   心行, 新青,   ,
  { {0xfa7b6009,0xf4ab700e,0xfa6ac001,0xf920900c}},	//   大有, 酒造, 水流, 次別
  { {0xfb7b7004,0xf928b001,0x00000003,0x00000003}},	//   要研, 部役,   ,
  { {0xfa612006,0xfa728009,0xf917b004,0xf9243001}},	//   理性, 新更, 永嘉, 種心
  { {0xf93f9008,0xf9163004,0xfa776005,0xf947300d}},	//   心強, 活塞, 固提, 配工
  { {0xf831c006,0xf91a700f,0xf4a15009,0xf8298009}},	//   共享, 書室, 昭通, 然会
  { {0xfb4ef006,0xf59a8009,0xfb4a5007,0xf48d7001}},	// [890] 地税, 作落, 海灘, 念頭
  { {0xf910d001,0xf91b9001,0xf5b72001,0xfb82b005}},	//   共四, 大富, 她要, 率相
  { {0xfb6d7006,0xfa8b1009,0xf924f001,0xfb81d00c}},	//   科研, 雪松, 般家, 又看
  { {0xf940500b,0xf81c0004,0xf9345004,0xfb4cd00c}},	//   理士, 境事, 多公, 整符
  { {0xf5a28001,0xfb79d005,0xfa55400c,0x00000003}},	//   載自, 持等, 生故,
  { {0xfb77d00c,0xf93fb00c,0xf5bfa00c,0xfa4be00d}},	//   募現, 心呵, 握著, 坐果
  { {0xf591e007,0xf8266004,0xf8324004,0xf844c00c}},	//   研議, 上中, 施上, 種保
  { {0xf910500f,0xf8232008,0xfa652001,0xfb731004}},	//   東市, 下位, 名指, 忙着
  { {0xf491f001,0xf8472001,0xfa5c2004,0xf4b97005}},	//   山頭, 庫位, 持本, 一附
  { {0xf8374007,0xfa630005,0xfa7d000c,0xfa778005}},	//   人作, 之恋, 工水, 方旅
  { {0xfb531007,0xf4c21001,0xf9125005,0xf9375005}},	//   命理, 合送, 台地, 食健
  { {0xf937900c,0xfa51600c,0x00000003,0x00000003}},	//   神巨, 著水,   ,
  { {0xf91db004,0xfb88d00c,0xfa6a6002,0x00000003}},	//   性差, 美生, 崎步,
  { {0xf90bf00c,0xf934900c,0x00000003,0x00000003}},	//   念商, 際報,   ,
  { {0xf59d4004,0xf92d9005,0x00000003,0x00000003}},	//   必行, 金塔,   ,
  { {0xfa58e009,0xf82ee004,0xfb54b001,0xf5a9a001}},	//   一手, 地不, 徽章, 長行
  { {0xfa554004,0xf9383008,0xf91cb005,0xf911d00a}},	// [8a0] 会放, 喜多, 大土, 由利
  { {0xfb50d00f,0xf9379007,0xf59c8004,0xf4c3d005}},	//   細物, 府城, 元老, 型集
  { {0xfa4d0004,0xf9351005,0xf9225005,0x00000003}},	//   源是, 域市, 面平,
  { {0xf93d5006,0xfa52600c,0xf9111005,0x00000003}},	//   市公, 力感, 板市,
  { {0xfa71200f,0xf843c001,0xf82e2008,0xfb747008}},	//   危機, 可保, 哲也, 香織
  { {0xf58c800f,0xf4a7100e,0xf9107001,0xf9491004}},	//   材質, 風速, 山商, 氏度
  { {0xf90ad00e,0xf9359004,0xfb633001,0xfa7b6004}},	//   直径, 会共, 業特, 永新
  { {0xfb5d900e,0xfa4c6007,0xfb4f5007,0xf92ef00a}},	//   性用, 民旅, 米科, 算子
  { {0xf93ad004,0xfa802008,0xfb83300c,0x00000003}},	//   潜山, 設案, 友看,
  { {0xf824400e,0xf9151001,0xfb525001,0xfb7cf001}},	//   上位, 呼叫, 政窗, 約範
  { {0xfb4f5005,0x00000003,0x00000003,0x00000003}},	//   田的,   ,   ,
  { {0xf90e500f,0xfb737009,0xfb4af009,0xf933b004}},	//   兵役, 料的, 致病, 辛勤
  { {0xf918700b,0xfa688009,0xf9489004,0xfa69a004}},	//   人形, 二款, 昌平, 明是
  { {0xf932d004,0xfa4ba00c,0x00000003,0x00000003}},	//   棚内, 打打,   ,
  { {0xfb8ab006,0xfa5e0009,0xf5c16010,0x00000003}},	//   明白, 病情, 臣賞,
  { {0xfa83a007,0xf942d009,0xfa69a001,0xf5aa4001}},	//   可望, 月初, 康服, 整行
  { {0xfa86a004,0xf91ab004,0xf938900c,0xf81fc00a}},	// [8b0] 刮板, 岸区, 府原, 滅亡
  { {0xfa5bc00f,0xf4c5100f,0xf81c0007,0xf93e3004}},	//   品木, 融集, 境下, 布公
  { {0xf918b008,0xfa69e00e,0xf919b004,0xfa6a8004}},	//   特化, 究機, 以参, 李永
  { {0xf8440006,0xfb64d006,0xfa89600f,0xf4a39006}},	//   公交, 是第, 自我, 是通
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb789004,0xf93e5004,0x00000003,0x00000003}},	//   作生, 理光,   ,
  { {0xfb621006,0xf9113004,0xfb755004,0xf926f00c}},	//   本站, 地加, 感病, 含安
  { {0xf822e007,0xf8306005,0xf9301005,0xfb769005}},	//   消保, 圳中, 得学, 期用
  { {0xfa538006,0xf4aa700c,0xf9267005,0xf9469002}},	//   会成, 含防, 浮出, 服公
  { {0xf59f600a,0xfb665005,0x00000003,0x00000003}},	//   境課, 旨的,   ,
  { {0xf93f1009,0xf5a30001,0xfa4b8004,0xf91db004}},	//   密封, 屋行, 易成, 邦国
  { {0xf49a3006,0xfa79a004,0xf9431005,0x00000003}},	//   以通, 方日, 之和,
  { {0xf5c8e009,0xf490f001,0xf93d7008,0xf942500c}},	//   用能, 乳酸, 超小, 安徒
  { {0xfa70c004,0xf5c5c00c,0xf917500c,0x00000003}},	//   地温, 森路, 芹壁,
  { {0xf90ad009,0xfb679007,0xfb5bf008,0xf910d00a}},	//   年市, 早盤, 日給, 河出
  { {0xfa646009,0xfb6f1007,0xf4b2b001,0xf4c3b005}},	//   合性, 民申, 通順, 看附
  { {0xfb7c900e,0xf4a0d005,0xf9437005,0x00000003}},	// [8c0] 品群, 代高, 王宏,
  { {0xf5c5e001,0xfb511001,0xfb4f7004,0x00000003}},	//   全認, 山科, 新理,
  { {0xf9119009,0xf4b2f004,0xfa4b0004,0xf923500c}},	//   新基, 会高, 恒温, 代女
  { {0xf93a3007,0xf916d008,0xf4b75001,0xf9121001}},	//   言回, 丹後, 作開, 地平
  { {0xf90a7009,0xf944f004,0xf4a1f004,0xf93c3005}},	//   家外, 始在, 本集, 市初
  { {0xfa710006,0xfb69b00f,0xf90b7009,0xfb509001}},	//   印本, 棒球, 男士, 冰糖
  { {0xf9319004,0xf9479001,0xf92eb001,0x00000003}},	//   五好, 位女, 金工,
  { {0xf90c5006,0xf9473001,0xfb4b300a,0x00000003}},	//   水利, 行取, 破片,
  { {0xf936b00f,0xf9313009,0xf9261004,0xf4c2b001}},	//   識別, 南地, 是影, 築風
  { {0xfa4e8006,0xf8166004,0xfa64e001,0xf8426005}},	//   民日, 余件, 才求, 代代
  { {0xf8438008,0xf5b1800c,0xf5a0a00d,0x00000003}},	//   浮上, 足護, 分路,
  { {0xf9435004,0xf4a23008,0xf926500a,0xfb6f900c}},	//   安卡, 設部, 修室, 動積
  { {0xf9363009,0xf5a6a009,0xf919b004,0xfa58c005}},	//   属各, 歌舞, 方出, 保模
  { {0xfa668007,0xfb4ff004,0xfb52900c,0xf825c00c}},	//   降息, 育特, 唱盤, 完一
  { {0xfb7bd004,0xfb77f001,0xfa528005,0xf9457005}},	//   一特, 生申, 供排, 戊子
  { {0xf841c00f,0xfa85c009,0xfa7ea001,0xf5a04001}},	//   第一, 置是, 員指, 宅貸
  { {0xf9195007,0xf835c004,0xf910d00a,0xfb4a100c}},	// [8d0] 書展, 死了, 械器, 谷的
  { {0xf4a5f009,0xf830400a,0x00000003,0x00000003}},	//   用量, 英一,   ,
  { {0xfa66400c,0xfa66c005,0x00000003,0x00000003}},	//   伊斯, 富村,   ,
  { {0xfa4fa009,0xf93cb001,0xf826000c,0xf4a1f00a}},	//   救援, 品基, 克人, 本隆
  { {0xf82ee006,0xfa7c8009,0xfa894004,0xf814c004}},	//   地位, 大棚, 用数, 租住
  { {0xfb7e9007,0xf918d005,0xf9475005,0x00000003}},	//   係由, 永定, 量包,
  { {0xf93a7005,0x00000003,0x00000003,0x00000003}},	//   果好,   ,   ,
  { {0xfb64f001,0xfb55b001,0xfa67000d,0x00000003}},	//   可短, 白米, 名控,
  { {0xfa508006,0xfa57600f,0xf9111005,0xfa5bc005}},	//   五是, 生日, 地客, 要早
  { {0xf9163004,0xf5c0c004,0xf91fb005,0x00000003}},	//   携式, 断裂, 衡器,
  { {0xf9445004,0xfb831005,0xf92b9002,0x00000003}},	//   安地, 王玉, 只到,
  { {0xf93eb005,0xf93a3005,0xf92eb005,0x00000003}},	//   了希, 仁堂, 向出,
  { {0xf8450005,0x00000003,0x00000003,0x00000003}},	//   革不,   ,   ,
  { {0xf91db001,0xf92b3005,0xfb7eb005,0x00000003}},	//   校刊, 未尽, 病科,
  { {0xfb84b007,0xf836c00c,0x00000003,0x00000003}},	//   月特, 方上,   ,
  { {0xfa68e004,0xf911b004,0x00000003,0x00000003}},	//   家明, 西域,   ,
  { {0xf92ff002,0x00000003,0x00000003,0x00000003}},	// [8e0] 展分,   ,   ,
  { {0xfa6ca00f,0xfb705001,0x00000003,0x00000003}},	//   更正, 套系,   ,
  { {0xfa5da009,0xf93c9001,0xfa4c8001,0xf831000c}},	//   的材, 的往, 腐敗, 拿一
  { {0xfa6c0001,0xfa80000c,0xf92a3005,0xfa892005}},	//   場投, 加抽, 太差, 用液
  { {0xf918b00c,0xf81b0002,0x00000003,0x00000003}},	//   批取, 懂事,   ,
  { {0xf5bcc00f,0xf932b00c,0xfa6d400c,0x00000003}},	//   因而, 料倉, 練方,
  { {0xf4c6900f,0xf9145001,0xf5c0c001,0xf9243004}},	//   事長, 找工, 業考, 目分
  { {0xfb707001,0xf59e4001,0xf494d001,0xfa5b2005}},	//   五種, 呂芳, 麻醉, 翁源
  { {0xf941b004,0xfa84e008,0xf910b005,0x00000003}},	//   万公, 義母, 就多,
  { {0xfa84400f,0xfa6e0006,0xf9205006,0xf9113004}},	//   本書, 践活, 面向, 地占
  { {0xf499b00f,0xfa5be009,0xf943b008,0xfa77c001}},	//   入門, 送温, 手元, 活津
  { {0xf9303006,0xf92cf004,0xf9101004,0xf937300c}},	//   法定, 化品, 至全, 食大
  { {0xf9203004,0xf59be001,0xf9369004,0xf815a001}},	//   六合, 往西, 感器, 教主
  { {0xf4ae1007,0xfa700001,0xf59d6008,0xf4b33001}},	//   子都, 已改, 擁護, 料送
  { {0xf9339004,0xf81c200a,0x00000003,0x00000003}},	//   供学, 送中,   ,
  { {0xf9205007,0xfa51a004,0xf9463005,0x00000003}},	//   業同, 何正, 名士,
  { {0xfa690009,0xfb77d004,0xf9343005,0xf915900a}},	// [8f0] 低成, 喜的, 些好, 翻弄
  { {0xf9373001,0xfa4f8004,0x00000003,0x00000003}},	//   棟大, 金海,   ,
  { {0xf945b00e,0xf830c004,0xfb60300a,0xfb67700d}},	//   母子, 米以, 簡素, 被禁
  { {0xfa608009,0xfb7e1004,0xfb6b7004,0xfa64a005}},	//   涉案, 市特, 腐病, 吉水
  { {0xf5b12007,0xf92ef004,0xfa63600c,0xfa6a4005}},	//   械設, 他形, 屋流, 海文
  { {0xfa4d8004,0xf8192004,0xf93eb004,0xfa6d6004}},	//   体数, 作他, 的忠, 署意
  { {0xf921d00f,0xfa680007,0xf9445009,0xfa4d8005}},	//   正取, 同步, 越式, 当数
  { {0xf91df00c,0xf921b00c,0x00000003,0x00000003}},	//   員反, 院判,   ,
  { {0xf90e7006,0xfb80b004,0xfb64d004,0xf59a8001}},	//   平市, 必由, 是硬, 要談
  { {0xf9483009,0xf90c1001,0xf9111004,0xf80ca005}},	//   小字, 件報, 使各, 近些
  { {0xf5b2c006,0xfb83d005,0xfa5b4005,0x00000003}},	//   山西, 下留, 所欠,
  { {0xf8148004,0xf832a005,0x00000003,0x00000003}},	//   生上, 西伯,   ,
  { {0xf4b07001,0xf93a7001,0xf920b00a,0xf9153005}},	//   北鼻, 激動, 庭市, 施基
  { {0xf947100b,0xfb61100c,0xfb69f00a,0xfa88200c}},	//   同士, 信申, 火系, 物栽
  { {0xf911100e,0xfa79c001,0xf818e001,0xfa812004}},	//   調布, 此我, 退伍, 院是
  { {0xf9205009,0xf9225005,0xf939b00c,0xf913700d}},	//   六届, 六周, 果加, 好域
  { {0xf9397007,0xf5c80008,0x00000003,0x00000003}},	// [900] 局各, 輪車,   ,
  { {0xf935900f,0xf829000f,0xf93eb00e,0xfa658004}},	//   教室, 家一, 了後, 合水
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa5b2009,0xfa734004,0xf946d008,0x00000003}},	//   言本, 山新, 界動,
  { {0xfa6f2007,0xf4c0d007,0xf933b007,0xfb587004}},	//   到所, 拉鍊, 領先, 交界
  { {0xf4ae1006,0xfa894009,0xf81d8009,0xfa5ee004}},	//   科院, 用新, 者不, 了每
  { {0xfa7d4004,0x00000003,0x00000003,0x00000003}},	//   旦春,   ,   ,
  { {0xf92e5007,0xf929f001,0xfa50e001,0x00000003}},	//   提到, 含基, 法比,
  { {0xfa632009,0xf8162004,0xf5c98005,0x00000003}},	//   按本, 原体, 在致,
  { {0xf911500c,0xf8296005,0x00000003,0x00000003}},	//   晰度, 美世,   ,
  { {0xf9101009,0xf9231001,0x00000003,0x00000003}},	//   地向, 般外,   ,
  { {0xfb499006,0xfb63d004,0xf4a67005,0x00000003}},	//   奶牛, 是生, 在集,
  { {0xf9343009,0xfb84f004,0xfb663005,0x00000003}},	//   通公, 上留, 良田,
  { {0xf921d006,0xf5ad8004,0x00000003,0x00000003}},	//   京市, 育考,   ,
  { {0xfb851009,0xfa7b8004,0xfa85a005,0xf928b00c}},	//   不留, 性有, 在拉, 用券
  { {0xf9227009,0xf4a81001,0xf4be7004,0xfa896001}},	//   本原, 物都, 装食, 部海
  { {0xfb811004,0xfa642005,0xfa72e00c,0xf92ad005}},	// [910] 安福, 不涉, 找我, 罪判
  { {0xf90c1008,0xfb86f008,0xf818c00c,0xf915300c}},	//   強姦, 配管, 朝代, 格優
  { {0xf9143001,0xfb82b001,0xf925500a,0x00000003}},	//   呼喚, 有罪, 副大,
  { {0xfb5a7004,0xf934b004,0xf8342005,0xf81e6005}},	//   以生, 期完, 国世, 考中
  { {0xf83a0001,0xfa50600c,0xf9235010,0x00000003}},	//   步了, 旗津, 那国,
  { {0xfa5f2004,0x00000003,0x00000003,0x00000003}},	//   病或,   ,   ,
  { {0xf92d900e,0xfa4d8009,0xfb5b7004,0xfb669001}},	//   子大, 金投, 大熊, 部片
  { {0xf4be9007,0xf4b0b00c,0xf5bf000a,0x00000003}},	//   商配, 字都, 賠責,
  { {0xf9159004,0xf58d700c,0xf5c0c00c,0x00000003}},	//   都国, 取記, 次貸,
  { {0xfa6fc00f,0xf940f009,0xfb6a9004,0x00000003}},	//   想法, 有同, 士称,
  { {0xf4be700f,0xf4b01007,0xf5b7a00c,0xf813400c}},	//   分隊, 引領, 伸計, 多作
  { {0xf9303005,0xf8188005,0x00000003,0x00000003}},	//   抗御, 祝中,   ,
  { {0xf5a4e006,0x00000003,0x00000003,0x00000003}},	//   不超,   ,   ,
  { {0xfa730009,0xf93e900e,0xf9471008,0xf92d7005}},	//   施情, 濃度, 行委, 民北
  { {0xf4c3b001,0xfb607005,0xfa886005,0xf81fa005}},	//   事集, 庭美, 快提, 理也
  { {0xfa55200e,0xfa76a001,0xf4939005,0xfa85a005}},	//   高機, 她有, 国非, 在按
  { {0xf9329004,0xf946f008,0xfb6c3004,0xf9453005}},	// [920] 会参, 式市, 青白, 下公
  { {0xfa888004,0xfa796004,0xf930100c,0x00000003}},	//   巨性, 永恒, 林冠,
  { {0xf944b004,0xfa75c004,0xf92e3005,0xfa54c00c}},	//   位参, 活指, 字内, 期服
  { {0xfa712004,0xf91cd005,0xfb4f500c,0xfa54c00c}},	//   花期, 性土, 新約, 真服
  { {0xf4bd100f,0x00000003,0x00000003,0x00000003}},	//   心障,   ,   ,
  { {0xfa7b8007,0xf83be004,0xf9423004,0xf819c005}},	//   大洋, 性住, 玉州, 果信
  { {0xf9199001,0xf9141004,0xf48ac001,0xf92bd008}},	//   人共, 国北, 水送, 習室
  { {0xf839600f,0xf5b3c00e,0xf90b700c,0xf81fa005}},	//   入下, 施術, 然她, 者中
  { {0xfa704004,0xfa50e005,0x00000003,0x00000003}},	//   石景, 北汽,   ,
  { {0xfb745006,0xf4b31009,0xf82b6001,0xfa7c2004}},	//   会第, 会通, 其人, 日来
  { {0xf5c0a007,0xf9445005,0xf9119010,0x00000003}},	//   業要, 越小, 山師,
  { {0xf4c53001,0xfb5fd004,0x00000003,0x00000003}},	//   位通, 解版,   ,
  { {0xfa4de00e,0xfa4fc001,0xfb75d001,0xf9365001}},	//   材派, 林斯, 機神, 生北
  { {0xfa5c000f,0xf92e700f,0xf936b007,0xf9129005}},	//   企業, 且完, 非原, 就建
  { {0xfa7f0001,0xfa7c000c,0xf940100a,0x00000003}},	//   次感, 津津, 蘇市,
  { {0xfa538009,0xf491e004,0xf92e7001,0x00000003}},	//   会提, 到阿, 成家,
  { {0xfa57e004,0xf928b00c,0xf927b005,0xf80cc005}},	// [930] 回扣, 全匹, 全在, 当以
  { {0xfa65a009,0xf58f9009,0xf5b18008,0xfa4ee002}},	//   位提, 投融, 馳走, 算我
  { {0xf9465009,0xfa4ec007,0xf938b005,0xfa5cc00c}},	//   上公, 科書, 果当, 禁書
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9479001,0xf9127001,0xfa876004,0xfb7a700c}},	//   反傾, 政士, 部投, 品約
  { {0xf81a4006,0xfa690005,0xfa71c00d,0x00000003}},	//   十一, 住条, 地核,
  { {0xf9141006,0xf936d006,0xf90d1001,0xf91e7004}},	//   百度, 速公, 整建, 次充
  { {0xf5913001,0xf4c6900c,0x00000003,0x00000003}},	//   著迷, 小配,   ,
  { {0xfb4ab007,0xf924f009,0xfb505004,0xfa7d8005}},	//   康生, 独家, 就的, 大早
  { {0xf5bea007,0xfa71600c,0xf9277005,0x00000003}},	//   你自, 報投, 壮年,
  { {0xf93c300c,0x00000003,0x00000003,0x00000003}},	//   各型,   ,   ,
  { {0xf8418004,0xfa54a00c,0x00000003,0x00000003}},	//   院信, 也才,   ,
  { {0xf93b3004,0xf4a0f001,0x00000003,0x00000003}},	//   市同, 次都,   ,
  { {0xfb6fd008,0xf832a001,0xf9365001,0x00000003}},	//   北緯, 報人, 生南,
  { {0xf9359004,0xf839a004,0xfa870001,0xf4bb3005}},	//   会影, 固件, 身手, 郁金
  { {0xfa53a006,0xf80ae005,0x00000003,0x00000003}},	//   四次, 子下,   ,
  { {0xf824c009,0xfb6e9004,0xf9303004,0xf834e004}},	// [940] 案人, 向群, 字大, 治上
  { {0xf92f900f,0xfb4ad00f,0xfa72600c,0x00000003}},	//   我家, 整的, 由校,
  { {0xf91e9001,0xfa55e00c,0xf925900c,0xfb7cb00d}},	//   池受, 備書, 全合, 送系
  { {0xfb6c1004,0x00000003,0x00000003,0x00000003}},	//   村税,   ,   ,
  { {0xfa87e006,0xf59fa004,0xf5bd2005,0xf93d100a}},	//   未按, 球迷, 接踵, 項又
  { {0xf5b0a009,0xf4c1f001,0xf49c1004,0xfb843008}},	//   想象, 假面, 大黄, 王線
  { {0xf5b50009,0xf9365004,0xfa802005,0x00000003}},	//   精英, 属分, 中按,
  { {0xfa4fa00f,0xf5c6200b,0xf9431007,0xf4c9d007}},	//   化政, 物語, 事後, 福音
  { {0xfa888004,0xf90c5005,0x00000003,0x00000003}},	//   周日, 兵力,   ,
  { {0xfb6e7006,0xfb5c7004,0xfb517001,0x00000003}},	//   金管, 来稿, 花筒,
  { {0xfa57c008,0xf9467001,0xfa4e8004,0xf92e900a}},	//   星放, 車客, 近来, 子制
  { {0xf8388006,0xf91db007,0xfa862004,0xf90eb005}},	//   人代, 無奈, 路收, 佳分
  { {0xf4c4b005,0xfb659002,0x00000003,0x00000003}},	//   上附, 息特,   ,
  { {0xf596400c,0xfa88000c,0xf91df00a,0xf499300c}},	//   依行, 利政, 員免, 方連
  { {0xf5c0c001,0xfb787001,0x00000003,0x00000003}},	//   口蹄, 猜猜,   ,
  { {0xf825c009,0xf837c007,0xfa69000c,0xf938d00c}},	//   届五, 系主, 制概, 需完
  { {0xf92e900b,0x00000003,0x00000003,0x00000003}},	// [950] 科医,   ,   ,
  { {0xfa70800f,0xf945d001,0xf5ad6004,0x00000003}},	//   西洋, 手座, 育要,
  { {0xfa74800a,0xf5c9c00a,0x00000003,0x00000003}},	//   松永, 猪苗,   ,
  { {0xfa5f0004,0xf92eb004,0xf9389005,0xf914100a}},	//   内投, 向基, 果向, 調印
  { {0xf93f3009,0xf90c100e,0xfa638004,0xf9475001}},	//   商分, 強度, 愉悦, 族商
  { {0xfa664006,0xf5c2a009,0xf8144005,0xf923f00a}},	//   程施, 支行, 做中, 括弧
  { {0xf919b00f,0xf926f004,0xf8442005,0xfb523002}},	//   查局, 在原, 是互, 尾的
  { {0xf8204009,0xf92d3004,0xf915f001,0x00000003}},	//   内人, 材加, 系博,
  { {0xfb6fb004,0xf5a78005,0xfa69e00c,0xf9209005}},	//   化社, 富路, 柏格, 次入
  { {0xf9289001,0xf8288001,0xfa6e200a,0xf81c800c}},	//   周出, 島上, 串揚, 千一
  { {0xfa81a007,0x00000003,0x00000003,0x00000003}},	//   無敵,   ,   ,
  { {0xfa72e004,0xf83b6001,0xf59a6001,0xf910f00c}},	//   影放, 書件, 要者, 河岸
  { {0xfb849006,0xfa61600b,0xfa6ac009,0xfa65e00c}},	//   告的, 将来, 件是, 額投
  { {0xf8266001,0xf5955005,0x00000003,0x00000003}},	//   看似, 会落,   ,
  { {0xf80ce006,0xf5a76001,0xf59fe00c,0x00000003}},	//   金会, 位落, 約起,
  { {0xf936500c,0xfa57600c,0x00000003,0x00000003}},	//   生受, 生接,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	// [960]   ,   ,   ,
  { {0xf9235007,0xf9129001,0xf827c00c,0x00000003}},	//   連帽, 山寺, 伍佰,
  { {0xf597200f,0xf5b5e001,0xfa74c004,0xf5c3800d}},	//   思薇, 任講, 国正, 售行
  { {0xf5b9800a,0x00000003,0x00000003,0x00000003}},	//   陸自,   ,   ,
  { {0xf9471001,0xf9233004,0xf5c58001,0xf4c9d004}},	//   前座, 断出, 置表, 量都
  { {0xf9207009,0xfa784001,0xfa814008,0xfa59200c}},	//   次大, 人湯, 本構, 技所
  { {0xf49f5001,0xf5901008,0xf938d00c,0xf5aa800a}},	//   無間, 策課, 最富, 階調
  { {0xf49c3007,0xfa7aa001,0xfb7bf004,0xf4932001}},	//   大集, 別感, 概率, 能順
  { {0xfa6cc001,0xfa6ce001,0xfa84e004,0xf9251005}},	//   水患, 水校, 目提, 目引
  { {0xf9145004,0xf80d800a,0xfb54500c,0xf934f00c}},	//   格力, 字下, 尾盤, 站可
  { {0xf489e009,0xf58ef007,0xf9461004,0xfa5b6008}},	//   家食, 研考, 里奇, 門性
  { {0xf9271009,0xf4c5f001,0xfb553008,0xf9401004}},	//   八届, 半部, 能系, 装入
  { {0xfa6dc00b,0xf4a93008,0xfb751004,0xfa816001}},	//   更新, 全週, 多点, 班招
  { {0xf5bb200f,0xf80cc009,0xf917f004,0xf93ed001}},	//   接著, 首位, 出全, 境工
  { {0xf91cb009,0xf9207004,0xf93a7001,0xf92e3004}},	//   大功, 中城, 夜宿, 研合
  { {0xfb847009,0xfa670007,0xf83ac008,0xfb75d005}},	//   案管, 行投, 交代, 候特
  { {0xfb64b009,0xfb85f005,0xf921d00c,0xfa50600c}},	// [970] 是目, 下特, 客座, 沖水
  { {0xfa59c009,0xfa670008,0xfa64c005,0xf94a3005}},	//   作正, 上智, 告指, 小兵
  { {0xf91f7007,0xfa6cc004,0xf598e001,0xfa584004}},	//   牧場, 卷板, 所認, 搞活
  { {0xf828400f,0xf90a3007,0xf93a3004,0xfa4c6004}},	//   行人, 制委, 仁市, 民情
  { {0xfa77a00b,0xfb63300e,0xf9361007,0xf9473004}},	//   活性, 本編, 高可, 小分
  { {0xfa61200c,0xf599400a,0x00000003,0x00000003}},	//   安技, 賀茂,   ,
  { {0xfa624007,0xf8404004,0xf82d0004,0xfa738005}},	//   守所, 断上, 直以, 共海
  { {0xf91e5008,0xf947f004,0x00000003,0x00000003}},	//   条市, 里大,   ,
  { {0xfa764007,0xfb4ef009,0xf8364004,0xf93ff004}},	//   人服, 育用, 格人, 装大
  { {0xf49b1007,0xf4bb3004,0xfb7ad005,0xfa53800c}},	//   典音, 要道, 一用, 定我
  { {0xfb689009,0xf9343005,0x00000003,0x00000003}},	//   毫秒, 默哀,   ,
  { {0xf5afa007,0xf5ae0007,0xfa4ee001,0xf9293001}},	//   印記, 詳見, 他業, 園城
  { {0xf9197004,0xf58cb001,0x00000003,0x00000003}},	//   撤回, 源自,   ,
  { {0xf9217004,0xf5992004,0x00000003,0x00000003}},	//   中原, 果表,   ,
  { {0xfa884004,0xf9279004,0xfa7a0001,0xfb4f500c}},	//   全池, 岩区, 工教, 到球
  { {0xfb613004,0xf830e00c,0x00000003,0x00000003}},	//   代生, 宿一,   ,
  { {0xf8218009,0xf9429004,0xfa4e0004,0xf910d00a}},	// [980] 理使, 万寿, 他成, 即座
  { {0xfb735009,0xfb55f00d,0x00000003,0x00000003}},	//   会生, 携程,   ,
  { {0xfa554004,0x00000003,0x00000003,0x00000003}},	//   生情,   ,   ,
  { {0xf8256006,0xfb857007,0xf947b004,0xf5977008}},	//   而不, 位生, 位就, 期費
  { {0xf8440001,0xfa742004,0xfa4b2005,0x00000003}},	//   冬令, 施或, 青枯,
  { {0xf5c0e00a,0x00000003,0x00000003,0x00000003}},	//   連資,   ,   ,
  { {0xfa7e2002,0x00000003,0x00000003,0x00000003}},	//   次技,   ,   ,
  { {0xfa5f2006,0xfa7f0004,0x00000003,0x00000003}},	//   考核, 管期,   ,
  { {0xf5c5c007,0xf945500c,0xf80b2005,0x00000003}},	//   用行, 不勝, 材企,
  { {0xfb575001,0xfa796001,0xf5b00005,0xf93d9005}},	//   人真, 特映, 新近, 的契
  { {0xfa768007,0xf4ad7005,0xfa69a005,0xf48a0002}},	//   出時, 他高, 明斯, 其道
  { {0xf90dd009,0xf49b7007,0xf90f3001,0xf92e3004}},	//   年共, 度高, 已可, 村客
  { {0xf48ae007,0xfa7e8001,0xf92ff00c,0xfb53300a}},	//   水餃, 大書, 他女, 都留
  { {0xf945b006,0xf9495009,0xfb759001,0xfa86a00c}},	//   昌市, 量大, 州立, 種樹
  { {0xf9155007,0xf9449009,0xfb80b004,0xfa5d0001}},	//   任局, 合区, 但目, 各教
  { {0xf9131006,0xf936f004,0xf4b4500c,0xf935900c}},	//   国商, 保分, 備道, 賞屋
  { {0xf9127009,0xf91c9005,0xfb83d005,0x00000003}},	// [990] 命名, 大宝, 始皇,
  { {0xf5af6004,0xf8254004,0xfb5f7005,0x00000003}},	//   称考, 里之, 校研,
  { {0xf91ed007,0xfa64e001,0xf941b004,0xf926b004}},	//   無力, 下挫, 合型, 物化
  { {0xf91b3007,0x00000003,0x00000003,0x00000003}},	//   司已,   ,   ,
  { {0xfb631007,0xfb6cb007,0xf5aac001,0xfa50800c}},	//   業登, 耐用, 低落, 五支
  { {0xf940d004,0xfb79f008,0xf5b1c001,0xf5c6a004}},	//   三同, 仁美, 房菜, 目落
  { {0xfa800004,0xfb5e700c,0xfa70600c,0x00000003}},	//   探望, 蔡的, 西拉,
  { {0xf49a7001,0xf9101005,0x00000003,0x00000003}},	//   別針, 至周,   ,
  { {0xfa786009,0xf826a004,0x00000003,0x00000003}},	//   摸清, 量事,   ,
  { {0xf82b2007,0xf9103004,0xf936b004,0xfa788004}},	//   件信, 台子, 存入, 翻新
  { {0xf5c04004,0xf4ae3008,0xf9257001,0xfb74d00c}},	//   巡警, 結露, 義分, 伙煮
  { {0xf9263009,0xfa718004,0xf92f5008,0xf90a5005}},	//   景德, 共投, 敗北, 件得
  { {0xf49ad005,0xf4a3900c,0x00000003,0x00000003}},	//   日酒, 頭音,   ,
  { {0xfb5f1004,0xf49f900c,0xf92e3005,0x00000003}},	//   象科, 匠電, 委屈,
  { {0xf92c9004,0xf4aad001,0xfb7d1005,0xf815000c}},	//   体学, 成里, 市用, 香亭
  { {0xf82f8009,0xf93bd004,0x00000003,0x00000003}},	//   新余, 求分,   ,
  { {0xf9169006,0xf497c007,0xf9217007,0xf825c00c}},	// [9a0] 人参, 移除, 管家, 律以
  { {0xfa614007,0xf943b001,0xfa7a0004,0xfa63a00c}},	//   理治, 合彩, 日旅, 合推
  { {0xf4be9004,0xfb73b002,0x00000003,0x00000003}},	//   内速, 衛粧,   ,
  { {0xf91bb009,0xf4b13008,0xf9353001,0xf495c005}},	//   大城, 四重, 多姿, 格面
  { {0xf90f3006,0xfa840001,0xf80f0004,0xf8482004}},	//   地市, 修持, 法予, 身作
  { {0xf93ad007,0xfa694004,0xf58f5001,0xf8278004}},	//   作報, 小春, 店自, 而中
  { {0xf4b6d006,0xf5a7200e,0xf9189008,0xf90e1004}},	//   增速, 二輪, 容外, 至尊
  { {0xf490c00e,0xf92c9008,0xfa842004,0xfb82f004}},	//   台風, 成外, 断更, 程等
  { {0xf48b4009,0xf93df004,0xfb6d3001,0xfb59500c}},	//   年高, 必将, 糖的, 肥羊
  { {0xf93f1007,0xfb585001,0xf943100c,0x00000003}},	//   商寄, 人第, 旋律,
  { {0xf48be00f,0xf58a1009,0xf90c1009,0xfb5b1004}},	//   家都, 体行, 更快, 入研
  { {0xfb543009,0xf58a1004,0xfa676001,0xf59ec00c}},	//   格率, 当行, 車格, 分規
  { {0xf9215006,0xfa87a004,0xfb70700a,0xf5c4a005}},	//   信号, 早春, 演目, 目跟
  { {0xfa5fc006,0xfa702007,0xf5a92007,0xf8238004}},	//   的新, 史沿, 意象, 等交
  { {0xf4ac300e,0xf5b14001,0xf927d004,0xfb68b00c}},	//   預金, 深耕, 表在, 風知
  { {0xf4abf009,0xf910d005,0xfb7df005,0xf922700c}},	//   少量, 声器, 市移, 斯安
  { {0xf82cc00f,0xf4b2b009,0xf923b004,0xf838c00c}},	// [9b0] 年代, 楚雄, 口地, 出令
  { {0xf947f006,0xfb75f007,0xf5b76004,0xf942f00c}},	//   明市, 生科, 点考, 有刮
  { {0xfa720007,0xf593b00e,0xf824c001,0xf4ba3001}},	//   東港, 標識, 合使, 果酸
  { {0xfa4e4008,0xfb865001,0xf9149005,0x00000003}},	//   我慢, 服用, 能公,
  { {0xfa56e00f,0xf922d00f,0xfa5f400f,0x00000003}},	//   秘書, 客家, 理教,
  { {0xf8252008,0xf9313004,0xfa850005,0xf4a2b00a}},	//   授乳, 法利, 修材, 副題
  { {0xfa5fe009,0xfa78c009,0xf81f0009,0xf9329001}},	//   均每, 活水, 的以, 仕女
  { {0xf81b400f,0xf940d008,0xf80d8005,0xf9283010}},	//   一代, 三和, 限以, 師募
  { {0xf9123007,0xf948f001,0x00000003,0x00000003}},	//   東勢, 牌家,   ,
  { {0xf8254009,0xf9431009,0xfb88d009,0xfa7a2001}},	//   上作, 下同, 低生, 書正
  { {0xfa614004,0xfb511008,0xf5b56001,0x00000003}},	//   商来, 帳簿, 追追,
  { {0xf5bc2001,0x00000003,0x00000003,0x00000003}},	//   大者,   ,   ,
  { {0xfb85d00f,0xfa4d6008,0xfa75e004,0xf945900c}},	//   開盤, 伐採, 国数, 型加
  { {0xfa528001,0xfb4ad001,0xf9397005,0x00000003}},	//   定最, 德科, 所包,
  { {0xf4b39007,0xf931d001,0xfb75d00a,0xfb89b005}},	//   通違, 四分, 愚痴, 每百
  { {0xfa5ea005,0xf4b4d005,0xf84ac005,0xfa53c002}},	//   包期, 生量, 被侵, 甚或
  { {0xf91a3009,0xfa590004,0xf48f4004,0xf4906004}},	// [9c0] 室外, 保春, 害食, 新途
  { {0xfb5d9001,0x00000003,0x00000003,0x00000003}},	//   造紙,   ,   ,
  { {0xf5991005,0xfa75a00c,0xf4b1100c,0x00000003}},	//   果自, 費情, 鍛鍊,
  { {0xfa660004,0xf9471008,0xf9163004,0xf93f9005}},	//   再投, 柏市, 示嵌, 者公
  { {0xf91e7009,0xfa4ea00e,0xfb78f004,0x00000003}},	//   信商, 救急, 搜狗,
  { {0xf916d007,0xfb86d00a,0xf5b0000c,0x00000003}},	//   登字, 小節, 音表,
  { {0xf9481004,0xfb4ef001,0xfa586004,0x00000003}},	//   同区, 地美, 生整,
  { {0xfa510001,0xfa75a005,0xfb4af00a,0xfb621005}},	//   南澳, 治情, 直筆, 索相
  { {0xf939f00f,0xf8416009,0xf90b3004,0xfb4a700c}},	//   品名, 本不, 件学, 海線
  { {0xfa846004,0x00000003,0x00000003,0x00000003}},	//   路推,   ,   ,
  { {0xfa644001,0xf8438008,0xf8418005,0xf927d005}},	//   安東, 慮下, 代互, 在售
  { {0xf5aa6001,0xfb8a9005,0xf947700c,0x00000003}},	//   康講, 明稿, 隊報,
  { {0xfa86c004,0xf93b1005,0xfa78a005,0xf90ab005}},	//   天早, 品增, 方或, 海州
  { {0xf9453004,0xf921700c,0xf91a900d,0x00000003}},	//   程可, 業土, 急功,
  { {0xf909b00a,0x00000003,0x00000003,0x00000003}},	//   職後,   ,   ,
  { {0xf845c006,0xf93c100a,0xfa4ec005,0xf493a00c}},	//   全事, 善光, 湖景, 追逐
  { {0xf92df00f,0xf9197001,0xfa5c2001,0x00000003}},	// [9d0] 店市, 人味, 考手,
  { {0xfa5b0001,0xfb6dd001,0xfb7c7001,0xf928d001}},	//   一湯, 他真, 要照, 風吹
  { {0xf90b5009,0xfa5f200a,0xf93fd005,0x00000003}},	//   家大, 射日, 的康,
  { {0xfa648006,0xf90eb009,0xfb87b00a,0xf938300c}},	//   合治, 泰安, 明美, 生具
  { {0xf91c3007,0x00000003,0x00000003,0x00000003}},	//   日出,   ,   ,
  { {0xfb83b009,0xf91b3009,0xf5a3a004,0xf82a4001}},	//   三点, 常平, 又被, 場三
  { {0xf9401006,0xf9301001,0xf5cb2005,0x00000003}},	//   商引, 化地, 雪落,
  { {0xf4c5500f,0xf943f007,0xfb75b009,0xf5a4c005}},	//   見面, 又可, 非税, 上装
  { {0xfa52c001,0xf59fa00c,0xf5c0600a,0xfa4d000c}},	//   尚情, 吃起, 員試, 間改
  { {0xf4970001,0xfa672004,0xf90ef008,0xf499000c}},	//   人願, 同推, 新小, 人遺
  { {0xf5975009,0xf9493008,0xfa714004,0xf928f013}},	//   障行, 小室, 数次, 岫岩
  { {0xfa64400c,0xf928b00c,0x00000003,0x00000003}},	//   王朝, 用典,   ,
  { {0xf9267007,0xf81d8004,0xf92cd001,0xf5cb4001}},	//   良場, 市代, 毒奶, 質製
  { {0xfa6a800c,0xf90a500a,0xfb6f5005,0x00000003}},	//   年服, 究協, 金甲,
  { {0xfa6d4007,0xf9199001,0xf9457004,0xfa790001}},	//   海水, 券化, 型客, 役業
  { {0xfa66a006,0xfa814004,0xf9177005,0xf93ef00c}},	//   反本, 象新, 人少, 吃出
  { {0xfb771006,0xf9115004,0xfb63500c,0x00000003}},	// [9e0] 生素, 阿姆, 口精,
  { {0xfa5f2006,0xf9319007,0xfb7df00c,0x00000003}},	//   各方, 供各, 市登,
  { {0xfa69000f,0xf48ee004,0xf58cf004,0xfb79500c}},	//   家所, 平高, 成良, 夜用
  { {0xfb817005,0xfa67200c,0xfa6b2005,0xfa89e005}},	//   万用, 納方, 美新, 身携
  { {0xfa4e8006,0xfa59a008,0xf82fe004,0xfa60e001}},	//   近日, 品案, 地作, 指期
  { {0xf8472001,0xf941d004,0xf5b6a001,0xf830c001}},	//   八事, 月完, 樹葉, 由供
  { {0xf8394006,0xf59fc009,0xfb7cb007,0xf9187007}},	//   日上, 内衣, 品確, 書商
  { {0xf94a500b,0xfa7d8007,0xfb81b004,0xf828400c}},	//   過去, 左方, 授粉, 住他
  { {0xf9313007,0xf9471005,0x00000003,0x00000003}},	//   北地, 每千,   ,
  { {0xf5a7c007,0xfa4d6001,0xf59f600a,0x00000003}},	//   配色, 我打, 桃色,
  { {0xfa7b8004,0x00000003,0x00000003,0x00000003}},	//   查是,   ,   ,
  { {0xf81ba004,0xf5a9200a,0x00000003,0x00000003}},	//   市七, 偶者,   ,
  { {0xfa528004,0xf923d001,0xf9249004,0xf93cb00c}},	//   会持, 扣其, 本平, 心分
  { {0xfa75e006,0xfb72900f,0xf9455001,0xf9463004}},	//   国新, 講習, 友可, 同做
  { {0xf9361001,0xf5c92001,0xf90c5008,0xf93d5005}},	//   仙女, 披肩, 究家, 情及
  { {0xf4a47009,0xfa80800c,0xf918f00c,0xf90b700c}},	//   般都, 監持, 盤商, 長夫
  { {0xf9119001,0xf8308005,0x00000003,0x00000003}},	// [9f0] 政博, 廳信,   ,
  { {0xf5aa800e,0xfa658009,0xf91cd004,0xfb879004}},	//   件表, 反思, 性功, 税等
  { {0xfb5cd00f,0xfa72a00e,0x00000003,0x00000003}},	//   度第, 由来,   ,
  { {0xfa58c001,0xf49ba001,0xf5a98004,0xfa4e000c}},	//   初探, 度通, 零距, 或打
  { {0xf917f005,0x00000003,0x00000003,0x00000003}},	//   出在,   ,   ,
  { {0xfa86000f,0xf4c45007,0xf5c92008,0xf9481001}},	//   修正, 籍配, 全課, 後勤
  { {0xf4a23004,0xfa77e001,0xf9253004,0xfa6be005}},	//   京高, 樹枝, 目列, 件格
  { {0xfa5cc006,0xfb485009,0xf9111007,0xfa4e0004}},	//   品油, 其版, 地形, 他提
  { {0xfa622009,0xf90d7001,0xf9447004,0xfa74a00c}},	//   按期, 浴巾, 草地, 乾涸
  { {0xfa7cc001,0xf4a6f00a,0x00000003,0x00000003}},	//   造橋, 器類,   ,
  { {0xf4a33008,0xfa4dc001,0xf92cf001,0xf4ac700c}},	//   本革, 林植, 間出, 向隅
  { {0xfa7c8006,0xf92db001,0xf9193004,0xf5a1c00c}},	//   查找, 子工, 日安, 又見
  { {0xfa5ae009,0xf9177009,0xf9433007,0xfa64c00e}},	//   作新, 容包, 看完, 開演
  { {0xf92f3001,0x00000003,0x00000003,0x00000003}},	//   字塔,   ,   ,
  { {0xf9315004,0xf90ad005,0xfb83f00d,0xfa84c010}},	//   望城, 巴布, 之痛, 天橋
  { {0xf5bca001,0xfa67e004,0xfa6d0004,0xf4c01001}},	//   加載, 式成, 德新, 者除
  { {0xf9259001,0xf9257001,0xf9277008,0xfb65f005}},	// [a00] 全守, 斯基, 義室, 在税
  { {0xfb57500f,0xf9199006,0xf59f7004,0xfa4e2005}},	//   人生, 人就, 的追, 南概
  { {0xfa5c000f,0xf929d007,0xfa5ba001,0xfa8a200c}},	//   言板, 術合, 局查, 太早
  { {0xfa70200f,0xfa56e00f,0xfa614004,0xfb555005}},	//   到我, 原本, 理活, 能特
  { {0xfb6d7009,0xfa548005,0x00000003,0x00000003}},	//   当由, 写法,   ,
  { {0xfa5dc009,0xfa5d4008,0xf90ad004,0xf815e00c}},	//   的排, 市港, 年参, 料使
  { {0xf915d004,0xfb725005,0x00000003,0x00000003}},	//   出合, 底稿,   ,
  { {0xfa616006,0xfb73f006,0xf9415009,0xf5b2e004}},	//   理方, 通用, 理出, 好者
  { {0xfa5c2008,0x00000003,0x00000003,0x00000003}},	//   銀河,   ,   ,
  { {0xf5c7e001,0xf8406005,0xfb81500c,0xf935f005}},	//   利貸, 中仍, 沉的, 聘公
  { {0xf9163009,0xfb70d009,0xfb815004,0xf5b2a005}},	//   兼容, 受社, 粉的, 寿路
  { {0xf93b3004,0xf8476004,0xfb871005,0xf93d500c}},	//   市富, 用五, 上点, 久後
  { {0xf5aaa007,0xf93d9001,0xf90b500c,0x00000003}},	//   低調, 心底, 水博,
  { {0xfb64d001,0xf4c1f004,0x00000003,0x00000003}},	//   種畜, 等食,   ,
  { {0xfb4c9006,0xfa7d0004,0xf5b0c001,0xf927f005}},	//   年第, 入海, 房舍, 您公
  { {0xf845e006,0xf9115007,0xf9289009,0xfb7df004}},	//   在不, 影展, 用建, 内燃
  { {0xfa652004,0xf9447004,0xfb4bd001,0x00000003}},	// [a10] 名教, 型向, 念的,
  { {0xfb849001,0xfb68f004,0xfa4d8004,0xf819e005}},	//   先知, 在白, 碑林, 禁不
  { {0xfa66e00c,0x00000003,0x00000003,0x00000003}},	//   住持,   ,   ,
  { {0xf937700f,0xfa85a009,0xf4af9007,0xfb805004}},	//   高到, 可根, 法送, 者特
  { {0xf92bd001,0xf93d9001,0xf5c4e00a,0x00000003}},	//   打孔, 磁場, 本茶,
  { {0xfa61c00f,0xf93f1004,0xfa5c000c,0xfb6ab00c}},	//   指揮, 集各, 各月, 打球
  { {0xf5b7400e,0xfa5c8004,0xfa72c005,0x00000003}},	//   改訂, 流活, 阿斯,
  { {0xf91c5006,0xfa7d200b,0xf8286004,0xfa64a004}},	//   日常, 日更, 其三, 合改
  { {0xfb505001,0xf91f9008,0xf923f001,0x00000003}},	//   山的, 管外, 般大,
  { {0xf5a30001,0xf49a4008,0xf58ef001,0xf928f005}},	//   例行, 来高, 滑落, 被全
  { {0xfb665006,0xf93c5009,0xfb697004,0xfa5ca005}},	//   用的, 市土, 全状, 流方
  { {0xf83a600f,0x00000003,0x00000003,0x00000003}},	//   給予,   ,   ,
  { {0xf910b007,0xfb58d004,0xf9135005,0xfa5d600c}},	//   課地, 点用, 国定, 市杭
  { {0xf9335004,0xf9095001,0xf5acc00d,0x00000003}},	//   多域, 家必, 海至,
  { {0xf5b94006,0xf49bc00e,0xf592b007,0xfb55d00a}},	//   履行, 入院, 裕農, 白熱
  { {0xf80ce009,0xfa5ae004,0xfb5cd001,0x00000003}},	//   取一, 址是, 素秋,
  { {0xfa636004,0x00000003,0x00000003,0x00000003}},	// [a20] 文水,   ,   ,
  { {0xf5bcc00a,0xfb77700c,0xf929f00c,0x00000003}},	//   日英, 熟知, 間安,
  { {0xfa772005,0x00000003,0x00000003,0x00000003}},	//   任是,   ,   ,
  { {0xf9497005,0xf941900d,0x00000003,0x00000003}},	//   偏僻, 愈合,   ,
  { {0xfa5c0006,0xf939f009,0xf817600c,0x00000003}},	//   一款, 老同, 食人,
  { {0xfa64e001,0xfb7eb00c,0x00000003,0x00000003}},	//   克林, 的珠,   ,
  { {0xf9283009,0xfff0e009,0xf93ff004,0xfb7ab004}},	//   在加, 鍔ㄦ, 居室, 郁症
  { {0xf917100f,0xf497e007,0xfb885008,0xfb86d001}},	//   方式, 陸配, 炎症, 行結
  { {0xf90cf007,0xf83be001,0xf5a7c004,0xf9107005}},	//   康報, 知信, 行解, 箱内
  { {0xf93d5006,0xfa6a4009,0xf918b004,0xf8156005}},	//   考察, 海曙, 油天, 功了
  { {0xfb807004,0xfa6aa001,0xfb6b5005,0xfb511005}},	//   万盛, 直流, 只眼, 足社
  { {0xf9385004,0xf4c5d005,0xfb4ed00c,0xfb75d00c}},	//   喝彩, 名酒, 地界, 星生
  { {0xf832800b,0xf90c5007,0xfb85d004,0xf9405005}},	//   就任, 水彩, 下移, 片包
  { {0xfa4fe007,0xfb861004,0xfb7df008,0xfa518004}},	//   林業, 上用, 元祖, 力最
  { {0xf815e009,0xfb79b004,0xf924300c,0x00000003}},	//   非企, 最牛, 置各,
  { {0xfa750004,0xfb7d1004,0xf935700a,0xf4a2c005}},	//   主旋, 持社, 博史, 是降
  { {0xfa58c009,0xf5abe00c,0xf4c1d00c,0xf921d00c}},	// [a30] 依次, 其色, 理防, 難受
  { {0xf8480006,0xf90b3006,0xf80e0001,0xfb6ad001}},	//   在中, 更多, 受一, 自知
  { {0xf5a54006,0xfa6c6007,0xfa5f2001,0xf93c9008}},	//   合起, 長春, 商旅, 節家
  { {0xf935b007,0xf91ef009,0xf9291004,0xfa7b6004}},	//   存取, 巡回, 在平, 永泰
  { {0xfb7df006,0xf9117007,0xfb70f00a,0xf816c005}},	//   病的, 跳到, 減益, 神作
  { {0xf934d00f,0xf8232007,0xf936d001,0xfa648001}},	//   土城, 三代, 依各, 合活
  { {0xf8406009,0xfb769007,0xfa72a007,0xf92c100c}},	//   中不, 借用, 鹿港, 向式
  { {0xf499600b,0xf83c4009,0xf8324009,0xfa716004}},	//   以降, 入人, 百万, 新旧
  { {0xfa51e009,0xfa4f8007,0xf8286005,0xfa884005}},	//   法性, 近更, 收上, 用橡
  { {0xf9449001,0xf90c7001,0xf8386008,0xf91bd00c}},	//   合出, 男出, 示中, 令失
  { {0xf9301009,0x00000003,0x00000003,0x00000003}},	//   他山,   ,   ,
  { {0xfb5c700f,0xf9291004,0xf91e100c,0xf93ff00c}},	//   照片, 倒塌, 度山, 的呵
  { {0xf4ae7001,0xf91fb005,0x00000003,0x00000003}},	//   林高, 欠工,   ,
  { {0xf81ec007,0xfa548004,0xfa64a00a,0x00000003}},	//   心主, 会正, 手打,
  { {0xf9311008,0xfa564001,0xfa6b0008,0xf91bd005}},	//   法士, 生比, 破棄, 大刀
  { {0xfa856009,0xfa66a005,0xfb51b005,0x00000003}},	//   路改, 位正, 称登,
  { {0xfb871004,0xfb4eb004,0xf821e00c,0xf5a5600c}},	// [a40] 不移, 新立, 合乎, 後行
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf92a7009,0xf49cc00a,0xf946300c,0xf90b3005}},	//   易局, 日露, 肌力, 茶座
  { {0xf815200e,0xf4ab1008,0xf93e1004,0xf947b001}},	//   備中, 体障, 元器, 坎城
  { {0xfa7e4001,0xf90bb008,0x00000003,0x00000003}},	//   你成, 年少,   ,
  { {0xf92b3004,0xfa4d800a,0xfb5bd005,0xf939f00d}},	//   材市, 唐津, 麦生, 送和
  { {0xfb4f7007,0xfa718004,0xf945d001,0xf93a9001}},	//   述的, 新津, 洋基, 裁切
  { {0xfa6f2007,0xf8096001,0xf81d6004,0x00000003}},	//   到最, 園丁, 如中,
  { {0xfa678006,0xf5ae800f,0xf9423004,0xfa7ea008}},	//   二是, 想要, 争当, 員教
  { {0xf9301009,0xf90a700e,0xfb6dd001,0xfb4a9001}},	//   他就, 長官, 他生, 傷痛
  { {0xf914f00f,0xf4a2c00b,0xf9133004,0xf81e8004}},	//   松山, 解除, 仿古, 者作
  { {0xfa4c8007,0xfb5b9004,0xfb6a5005,0xf4b5100a}},	//   子投, 大牌, 当着, 教頭
  { {0xf825c008,0xfb87f004,0xf94b3004,0xf837a00c}},	//   二丁, 名男, 美德, 人互
  { {0xfa7bc00f,0xf922b009,0xf9199007,0xf4c3f009}},	//   盤新, 中加, 書庫, 等都
  { {0xf5c1e008,0xfa7e600c,0x00000003,0x00000003}},	//   六角, 財情,   ,
  { {0xfb4ff001,0xf4a44008,0xfb83d00c,0x00000003}},	//   地租, 本選, 倉特,
  { {0xf93f9004,0xf913300c,0x00000003,0x00000003}},	// [a50] 万富, 宿大,   ,
  { {0xfa7e0007,0xf59dd001,0x00000003,0x00000003}},	//   占星, 項考,   ,
  { {0xf940b009,0xf93eb00c,0xf9401005,0xfa78c005}},	//   吉安, 心室, 浅出, 系更
  { {0xfb6cb007,0x00000003,0x00000003,0x00000003}},	//   耐磨,   ,   ,
  { {0xf4b45005,0x00000003,0x00000003,0x00000003}},	//   料酒,   ,   ,
  { {0xf8184009,0xf91f9001,0xfb799004,0xfb7f900c}},	//   回主, 加哥, 血病, 的米
  { {0xf916f006,0xf81a4009,0xf9279004,0xf49bc00c}},	//   固定, 持一, 利大, 日連
  { {0xf59d5007,0xf90dd004,0xf931300c,0xf935d00c}},	//   的距, 年山, 受困, 期借
  { {0xf9417006,0xfb88f007,0xf913d004,0xfb5cb00c}},	//   等内, 行細, 礼堂, 座生
  { {0xf91eb00b,0xf82e200f,0xf9273009,0xf93f1004}},	//   大好, 已依, 在当, 各基
  { {0xf492800c,0x00000003,0x00000003,0x00000003}},	//   羽量,   ,   ,
  { {0xfa89600e,0xf92cf009,0xfa68a004,0xfa55a004}},	//   自民, 靖市, 序是, 料添
  { {0xf4922001,0xf90ed004,0xf93d7004,0xfb5bb005}},	//   沿途, 泰克, 者同, 大税
  { {0xf942f004,0xf91f9004,0xfb639005,0x00000003}},	//   奉公, 院各, 京第,
  { {0xf81b400e,0xf4a26005,0xfa84c005,0xfa844005}},	//   着信, 京通, 是是, 本核
  { {0xf8258006,0xf9489009,0xf92f9001,0xfb7d9004}},	//   事信, 意在, 且原, 待着
  { {0xfa4ce001,0xf9419004,0x00000003,0x00000003}},	// [a60] 化所, 合安,   ,
  { {0xf93e700f,0xf8254004,0xf923b005,0xf944f00a}},	//   時報, 行三, 庭影, 手帖
  { {0xf49bc004,0xf4be9001,0xf4c51004,0xf92e1005}},	//   入面, 各連, 合防, 南威
  { {0xfa674007,0xf82a4008,0xfa4c2004,0xf9473005}},	//   名方, 階以, 青松, 名出
  { {0xfa5d6005,0x00000003,0x00000003,0x00000003}},	//   情洋,   ,   ,
  { {0xf91cf009,0xfa824001,0xfa70c00c,0xf917d00c}},	//   接地, 客房, 味性, 建志
  { {0xfb58300e,0xf90dd009,0x00000003,0x00000003}},	//   人目, 年就,   ,
  { {0xf9339009,0xfa564007,0xf9099007,0xf8336004}},	//   教唆, 江湖, 買前, 值不
  { {0xf935b004,0xf942b00a,0xf91c3005,0xf93b900c}},	//   神和, 光太, 入医, 所入
  { {0xfa562009,0xf914f007,0xf83f800c,0xf946d00c}},	//   勘探, 系友, 客一, 界展
  { {0xfa584006,0xf4c69001,0xf9423005,0xf92c1005}},	//   回来, 下陷, 分家, 向小
  { {0xf845e007,0xf9103001,0xf8406005,0xfb5e500a}},	//   表下, 己心, 中位, 信玄
  { {0xf4a3c010,0x00000003,0x00000003,0x00000003}},	//   宮里,   ,   ,
  { {0xfb5eb009,0xf5b1c001,0xf92eb005,0xf49fe00c}},	//   大白, 東臨, 子年, 面高
  { {0xf937d00e,0xfa5ec004,0xf928d00d,0xf9397002}},	//   府市, 的淡, 剪切, 朝卿
  { {0xf9095006,0xf93f1004,0xfb7bd008,0xf919f00d}},	//   家居, 了如, 品物, 判委
  { {0xf5b26009,0xfb7c3007,0xfb88b00e,0xf4c77004}},	// [a70] 国行, 局申, 式第, 式通
  { {0xf818c007,0xf92dd00e,0xfa682004,0xf9123001}},	//   所介, 視察, 同方, 地共
  { {0xf91fd004,0xfb87100a,0xfa4c2005,0xf5b18005}},	//   凡在, 不登, 撒施, 百菌
  { {0xfb867004,0xf947b00c,0x00000003,0x00000003}},	//   例由, 位報,   ,
  { {0xfb74300f,0xf939f004,0xfb777001,0xfa7f200c}},	//   教科, 作学, 速登, 次我
  { {0xf4966007,0xf5a94008,0xfb535004,0x00000003}},	//   出門, 康計, 眼界,
  { {0xfa67e009,0xf9437009,0xf93c300e,0xf919d004}},	//   式提, 等大, 薄型, 来参
  { {0xf943100c,0xfa7da005,0xf82ea00c,0x00000003}},	//   下完, 淡泊, 腰三,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf82e8005,0xfa6b600c,0x00000003,0x00000003}},	//   即一, 起推,   ,
  { {0xf9127004,0xf4994001,0xf9271005,0xfa5ba005}},	//   施前, 腸道, 在向, 局日
  { {0xf90a3007,0xfa87a009,0xfa6a400c,0xf90c300a}},	//   整型, 早日, 其林, 整復
  { {0xf9295006,0xf5977008,0x00000003,0x00000003}},	//   太原, 非表,   ,
  { {0xfa766009,0x00000003,0x00000003,0x00000003}},	//   人每,   ,   ,
  { {0xf9355009,0xfb6d7004,0xf844c004,0xf915b00c}},	//   瑞安, 子管, 港中, 值加
  { {0xf5bb4007,0xf813c001,0xfb517004,0xf9415004}},	//   查表, 供任, 右翼, 理基
  { {0xf915f007,0xf5977004,0xf922b005,0xf5955005}},	// [a80] 出刊, 作行, 中占, 会能
  { {0xf820c009,0xfb4ad004,0xfa676004,0xfa62c005}},	//   等事, 更的, 藏文, 吉木
  { {0xf90fd009,0xfb4ad001,0xf5a9800c,0x00000003}},	//   害化, 直的, 德行,
  { {0xf9481006,0xfb6ed001,0xfa632008,0xf4b31005}},	//   屏幕, 林真, 計期, 留量
  { {0xf9471005,0xf914300d,0x00000003,0x00000003}},	//   小庄, 宿制,   ,
  { {0xfb7bd00f,0xfa710008,0xf8162005,0xfb79900c}},	//   送用, 台本, 保今, 保申
  { {0xf5b2c006,0xfa676009,0x00000003,0x00000003}},	//   都要, 族文,   ,
  { {0xfb6e900f,0xf8324009,0xf5b2c001,0xf4988001}},	//   科系, 使他, 能要, 選集
  { {0xf9313004,0xfb7f1004,0xfa720005,0xfa7a800c}},	//   受地, 考点, 乱搭, 查榜
  { {0xfa600004,0xf8358005,0xf943700a,0x00000003}},	//   病控, 值中, 興協,
  { {0xf925b00b,0xfa4fe009,0xf49ce00e,0xf9377004}},	//   臨床, 展情, 旦那, 高台
  { {0xfb6e3005,0x00000003,0x00000003,0x00000003}},	//   限由,   ,   ,
  { {0xf4adf006,0xf5a31007,0xf927b005,0x00000003}},	//   成都, 請見, 早出,
  { {0xf83dc006,0xfa61c004,0xfb5f9001,0xf4b7f001}},	//   大中, 均是, 敢的, 生飲
  { {0xf48fa004,0xf822a00c,0xfb67700c,0xf9235005}},	//   地高, 先付, 岩群, 是密
  { {0xf931d00b,0xf942d005,0x00000003,0x00000003}},	//   何度, 光器,   ,
  { {0xfa8a600b,0xf9117004,0xfa634001,0xf4c1d001}},	// [a90] 自慢, 乳山, 介意, 守隊
  { {0xfa6b000c,0xfb7a700c,0xf91fd00c,0xfa59800a}},	//   水旅, 流理, 跡可, 門教
  { {0xfb82f001,0xfa71600c,0xf93c900c,0x00000003}},	//   安犯, 報法, 流基,
  { {0xf8360004,0xf93d900c,0x00000003,0x00000003}},	//   出事, 心展,   ,
  { {0xf5b70001,0xfa7cc00c,0x00000003,0x00000003}},	//   人講, 遠洋,   ,
  { {0xf910b004,0xfa638004,0xf4a10001,0xfa4e0005}},	//   就做, 案法, 業集, 南最
  { {0xf93e1004,0xf8312001,0xf9367001,0xfb7e3005}},	//   元在, 地代, 教具, 情片
  { {0xf9115005,0xfa7d0005,0x00000003,0x00000003}},	//   女平, 学探,   ,
  { {0xfa644001,0xf9451004,0x00000003,0x00000003}},	//   上服, 同安,   ,
  { {0xfa67c009,0xf4b4b001,0xfa668005,0xfb70500a}},	//   位数, 站部, 双星, 純物
  { {0xfb7ad009,0xf4932009,0xf9177001,0xfa6a800c}},	//   一票, 花都, 主因, 年才
  { {0xfa600009,0xf8452004,0xf93dd008,0xf4bc1001}},	//   病性, 是信, 桃太, 流連
  { {0xf4aaf009,0xf5c8e008,0xf936300c,0xfa6ec00d}},	//   排部, 用製, 仙山, 河文
  { {0xfb607007,0xf818c004,0xf912b005,0x00000003}},	//   設籍, 局上, 由出,
  { {0xf844c00f,0xf49d8004,0xf4af1001,0xf499200c}},	//   早上, 大革, 我都, 示選
  { {0xfb5d7004,0xfb60b004,0xfa782001,0xf90e7008}},	//   学知, 散的, 書況, 玲子
  { {0xf9409004,0xf81d6001,0xf934d00c,0xfb4f300c}},	// [aa0] 文博, 約保, 定座, 平生
  { {0xfa4f400f,0xf918b009,0xfa7d0004,0xf83ca008}},	//   我想, 交往, 加明, 照会
  { {0xf5a1f001,0xf9263004,0xfb85d010,0xf4c9b00d}},	//   商花, 在如, 旋盤, 魏都
  { {0xf9173008,0xf83bc004,0xfb4c7001,0xf4c5d005}},	//   丹市, 以信, 具系, 名青
  { {0xf5c7400b,0xf91dd009,0xf4b23004,0xfa4de001}},	//   全角, 大客, 会降, 化村
  { {0xfb57d00b,0xf5bdc004,0xfa88c004,0xfa744004}},	//   決算, 信行, 在核, 放日
  { {0xf5a3d004,0xf924d004,0xfb6fb002,0x00000003}},	//   予表, 京山, 取精,
  { {0xfa61200a,0xfa81400c,0x00000003,0x00000003}},	//   安最, 本手,   ,
  { {0xf9303004,0xf9399004,0xf924500c,0xfb52700d}},	//   拖延, 榜公, 置分, 好税
  { {0xfa750001,0xf5b0800c,0xf92cb005,0x00000003}},	//   命性, 地訪, 民多,
  { {0xfb7e1007,0xfa4fc00c,0xfb83b00d,0xf916900d}},	//   考用, 店業, 月票, 示如
  { {0xfb803004,0xfa7ac001,0x00000003,0x00000003}},	//   内知, 選書,   ,
  { {0xf9125004,0xfa5f0004,0xf8404001,0xf8448005}},	//   便快, 内法, 管你, 路修
  { {0xfa54a006,0xfb545001,0xf496e005,0xf5aad005}},	//   留或, 都用, 区香, 家路
  { {0xfb545009,0x00000003,0x00000003,0x00000003}},	//   能用,   ,   ,
  { {0xfb5cb00e,0xf82fc009,0xf936f001,0xf594b001}},	//   度目, 由上, 依分, 原蛋
  { {0xfb827006,0xf9191006,0xf9259004,0xf49ae008}},	// [ab0] 合理, 室内, 利待, 常陸
  { {0xf9449004,0xfb61d004,0xfb7f9004,0xf8360005}},	//   合基, 敬的, 率等, 出下
  { {0xfb65300b,0xf59a7004,0xf9135005,0xf8200005}},	//   支給, 要超, 国多, 指一
  { {0xf91b5009,0xf916f004,0xf924b001,0xf932b00c}},	//   日天, 出四, 早安, 料安
  { {0xfb69700b,0xf596f007,0xf91fd00a,0x00000003}},	//   全然, 食衣, 正午,
  { {0xf921d006,0xf826200b,0xf5c66004,0xf9359005}},	//   班子, 完了, 在超, 会失
  { {0xf917b001,0xfa524002,0x00000003,0x00000003}},	//   書屋, 多才,   ,
  { {0xf5ad000f,0xfb625009,0xfa8a8004,0x00000003}},	//   起買, 路等, 快新,
  { {0xfa4c8009,0xf5a4f001,0xf9359001,0xf5aad005}},	//   民文, 事表, 生多, 低能
  { {0xfa834007,0xf832c009,0xf5b7e001,0xf5bbe004}},	//   業書, 西中, 人質, 入股
  { {0xf93ab007,0xf5c8a004,0xf9465008,0xfb555005}},	//   果共, 八角, 運命, 施相
  { {0xf4ab000e,0xfa7e4004,0xf4c2d00c,0xf913d005}},	//   未選, 你提, 片都, 西平
  { {0xf4b99007,0xfa648004,0xfa4fc001,0xf9219004}},	//   一集, 不漏, 五成, 次年
  { {0xf80e8009,0xf9205007,0x00000003,0x00000003}},	//   字会, 業後,   ,
  { {0xfa4e2009,0xf4a9e004,0x00000003,0x00000003}},	//   得擅, 浪首,   ,
  { {0xf938f00a,0xf82ee005,0xfb84d005,0xfa88c005}},	//   一希, 声下, 奈特, 巫溪
  { {0xf80ac004,0xf9397004,0xfb537001,0xfa618005}},	// [ac0] 成事, 所必, 花田, 文推
  { {0xf9167001,0xf940f004,0xf9419001,0xf4c7b005}},	//   呼呼, 有希, 等均, 小非
  { {0xf81b0004,0xfa684004,0xfb56d005,0xf93ed00c}},	//   求上, 量投, 方立, 的度
  { {0xf83d2007,0xf80be007,0xf92d5009,0xf91cd004}},	//   加一, 我介, 限度, 以德
  { {0xf92e5005,0xf92dd00c,0xfa766005,0xf5bb2005}},	//   列内, 外原, 建敏, 知自
  { {0xf9111001,0xfa7c0004,0xf4c59005,0xf935d00d}},	//   地勢, 警民, 前食, 也向
  { {0xf8214001,0xfb4cf005,0xf92dd005,0x00000003}},	//   按一, 洲等, 金全,
  { {0xfb60100b,0xf817a001,0xfa7c2004,0xf841600a}},	//   条第, 菜一, 赤水, 夢中
  { {0xfa67000f,0xfa55a009,0xfb87b007,0xf92cb001}},	//   行法, 会新, 式生, 寓大
  { {0xf925100f,0xf920b004,0xf91a5001,0xf8106004}},	//   種子, 中如, 常因, 法也
  { {0xfa4e0007,0xf8316001,0xfa4da004,0xfa752001}},	//   殖民, 拿了, 易新, 格林
  { {0xfb4c700b,0xf5bf2001,0xfa606001,0xf82be008}},	//   年目, 形而, 情書, 職中
  { {0xfa834008,0xfa640004,0x00000003,0x00000003}},	//   中核, 予支,   ,
  { {0xf921b006,0xfa750004,0xf93fb001,0xf4906005}},	//   本市, 格法, 震後, 音郭
  { {0xfa5c0001,0xf91b1005,0xfb5a100c,0x00000003}},	//   言承, 室大, 役申,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf941700f,0xfa802004,0xf4aa2004,0xfa716004}},	// [ad0] 等待, 中涉, 当配, 新性
  { {0xf80be006,0xf92bf009,0xf595b007,0xf814e004}},	//   刑事, 向前, 領袖, 会以
  { {0xf91bd004,0xf826a005,0xfb591005,0x00000003}},	//   以学, 友俱, 此病,
  { {0xf8270009,0xf594d00e,0xfb6ab007,0xfa6a6004}},	//   位以, 通費, 間約, 迎春
  { {0xf914b008,0xfa68200c,0xf82a600c,0x00000003}},	//   幼少, 行此, 野人,
  { {0xf9307009,0xfb535001,0xf91a7005,0x00000003}},	//   列入, 命線, 学先,
  { {0xf92dd007,0xf48d2004,0xfa62e005,0xfb87f005}},	//   外借, 破除, 三氯, 同群
  { {0xf814e009,0xfb5a9004,0xf941d004,0xf5b84008}},	//   料修, 来生, 率可, 除菌
  { {0xfa512007,0xfa5bc004,0xf5ad7004,0xf5b5e001}},	//   北東, 品注, 段路, 能走
  { {0xf930100e,0xf8348004,0xf90ab005,0xf931d00c}},	//   南口, 好中, 其公, 際分
  { {0xf90c5001,0xf9455004,0xfb597002,0x00000003}},	//   水嫩, 而同, 船管,
  { {0xf910b004,0xf940d005,0xf9463005,0xf918500a}},	//   英勇, 吉克, 名叫, 樹園
  { {0xf5adb00e,0xf5c0e004,0xf91ed004,0xf929700a}},	//   創設, 中超, 性好, 師匠
  { {0xf92db009,0xf498800c,0x00000003,0x00000003}},	//   民利, 吸震,   ,
  { {0xf5aa5001,0xf5bd4008,0xfa4f2004,0xf592b001}},	//   傷者, 大聖, 村沼, 棕色
  { {0xf93a9007,0xf921700c,0x00000003,0x00000003}},	//   局南, 業原,   ,
  { {0xfa798009,0xf4b1500e,0xf91e7001,0xfb53300c}},	// [ae0] 交搜, 衛門, 你展, 命甘
  { {0xf4bbd00f,0xf93d3004,0xf939f001,0x00000003}},	//   市集, 内先, 送完,
  { {0xf80f2009,0xf9405004,0xf9379004,0xfa806004}},	//   五万, 分外, 思域, 院成
  { {0xf91fb001,0xfa53c00c,0x00000003,0x00000003}},	//   勢必, 供查,   ,
  { {0xf81c4007,0xf4a82004,0xf9247008,0xf940f005}},	//   迄今, 全院, 飯器, 包地
  { {0xf8252006,0xf9401001,0xfa6f0005,0xfa68e005}},	//   界上, 談心, 地漏, 税期
  { {0xf9145004,0xf5c0e00a,0xf5a7f010,0x00000003}},	//   国利, 連複, 行財,
  { {0xfb645009,0xf90fd004,0xfb66d001,0xfb4d500c}},	//   本稿, 甲基, 種現, 場特
  { {0xf5c0e00f,0xfa8be009,0xf93df009,0xf925f004}},	//   業者, 洪水, 的宗, 周小
  { {0xf930100f,0xf9481001,0xf8296001,0xfb7c7008}},	//   法官, 同基, 家了, 心療
  { {0xf93c900f,0xf4b4b007,0xfb667004,0xfa59c004}},	//   娃娃, 默默, 用爆, 要手
  { {0xf4a60007,0xf90f3004,0xfb5d7004,0xfb57900c}},	//   雨量, 地参, 池的, 典版
  { {0xf59c9007,0xf5939009,0xf931100c,0xf9369005}},	//   寄認, 香菇, 林山, 生利
  { {0xf911f008,0xfa7dc004,0xfa5e0005,0x00000003}},	//   報公, 股有, 故情,
  { {0xf944b00f,0xfa77e009,0xfa542009,0xf48dc001}},	//   益分, 活方, 高明, 水防
  { {0xf4912004,0x00000003,0x00000003,0x00000003}},	//   就餐,   ,   ,
  { {0xfa666007,0xf5967004,0xf943b004,0xfa52e001}},	// [af0] 車業, 也表, 先在, 四湖
  { {0xf9199007,0xf4aa200e,0xfa7e600e,0xf4974004}},	//   人報, 体重, 給水, 特邀
  { {0xfa7fe00f,0xfa5f0001,0xf4c65005,0x00000003}},	//   加拿, 分時, 手都,
  { {0xfa5ee004,0x00000003,0x00000003,0x00000003}},	//   求更,   ,   ,
  { {0xfb64f00f,0xf81c4004,0xf940b004,0xf4892004}},	//   微笑, 一串, 光合, 其附
  { {0xf941d007,0xf91d3001,0xf48fc004,0xf928d001}},	//   月後, 別年, 地通, 快快
  { {0xf80d0008,0x00000003,0x00000003,0x00000003}},	//   傑作,   ,   ,
  { {0xfb86b007,0xfb59b001,0xf8298001,0xf932d005}},	//   手環, 油炸, 長今, 毛尖
  { {0xfb6c5009,0xf92b5009,0xf90b7005,0xfa4f000c}},	//   少的, 道域, 德利, 法授
  { {0xf8424004,0xf488c005,0xfa55200c,0xfb85b00c}},	//   公会, 件配, 宙探, 手無
  { {0xf922900c,0xf9333005,0xf491000c,0xfa6f8005}},	//   代婦, 多宝, 女選, 芳村
  { {0xf5bb2004,0xf5baa008,0xfb6ed004,0xfb4d3008}},	//   以表, 室蘭, 林生, 長男
  { {0xf9439007,0xf81fc004,0xfb4fb00a,0x00000003}},	//   粉刺, 者代, 新線,
  { {0xfa560007,0xf848a001,0xf91e5004,0xf9453004}},	//   高普, 全人, 章子, 行先
  { {0xfa5f2009,0xf5a25004,0xfa56c004,0xf929500c}},	//   商情, 先考, 期是, 雨具
  { {0xf826a004,0xf4c4f008,0xf942900c,0xf4bd900c}},	//   双休, 車高, 唇卸, 胃道
  { {0xf8190001,0xfa4ce00c,0xf493200c,0x00000003}},	// [b00] 依主, 取所, 尾酒,
  { {0xfb67f009,0xfa656004,0xf5935001,0xfb803001}},	//   天白, 不惜, 定補, 者登
  { {0xf93a9009,0xf911d001,0x00000003,0x00000003}},	//   所取, 西向,   ,
  { {0xf5c3a007,0xfb7ed004,0xf4a66008,0xfb63500a}},	//   修行, 了美, 部附, 中綿
  { {0xf920d00b,0xfb75b006,0xfa58400e,0xf91df004}},	//   漢字, 聘用, 回日, 胡同
  { {0xfa7bc009,0xf4c79001,0xf929d001,0xfa4f0005}},	//   度搜, 前都, 寒必, 他正
  { {0xf4ada005,0xf93c300c,0x00000003,0x00000003}},	//   北郊, 考完,   ,
  { {0xf93a100c,0x00000003,0x00000003,0x00000003}},	//   一原,   ,   ,
  { {0xf5c42006,0xf9287008,0xfa782004,0xf8096004}},	//   路街, 太刀, 容村, 排一
  { {0xf9433009,0xfa59a004,0xfb50d004,0xfa67c00c}},	//   指地, 品消, 避税, 才想
  { {0xf8464008,0xf5c9e00a,0xf827a005,0x00000003}},	//   目以, 輪自, 量会,
  { {0xf92ab004,0xf944d004,0xf94a3005,0x00000003}},	//   体分, 珍品, 每家,
  { {0xf83a400f,0xfa75c004,0xf92a7004,0xfa812005}},	//   工保, 治文, 身就, 卡汽
  { {0xf5b3e004,0xf9325004,0xf81fa001,0x00000003}},	//   值超, 多城, 片下,
  { {0xfb8ab004,0xfa5b6005,0xf936900c,0x00000003}},	//   李白, 市每, 生助,
  { {0xf947d006,0xf8428004,0xfa4d000c,0xfa76c005}},	//   融危, 代信, 化概, 系或
  { {0xfb761009,0xf83de004,0xf5adb005,0x00000003}},	// [b10] 高端, 性中, 育者,
  { {0xf5bc2004,0xf91f1004,0xf821c001,0xf83de00c}},	//   大超, 止妊, 版事, 凡事
  { {0xfb82500f,0xf91ef001,0xfa728004,0xf90c7001}},	//   合約, 性平, 新水, 長出
  { {0xf4c69007,0xfa5ec004,0xf933d005,0xf48f800c}},	//   小額, 的次, 会得, 細項
  { {0xf9263006,0xfa72400f,0xfb757009,0xf92f5004}},	//   在市, 都有, 婚礼, 算外
  { {0xfa72400f,0xfa814004,0xf92bd004,0xf912b001}},	//   能有, 中晚, 易得, 由基
  { {0xf941500f,0xf4a2c005,0xf9371005,0xfa714005}},	//   分別, 公道, 真加, 花村
  { {0xf93df00f,0xf942f001,0xf599b00c,0xf93d1010}},	//   的字, 月原, 初購, 七宝
  { {0xfa554005,0xf5aed005,0x00000003,0x00000003}},	//   余次, 洲街,   ,
  { {0xfb7cb009,0xf593f007,0xf94a1005,0xf9129005}},	//   要特, 通膨, 小号, 就出
  { {0xf8406009,0xfa546001,0xf5a19001,0xf4988001}},	//   代企, 務拓, 帆船, 攻防
  { {0xf945d004,0xf488c00c,0x00000003,0x00000003}},	//   手大, 件重,   ,
  { {0xfa548004,0xf83f0004,0xf9347005,0xfa65c00c}},	//   沙溪, 造中, 余字, 屋日
  { {0xfa7a800e,0xfa556007,0xfb787001,0xfb861004}},	//   古本, 生指, 果真, 行病
  { {0xf5b13009,0xfa67200c,0xf93ad005,0xf9201005}},	//   佳能, 小情, 菜地, 造平
  { {0xf9475006,0xfb6eb004,0xf495e00c,0x00000003}},	//   行全, 科特, 稻香,
  { {0xf5adf001,0xf9239004,0xf5a21001,0xfa52e00d}},	// [b20] 史記, 本形, 豆花, 展扶
  { {0xfa5f200c,0xfa6c0005,0x00000003,0x00000003}},	//   善方, 德模,   ,
  { {0xfa7b6004,0x00000003,0x00000003,0x00000003}},	//   以支,   ,   ,
  { {0xf9281005,0xfb66f005,0x00000003,0x00000003}},	//   天平, 天独,   ,
  { {0xfa4d4005,0xfa666005,0xfa59800d,0x00000003}},	//   洗消, 福泉, 局情,
  { {0xfa690004,0xf8394005,0xf91ed00c,0xf916f00d}},	//   家最, 入三, 座右, 死在
  { {0xfa6a4004,0xf9207004,0xf492200c,0xf58f300a}},	//   收或, 管大, 山難, 民話
  { {0xf944300f,0xf91c9004,0xf4bd700a,0xf8214005}},	//   配合, 警器, 元金, 分交
  { {0xfa5a0004,0xfa872001,0xf9159008,0xfa5f0005}},	//   一搜, 復正, 格公, 梅林
  { {0xfa7b000e,0xfb6e9008,0xf80e6004,0xfa5d8001}},	//   日比, 外編, 比之, 者服
  { {0xf8246005,0xf9101005,0xfb89900c,0x00000003}},	//   前介, 地少, 纏綿,
  { {0xf4c5f009,0xf94a1004,0xf9227004,0x00000003}},	//   及部, 小偷, 面就,
  { {0xfa5ec006,0xf4924006,0xf91c9006,0xf48b800b}},	//   元旦, 声音, 武器, 段階
  { {0xf921f00c,0xf58e500c,0x00000003,0x00000003}},	//   客入, 胖胖,   ,
  { {0xf9471004,0xf4b6500c,0xf90fb00c,0x00000003}},	//   前大, 保額, 史座,
  { {0xf58fb001,0xfa4da004,0xf821c004,0x00000003}},	//   取諾, 向未, 版下,
  { {0xfb6bb00f,0x00000003,0x00000003,0x00000003}},	// [b30] 術研,   ,   ,
  { {0xf9473004,0xf8252001,0x00000003,0x00000003}},	//   小商, 額付,   ,
  { {0xf5a2f00b,0xf93fd006,0x00000003,0x00000003}},	//   下車, 黄山,   ,
  { {0xf49b4008,0xfb7d1005,0xfa4f400a,0x00000003}},	//   童館, 十百, 純愛,
  { {0xf9099001,0xfb5e300c,0x00000003,0x00000003}},	//   買再, 次私,   ,
  { {0xf9199001,0xf9095001,0xf8140005,0xf90b900c}},	//   人失, 件分, 牛人, 貴州
  { {0xfa5c6001,0xfa77c005,0xf935d00c,0xfb649002}},	//   逃漏, 出汗, 教司, 差甚
  { {0xfb78b009,0xfb5cb004,0xfb6b5004,0xf5ba8004}},	//   淀粉, 以由, 太白, 度越
  { {0xf8352009,0xfa736007,0xf93f3004,0xfb68b004}},	//   百件, 花東, 分包, 部特
  { {0xf90b7001,0xf8226005,0xf4b08005,0x00000003}},	//   迷彩, 切交, 受阻,
  { {0xf4c17001,0xf91e1001,0xf825400c,0xfa5ae00c}},	//   三集, 度報, 牌介, 需是
  { {0xfa6e800f,0xfb85d00e,0xfb4c9004,0xf4beb004}},	//   防毒, 同組, 具特, 商量
  { {0xf9479001,0xf92f7005,0xf59b100c,0xf935300c}},	//   像力, 列化, 時行, 站宣
  { {0xfb52b001,0xf4b83004,0xfa55400a,0xf9159005}},	//   報特, 果通, 官民, 能忽
  { {0xf5b7e004,0xf48d4001,0xf4a98004,0xf947f004}},	//   人航, 側選, 八面, 牌大
  { {0xf5bb0006,0xfb78700c,0x00000003,0x00000003}},	//   以自, 菜瓜,   ,
  { {0xf92db006,0xf4c9b001,0x00000003,0x00000003}},	// [b40] 著名, 量避,   ,
  { {0xf846c006,0xfb847004,0xfa71400a,0x00000003}},	//   全会, 融界, 政情,
  { {0xf5a23009,0xf946d004,0xfa762004,0xf5a65005}},	//   先要, 位学, 尼日, 双脚
  { {0xf932d001,0xf8264008,0xfa63200c,0xfa58a00d}},	//   力協, 題付, 下才, 果提
  { {0xfa684007,0xf8232004,0xfb54d005,0xf92ed005}},	//   背書, 手下, 活等, 著增
  { {0xf5b11009,0xfb6df001,0xf91a9005,0x00000003}},	//   花菜, 瞑目, 日增,
  { {0xfa818008,0x00000003,0x00000003,0x00000003}},	//   設機,   ,   ,
  { {0xf80d6009,0xf4c99004,0xf59ff005,0xf5c0200c}},	//   得上, 税部, 将近, 難行
  { {0xf9321001,0xfb8a1008,0xf9267005,0xfb78f005}},	//   做完, 問箱, 器分, 着美
  { {0xf945300f,0xfa6f2005,0xfa4c2005,0xf9147005}},	//   配備, 平果, 析材, 格初
  { {0xf94af00f,0xf919f001,0xf9117010,0x00000003}},	//   明山, 知各, 台座,
  { {0xf9301004,0xf4b2c004,0xfa6d600c,0xf93df00c}},	//   拔尖, 通集, 涵括, 的塗
  { {0xfb59300f,0xfb4ff009,0xf5923004,0xf9123005}},	//   此篇, 地生, 会行, 地就
  { {0xfb821009,0xf91c9009,0xf8480007,0xf92dd004}},	//   但由, 入国, 質上, 金在
  { {0xf9129006,0xf5a45017,0xfa6c2001,0xf922b005}},	//   山区, 位行, 水沖, 中因
  { {0xf4c1f001,0xfa722004,0xf9409005,0xf925d005}},	//   很重, 放情, 万宝, 周前
  { {0xfa888009,0xfb74300c,0xf9289005,0x00000003}},	// [b50] 用来, 忘紀, 用区,
  { {0xf949b007,0xf911f00e,0xf93b3001,0xf59dd00a}},	//   規命, 調子, 需加, 七輪
  { {0xfa798009,0xfa54400c,0xf842600a,0xf90a7002}},	//   方性, 記所, 連中, 場和
  { {0xf48b2007,0xfa74e005,0xf947500d,0x00000003}},	//   長青, 国次, 行器,
  { {0xfa784006,0xfa5f2004,0xf931b00c,0x00000003}},	//   人是, 故或, 五味,
  { {0xf4bc5009,0xf83de008,0xf9199008,0xf93bb008}},	//   的配, 凡例, 工品, 節句
  { {0xfa668006,0xf90dd007,0xfb73700c,0x00000003}},	//   不断, 年報, 料組,
  { {0xf923f00e,0xfa8ae004,0xf9257001,0x00000003}},	//   端子, 含水, 義商,
  { {0xfa62800e,0xfa594008,0xfa79a001,0xf9443001}},	//   文方, 回更, 春意, 載報
  { {0xf92b7006,0xfa806009,0xf5b9a001,0xfb88b004}},	//   太平, 院提, 別規, 明生
  { {0xf921700f,0xf48e2004,0xf917d001,0xfb6a9005}},	//   管制, 串通, 出優, 打私
  { {0xf48ec007,0xf936b004,0xfa53c00a,0xf5a8f00c}},	//   地開, 租公, 供日, 家裏
  { {0xf933f004,0xfa738004,0xf93bd004,0xfa4ea008}},	//   定外, 就更, 求商, 金澤
  { {0xfa68600f,0xf82ee00f,0xfb607009,0xfa6b0004}},	//   然有, 議事, 中美, 水情
  { {0xf80e6006,0xf92e5007,0xf5ca200a,0x00000003}},	//   比例, 翔律, 航路,
  { {0xfa86600f,0xf93c5001,0xf9421008,0xf92ff00c}},	//   支援, 射屋, 有償, 何分
  { {0xf5b94001,0xf497a005,0x00000003,0x00000003}},	// [b60] 方負, 点集,   ,
  { {0xf92ab005,0x00000003,0x00000003,0x00000003}},	//   子午,   ,   ,
  { {0xfb865004,0xf92dd001,0xf939d004,0xf4a16005}},	//   友社, 著小, 要同, 劣食
  { {0xf941d005,0xfb68d00a,0xf91c9005,0xf83b400c}},	//   三宝, 孫策, 日值, 苦了
  { {0xfa83400c,0x00000003,0x00000003,0x00000003}},	//   中游,   ,   ,
  { {0xfa598006,0xf9443009,0xf4962001,0xf4bb1001}},	//   激情, 下功, 格除, 門連
  { {0xf4c51008,0xf943d00c,0x00000003,0x00000003}},	//   車通, 手必,   ,
  { {0xf5c1e006,0xf912700b,0xfa7a400e,0xf9377009}},	//   代表, 便利, 相模, 高地
  { {0xf58e7001,0xf9319004,0xf5cb6008,0xf592500c}},	//   外航, 辛庄, 酪農, 定認
  { {0xfa4fc004,0xf935f004,0xf9293005,0x00000003}},	//   外派, 期向, 在危,
  { {0xfa5ee004,0xf9403004,0xf926100d,0x00000003}},	//   了意, 病区, 天向,
  { {0xf48f2001,0xfb765008,0xfa808001,0x00000003}},	//   到退, 務署, 正時,
  { {0xfa52a00f,0xf9491006,0xfb495004,0xf9347005}},	//   定時, 里巴, 海等, 些影
  { {0xf919b005,0x00000003,0x00000003,0x00000003}},	//   人康,   ,   ,
  { {0xf4a3e004,0xf946d00c,0xfb6cd005,0xf58a3005}},	//   微量, 刊別, 外税, 染行
  { {0xfa64200b,0xfa574007,0xf910d00c,0x00000003}},	//   計測, 生性, 音室,
  { {0xf91bf006,0xf4c4d005,0xf93c7005,0x00000003}},	// [b70] 大市, 上集, 各小,
  { {0xfa672005,0x00000003,0x00000003,0x00000003}},	//   行抗,   ,   ,
  { {0xf5a69007,0xf92dd009,0xf4aec004,0xfa888004}},	//   住行, 金周, 得非, 用查
  { {0xfa774004,0xf93db004,0xfa7f6008,0xf943d004}},	//   容概, 心受, 校法, 案在
  { {0xf4a8a005,0xf93e900c,0xfa540002,0x00000003}},	//   八道, 理名, 痛批,
  { {0xfa624008,0xf5a6f00a,0x00000003,0x00000003}},	//   安易, 養費,   ,
  { {0xf4b2a001,0xfa662004,0xf931d005,0xf4bf100c}},	//   動都, 程承, 五山, 順遂
  { {0xf4cb3005,0xf4c3900a,0x00000003,0x00000003}},	//   炎陵, 見附,   ,
  { {0xfa514006,0xf5c64009,0xfa79a004,0xfb565001}},	//   得更, 部考, 查意, 格特
  { {0xf9451004,0xf8492004,0x00000003,0x00000003}},	//   前必, 未作,   ,
  { {0xf91c9004,0xf827a002,0x00000003,0x00000003}},	//   警在, 而代,   ,
  { {0xf943b009,0xf8426001,0xf8416005,0xf814800c}},	//   例分, 維京, 中作, 察事
  { {0xf9143007,0xf82ea004,0xfa78800a,0xf911d005}},	//   抽取, 数上, 油暖, 由天
  { {0xfa534004,0xf5b1b001,0x00000003,0x00000003}},	//   仙桃, 東航,   ,
  { {0xf5b05007,0xf93cd001,0xfa8be001,0xf810e005}},	//   報考, 的善, 質更, 供上
  { {0xf93f7004,0xfb6e9005,0x00000003,0x00000003}},	//   文安, 金碧,   ,
  { {0xf9465007,0xf8170004,0xf59b1004,0xf58a1001}},	// [b80] 滋味, 乞丐, 市越, 道車
  { {0xf93cb001,0xfa520004,0xfa5f4008,0xf590f00a}},	//   千千, 法添, 理沙, 字色
  { {0xfa84e001,0xf945d005,0x00000003,0x00000003}},	//   種機, 届北,   ,
  { {0xfa6f6001,0xf818a001,0xfb7ef001,0xf91df005}},	//   仲業, 糞便, 項研, 大因
  { {0xfa69000f,0xf917d008,0xf9279005,0x00000003}},	//   究所, 人志, 用含,
  { {0xf937b007,0xfa5ec001,0xf90c3004,0xfa528005}},	//   朝向, 心急, 暴利, 会流
  { {0xf911b001,0xfb609001,0xf4c3d00c,0xf93ff005}},	//   山岩, 校系, 予適, 待室
  { {0xf91f900f,0xfa4a8004,0xfa79000a,0xf9129002}},	//   加入, 易流, 竹本, 政天
  { {0xfa534008,0xf9139005,0x00000003,0x00000003}},	//   線機, 款全,   ,
  { {0xf8238007,0xfa4ba004,0xf92a5001,0xfa64800c}},	//   友一, 向消, 間小, 型成
  { {0xf9267009,0xfa53a009,0xf945f007,0xf93f5004}},	//   修建, 教文, 開出, 内在
  { {0xf5c6e002,0x00000003,0x00000003,0x00000003}},	//   森購,   ,   ,
  { {0xfa7b0007,0xfa66a001,0xf92a5005,0xf81c6010}},	//   入法, 筋混, 未形, 元住
  { {0xfa51a004,0xfb7cf004,0x00000003,0x00000003}},	//   供担, 市番,   ,
  { {0xf9229004,0xfa740005,0xf830c00c,0xf92b9005}},	//   中形, 使新, 共乘, 当引
  { {0xfa840006,0xf93df001,0xf93ff005,0xfa61400c}},	//   公斤, 的套, 的兵, 集日
  { {0xf91a7009,0xfa52200e,0xfb61100e,0xf9313007}},	// [b90] 学合, 法改, 面目, 魔幻
  { {0xf9123004,0xf91d3008,0x00000003,0x00000003}},	//   国光, 若年,   ,
  { {0xfa64800f,0xfb4c500c,0xf5c1000a,0xfa7f200d}},	//   泉水, 場用, 本興, 碧海
  { {0xfb863006,0xf9393004,0xfb893005,0xf91a9002}},	//   残疾, 一刀, 行直, 甸基
  { {0xf91f7006,0xf941f007,0xfa66a007,0xf4be9009}},	//   加大, 合式, 融業, 隆重
  { {0xfb643004,0xf93ab005,0xfb787005,0x00000003}},	//   修的, 果就, 果生,
  { {0xfa5ca00f,0xf5b9300e,0xfa5ac009,0xf90b500a}},	//   心情, 特設, 阜新, 創刊
  { {0xfb77100e,0xfb727001,0xf8388001,0xfa5ca00c}},	//   高精, 四科, 船井, 濃情
  { {0xf8254001,0xfa79a001,0xfa7c2002,0x00000003}},	//   再付, 出海, 入此,
  { {0xfb4af00b,0xf93f1004,0xf9141001,0xfa634005}},	//   整理, 善基, 飽優, 嘉欣
  { {0xf80f6001,0xfb77d001,0xf924b008,0xf4a2e00d}},	//   動介, 原社, 本共, 硬道
  { {0xfa826004,0xfb4b5004,0xf939d00a,0xfb65700c}},	//   口本, 起火, 保冷, 良知
  { {0xfa498001,0xf8476001,0xf599d001,0xf836800a}},	//   互持, 助你, 送車, 人企
  { {0xf5c02007,0xfa7cc009,0xf5a29008,0xfa646004}},	//   口袋, 度是, 三輪, 上每
  { {0xf93f7004,0xfa72c005,0x00000003,0x00000003}},	//   商定, 板是,   ,
  { {0xfa840007,0xf9351001,0xf8256008,0xf935d001}},	//   拯救, 弟兄, 損保, 紙巾
  { {0xfa84e007,0xf592f001,0xf5a7500c,0xf919f00c}},	// [ba0] 詩歌, 望自, 伊能, 方巾
  { {0xfb491004,0xfb4ad001,0xfa4a8008,0xfa85e00c}},	//   家私, 暴的, 韓流, 可抽
  { {0xf59a300e,0xf9461001,0xfa6ee00d,0x00000003}},	//   言語, 後分, 地拍,
  { {0xfa4ce005,0xfb4d300c,0xfa67200a,0xf90c5005}},	//   化最, 場移, 小清, 水天
  { {0xfb5a700a,0xf4ac600a,0xf8176018,0x00000003}},	//   俸給, 術院, 關于,
  { {0xfb70d00f,0xfb759009,0xf4b78004,0xfa778004}},	//   受現, 会由, 作配, 改情
  { {0xf4a8400b,0xf9475004,0x00000003,0x00000003}},	//   表面, 行在,   ,
  { {0xfb6e1001,0xfa510004,0x00000003,0x00000003}},	//   村第, 比武,   ,
  { {0xfb5d5001,0xf5947001,0xf48f8001,0xfb4b300c}},	//   因的, 定設, 米酒, 護研
  { {0xf92a500f,0xf9443004,0xf80f6001,0xf93cb005}},	//   青少, 下原, 動事, 心商
  { {0xf81d8001,0xfa5a6005,0xf919700a,0x00000003}},	//   情不, 所投, 肥後,
  { {0xf915300e,0xfa702001,0xfa7a4008,0xfa57600c}},	//   鬼太, 到民, 相次, 停服
  { {0xfa5c0004,0xf9445004,0xf9179001,0xf5b85008}},	//   一派, 上城, 基底, 電製
  { {0xfa590004,0xfa5f2005,0xf4aae005,0x00000003}},	//   址意, 病株, 道集,
  { {0xfb66b009,0xf91b700e,0xf81ba001,0xfa520004}},	//   表率, 警備, 所人, 法活
  { {0xf823a00f,0xfa54c009,0xf922b007,0xfa602004}},	//   等人, 供更, 業加, 病治
  { {0xf83ca007,0xfa5ce004,0xf919700c,0xf5b1f00c}},	// [bb0] 大作, 求或, 伸展, 想致
  { {0xf5a37001,0xfb843004,0xfa586004,0xf92b7005}},	//   合著, 滋生, 生水, 坪山
  { {0xfa70a009,0xf48e6009,0xf5c82001,0xfb755004}},	//   新推, 色金, 全解, 沙瓦
  { {0xf9381001,0xf59e7001,0xfa6b0004,0xf8280004}},	//   保庫, 宅補, 明晰, 税一
  { {0xf5a5f009,0xf91d7001,0xf92e300c,0xfa77a005}},	//   行考, 試別, 或委, 治性
  { {0xf83ae005,0xfa88c005,0xf9355005,0xfb7e7005}},	//   交信, 在永, 盟商, 黄皮
  { {0xf82e0001,0xf92ef004,0xf92e7001,0xf4c09001}},	//   伴侶, 外客, 成其, 震驚
  { {0xfa6a0004,0xf4a22004,0xfa500001,0xf82b2001}},	//   件提, 本高, 林正, 水仙
  { {0xf9453009,0xf82f2001,0xf949f00c,0xf924f00c}},	//   行合, 女作, 式報, 港埠
  { {0xf5b3f006,0xfa6c8009,0xfb7a900e,0x00000003}},	//   格考, 年是, 禁煙,
  { {0xf81b4005,0xf80f2005,0x00000003,0x00000003}},	//   品体, 外信,   ,
  { {0xf93ad004,0x00000003,0x00000003,0x00000003}},	//   阜康,   ,   ,
  { {0xf912b004,0xf9239001,0xf5971005,0x00000003}},	//   好市, 業平, 付能,
  { {0xf9233009,0xfa5d4001,0xfa77a005,0xf4922005}},	//   是各, 約掛, 出投, 就那
  { {0xfb677004,0xf5ab3004,0xf9477005,0xfb899005}},	//   利管, 海街, 小定, 明目
  { {0xf90f5007,0xf5a7b004,0xfb6f9005,0xf82d2005}},	//   細心, 柏芝, 引着, 育不
  { {0xfa5b0006,0xf918b004,0xf911b004,0xfb50d005}},	// [bc0] 一是, 人学, 危化, 地皮
  { {0xf936300f,0xfb5a3009,0xf838e009,0xfb855001}},	//   回商, 入留, 出人, 今生
  { {0xf92f7009,0xfa618008,0xfa74600c,0xfa8be00c}},	//   殖健, 合案, 能早, 質柴
  { {0xfb7b5009,0xfb719004,0xfb5cb004,0xf5a3d00c}},	//   激素, 毛球, 素等, 蹈表
  { {0xfb7bb006,0x00000003,0x00000003,0x00000003}},	//   要用,   ,   ,
  { {0xf5b95006,0xf936300f,0xf80d0009,0xf91ef004}},	//   来越, 站已, 外企, 大危
  { {0xfa706009,0x00000003,0x00000003,0x00000003}},	//   山旅,   ,   ,
  { {0xf595500f,0xf813e007,0xf4c1b001,0xf5bd2008}},	//   甚至, 料保, 分都, 大輔
  { {0xf9257006,0xfa83e004,0xf9485001,0xf941f00c}},	//   支出, 是搞, 美分, 合小
  { {0xf935b007,0xf911f007,0xf9427001,0xf59df00c}},	//   務入, 右側, 片工, 善街
  { {0xf9197006,0xfb59500b,0xf4986001,0xfb7bb004}},	//   日前, 日立, 出離, 禁用
  { {0xfb737007,0xfb659008,0xf9163001,0xf9355005}},	//   教的, 全版, 旺宏, 娘子
  { {0xfb67900f,0xfb737009,0xf932f00c,0xf81fa005}},	//   快的, 留的, 力外, 情中
  { {0xf93c9009,0xf813e007,0xfa7d2008,0xf593b008}},	//   封建, 講人, 武池, 香辛
  { {0xfa7fc009,0xfa502001,0xfb4f1001,0xfa5b6004}},	//   波清, 受惠, 育種, 裁法
  { {0xfb7af00f,0xf915f004,0xf8326001,0xf5a5f008}},	//   一種, 固始, 東信, 立腺
  { {0xfa732007,0xf9447001,0xfa6da001,0xf59cf005}},	// [bd0] 命教, 名名, 張正, 市航
  { {0xf59a3001,0xf922900c,0xfa66200c,0x00000003}},	//   言詞, 業客, 立政,
  { {0xf812e007,0xf93f3004,0xf81a200c,0xf9331010}},	//   務介, 分内, 丁丁, 動制
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb4a7004,0xf8420001,0x00000003,0x00000003}},	//   其用, 括了,   ,
  { {0xf921f006,0xfa83c007,0xfa544009,0xfa68e009}},	//   正在, 可思, 多是, 明材
  { {0xf491200f,0xf935900e,0xfb7b5004,0x00000003}},	//   困難, 務大, 市税,
  { {0xfb59500b,0xfa50000f,0xf5aeb009,0xf93b500c}},	//   日程, 魔法, 女装, 一加
  { {0xf9447006,0xfb7a5004,0xfa59e004,0xfb755005}},	//   坊市, 封的, 繁母, 生爆
  { {0xf5a0b007,0xf9373009,0xf4c2d007,0xf9435001}},	//   三越, 保定, 切都, 有加
  { {0xf917d009,0xfa72e004,0xfa5ba004,0xfa50a001}},	//   区外, 尽情, 往日, 織業
  { {0xf5a61007,0xf58f1004,0xf9261001,0x00000003}},	//   名著, 村落, 種口,
  { {0xf59dd009,0xfa654004,0xf90bd001,0xfa51a00c}},	//   内要, 上搜, 冷冬, 力時
  { {0xfb7b5008,0xf90a300c,0x00000003,0x00000003}},	//   所管, 延展,   ,
  { {0xf9455001,0xfb7d1004,0xf4b98008,0x00000003}},	//   同名, 如用, 秀雄,
  { {0xf92cb00e,0xf910d004,0x00000003,0x00000003}},	//   易度, 米出,   ,
  { {0xf946b007,0xfa53a00c,0xfb62f005,0x00000003}},	// [be0] 友地, 教指, 景秀,
  { {0xf9381004,0xf812e001,0xf9293004,0xf5c90005}},	//   作分, 務事, 在共, 用足
  { {0xfb863009,0xfa6b0004,0xf932b005,0xf932f00c}},	//   立社, 水清, 供受, 四庫
  { {0xf8120001,0xfb67b004,0xf93a100a,0x00000003}},	//   五件, 部用, 紀州,
  { {0xfb74300f,0xf93c3004,0xfb50f001,0xf91af00d}},	//   多種, 一平, 失真, 交学
  { {0xfa5d4004,0xfa71c001,0xf8222005,0x00000003}},	//   市是, 松柏, 震信,
  { {0xfa53200f,0xfa5d8002,0x00000003,0x00000003}},	//   站所, 者才,   ,
  { {0xfb7e5009,0xf9463007,0xf8212004,0xf91b9004}},	//   市白, 歌劇, 光伏, 入公
  { {0xf90ff006,0xf4c29004,0xf92df004,0xfa728004}},	//   共同, 吉首, 外向, 山日
  { {0xf9251007,0xf90c1004,0xf90cf005,0xf91ef00c}},	//   可口, 年志, 夷山, 素可
  { {0xfa4c6009,0xf9173005,0xfb70700a,0xfa830005}},	//   成投, 丹参, 五目, 断性
  { {0xfb4a3007,0xfb897004,0xfa632001,0xfa49e005}},	//   長約, 福特, 計感, 粒沙
  { {0xfa816007,0xf4986001,0xf9303005,0xf80b8005}},	//   本服, 出面, 得尤, 提了
  { {0xfb6bf009,0x00000003,0x00000003,0x00000003}},	//   材生,   ,   ,
  { {0xf80da00b,0xfa796007,0xf5a13005,0x00000003}},	//   成人, 人格, 等老,
  { {0xf944f00c,0x00000003,0x00000003,0x00000003}},	//   籍商,   ,   ,
  { {0xf9413004,0xf93db00c,0x00000003,0x00000003}},	// [bf0] 分大, 晃動,   ,
  { {0xf4c81001,0xf80ce004,0xfa57c005,0xf4932005}},	//   意間, 民也, 州本, 都集
  { {0xf9449007,0xfa5e2004,0xf5c32004,0xfa4e4004}},	//   名小, 七是, 京航, 俗文
  { {0xf918300c,0xf912700c,0xfa70200d,0xfa71c002}},	//   系兼, 都希, 平是, 社服
  { {0xf9451004,0xfb56d005,0xfb7d300c,0xfa644005}},	//   月平, 出率, 市種, 配有
  { {0xfa5b000e,0xf9427009,0xf48da008,0xfa764005}},	//   一杯, 切入, 直進, 区明
  { {0xf82ce004,0xfa78c001,0xf492000c,0xfa762005}},	//   年信, 治水, 款需, 螺母
  { {0xf945f001,0xfa6f8004,0xfb761005,0xf92b500c}},	//   忍受, 新教, 川等, 道原
  { {0xf91b9004,0xfb545001,0xf93ef001,0xf5a5d004}},	//   入冬, 放空, 的室, 行要
  { {0xf930100e,0xf9357004,0xf920b00a,0xf92d7005}},	//   北口, 多平, 口元, 街坊
  { {0xf9465005,0xf93dd005,0x00000003,0x00000003}},	//   再在, 它外,   ,
  { {0xf915b004,0xf81e8001,0xf943300c,0xf4a2c00d}},	//   任分, 分事, 有客, 是配
  { {0xf4aac008,0xf833600c,0xf929300c,0xfb7eb00c}},	//   材開, 好作, 秒完, 雅筑
  { {0xf5b3d009,0xf4c39004,0xf81ee001,0xfb6a1008}},	//   格要, 炉除, 者互, 間程
  { {0xf4a6a009,0xf4c2b004,0xfb889004,0x00000003}},	//   在高, 予高, 双眼,
  { {0xfb6d1009,0xfa7b200e,0xf80ec001,0xfb5cb00a}},	//   村生, 相撲, 刑人, 左端

  { {0xf945f00f,0xf80ec00c,0x00000003,0x00000003}},	// [c00] 手工, 我人,   ,
  { {0xf82ac004,0xf9271004,0x00000003,0x00000003}},	//   年企, 皮具,   ,
  { {0xf925700e,0xf809e009,0xf914b008,0xfb6ad004}},	//   修士, 当今, 涼子, 被破
  { {0xf946d004,0xf82b2004,0xf9351004,0xfa56a005}},	//   反季, 念上, 期市, 州思
  { {0xfb58f007,0xf936700e,0xf92e3004,0xf4c33005}},	//   群的, 食器, 算内, 案金
  { {0xf5b0900f,0x00000003,0x00000003,0x00000003}},	//   地質,   ,   ,
  { {0xfa5e2007,0xfa646001,0xfb7f5001,0xf91e1004}},	//   堂書, 事成, 幅縮, 性因
  { {0xfb7c9007,0xfb857005,0xf498e00a,0xf8464005}},	//   要登, 届科, 常通, 木乃
  { {0xf923b006,0xf596500e,0xf92f3004,0xf90ef001}},	//   中共, 務課, 他学, 農夫
  { {0xf5c2a00f,0xf93e7009,0xf8236009,0xfb795004}},	//   可見, 市平, 立一, 果皮
  { {0xfb7e7009,0xf4af4001,0xfb807004,0xf94b3004}},	//   理程, 底鍋, 清白, 税地
  { {0xf82fa007,0xf4ad8001,0xf4c4300c,0xf498600c}},	//   山上, 怖驚, 光音, 除額
  { {0xf92e9006,0xf5c01007,0xf9463009,0xfb5d9004}},	//   成年, 你能, 界定, 旧物
  { {0xf845a00e,0xfb58d008,0xf91dd004,0x00000003}},	//   用上, 岸線, 照公,
  { {0xf4a46004,0xf5c84001,0x00000003,0x00000003}},	//   路部, 風趣,   ,
  { {0xf9149009,0xfa6a000a,0x00000003,0x00000003}},	//   好形, 式新,   ,
  { {0xf49c0009,0xf4c3d005,0xf90b9005,0xf92f300c}},	// [c10] 学金, 事高, 破土, 跑到
  { {0xf90bd004,0xf937d004,0xf90f3001,0xf9265008}},	//   巴勒, 洞庭, 細品, 館市
  { {0xf814a006,0xf5b09004,0x00000003,0x00000003}},	//   多信, 使行,   ,
  { {0xf92f5004,0xf93b1001,0x00000003,0x00000003}},	//   殖大, 送原,   ,
  { {0xf58cb009,0xf918d009,0xf5c78007,0xf59a9007}},	//   他行, 出去, 編著, 需自
  { {0xf931d008,0xfa69e001,0xf8482004,0x00000003}},	//   招待, 明正, 票中,
  { {0xfa662004,0xf59bd008,0xf93d5005,0xf4b7000c}},	//   立承, 脂複, 内刊, 生難
  { {0xfb6f700f,0xfb7f3009,0xfb75b001,0xf91e9005}},	//   策略, 各相, 料確, 卡充
  { {0xf931b004,0xf9383004,0xf8386001,0xf593700c}},	//   供商, 原地, 此下, 力設
  { {0xfb71100d,0xf83aa00d,0x00000003,0x00000003}},	//   暗箱, 警事,   ,
  { {0xfa598008,0xfa718004,0xf9245010,0x00000003}},	//   夜景, 山湖, 鮮居,
  { {0xfa4fe00b,0xfb65900e,0xfa4d8004,0xf9227001}},	//   何故, 物病, 限查, 面報
  { {0xf830a00b,0xfb595009,0xfa866009,0xf5c30004}},	//   承下, 容管, 用担, 斯蒂
  { {0xfb641004,0xfb595004,0xf8128004,0xf9479001}},	//   公系, 基石, 多企, 意力
  { {0xf4a24009,0xf93d7005,0xf82b800d,0x00000003}},	//   本通, 市客, 堵住,
  { {0xfa520001,0xf942f004,0xf58df005,0xfb64700c}},	//   比海, 秉公, 南藏, 本羽
  { {0xf5b93006,0xf90f9004,0xfa600004,0xfb803004}},	// [c20] 智能, 山安, 待日, 情系
  { {0xf933900f,0xf90b9001,0xfb777004,0xf9117005}},	//   務必, 場域, 州火, 款合
  { {0xf4978001,0x00000003,0x00000003,0x00000003}},	//   出道,   ,   ,
  { {0xf4932001,0xfb6bb001,0xfb6e300a,0xf93e5005}},	//   山防, 毒管, 字病, 故多
  { {0xf921f00e,0xfa66c009,0xfb5a500c,0xfa554005}},	//   劣化, 律援, 書給, 江文
  { {0xf90cf009,0xf499600c,0xfb85f005,0x00000003}},	//   年学, 以重, 越火,
  { {0xf592b005,0x00000003,0x00000003,0x00000003}},	//   孕育,   ,   ,
  { {0xfa640007,0xf597300c,0xf8394005,0x00000003}},	//   月潭, 生試, 略上,
  { {0xf918f007,0xf9375001,0xfa71a004,0xfa75e008}},	//   除商, 回庫, 新改, 陽新
  { {0xfa6a6006,0xf8360009,0xf9467009,0xfb6ff001}},	//   迎接, 活保, 程已, 法理
  { {0xfa518004,0xf9321004,0xf4abc008,0xfb58b00c}},	//   怕是, 法基, 間隔, 空無
  { {0xf93a3007,0xfb4bf007,0xf948b008,0xfa526005}},	//   一向, 件申, 偏差, 些材
  { {0xf943f008,0xf4adc001,0xf8464004,0xfa4bc004}},	//   三好, 南里, 在促, 金有
  { {0xf927f004,0x00000003,0x00000003,0x00000003}},	//   周六,   ,   ,
  { {0xf5b7f00f,0xf809e006,0xf825e004,0xf842a005}},	//   人自, 体上, 今世, 席代
  { {0xfa87e004,0xf809e004,0xfa59e001,0xf941d00c}},	//   在港, 当上, 要服, 合前
  { {0xf930d001,0xf4906004,0xfa66c005,0xf830800c}},	// [c30] 且因, 声道, 位次, 平信
  { {0xf947500a,0xf5b1300c,0x00000003,0x00000003}},	//   随分, 音調,   ,
  { {0xf4a9e00a,0xf90fb00d,0x00000003,0x00000003}},	//   園高, 平得,   ,
  { {0xf932b006,0xf5bc9001,0xf83cc004,0xf9447005}},	//   会各, 度表, 性作, 半壁
  { {0xf5b2900a,0xf4b1a00c,0xfa88600d,0x00000003}},	//   板表, 法連, 周慧,
  { {0xfa7b2005,0x00000003,0x00000003,0x00000003}},	//   入抗,   ,   ,
  { {0xf839e00f,0xf5b33004,0xf93bf00c,0xfa58600c}},	//   方便, 山花, 心律, 賞櫻
  { {0xf826e00f,0xfa600009,0xf4c6b004,0xfa65a005}},	//   服信, 了提, 行金, 反感
  { {0xf93b700f,0xf5c4c001,0xfa6e2004,0xfa73800c}},	//   技巧, 義行, 蒲江, 熱敷
  { {0xf93dd007,0xf593d009,0x00000003,0x00000003}},	//   的展, 通航,   ,
  { {0xf490c007,0xf4914004,0xfa60000d,0x00000003}},	//   細部, 山青, 的援,
  { {0xf93f3007,0xfb7c500e,0xf91a700c,0xf9431005}},	//   分必, 組立, 入勝, 月向
  { {0xf4b6800e,0xf917b004,0xf913900c,0xf920b005}},	//   非通, 特写, 能原, 院南
  { {0xfb817009,0xf810a004,0xf91ef005,0xf91b9005}},	//   理相, 研中, 大共, 学四
  { {0xfa62e006,0xf4c0e007,0xfa55e004,0xf4c7b001}},	//   三是, 安里, 也成, 配音
  { {0xf4c0c006,0xfa69a007,0xf840c001,0xf93a9001}},	//   病防, 意書, 凡人, 往南
  { {0xfb6bf009,0xfa69a00d,0x00000003,0x00000003}},	// [c40] 契税, 李振,   ,
  { {0xfa668001,0xfa69000c,0xf91ff00a,0x00000003}},	//   菌感, 式渡, 無差,
  { {0xfa840009,0xf4b56001,0xfa512004,0xfb7e3002}},	//   是成, 定都, 林新, 情留
  { {0xfa4ce001,0xf82f2004,0xfa83600c,0xfa5f400d}},	//   取最, 台一, 正想, 商文
  { {0xf5b25004,0xfb785004,0xfb6ef00c,0x00000003}},	//   新起, 食直, 翔的,
  { {0xf827800e,0xf90a5004,0xfa7ba004,0xf843e005}},	//   背中, 件列, 性恋, 京信
  { {0xf9421005,0x00000003,0x00000003,0x00000003}},	//   了影,   ,   ,
  { {0xf93a100f,0xfb88d001,0xfb84d00c,0xf940300c}},	//   作室, 舌異, 態研, 篇幅
  { {0xffd9a005,0xfb56f002,0x00000003,0x00000003}},	//   瀹ュ, 欺篇,   ,
  { {0xf5ca600e,0xf5a8f009,0xf4b56005,0xfa4e4005}},	//   士課, 行走, 也高, 志指
  { {0xf91fb006,0xfa7aa009,0xf9405009,0xf8336009}},	//   次全, 以成, 分化, 房交
  { {0xfa67000e,0xf9473004,0xf9309004,0xf926d001}},	//   後悔, 式密, 途客, 風力
  { {0xfb5fd008,0xf918d001,0x00000003,0x00000003}},	//   無用, 空大,   ,
  { {0xfb82d00f,0xfb83b009,0xf917f00a,0x00000003}},	//   三種, 合物, 尺八,
  { {0xf942d006,0xfa5ce00f,0xfa662004,0xf5b6f004}},	//   万平, 的故, 下派, 格走
  { {0xfa6d2006,0xf9357006,0xf5ac500e,0xf91b5004}},	//   水泥, 生存, 年表, 常山
  { {0xf916d007,0xf841c004,0xfb65b004,0xf9225004}},	// [c50] 特刊, 京企, 峨眉, 索尼
  { {0xf82a8005,0xfa5fe005,0xf938d00c,0xf947b002}},	//   海保, 率明, 門名, 伊德
  { {0xfb845004,0xf5a53008,0xf91f1008,0xf8262005}},	//   型生, 興課, 造形, 二万
  { {0xf9395004,0xf4afa005,0xf4c6b002,0x00000003}},	//   一如, 展送, 見郵,
  { {0xf945300f,0xfb571004,0xfb843005,0xfb5c900c}},	//   秋冬, 点税, 上牌, 急災
  { {0xfa80e009,0xf919d007,0xfa4e0001,0xf925b004}},	//   模板, 除夕, 受最, 用友
  { {0xf4af0006,0xfb767006,0xfa614008,0xfa5f2004}},	//   街道, 租用, 安時, 邃永
  { {0xfb79b008,0xf90a500a,0xfb689002,0x00000003}},	//   血症, 究委, 雪的,
  { {0xf5a2d001,0xfb51b00c,0x00000003,0x00000003}},	//   有表, 械系,   ,
  { {0xf5b11004,0xf49dc00a,0xfa5ee005,0xf4a3e00c}},	//   就近, 員養, 的氧, 目送
  { {0xfa5c2001,0xf49c6004,0xf939d004,0xf5ac500a}},	//   一格, 大高, 局多, 蠶蠶
  { {0xf9263004,0xf91ed004,0xfa60e00c,0xf910300c}},	//   在参, 大女, 光洋, 味可
  { {0xf58e5006,0xfa53000a,0xf93c1005,0xf938f010}},	//   民警, 愛撫, 遂川, 秀和
  { {0xfa658010,0x00000003,0x00000003,0x00000003}},	//   事条,   ,   ,
  { {0xfb591007,0xf5bd7008,0xfb881005,0xfb52700c}},	//   常生, 造装, 同示, 山群
  { {0xfb4b7009,0xfa520008,0xfb877004,0xf4a28001}},	//   家知, 何日, 意率, 湯鍋
  { {0xf844e006,0xf91ff007,0xfa6f8009,0xf830c004}},	// [c60] 息中, 季刊, 石材, 新亮
  { {0xfa73c008,0xfa834004,0xf917b00c,0xf48f2005}},	//   乾杯, 支情, 任室, 估量
  { {0xf83de006,0xf48ee001,0xf9101004,0xf817a00c}},	//   大代, 女高, 泰州, 生使
  { {0xf941d004,0xf9115001,0xfa674008,0xfa50e001}},	//   万客, 女女, 小文, 展演
  { {0xf90a3001,0xfa66c00c,0xfa7be00c,0xfa4c800d}},	//   康分, 位校, 卦村, 易患
  { {0xfb689007,0xf4a6c009,0xfa48e004,0xfb67f00c}},	//   全系, 在通, 酒泉, 木第
  { {0xf4c2e004,0xf924b004,0xf9323004,0xf5b6b001}},	//   予通, 本山, 比年, 活著
  { {0xfa86000b,0xf9373001,0xf8498004,0xf93ff005}},	//   目次, 機座, 身亡, 了少
  { {0xf930f001,0xf93f9001,0xf4c42008,0xfb7fd005}},	//   店報, 情公, 車運, 集科
  { {0xfa5f0009,0xfa59a009,0xf924f004,0xf5a31002}},	//   射性, 局文, 端口, 事而
  { {0xf934d004,0xfa63800c,0xf8306005,0xf5b2900a}},	//   定大, 友所, 女代, 己診
  { {0xf947d00c,0x00000003,0x00000003,0x00000003}},	//   忍具,   ,   ,
  { {0xf9333007,0xfb585007,0xf936f001,0xfa588004}},	//   動場, 示第, 依商, 停滞
  { {0xf90d7007,0xf849e009,0xfa4a400c,0xf4972005}},	//   致命, 被人, 姓氏, 示通
  { {0xf91b7005,0xfa842005,0xfb845005,0x00000003}},	//   入微, 售情, 版管,
  { {0xf5a75007,0xfa6ae004,0xf4a5a004,0xfb84b005}},	//   意者, 康成, 温高, 合相
  { {0xfb4db009,0xfb5c5001,0xf48ee005,0xf4b3c00a}},	// [c70] 署的, 工精, 地降, 高須
  { {0xfa592007,0xfa6c6007,0xfa61000c,0x00000003}},	//   一族, 買方, 均成,
  { {0xf491400e,0xf93fb004,0xf93e7004,0xfb667005}},	//   議院, 埃德, 市岳, 用理
  { {0xf9289004,0xfa4ca001,0xf8200005,0x00000003}},	//   用基, 袖洋, 率一,
  { {0xfa664009,0xfb853009,0xf5af1001,0xf5a9f008}},	//   上是, 同程, 異言, 護老
  { {0xf9345009,0xfb627009,0xf93b1004,0xf945b004}},	//   丘市, 本生, 品回, 益受
  { {0xfa624008,0xfb597001,0xf912500a,0x00000003}},	//   安打, 工福, 阿南,
  { {0xfb4e100e,0xf5b87004,0xf5bc7001,0xfa804001}},	//   申立, 出解, 度自, 業手
  { {0xf4c40004,0xf5b9f004,0xfb5a1004,0xfb60900c}},	//   事通, 入考, 此答, 辣的
  { {0xf916f007,0xf8106004,0xf9415001,0xf90eb010}},	//   改名, 南交, 商建, 露店
  { {0xf8496009,0xfa5a4001,0xfa85e005,0xfb85300d}},	//   器件, 持最, 在操, 和王
  { {0xfb519004,0xf9123002,0xf849c002,0x00000003}},	//   音箱, 穿孔, 陪他,
  { {0xf9301001,0xf92f5004,0xf9453001,0xfb765005}},	//   湖山, 算化, 籍定, 食糖
  { {0xf4a8e001,0xf4a82001,0xfa624004,0xf48f400a}},	//   倒閉, 用連, 集整, 乳類
  { {0xfa620007,0xfa6e8007,0xf92f5007,0xfa812009}},	//   勇敢, 新月, 林志, 面是
  { {0xfa790001,0xf909b001,0xfb5f100a,0x00000003}},	//   工消, 長名, 波紋,
  { {0xf4974009,0xf9197004,0xfb553008,0xf93d9004}},	// [c80] 区食, 入同, 兼用, 十家
  { {0xf9355008,0xf91a9005,0xfa64a00c,0xf91d700c}},	//   通帳, 学及, 積最, 試入
  { {0xf92d1009,0xf92cd009,0xf9125007,0xfa5b0008}},	//   外市, 子在, 走到, 品機
  { {0xf5937007,0xf91b3001,0xf8400004,0xfa51c001}},	//   講解, 層出, 正之, 際情
  { {0xf915b00f,0xfa754006,0xfb777001,0xf83f2004}},	//   災害, 施方, 官田, 止下
  { {0xf5a5300f,0xf948300b,0xf93ab007,0xfa6a0004}},	//   認識, 前年, 果報, 件材
  { {0xf4ba4009,0xfa716009,0xf8214004,0xfb4df005}},	//   局限, 政文, 掉一, 卵管
  { {0xf9195005,0xf9345005,0xf4c0200c,0x00000003}},	//   剥削, 通客, 順道,
  { {0xf938f001,0xf48b4001,0xf4974001,0xf83c0005}},	//   作展, 長途, 鼻頭, 大促
  { {0xf9421009,0xfa636004,0xfa4b8004,0xf928100a}},	//   了就, 王明, 荒漠, 暫定
  { {0xfb4f7004,0xf4a90004,0xf90a3002,0x00000003}},	//   彰的, 未通, 延宕,
  { {0xf814800b,0xf90ab00f,0xf9469009,0xfa736007}},	//   通信, 買回, 上加, 值服
  { {0xf4a14004,0xf81a4001,0xf90f500a,0x00000003}},	//   中通, 品係, 淳子,
  { {0xf5b85007,0xf9345001,0xf93f3005,0xfa7f800c}},	//   腸胃, 減害, 分居, 客最
  { {0xfa7fe008,0xf93ad005,0xf93fd005,0xf489e002}},	//   波文, 局利, 覆土, 制金
  { {0xfb55d00f,0xfb515009,0xf59c5009,0xf90df002}},	//   出版, 平米, 心血, 米克
  { {0xfb5db008,0xfa89c00c,0x00000003,0x00000003}},	// [c90] 泡立, 質比,   ,
  { {0xf593b007,0xf93fb00c,0xfa616010,0xfa84a00d}},	//   痛苦, 掃地, 片栗, 芬河
  { {0xf933b00f,0xf91eb00c,0x00000003,0x00000003}},	//   稚園, 你快,   ,
  { {0xf8122009,0xfb7d3008,0xfa5d0004,0xf5ac3004}},	//   定下, 各線, 品抽, 年自
  { {0xfb6bb00f,0xfa680009,0xf59a7001,0xf4b6a00c}},	//   自然, 税所, 果能, 勝過
  { {0xf82ee007,0xf940d005,0xf920700c,0xf8186005}},	//   新低, 万向, 加其, 舞人
  { {0xf931d00f,0xfa556007,0xf9411001,0xf4baa005}},	//   際商, 生教, 葉小, 宜都
  { {0xf5b9700f,0xf918d005,0xfa6e200c,0xf58e700a}},	//   接見, 区健, 女服, 首輪
  { {0xf9201004,0xf9477005,0xf8256005,0xf5c1300a}},	//   淡季, 上平, 富之, 本車
  { {0xfa5f4004,0xfb875005,0x00000003,0x00000003}},	//   商指, 名相,   ,
  { {0xf9479004,0xf9399004,0xf9271004,0xf9259004}},	//   不平, 刀切, 在少, 微利
  { {0xfa502004,0xf496e00a,0xfb51b005,0x00000003}},	//   志性, 活部, 西盟,
  { {0xf4bd8009,0xf595900c,0xfa88a005,0xf911b00d}},	//   品零, 定課, 被捕, 辰区
  { {0xfb879008,0xf4b6a001,0xf943b004,0xf93bb001}},	//   二第, 初階, 效利, 時分
  { {0xfa514004,0xfb7cf004,0xfa6d0004,0xf5bc300c}},	//   汗水, 球甘, 育手, 照考
  { {0xf5c73008,0xfa70e005,0xf9149005,0x00000003}},	//   用術, 地是, 格土,
  { {0xfa85c004,0xf93e3001,0xfa6b0004,0xfa70e004}},	// [ca0] 可替, 居多, 明新, 至此
  { {0xfa6f400a,0xfb77300c,0x00000003,0x00000003}},	//   干支, 斜紋,   ,
  { {0xfa6b2006,0xfa68200e,0xfb61b010,0x00000003}},	//   水文, 後日, 客管,
  { {0xf9383004,0xfa7e2001,0xf9305005,0x00000003}},	//   保利, 加我, 抗大,
  { {0xf93fd009,0xf926d004,0xf930300c,0xf9487005}},	//   千家, 物在, 動切, 意哪
  { {0xf926f006,0xf9235009,0xf595500c,0xfb871002}},	//   被告, 目光, 感超, 氏的
  { {0xf9489009,0xfb631001,0xf4932004,0xfa624001}},	//   量器, 可省, 好高, 按我
  { {0xf836e00e,0xfb4c1004,0xfb883005,0xf83ba00d}},	//   特例, 件箱, 同相, 肥中
  { {0xfa49e00c,0x00000003,0x00000003,0x00000003}},	//   間消,   ,   ,
  { {0xf8176007,0xf82a4005,0x00000003,0x00000003}},	//   察人, 明以,   ,
  { {0xfa52c004,0xfa528004,0xf9487005,0xf5a3900c}},	//   底数, 望成, 小助, 月自
  { {0xfb78f009,0xf5b83004,0xfa880004,0xfb509001}},	//   退税, 任落, 在播, 政程
  { {0xf5ad9007,0xf938f005,0xf9119005,0x00000003}},	//   更詳, 宝大, 放前,
  { {0xf946700f,0xf5a2100e,0xf932d004,0xf927f004}},	//   上客, 理職, 会分, 全公
  { {0xfa76600f,0xf4aa6001,0xfb623001,0xfa5d4008}},	//   刺激, 士音, 搭火, 組換
  { {0xf944f004,0xf835e004,0x00000003,0x00000003}},	//   位分, 出三,   ,
  { {0xfb605009,0xfa71e00d,0x00000003,0x00000003}},	// [cb0] 院科, 地找,   ,
  { {0xf826a006,0xf9341004,0xf594f005,0xfb5d900a}},	//   上信, 盛典, 站路, 絡等
  { {0xf9323006,0xf91a700f,0xf917d001,0xf4b46004}},	//   投入, 符合, 人字, 力都
  { {0xfa544009,0xf916b00c,0xfa530005,0xf943100c}},	//   多斯, 人各, 何更, 月刑
  { {0xf926f004,0x00000003,0x00000003,0x00000003}},	//   被吊,   ,   ,
  { {0xf81c2006,0xfa4aa009,0xf932d004,0x00000003}},	//   的上, 体情, 定必,
  { {0xf58e5001,0xfb82d005,0x00000003,0x00000003}},	//   我解, 肉用,   ,
  { {0xf4bac00b,0xf9439004,0xf91bf005,0xf93ab00c}},	//   最適, 拉大, 大参, 攀岩
  { {0xfb73b001,0xf599d005,0xf939500a,0x00000003}},	//   力無, 品袋, 詞家,
  { {0xfa840009,0xf9105004,0xf4c6a005,0xf9243005}},	//   是提, 足口, 住重, 是引
  { {0xfb5cb009,0xf81e8001,0xf9303004,0xf5b63001}},	//   知申, 拆下, 林学, 登輝
  { {0xfa514004,0x00000003,0x00000003,0x00000003}},	//   字段,   ,   ,
  { {0xf8248004,0xf5b9d004,0xfb66f004,0xf90a5005}},	//   上企, 入要, 在生, 件受
  { {0xfb7a1004,0xfb66f005,0xf92a300c,0x00000003}},	//   送税, 木生, 間再,
  { {0xf9459004,0x00000003,0x00000003,0x00000003}},	//   上当,   ,   ,
  { {0xfa6c400b,0xfa6b0009,0xf59cf007,0xfa706004}},	//   男性, 城新, 市自, 数比
  { {0xfb5c5009,0xf945b004,0xf4994004,0xfa79e001}},	// [cc0] 入点, 不当, 区都, 司普
  { {0xf49c8009,0xf4906007,0xfa87a001,0xf5a4f001}},	//   大通, 石頭, 周推, 看自
  { {0xf90c5005,0xfb75d00a,0xf5b61010,0x00000003}},	//   号大, 料相, 去記,
  { {0xf5a99001,0xf9295005,0xf4af400a,0xfa63200c}},	//   強行, 八公, 幕開, 見服
  { {0xf944100f,0xfb68b009,0xf93bd001,0xf9483001}},	//   克力, 士研, 境守, 完別
  { {0xfb4b7004,0xfa6b0005,0xfb66500a,0xf5a09010}},	//   谷物, 件正, 用組, 宅購
  { {0xf90ed007,0xf92f300c,0xf916d00c,0xf83f600c}},	//   音商, 店店, 根富, 面企
  { {0xfa578004,0xf91bb005,0xfb85500c,0x00000003}},	//   生改, 慧和, 益科,
  { {0xf93c7001,0xfa51c005,0xf92ab005,0xf8324005}},	//   市刑, 五洲, 体商, 国今
  { {0xf8206006,0xf5b97009,0x00000003,0x00000003}},	//   了他, 出色,   ,
  { {0xf916b006,0xf5b5b004,0xfa74c004,0xfb661004}},	//   区内, 国足, 治愈, 苯甲
  { {0xfa5ea001,0xf9299004,0xfb81100c,0xf59a3005}},	//   幅成, 身学, 玉珍, 裁裁
  { {0xfb55f004,0xfa79c004,0x00000003,0x00000003}},	//   国男, 方方,   ,
  { {0xf59d1008,0xf910900c,0x00000003,0x00000003}},	//   紅葉, 想加,   ,
  { {0xfa648009,0xf4c6a004,0xfb79f004,0xf928f008}},	//   型材, 界限, 着生, 自力
  { {0xfb843004,0xfa892008,0xf838e001,0xfa574004}},	//   事生, 親戚, 選作, 高淳
  { {0xf4c8c007,0xf5a8d001,0xf9381005,0xf5bc5005}},	// [cd0] 行音, 家認, 期共, 浦街
  { {0xf91fb009,0xf814e004,0xfb87d001,0xfb6eb005}},	//   次在, 会任, 完竣, 外置
  { {0xfa58000f,0xfa752009,0xf9109008,0xf932f004}},	//   保暖, 国日, 防具, 香城
  { {0xfb52d004,0xfa884005,0x00000003,0x00000003}},	//   由相, 彩新,   ,
  { {0xf58b5004,0xfb66500c,0x00000003,0x00000003}},	//   子要, 用約,   ,
  { {0xf93d100f,0xf92ef009,0xf91ef009,0xf9209005}},	//   求助, 外形, 大影, 象出
  { {0xf90cf00f,0xf59bb004,0xf4be2004,0x00000003}},	//   傷害, 品被, 幅高,
  { {0xf9193006,0xf91b7004,0xfa78c001,0xf91a300c}},	//   出国, 入差, 系水, 別務
  { {0xf83b200c,0x00000003,0x00000003,0x00000003}},	//   知他,   ,   ,
  { {0xfa6d000f,0x00000003,0x00000003,0x00000003}},	//   直接,   ,   ,
  { {0xf933d009,0xf938d00e,0xf90c3004,0xf9329004}},	//   力大, 門前, 件号, 多市
  { {0xfa75c007,0xf838a008,0xfa5cc004,0xf90ab005}},	//   治教, 古一, 心文, 冷凝
  { {0xf927b00f,0xf5bcb006,0xf8314009,0xf5bbb001}},	//   彩券, 日至, 地信, 別設
  { {0xfa584009,0xfa56e00c,0xf841600c,0x00000003}},	//   属性, 期業, 業作,
  { {0xfb7fb004,0xfb53900c,0xf815200c,0xf910700d}},	//   境状, 政相, 魚丸, 地得
  { {0xf9457004,0xf5b0900c,0x00000003,0x00000003}},	//   上向, 走著,   ,
  { {0xf4bd8006,0xfa664009,0x00000003,0x00000003}},	// [ce0] 的非, 名注,   ,
  { {0xfa5a2006,0xf9421004,0xf92b7004,0xf9307001}},	//   作日, 吉州, 未就, 殖場
  { {0xfb5b5004,0xf91cb001,0xf90d3005,0x00000003}},	//   入用, 因型, 段全,
  { {0xf9153009,0xf933b007,0xf923b004,0xfb827008}},	//   国出, 教官, 中就, 文確
  { {0xf8120004,0x00000003,0x00000003,0x00000003}},	//   底以,   ,   ,
  { {0xfa57600f,0xf9485004,0xf8112005,0xf83e000c}},	//   生活, 低分, 力事, 性代
  { {0xf93df009,0xfa520004,0xfb871004,0xf91ad002}},	//   的北, 引来, 行研, 以展
  { {0xfa500001,0xf82f2004,0xf5c5d004,0xfa6e2001}},	//   北探, 地企, 是落, 水滴
  { {0xf918b009,0xf80f6001,0x00000003,0x00000003}},	//   区大, 投下,   ,
  { {0xf9377007,0xfa4ca00c,0xf49da00c,0xf92c700c}},	//   生出, 救教, 造高, 道客
  { {0xf5c21004,0xfa614005,0xfa77a005,0xfb79f00c}},	//   院西, 按最, 改文, 需租
  { {0xf9209005,0xfb79700c,0xfa842005,0x00000003}},	//   加年, 激的, 葬改,
  { {0xfb89f004,0xf4b58005,0xf945500a,0xfb7df00d}},	//   式由, 土高, 消印, 如画
  { {0xf810400f,0xf9349004,0xf4b94001,0xf4b58008}},	//   法保, 多因, 局送, 期高
  { {0xfb71b00c,0xf4a5a005,0xf4b5800c,0xf4a84002}},	//   四的, 天高, 真高, 庫類
  { {0xf5973001,0xf5bc7005,0xfa57c00d,0x00000003}},	//   托育, 以落, 神是,
  { {0xf4ba0004,0xfb6a3001,0xf809c004,0xfa68e004}},	// [cf0] 十里, 園生, 排了, 李成
  { {0xf48e6007,0xf9315001,0xf4c42008,0xf91f7001}},	//   音量, 南島, 床開, 捧場
  { {0xfa52a00f,0xf5b07009,0xf9095001,0xf837e001}},	//   教授, 新街, 件商, 死人
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf58e9008,0xf933d001,0xf59ed005,0x00000003}},	//   外貨, 教博, 了迎,
  { {0xf8324009,0xfb79f001,0xf9437005,0x00000003}},	//   国上, 丁美, 下如,
  { {0xfb50900f,0xfa548009,0xf8206004,0xf90cd008}},	//   報紙, 些新, 了世, 長兼
  { {0xf933f004,0x00000003,0x00000003,0x00000003}},	//   定取,   ,   ,
  { {0xf5a4f001,0xf945f001,0xf93c7008,0xf5bfb001}},	//   下表, 反倒, 布市, 無袖
  { {0xf9489009,0xfb74b001,0xf592900c,0xf90ef005}},	//   量在, 講究, 展至, 数小
  { {0xfa86a00b,0xfa62e009,0xfb4ab00c,0x00000003}},	//   注文, 三支, 海神,
  { {0xf92d3009,0xf841c004,0x00000003,0x00000003}},	//   他各, 院以,   ,
  { {0xf9109009,0xf91b3001,0xf9125001,0xfa4fc00c}},	//   平度, 度各, 細地, 且成
  { {0xf823a00c,0xf5bf300c,0x00000003,0x00000003}},	//   予他, 形行,   ,
  { {0xf90a7001,0xf938d008,0xf5943001,0xf5915005}},	//   場後, 菜園, 記規, 供血
  { {0xf9087001,0xfa65c004,0x00000003,0x00000003}},	//   制及, 益或,   ,
  { {0xf90f9004,0xf80ce005,0xfb67500d,0x00000003}},	// [d00] 想当, 易主, 雨燕,
  { {0xf935b00a,0xfa53a00a,0x00000003,0x00000003}},	//   教区, 望条,   ,
  { {0xfb7b9001,0xf5b7d001,0xf4b6a005,0xfb4c9005}},	//   所知, 陸行, 保送, 起社
  { {0xf4bc8004,0xfb839004,0xfa89c004,0xf91f9005}},	//   的透, 等知, 被撤, 卡塔
  { {0xf8174009,0xf92e7009,0xf82e2004,0x00000003}},	//   作上, 得多, 育作,
  { {0xf90b5001,0xfb66b004,0xfa65a010,0xf92f3010}},	//   致勝, 表留, 埋没, 算委
  { {0xfb569001,0xf93c3005,0xf942100a,0x00000003}},	//   人終, 老客, 閉塞,
  { {0xf92d9009,0xfa808008,0xf8474004,0xf932d004}},	//   当具, 信日, 在互, 定居
  { {0xf4ba8009,0xfb575005,0x00000003,0x00000003}},	//   要集, 役的,   ,
  { {0xf82b6004,0xfb4f5001,0xf8314001,0xf80fc008}},	//   家交, 晰的, 穿了, 街中
  { {0xf5a61004,0xf918b004,0xf4906010,0x00000003}},	//   上表, 人左, 山雅,
  { {0xf9115004,0xf9467004,0xfb595005,0x00000003}},	//   地学, 量合, 日看,
  { {0xf5a63004,0xfb547004,0xfb7b5008,0xf914d001}},	//   不表, 好第, 市美, 能加
  { {0xfb89500f,0xfa864009,0xf93db009,0xf941f001}},	//   族群, 利民, 清市, 合奏
  { {0xf4bb4007,0xf81a8009,0xf92ad004,0xf911d005}},	//   所造, 着他, 子刊, 英在
  { {0xf9137004,0xf58bb008,0xf5a5300a,0x00000003}},	//   朱德, 習試, 再資,
  { {0xf4b6e00e,0xf9347009,0xf4b46004,0xf5b4100c}},	// [d10] 回限, 生安, 写道, 承襲
  { {0xfa5b8004,0xfa6be005,0x00000003,0x00000003}},	//   局性, 殴打,   ,
  { {0xf935d006,0xfa654004,0xf93f3001,0xfa7bc00c}},	//   存在, 上榜, 兄妹, 性服
  { {0xfb6c7009,0xf4b80009,0xfa54e004,0x00000003}},	//   体素, 生防, 会来,
  { {0xf5c0f008,0x00000003,0x00000003,0x00000003}},	//   面表,   ,   ,
  { {0xfa634007,0xf498800a,0xf4a7c00c,0xf91b300c}},	//   載次, 交配, 含項, 此刻
  { {0xfa828004,0xf834a008,0xfa77a005,0x00000003}},	//   中断, 都中, 出法,
  { {0xfb86300c,0xf90f5005,0x00000003,0x00000003}},	//   看穿, 育形,   ,
  { {0xfb5cb009,0xf93f7009,0xf90af009,0xfb89f009}},	//   大生, 密切, 年各, 明珠
  { {0xf49e0006,0xf842a001,0xfa4f0005,0xfa5d4005}},	//   加速, 良事, 北民, 市振
  { {0xf4a6200e,0xf4b0e00c,0xf9279005,0x00000003}},	//   微鏡, 南都, 火如,
  { {0xf5bb3007,0xf9439001,0xfb84f00c,0x00000003}},	//   肥胖, 築工, 授精,
  { {0xf92ff004,0xf9095001,0xf4b22004,0xf93fd004}},	//   何商, 德安, 望通, 者加
  { {0xfa64e00d,0x00000003,0x00000003,0x00000003}},	//   届文,   ,   ,
  { {0xf830a002,0x00000003,0x00000003,0x00000003}},	//   房事,   ,   ,
  { {0xf93a9004,0xf92db005,0x00000003,0x00000003}},	//   封存, 徐建,   ,
  { {0xfb4f300f,0xf49a6009,0xfa646009,0xf5b5d004}},	// [d20] 女生, 急通, 效性, 国花
  { {0xf9353006,0xfb67100b,0xfa834001,0xfb67d004}},	//   做好, 器科, 口政, 在目
  { {0xfa5be007,0xfb637007,0xfb889001,0xfa7e4005}},	//   係指, 業災, 誌社, 学海
  { {0xf5a55004,0xf93d7004,0xf5adb004,0xf5a6100c}},	//   希腊, 情和, 育装, 事調
  { {0xfa89c00f,0xfa6f200e,0xf493e009,0xfa71a007}},	//   快查, 台所, 国青, 音新
  { {0xfa54e007,0xfa4c6001,0xfa864001,0xfb6cd008}},	//   紙本, 休旅, 助我, 術系
  { {0xf8362005,0x00000003,0x00000003,0x00000003}},	//   系也,   ,   ,
  { {0xfa708006,0xf939d007,0xf4a68004,0xf93a7005}},	//   新浪, 禁忌, 部集, 企分
  { {0xfa778009,0xf83b4001,0xfb753004,0xf592b001}},	//   油料, 此人, 盟的, 紙袋
  { {0xf8216009,0xf934f004,0xfa5d400c,0xfb58d002}},	//   分人, 定履, 各朝, 出系
  { {0xfa5e400f,0xfa77c009,0xf917d001,0xfb86d008}},	//   市松, 治活, 人套, 告示
  { {0xfa864004,0x00000003,0x00000003,0x00000003}},	//   彩排,   ,   ,
  { {0xf8338007,0xfa672004,0xf9187004,0xf5c0d005}},	//   承人, 富汗, 活困, 六要
  { {0xf826a006,0xf916d007,0xf9347004,0xfa624005}},	//   事件, 人分, 多形, 商水
  { {0xf937d007,0xf5c31007,0xfa77e009,0xfa646004}},	//   夜市, 本質, 治方, 立村
  { {0xf933b009,0xf594b001,0xf4b8a005,0x00000003}},	//   会引, 機認, 作非,
  { {0xfa664004,0xfa7da001,0xf92ad004,0x00000003}},	// [d30] 上支, 校有, 自去,
  { {0xf5b5d004,0xfa5cc001,0xf944700c,0xf92bb005}},	//   国英, 心指, 型塑, 易引
  { {0xf49d0006,0xfb79d00c,0xfa6c800c,0xfb51d010}},	//   学院, 保筷, 年息, 灰皿
  { {0xf9431004,0xfb7ad008,0x00000003,0x00000003}},	//   率已, 着目,   ,
  { {0xfb761009,0xfa7d6007,0xf92bb007,0xf932f008}},	//   回的, 因故, 我又, 力化
  { {0xfb5c9009,0xfa4e0007,0xf5b0b009,0xfa5b2004}},	//   以申, 向本, 地表, 作更
  { {0xfa55c00c,0xf925700c,0x00000003,0x00000003}},	//   料根, 種外,   ,
  { {0xf840a008,0xf4ad200c,0x00000003,0x00000003}},	//   設一, 道選,   ,
  { {0xfa778007,0xfa860009,0xf92f7009,0xf48b200c}},	//   人成, 在每, 得利, 家靠
  { {0xfa5b0008,0xf4acc001,0xf9409004,0xf5c8d004}},	//   一息, 他配, 等先, 身自
  { {0xf8346009,0xf91a9007,0xf9473004,0xf90ed008}},	//   找人, 書出, 免去, 蟲師
  { {0xfb4a500e,0xfa4f0009,0xf832a005,0x00000003}},	//   執筆, 法案, 山丹,
  { {0xfa5ce006,0xf5bfb00e,0xf5a4d001,0xfa7b4004}},	//   的情, 無視, 下自, 日推
  { {0xfb689007,0xf4c3c008,0xfb72100c,0xf94a1005}},	//   用空, 三陸, 法確, 虎左
  { {0xf928f006,0xf90a9006,0xf9197004,0xfb51f008}},	//   您好, 家在, 入完, 週目
  { {0xf5b2f00e,0xf913d004,0xf91d900c,0xf93e9005}},	//   許諾, 能当, 信安, 市危
  { {0xf828e004,0xfa6e000c,0xf5c6100c,0x00000003}},	// [d40] 意中, 直整, 良課,
  { {0xf945d004,0xf90eb002,0x00000003,0x00000003}},	//   屋建, 到半,   ,
  { {0xf9305006,0xfa834009,0xf81fe001,0xfa5ea005}},	//   南大, 断改, 者信, 幅提
  { {0xf929500b,0xf9413004,0xf4a4a00a,0xf5adf00c}},	//   器具, 三市, 央通, 女車
  { {0xf59cf00f,0xf58c1008,0xf92cf008,0xf4c1e001}},	//   終身, 園調, 聖堂, 資遣
  { {0xf918b007,0xf5aa1007,0xf594b005,0xf917d00a}},	//   基層, 起迄, 真菌, 死去
  { {0xfa4f6009,0xf4bb4001,0xfa6a6001,0xf932f00a}},	//   村新, 狂野, 長指, 備後
  { {0xfa574004,0xf48b2001,0xf9425005,0xf9103005}},	//   回暖, 迷途, 分年, 新媒
  { {0xf918f006,0xfb62500e,0xf911d001,0x00000003}},	//   方可, 中目, 田尾,
  { {0xf9305005,0xfa6f800a,0x00000003,0x00000003}},	//   得建, 異文,   ,
  { {0xfa6d000e,0xfa672001,0xf90a5005,0x00000003}},	//   水性, 歌林, 致同,
  { {0xf83d8009,0xfb89900a,0xfb4d100c,0x00000003}},	//   学人, 像特, 育界,
  { {0xf837a007,0xf5a39001,0xfb839004,0xf4adc005}},	//   書上, 合身, 屋的, 北里
  { {0xfa6a4004,0xf924b001,0xfb6cb004,0xf83c600a}},	//   小水, 搬到, 金率, 日使
  { {0xfa6ca007,0xfa592004,0xf937b00c,0x00000003}},	//   具書, 一意, 瓜布,
  { {0xf93cf00f,0xfa57e009,0xfb52b004,0xfb5ed001}},	//   的商, 非正, 就相, 無痛
  { {0xfa612006,0xf5a6100e,0xf58e7001,0xfa6c2004}},	// [d50] 有意, 不自, 五行, 件新
  { {0xfb7fb006,0x00000003,0x00000003,0x00000003}},	//   万美,   ,   ,
  { {0xf93af006,0xfa5b8001,0xf4ada005,0x00000003}},	//   要原, 激性, 世通,
  { {0xf5b0100e,0xfa728009,0xfa5ca001,0xfa4b4008}},	//   台詞, 田水, 局水, 源流
  { {0xfb6e1006,0xfa4d8007,0xf9437009,0xf90fd001}},	//   得的, 刑法, 安大, 報後
  { {0xf93b700f,0xf8244009,0xfa57a007,0xf8382007}},	//   技大, 前三, 果汁, 盤上
  { {0xf92af004,0xfb4ad001,0xfa73e008,0xf58db005}},	//   当定, 職生, 製法, 向被
  { {0xf5afd001,0xfb7f3004,0xfb749001,0xf8434004}},	//   味著, 善相, 毛細, 氯乙
  { {0xf5a93007,0xfa6fa00c,0xf5c0d00c,0x00000003}},	//   量衡, 峰教, 面自,
  { {0xfa53a001,0xfa560004,0xfa51200c,0xfa67e005}},	//   教教, 期提, 展推, 界性
  { {0xf93ab00f,0xf5c49005,0xf93cf005,0xfa560010}},	//   所全, 旬至, 求填, 真提
  { {0xf9153004,0xf4acc00c,0xf91bf00a,0xf9381005}},	//   国基, 他重, 古島, 宜居
  { {0xf5c37008,0xf91e7001,0x00000003,0x00000003}},	//   短調, 試場,   ,
  { {0xf93f1007,0xfa5ae007,0xfb5cb008,0xf58c9001}},	//   居士, 府新, 大牟, 金者
  { {0xfa778006,0xf91a9004,0xfa65800a,0xfa52e010}},	//   建材, 入土, 床材, 顛末
  { {0xf820c007,0xf8416001,0xf4bc600c,0x00000003}},	//   安事, 搭保, 心送,
  { {0xfb633006,0xfb75500f,0xf839a009,0xf93f9004}},	// [d60] 公用, 生理, 入住, 清形
  { {0xfa4ac006,0xfa818004,0xf917f004,0xf9377001}},	//   子有, 峡水, 智利, 生基
  { {0xf8272008,0xfa64e001,0xfa6c0004,0xfb84d005}},	//   二世, 告招, 更或, 籍的
  { {0xf90e7004,0xfa6b0001,0xf91f500c,0x00000003}},	//   味品, 直昇, 靠度,
  { {0xf9465009,0xf915b004,0xf9203008,0xfb537005}},	//   行力, 好就, 造影, 好生
  { {0xf912300f,0xfa866009,0xf924b007,0xfa86e00d}},	//   新到, 修日, 本報, 在果
  { {0xf9449007,0xfb74f004,0xf5b9100c,0xf940d002}},	//   守大, 脚点, 書苑, 假借
  { {0xfb839009,0xf9291004,0xf920f001,0xfa6bc001}},	//   光照, 在即, 校徽, 職涯
  { {0xf9391004,0xf925d004,0xfa66a005,0x00000003}},	//   作受, 用名, 型数,
  { {0xfb5d700f,0xfa73400c,0x00000003,0x00000003}},	//   你的, 格拉,   ,
  { {0xfb59d00f,0xf93e3004,0xfa4d800c,0xf5a4900c}},	//   履約, 待定, 休準, 合診
  { {0xfb4ad00f,0xf80da007,0xf9109001,0xfb599001}},	//   年終, 南下, 東分, 瘤科
  { {0xfb819006,0xf4ad8004,0xf5bd1001,0xf9151001}},	//   文物, 外高, 日葵, 社報
  { {0xf81f8009,0x00000003,0x00000003,0x00000003}},	//   分会,   ,   ,
  { {0xfa576007,0xfa864001,0xf4af600c,0xf9405005}},	//   生死, 目查, 且通, 雅典
  { {0xf90cf004,0xf818c005,0xf5bf900c,0x00000003}},	//   年左, 技之, 渡輪,
  { {0xf932f004,0xf821c008,0xfb523005,0xf83dc005}},	// [d70] 定切, 文京, 地由, 次事
  { {0xf4a7600f,0xf8424004,0xf9183005,0xfb881005}},	//   用途, 解中, 出公, 小燕
  { {0xfa860001,0xfa668004,0xf912d00c,0x00000003}},	//   普渡, 立柱, 花吹,
  { {0xf4c72008,0xfb82b004,0xfa5ae004,0xfa51200a}},	//   上陸, 案率, 要搜, 演日
  { {0xf93b1004,0xf90a1005,0xfa4be00c,0xf943300c}},	//   拜年, 康庄, 徒步, 有巢
  { {0xf92d5001,0xf9189004,0xfb79f001,0xfa654001}},	//   他分, 役士, 最真, 行按
  { {0xf93d5007,0xfa798009,0xf5c79007,0xf91b5001}},	//   品到, 基数, 木質, 度分
  { {0xfa668008,0xf934b004,0xf48d6001,0xfa86e005}},	//   型液, 感和, 長靴, 在搜
  { {0xf8446009,0xf4bf2007,0xf9257001,0xfa7cc00c}},	//   是世, 考選, 可別, 別想
  { {0xf81b200e,0xf5b09004,0xf926d008,0x00000003}},	//   流体, 地自, 用停,
  { {0xf938b006,0xf9207001,0xfa55c004,0xf4bc8001}},	//   激光, 坡度, 定海, 的量
  { {0xf9261004,0xf5bcf001,0xf825600c,0xf82dc00a}},	//   在局, 日買, 構代, 雲仙
  { {0xfa730009,0xf81fa00d,0x00000003,0x00000003}},	//   国情, 商也,   ,
  { {0xfa85a00e,0xfb5d9004,0x00000003,0x00000003}},	//   港湾, 大目,   ,
  { {0xfb5b7004,0x00000003,0x00000003,0x00000003}},	//   学率,   ,   ,
  { {0xfa84000f,0xf91a9006,0xfb54d00e,0xfb85d005}},	//   潮流, 警告, 費等, 始登
  { {0xf5b07001,0xfb82f001,0xf933d00c,0x00000003}},	// [d80] 報者, 月租, 供建,
  { {0xfb4fd008,0xf8430001,0xfa7c0001,0xf93d7004}},	//   共益, 可一, 度成, 禅城
  { {0xf917d007,0xfa772004,0xf4992001,0xf9109004}},	//   特力, 主是, 券金, 房及
  { {0xfa61c010,0xfa6fa00d,0x00000003,0x00000003}},	//   合掌, 石排,   ,
  { {0xf9233004,0xf49b800a,0x00000003,0x00000003}},	//   般在, 古都,   ,
  { {0xf916b006,0xf4a3e00b,0xfb4c5007,0xf90cf009}},	//   区居, 是非, 場編, 海地
  { {0xfa546007,0xfa686001,0x00000003,0x00000003}},	//   生效, 行書,   ,
  { {0xf80f4009,0xfa7d2001,0xf59e1001,0xf926500c}},	//   化交, 占最, 考表, 揮別
  { {0xf597d006,0xf934b004,0xf90ff004,0xfb78b004}},	//   真落, 博大, 山小, 州社
  { {0xf5a43007,0xf91f900c,0xf926f005,0x00000003}},	//   車行, 因出, 士告,
  { {0xfb701009,0xf58bf007,0xfa55c001,0xf4bf0001}},	//   算管, 道自, 教改, 旅途
  { {0xfa580006,0xf9245009,0xf499c001,0xf9209004}},	//   作情, 是北, 別門, 占年
  { {0xf9405006,0xfa6e200f,0xfa518001,0xfa71600d}},	//   内容, 水水, 達格, 到武
  { {0xf49a8004,0xf8116004,0xf4c4400a,0xf5c61005}},	//   以非, 受侵, 介類, 用血
  { {0xfa640001,0xf5b23004,0xfa520001,0xfa4a0001}},	//   有放, 沿街, 法攻, 術手
  { {0xf5c83009,0xf59fd007,0xf9137001,0xf842a001}},	//   罪行, 薄荷, 格後, 業代
  { {0xfa80c001,0xf920900c,0xf946d005,0x00000003}},	// [d90] 止投, 信基, 倍加,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf93c5001,0xf5ac3004,0xfa798004,0xf9171005}},	//   一共, 年薪, 改性, 出初
  { {0xf91af004,0xf918d00c,0x00000003,0x00000003}},	//   以北, 人室,   ,
  { {0xfb6ab00b,0xf9445001,0xf4a0600c,0xf93c1005}},	//   卓球, 有共, 庭配, 的嘉
  { {0xf8164004,0xfb7c5001,0xf9187005,0xf91b300c}},	//   初三, 市租, 妻共, 摸到
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf49ac007,0xf5bc9007,0xfb845001,0xf58cb008}},	//   步道, 知能, 看租, 科衛
  { {0xf9229007,0xf944f004,0xfa6ca00c,0x00000003}},	//   本契, 哈尼, 年業,
  { {0xf5bcf007,0xf80f6004,0xf58ed001,0xfa54a004}},	//   日谷, 他任, 受補, 望慰
  { {0xf932b009,0xf8396001,0x00000003,0x00000003}},	//   曙光, 別介,   ,
  { {0xf5b63007,0xfb5cd009,0xfb58d009,0xf91f1004}},	//   人而, 性生, 除的, 性就
  { {0xf5b31009,0xf9245004,0xfb6a1005,0xf92f700c}},	//   能超, 是南, 八点, 南化
  { {0xf9283004,0xf826800d,0x00000003,0x00000003}},	//   天山, 和休,   ,
  { {0xfa816004,0xf9381001,0xfb4f5004,0xfb69d004}},	//   中搜, 作商, 台球, 毒病
  { {0xfa66e006,0xf93dd004,0xfa53c004,0x00000003}},	//   反映, 境噪, 定投,
  { {0xfa78a00c,0xfa584005,0x00000003,0x00000003}},	// [da0] 油木, 辞旧,   ,
  { {0xf93d9005,0xfb88f005,0x00000003,0x00000003}},	//   持家, 美科,   ,
  { {0xf8120008,0x00000003,0x00000003,0x00000003}},	//   博之,   ,   ,
  { {0xf8150009,0xfa5e0009,0xf8120005,0xfb743005}},	//   定人, 的或, 会今, 拘禁
  { {0xfa5a4001,0xf91af004,0xf9483004,0xf938f004}},	//   一成, 以南, 行医, 霞山
  { {0xf91a7007,0xf5c31008,0xf4c4c005,0x00000003}},	//   日夜, 公論, 前退,
  { {0xfb863001,0xfa70c00c,0x00000003,0x00000003}},	//   行率, 深思,   ,
  { {0xfa768009,0xf9203009,0xf5a5300c,0xf83d400c}},	//   区概, 造就, 再談, 章一
  { {0xfa55a009,0xfb67b004,0x00000003,0x00000003}},	//   教活, 全用,   ,
  { {0xfb4f7004,0xfa840004,0xf5a39004,0xfa7ee001}},	//   估的, 是某, 月薪, 淡江
  { {0xf917900e,0xfb75d005,0xf948d00c,0xf929500a}},	//   主婦, 土生, 跌到, 館山
  { {0xfa76e006,0x00000003,0x00000003,0x00000003}},	//   系您,   ,   ,
  { {0xf93d7006,0xf59c9004,0xfb4c3004,0xf5bc700c}},	//   兄弟, 的言, 致用, 大講
  { {0xf49c2008,0x00000003,0x00000003,0x00000003}},	//   武道,   ,   ,
  { {0xf915d007,0xfb87f008,0x00000003,0x00000003}},	//   落地, 美紀,   ,
  { {0xfa778006,0x00000003,0x00000003,0x00000003}},	//   人提,   ,   ,
  { {0xf93c3001,0xf9493004,0xf9087004,0xfa85c00c}},	// [db0] 一女, 宏大, 延吉, 可拿
  { {0xf59b100f,0xf4c1c007,0xfa5a4001,0xfa7a8005}},	//   一般, 有高, 最棒, 相接
  { {0xf90bf006,0xf58bb00c,0xf90d1005,0xf944300c}},	//   年底, 拓荒, 援工, 有女
  { {0xfb753007,0xfa6f8004,0xf812e001,0xfa66c001}},	//   生組, 史悠, 望他, 積欠
  { {0xfa782007,0xfa632001,0xfa764001,0xf9385005}},	//   司所, 月成, 遺漏, 喜喜
  { {0xf94a1009,0xfb6f3004,0x00000003,0x00000003}},	//   明度, 法程,   ,
  { {0xf946b002,0xf93e1002,0x00000003,0x00000003}},	//   像和, 的庫,   ,
  { {0xf8284009,0xf914d007,0xf593d004,0xfa564005}},	//   富人, 鼻喉, 乙肝, 察暗
  { {0xf58ad004,0xf4bee005,0xfa4dc00a,0x00000003}},	//   材行, 内道, 筑摩,
  { {0xf92ab004,0xfb7ab004,0xfb57d001,0xfa4f0002}},	//   徐光, 果由, 腹痛, 受民
  { {0xfa65e002,0x00000003,0x00000003,0x00000003}},	//   告注,   ,   ,
  { {0xfb4cd004,0xfb49b005,0xfb7c300c,0xfa67600d}},	//   色版, 海福, 約等, 不松
  { {0xfb865007,0xfa75c007,0xfb873001,0xf9245001}},	//   名義, 系教, 才知, 柯南
  { {0xfa86e004,0xf9347001,0xfa6ec00a,0xf936500c}},	//   天涯, 減弱, 米文, 食優
  { {0xf92e7004,0xf9245005,0x00000003,0x00000003}},	//   村学, 是受,   ,
  { {0xf80ba00f,0xfa744007,0xf945f004,0xfa62e004}},	//   成付, 格摘, 位列, 光温
  { {0xf9379007,0xf495a008,0xf939900c,0x00000003}},	// [dc0] 娘家, 羽雲, 停客,
  { {0xfa5ce009,0xfb58f004,0xf94a7001,0xfa5f8004}},	//   的清, 出特, 盎司, 者支
  { {0xf4a16004,0xf926d005,0xf924d005,0xfb6c900c}},	//   口食, 利在, 利弊, 子研
  { {0xf943b006,0xf922f00f,0xfa56e004,0xfb4d3004}},	//   很快, 本店, 也正, 号称
  { {0xf923500f,0xf4b30004,0xf9201001,0xfa6dc001}},	//   暮光, 多高, 惠平, 農情
  { {0xfb6d1007,0xf593f00e,0xfa7d8008,0xf935700c}},	//   暖的, 通貨, 給油, 多女
  { {0xfb58b001,0xf91af005,0x00000003,0x00000003}},	//   酸痛, 以受,   ,
  { {0xfa812006,0xf93d3009,0xf4bce008,0xf92f9004}},	//   公有, 的婚, 元順, 列全
  { {0xf4b9200f,0xf9369005,0x00000003,0x00000003}},	//   所需, 生天,   ,
  { {0xf9135007,0xfb533004,0xf4b5c001,0x00000003}},	//   週報, 便群, 機食,
  { {0xf819a009,0xf58fb001,0xf4aba001,0xf848200c}},	//   一万, 湖西, 耐高, 含保
  { {0xf916d001,0xf9239005,0xfb881002,0x00000003}},	//   建商, 售前, 牌知,
  { {0xfa7c4009,0xf9467004,0xf90eb004,0xf80cc008}},	//   警惕, 上形, 平分, 訓令
  { {0xf4a2600f,0xf918b00e,0xfa79800c,0x00000003}},	//   正面, 容器, 健服,
  { {0xf828a004,0xf5a63005,0x00000003,0x00000003}},	//   家介, 事能,   ,
  { {0xfb509009,0xf90a5009,0xf923d009,0xfa54c004}},	//   估算, 更名, 路子, 存折
  { {0xf8120006,0xfa622006,0xfa7c2009,0xf947b007}},	// [dd0] 会上, 了新, 日活, 躍報
  { {0xfa4c0001,0xf93a5004,0xf5c0300a,0x00000003}},	//   習方, 送市, 中越,
  { {0xf9363006,0xf8242009,0xfa5fe009,0xfa502004}},	//   曝光, 位上, 的扶, 湖新
  { {0xfa69400c,0xfa70e005,0xfa4ea005,0x00000003}},	//   住日, 地振, 徐水,
  { {0xf849200e,0xfa726009,0xf4c6e007,0xf5a8b004}},	//   巨乳, 能手, 行道, 件行
  { {0xf93e700c,0xf925b010,0x00000003,0x00000003}},	//   市女, 器屋,   ,
  { {0xf4b0e00c,0x00000003,0x00000003,0x00000003}},	//   字音,   ,   ,
  { {0xf91bd006,0xfa686008,0xfb643001,0xf937100c}},	//   大局, 慶應, 潮的, 保官
  { {0xf492600f,0xfa4e4007,0xfa668007,0xfa4e0005}},	//   精采, 暖暖, 量有, 外提
  { {0xf8216006,0xf93c3005,0xf92a300d,0x00000003}},	//   了以, 蜀山, 被命,
  { {0xf9495006,0xfa50400a,0xf4c6a002,0x00000003}},	//   小区, 南武, 式重,
  { {0xfa4f6004,0xfb649004,0xf91a700c,0x00000003}},	//   他来, 唯物, 日府,
  { {0xf830a001,0xf4a4e00c,0x00000003,0x00000003}},	//   拿下, 種食,   ,
  { {0xf92bb00b,0xfb7ff00c,0xf90fd002,0x00000003}},	//   限定, 分結, 史工,
  { {0xf9467006,0xf943b009,0xfa6de004,0xfa7ce004}},	//   小型, 盈利, 念旧, 查新
  { {0xf5a0f006,0xf812e006,0xf93a3009,0xf59f3009}},	//   分解, 多万, 品品, 者自
  { {0xfb6e5009,0xfa658004,0xfa84e001,0xfa728004}},	// [de0] 策研, 不搞, 天才, 好每
  { {0xf93ab006,0xf4c20004,0xf9221004,0x00000003}},	//   所在, 予降, 京分,
  { {0xf9129008,0xf942b004,0x00000003,0x00000003}},	//   台場, 等在,   ,
  { {0xf93f3001,0xf59d9004,0xfb8a5004,0xfb573005}},	//   射出, 的近, 量状, 示祝
  { {0xfb669007,0xf5bab001,0xfa89a004,0xf4a38008}},	//   物研, 度而, 注水, 難防
  { {0xf9207004,0x00000003,0x00000003,0x00000003}},	//   模大,   ,   ,
  { {0xf83d2004,0xf5955008,0xfb87f00c,0x00000003}},	//   性互, 折角, 富管,
  { {0xf8132009,0xf90af008,0xfa5fa00c,0xf83c2005}},	//   定会, 年寄, 心收, 查以
  { {0xf94a5006,0xfa85000f,0xfa6e8007,0xf4adc004}},	//   每年, 矯正, 石流, 化食
  { {0xf90f1007,0x00000003,0x00000003,0x00000003}},	//   音多,   ,   ,
  { {0xf4a3e001,0xf8362001,0x00000003,0x00000003}},	//   可食, 移作,   ,
  { {0xfb81d009,0xf4afe004,0xf92af005,0xfa874005}},	//   肉牛, 林郭, 体多, 利枢
  { {0xf90f9007,0xfb6f300c,0xf92af005,0xf9475005}},	//   平底, 字研, 当多, 每升
  { {0xfb64500b,0xf9117007,0xf9353010,0x00000003}},	//   修理, 東引, 嗚呼,
  { {0xf9267005,0xf820800a,0x00000003,0x00000003}},	//   修基, 片付,   ,
  { {0xfa894009,0xfb811001,0xf81be004,0xf5995001}},	//   器械, 切結, 市万, 所考
  { {0xf9239009,0xf48da009,0xf5a15007,0xfa634004}},	// [df0] 微型, 暴露, 等考, 下意
  { {0xf823c006,0xf9417009,0xf9321007,0xfa510007}},	//   立了, 安居, 展出, 昔日
  { {0xf920f007,0xf920b001,0xfa4d000c,0xf80a0005}},	//   難忘, 次役, 取時, 染上
  { {0xfa816007,0xf8350004,0xfb693008,0xf938900c}},	//   口感, 份以, 未熟, 所合
  { {0xf9473001,0xf939d004,0xf5939001,0xf80b2001}},	//   式分, 思危, 毛象, 術作
  { {0xf5b07001,0xf4acc001,0xfb7a100c,0xf5a85005}},	//   色色, 酒酵, 一真, 夏自
  { {0xfa708001,0xf935b001,0xf8266005,0x00000003}},	//   姿態, 租借, 住上,
  { {0xf81a4004,0xfb72b004,0xf5bfb004,0xfa5ea001}},	//   宜人, 料粉, 造船, 順手
  { {0xfa7c0009,0xf94a300e,0xf91d9005,0xfa7a600a}},	//   度提, 階層, 学妹, 工機
  { {0xf932f007,0xfb57100c,0xfa6b0005,0x00000003}},	//   定假, 移置, 究探,
  { {0xfa684001,0xfb82500c,0xf499000c,0x00000003}},	//   行決, 盈的, 胺酸,
  { {0xf828a007,0xf4b36005,0xfa4ac00d,0x00000003}},	//   家下, 会非, 当文,
  { {0xf921d009,0xfb533001,0xfa5be005,0x00000003}},	//   院建, 東石, 要景,
  { {0xf9107001,0xf909900c,0xfa66a00c,0x00000003}},	//   地字, 家四, 意手,
  { {0xfa66e009,0xf90f5004,0xfa576001,0x00000003}},	//   伊春, 地各, 域查,
  { {0xf92cb008,0xfa76400c,0xf918b005,0xfa858005}},	//   刑務, 格決, 船只, 路沿
  { {0xfb5db005,0xfa79a00d,0xf4c6c002,0x00000003}},	// [e00] 性目, 古村, 重逢,
  { {0xf944900b,0xfa55e009,0x00000003,0x00000003}},	//   王子, 会更,   ,
  { {0xf5b69005,0xf5ae300c,0x00000003,0x00000003}},	//   出考, 音軌,   ,
  { {0xf91a1004,0xfa736005,0xf4a1800c,0xfa8be00c}},	//   来分, 就收, 正道, 質水
  { {0xfa648009,0xfb585001,0xfa4e200c,0xf9471005}},	//   不意, 書組, 受時, 里只
  { {0xf843c006,0xf93af007,0xf4a1a00c,0xfa6fa005}},	//   本信, 私募, 般門, 述文
  { {0xf937100b,0xf93c9006,0xf9391009,0xf5c5b001}},	//   保存, 十大, 州地, 可貸
  { {0xfb5f9006,0xf598f00c,0xf5c8d00c,0xf837e005}},	//   院的, 一而, 含著, 方保
  { {0xfa79200f,0xf91ef00c,0x00000003,0x00000003}},	//   日月, 大報,   ,
  { {0xf919b008,0xf946b004,0xf4b7c001,0xf8436004}},	//   建具, 把大, 機都, 目上
  { {0xf5a51001,0xfb7d5008,0xf9161005,0xf93c3005}},	//   再者, 旅立, 出同, 射安
  { {0xfa5be006,0xfa61a008,0x00000003,0x00000003}},	//   要是, 理施,   ,
  { {0xf80d8006,0xf80c0009,0xf592b008,0xfb60f004}},	//   提交, 金不, 備計, 巡礼
  { {0xf824a006,0xf914d007,0xf593d001,0xf92c5001}},	//   予以, 能因, 做自, 向心
  { {0xf839c001,0x00000003,0x00000003,0x00000003}},	//   接一,   ,   ,
  { {0xf48ae00b,0xfb67b00e,0xfa52c004,0xf809c004}},	//   競馬, 用物, 力投, 当予
  { {0xf915500f,0xf939b009,0xfb63f009,0xfb76b009}},	// [e10] 現場, 川地, 是科, 期目
  { {0xf82ce009,0xfb5f7001,0xfb66d005,0x00000003}},	//   混乱, 次研, 天目,
  { {0xf5bc7004,0xfa5f4001,0xf833a00c,0x00000003}},	//   以能, 商教, 政便,
  { {0xf9465009,0xfa6a2019,0xfa53400c,0x00000003}},	//   前全, 德清, 線感,
  { {0xfa6bc009,0xfb4f3004,0xf90bf005,0xfa88c005}},	//   年提, 育第, 年引, 豪情
  { {0xf9305004,0xfa5d8004,0xf80cc001,0xfa5c4004}},	//   志出, 情操, 民保, 着新
  { {0xf4b9e00e,0xfa668004,0xf837e00c,0xfa550005}},	//   一通, 事新, 方依, 期持
  { {0xf81e6004,0xfb831001,0xf4afa004,0x00000003}},	//   分三, 有第, 金陵,
  { {0xfb5a9009,0xfa7f8004,0xfb7d5005,0x00000003}},	//   以科, 信或, 病程,
  { {0xf90a5006,0xfb5a7004,0xf8324005,0xf5a0900a}},	//   致富, 学版, 地估, 必至
  { {0xf9293007,0xf4ac4001,0xf91e100a,0xf9487005}},	//   妨害, 我需, 蝦夷, 量只
  { {0xf828a004,0xf5923004,0xfb84f001,0xf5965001}},	//   其不, 多菌, 消精, 甘苦
  { {0xf9423004,0xf5923005,0xf4a6e00c,0xfb52900a}},	//   月参, 多而, 種都, 能美
  { {0xf9293004,0xf5a3300c,0xf5c3100a,0x00000003}},	//   被公, 型行, 業費,
  { {0xf923500b,0xf4a0a001,0xf4b7200c,0x00000003}},	//   目安, 難逃, 川飛,
  { {0xf92bf004,0xfa512004,0xf5adf00c,0x00000003}},	//   体利, 得收, 跳蛋,
  { {0xf9179007,0xfb76b007,0xf92bf004,0xf820e004}},	// [e20] 役官, 真皮, 当利, 框中
  { {0xf4a94004,0xf4c28001,0xf93fb004,0xf946f004}},	//   互配, 先順, 理回, 融学
  { {0xfa662004,0xfb663001,0x00000003,0x00000003}},	//   前旗, 種無,   ,
  { {0xfb597007,0xf9235001,0xf5b3b004,0xf9129004}},	//   人申, 可充, 国近, 好局
  { {0xf815a00f,0xf935b007,0xf93cb001,0xf4ace00c}},	//   生保, 教基, 時受, 或需
  { {0xf932d009,0xfb83f007,0xf9171007,0xfb819005}},	//   引号, 月第, 系副, 先烈
  { {0xf9365001,0xf5bdd004,0xfa6f8008,0xf4c2c005}},	//   回娘, 度落, 音源, 月通
  { {0xf92e5007,0xf93f9005,0x00000003,0x00000003}},	//   林分, 充公,   ,
  { {0xfa71e008,0xfb729005,0xf93eb00c,0xf9415010}},	//   至極, 定禁, 超划, 隆寺
  { {0xfa79a009,0xf9233004,0xfa7cc00d,0x00000003}},	//   建新, 括在, 以数,
  { {0xf922d009,0xf9301004,0xfb6dd001,0xf845e004}},	//   口大, 外就, 外生, 部不
  { {0xf82f8009,0xfa8a0005,0xfb88100c,0xf5a4f00a}},	//   台了, 含油, 行照, 運航
  { {0xfa51000e,0x00000003,0x00000003,0x00000003}},	//   動法,   ,   ,
  { {0xf4c1a004,0xf8148001,0xf829c005,0x00000003}},	//   三高, 機介, 具不,
  { {0xfa5f0004,0xf80e2004,0xf921900d,0x00000003}},	//   的泥, 金中, 代孕,
  { {0xf58b5004,0xfa868001,0xfa7fe004,0xf93d1005}},	//   成考, 用指, 衣有, 要平
  { {0xf91f100e,0xfa538004,0x00000003,0x00000003}},	// [e30] 無償, 多提,   ,
  { {0xf93b9004,0xf9199002,0x00000003,0x00000003}},	//   市参, 司取,   ,
  { {0xfa67000f,0xfa50e009,0xf4a50009,0xf92d3004}},	//   牌旗, 五次, 副院, 化内
  { {0xf82e0007,0xf92a9009,0xf92dd007,0xf599300e}},	//   害事, 成合, 我在, 所要
  { {0xf8204004,0xf933d004,0xfa54e004,0xf5beb001}},	//   万万, 会受, 会接, 座落
  { {0xf59c9009,0x00000003,0x00000003,0x00000003}},	//   的血,   ,   ,
  { {0xf5c9300e,0xfa826004,0xf945f005,0xf82d000d}},	//   用許, 中是, 位受, 署今
  { {0xf942700e,0x00000003,0x00000003,0x00000003}},	//   安委,   ,   ,
  { {0xf927b00f,0xf923f00a,0x00000003,0x00000003}},	//   身分, 本古,   ,
  { {0xf5a2d001,0xf83a8004,0xfa6c8001,0xfb73b005}},	//   均能, 学三, 男方, 写留
  { {0xf4b0e001,0xf91a5004,0xf4ab0001,0xf945300d}},	//   北都, 室在, 肪酸, 月影
  { {0xfb51d009,0xfa766004,0xf921b004,0x00000003}},	//   新社, 区最, 卡巴,
  { {0xfa68e00e,0xfb879007,0xfb855007,0xf93c3004}},	//   二新, 嫌犯, 看第, 一味
  { {0xf82ac006,0xf92e7009,0xf92d1004,0xfa64e00c}},	//   其中, 或在, 首市, 合施
  { {0xf596f009,0xf59c1007,0xfa8ac001,0xf9129005}},	//   湘西, 球袋, 自此, 国式
  { {0xf91f9009,0xf4ab0004,0xf919d005,0x00000003}},	//   模化, 源配, 区年,
  { {0xf909b009,0xfa674004,0xfa5c8004,0xfa4d8001}},	// [e40] 收回, 上放, 市提, 民措
  { {0xf5c6d001,0xf48a0005,0x00000003,0x00000003}},	//   目詳, 件限,   ,
  { {0xfa676009,0xfb659004,0xf814c00c,0xfb69500c}},	//   不放, 用玉, 付供, 庫索
  { {0xf59bd007,0xfa5f6005,0x00000003,0x00000003}},	//   送貨, 商洛,   ,
  { {0xf9265007,0xfa546007,0xf93c1004,0xf5b3700c}},	//   種大, 記時, 要客, 由買
  { {0xfb61700f,0xf9257001,0xf8294004,0xfa81e008}},	//   業生, 可入, 式主, 賢治
  { {0xf5b67009,0xf8404007,0xfa7f4004,0xf80f4001}},	//   出要, 衣住, 探明, 比丘
  { {0xfb5bb004,0xfa590001,0xf925d004,0xf5c45004}},	//   交申, 作比, 斯尼, 港航
  { {0xf8218004,0xf4bd8005,0x00000003,0x00000003}},	//   三万, 包里,   ,
  { {0xf81d8004,0xf59c1005,0x00000003,0x00000003}},	//   内不, 一落,   ,
  { {0xf942d006,0xfa7c6007,0xf5c5b004,0xfa70a001}},	//   很多, 入書, 是西, 由教
  { {0xfa6d6009,0xf8178004,0xfa558005,0x00000003}},	//   史最, 功人, 瑞昌,
  { {0xf8484009,0xf9415005,0xfb7cf00c,0xf91ef005}},	//   在信, 了古, 品社, 大失
  { {0xf9423004,0xf8276005,0xf8366005,0x00000003}},	//   有少, 式供, 活体,
  { {0xfa500004,0xf9277004,0xf9119005,0xf4aac005}},	//   何文, 在得, 味地, 士陵
  { {0xf9157009,0xf922f001,0xf92c5005,0xf48d200c}},	//   活垃, 正妹, 或合, 水鳥
  { {0xf92f3009,0xf9127009,0xfa6c0009,0xf9239004}},	// [e50] 化大, 国名, 溶液, 代号
  { {0xf4c3e008,0xf5c93004,0xfa4ac005,0xf4a4e005}},	//   下高, 雨花, 当指, 温降
  { {0xfa514006,0xfa862009,0xf9191004,0x00000003}},	//   南海, 是新, 永州,
  { {0xfa66600c,0xfa876005,0xf913100c,0x00000003}},	//   上業, 修整, 報平,
  { {0xf5bd700f,0xf8242009,0xf4a04007,0xf59c1004}},	//   性質, 案中, 業開, 持良
  { {0xfa76a006,0xfb4fd007,0xf93b3004,0xf930700c}},	//   方案, 色系, 要当, 北入
  { {0xfb73900b,0xfa646008,0xf9199001,0xfa638001}},	//   供給, 再構, 券優, 型流
  { {0xfa68e004,0xf93cf001,0xf91fb004,0xfa666002}},	//   李某, 濃厚, 面分, 裏有
  { {0xfa658004,0xf9169008,0xfa50600c,0x00000003}},	//   上成, 格好, 林春,
  { {0xf90a500e,0xf5949004,0xfa64e005,0x00000003}},	//   直前, 定解, 位情,
  { {0xfa65a009,0xfa694004,0xf59bf005,0xfb6e7005}},	//   不成, 式来, 吃肉, 近群
  { {0xf80c8007,0xfb4a5004,0xf4acc001,0xf4cb2008}},	//   化事, 家答, 準配, 過酷
  { {0xf5b6d007,0xfa864009,0xfa656005,0x00000003}},	//   主自, 支架, 和李,
  { {0xf82da007,0xf5a71001,0x00000003,0x00000003}},	//   浴乳, 而自,   ,
  { {0xf5b23007,0xf48ee001,0xf5c15004,0xf5959004}},	//   沿著, 地重, 峡谷, 非行
  { {0xf845e00f,0xf839c00e,0xf946500a,0xfb56b002}},	//   部位, 人件, 納可, 屹立
  { {0xfa62e001,0xf594900c,0xf9445002,0x00000003}},	// [e60] 合機, 力農, 有山,
  { {0xf844e00f,0xf9199004,0xf9181004,0xfa614004}},	//   利事, 入城, 出差, 商活
  { {0xf9305006,0xfa4de00f,0xf830e004,0xf925d004}},	//   北大, 子書, 新京, 物力
  { {0xf4c5000e,0xfb75b001,0xf5b97001,0xf82d0004}},	//   上高, 務知, 知行, 署上
  { {0xf947700c,0x00000003,0x00000003,0x00000003}},	//   上女,   ,   ,
  { {0xf4c52006,0xfa5de001,0xf8258004,0xfa7ba00a}},	//   不高, 心推, 行不, 古河
  { {0xfa59a005,0xfb493005,0x00000003,0x00000003}},	//   九洲, 延的,   ,
  { {0xfa5f6004,0xf91cd001,0xfb545001,0xfa756005}},	//   内温, 急報, 栽種, 值是
  { {0xfa570006,0xfa624007,0xf920b004,0xf48c0001}},	//   真正, 集水, 代商, 家音
  { {0xfa4b8001,0xfa71a005,0xfb7df002,0x00000003}},	//   園渡, 田改, 吃火,
  { {0xf5b83006,0xf9207007,0xf932d004,0xfa63c008}},	//   任追, 頭城, 会商, 例文
  { {0xfa63c004,0xf4946001,0xf9125001,0xfa71e005}},	//   律文, 都適, 飽和, 地放
  { {0xfa768001,0xfb57f001,0xf9295004,0xf944f00c}},	//   人持, 出用, 在德, 位商
  { {0xfb7a100f,0xf9409004,0xf938b004,0xf93c5005}},	//   一生, 内国, 所刊, 一就
  { {0xfa856006,0xfa63800b,0xf9453005,0x00000003}},	//   森林, 請求, 月山,
  { {0xfa5ce006,0xfa6fe00f,0xf59a1007,0xf9445004}},	//   品房, 甲方, 一趟, 有就
  { {0xfb5fd007,0xf93c7005,0xf93ab005,0x00000003}},	// [e70] 正版, 市少, 磁力,
  { {0xf828a00c,0xf5c55002,0x00000003,0x00000003}},	//   收低, 薯藤,   ,
  { {0xf594500f,0xf93d3006,0xf9129004,0xfb64b005}},	//   望能, 的多, 国小, 京石
  { {0xf81a200b,0xf92f5007,0xf9313004,0xf58b3008}},	//   品一, 魔力, 何利, 成要
  { {0xf920d009,0xf919500a,0xf4c22005,0xf90ed00a}},	//   院士, 別冊, 等金, 防士
  { {0xf921f009,0xf81f0009,0xf9343008,0xf5cb7001}},	//   中得, 促使, 蒙子, 雪花
  { {0xf93b1007,0xf90e1008,0xf92c3001,0xf5a0d005}},	//   要向, 甲府, 間可, 争行
  { {0xfa4f400f,0xfb7c500e,0xfa57400a,0x00000003}},	//   南投, 療科, 高柳,
  { {0xf90f7009,0xf934d001,0xfa64a00c,0xf810600c}},	//   地分, 生小, 效改, 林主
  { {0xfb6cd001,0xf9467005,0xf498c00c,0xfb63b005}},	//   術移, 名副, 方部, 欣然
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9285009,0xfb683005,0xf9131005,0xf9305005}},	//   在学, 在珠, 押合, 比在
  { {0xfb515006,0xfa4d400c,0x00000003,0x00000003}},	//   台管, 道放,   ,
  { {0xfa77800b,0xfa672007,0xf92d7007,0xfb82f004}},	//   人材, 住情, 紓困, 月生
  { {0xf824e004,0xfa602001,0xfb4a5004,0xfa728001}},	//   上万, 分法, 家研, 山步
  { {0xf9287004,0xf5aa1004,0xfa740008,0xf49a000c}},	//   在古, 小起, 響曲, 工香
  { {0xf4c08004,0xf5a0f001,0xf917f00c,0x00000003}},	// [e80] 万通, 拆解, 刻刻,
  { {0xfa5d0006,0xfb527008,0xfb54700c,0xf59fd00c}},	//   的文, 能界, 拿破, 指認
  { {0xf592d00e,0xfb735005,0xf4a9200d,0x00000003}},	//   料請, 多生, 雨露,
  { {0xf948300f,0xfa702004,0xf93f3004,0xf9455005}},	//   完工, 地成, 的典, 克公
  { {0xfb615004,0xf9135001,0xf93c500c,0xf90ad005}},	//   代科, 使出, 一己, 海子
  { {0xf58c500f,0xfa66a006,0xf9495007,0xfa630008}},	//   我要, 益性, 小出, 吉本
  { {0xfb78900f,0xfb737006,0xf935f001,0xfa738008}},	//   聞稿, 会科, 婚宴, 政改
  { {0xf827a009,0xf9451005,0xf914100c,0xf934d00a}},	//   行中, 手在, 綿延, 鍛冶
  { {0xf5a1f006,0xfb85900f,0xf92d9004,0xfb4db005}},	//   予行, 位科, 苗床, 年申
  { {0xf9489009,0x00000003,0x00000003,0x00000003}},	//   行国,   ,   ,
  { {0xf4922001,0xf5bad00a,0xfb51d00c,0x00000003}},	//   誰都, 敦賀, 瑰精,
  { {0xfb74b008,0xf9365008,0xfa5bc002,0x00000003}},	//   存症, 機化, 局方,
  { {0xfa818006,0xf4c1c007,0xfa508001,0xfa6f6004}},	//   院校, 月開, 字書, 防患
  { {0xf5a29008,0xf49f8002,0x00000003,0x00000003}},	//   文芸, 客需,   ,
  { {0xf916b004,0xfb74b00a,0x00000003,0x00000003}},	//   格平, 租税,   ,
  { {0xfa86c004,0xfa8a200a,0x00000003,0x00000003}},	//   早晨, 師派,   ,
  { {0xfa796006,0xf9473007,0xfa614007,0xfb5b3001}},	// [e90] 相比, 住商, 切法, 此系
  { {0xf8120005,0x00000003,0x00000003,0x00000003}},	//   定三,   ,   ,
  { {0xfb7c5009,0xf93e9004,0xf48b6001,0xf915d00c}},	//   市生, 市就, 海風, 命地
  { {0xfa63e006,0xfb705007,0xf923d004,0xfa5da001}},	//   合本, 研磨, 中德, 者意
  { {0xfa596007,0xf5c6100c,0xfa4b8005,0x00000003}},	//   言時, 良農, 道成,
  { {0xfa74800f,0xf9271004,0xfb623005,0xf81c000d}},	//   精油, 部向, 公牛, 的予
  { {0xfa66e006,0xf591100e,0xf4c9e001,0xf593b00c}},	//   手段, 愛車, 低頭, 力股
  { {0xf4c02004,0xf9269001,0xf4aa6004,0xf92d5001}},	//   密鼓, 推崇, 易量, 準分
  { {0xfb823001,0xf910500c,0x00000003,0x00000003}},	//   又省, 地底,   ,
  { {0xf5ba5006,0xf9363004,0xf942f001,0xf5b23001}},	//   特色, 也得, 手合, 落葉
  { {0xf58f900f,0xf5a31007,0xfa7f6001,0xf5b5100c}},	//   引言, 事行, 次投, 任行
  { {0xfa7c0009,0xfb827001,0xf4c64001,0xfb57700c}},	//   略性, 澈的, 認風, 人笑
  { {0xf90bf009,0xf4a74008,0xf9381001,0xfa590005}},	//   海峡, 物面, 真報, 保活
  { {0xf80ea008,0x00000003,0x00000003,0x00000003}},	//   純一,   ,   ,
  { {0xf840a009,0xf4bda009,0xfa7c6004,0xf4966005}},	//   次人, 的限, 武林, 人透
  { {0xf4ab0001,0x00000003,0x00000003,0x00000003}},	//   道高,   ,   ,
  { {0xf827a007,0xfa7c4009,0xfa5d8008,0xfa592005}},	// [ea0] 和你, 学法, 約束, 保方
  { {0xfa79c004,0xf826e005,0xf830c00d,0x00000003}},	//   交材, 双井, 田亮,
  { {0xf922d006,0xfa4ca009,0xf927b009,0xf9271005}},	//   中学, 体性, 物医, 表土
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf4b30007,0xf9483004,0xf4afe001,0xfa736001}},	//   通通, 城分, 字面, 政活
  { {0xf9109007,0xf5c7b004,0xf923100d,0x00000003}},	//   到哪, 在表, 般只,
  { {0xf922f00b,0xf93e3006,0xfa632007,0xfa88a008}},	//   中古, 的利, 消暑, 士法
  { {0xf917d00f,0xfa71c005,0x00000003,0x00000003}},	//   書名, 米水,   ,
  { {0xf83e0009,0xf4890001,0xfb84b004,0xfa75c004}},	//   大信, 件送, 案系, 治沙
  { {0xf90ff00f,0xfa682004,0xfb85500c,0xf927900c}},	//   詳全, 前段, 上真, 復出
  { {0xfb703001,0xfa5cc001,0xf59fb001,0xf9211004}},	//   南管, 心教, 抄襲, 既可
  { {0xfb839009,0xfb50b007,0xf8226007,0xf9365005}},	//   例的, 山線, 指令, 星北
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf5c1500c,0xf929700c,0xf5b81005,0xfa866005}},	//   口菜, 火勢, 示表, 雨情
  { {0xf848e00f,0xf8108004,0xf4c44001,0xf5bc7005}},	//   自付, 得使, 車配, 以追
  { {0xf910f009,0xfa5d8007,0xfb58d004,0xfb5d7004}},	//   山州, 約期, 出登, 警系
  { {0xfb581007,0xf836c001,0xf928d004,0xf93df004}},	// [eb0] 方神, 容介, 横幅, 求出
  { {0xf92f1007,0xfa6b8005,0x00000003,0x00000003}},	//   五分, 其核,   ,
  { {0xfb593006,0xfa744004,0xf8380004,0xfa54e008}},	//   此留, 放活, 核不, 際水
  { {0xf8322006,0xf83be009,0xf4ac200e,0xf81c2004}},	//   共中, 大企, 成金, 境不
  { {0xf935100f,0xf917d009,0xf4a9600e,0xfa71e00e}},	//   領域, 人受, 全長, 統括
  { {0xf4bc4001,0xf9133005,0xf9271005,0x00000003}},	//   局防, 共平, 表域,
  { {0xf9101004,0xfa6a4004,0xf915300c,0x00000003}},	//   即在, 明春, 臻完,
  { {0xfb853001,0xfb86b004,0xf4a4a001,0xf93e3005}},	//   下第, 位素, 湯飯, 的剩
  { {0xf4bd6001,0xf5a0d00c,0x00000003,0x00000003}},	//   幅降, 必買,   ,
  { {0xfa796007,0xfa66400c,0x00000003,0x00000003}},	//   券投, 小月,   ,
  { {0xfb843008,0xfa87200c,0x00000003,0x00000003}},	//   損等, 種東,   ,
  { {0xf5a43004,0xf5891001,0xfa4ee001,0xf82e6005}},	//   上而, 園行, 柔情, 女企
  { {0xfa554007,0xfb56900c,0x00000003,0x00000003}},	//   誘惑, 基的,   ,
  { {0xfa788004,0xf8134001,0xfa4de001,0x00000003}},	//   人正, 料係, 染整,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa872009,0xfa862004,0x00000003,0x00000003}},	//   售收, 景泰,   ,
  { {0xfa58a00f,0xfa660006,0xfa74e004,0xf844c00a}},	// [ec0] 所有, 位或, 追捧, 浩二
  { {0xfa738007,0xf9385001,0xf937f001,0xfb61f004}},	//   山水, 作多, 果分, 犬病
  { {0xfb84d008,0xf944b005,0xfb58d00c,0xf5bcf002}},	//   反省, 不参, 瘤的, 苦辣
  { {0xfa898006,0xfb6b5006,0xf4ade004,0xf5c6b008}},	//   用水, 限的, 他非, 表資
  { {0xf5919001,0xf49be005,0xf8270005,0xfa6d4005}},	//   且能, 度非, 殊人, 水方
  { {0xf59c900d,0x00000003,0x00000003,0x00000003}},	//   附言,   ,   ,
  { {0xf5909007,0xfa838001,0xf91dd001,0xf4c80005}},	//   誕舞, 代新, 你做, 小青
  { {0xfb851009,0xfa70a004,0xfa720004,0xf9247005}},	//   同等, 新注, 板材, 伯利
  { {0xfa5ba009,0xf9357009,0xf90df007,0xf942f005}},	//   激活, 舞弊, 音光, 万山
  { {0xfb865004,0xf9213001,0xf4a02005,0x00000003}},	//   上第, 彭博, 次面,
  { {0xf4c52004,0xf4b9a001,0xf8386004,0xfa6f400a}},	//   上通, 保防, 室介, 洲本
  { {0xf81c800f,0xfa676004,0xfa87e004,0xf4b40001}},	//   一件, 同本, 在支, 高里
  { {0xfb6ef006,0xf5c23004,0xf5a45008,0xf9415005}},	//   向社, 中表, 興財, 均得
  { {0xfa864001,0xfa754005,0x00000003,0x00000003}},	//   助民, 命根,   ,
  { {0xf4b5a004,0x00000003,0x00000003,0x00000003}},	//   速通,   ,   ,
  { {0xfa658009,0xfa540007,0xf842c005,0xfa65600c}},	//   上提, 四方, 代以, 名思
  { {0xf911900f,0xfa582009,0xf91e300e,0xf5b87005}},	// [ed0] 東南, 作文, 財布, 令行
  { {0xf5aa9004,0xfb4f1001,0xfa6ac005,0xfa57600c}},	//   年迎, 育目, 年持, 高深
  { {0xfb5a500f,0xfb7af00e,0xf91c3009,0xfa59e004}},	//   役男, 一目, 接入, 障性
  { {0xf940b006,0xfa636009,0xfa560004,0xfa75e00c}},	//   超声, 事流, 速提, 出有
  { {0xf80bc00f,0xf4c7200e,0xf5a69007,0xf8462001}},	//   源供, 免除, 屋買, 推一
  { {0xfa5d8004,0xf93d3004,0xfa5e000c,0x00000003}},	//   考成, 雄厚, 的暖,
  { {0xf8140004,0xf58f7001,0xf5c2b004,0xfa6c2001}},	//   供便, 我走, 是行, 水溪
  { {0xf83c400f,0xfb4db007,0xf940d004,0xf4c7e00a}},	//   別人, 防爆, 者共, 前週
  { {0xf91a9009,0x00000003,0x00000003,0x00000003}},	//   此公,   ,   ,
  { {0xfa806006,0xf9127004,0xf9221008,0xf9467004}},	//   面提, 国前, 形寸, 量很
  { {0xfa7ec00a,0xfa714010,0xfa614002,0x00000003}},	//   性派, 地条, 有持,
  { {0xfa686001,0x00000003,0x00000003,0x00000003}},	//   小木,   ,   ,
  { {0xf825800f,0xf9443004,0xf9367005,0xf90e9005}},	//   見信, 三山, 察在, 平庄
  { {0xfb52d006,0xfb66900f,0xf92e500c,0xf941500c}},	//   精神, 全站, 化取, 商基
  { {0xfa64e004,0xf5b95005,0xf5a63005,0xf90b9005}},	//   位清, 以行, 名被, 水回
  { {0xf9467009,0xf81de001,0xf9247001,0xf934b001}},	//   名可, 久久, 可取, 生前
  { {0xfb619009,0xf90bf007,0xf815c004,0xf5c19008}},	// [ee0] 本着, 海巡, 多件, 無茶
  { {0xf92d900c,0xfb7e300d,0xf4b2800d,0x00000003}},	//   源室, 内留, 定退,
  { {0xf83ec006,0xfa6c4009,0xfb72b009,0xf93d9001}},	//   次会, 家海, 料等, 情城
  { {0xf4b8e00c,0xf941d00a,0x00000003,0x00000003}},	//   一鍋, 奇形,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf59b9007,0xfa896004,0xfb6b5005,0x00000003}},	//   要自, 用收, 道真,
  { {0xf8140009,0xf90c1009,0xfa81e001,0xf59c3005}},	//   写作, 年北, 形查, 市芝
  { {0xfa6a2008,0xfb743008,0xf813e001,0xf93bf001}},	//   与条, 多目, 教保, 時定
  { {0xfa888004,0xf9173004,0xf8300001,0xf947f00c}},	//   佩戴, 出土, 由低, 偏向
  { {0xf5c79009,0xfb51d009,0xf92cf008,0xf592d004}},	//   在自, 新精, 外局, 料袋
  { {0xf913b004,0xf916d00c,0xf9441005,0xfa76000c}},	//   找公, 人商, 吉尼, 汽水
  { {0xf8184009,0xfa6a4004,0xfa4be001,0xfb81f00c}},	//   保修, 明来, 金手, 三生
  { {0xf4a68009,0xf5a4d004,0xf9357004,0x00000003}},	//   全集, 前要, 通山,
  { {0xf9231008,0xf9107005,0xfa50c00a,0xf5a4d00c}},	//   設工, 仿宋, 偕成, 才要
  { {0xf493e009,0xfa7dc004,0xf9277002,0x00000003}},	//   白酒, 性是, 鑫品,
  { {0xf91cd001,0xfa7bc001,0x00000003,0x00000003}},	//   日到, 查扣,   ,
  { {0xf83ec008,0xf92f3005,0xfa780005,0x00000003}},	// [ef0] 財保, 取大, 攻方,
  { {0xf5b7f00f,0xfa582005,0x00000003,0x00000003}},	//   示自, 土新,   ,
  { {0xfa88000e,0xfa79a009,0xfa826004,0xf9459005}},	//   推測, 特此, 中支, 不屑
  { {0xf90b701a,0xfb867007,0xf80c2004,0xfa600001}},	//   直属, 事由, 向一, 的渴
  { {0xfb59f00e,0xf834c004,0xf9141001,0xf92ad005}},	//   知的, 好信, 西德, 剪去
  { {0xf9415009,0xf82a400a,0xf810400a,0x00000003}},	//   集区, 城主, 店主,
  { {0xf824200c,0x00000003,0x00000003,0x00000003}},	//   泊二,   ,   ,
  { {0xf4c5e008,0xfb545004,0xf90c1004,0xfa854004}},	//   同項, 国物, 年南, 目或
  { {0xfb523001,0xfa6a2001,0xf93d1005,0x00000003}},	//   失眠, 水月, 居安,
  { {0xf93e7009,0xfa5ec004,0xf5c1700a,0xf5a4f00c}},	//   集型, 心活, 短距, 額超
  { {0xf93f9007,0xf9105004,0xfa702004,0xfa504005}},	//   吃到, 地引, 地提, 北武
  { {0xf4b18007,0xf8176009,0xf80c8001,0xf5c8f008}},	//   力銀, 期以, 取事, 器製
  { {0xf9135005,0x00000003,0x00000003,0x00000003}},	//   使基,   ,   ,
  { {0xfb76900f,0xf5b53001,0xf59b5004,0xf93ed001}},	//   生物, 值表, 市迎, 心出
  { {0xf80ac009,0xf941b007,0xfb7fb009,0xf9495001}},	//   提下, 版刊, 黄石, 氏基
  { {0xfa86e006,0xf938500f,0xf81ce004,0xf943f004}},	//   天是, 機場, 市世, 手写
  { {0xf5b95007,0xfa5ca007,0xfa6b0004,0xf5adf001}},	// [f00] 人能, 裁決, 李新, 育講
  { {0xf9459006,0xf5bd7008,0xf5b6b002,0x00000003}},	//   不少, 大表, 紹請,
  { {0xf9305001,0x00000003,0x00000003,0x00000003}},	//   受大,   ,   ,
  { {0xfa50e00f,0xfa88e001,0xf9481004,0xf915b00a}},	//   四月, 推拿, 里去, 主将
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf8130006,0xf5c25004,0xfa82e001,0xfb491004}},	//   博会, 口路, 散步, 架的
  { {0xfb57700b,0xfa744009,0xf599700c,0xf4ab2005}},	//   人科, 百日, 朝西, 道通
  { {0xfb5ed006,0xf498c007,0xf5c23009,0xf93f9004}},	//   大米, 吹風, 面落, 内公
  { {0xf934f001,0xfa79a005,0xf9259005,0x00000003}},	//   料可, 改活, 晨光,
  { {0xf911b007,0xf5b6d008,0xfa672001,0xfb5d5004}},	//   到她, 出資, 富林, 映的
  { {0xfb4eb009,0xfa69800d,0x00000003,0x00000003}},	//   防盗, 海昌,   ,
  { {0xf82b800f,0xfa5ce002,0x00000003,0x00000003}},	//   家人, 的梅,   ,
  { {0xfa79c004,0xf84bc001,0xf48f200a,0xf596100a}},	//   改方, 陪伴, 想通, 星術
  { {0xfa5b0006,0xfa5f0009,0xfa678007,0xfa624001}},	//   品感, 担法, 量摘, 有某
  { {0xf9365004,0xfb7e1004,0xf93bb00d,0x00000003}},	//   候就, 元用, 陀司,
  { {0xfa60c006,0xfa830004,0xfb84300c,0x00000003}},	//   清晰, 是流, 下生,
  { {0xfa88c00f,0xfa754004,0xf83de004,0xfb581004}},	// [f10] 全書, 主意, 校不, 点生
  { {0xf59b500f,0xfa61e005,0x00000003,0x00000003}},	//   技股, 案手,   ,
  { {0xfa4bc00f,0xf9479007,0xf91c9004,0xf846e004}},	//   我有, 上山, 加合, 用也
  { {0xfa53c004,0xf5949001,0xfa506005,0xfa7d000c}},	//   会比, 供買, 得改, 試探
  { {0xf946b00e,0xf9355001,0xf9365010,0xfa87800d}},	//   希少, 星商, 江八, 雨或
  { {0xfa72800e,0xfb4b300e,0xf4c5c001,0xf8290001}},	//   就活, 直線, 後送, 意代
  { {0xf49b400a,0xf499c00c,0xf948d00c,0xf944900d}},	//   学附, 春送, 福客, 王岐
  { {0xfa79a006,0xf8266006,0xfa536007,0xf9239009}},	//   人数, 式上, 做成, 是多
  { {0xf9391009,0xfb807009,0xfb68f004,0xf816a004}},	//   保基, 文秘, 被用, 高交
  { {0xfa51c001,0xf80c8001,0xfa728001,0xfa88e001}},	//   供教, 取下, 能服, 質料
  { {0xf4b72001,0x00000003,0x00000003,0x00000003}},	//   記都,   ,   ,
  { {0xf82ea001,0xfb6a5004,0xf914b00a,0x00000003}},	//   到三, 道炎, 能勢,
  { {0xf92f3001,0xf91bb005,0xf4aae00c,0x00000003}},	//   動合, 学初, 間隙,
  { {0xfb6ab009,0xf5cb900c,0x00000003,0x00000003}},	//   子版, 自述,   ,
  { {0xfa6a2007,0xf5c89009,0xfa66e005,0xf82b800c}},	//   制法, 自考, 今春, 場作
  { {0xfa4d4004,0xfb581001,0xf922f00c,0x00000003}},	//   他情, 治社, 召委,
  { {0xf90fb001,0xfa78a00c,0x00000003,0x00000003}},	// [f20] 平北, 方未,   ,
  { {0xf9479009,0xfb7a7007,0xfb855001,0x00000003}},	//   上就, 所研, 上生,
  { {0xfb65700e,0xfa6cc001,0xfa6d2004,0xf8432005}},	//   義理, 年正, 整方, 京世
  { {0xf9479009,0xf93c300e,0xf914d004,0xf4a3e00c}},	//   行公, 要因, 好学, 梭雷
  { {0xf93bd001,0xf92ab005,0xf939f00d,0x00000003}},	//   心安, 成及, 朝廷,
  { {0xf92a9007,0xf48fa001,0xfb75d004,0x00000003}},	//   火山, 拳道, 速生,
  { {0xfa582009,0xf937100e,0x00000003,0x00000003}},	//   作指, 依存,   ,
  { {0xfb4bd00b,0xfa7da004,0xf93c9004,0xfb6a300c}},	//   練習, 大支, 持大, 奪目
  { {0xfa4bc00f,0xf5b1f004,0xf9125001,0xf910900c}},	//   青春, 地落, 績分, 東商
  { {0xfa5ee006,0xf8398004,0xf80c200c,0xfa67200c}},	//   的性, 入不, 我住, 界木
  { {0xfb86f007,0xf9283004,0xfb523004,0xf5b0d001}},	//   宏碁, 八宝, 国玉, 細肩
  { {0xfb77f004,0xfa634001,0xf8194004,0xf83e2005}},	//   也由, 有正, 秀企, 性信
  { {0xf92e9004,0x00000003,0x00000003,0x00000003}},	//   殖器,   ,   ,
  { {0xf945d00f,0xfa65600b,0xf5a83004,0xf9135001}},	//   屋出, 納期, 小街, 社字
  { {0xfa620007,0xf946f00c,0x00000003,0x00000003}},	//   葉機, 積大,   ,
  { {0xf5911009,0xf926300e,0xfa5f8001,0xf93e1004}},	//   得起, 部市, 片有, 的士
  { {0xfb75f004,0xf4b88001,0x00000003,0x00000003}},	// [f30] 星科, 菜食,   ,
  { {0xf916f001,0xf90fb001,0xf5a6500a,0xf83dc00c}},	//   任助, 平南, 型製, 管事
  { {0xf92d5007,0xfb849001,0xf8400004,0xfa7ae005}},	//   他商, 半球, 校中, 除氧
  { {0xf9355004,0xfb721004,0xfb53d001,0xf90af00c}},	//   域商, 展空, 西米, 其因
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa52a009,0xf9231004,0xf82a4008,0xf9305004}},	//   教案, 京北, 却下, 得出
  { {0xf82e4008,0xf83c0005,0xf92bd00c,0xfb74500a}},	//   淳一, 性企, 民反, 線維
  { {0xfa502007,0xf81b8002,0x00000003,0x00000003}},	//   展望, 需以,   ,
  { {0xfa7e2004,0xfb87f005,0xf816c00a,0x00000003}},	//   模最, 界群, 食中,
  { {0xf91a1006,0xfa642004,0xf49b4008,0xf93ef001}},	//   接待, 月正, 武雄, 理心
  { {0xf48d400b,0x00000003,0x00000003,0x00000003}},	//   課題,   ,   ,
  { {0xf92f7009,0xf92d3004,0xf91a5004,0xfb7cd001}},	//   算器, 取必, 方地, 要穿
  { {0xf9493004,0xf940d001,0x00000003,0x00000003}},	//   李志, 逆勢,   ,
  { {0xf499c009,0xf5a7f004,0xf93d9004,0xfa56600c}},	//   令限, 前走, 如因, 生未
  { {0xf93f3009,0xf91cd004,0xf4b9c008,0x00000003}},	//   的吸, 冠希, 譜面,
  { {0xfa560009,0xf5a1d001,0xf922d004,0xf825c004}},	//   州概, 三芝, 中度, 之以
  { {0xfb4df00f,0xf90c7001,0xfa77e001,0xfb561004}},	// [f40] 曲線, 水可, 登日, 芽状
  { {0xf90bf00f,0xf9189006,0xf912d004,0xf9191005}},	//   收到, 容只, 能参, 特公
  { {0xf8230001,0xf4b2600c,0xf4c7c005,0xf81f8005}},	//   橋下, 供餐, 式非, 球俱
  { {0xfb5bb001,0xfb4c700a,0xf947100c,0xfb805005}},	//   邦生, 刷系, 籍出, 超百
  { {0xf93ad00e,0xf91cd004,0xfb513001,0xf9467004}},	//   往復, 日印, 東科, 行初
  { {0xf4b6a001,0xf91df00c,0xfa62800c,0xf83de00c}},	//   神通, 信宏, 拉法, 校位
  { {0xf9231005,0xf597d00c,0xf491c00c,0x00000003}},	//   京南, 期追, 腰酸,
  { {0xf930700c,0x00000003,0x00000003,0x00000003}},	//   北工,   ,   ,
  { {0xfa6a4005,0x00000003,0x00000003,0x00000003}},	//   式更,   ,   ,
  { {0xfa56000c,0x00000003,0x00000003,0x00000003}},	//   原民,   ,   ,
  { {0xf92f5004,0xfb4dd001,0xf91e3005,0xf91fb002}},	//   向地, 米粉, 左家, 你出
  { {0xf83ba009,0xf9249009,0xfb5d9004,0xfa78a004}},	//   入中, 是利, 学特, 建模
  { {0xfa7e8001,0xfa78a004,0xf59d7001,0xf81e800d}},	//   信指, 特旗, 者而, 元代
  { {0xf93e1004,0xf945d00a,0xf9447005,0xfa500010}},	//   的填, 躍動, 配和, 投棄
  { {0xfa5d8004,0xfb4c300c,0xfb6b500c,0x00000003}},	//   市正, 水火, 秒瞬,
  { {0xfa698006,0xf919700f,0xf9341004,0xf829a004}},	//   迎您, 遺失, 定全, 家会
  { {0xfa718007,0xf819e009,0xf5937001,0xf80e800a}},	// [f50] 抱枕, 持下, 務考, 志保
  { {0xf917f00f,0xf838e006,0xf947f00e,0xf8300001}},	//   登出, 人以, 二度, 己一
  { {0xf830000c,0xf9187005,0x00000003,0x00000003}},	//   深一, 移就,   ,
  { {0xfa5a6004,0xfa72a008,0xf93d5002,0xfb75300d}},	//   停放, 西支, 魄力, 默笑
  { {0xfa698001,0xf92db001,0xf5b4f004,0xf93d1004}},	//   冷泉, 我只, 百花, 要害
  { {0xfa740005,0xf93c3005,0x00000003,0x00000003}},	//   国演, 的始,   ,
  { {0xfa818004,0xf932900c,0x00000003,0x00000003}},	//   本意, 余光,   ,
  { {0xf5c7100f,0xf838e00e,0xf91b1005,0x00000003}},	//   火車, 改修, 来北,
  { {0xf8228008,0xf91f1004,0xf923700c,0xf911b005}},	//   三世, 巧家, 可切, 影天
  { {0xf9193009,0xf4bbe00a,0x00000003,0x00000003}},	//   典当, 秀逸,   ,
  { {0xf91e3004,0xf928100c,0xfb7f9005,0xf58f9005}},	//   性学, 罪型, 者第, 金蝶
  { {0xf597b001,0xfb819004,0xf4be6004,0xf5b5d00a}},	//   州路, 等症, 者通, 陽花
  { {0xf9257006,0xf81f4007,0xfa706004,0xf92d5004}},	//   是建, 必修, 平正, 得安
  { {0xfa56a009,0xfb6b500c,0x00000003,0x00000003}},	//   瑞星, 道生,   ,
  { {0xfb831007,0xf49ae007,0xfa58000c,0x00000003}},	//   均由, 度量, 神泣,
  { {0xf91fd004,0xf80cc004,0xf915d004,0xf93e700a}},	//   卡器, 策不, 能影, 市右
  { {0xfa5ec009,0xf83ae004,0xf4a7a008,0x00000003}},	// [f60] 者提, 以五, 硫黄,
  { {0xf830e00f,0xf93e300f,0xfb849001,0xfa744005}},	//   害人, 魅力, 立筒, 使整
  { {0xf92c9009,0xf5b21001,0xf9193004,0xf5b5d004}},	//   提取, 台証, 春光, 白花
  { {0xf81f0007,0xfb84b007,0xf80d2004,0xf9125001}},	//   千人, 蛋糕, 子中, 環島
  { {0xf9239006,0xf91c1009,0xf94a500e,0xf4c34001}},	//   目名, 以建, 階建, 型重
  { {0xfa6bc00e,0xf83b2004,0xf5ad9005,0xf4a16005}},	//   職支, 勤人, 年能, 本配
  { {0xfa766008,0xfa598001,0xfa568005,0xf91f5005}},	//   主成, 停業, 生注, 造学
  { {0xfa66a00f,0xf944900e,0xf945f001,0xf4b0e010}},	//   而成, 納品, 益彩, 展途
  { {0xf8482008,0xfb83b004,0xf938d001,0x00000003}},	//   優位, 先用, 果展,
  { {0xfa750009,0xfb6b7004,0xf80d8004,0xf90c5008}},	//   国性, 伐的, 南三, 強固
  { {0xf59f1009,0xf9373005,0x00000003,0x00000003}},	//   分考, 期学,   ,
  { {0xf9373006,0xfb4bb009,0xf5ad9009,0xfa624001}},	//   真学, 年科, 直至, 分段
  { {0xfb865004,0xfa53e004,0xf59c100c,0xf933d005}},	//   介石, 供方, 一能, 供出
  { {0xf9453007,0xfa77a005,0xfa57000c,0xf5a8700a}},	//   月報, 人拒, 依教, 規表
  { {0xf9265006,0xfb6d7007,0xfb521001,0xfb777005}},	//   在各, 旗等, 地申, 生缺
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9303005,0xfb843010,0x00000003,0x00000003}},	// [f70] 他具, 重版,   ,
  { {0xfa69c00f,0xf9187009,0xf83de009,0xfa502004}},	//   規格, 此同, 照中, 外新
  { {0xf92cd005,0xfb49b00c,0x00000003,0x00000003}},	//   当区, 然真,   ,
  { {0xf90ed009,0xf91bd004,0xf91ad004,0xfb885004}},	//   液化, 入占, 入当, 行特
  { {0xfb7cb00f,0xfa85e007,0xf9399009,0xf58cb004}},	//   心理, 您服, 言内, 世行
  { {0xf929f00e,0xf83b2004,0xfb58d004,0xfb58f008}},	//   体型, 交以, 区知, 点目
  { {0xf8112007,0xf92cf007,0xf4a74004,0xf594b001}},	//   套件, 子宮, 利院, 期行
  { {0xf5a75008,0xf9171004,0xf9325001,0xfb6c5005}},	//   不調, 人定, 通往, 休的
  { {0xfa5a0009,0xf8250001,0xfb52700a,0xf94a1005}},	//   作性, 屋修, 便物, 李学
  { {0xfa55c007,0xfb6bb001,0xfa870005,0xf5a4d00c}},	//   跟我, 截然, 在搞, 見自
  { {0xfa64400f,0xf82b600a,0x00000003,0x00000003}},	//   才有, 直也,   ,
  { {0xf5b0b00b,0xf5bab00c,0x00000003,0x00000003}},	//   議論, 判解,   ,
  { {0xf5be3004,0xf91a300c,0xf4b4c002,0x00000003}},	//   寡老, 妹報, 原里,
  { {0xf81ca007,0xf9175001,0xf8228001,0xfb6a700c}},	//   約一, 治宣, 玉井, 未眠
  { {0xf5b2f00f,0xf943d001,0xf58f7001,0xf5913005}},	//   東西, 型分, 違背, 抗衰
  { {0xfa5bc001,0xfa85200c,0x00000003,0x00000003}},	//   謀殺, 華映,   ,
  { {0xf941f006,0xf93f7004,0xf4c5a005,0xf80da005}},	// [f80] 泉州, 切合, 届青, 得低
  { {0xf93ff009,0xf92d9001,0xfa5d0004,0xf49b4008}},	//   千年, 俗名, 弄清, 日部
  { {0xf91e1009,0xfa4e2001,0xf93e900c,0xfa69e00a}},	//   池州, 店旅, 市報, 序曲
  { {0xfa5c6004,0xfa806004,0xf934100a,0xf942500c}},	//   一数, 代流, 定器, 指大
  { {0xfb881004,0x00000003,0x00000003,0x00000003}},	//   前状,   ,   ,
  { {0xfa6a400b,0xfa4e2004,0x00000003,0x00000003}},	//   明日, 化投,   ,
  { {0xf837a00b,0xfb6e5009,0xf917f001,0xfa4c8005}},	//   陸上, 抗病, 人快, 倒数
  { {0xf80f6004,0xf83a400c,0xfa56600d,0x00000003}},	//   孕不, 鳥保, 域或,
  { {0xf5a7f001,0xfb6c5005,0xfa4de00d,0x00000003}},	//   低血, 青石, 姑息,
  { {0xf9275006,0xf5a5900e,0xf4b40001,0xf90c5005}},	//   温度, 半角, 付額, 康建
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb86d00e,0xfa646004,0xfa5fa004,0xf943500c}},	//   完結, 下材, 崇明, 下往
  { {0xf5bb3009,0xf945d009,0xf913d004,0x00000003}},	//   学考, 残奥, 款公,
  { {0xfa5fe00f,0xf9331004,0xf80fc00a,0xfb57f00d}},	//   的收, 会多, 字中, 出票
  { {0xfa72000f,0xf825e009,0xf81e8009,0xfa718007}},	//   失業, 上世, 内作, 到此
  { {0xf598300c,0xf92b900c,0xf944500c,0x00000003}},	//   生職, 親山, 載具,
  { {0xf93e7005,0xf93eb005,0xfa77c00a,0xfa68a002}},	// [f90] 分尊, 者少, 電性, 和東
  { {0xf5b41009,0xf914d007,0xfa646004,0xfb67f00c}},	//   好自, 麻吉, 立民, 質等
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb83d004,0xfa734008,0xfa578004,0xfa654005}},	//   告等, 放浪, 生根, 月数
  { {0xfb4a1006,0xfa8ba007,0xf921f004,0xfa846008}},	//   康的, 航海, 中字, 本放
  { {0xf920d004,0xf8322008,0xfb86300a,0xf5b8b00c}},	//   中各, 熱中, 上皮, 她表
  { {0xf90bd006,0xf4c32009,0xf92f5001,0xf80d0004}},	//   海口, 等院, 動刊, 当使
  { {0xfa4f400f,0xfa87a009,0xfa546001,0xfa840001}},	//   北投, 用您, 生消, 種最
  { {0xfa55a006,0xf940900c,0xf939f005,0xf939500a}},	//   多数, 情好, 菜大, 語家
  { {0xfa5a0009,0xfb771008,0xf937500c,0x00000003}},	//   要意, 機管, 初四,
  { {0xf59c9007,0xf91d3004,0x00000003,0x00000003}},	//   所致, 大宗,   ,
  { {0xf8108004,0xfb67b00a,0xf918d005,0xfa5f8005}},	//   北人, 全編, 去其, 情景
  { {0xf5b95001,0xfa52e004,0xf9235001,0xfa614004}},	//   人追, 会文, 可宅, 集活
  { {0xf5a53001,0xf5a81001,0xf9187004,0xfb7d5004}},	//   事責, 低脂, 治地, 逃生
  { {0xfb7d5006,0xfa6c0004,0xfa600001,0xf4b86001}},	//   考生, 念教, 談時, 賞鳥
  { {0xf9469008,0xf5b89001,0x00000003,0x00000003}},	//   和子, 登英,   ,
  { {0xf947300f,0xf93d7004,0xf80da001,0xfb69f005}},	// [fa0] 位典, 内同, 字位, 毒症
  { {0xf921f00f,0xf5c5d007,0xf91c1004,0xf9359001}},	//   本分, 巨蛋, 古巴, 星定
  { {0xfa67e006,0xfa4f4004,0xf5aa7001,0xfb539004}},	//   二次, 暖活, 海豚, 能生
  { {0xf945b009,0xf9445001,0xfb6ed005,0xf9181005}},	//   同心, 有失, 金点, 除安
  { {0xfa6ba004,0x00000003,0x00000003,0x00000003}},	//   海搬,   ,   ,
  { {0xfa766007,0xf9417001,0xf5ad7005,0xf933b00c}},	//   示意, 勇奪, 年西, 托吊
  { {0xfa708004,0xf5ac1008,0xfa4f600c,0xf835400c}},	//   山教, 究課, 暖方, 添一
  { {0xf4ac0007,0xfa838001,0xfa806004,0xf915f00a}},	//   間部, 本業, 面材, 人吉
  { {0xfa5ea004,0xf8276004,0xfb619004,0x00000003}},	//   市数, 明上, 炭生,
  { {0xfa888007,0xf92f5007,0xf8302009,0xfa85c00a}},	//   叫我, 外勤, 新体, 央支
  { {0xf4a72007,0xfa7dc004,0xf8178004,0xf5acd001}},	//   火鍋, 性支, 搜一, 育計
  { {0xfb849007,0xf915d004,0xf5c5100c,0xf823c00c}},	//   先登, 区先, 副董, 草人
  { {0xfb4e7006,0xf90cf004,0xf81fa00c,0xfa82a005}},	//   足球, 海峰, 指下, 本成
  { {0xfa6de006,0xf4c7200e,0xf9437001,0xfa658001}},	//   年新, 和風, 下垂, 名期
  { {0xf83cc009,0xfa550009,0xfb60f004,0xf9101004}},	//   加之, 土流, 扣留, 石岩
  { {0xfb72d006,0xfa6e6004,0xfa894005,0x00000003}},	//   教程, 史民, 洪江,
  { {0xf49c6007,0xfa778001,0xf93b7008,0xfa7ca005}},	// [fb0] 入選, 任校, 最古, 大潜
  { {0xf835e006,0xf58d3001,0xf947300c,0xf945300c}},	//   去了, 道調, 式商, 月失
  { {0xfa61c006,0xf9473008,0xfb7e9001,0xf5a97001}},	//   文本, 界天, 者生, 起見
  { {0xfa730005,0xf5cb900a,0xf934900d,0x00000003}},	//   社成, 自走, 江名,
  { {0xf91fb00f,0xfa5c6009,0xf92eb007,0xfb627004}},	//   採取, 一新, 笑容, 催生
  { {0xf93d3009,0xfa7a2005,0xf4a54005,0x00000003}},	//   雅安, 尤溪, 目首,
  { {0xf82d2006,0xf90c100f,0xfa646006,0xfa526007}},	//   年以, 島地, 有新, 法施
  { {0xf92d5007,0xfa78c004,0xf92a300c,0x00000003}},	//   湖分, 缺氧, 質可,
  { {0xf826c006,0xf9105008,0xf5953001,0x00000003}},	//   量不, 由布, 聚落,
  { {0xf81ba00f,0xfa54a00a,0x00000003,0x00000003}},	//   送他, 弘文,   ,
  { {0xf81d6009,0xfb62b004,0x00000003,0x00000003}},	//   的也, 京科,   ,
  { {0xfa666006,0xf93c500b,0xf842a009,0xf59fd009}},	//   同期, 最強, 六中, 黄花
  { {0xf9457004,0xf92f900a,0x00000003,0x00000003}},	//   行同, 抗器,   ,
  { {0xf9421001,0xfa4be001,0xf83cc00a,0xf92cd005}},	//   合品, 科植, 加下, 民喜
  { {0xf5c6900f,0xf5b35001,0xf90d3008,0x00000003}},	//   表者, 山谷, 署名,
  { {0xf823a009,0xfb5f1004,0xfb561004,0xf933100c}},	//   有以, 性由, 腺癌, 力全
  { {0xf820e00f,0xfb873001,0xfb695004,0xfa7bc005}},	// [fc0] 按下, 問約, 青秀, 以次
  { {0xfa5a0007,0xfa7a600e,0xfb7b9001,0xf9341005}},	//   果日, 相性, 門町, 会利
  { {0xf928b006,0xf91ff007,0xf915b004,0xfa63c001}},	//   享受, 勢力, 格形, 等書
  { {0xfb4b5001,0xf5c69008,0xfa58200c,0xfa5e0005}},	//   家照, 摩耗, 依晨, 的横
  { {0xfa65400f,0xfb83d008,0x00000003,0x00000003}},	//   月新, 須磨,   ,
  { {0xfb5c7001,0xfb6dd004,0xfb897005,0x00000003}},	//   日社, 金用, 慎用,
  { {0xf819e001,0xf90f1008,0xf82fc004,0x00000003}},	//   局保, 彰式, 田保,
  { {0xf8414006,0xf4bba007,0xf5c5700a,0xf93e5005}},	//   第三, 流部, 央自, 集安
  { {0xf932f001,0xf93b7010,0x00000003,0x00000003}},	//   換取, 呂布,   ,
  { {0xf91d300b,0xf8438005,0xf5a61005,0xf9359002}},	//   大字, 公中, 行装, 站入
  { {0xf81f8001,0xf811800c,0xf9239010,0x00000003}},	//   了些, 愛丁, 鮮半,
  { {0xf9249009,0xf8438004,0xfa656005,0xfa60400c}},	//   公平, 置上, 下正, 商措
  { {0xf5b63007,0xfa7a0004,0xf944d004,0xf9107005}},	//   人行, 泥沙, 立外, 地北
  { {0xf824800e,0xf5b01005,0x00000003,0x00000003}},	//   月以, 台胞,   ,
  { {0xf91ef00e,0xf812c007,0x00000003,0x00000003}},	//   信州, 多久,   ,
  { {0xfa6e2009,0xf4c2000d,0xf933500d,0x00000003}},	//   念改, 予重, 尚属,
  { {0xfa58c009,0xf5ba1004,0xf59f5008,0xf5bb1005}},	// [fd0] 九次, 入超, 筆者, 学要
  { {0xf59e300f,0xf8140005,0xf839e00d,0x00000003}},	//   市西, 存不, 古井,
  { {0xf93e900f,0xf5b77007,0xfa738001,0xfb7f300c}},	//   商名, 特考, 花海, 球社
  { {0xf923d009,0xfa55e005,0xf5a2f005,0x00000003}},	//   断地, 州最, 洋芋,
  { {0xfa4c2009,0xf93fd007,0xf4992008,0xfb5d9005}},	//   向所, 約地, 容院, 学点
  { {0xf913b009,0xf90fd004,0xf842c001,0xfa80a001}},	//   寿命, 危及, 業信, 翠水
  { {0xf5a2b004,0xf9341004,0xfa6b8008,0xf9357004}},	//   万能, 定在, 極意, 站大
  { {0xf916b009,0xfa5ce001,0xf81d8001,0xfb89300c}},	//   呼声, 要放, 送件, 富直
  { {0xf9161007,0xf9171004,0xf9285001,0x00000003}},	//   出後, 出宝, 循序,
  { {0xfa5ea006,0xf5b89001,0xfb487004,0xfa88a005}},	//   市新, 她自, 家版, 用改
  { {0xf58e1004,0xf9139004,0xf828e004,0xf917d005}},	//   北老, 找差, 量中, 区太
  { {0xfb609007,0xfa66a004,0xf817400c,0xfa88e005}},	//   代的, 看新, 保保, 在放
  { {0xfa5b0001,0xf9101004,0xf90b5005,0xfa64600c}},	//   作收, 即墨, 年定, 淋漓
  { {0xfa668005,0xfa766005,0xfb4ad00c,0xfa5d2005}},	//   上正, 主提, 具租, 故案
  { {0xfb717004,0xfa66a004,0xf939d002,0x00000003}},	//   望着, 而提, 喝到,
  { {0xfa66a009,0xfb6ab009,0xf5b11001,0xf90ad00c}},	//   不正, 易的, 平西, 水布
  { {0xfa82a009,0xf93cd00c,0xf92ff005,0xf4ad4005}},	// [fe0] 宣武, 市店, 幕分, 笑道
  { {0xf5947001,0xf90d7004,0xf9369004,0xf812c00c}},	//   忙著, 致好, 高大, 站事
  { {0xf81de009,0xfa5bc001,0xf5acf008,0x00000003}},	//   市以, 時指, 水艦,
  { {0xfa5a6007,0xf81b0004,0xf943b00c,0x00000003}},	//   技法, 参事, 安培,
  { {0xf592b001,0xf8172004,0xf92d900c,0xf933d00c}},	//   定考, 果上, 休士, 供基
  { {0xfa7c400b,0x00000003,0x00000003,0x00000003}},	//   工房,   ,   ,
  { {0xf4c3a009,0xfb7c5008,0xfb501005,0xf910d005}},	//   合部, 射程, 地笑, 数可
  { {0xf944b007,0xfa5f8004,0xf81fe004,0xfa816005}},	//   名品, 布新, 情信, 面正
  { {0xf931f004,0xf9267005,0xf829c00a,0xf921d005}},	//   定合, 在分, 野中, 院出
  { {0xf92f3004,0xfa7c2004,0xfb71d00c,0xfb6f900c}},	//   外学, 度排, 且由, 委租
  { {0xf82c6009,0xfb49b007,0xfa732008,0xfa5c0001}},	//   号令, 然生, 便性, 要業
  { {0xf935700f,0xf80de007,0xf9135001,0xf9415001}},	//   通報, 著一, 共危, 均字
  { {0xf9303004,0xfb58b001,0xfa686008,0xf91c300a}},	//   何做, 書線, 題沸, 大将
  { {0xfb63700e,0xfa758008,0xfa6e0004,0xf948b004}},	//   目立, 去最, 念活, 而影
  { {0xf4bfe001,0xf59b3001,0xf4a16008,0xfb875001}},	//   分金, 技董, 本龍, 每篇
  { {0xfa87e007,0xfa5b2007,0xf90fd00c,0x00000003}},	//   自有, 要成, 乳庫,
  { {0xf93fd006,0xf4c6c00c,0x00000003,0x00000003}},	// [ff0] 幅度, 克雷,   ,
  { {0xf918f006,0xf9131006,0xf4c9000a,0xfa650005}},	//   去年, 英国, 低限, 手淫
  { {0xf593b007,0xfa52e004,0xf9429001,0xfb5c9004}},	//   料識, 会指, 有志, 警用
  { {0xf591d00b,0xfa872009,0xf92fb008,0xfa70e008}},	//   協議, 在成, 純子, 農水
  { {0xf4b1a00f,0xf5c47009,0xfa638009,0xfa650004}},	//   枕頭, 京西, 守法, 位指
  { {0xf9459004,0xf5a75001,0xf58cb001,0xfa728001}},	//   同品, 和路, 外行, 山活
  { {0xfb579008,0xf92d5004,0xfb5c9004,0xf946d004}},	//   任給, 取切, 学用, 王家
  { {0xf81c6001,0xf49f2001,0xf839000c,0x00000003}},	//   吃一, 面額, 核作,
  { {0xfa718006,0xf9493009,0xfb819004,0xf949500d}},	//   艾滋, 城北, 理社, 住建
  { {0xf9499007,0xf81c8007,0xfa7bc009,0xf8288004}},	//   低利, 各一, 大意, 家三
  { {0xf917300c,0xf492e00c,0xf83ee005,0x00000003}},	//   出原, 己都, 院上,
  { {0xf943b00c,0xfb80700c,0x00000003,0x00000003}},	//   事分, 片片,   ,
  { {0xf912d006,0xf82f8006,0xfa84e004,0xf5967001}},	//   房公, 育信, 京新, 生身
  { {0xf91c1007,0x00000003,0x00000003,0x00000003}},	//   哥哥,   ,   ,
  { {0xf82fa007,0xf825800c,0xf93eb005,0xfa712005}},	//   到付, 再作, 市康, 跳槽
  { {0xf947d006,0xf918b00b,0xf82b6007,0xf812c007}},	//   半年, 主張, 水保, 站下

  { {0xfb6ef001,0xf4c54005,0xf944b005,0xf49cc00a}},	// [1000] 林科, 及食, 型引, 性障
  { {0xf599d009,0xfa4dc001,0xf93f9005,0xf494400a}},	//   枝花, 成書, 但尚, 命館
  { {0xfa68e004,0xfa836005,0xf8090005,0xf9415005}},	//   李源, 中放, 排下, 肉市
  { {0xfb871004,0x00000003,0x00000003,0x00000003}},	//   住的,   ,   ,
  { {0xf9145006,0xf5b6b001,0xfb86b005,0x00000003}},	//   白天, 出者, 福美,
  { {0xfb813006,0xf90f900c,0xfa6f400c,0x00000003}},	//   集群, 女僕, 誰最,
  { {0xf4a5c007,0xfb64d004,0xf8484004,0xfa5d4005}},	//   可避, 斯班, 自住, 寄托
  { {0xf4c58008,0xf5a53004,0xfb4b100a,0x00000003}},	//   二重, 立良, 年筆,
  { {0xfa712005,0x00000003,0x00000003,0x00000003}},	//   地正,   ,   ,
  { {0xf93d1009,0xf946d001,0xfa7c2005,0xf939d005}},	//   的存, 名員, 春来, 梁和
  { {0xfa520004,0xf5aff001,0xfb791004,0xf813e001}},	//   何治, 東行, 秀美, 高下
  { {0xf93e3007,0xfb7c3001,0xfb7cd00c,0xfa718002}},	//   的彩, 需由, 流社, 山溪
  { {0xfa5a6004,0xf9173004,0xf90a3005,0xfb533010}},	//   一排, 出借, 年吉, 追焚
  { {0xf928b00f,0xf9171009,0xf5961005,0xf837c00c}},	//   未分, 人多, 候能, 卸下
  { {0xf4b3a001,0xf9419005,0xfa72600c,0x00000003}},	//   鍛造, 勇在, 政措,
  { {0xfa602001,0xf4b2e008,0xf91ed004,0xf4b88005}},	//   待改, 線香, 院安, 果非
  { {0xf8184009,0xf591b001,0xf58d1001,0xf4bb600c}},	// [1010] 非主, 講者, 間軸, 時送
  { {0xf4a2e006,0xfa8ae00f,0xf9479007,0xf825c009}},	//   扣除, 自殺, 上報, 立交
  { {0xf80a6001,0xfa796005,0x00000003,0x00000003}},	//   間一, 券法,   ,
  { {0xf92bb007,0xf947b001,0xf929100c,0xf58f100c}},	//   我很, 菊島, 全平, 受虐
  { {0xfb693001,0xf933d004,0xf92f7004,0xfa4ae004}},	//   八種, 多得, 得天, 染指
  { {0xf8106007,0xf5bab001,0xfa5b0004,0xf944b001}},	//   託人, 度行, 果更, 計入
  { {0xf912d009,0xf9361007,0xf9301001,0xf944d001}},	//   好各, 香味, 五南, 律含
  { {0xf5bd7004,0xf58d9005,0x00000003,0x00000003}},	//   大跨, 当起,   ,
  { {0xfa896006,0xfa4cc009,0xf9485007,0xfa4d2005}},	//   未成, 体活, 式庫, 向村
  { {0xfb80100e,0xfa4c8004,0xf4a6a001,0xfa6fc00a}},	//   装系, 道正, 部高, 拳法
  { {0xfb59d006,0xfa81a009,0xf91ab004,0xfb537001}},	//   特点, 中成, 伸出, 承登
  { {0xfa60c007,0xf8316004,0xf93f7005,0xfa7dc005}},	//   姆斯, 仿佛, 分四, 大榭
  { {0xfa4ce009,0xf48a8001,0xf929b001,0xf9185001}},	//   体方, 具高, 園分, 旺季
  { {0xfa6fa009,0xf92cd004,0xf842a00c,0xf92ed005}},	//   就把, 当出, 犯下, 策公
  { {0xf4a98009,0xf9471004,0xfa652001,0xfa7ce004}},	//   航道, 二套, 又想, 来新
  { {0xf825c006,0xf93c7005,0xf5aed00a,0x00000003}},	//   事任, 球十, 陵辱,
  { {0xf5a75004,0xf8350005,0xfa4ae00c,0xfa4be005}},	// [1020] 上能, 份主, 子手, 子晚
  { {0xf844e00a,0xf8482005,0x00000003,0x00000003}},	//   助事, 部代,   ,
  { {0xf5a77006,0xf9487009,0xf9449008,0xfa752005}},	//   不能, 每周, 計大, 湾新
  { {0xf91bb004,0xf9313001,0xf4a38008,0xfa82a005}},	//   日宣, 比喻, 浮遊, 本提
  { {0xf82c0001,0xf9391001,0xfb777001,0xf9209005}},	//   具代, 夜店, 食特, 趣内
  { {0xf59ed009,0xf931b004,0x00000003,0x00000003}},	//   的警, 望各,   ,
  { {0xf92e3007,0xf923d008,0xf947100c,0x00000003}},	//   託宅, 微小, 服勤,
  { {0xf8496004,0xf5c07001,0xf8224005,0xf90e300c}},	//   八中, 正要, 万以, 色域
  { {0xf5929006,0xf490a008,0xf9459005,0xfa7b200a}},	//   定要, 新館, 不姑, 日未
  { {0xfa78c006,0xf80f6001,0xf4b24005,0x00000003}},	//   交流, 取人, 些非,
  { {0xfb84d009,0xf9395004,0xf94b1004,0x00000003}},	//   合社, 宜在, 明号,
  { {0xf90f9006,0xfb635004,0xf4ab8001,0xf921f004}},	//   育学, 售等, 罪防, 院常
  { {0xf93b7004,0xf93e1004,0xf93c300c,0xfa4e0005}},	//   一学, 的含, 範守, 金港
  { {0xf819c006,0xf4b18001,0xfb667004,0xfa6b8005}},	//   十三, 力需, 目相, 堵漏
  { {0xf919d009,0xf94a7004,0xfb897001,0xfb4c900c}},	//   入市, 美区, 量系, 場第
  { {0xfa682004,0xfa89a004,0xf919700c,0xfb70100c}},	//   明情, 迫性, 丹堤, 林素
  { {0xf92b9006,0xf5c89004,0xfa53c005,0xf919f005}},	// [1030] 提升, 番茄, 会演, 奥帆
  { {0xf9399007,0xf9117001,0xfa5ca004,0xf5aa7004}},	//   一堆, 地層, 市排, 年行
  { {0xf4c66001,0xfa700001,0xfb76b004,0xfa644005}},	//   友都, 己所, 朝着, 三新
  { {0xfa6a800e,0xf935300d,0x00000003,0x00000003}},	//   破損, 也分,   ,
  { {0xfa79800e,0xfa5b8008,0xf92f700a,0xf913300c}},	//   寸法, 市況, 南太, 就到
  { {0xf9233007,0xf90f7004,0xfb4dd005,0xf4b66010}},	//   港分, 地商, 米等, 九重
  { {0xf8362004,0xfb77f00c,0xfb57f00c,0x00000003}},	//   押人, 作範, 典美,
  { {0xfa4f4001,0xf5c27004,0xfa67a005,0x00000003}},	//   受投, 口臭, 上数,
  { {0xf598f006,0xfa646004,0xf5b2f001,0xf93ef008}},	//   一行, 之源, 失落, 清志
  { {0xf936d007,0xf4a6c005,0xfb4cb005,0x00000003}},	//   郝市, 早部, 朴素,
  { {0xfa4f4001,0xfa784001,0xfa70c001,0xfa71200c}},	//   向東, 此有, 防暴, 輿情
  { {0xf8108009,0xfa86c001,0xf80aa005,0x00000003}},	//   受人, 縮放, 坐上,
  { {0xf9313001,0xf5991005,0xf49b6002,0xf92f5002}},	//   四名, 一胎, 畸零, 裕和
  { {0xf914f001,0xfa5d2004,0xf90fb008,0xf9467005}},	//   值套, 的氛, 進室, 洋地
  { {0xfa876004,0xfa6ec004,0xf9313001,0xfb70d001}},	//   修水, 新昌, 盛名, 著眼
  { {0xfa68a00c,0xfb611005,0x00000003,0x00000003}},	//   其服, 止用,   ,
  { {0xf9455007,0xf59f5001,0xfb7af004,0xfb697004}},	// [1040] 界名, 情表, 要真, 身素
  { {0xf9181004,0xf934b004,0xfb809005,0xf92d1005}},	//   人利, 多学, 粉等, 金土
  { {0xf492800e,0xfa528001,0xf4c10001,0xf9311001}},	//   議長, 多汁, 玉里, 著地
  { {0xfb633004,0xf48d2004,0xf915d00c,0xfb4fb005}},	//   可燃, 洲里, 任官, 英烈
  { {0xfa72000e,0xfa54c004,0xf929d005,0xf491800c}},	//   現時, 会性, 当安, 音防
  { {0xf58c7004,0x00000003,0x00000003,0x00000003}},	//   青花,   ,   ,
  { {0xf90b7004,0xfa66e004,0xf845e004,0x00000003}},	//   件出, 位性, 用低,
  { {0xf4c46004,0xfb5bf001,0xf4b4a00c,0xfb88500d}},	//   不降, 接管, 紙風, 和百
  { {0xf5a1d007,0xf4c20008,0xf498c00c,0xf922d002}},	//   月行, 片面, 方風, 本展
  { {0xfb7d3007,0x00000003,0x00000003,0x00000003}},	//   終端,   ,   ,
  { {0xf921b00f,0xfb711001,0xfa7dc001,0xf944b005}},	//   連動, 動研, 大業, 及内
  { {0xfa818001,0xf5a6f004,0xf937500c,0xf8318005}},	//   搭機, 界著, 作型, 台交
  { {0xf825c00c,0xfa5a2005,0x00000003,0x00000003}},	//   事主, 障方,   ,
  { {0xf58d3006,0xf5923004,0xfb75b001,0xf82aa008}},	//   或者, 多行, 租租, 長保
  { {0xf9287004,0xfa85e001,0x00000003,0x00000003}},	//   在室, 部服,   ,
  { {0xfa7ce009,0xfb4f9007,0xfb6dd008,0xf5b81004}},	//   大成, 山等, 子特, 幻西
  { {0xf93fb006,0xfb87d006,0xf59cf004,0xfb59900c}},	// [1050] 各地, 二章, 的覆, 入美
  { {0xf822000f,0xfb659009,0xf81c0001,0xf93db004}},	//   合一, 用等, 千三, 市学
  { {0xf918f001,0xfa64c001,0xfa844004,0xf9229001}},	//   人建, 版書, 置情, 面具
  { {0xf9397001,0xf91ed004,0xf93cb001,0xf92eb001}},	//   一億, 信宜, 善心, 我去
  { {0xf591b004,0xf838e00c,0xfb877005,0xf5a5500a}},	//   力考, 典作, 名社, 計課
  { {0xf93dd004,0x00000003,0x00000003,0x00000003}},	//   市古,   ,   ,
  { {0xfa878007,0xf931f004,0xf49aa008,0xf823200c}},	//   利浦, 五号, 秦運, 友介
  { {0xf4b28001,0xf93a3004,0xf595b001,0x00000003}},	//   定門, 要参, 領航,
  { {0xf8288004,0xf930f004,0xf91e7001,0xf9383005}},	//   件上, 力合, 造字, 作存
  { {0xfa530004,0xf4944004,0xf9317005,0x00000003}},	//   引水, 格高, 受年,
  { {0xf836400f,0xf4ac0009,0x00000003,0x00000003}},	//   活休, 提速,   ,
  { {0xf815a004,0xf9379004,0xf93e9005,0x00000003}},	//   食作, 食宿, 商前,
  { {0xf91a3001,0xfb7c3005,0xf8356005,0xf4bf200c}},	//   方史, 一米, 国使, 胃酸
  { {0xf59b3006,0xfa738009,0xf9353005,0xfa73e005}},	//   市行, 能搜, 期各, 松散
  { {0xf93d7009,0xf5c0f008,0xfa5ca001,0xfa6fc008}},	//   内完, 条西, 約所, 防接
  { {0xfa616001,0xf5a75004,0xfb5fb008,0xfa6e6005}},	//   爆殺, 量超, 院理, 乳汁
  { {0xf81cc00f,0xfa79000f,0xfb51d008,0x00000003}},	// [1060] 持人, 決方, 新百,
  { {0xf945b00f,0xf92e300f,0xfa65c004,0xfb7c3001}},	//   事室, 店商, 事来, 胃癌
  { {0xfa6d2007,0xfa724005,0x00000003,0x00000003}},	//   更方, 地数,   ,
  { {0xf83c0009,0xf9481009,0xf935d001,0xfa79a00a}},	//   以任, 序幕, 務役, 古民
  { {0xfa4d6009,0xf941d005,0x00000003,0x00000003}},	//   他文, 嘉定,   ,
  { {0xfb6f700c,0xfb84500a,0xfa55600d,0xf80bc010}},	//   挑細, 計監, 域文, 村俊
  { {0xfa5b2006,0xf915d004,0xf9405001,0xfa4cc004}},	//   要提, 区合, 均分, 染性
  { {0xfa662007,0xf8384008,0xf8272001,0xf912f004}},	//   手書, 治乳, 積人, 精子
  { {0xfa67a009,0xf4b38001,0xfa666005,0xf932b00c}},	//   上新, 定金, 名普, 多億
  { {0xf92d9001,0xfa644005,0xf91bf00c,0xfb70b005}},	//   間地, 前按, 工健, 洗礼
  { {0xfa872009,0xfa6ac004,0xf9275005,0xfb7d300c}},	//   在提, 年流, 在引, 旅等
  { {0xf5ae1007,0xfb5e3007,0xf939d004,0xfb7d3004}},	//   平行, 控管, 封免, 病等
  { {0xfa5a8001,0xf8324005,0x00000003,0x00000003}},	//   企指, 百余,   ,
  { {0xfb6f9008,0xfa5d800a,0xf919f005,0xf8344005}},	//   策特, 内服, 券公, 汽修
  { {0xf9181006,0xf9087009,0xfa5fc007,0xf83a800c}},	//   出售, 延安, 者正, 入作
  { {0xf83ea00f,0xf5b19007,0xf824e004,0x00000003}},	//   次付, 石英, 不久,
  { {0xfa522009,0xf9113004,0x00000003,0x00000003}},	// [1070] 何方, 西分,   ,
  { {0xfa6fe00e,0xfb757004,0xfa82c010,0x00000003}},	//   新機, 多米, 中条,
  { {0xf90b5009,0xf936b001,0xf5c21001,0xfb57b005}},	//   年多, 拘役, 業自, 相看
  { {0xfa81c006,0xf842000f,0xf8270009,0xf918b009}},	//   中毒, 客人, 不以, 赤壁
  { {0xf93df004,0xf90d1001,0x00000003,0x00000003}},	//   它在, 起家,   ,
  { {0xf8362001,0xf90ff005,0xf93d3005,0xfb7ed005}},	//   空下, 到孟, 要影, 黄素
  { {0xf941f009,0xf8492007,0xf9263009,0xf5a51004}},	//   理地, 質保, 部参, 前茅
  { {0xf9113006,0xf927d00b,0xf9137004,0xf80c6005}},	//   害国, 用可, 追回, 化三
  { {0xfb7c900e,0x00000003,0x00000003,0x00000003}},	//   較的,   ,   ,
  { {0xf4bda007,0xf917f004,0xf919300a,0xfb691005}},	//   的餐, 区周, 令官, 在石
  { {0xf9457001,0x00000003,0x00000003,0x00000003}},	//   行完,   ,   ,
  { {0xfb84d004,0xf9453004,0xfa7d8004,0xf4b2a001}},	//   宋祖, 牌坊, 瓦房, 驚魂
  { {0xfa7be004,0xfa7a0004,0x00000003,0x00000003}},	//   性意, 除或,   ,
  { {0xfa862005,0x00000003,0x00000003,0x00000003}},	//   目性,   ,   ,
  { {0xfb531007,0xf5ab3008,0xf4b04001,0xf90e9008}},	//   失申, 家財, 袖長, 進展
  { {0xf4baa00b,0xfa618009,0xf59ed00d,0x00000003}},	//   要領, 豆油, 的触,
  { {0xf5a05001,0xf9259004,0xfb6ff001,0xf910b005}},	// [1080] 分袖, 器安, 引爆, 台在
  { {0xfb58f006,0xf48c2004,0xf818e005,0xfb78d005}},	//   交的, 零零, 局二, 局立
  { {0xfb749007,0xf9359007,0xf5a27007,0xfa792004}},	//   務研, 回名, 版者, 日消
  { {0xf947500f,0xf9339001,0xfa6f0001,0xf5a3b004}},	//   完全, 折合, 細明, 袋装
  { {0xfb51f007,0xf932f008,0xf83cc004,0xf9119004}},	//   報第, 幕張, 武侯, 百名
  { {0xfb679004,0x00000003,0x00000003,0x00000003}},	//   用火,   ,   ,
  { {0xfb4b901b,0xfa4c200c,0x00000003,0x00000003}},	//   刷用, 金氏,   ,
  { {0xf9481004,0x00000003,0x00000003,0x00000003}},	//   二室,   ,   ,
  { {0xfa6be00f,0xf8456009,0xfa68000c,0xf841c00c}},	//   職業, 是主, 位水, 馬丁
  { {0xf945d006,0xf92e9004,0xf90e3004,0xf80d8004}},	//   立健, 他利, 佳宏, 北三
  { {0xf9445008,0xfb6fb00c,0xf93b300a,0x00000003}},	//   旋回, 五科, 門員,
  { {0xf821a004,0xfb79b004,0xf93f300c,0xf9487005}},	//   安丘, 血站, 待審, 明媚
  { {0xf93c3009,0xf93f300c,0x00000003,0x00000003}},	//   心小, 心值,   ,
  { {0xf836600e,0xfa6b000e,0xf48ee001,0xf934d001}},	//   治体, 職成, 味香, 生問
  { {0xf93f9007,0xfb52f004,0x00000003,0x00000003}},	//   考報, 由社,   ,
  { {0xf8482009,0xf827a004,0xfb7c700a,0xf9423005}},	//   表中, 税事, 持管, 蓉姐
  { {0xf4b6e006,0xf8438005,0xfb88100c,0xf912f00d}},	// [1090] 察院, 是供, 虎的, 好分
  { {0xfa81a009,0xfa80e008,0xf4c70004,0xf93f7005}},	//   中提, 季折, 界首, 病可
  { {0xf9375007,0x00000003,0x00000003,0x00000003}},	//   原大,   ,   ,
  { {0xfa724009,0xfb6c5001,0x00000003,0x00000003}},	//   地新, 黑的,   ,
  { {0xf48b0006,0xfb6ab004,0xf59cf004,0xf9293004}},	//   究院, 当理, 要落, 部影
  { {0xfb7d500e,0xf91bd009,0xf48a6001,0xf4aa8004}},	//   射線, 赤峰, 場開, 虫防
  { {0xfb7ff004,0xfa694004,0xfa684005,0xf93b1005}},	//   待群, 明或, 同承, 要少
  { {0xf8204004,0x00000003,0x00000003,0x00000003}},	//   包人,   ,   ,
  { {0xfb7d900b,0xfa858009,0xf4bee001,0xf9473005}},	//   時給, 用效, 必達, 前医
  { {0xfb88700b,0xf5aed004,0xf944500a,0x00000003}},	//   小物, 育自, 葉台,
  { {0xf4b4c009,0xf92f7004,0xf4b2a004,0xf9469004}},	//   土配, 他建, 何防, 行土
  { {0xf9313006,0xfa73a009,0xfb54900e,0xf93a300e}},	//   比去, 好成, 眼科, 紀子
  { {0xf58d3004,0xf8318005,0xfb80100c,0xf90e100c}},	//   道西, 地以, 必確, 練場
  { {0xf9327001,0xf4abc001,0xfb79b00a,0x00000003}},	//   君子, 雪靴, 節症,
  { {0xf48bc006,0xfa71e001,0xf827a00d,0xfa610010}},	//   年限, 議書, 税之, 震源
  { {0xfa5f0006,0xfa582001,0x00000003,0x00000003}},	//   的活, 作教,   ,
  { {0xf4968007,0xfb639004,0xfb6b3004,0xf4910004}},	// [10a0] 人送, 中石, 姓生, 碳酸
  { {0xf4a08009,0xf5b17009,0xf820e009,0xfa5b0001}},	//   口退, 山街, 等不, 賀本
  { {0xf940d001,0xf5965005,0xf92d9005,0x00000003}},	//   者報, 余起, 得名,
  { {0xfa81a004,0x00000003,0x00000003,0x00000003}},	//   郭楞,   ,   ,
  { {0xf81ae009,0xf8132004,0xfa70e004,0x00000003}},	//   持会, 料一, 新本,
  { {0xf9281004,0xf8214004,0xf58b9004,0xfa6c2004}},	//   利国, 奇世, 子装, 晶晶
  { {0xf90c5009,0xfb81900c,0x00000003,0x00000003}},	//   年利, 理精,   ,
  { {0xfb513009,0xf944d001,0xfb633002,0x00000003}},	//   板的, 車商, 枯的,
  { {0xf9453004,0xfa708004,0xfa50e004,0xf91cf004}},	//   合地, 平淡, 柔性, 浦口
  { {0xf593900f,0xf9441007,0xf48c800e,0xfb647008}},	//   辛苦, 母守, 練馬, 目線
  { {0xf9435004,0xf5a51001,0xf4a1600c,0xf92cf005}},	//   三学, 前者, 業障, 金川
  { {0xfb799004,0xfa738008,0xf943100c,0x00000003}},	//   刀片, 施機, 假山,
  { {0xfb833001,0xfa4b400c,0x00000003,0x00000003}},	//   秋美, 間感,   ,
  { {0xf82b8007,0xf9469009,0xf90f9004,0xf82a6004}},	//   究人, 行域, 地勘, 更低
  { {0xf913700b,0xfb58100f,0xf9237004,0xf5b3500c}},	//   現在, 系精, 是存, 值而
  { {0xfb6ad005,0x00000003,0x00000003,0x00000003}},	//   易爆,   ,   ,
  { {0xf5b2d008,0xfb799008,0x00000003,0x00000003}},	// [10b0] 失調, 況等,   ,
  { {0xf5a09001,0xf922f00a,0x00000003,0x00000003}},	//   者能, 本列,   ,
  { {0xf921d00f,0xf5bb9004,0xf92ed005,0xf922b00d}},	//   業動, 大而, 近尾, 良和
  { {0xfa684007,0xfa70c00e,0xf945d004,0xf8362004}},	//   後方, 新潮, 上得, 出不
  { {0xfa5d6009,0xfb5c1001,0xf9147005,0xfa73400a}},	//   威海, 座的, 国唯, 廿日
  { {0xf945f006,0xfa616008,0xf9275004,0xfb521004}},	//   不得, 了日, 天左, 松的
  { {0xfa6fc009,0xf5a0d001,0xfa704004,0xf921d005}},	//   新思, 三行, 想是, 中展
  { {0xfa63a006,0xf90d3009,0xf5b6d001,0xf5a83005}},	//   事故, 年建, 曼谷, 小苗
  { {0xfb7af009,0xfb4a1008,0xf94b5008,0xfb7c5001}},	//   要生, 更等, 税制, 胃美
  { {0xfa7b2007,0xf9367007,0xfa5da008,0xf81e4004}},	//   令查, 依序, 清流, 的亮
  { {0xf9183009,0xfa4d6009,0xfa688005,0x00000003}},	//   交叉, 他指, 凶手,
  { {0xf9387008,0xfa66c002,0xf9473002,0x00000003}},	//   語句, 半斤, 才去,
  { {0xf8228007,0xf5bcb001,0x00000003,0x00000003}},	//   有五, 知足,   ,
  { {0xfb5ab007,0xfa516004,0xf4b4c00c,0xf5cb3005}},	//   券特, 南段, 期重, 未落
  { {0xfb6cf009,0xfa6b6004,0xfa77c001,0xf5c69010}},	//   科生, 低水, 基湖, 早苗
  { {0xf9277009,0xf90b8005,0xfb6cf005,0xfb5b100a}},	//   温室, 件基, 取私, 室照
  { {0xfb825009,0xf49f4007,0xf942b004,0xf48b0005}},	// [10c0] 爆破, 管道, 安在, 号金
  { {0xf83ee007,0xfb7bd004,0xf82f000d,0x00000003}},	//   蔡依, 局相, 声不,
  { {0xfb4af006,0xf9413007,0xf81b0004,0xfb8b3005}},	//   年的, 震動, 所中, 美男
  { {0xf8230004,0xf93e900d,0xfa6a6010,0x00000003}},	//   等中, 如山, 野智,
  { {0xf9239009,0xfa664007,0xf9353001,0xf93a1004}},	//   是做, 重挫, 真善, 障基
  { {0xfa64a00e,0xfa7e8008,0xfa7b2008,0x00000003}},	//   不況, 信教, 若林,
  { {0xf5921006,0xfa7ce009,0xf941f004,0xfb82d005}},	//   通行, 大提, 光宝, 万米
  { {0xfa7c0009,0xf91c5004,0xfa5de001,0xfa5a4004}},	//   以查, 性分, 狂殺, 秀成
  { {0xf930500f,0xf4908006,0xf9431005,0xf9293005}},	//   動力, 英雄, 文印, 部山
  { {0xf93b700b,0xfa7e6009,0xf5c45008,0xf9399005}},	//   一度, 加投, 本調, 一帆
  { {0xf91f5006,0xf9187004,0xfa798001,0xf8236001}},	//   形式, 出加, 工所, 月五
  { {0xf81bc00f,0xfa6ba001,0xf943700c,0x00000003}},	//   言人, 買本, 有度,
  { {0xfa5ae006,0xf83a8007,0xf8126005,0xfb86500c}},	//   流感, 司令, 定住, 小玉
  { {0xf83fa007,0xfb4bf00c,0x00000003,0x00000003}},	//   加人, 混紡,   ,
  { {0xf59e3006,0xf9459004,0xfa85c00c,0xf5af900c}},	//   内蒙, 下学, 全手, 議者
  { {0xfb767006,0xf9487001,0xf9197004,0xfb85900c}},	//   食用, 明定, 点学, 不瞑
  { {0xf945f00f,0xfa7a0009,0xfa53e005,0xfa658005}},	// [10d0] 律常, 方施, 望春, 行操
  { {0xf9415001,0xf4c3e004,0xfa780005,0x00000003}},	//   三億, 克隆, 出温,
  { {0xfa7d0009,0xf9109009,0xf947d004,0xfa730008}},	//   性成, 阿克, 名地, 西条
  { {0xf844e00e,0xf48ec004,0xf5a8900a,0xfb6cb00c}},	//   本件, 曲靖, 像表, 金紙
  { {0xf941d007,0xf5959009,0xf9477009,0xf5c49001}},	//   先後, 婚育, 式多, 息表
  { {0xfb5ed004,0xfb583004,0xf818e001,0xf8384005}},	//   大石, 室版, 所位, 出中
  { {0xf945f005,0xf9355005,0xf92b7005,0x00000003}},	//   双待, 土分, 材商,
  { {0xf9355007,0xf93f1009,0xf8256004,0xfa5c0001}},	//   期分, 的固, 位也, 的月
  { {0xf81e8009,0xf9355004,0xf5963001,0xfa67e008}},	//   了上, 真分, 舞者, 車整
  { {0xfa7f000f,0xf9445004,0xfa6a8004,0xfa7f800c}},	//   造業, 月度, 美方, 映日
  { {0xf945b00b,0xf5a31004,0xfa5c8008,0xfb4ad005}},	//   立大, 下行, 各所, 具生
  { {0xf9451009,0xf9193007,0xf81f8001,0xfa714002}},	//   昌吉, 春安, 集保, 響情
  { {0xfa898009,0xfb50f001,0xf92d3004,0xf924100c}},	//   雨水, 報生, 外各, 港展
  { {0xfb6f5004,0xf81ca005,0x00000003,0x00000003}},	//   化知, 威人,   ,
  { {0xfb769006,0xfb691009,0xfa748004,0xf934b00a}},	//   川省, 在申, 施本, 多度
  { {0xfb657007,0xf5be5004,0x00000003,0x00000003}},	//   可知, 次考,   ,
  { {0xf946b006,0xfa6b4007,0xf948b004,0xf90ff004}},	// [10e0] 上学, 低收, 同地, 平利
  { {0xf9461004,0xf4be4001,0x00000003,0x00000003}},	//   伊利, 約風,   ,
  { {0xfa606009,0xfb59f004,0xf8430004,0xfb827001}},	//   商注, 方百, 本世, 築研
  { {0xf922b007,0xfa862004,0xfa674004,0xfa754005}},	//   公寓, 天成, 式文, 国方
  { {0xf8360004,0xf941b004,0xf4938005,0xf942b00d}},	//   区介, 守合, 尾部, 守候
  { {0xf5bb9004,0xfa718005,0xf823000c,0x00000003}},	//   大背, 山洪, 立事,
  { {0xf4976009,0xfb7e1004,0x00000003,0x00000003}},	//   区金, 求相,   ,
  { {0xf490e00b,0xfa5c4004,0xfb6ff004,0xf4ac8004}},	//   共通, 一曲, 何理, 金黄
  { {0xfb6f500f,0xfa680009,0xf92c9009,0xf8362004}},	//   暖空, 二氧, 村商, 出位
  { {0xfa894001,0xf9185004,0xf817800a,0xf5c9f00c}},	//   含本, 除名, 喜一, 火蟻
  { {0xf9137008,0xf80b7004,0xf91f9004,0x00000003}},	//   国府, 寒亭, 映出,
  { {0xf91d1001,0xf592f008,0xfa5c600c,0xfb823002}},	//   大展, 定資, 球技, 指管
  { {0xf5a43009,0x00000003,0x00000003,0x00000003}},	//   上行,   ,   ,
  { {0xf5b0d008,0xfa698005,0xfa4f6005,0xfb80f005}},	//   飲茶, 刷有, 北林, 毅然
  { {0xf81e4009,0xf9379004,0xf944b004,0xf5b35004}},	//   的修, 凝土, 按年, 落脚
  { {0xfa4fe004,0xf93a9005,0xfb5fb005,0x00000003}},	//   底清, 一宗, 溢的,
  { {0xf9249009,0xf594b004,0x00000003,0x00000003}},	// [10f0] 公害, 速行,   ,
  { {0xfa578001,0xfb86500c,0xf5bcd005,0x00000003}},	//   高海, 事申, 春花,
  { {0xf93a3006,0xfa5a4006,0xf4b10004,0xf8322005}},	//   作出, 作方, 剔除, 份上
  { {0xf80c1007,0xf4b2a008,0xf8360004,0xfa5da001}},	//   我不, 供達, 区事, 情描
  { {0xf5beb004,0xf922b00c,0xf4a84002,0x00000003}},	//   大落, 索家, 太重,
  { {0xf593d007,0xf932f004,0xf913b001,0x00000003}},	//   膚質, 会官, 宿命,
  { {0xfa6d4008,0x00000003,0x00000003,0x00000003}},	//   水樹,   ,   ,
  { {0xfb67b004,0xf912f001,0xf5c2d004,0xfa62000c}},	//   利系, 政宣, 枯萎, 光果
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa5e2001,0xf90b4005,0xf939b005,0x00000003}},	//   的木, 援四, 犁哈,
  { {0xf820a004,0xf9123004,0xfb6cd00a,0x00000003}},	//   争上, 田地, 子用,
  { {0xfa65c009,0xfa4b2004,0xf9285005,0xfb66700c}},	//   事日, 桐柏, 早地, 置空
  { {0xf58f100e,0xf92bf009,0xf9135004,0xfa59600a}},	//   化財, 当天, 社北, 一掃
  { {0xfa68c006,0xf826c008,0xf9177005,0x00000003}},	//   藏本, 坊主, 出当,
  { {0xfb84b005,0xfa5ea005,0xfb6af00a,0x00000003}},	//   弊的, 清源, 結納,
  { {0xf4b8e007,0xf49ea00a,0xfa52600c,0x00000003}},	//   最重, 校高, 通流,
  { {0xfb711007,0xf4c7800a,0xf926900c,0xf58bf00a}},	// [1100] 比照, 反響, 推升, 結膜
  { {0xf4c5c00a,0xfa89e005,0x00000003,0x00000003}},	//   洋電, 罪或,   ,
  { {0xf93fb00f,0xf8202004,0x00000003,0x00000003}},	//   情形, 者以,   ,
  { {0xf4bfe004,0xf9351004,0xf5a21005,0xf82d000c}},	//   了非, 感市, 了花, 史事
  { {0xf938f007,0xfa87c004,0xfa51e005,0xf837e00c}},	//   聞報, 虫情, 会授, 示他
  { {0xf4c1800e,0xf48ac001,0xf9395008,0xfa4c8005}},	//   文部, 年送, 最善, 休教
  { {0xf8354005,0x00000003,0x00000003,0x00000003}},	//   活一,   ,   ,
  { {0xf944b00c,0xf91b1005,0xf93d500c,0xf840200c}},	//   上億, 健字, 必前, 校代
  { {0xf9453001,0xf947f004,0xf80b700a,0xf92b1005}},	//   位博, 偏少, 寒中, 易博
  { {0xfa626009,0xf9405004,0xf9151001,0xf4aca005}},	//   了更, 了北, 死後, 金集
  { {0xf8174001,0x00000003,0x00000003,0x00000003}},	//   依依,   ,   ,
  { {0xf92e5006,0xf82fc010,0x00000003,0x00000003}},	//   湖北, 許事,   ,
  { {0xf9135004,0xf93c3005,0xfa69a005,0xfb5ad002}},	//   由地, 桃城, 海明, 甸社
  { {0xfa574009,0xfb60d004,0xf94a9001,0xfb87b00c}},	//   域性, 口病, 美幸, 半究
  { {0xfa78e005,0xf844a005,0x00000003,0x00000003}},	//   建日, 目也,   ,
  { {0xfa6a0004,0xf815a001,0xf946b004,0xfb50b00c}},	//   夏新, 站人, 量同, 平盤
  { {0xfa55c007,0x00000003,0x00000003,0x00000003}},	// [1110] 生機,   ,   ,
  { {0xf83dc009,0xf92df007,0xf8360008,0xf5939001}},	//   加会, 栗市, 区下, 甘草
  { {0xfb7f5009,0xfa71c00e,0xf9104005,0x00000003}},	//   善社, 議決, 害公,
  { {0xfa6ce00e,0xfa636008,0xf934f004,0xf92c5005}},	//   年次, 下流, 会区, 化先
  { {0xf5a21005,0xf93cd005,0xfa4be00c,0xfa81800c}},	//   了英, 市宗, 我朋, 連成
  { {0xf9227007,0xfa834004,0xfb747001,0xf80e3005}},	//   可先, 是旅, 默的, 我中
  { {0xf81d600e,0xf59c5004,0xf9293001,0xf49ae004}},	//   要件, 持解, 用到, 知青
  { {0xf59f3006,0xf5aed009,0xfa82a004,0xf916d00d}},	//   病虫, 地行, 院扶, 格就
  { {0xf49a4004,0xf80c7004,0xf4a0c001,0xf915b00c}},	//   入高, 取三, 無遺, 主商
  { {0xfb747004,0xf9121004,0xfb80700c,0xf832a00a}},	//   付的, 估值, 切片, 話人
  { {0xfa5b6006,0xfa6b2007,0xf5901001,0xf4be6005}},	//   一次, 職棒, 動者, 清障
  { {0xf5a97001,0xf93e1001,0xf93c100c,0xfb6b700a}},	//   海芋, 的叫, 局呼, 限理
  { {0xf4c2e005,0x00000003,0x00000003,0x00000003}},	//   率都,   ,   ,
  { {0xf93ed009,0xf58c7004,0xf944b001,0xf818a005}},	//   考勤, 尖草, 程委, 着上
  { {0xf93a9007,0xf9485004,0xfa5d6001,0xf9385008}},	//   一字, 每只, 球村, 語大
  { {0xf921f004,0xf943b010,0x00000003,0x00000003}},	//   中列, 請必,   ,
  { {0xfa726001,0xfa72c008,0xfa4e2005,0x00000003}},	// [1120] 東校, 精機, 演愈,
  { {0xf9417007,0xf5971004,0x00000003,0x00000003}},	//   有各, 功臣,   ,
  { {0xf84a0004,0xfb5cb005,0x00000003,0x00000003}},	//   迫使, 池等,   ,
  { {0xf946b006,0xfb6dd00f,0xfa666001,0xf910c004}},	//   型号, 科目, 同感, 想学
  { {0xfb871006,0xfb515008,0xf932f005,0xf4be0005}},	//   式的, 便秘, 会存, 内黄
  { {0xfa64800e,0xfa7ea009,0xfb74d004,0xf914f005}},	//   上流, 因您, 感美, 放地
  { {0xf9451005,0xfa594005,0xfa50e00a,0xfa80800c}},	//   位存, 作暨, 底比, 業意
  { {0xfa888007,0xfb60b004,0xf93e3001,0xfb645001}},	//   溪流, 次点, 毅力, 種病
  { {0xf58a3001,0xf8176005,0xf917d00d,0x00000003}},	//   道行, 期主, 券和,
  { {0xf8478009,0xf925900c,0x00000003,0x00000003}},	//   在世, 種全,   ,
  { {0xfb4fd006,0xf4c90007,0xf48be001,0x00000003}},	//   防空, 行長, 穴道,
  { {0xf90fc001,0xfa6de001,0xfa7d200c,0xf59cf00c}},	//   東光, 梳棉, 度校, 的豆
  { {0xf93b7001,0xf931300c,0xfa5c400d,0x00000003}},	//   丁字, 四倍, 私条,
  { {0xfb4a9001,0xf8428004,0xfa4f0005,0x00000003}},	//   其目, 是今, 金湾,
  { {0xf829c004,0x00000003,0x00000003,0x00000003}},	//   海一,   ,   ,
  { {0xfa54a006,0xfb87f007,0xf5a87001,0xf9135005}},	//   多次, 牌照, 而能, 共山
  { {0xfb56700e,0xf8158004,0xfb74d005,0x00000003}},	// [1130] 活習, 期供, 力状,
  { {0xf5aa5007,0xf8240009,0xf821e009,0xf834e004}},	//   側背, 床上, 片中, 都信
  { {0xf4c0e00f,0xfa620007,0x00000003,0x00000003}},	//   分離, 合所,   ,
  { {0xfa66a001,0xf82e2008,0xf9249008,0xfa574005}},	//   再搭, 右下, 華全, 也日
  { {0xf9141009,0xf90de001,0xfa4de005,0xfa4d4010}},	//   能得, 水地, 民本, 逐次
  { {0xf5a5500f,0xf90ee001,0xf8242004,0xf4a06001}},	//   行車, 到完, 届二, 業配
  { {0xf846c00e,0xf4a70004,0xfa610005,0xf4b4c00a}},	//   用保, 在非, 假材, 原題
  { {0xf5bf700f,0xf8152009,0xfa844004,0x00000003}},	//   信託, 会使, 屯溪,
  { {0xfa5da001,0xf931700d,0x00000003,0x00000003}},	//   情意, 君威,   ,
  { {0xfa872009,0xf9495004,0xf80d5001,0xf9257001}},	//   木材, 住区, 子代, 湯券
  { {0xf825000f,0xfa7aa001,0xf491e001,0x00000003}},	//   益保, 書方, 音鈴,
  { {0xf947b004,0xf943d001,0xfa7aa00a,0x00000003}},	//   名已, 型商, 相方,
  { {0xf9277006,0xfa67e004,0xfa618001,0xf4acc002}},	//   在北, 倍数, 分書, 外重
  { {0xfb759001,0xfa576004,0x00000003,0x00000003}},	//   增益, 期来,   ,
  { {0xf946300e,0x00000003,0x00000003,0x00000003}},	//   完備,   ,   ,
  { {0xfb747009,0xf9136004,0xfb51b001,0x00000003}},	//   生等, 共就, 誰知,
  { {0xf82b8004,0xfb5f1001,0xf93ab005,0xf5b57005}},	// [1140] 德修, 無生, 喜地, 好落
  { {0xfb84f007,0xf4a16007,0xfa65a004,0xf5bcd00c}},	//   屋物, 本額, 看次, 造而
  { {0xf9499004,0xfb601001,0x00000003,0x00000003}},	//   小尾, 止痛,   ,
  { {0xf840c004,0xf93cd00a,0xfa56c005,0x00000003}},	//   炭企, 市字, 生本,
  { {0xf9483009,0xfa5dc00e,0xf92c1007,0xf599f001}},	//   序列, 清掃, 金城, 送行
  { {0xf9427009,0xfb879005,0xf5ad900a,0xf936100c}},	//   涉外, 上由, 年製, 賞心
  { {0xfa584008,0xf9167005,0xf823400a,0xf5af9005}},	//   非接, 出如, 手不, 械装
  { {0xfa588004,0xf939d004,0xf910000a,0x00000003}},	//   搜救, 豁免, 英和,
  { {0xf49a800e,0xfa850004,0xf9257004,0xf4ba0005}},	//   特長, 央提, 是出, 着非
  { {0xf9311001,0xfb82b008,0xf5a49004,0xf4c44005}},	//   力及, 文社, 殊要, 事非
  { {0xf936700b,0xf49b6009,0xfb711009,0xf9124001}},	//   機器, 武隆, 牛羊, 山坡
  { {0xf5a5d006,0xf497a00f,0xfa67c009,0xfb5a1001}},	//   反腐, 空間, 倍液, 查理
  { {0xfa5e8009,0xf928f009,0xf5a93001,0xfb68d004}},	//   七次, 身利, 家考, 截留
  { {0xfb5ef00b,0xf9277009,0xfa7fe00a,0xfb6d100a}},	//   大統, 在南, 形文, 打点
  { {0xfa5fc006,0xfb7e1001,0xfa5b600c,0xf937300c}},	//   文明, 魂特, 一校, 果屋
  { {0xfb67100f,0xf847c007,0xfa586004,0xfb53b00c}},	//   差異, 助人, 域水, 尾端
  { {0xfa87e006,0xf842000e,0xfa6f2009,0xf4aa0009}},	// [1150] 您是, 中世, 地流, 硫酸
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf93c900c,0xf93b9005,0x00000003,0x00000003}},	//   吃吃, 堂堂,   ,
  { {0xf93c3001,0xfa860005,0xfb55100a,0x00000003}},	//   門地, 部每, 電王,
  { {0xf92f7005,0xf91c1005,0x00000003,0x00000003}},	//   北太, 大庄,   ,
  { {0xf848400f,0xf81c0009,0xfa4a0004,0xfa5ce008}},	//   哪一, 参会, 卓有, 心掛
  { {0xf90a600b,0xfa616001,0xfb58d004,0xfa70600c}},	//   年始, 升旗, 船用, 政消
  { {0xfb847007,0xfb7a100c,0xf9409005,0xf8266005}},	//   型科, 作群, 充好, 序上
  { {0xfa54e006,0xf5aab001,0xf9439001,0xf4b7e005}},	//   会治, 怎能, 玉大, 潜逃
  { {0xf8248009,0xf80b1004,0xf493e001,0xf90fc005}},	//   前不, 当保, 社頭, 地多
  { {0xfa872009,0xf8428009,0xf5ab3004,0xf5b6b001}},	//   在某, 是上, 低迷, 出超
  { {0xf5b2f001,0x00000003,0x00000003,0x00000003}},	//   失能,   ,   ,
  { {0xfa64a009,0xf4a10001,0xfb50f001,0xf5b9d00c}},	//   名所, 員都, 音空, 別要
  { {0xfa56c00f,0xf929d009,0xf4a18004,0xf810b004}},	//   賞期, 身建, 中非, 比中
  { {0xf921f00f,0xfb76b00c,0xf946500c,0x00000003}},	//   本商, 托特, 洋史,
  { {0xf942f009,0xfb67b001,0xf93b1005,0xf814f005}},	//   等公, 物登, 局六, 高会
  { {0xfb5c700e,0xfb83f001,0xf9263005,0x00000003}},	// [1160] 日現, 熊熊, 差大,
  { {0xf842e004,0xfa88e004,0xfa772004,0xfb4ad005}},	//   口交, 您找, 移支, 朴的
  { {0xf8392006,0xf4c62009,0xf9150005,0x00000003}},	//   以上, 行集, 能学,
  { {0xfa4c6005,0xfb4d700c,0x00000003,0x00000003}},	//   提法, 水精,   ,
  { {0xfa516008,0xfa71400c,0xf5967005,0xf4bde00a}},	//   南極, 放消, 生被, 終電
  { {0xf8093009,0xf936b004,0xfa4b000c,0xfb5af002}},	//   拒不, 生可, 子服, 浦省
  { {0xf4b52006,0xf4c2000c,0xf5c5d005,0xfa5ea005}},	//   高速, 切面, 在萌, 市泰
  { {0xfb77f007,0xf5a7d001,0xfa7fa001,0xf595b004}},	//   土石, 位買, 因改, 神行
  { {0xfa64600b,0xfb679006,0xf8256009,0x00000003}},	//   構成, 身的, 手中,
  { {0xf947b006,0xf92e700e,0xfa8a2004,0xfa846005}},	//   及其, 化器, 浪潮, 是湖
  { {0xf93a3009,0xfa658004,0xfa4ba004,0xfa71600a}},	//   作基, 同所, 源文, 陰性
  { {0xfb707004,0xfa82c001,0xfa4f800d,0xfb52100d}},	//   得相, 路技, 村扶, 灰石
  { {0xf59f3001,0xfb679001,0xfa62a008,0xfb523004}},	//   分者, 庫的, 文房, 白玉
  { {0xfa650001,0xf81fa004,0x00000003,0x00000003}},	//   位教, 率下,   ,
  { {0xf939500b,0xfb5d900e,0xfa7a0009,0xfa508007}},	//   最寄, 信等, 知情, 算書
  { {0xf9227009,0xf4962007,0xfa662004,0xfb5b3001}},	//   是安, 活食, 反洗, 室系
  { {0xf9439009,0xfa504004,0xf592f00c,0x00000003}},	// [1170] 予受, 他收, 紙規,
  { {0xf92b1009,0xf920f007,0xf93e1009,0xf93c1005}},	//   互利, 業分, 的八, 的奉
  { {0xf933b009,0xf9375004,0xf4a60004,0xf81c4008}},	//   做得, 州外, 是防, 雄二
  { {0xf91fd004,0xfb767004,0xf48ee001,0xf5c7700c}},	//   握在, 生火, 甲骨, 用著
  { {0xfa5c2007,0xfa842001,0xfa4f2005,0xf5c15005}},	//   要正, 可打, 何把, 次走
  { {0xfb76300f,0xf91ad004,0xf93fd008,0xf929500a}},	//   初版, 学城, 理子, 習問
  { {0xf90ba007,0xf8272004,0xfa630004,0xf83f2004}},	//   念品, 倍以, 合村, 大件
  { {0xf90de001,0xf9311004,0xf5abd001,0xf4a56004}},	//   場報, 柔区, 段考, 置首
  { {0xfa882004,0xf937f004,0xf937700a,0x00000003}},	//   在正, 洞口, 語化,
  { {0xf924b006,0xf9363005,0x00000003,0x00000003}},	//   公共, 沙地,   ,
  { {0xfb629006,0xfb83500e,0xf49ca009,0xf58bb001}},	//   本科, 下着, 以防, 少見
  { {0xf826a00e,0xfa66a004,0xf83aa004,0xf91a5001}},	//   前中, 不扣, 壤中, 改地
  { {0xfa81a007,0xf9363001,0xf826a005,0xf9257005}},	//   業成, 非商, 才中, 是固
  { {0xf9479009,0xf92f700e,0xf59d7004,0xfa5a4001}},	//   前国, 殖医, 者行, 送流
  { {0xf5b13008,0xfb5b9001,0xf59cd004,0xf4b4e00c}},	//   乳製, 入第, 的薄, 原野
  { {0xfb83100f,0xf90dc00f,0xfb68b001,0xf920b004}},	//   指甲, 直到, 溪的, 解密
  { {0xfa60c009,0xf82be00c,0x00000003,0x00000003}},	// [1180] 等手, 起你,   ,
  { {0xf9373006,0xfb52f009,0xf4b5c004,0xf93d9004}},	//   速度, 社科, 也非, 内城
  { {0xf4a56004,0xfa76c004,0xf90d200c,0xfa5b000d}},	//   售部, 特拉, 長地, 府扶
  { {0xfb55b001,0xfa7d6004,0xfa84c004,0xf830e005}},	//   任理, 映情, 物有, 到伯
  { {0xf931300f,0xf9287006,0xfa85800e,0xf90ec004}},	//   演出, 巨大, 用案, 台及
  { {0xf83d4004,0xfb827001,0xfa53200c,0xf839000c}},	//   大世, 片系, 料所, 空人
  { {0xfb72d001,0xf9201001,0xfa648001,0xf9445005}},	//   力研, 設合, 越時, 月左
  { {0xfa572008,0xfb4d9004,0xf9160005,0xf941700c}},	//   軟性, 露的, 命家, 有善
  { {0xf9413004,0xfb82b004,0xfa772004,0x00000003}},	//   万字, 崇礼, 治本,
  { {0xf947f006,0xf9134004,0xf9243008,0xf4a42005}},	//   意向, 就地, 港北, 是青
  { {0xfb87b004,0xf9457001,0xfb847008,0xf5b45004}},	//   福生, 行後, 計管, 都表
  { {0xf592d006,0xf5a5900f,0xf5b45007,0xf8278005}},	//   引起, 名詞, 能表, 牌中
  { {0xf9465004,0xfb85f001,0xfb609001,0xf824c001}},	//   告宣, 後約, 次登, 見他
  { {0xf910c006,0xf9333008,0x00000003,0x00000003}},	//   地利, 備局,   ,
  { {0xf8248006,0xf5bb5006,0xf5c55005,0xfa65a00d}},	//   前位, 学者, 助老, 行每
  { {0xf92cd009,0xfa64c001,0xfa724004,0xf9407004}},	//   源利, 友投, 恰恰, 率均
  { {0xf945d00b,0xf9441004,0xfa4f4004,0xf5aff001}},	// [1190] 不動, 伊始, 受法, 想自
  { {0xfb579004,0xfb85d005,0x00000003,0x00000003}},	//   相等, 昌的,   ,
  { {0xfa760009,0xf90dc009,0xfa524008,0xf9405002}},	//   出手, 整地, 法政, 昆士
  { {0xf826000b,0xfa7d0009,0xfa5b8004,0xf845e00a}},	//   友人, 以更, 着急, 助会
  { {0xf4b24001,0xf929b001,0xf9315004,0xf91fd00a}},	//   多重, 未受, 盛夏, 信可
  { {0xf924d00f,0xf922b004,0xfb74f005,0xf916e005}},	//   搬家, 景名, 借着, 呼家
  { {0xf93a900f,0xf9221004,0xfa846008,0xf921f005}},	//   一套, 口在, 潮文, 中受
  { {0xf939d009,0xfa88a009,0xf93bd004,0xf48aa005}},	//   十届, 用油, 十周, 海食
  { {0xfa634006,0xfb4b1001,0xf916200c,0xf91d3005}},	//   三次, 張玉, 人型, 大北
  { {0xf939900f,0xf4be4005,0xf58c9002,0x00000003}},	//   一分, 情高, 我超,
  { {0xf4a80001,0xfa760004,0xf9243008,0xfb61b00c}},	//   木頭, 治思, 港南, 面盤
  { {0xf9209008,0xf9419001,0xfa6a400a,0xf4ae000c}},	//   散布, 有分, 件比, 受邀
  { {0xfa550004,0xf59ef008,0xf9225004,0xf910200a}},	//   会改, 燃費, 班在, 報局
  { {0xf5ab3001,0xf9459004,0xf81c800a,0xf9096005}},	//   德街, 行城, 元企, 康安
  { {0xfb7c700f,0xf941700e,0xf92cf004,0xfb62b001}},	//   億美, 率化, 成公, 探究
  { {0xf59a1009,0xfa678005,0x00000003,0x00000003}},	//   老虎, 和探,   ,
  { {0xf5a61007,0xfa65a004,0xfb5d900c,0x00000003}},	// [11a0] 見調, 名村, 占率,
  { {0xfb74f00c,0x00000003,0x00000003,0x00000003}},	//   真秀,   ,   ,
  { {0xfb859009,0xfb73f004,0xf9227001,0xfa886008}},	//   程管, 供相, 湯屋, 親族
  { {0xf4a12007,0xf58d3004,0xfa6ec004,0xf5ab300d}},	//   釣魚, 或超, 新歌, 号角
  { {0xfb4eb007,0xfa750008,0xfa6dc00a,0xfa64c00c}},	//   史研, 陽性, 極採, 橋林
  { {0xfa63a006,0xfb833001,0xf5a2d001,0xfb707004}},	//   事情, 克牌, 合菜, 暗示
  { {0xfa89a00c,0xf9237005,0x00000003,0x00000003}},	//   太棒, 括公,   ,
  { {0xfa7d6001,0xfa5c2001,0xfa858005,0xfa87a002}},	//   度春, 的把, 彩文, 漫情
  { {0xf90b000b,0xf946d00f,0xf93d3001,0xf91ff005}},	//   男子, 立場, 要報, 口合
  { {0xf5b83008,0xf59ef00c,0xfa862005,0xfa82e00c}},	//   輸血, 待著, 温材, 湯汁
  { {0xf94a5006,0xf92b9007,0xf8394004,0xf5b4f001}},	//   明建, 質地, 交供, 抽象
  { {0xfb66700f,0xf933d005,0xf80bd00c,0x00000003}},	//   可直, 多套, 道五,
  { {0xf8105009,0xfb865004,0xf4c4e010,0x00000003}},	//   何保, 之石, 洋館,
  { {0xfb4d1008,0xf5a39004,0xfb655004,0xf91f5008}},	//   却系, 效身, 是群, 絡協
  { {0xfa5d600f,0xf9126004,0xf93dd001,0xf5bc3010}},	//   終止, 新家, 時出, 入費
  { {0xfb83b009,0xfa63e004,0xf90d2001,0xfa5de001}},	//   等特, 先是, 海島, 療方
  { {0xf821c00f,0x00000003,0x00000003,0x00000003}},	// [11b0] 有些,   ,   ,
  { {0xf912c005,0xfa74800c,0x00000003,0x00000003}},	//   朱建, 能支,   ,
  { {0xf9475007,0xf8470007,0xfb5cd001,0xfa4f6005}},	//   融券, 表作, 大笑, 得注
  { {0xf93ed004,0xf5b07001,0xfb4bd00c,0x00000003}},	//   充当, 詳解, 長炭,
  { {0xf92b5007,0xfa7f6007,0x00000003,0x00000003}},	//   寒冬, 管法,   ,
  { {0xfb881006,0xfa7a0008,0xfb5bf005,0xf91ac005}},	//   明的, 岸本, 以群, 入少
  { {0xfa6d200b,0xfa552007,0xf82d2004,0xf9347001}},	//   抵抗, 定書, 年任, 愛女
  { {0xf59cf007,0xfa84c001,0xf919e001,0xf9273001}},	//   要能, 息息, 書可, 風向
  { {0xf5b5500e,0xf9217008,0xf81d4004,0xf943b00c}},	//   好調, 員制, 的九, 事商
  { {0xf9168004,0xf9201001,0x00000003,0x00000003}},	//   出市, 正後,   ,
  { {0xfa54e009,0xf9363005,0x00000003,0x00000003}},	//   会活, 也受,   ,
  { {0xf9427007,0xf5ab3004,0xf5c8f004,0xf93cd00c}},	//   有底, 低谷, 在能, 市套
  { {0xfa4f6006,0xf818b009,0xfb77f001,0xf92e7004}},	//   外来, 初中, 作組, 化在
  { {0xf82a8006,0xf944b007,0xf9213004,0xf58ef001}},	//   税人, 立委, 校就, 科能
  { {0xf934f006,0xf9249006,0xf93bd009,0xf816d004}},	//   会出, 可在, 市分, 察中
  { {0xf5b3500b,0xf823a00f,0xfb635004,0xfb86b00a}},	//   就職, 有任, 是理, 不眠
  { {0xf9471004,0xf9257004,0xf92cf005,0xf4a4e010}},	// [11c0] 位出, 是基, 易出, 献金
  { {0xfb671009,0xf92c1009,0xf9439001,0xf822c004}},	//   在科, 徐州, 下各, 又会
  { {0xf90e2006,0xf918a00e,0xfa676001,0xf5b4300c}},	//   巴巴, 点字, 里港, 拿走
  { {0xfa6d2006,0x00000003,0x00000003,0x00000003}},	//   年春,   ,   ,
  { {0xfb59f005,0xf938b002,0x00000003,0x00000003}},	//   核目, 技及,   ,
  { {0xf9124006,0xfb84d001,0xf91ef004,0xfb55d004}},	//   西北, 合現, 次土, 都由
  { {0xfb55d007,0xfa4ca008,0xf944300c,0x00000003}},	//   能由, 道模, 先加,
  { {0xf91cd007,0xfb76700e,0xfb609007,0xf9295009}},	//   入山, 回線, 管系, 表危
  { {0xf93a7004,0xf8222005,0xf4a8e00c,0xf9455002}},	//   一幕, 守住, 酒醉, 里富
  { {0xf9435006,0xfa656007,0xf93db001,0x00000003}},	//   月底, 歌手, 布套,
  { {0xfa51c004,0xfb849004,0xf58d1004,0xfa63c00a}},	//   些文, 免税, 化考, 介文
  { {0xf83d800b,0xf91d3001,0xf80f9001,0xfa4ee001}},	//   婦人, 大受, 法一, 著我
  { {0xfa732009,0xf920f005,0xfb637005,0xf8179005}},	//   羽毛, 中商, 修等, 原人
  { {0xf913400f,0xf919e006,0xf5c43004,0xf92e9004}},	//   報報, 妥善, 屯街, 抗力
  { {0xf92c5007,0xf49e4004,0xf8149001,0xfa5d4004}},	//   化合, 占道, 期今, 要数
  { {0xf5ac500e,0xf5b43007,0xf91e700c,0xf5b27005}},	//   兵衛, 能自, 員必, 好迎
  { {0xf596d009,0xf5965007,0xf9227001,0xf923b001}},	// [11d0] 神舟, 高解, 可合, 頭山
  { {0xf939500f,0xfa4c8004,0xf945b00c,0xfa4be00c}},	//   作天, 角洲, 名子, 我手
  { {0xfa894005,0xf5c0500a,0x00000003,0x00000003}},	//   在数, 管財,   ,
  { {0xf944b009,0x00000003,0x00000003,0x00000003}},	//   上各,   ,   ,
  { {0xfb845004,0xfb521004,0xfb6e1004,0xf93d5001}},	//   事科, 圾的, 店的, 必再
  { {0xf90d200f,0xf8310004,0xf92e7004,0xf83d0001}},	//   買家, 佳使, 取全, 急件
  { {0xfb5a9004,0xfb80d004,0xf5c1b004,0x00000003}},	//   入生, 者由, 般要,
  { {0xf923d00e,0xf8242004,0xf90d6008,0xf944f00c}},	//   中傷, 友会, 段差, 型快
  { {0xf4b10001,0xf92e3004,0xfb87b001,0x00000003}},	//   南音, 外引, 炎炎,
  { {0xf9281009,0xfa7b2004,0xf59ab001,0x00000003}},	//   周口, 交查, 菜色,
  { {0xf9433007,0xfb563001,0xf9124005,0xfb65500c}},	//   光客, 出美, 数地, 杯盤
  { {0xf5b2700e,0xf9124001,0xf94b7004,0xf90a600a}},	//   勿論, 異地, 税年, 康弘
  { {0xf5a4b008,0xfb871005,0x00000003,0x00000003}},	//   拉致, 告精,   ,
  { {0xfa516004,0xf91f9001,0x00000003,0x00000003}},	//   北段, 胡志,   ,
  { {0xf5bfd00e,0xf90e600e,0xf91f1008,0x00000003}},	//   淡路, 甲子, 院前,
  { {0xf8157009,0xf92a700e,0xf5a65001,0xfb83f001}},	//   写信, 粒子, 小葉, 屋線
  { {0xfb693007,0xf81cd007,0xfb711008,0xf9421005}},	// [11e0] 優生, 吃了, 際立, 万左
  { {0xfa60c007,0xfb6ef00c,0xf5ab100a,0x00000003}},	//   拉拉, 五的, 家臣,
  { {0xf90a2009,0xf5c37004,0xf48c0005,0xf48b200c}},	//   海内, 中能, 号院, 致高
  { {0xf9295004,0xf82d2004,0xf59ed001,0x00000003}},	//   在具, 年主, 的苦,
  { {0xf81d3009,0xfa5f4004,0xfb76700c,0xfb59100c}},	//   幅上, 了清, 付給, 殺特
  { {0xf931f004,0xf5c0b00c,0xf825000d,0xf80bf010}},	//   会安, 正者, 及会, 秒以
  { {0xf592d007,0xfb86d007,0xfa5d0004,0x00000003}},	//   定者, 認無, 黄梅,
  { {0xf92f9001,0xf80f500c,0x00000003,0x00000003}},	//   受全, 撕下,   ,
  { {0xfb619006,0xfa654001,0xf4c2e00c,0x00000003}},	//   中科, 洋溢, 消逝,
  { {0xf91f1005,0xfa79e00d,0x00000003,0x00000003}},	//   大号, 以情,   ,
  { {0xf5913004,0xfb52d001,0xf939b004,0xfa66a001}},	//   北辰, 山社, 持先, 立海
  { {0xf81bb00f,0xf496c001,0xf82b4004,0xfa748008}},	//   一主, 固醇, 年供, 放湿
  { {0xf823a007,0xfb68d009,0xfb6bf009,0xfa5f0005}},	//   有主, 用社, 金牌, 包法
  { {0xf48a6009,0xf5c8b001,0xf941500c,0xf928f005}},	//   零部, 全虹, 均受, 漫天
  { {0xf49e0007,0xfa5fa008,0xf937f00c,0xfb6db005}},	//   素食, 片手, 感女, 成特
  { {0xfa5de004,0xf5a4300c,0xfb669005,0xf4b8a00a}},	//   市春, 緋聞, 置相, 類選
  { {0xf5a3100f,0xf943b004,0xfa65800a,0xf4c6a002}},	// [11f0] 下跌, 午在, 下校, 踏遍
  { {0xfb77d00f,0xfa772004,0xfb82900c,0xf59d7002}},	//   果的, 点意, 等罪, 情而
  { {0xf934f004,0xfa7a0004,0xf9233001,0x00000003}},	//   会固, 查清, 港商,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa81c00a,0xfb895005,0xf910a00d,0x00000003}},	//   形性, 野猪, 宿和,
  { {0xf94a7007,0xfa4f2005,0xf932f005,0xf93dd005}},	//   低出, 五指, 会忘, 情参
  { {0xfb643006,0xfb7e5001,0xf5a17008,0xfb82b004}},	//   独特, 分版, 懇親, 文精
  { {0xfa6d2006,0xf940d009,0xf8372001,0xfa79a004}},	//   年来, 等同, 出作, 区海
  { {0xfb4b7001,0xfa83c005,0xf90d4005,0x00000003}},	//   家登, 中数, 年区,
  { {0xfb7e7009,0xf595700c,0xf8248002,0x00000003}},	//   七章, 生記, 月主,
  { {0xf947100f,0xf4a86007,0xf5c8d009,0xf8149004}},	//   認入, 只需, 在西, 期上
  { {0xfb7c5001,0xfb633001,0x00000003,0x00000003}},	//   胃炎, 般用,   ,
  { {0xf4c0e00e,0xfb6c1005,0x00000003,0x00000003}},	//   三重, 金税,   ,
  { {0xfa7d600f,0xf914000c,0xfa506005,0xfb85300a}},	//   度查, 值商, 外援, 珈琲
  { {0xf934f006,0xfa5fc00f,0xfa4fc009,0xfa71e004}},	//   婚姻, 理我, 研成, 石榴
  { {0xf9459007,0xfa51600e,0xf90c2007,0xf4be6004}},	// [1200] 再原, 林水, 海大, 情通
  { {0xf9351006,0xf817b004,0xfb7a7001,0xfa7ae00c}},	//   会常, 域使, 技研, 接打
  { {0xf9459008,0xf91c4004,0xfb637004,0xf943d00a}},	//   同封, 大商, 微粉, 立劇
  { {0xfa894006,0xf9403004,0xfb71f001,0xf494400a}},	//   在新, 万分, 底盤, 房長
  { {0xf4c54001,0xf5b89004,0xf4af6008,0xfa89400c}},	//   和里, 永葆, 達障, 木新
  { {0xfb807001,0xfa5ec005,0x00000003,0x00000003}},	//   旅社, 情提,   ,
  { {0xf9383007,0xfa698007,0xf59ff004,0xf91ee001}},	//   真刷, 護手, 了近, 因可
  { {0xfa550004,0xf4938001,0x00000003,0x00000003}},	//   留本, 能障,   ,
  { {0xfa70a004,0xfb691004,0xfa790005,0xf945f002}},	//   史海, 寒羊, 核果, 不塗
  { {0xf81c9006,0xf813d009,0xf947d004,0x00000003}},	//   要以, 高三, 名声,
  { {0xf4ad8007,0xf923d004,0xf9421004,0xf59c900c}},	//   染防, 中具, 很小, 約規
  { {0xfa846009,0xfa76c008,0xfa526001,0xfa65200c}},	//   公款, 人旅, 投書, 熊果
  { {0xf8488009,0xf842200e,0xfa64c004,0xf93bd004}},	//   在以, 監修, 事或, 持全
  { {0xf934300c,0x00000003,0x00000003,0x00000003}},	//   甘心,   ,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa648004,0xf80e9004,0xfa64a005,0xf92ab005}},	//   月来, 科以, 立投, 道各
  { {0xf59dd00e,0xf93c9001,0xf9200004,0x00000003}},	// [1210] 心身, 一念, 管公,
  { {0xf9134001,0xfb875001,0xf4c4400c,0xf944f00a}},	//   報失, 行編, 上配, 介助
  { {0xfa4d8004,0xf5953001,0x00000003,0x00000003}},	//   源性, 胚芽,   ,
  { {0xf92a1006,0xf9465004,0xfb69f004,0xf825e004}},	//   当前, 届六, 当立, 立人
  { {0xf917c001,0xfa54e004,0xf828a008,0xf9427005}},	//   司及, 多来, 美保, 三套
  { {0xf932d009,0xf4b4c007,0xf9441008,0xf49ce004}},	//   余名, 速配, 伊國, 性非
  { {0xfa62c00a,0xf83c2005,0x00000003,0x00000003}},	//   律案, 接交,   ,
  { {0xf9417009,0xf9469009,0xf90aa001,0xf5aa5001}},	//   三分, 前公, 伴奏, 然自
  { {0xf4b6c004,0xf9469001,0xfa51200c,0xf9321005}},	//   州食, 才公, 仕推, 会友
  { {0xfa89e00c,0x00000003,0x00000003,0x00000003}},	//   汪汪,   ,   ,
  { {0xf8388009,0xfa50c001,0xf9431004,0xf498e001}},	//   此不, 供消, 先向, 吸食
  { {0xfa65c006,0xfa6aa006,0xf9351004,0xf90ea004}},	//   之日, 其是, 生心, 育引
  { {0xf91be004,0xf9152001,0xfa6dc004,0xfa6a200a}},	//   津大, 落入, 防指, 明性
  { {0xfb5cd009,0xfa77a004,0xf913a004,0xf9427002}},	//   大科, 区投, 鬼城, 有引
  { {0xfb869008,0xf823c001,0xfb637008,0x00000003}},	//   問看, 載使, 鮮烈,
  { {0xfa77e004,0xf9188001,0xf90e000c,0x00000003}},	//   建或, 方協, 菲力,
  { {0xf90b6005,0xfb615005,0x00000003,0x00000003}},	// [1220] 年做, 解疑,   ,
  { {0xf8430001,0xf93d5004,0xfa576005,0xf932b005}},	//   庭主, 的停, 域治, 法地
  { {0xf5c35009,0xfb5bb00e,0xfa7e600c,0xfa4b0002}},	//   中西, 工管, 加法, 子才
  { {0xf915a004,0xfb74d005,0xfb665005,0xf92e5005}},	//   活必, 会群, 普示, 金加
  { {0xf5a79007,0xfb66f001,0xfa726005,0xfa6e600c}},	//   族聚, 全真, 台海, 足時
  { {0xf5c49009,0xfa866004,0xf911c005,0xfa63200c}},	//   路路, 是整, 地吸, 手手
  { {0xfa83a00a,0xf940b00c,0xf80bf00c,0xf932d005}},	//   中洲, 情味, 成作, 望受
  { {0xfa4da007,0xfb59b00a,0xfa4e4005,0xf9477005}},	//   南洋, 人男, 取抗, 牌公
  { {0xf58d100f,0xf5b67009,0xf4bd8001,0xf4a18005}},	//   鑑賞, 建言, 千金, 口金
  { {0xfa5be001,0xf5c1d001,0xf5b7f005,0xf915000c}},	//   局沿, 解自, 常行, 落大
  { {0xfa83c006,0xfa87e004,0xf498000c,0xfa55000c}},	//   中新, 部是, 出適, 定決
  { {0xf5c2b007,0xfb637001,0xf93b9004,0xfb629005}},	//   涯規, 副站, 老字, 景程
  { {0xf49bc006,0xfa5c0006,0xf93c3004,0xf91de005}},	//   大量, 的案, 黄光, 学好
  { {0xfa78e00e,0xf48b6001,0xf93f500a,0x00000003}},	//   人日, 谷風, 庄司,
  { {0xfa7b800b,0xf91e0004,0xf81fd005,0xfa7f0005}},	//   日本, 你喜, 切不, 大数
  { {0xfb6bb009,0xf4be4001,0xfb6bd00a,0x00000003}},	//   子站, 情願, 子牛,
  { {0xf9467004,0xf91a8004,0xf92f3001,0xf933b00c}},	// [1230] 始就, 方家, 金平, 仙博
  { {0xf93ad006,0xfa63a00f,0xfa582009,0xf946d008}},	//   十四, 按此, 府文, 立年
  { {0xf81bd00b,0xf93f7001,0xf926b005,0xfb705005}},	//   終了, 的值, 在定, 字画
  { {0xfb60b006,0xf910e009,0xfa802007,0xfa4d6004}},	//   代理, 平区, 衣服, 他教
  { {0xfa4d400b,0xf93eb008,0xfa556001,0xf828e004}},	//   外旅, 僅少, 域教, 家住
  { {0xfb72d009,0xfb86f004,0xf4c4600c,0xfa51600c}},	//   会理, 益相, 不重, 林浴
  { {0xf9232004,0xf934f004,0xf4c4c001,0xfb7c9004}},	//   亭区, 会基, 先選, 壁画
  { {0xf8221001,0xf93c7005,0x00000003,0x00000003}},	//   泉休, 要勤,   ,
  { {0xf833600f,0xf9471004,0xf80d1001,0xf5b39008}},	//   製作, 位基, 我作, 落語
  { {0xf92f9006,0xf9261005,0xf91d600c,0xf92a5010}},	//   返回, 用十, 給別, 頓堀
  { {0xfb66d00b,0xf8227001,0xf834e001,0x00000003}},	//   利用, 合了, 麻上,
  { {0xf944d004,0xf9226004,0xfb5b7004,0xf93a7004}},	//   不善, 京博, 入目, 要密
  { {0xf816d001,0xf935900c,0x00000003,0x00000003}},	//   誘人, 功力,   ,
  { {0xf9359004,0xf917a004,0xf5a41001,0xf9267005}},	//   仙区, 点分, 額計, 天南
  { {0xf4a26007,0xf820d004,0xf4aba004,0xf92f7005}},	//   代連, 分中, 子集, 向家
  { {0xf9190007,0xf941b004,0xf836c008,0x00000003}},	//   人出, 分国, 竹下,
  { {0xf5c15006,0xf93a700c,0xf93cb005,0xf843a00c}},	// [1240] 本行, 一展, 市引, 種介
  { {0xf9279005,0xf927700c,0xfa4e0005,0xf5c31010}},	//   在快, 巨塔, 金杯, 般論
  { {0xf4c6a001,0xf599f00c,0xf80db00c,0xf9285005}},	//   位連, 品認, 或作, 被刑
  { {0xf919800f,0x00000003,0x00000003,0x00000003}},	//   知名,   ,   ,
  { {0xf9475009,0xf4b94009,0xf911a001,0xfb6df005}},	//   明光, 硝酸, 走入, 疑犯
  { {0xf4a6c001,0xf924b005,0xf91f200d,0x00000003}},	//   全通, 公山, 院反,
  { {0xfb833006,0xf9214001,0xfa5de00c,0xf947b00c}},	//   三章, 象印, 市查, 美名
  { {0xf5a75005,0xfa83a005,0x00000003,0x00000003}},	//   和良, 良渚,   ,
  { {0xf9341004,0xfb715004,0xfb6b5005,0xfb7d3005}},	//   力容, 比特, 坐的, 必看
  { {0xfb6b5009,0xf92bf001,0xfa708001,0x00000003}},	//   材的, 我同, 東旅,
  { {0xfa840001,0xf93b7004,0xf80e7004,0x00000003}},	//   潭水, 要得, 金信,
  { {0xf8336004,0xf5a71008,0xf81f9005,0x00000003}},	//   稿人, 里親, 毅中,
  { {0xf81db00d,0x00000003,0x00000003,0x00000003}},	//   老伴,   ,   ,
  { {0xfb85300f,0xf944d009,0xf5abf008,0xf92b7005}},	//   奈米, 上分, 茶色, 嗓子
  { {0xfa5f6001,0xf4bfe00c,0x00000003,0x00000003}},	//   集愛, 均量,   ,
  { {0xfb7e7004,0xfa878004,0xf843a001,0xf5bb3005}},	//   市石, 用未, 種事, 日被
  { {0xf5a53007,0xf8360004,0xfb63b001,0xfa860004}},	// [1250] 行計, 人上, 催眠, 港新
  { {0xfa7b2004,0xf9148005,0xfb72500c,0xf942500a}},	//   交日, 拼域, 法精, 須市
  { {0xfb7f7001,0x00000003,0x00000003,0x00000003}},	//   集線,   ,   ,
  { {0xf83ec001,0xfa686008,0xf59cf004,0xf9489005}},	//   信保, 美沙, 要追, 行好
  { {0xfb88b001,0xf5bab00a,0xfa7b400c,0x00000003}},	//   而由, 並行, 度旅,
  { {0xf80c5009,0xfa6fc001,0xf93d100c,0xf91dc005}},	//   金企, 汰換, 千四, 模及
  { {0xf9265004,0xf9479001,0xfb859004,0x00000003}},	//   墨市, 小夜, 行税,
  { {0xf5be9008,0xfb7e9001,0xf940d005,0xfa674005}},	//   大西, 情生, 情就, 才智
  { {0xfa56000a,0xf4b8c005,0xf938100c,0xf936d00c}},	//   償提, 州都, 朝南, 祝各
  { {0xfb7ab009,0xf922a00a,0xf4a0800c,0x00000003}},	//   所用, 解度, 象鼻,
  { {0xf93c9009,0xfa85e004,0xfa85a00c,0x00000003}},	//   元市, 全操, 良書,
  { {0xf5b41004,0xf83ce004,0xf4c76001,0xfa874005}},	//   国著, 警中, 配選, 在排
  { {0xf92e7005,0x00000003,0x00000003,0x00000003}},	//   取在,   ,   ,
  { {0xf842a009,0xfa504004,0xf91fc004,0xf935b00c}},	//   可事, 展思, 索内, 食原
  { {0xfa71c009,0xfa7ea00c,0xfa85a00a,0xf9365005}},	//   新房, 信望, 副書, 期受
  { {0xfa7f0009,0xfa76c004,0xfa86e004,0xf83ce004}},	//   大新, 人担, 周星, 学中
  { {0xf93fd004,0xf825d00c,0xf4a2800a,0xf9136005}},	// [1260] 内加, 下任, 亢進, 圾填
  { {0xf4be0006,0xfa64a00c,0x00000003,0x00000003}},	//   的首, 事比,   ,
  { {0xf82f0006,0xf49a8001,0xf9363005,0xfb633002}},	//   新一, 船長, 州内, 釣竿
  { {0xfb57300f,0xfb781008,0xf925a005,0xfb695005}},	//   出租, 謝罪, 在吉, 株生
  { {0xfa75600f,0xfa546007,0xf9277004,0xfb67d00c}},	//   施政, 站法, 被市, 笨笨
  { {0xfb86500e,0xf8370004,0xf58f1001,0xfa678005}},	//   再編, 区会, 協談, 行是
  { {0xf9160007,0xfa834004,0xf933f00c,0xfa7d200c}},	//   人安, 是清, 力去, 素所
  { {0xf9100001,0xf5bcb004,0xf594b001,0xfb639001}},	//   到原, 性肝, 感肌, 業申
  { {0xf83e4009,0xf9154008,0xf912c004,0xf9214004}},	//   大以, 任式, 国品, 象台
  { {0xf913400f,0xfa600006,0xfa61a001,0xfb539004}},	//   山地, 清查, 商施, 好科
  { {0xf9293006,0xf928d001,0xf4b4c008,0xf5a65001}},	//   用地, 含外, 料館, 配表
  { {0xfb575005,0x00000003,0x00000003,0x00000003}},	//   点狂,   ,   ,
  { {0xf5a97001,0xf82aa00c,0x00000003,0x00000003}},	//   長葉, 護作,   ,
  { {0xfb529009,0xfa63e004,0xfa686004,0xf9184001}},	//   箱登, 型文, 式推, 書心
  { {0xf922600e,0xfa560001,0xfa6fa004,0xf92c5005}},	//   測定, 依消, 防性, 取合
  { {0xf5ac5001,0xf92e7001,0xf912c008,0xfa558001}},	//   場表, 林官, 許容, 高法
  { {0xf8247009,0xfa6b0004,0xfa4ca005,0xf5af7002}},	// [1270] 案信, 年旅, 村指, 到者
  { {0xfb80b00c,0x00000003,0x00000003,0x00000003}},	//   堆置,   ,   ,
  { {0xf83ac006,0xfb87d00c,0xf825f005,0xf5b73005}},	//   学位, 像真, 同了, 容要
  { {0xfb725007,0xf5a1f00c,0xfa76200a,0x00000003}},	//   愛生, 葉菜, 費期,
  { {0xf816f004,0xf4b2a001,0xf8384005,0xf59c100c}},	//   付使, 力道, 交上, 最詳
  { {0xfa5b800f,0xf9124006,0xf9423007,0xf838c001}},	//   概況, 避孕, 葉子, 書保
  { {0xf91a8009,0xf8249005,0x00000003,0x00000003}},	//   吸入, 舍不,   ,
  { {0xf925c007,0xf93c5009,0xf48b8004,0xfa84e005}},	//   木屋, 要学, 雷雨, 物残
  { {0xf4af200f,0xf9341008,0xfa87a001,0xf4912005}},	//   答集, 沙子, 用注, 台面
  { {0xf58e5008,0xf48a4001,0xfb78b001,0xfa612001}},	//   化論, 強震, 思索, 秉持
  { {0xf80c9004,0xf949f001,0xf909e005,0xf841800c}},	//   外上, 福報, 德品, 般住
  { {0xf4c38008,0xf842a001,0xfb77f005,0x00000003}},	//   友銀, 可下, 菜病,
  { {0xf81c9009,0xf947d001,0xf49be00c,0xfa4be005}},	//   品交, 行加, 判長, 桑植
  { {0xf92e5006,0xf9437004,0xf9383004,0xfb67b00c}},	//   科学, 三室, 真号, 利登
  { {0xfb757009,0xf8298009,0xf91f0004,0xf8394001}},	//   功率, 式使, 加公, 盤保
  { {0xf93fb00c,0xfb6d900c,0x00000003,0x00000003}},	//   商回, 近火,   ,
  { {0xf9383009,0xf90f8005,0xf910c00a,0xf93b9002}},	// [1280] 州大, 新宇, 阿倍, 省北
  { {0xf9379007,0xfb5cd007,0xf917e001,0xfb73100a}},	//   作小, 你看, 主建, 焙煎
  { {0xf922400e,0xfa554009,0xfa81c004,0xf9192001}},	//   本多, 真情, 中排, 人常
  { {0xf599d004,0xfb5e7008,0x00000003,0x00000003}},	//   要行, 試練,   ,
  { {0xf946b009,0xfa806004,0xf9246005,0x00000003}},	//   越大, 患意, 央商,
  { {0xf91c6007,0xfa5a6001,0xfb4fd00c,0xf91ce005}},	//   性商, 丁旅, 已知, 略地
  { {0xfa4f8009,0xf92f7001,0xf83f4004,0xf82d4010}},	//   他方, 他出, 止不, 欲不
  { {0xf81ff009,0xf5c5d004,0xf4ada001,0xfa6e2001}},	//   内信, 在行, 民部, 滴滴
  { {0xf91d8004,0xf5c3f004,0xf93ed002,0x00000003}},	//   度出, 是近, 清展,
  { {0xf829c00f,0xf4a7e001,0xf948b004,0xf5a3900c}},	//   買一, 自閉, 行平, 先自
  { {0xf8249006,0xf938d009,0xfb867005,0xf932900c}},	//   降低, 川大, 名犯, 法已
  { {0xfa74000e,0x00000003,0x00000003,0x00000003}},	//   西新,   ,   ,
  { {0xfa5fa00f,0xfb4df004,0xfa6b4005,0xfa66c005}},	//   商機, 年男, 整枝, 王海
  { {0xf49e8004,0xf92e9005,0x00000003,0x00000003}},	//   次集, 北四,   ,
  { {0xf5955008,0xfa6bc004,0x00000003,0x00000003}},	//   功者, 起止,   ,
  { {0xfb7c3007,0xfb501004,0xf91b8002,0x00000003}},	//   一申, 械生, 大律,
  { {0xfb523004,0xfb7e1001,0xf58f5005,0xf826d00c}},	// [1290] 白粉, 的紫, 志被, 額信
  { {0xf91d8007,0xfa7e0004,0xfb84300c,0xf92e7005}},	//   造商, 大渡, 有申, 比同
  { {0xfa4f2006,0xf81dd009,0xf918a00e,0xfb58f007}},	//   首次, 内企, 治家, 特種
  { {0xf93bd004,0xf58df00a,0xfa74e00a,0x00000003}},	//   持在, 外苑, 電案,
  { {0xf48e8008,0xf836000c,0xf8402005,0x00000003}},	//   課金, 人伊, 正不,
  { {0xf93f9009,0xfa6d200e,0xf48c000c,0x00000003}},	//   了多, 直樹, 張震,
  { {0xf4b68006,0xf8125009,0xf8245005,0xf5a7700c}},	//   生部, 定不, 反三, 野車
  { {0xf9250009,0xf9286009,0xf4a14010,0x00000003}},	//   利完, 部学, 鏡音,
  { {0xf81b3001,0xfa530005,0xf90a200c,0x00000003}},	//   所代, 井水, 起居,
  { {0xf5c9d00f,0xf83a8006,0xf93c5006,0xfb7c3009}},	//   優質, 度上, 的前, 的立
  { {0xf5bed00b,0xfa4be004,0xfa6f8001,0xfa60600a}},	//   性能, 当注, 想成, 來未
  { {0xf815900d,0x00000003,0x00000003,0x00000003}},	//   州之,   ,   ,
  { {0xfb66f006,0xf81c7004,0xfb7b9001,0xf4bd400a}},	//   全生, 千伏, 所登, 十音
  { {0xfa844009,0xf9359004,0xfa71a001,0xfa82000c}},	//   是比, 丘北, 東湖, 京故
  { {0xf59e9001,0xf59bd00a,0xf947b005,0x00000003}},	//   超耐, 境計, 行客,
  { {0xf919e008,0xf58a5001,0xfa638005,0xfa64a005}},	//   常利, 間規, 三查, 名最
  { {0xf93a7007,0xfb5cf005,0xfb4b700c,0xf5be5002}},	// [12a0] 最受, 性科, 致生, 管考
  { {0xf945b007,0xf8271005,0xf83ce00c,0x00000003}},	//   下室, 不主, 章下,
  { {0xf58dd00e,0xf496e004,0x00000003,0x00000003}},	//   金表, 出高,   ,
  { {0xfa86e006,0xf827f009,0x00000003,0x00000003}},	//   周期, 行信,   ,
  { {0xf90d4009,0xfa5f6004,0xf91cc001,0xf919600c}},	//   年出, 了文, 入右, 出女
  { {0xfa87800b,0xf939b005,0x00000003,0x00000003}},	//   復活, 持合,   ,
  { {0xfb7c3006,0xf9415009,0xfb50900c,0x00000003}},	//   的程, 光市, 味無,
  { {0xf835e009,0xf8476001,0xf9479005,0xf83b600c}},	//   格信, 含一, 再好, 座上
  { {0xfa4f6007,0xfb749009,0xf8416008,0xf8215004}},	//   動手, 拘留, 止中, 等七
  { {0xf92a600e,0x00000003,0x00000003,0x00000003}},	//   被害,   ,   ,
  { {0xf8386005,0xfb4dd00c,0xf4c30010,0x00000003}},	//   出代, 場由, 昇進,
  { {0xfa75c009,0xf91b2009,0xfa4f4007,0xf4a5c008}},	//   好新, 学堂, 捕捉, 全開
  { {0xfb6bb009,0xf946d004,0xfa560004,0xf4c1c005}},	//   插秧, 免冠, 沙河, 哈里
  { {0xf5c6d005,0x00000003,0x00000003,0x00000003}},	//   在距,   ,   ,
  { {0xf92f1007,0xf5c05004,0xf825d004,0xf921c00c}},	//   且商, 中行, 行企, 解字
  { {0xf9166004,0xf9391001,0xf946d004,0xfa8b4005}},	//   建小, 果夫, 行当, 浪汽
  { {0xfa70c00f,0xf9387009,0xf5927004,0xfb75f004}},	// [12b0] 防水, 非典, 堕落, 期科
  { {0xfb661004,0xfa57c005,0xf49e000c,0xfa86e00c}},	//   天科, 属本, 度防, 快把
  { {0xf4c6600e,0xfb64f009,0xfa6fe005,0xf8141005}},	//   和食, 路管, 佳木, 官不
  { {0xfa66e006,0xf5ac3001,0xfa5e2004,0xfb62f004}},	//   上来, 場自, 境是, 本窗
  { {0xf927e00f,0xfa78e007,0xf93eb009,0xf8350009}},	//   庫存, 人接, 内向, 好以
  { {0xfb56d001,0xf81b1004,0xfb6e7004,0xf943f005}},	//   人理, 市今, 或用, 王勇
  { {0xf82a5006,0xf92d9009,0xf9234009,0x00000003}},	//   年上, 向外, 本利,
  { {0xfb7e3006,0xf9190001,0xfa7d0004,0xfa576004}},	//   的物, 人基, 大排, 速来
  { {0xf8147004,0xf5a33008,0xf845200c,0xf81b900a}},	//   定中, 運行, 利住, 退任
  { {0xf9355004,0xf9457008,0xf4934010,0x00000003}},	//   定国, 重宝, 東雲,
  { {0xfb58700f,0xf923e004,0x00000003,0x00000003}},	//   常的, 是增,   ,
  { {0xf934b00f,0xf4a2e004,0xfb7e5004,0xfa66000a}},	//   站全, 京酒, 商等, 手摺
  { {0xf9152005,0x00000003,0x00000003,0x00000003}},	//   命健,   ,   ,
  { {0xf9186006,0xfb865001,0xf9296005,0xf917c00c}},	//   交友, 小築, 周家, 活工
  { {0xf4ace001,0xf5b7d00c,0xfb6cb00c,0xfa69e005}},	//   帖量, 出訪, 沖積, 海概
  { {0xf943900b,0xfa820004,0xf5c5b008,0xfa6f8005}},	//   消化, 京旅, 全車, 女排
  { {0xf4988001,0xf912e001,0xfa4d2001,0xf5c7b001}},	// [12c0] 人連, 東常, 疑惑, 部表
  { {0xf9198009,0xfa5ae001,0xf826f00c,0x00000003}},	//   令停, 汁機, 族一,
  { {0xf4988008,0xfb681008,0xfa884005,0xfa770005}},	//   撤退, 表第, 天数, 方明
  { {0xfb85f010,0x00000003,0x00000003,0x00000003}},	//   律相,   ,   ,
  { {0xfa58e001,0xfa6c2005,0x00000003,0x00000003}},	//   所服, 年湖,   ,
  { {0xf5b1b00f,0xf5c05007,0xf8193009,0xfa586009}},	//   報表, 代言, 思主, 期整
  { {0xfb6f9005,0xf940f00a,0xfa586005,0xf58ff00a}},	//   列用, 文子, 真整, 菖蒲
  { {0xfa4ce009,0xf9242009,0xf930b007,0xfb539005}},	//   当根, 本建, 算命, 国神
  { {0xfa53200f,0xf9166009,0xfa4e0009,0xf5a3d004}},	//   料最, 死刑, 金支, 案表
  { {0xf926c009,0xf592d007,0xf8318001,0xf92a8001}},	//   在多, 飛航, 地主, 快到
  { {0xfb885005,0xf93cd005,0x00000003,0x00000003}},	//   小猫, 考分,   ,
  { {0xf8125006,0xf9198005,0x00000003,0x00000003}},	//   定位, 查前,   ,
  { {0xfa5ec006,0xf940900c,0xfb4f100c,0x00000003}},	//   布日, 載安, 音線,
  { {0xf821b009,0xf4b30001,0xfb5fb005,0xf9489005}},	//   月上, 痛風, 加特, 富国
  { {0xf910a00e,0xf5c7f001,0xf831c004,0xf9132004}},	//   環器, 優越, 款不, 都分
  { {0xf91fe009,0xf9132001,0xf945b005,0x00000003}},	//   面存, 能分, 上引,
  { {0xf923c001,0xf924200a,0xf946b005,0x00000003}},	// [12d0] 頭報, 傭兵, 行向,
  { {0xfb61d00b,0xf82fa009,0xf9118009,0xf9220005}},	//   本的, 地供, 澳台, 溢出
  { {0xf825b004,0x00000003,0x00000003,0x00000003}},	//   砍伐,   ,   ,
  { {0xf4c58009,0xfa782004,0xf5981001,0xf5b4f004}},	//   程造, 出港, 原色, 松花
  { {0xfb557006,0xf9292004,0xf92d7001,0xfb78d005}},	//   国社, 用已, 託刊, 局王
  { {0xfa738009,0xfa5ec008,0xf814f00c,0x00000003}},	//   命感, 垂水, 生什,
  { {0xfa5a8005,0x00000003,0x00000003,0x00000003}},	//   省情,   ,   ,
  { {0xfb72500e,0xf90f6009,0xfb595005,0xfa5c4005}},	//   動特, 柳州, 查程, 裂果
  { {0xfa7b2009,0xfa73c004,0xfa7b400c,0xfb5cb002}},	//   交接, 都成, 判書, 工細
  { {0xfb7f3006,0xfa73c007,0xf923000c,0x00000003}},	//   的相, 能成, 口吻,
  { {0xfa54200f,0xfb77b001,0xf48ba00c,0xf939b005}},	//   願意, 生社, 海馬, 着多
  { {0xf9104007,0xfa638004,0xf943f005,0xfa63200d}},	//   田園, 月湖, 事多, 万桶
  { {0xfa778005,0xf93d3005,0xfb89b00c,0xfa5b600d}},	//   主次, 包合, 煎熬, 蜀桧
  { {0xf497e005,0xf9311010,0xf94a1010,0x00000003}},	//   建首, 毛和, 烏山,
  { {0xf5a1f007,0xf82ad004,0xfa718004,0xf9152004}},	//   合規, 制中, 地来, 尾声
  { {0xf911a006,0xf9218006,0xfa68a004,0xfa6c2004}},	//   地区, 正当, 小本, 更注
  { {0xfa52e001,0x00000003,0x00000003,0x00000003}},	// [12e0] 務手,   ,   ,
  { {0xfa5f8007,0xfa842004,0xf9409005,0xfa872005}},	//   項業, 京日, 商可, 央新
  { {0xf4988005,0xf918c005,0xfa7f2005,0xf945d00c}},	//   人那, 幸存, 性新, 而各
  { {0xf5bb9009,0xfa674007,0xfa492007,0xfa696004}},	//   大行, 式料, 舒服, 式改
  { {0xf48be004,0xf8372004,0xf8231004,0x00000003}},	//   年青, 方一, 看上,
  { {0xf5ba300f,0xf83b2004,0xf59a5001,0xf58e5004}},	//   日記, 古人, 持要, 林覆
  { {0xfa87e007,0xf81f3005,0xfa7b2005,0x00000003}},	//   部支, 呆了, 春暖,
  { {0xf9475004,0xfb753004,0xfb6d3001,0xfa80a005}},	//   李嘉, 束的, 湖的, 中流
  { {0xfa566004,0xf9377005,0xfb57300c,0x00000003}},	//   期或, 作前, 出真,
  { {0xfa68a001,0xfa71e001,0xfb6a3008,0xf932500a}},	//   然植, 石水, 被災, 四回
  { {0xf93a1001,0xfa63c00d,0x00000003,0x00000003}},	//   思念, 事文,   ,
  { {0xf94a5009,0xf5a97001,0xf83e6004,0xf92bc001}},	//   明区, 家談, 性以, 村光
  { {0xf931f001,0xf4c86001,0x00000003,0x00000003}},	//   且具, 行選,   ,
  { {0xf59d100e,0xf92e6001,0x00000003,0x00000003}},	//   品購, 店官,   ,
  { {0xf835a004,0xfa804004,0x00000003,0x00000003}},	//   活了, 造新,   ,
  { {0xfa71c004,0xfb55d005,0xf9419005,0xf9429005}},	//   精明, 区版, 指在, 有北
  { {0xfb7dd007,0xf59d5009,0xf9214004,0xf82df004}},	// [12f0] 時空, 薄膜, 中多, 平上
  { {0xf5c6f001,0xfa79e005,0x00000003,0x00000003}},	//   木舟, 方承,   ,
  { {0xf931d001,0xf4bd0008,0x00000003,0x00000003}},	//   博弈, 寄附,   ,
  { {0xf9244005,0xf8402005,0x00000003,0x00000003}},	//   京出, 庭上,   ,
  { {0xfa82c007,0xf5a39004,0xf4a72005,0xf90c000c}},	//   業採, 王老, 在限, 場動
  { {0xfa700004,0x00000003,0x00000003,0x00000003}},	//   峰期,   ,   ,
  { {0xf5971001,0x00000003,0x00000003,0x00000003}},	//   真誠,   ,   ,
  { {0xf4c30007,0xf5a53001,0xfb7e900c,0xf9481005}},	//   月非, 月花, 概由, 疏勒
  { {0xf90f8001,0xf932900c,0xf93c900c,0xfb6f5005}},	//   色因, 做善, 喃喃, 或登
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf8133006,0xf936b007,0xfa5e8007,0xfa56c004}},	//   会保, 付出, 分手, 付方
  { {0xf5a75004,0xfa790002,0x00000003,0x00000003}},	//   行表, 交情,   ,
  { {0xfb6e3007,0xfa660009,0xf5bcb007,0xf80b3004}},	//   化研, 反法, 負載, 易保
  { {0xfa76e009,0xf927c004,0xf5a03001,0xf5963005}},	//   建文, 在利, 指考, 保袋
  { {0xfa6fc009,0xfb645004,0xf492400c,0x00000003}},	//   平湖, 可研, 東連,
  { {0xf5aa1005,0x00000003,0x00000003,0x00000003}},	//   式起,   ,   ,
  { {0xf81ff006,0xf9216001,0xfa4d4005,0xf91d8005}},	// [1300] 集体, 正向, 外情, 度基
  { {0xfa820005,0xf4bd600c,0x00000003,0x00000003}},	//   亭湖, 情運,   ,
  { {0xf814f009,0xfa55e004,0xf920800c,0xf822f005}},	//   生一, 多更, 正堂, 立三
  { {0xfa66800f,0xf9152004,0x00000003,0x00000003}},	//   行榜, 任前,   ,
  { {0xfa76a004,0xf5c79001,0xf8414005,0xf495000c}},	//   格格, 部自, 京上, 攻隊
  { {0xf90de006,0xf9495004,0xfa696004,0x00000003}},	//   平安, 式出, 式方,
  { {0xfb795006,0xf59ab004,0xf4a46004,0xfa554005}},	//   作物, 局被, 是首, 期清
  { {0xfb7a3001,0xf911e001,0xf5ab700c,0x00000003}},	//   一笑, 想念, 具自,
  { {0xf920e00f,0xfb583007,0xf8396007,0xf4af0001}},	//   索取, 出第, 接下, 他連
  { {0xf8211007,0xf4970004,0xf8476004,0xfa7ee001}},	//   情侶, 出通, 在五, 大悲
  { {0xf499e00b,0xfb71d001,0xfb5c5004,0xfb5fb004}},	//   特選, 委由, 查相, 管用
  { {0xf491e009,0xfb805004,0xf9306004,0xfa6a8008}},	//   新都, 了算, 店区, 美樹
  { {0xf59e9009,0xfa5c0008,0xf4bc6004,0xfa60e004}},	//   市花, 哀想, 市非, 等操
  { {0xf920a004,0xf5981008,0xfa5c000c,0x00000003}},	//   股室, 語解, 的沈,
  { {0xf928a006,0xf9120001,0xf5bd5004,0xf93c5001}},	//   在建, 到好, 加考, 需具
  { {0xf810900f,0xf835e009,0xf90f4007,0xfb885001}},	//   動作, 区三, 困境, 小火
  { {0xf9198004,0xfa7fe005,0x00000003,0x00000003}},	// [1310] 吸取, 校是,   ,
  { {0xf8141008,0xf4a06001,0xf831e008,0x00000003}},	//   付与, 業額, 精一,
  { {0xfa694006,0xfa620001,0xf92c6004,0xfb865005}},	//   税法, 假扣, 金市, 前用
  { {0xfa732007,0xfa670001,0xfa7fa001,0x00000003}},	//   深深, 融控, 面故,
  { {0xf92d6006,0xfa66e006,0xf849200b,0xf5b9300c}},	//   外商, 看更, 自作, 入計
  { {0xfb561006,0xf91c4005,0x00000003,0x00000003}},	//   建立, 来出,   ,
  { {0xf92c0004,0xf90f6004,0xfb77d001,0x00000003}},	//   成土, 新内, 果範,
  { {0xf94a1004,0xfa584004,0xfb56b00c,0xf92c800c}},	//   族地, 期扶, 人約, 駐動
  { {0xfb665006,0xf5b1b004,0xfa7a2005,0xfa55a005}},	//   在的, 由被, 除您, 高抗
  { {0xf9124009,0xf937500e,0xfb827004,0xfa6d2004}},	//   困地, 領就, 予的, 年接
  { {0xf9214004,0xf912e00c,0xf59df00c,0x00000003}},	//   京安, 東岸, 的耗,
  { {0xf943700e,0x00000003,0x00000003,0x00000003}},	//   開封,   ,   ,
  { {0xf4bd0007,0xf92d8004,0xfa7be004,0xfa7aa004}},	//   品都, 取四, 大流, 学手
  { {0xfb755001,0xf59e9005,0x00000003,0x00000003}},	//   通申, 市英,   ,
  { {0xfa562004,0xfa6ba001,0xf91f000c,0x00000003}},	//   宝泉, 家書, 占公,
  { {0xf944f004,0xfa660005,0xfb5ef005,0x00000003}},	//   程全, 昌教, 院看,
  { {0xfa4ca007,0xf82ef001,0xf9467001,0xf598f00c}},	// [1320] 或服, 到不, 始報, 作評
  { {0xf918800f,0xf9110007,0xf838c008,0xf9359001}},	//   選商, 平常, 司会, 期定
  { {0xfa728006,0xfa83c006,0xfa664009,0xf812f001}},	//   放思, 本次, 尊敬, 做些
  { {0xf93cd00f,0xf59f3004,0xfb873004,0x00000003}},	//   市南, 内自, 前移,
  { {0xf945b004,0xfb561004,0x00000003,0x00000003}},	//   再向, 押登,   ,
  { {0xf91c8006,0xfb70f001,0xf5ab3008,0xfa70600a}},	//   大多, 四等, 討議, 進曲
  { {0xf924c007,0xf93a7009,0xfa5ee004,0xfa836004}},	//   冬山, 品内, 幅比, 是文
  { {0xf943d008,0xfa874004,0x00000003,0x00000003}},	//   興奮, 馨提,   ,
  { {0xf925e006,0xfb867006,0xf4c26007,0xf9246007}},	//   良好, 配置, 切除, 息列
  { {0xf93d3008,0xfa7b8005,0xfb817005,0xf4a1a00c}},	//   封印, 入是, 分特, 口間
  { {0xf9202001,0xfa4fe00c,0x00000003,0x00000003}},	//   代名, 夕情,   ,
  { {0xf9306007,0xf59cf004,0x00000003,0x00000003}},	//   五彩, 求被,   ,
  { {0xf48dc009,0xf9324004,0xf90b600a,0x00000003}},	//   防震, 会名, 混在,
  { {0xf9445006,0xf91c6004,0xfb71900c,0xfa78a005}},	//   位名, 句容, 湛的, 示模
  { {0xf848c001,0xfa824001,0xf92a4005,0xfa7ec005}},	//   太久, 解業, 易名, 院授
  { {0xfb6df00b,0xf9210001,0xf5b25005,0xf9276005}},	//   外科, 業商, 好行, 虫夏
  { {0xfa6a400b,0xf93ed001,0xfa554001,0xf5c6b00c}},	// [1330] 明治, 考室, 願成, 全講
  { {0xf92e800f,0xf814d001,0xf4998001,0xf813f004}},	//   餐具, 做任, 工退, 折不
  { {0xf828b006,0xfa696009,0xf5af1001,0xf91ee00a}},	//   低保, 明您, 細規, 握力
  { {0xfb58100b,0xf4a2e009,0xfa840007,0xf92ae004}},	//   建物, 京青, 庭暴, 未建
  { {0xf911600e,0xf81c3004,0xf4b70002,0xfa63a002}},	//   新大, 它不, 勝雄, 有急
  { {0xf9232004,0xfb6d500a,0xf93f3005,0xf8253010}},	//   中建, 化症, 心幼, 和之
  { {0xfa662001,0xf91e8004,0xf59d7004,0xf4992005}},	//   囊括, 大典, 持走, 竹院
  { {0xfa742004,0xf9373001,0xf93c900c,0xf92c4005}},	//   国未, 府廉, 品入, 当庭
  { {0xfa604005,0xfb8a700c,0xf5b8d00a,0x00000003}},	//   了演, 低空, 出費,
  { {0xf4b28008,0xf9308001,0xfa4ba001,0xfa686005}},	//   換金, 林出, 源教, 式暨
  { {0xf923e001,0xfa83c005,0x00000003,0x00000003}},	//   業傷, 口海,   ,
  { {0xf820b008,0xfa506001,0xfb56d004,0xf943d008}},	//   三上, 展期, 格由, 計器
  { {0xfb84d008,0xf5ab700c,0xfb60900a,0x00000003}},	//   躍的, 遵行, 那珂,
  { {0xfb867008,0xfa5b0001,0xfa564008,0xf5b19001}},	//   問等, 府收, 期比, 詳述
  { {0xf93c7006,0xfa77e006,0xf9094006,0xfb629004}},	//   一号, 人或, 混合, 是立
  { {0xfb60d006,0xfa4ce006,0xf5a73009,0xfa616004}},	//   中的, 近期, 行自, 仇恨
  { {0xfa63c006,0xf5be100b,0xf92ee006,0xf83aa007}},	// [1340] 事指, 員規, 途径, 日休
  { {0xf819d00f,0xfa4d0009,0x00000003,0x00000003}},	//   品介, 子是,   ,
  { {0xf934b006,0xf8311009,0x00000003,0x00000003}},	//   站在, 到中,   ,
  { {0xfb503009,0xfa598004,0x00000003,0x00000003}},	//   至目, 一情,   ,
  { {0xf93fd007,0xfa602009,0xf5b53001,0xf5c37001}},	//   各家, 者来, 格自, 業能
  { {0xfb879004,0xfa618001,0xf909e005,0xf9214005}},	//   不申, 有情, 家原, 象地
  { {0xf92b0009,0xf4a5c008,0xfb65d005,0x00000003}},	//   排在, 全運, 路甲,
  { {0xf919600b,0xf5a79006,0xf934f006,0xf8141001}},	//   以前, 不足, 勘察, 務作
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf92f4004,0xf927800a,0xf5b0900c,0x00000003}},	//   少地, 士市, 政見,
  { {0xfb619007,0xfa4f6001,0xf92f4001,0xfa73800a}},	//   業科, 林溪, 民地, 乱暴
  { {0xf944b006,0xf490a00a,0x00000003,0x00000003}},	//   下列, 由香,   ,
  { {0xfa7b200f,0xf9204001,0xf81a5005,0x00000003}},	//   判決, 代小, 果使,
  { {0xf945f009,0xf9166001,0xfa668001,0xf935d004}},	//   及全, 建宏, 配息, 高在
  { {0xf93dd009,0xf9326005,0xf929e00c,0xf90c400c}},	//   内市, 会小, 庫出, 買入
  { {0xf9477001,0xf93b7004,0xf5a69001,0xfa85e00c}},	//   位值, 秀学, 規行, 周明
  { {0xfa68000f,0xf49ce009,0xfa5cc007,0x00000003}},	// [1350] 積極, 大限, 約時,
  { {0xfb4bd00b,0xfa65e008,0xf9140004,0xfb851005}},	//   極的, 床暖, 能引, 反病
  { {0xf935500b,0xf90d6001,0xf9282008,0xfb62f00a}},	//   教員, 仲夏, 物好, 中盤
  { {0xf915e009,0xf5af9007,0xf92ae004,0xfa6a4005}},	//   国地, 山葉, 坪区, 康文
  { {0xfb4eb006,0xf5c4700e,0xf9346005,0x00000003}},	//   平理, 本製, 定公,
  { {0xf93c5009,0xf93f1004,0xf4b8e001,0xf4c84005}},	//   的免, 玄幻, 神鬼, 和阿
  { {0xf9348007,0xf93ad009,0xf9399001,0xfa6f6004}},	//   原先, 参合, 一商, 地旅
  { {0xfb641007,0xfa7d2004,0xfa49a00a,0x00000003}},	//   京群, 来更, 排泄,
  { {0xf941900f,0xfa52c001,0xf944500c,0xf5977005}},	//   有商, 多情, 合座, 搜藏
  { {0xf93bd004,0xf8313004,0xfb74700c,0xf92d6005}},	//   娃哈, 山体, 乘的, 子加
  { {0xf8472009,0xfa4fa001,0xf91b200c,0xf83f200c}},	//   用体, 法概, 入志, 簡体
  { {0xf5947006,0xfa7c0007,0xf4a2a001,0xfb85f004}},	//   高考, 知性, 斯里, 菌病
  { {0xf5911001,0xfb649004,0xfb6b300c,0xf945f002}},	//   店買, 是物, 術生, 而分
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf829d004,0xf93f7004,0xf92be005,0x00000003}},	//   件也, 寄宿, 青区,
  { {0xfa81c001,0xfa4ec004,0xf814f004,0xfb629005}},	//   口投, 策是, 食企, 景看
  { {0xfb573006,0xf5ba5001,0xfa744004,0xfb5b3001}},	// [1360] 出生, 司股, 国注, 度約
  { {0xfb4ef007,0xf81fb005,0xf9152005,0xf921200a}},	//   潰瘍, 分作, 施入, 本光
  { {0xf493e001,0xf5a2f005,0xf80d100c,0x00000003}},	//   調音, 万英, 近休,
  { {0xf8430001,0xf4968001,0xf9140002,0x00000003}},	//   口人, 示送, 房平,
  { {0xfb5ad004,0x00000003,0x00000003,0x00000003}},	//   学美,   ,   ,
  { {0xf5c3b00f,0xf90f0009,0xf83d2004,0xfb83f008}},	//   央行, 已在, 大五, 脈硬
  { {0xfb595009,0xf93c5009,0xf9461001,0xf9451004}},	//   春秋, 的再, 今彩, 仍存
  { {0xf916e00c,0xfb76d00d,0x00000003,0x00000003}},	//   藻外, 生班,   ,
  { {0xf5b9500f,0xfa5bc009,0xf9126001,0xf9270008}},	//   書評, 市情, 新制, 目印
  { {0xf8434009,0xf921e007,0xfb621004,0xfa5d0001}},	//   班人, 面出, 京理, 心思
  { {0xf91e6009,0xf942100e,0xf91f4001,0xf945d004}},	//   大建, 理家, 信徒, 行市
  { {0xf4aa000e,0xfa6b8001,0xf5957001,0xf9427005}},	//   術開, 酵母, 默耕, 三北
  { {0xf932e001,0xf4b78001,0x00000003,0x00000003}},	//   多商, 賞鯨,   ,
  { {0xf83dc005,0xf5b1700c,0x00000003,0x00000003}},	//   坡上, 尾草,   ,
  { {0xfa636009,0xf9447009,0xfa62e00c,0xf9150005}},	//   争性, 前完, 崇深, 施大
  { {0xfb647006,0xfa51a004,0x00000003,0x00000003}},	//   犯罪, 比拼,   ,
  { {0xf936200e,0xfa69a004,0xf4c44004,0xf93f9005}},	// [1370] 官公, 收期, 越野, 七号
  { {0xfb64d006,0xf839c007,0xf8460009,0xfb713009}},	//   利益, 入企, 周一, 演示
  { {0xfb7a3007,0xfb66f007,0xf5c43005,0xf5bcd005}},	//   一科, 物種, 微薄, 造行
  { {0xf8243009,0xfb70f001,0xf5c79008,0xfb5d1004}},	//   不上, 且符, 全豪, 欠税
  { {0xfb5c1006,0xfb4db00e,0xf92ea001,0xf93e7005}},	//   大的, 網羅, 向健, 了光
  { {0xf491a001,0xf9222004,0xf5b25005,0xf4a9000a}},	//   山風, 遭受, 款超, 酒運
  { {0xf914000c,0xfa5ca00d,0x00000003,0x00000003}},	//   能展, 布情,   ,
  { {0xf93e7009,0xf5c4d005,0xfb89300a,0x00000003}},	//   的六, 天行, 序盤,
  { {0xf919a007,0xf9130001,0xfb523004,0xfb5eb005}},	//   春夏, 房客, 調研, 加用
  { {0xf929c00c,0xf93e100c,0xf4af200c,0xfb62b00c}},	//   含大, 心可, 林青, 業素
  { {0xf948b009,0xf929600c,0x00000003,0x00000003}},	//   每公, 周延,   ,
  { {0xf93bd006,0xfb73f001,0xf909200c,0xf91d800a}},	//   市商, 力系, 其各, 大助
  { {0xfa836006,0xfb4af001,0xfa7d200c,0xfa70a00c}},	//   是指, 年約, 春水, 東昇
  { {0xf9206009,0xf9495004,0xf943d001,0xf8468001}},	//   校学, 式基, 看商, 種人
  { {0xf5b77005,0xf4a5a005,0x00000003,0x00000003}},	//   人近, 利集,   ,
  { {0xfb693007,0xf59f3005,0xfb67f00c,0x00000003}},	//   自租, 分装, 表目,
  { {0xfb58f006,0xfa63200c,0xfa6e2005,0xf8153005}},	// [1380] 人空, 光業, 年整, 舟七
  { {0xfa89e001,0xf945f005,0xfb81300a,0x00000003}},	//   溪湖, 及器, 有紀,
  { {0xf83bc004,0xf9411001,0xfa81c004,0xf823d005}},	//   学作, 者張, 院治, 之余
  { {0xf90c6004,0xf93a700c,0xf5b5f00c,0xfa5a8005}},	//   年天, 一夕, 出車, 送旅
  { {0xf5a8900f,0xf9350009,0xf9382005,0xfa7a000d}},	//   然而, 食堂, 思列, 以指
  { {0xfa544005,0x00000003,0x00000003,0x00000003}},	//   写成,   ,   ,
  { {0xfa622005,0xf8355005,0xf5c5700c,0xf58e700c}},	//   万欧, 刻不, 浮腫, 源起
  { {0xfa700006,0xfa5ca007,0xfb5e3007,0xfa844005}},	//   新村, 一整, 大盤, 可投
  { {0xf917a00e,0xf9214004,0xfb529004,0xfa71c001}},	//   頻度, 信地, 国福, 山森
  { {0xf9176009,0xf5a67004,0xf5b25001,0xfa64a00c}},	//   特市, 下花, 東誠, 有整
  { {0xf911a009,0xfa4c8004,0xf90ea008,0xf9266001}},	//   地出, 他把, 河内, 部各
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf594b00f,0xfa83c007,0xfa656001,0xfa4da00c}},	//   忘記, 業新, 手札, 北橋
  { {0xf49a0009,0xfa656001,0xf59dd00a,0xf92dc00c}},	//   方都, 牌服, 境自, 源出
  { {0xfa4f8006,0xfa72a001,0xfb571004,0xfb74d00c}},	//   林木, 施技, 船税, 生福
  { {0xf93a700f,0xf944b00e,0xf911a009,0xfa4fa004}},	//   品必, 下北, 己在, 得本
  { {0xf80ff004,0xfa592004,0xf83de004,0xfa894005}},	// [1390] 南中, 州海, 次不, 在泰
  { {0xfa82c00c,0xfb5a500c,0xf5c33010,0x00000003}},	//   席次, 方環, 硬質,
  { {0xfa65a00c,0xfa6a800c,0xfa69a00c,0xf4a2600c}},	//   事性, 低油, 男歌, 面防
  { {0xfa77c001,0xfa89c001,0xfb59500c,0xf80eb00c}},	//   人比, 漫步, 方無, 算作
  { {0xfb525001,0xf8267004,0xf93c700c,0xf4c5c002}},	//   細細, 踏上, 一具, 二送
  { {0xf91be008,0xfa7fc004,0xf93a3005,0xf843000a}},	//   敦子, 院教, 梁市, 業以
  { {0xf91c0006,0xf94a5009,0xfa6c600e,0xf4b26008}},	//   入学, 明出, 究極, 多量
  { {0xfb6e300c,0xf5901005,0x00000003,0x00000003}},	//   朗的, 祖英,   ,
  { {0xf59af001,0xf91e2004,0xf90f8004,0xf931e005}},	//   作職, 学危, 撰写, 塔山
  { {0xfa828009,0xfa6bc004,0x00000003,0x00000003}},	//   六是, 海波,   ,
  { {0xf916600b,0x00000003,0x00000003,0x00000003}},	//   人式,   ,   ,
  { {0xf910a007,0xf4be6004,0xf4c56005,0xf912800c}},	//   農地, 超速, 上非, 共度
  { {0xf82eb00f,0xfa4f8001,0xf945500c,0xfb63d00a}},	//   地上, 化書, 合家, 本給
  { {0xfb7f7009,0xfa884009,0xfb75f001,0xf945f001}},	//   内置, 在校, 教社, 跌幅
  { {0xf93b9008,0xf827f010,0x00000003,0x00000003}},	//   品化, 野仁,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf4aa0001,0xf938e005,0xf816f002,0x00000003}},	// [13a0] 豪雨, 所希, 初七,
  { {0xf945d00a,0xf93fb005,0xfb77b00c,0xfa66e00c}},	//   上北, 内形, 增置, 族所
  { {0xfb59f004,0xfa676004,0xf5c09005,0xf4a6e00a}},	//   特稿, 里是, 口老, 風通
  { {0xf4c7800f,0xf92fc001,0xfa6c2004,0xfa6b6001}},	//   意願, 南宮, 年或, 整棟
  { {0xf945d00b,0xf941f009,0xf8231005,0x00000003}},	//   個室, 等功, 王三,
  { {0xf814300f,0xfa662001,0xf58f700c,0xfa78c005}},	//   記住, 反抗, 剖腹, 建性
  { {0xf5ba9006,0xf944f004,0xf949d004,0x00000003}},	//   船舶, 程在, 量好,
  { {0xf90e600f,0xf48c2009,0xfb6f3004,0xfa5fc001}},	//   債券, 暴雨, 何看, 理民
  { {0xf9204004,0xf4b9e004,0xf9459001,0xfa64e008}},	//   次加, 要配, 見度, 車教
  { {0xfa6a4004,0xfa722001,0xfa7b000c,0xfa5d4005}},	//   康指, 新東, 典格, 包有
  { {0xfb777007,0xf4a4200c,0x00000003,0x00000003}},	//   星空, 短靴,   ,
  { {0xfb57900f,0xfa872009,0xfb4c7008,0xf90f4004}},	//   司版, 您提, 康相, 数千
  { {0xf4aa2009,0xfa580001,0xfa62a004,0xf591d00c}},	//   薪酬, 夜情, 有或, 力超
  { {0xf80a1009,0xf837d008,0xf5c83004,0xf919600d}},	//   道上, 主主, 太行, 以反
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa556008,0xf83ab008,0x00000003,0x00000003}},	//   備校, 常任,   ,
  { {0xf9380007,0xf943b004,0xf91b200a,0xfa888005}},	// [13b0] 熟女, 又在, 日外, 火材
  { {0xf90ea004,0xfb515008,0xf9308005,0x00000003}},	//   地安, 調症, 林基,
  { {0xfb817006,0xf8400004,0xfa67c005,0xf833f005}},	//   分点, 次中, 和武, 好五
  { {0xfa708009,0xf4922004,0xf90b2001,0xfa66a001}},	//   育新, 地防, 場分, 配業
  { {0xf4bc4007,0xfb721004,0xf8243004,0xf942d001}},	//   各里, 会立, 守中, 安宮
  { {0xf9451009,0xf930c007,0xf9324004,0xf93d900c}},	//   守国, 答客, 会前, 七夕
  { {0xf9378004,0xf4a50001,0xf9152004,0xf9198004}},	//   作再, 可面, 好建, 方大
  { {0xf5c4f007,0xf49be00c,0xfa4aa00c,0xf91e600c}},	//   肩背, 大送, 楓情, 湧出
  { {0xfa68c009,0xfa7f8004,0xf488a005,0xfa6ca00c}},	//   量是, 亡或, 其配, 場業
  { {0xfa868009,0xf925c004,0x00000003,0x00000003}},	//   置方, 天多,   ,
  { {0xfb74d00e,0xfa71c004,0xfb87d001,0xf5ca100c}},	//   務用, 平整, 碎碎, 腫脹
  { {0xfa7aa001,0xfa594001,0xf4c4600c,0xfb843005}},	//   常春, 府推, 及需, 母羊
  { {0xfb6d5004,0xf9234005,0xfa854005,0xf93e700c}},	//   化率, 中吸, 是控, 的庭
  { {0xf825700f,0xfa678006,0xfa6bc001,0xfb83b008}},	//   合併, 前款, 場成, 立病
  { {0xf49c0008,0xfa4e0001,0xf4a8e00c,0xfa63e00c}},	//   室長, 著時, 自高, 草書
  { {0xf9152006,0xfa54a007,0xf942b001,0xf944f004}},	//   任免, 察服, 有庫, 立全
  { {0xfb52d006,0xf82bb005,0xf58bf00c,0x00000003}},	// [13c0] 好的, 件使, 划船,
  { {0xf9234004,0xfb87d004,0xf93b0004,0xf811d00c}},	//   京八, 及直, 市嘉, 動代
  { {0xf9128006,0xfb70d008,0xfb6c3001,0xfa514005}},	//   称号, 供等, 習社, 五方
  { {0xfb6a1004,0xfb781004,0xf909000a,0x00000003}},	//   易程, 速箱, 父市,
  { {0xfa7be004,0xf8191004,0xfb55b00c,0xfb51b00a}},	//   以控, 川人, 能申, 話用
  { {0xf497c00e,0xf92e8009,0xfa720001,0xfb723001}},	//   人達, 向大, 共振, 動登
  { {0xf947f007,0xf92ea001,0xf4b00005,0xfa81e005}},	//   名家, 鑑別, 北面, 院改
  { {0xf91f000f,0xfa6ee007,0xf4a5e005,0xfa67800c}},	//   你可, 音教, 部配, 重拾
  { {0xfa586001,0xfa70000a,0x00000003,0x00000003}},	//   神日, 甲板,   ,
  { {0xf929400f,0xfb5f1009,0xf819d009,0xfb5ab004}},	//   風味, 大篷, 送上, 学界
  { {0xfb633009,0xf489c004,0xfa674004,0xfa618004}},	//   短缺, 具配, 明月, 有清
  { {0xfb87d007,0xf497e004,0xf93e700c,0xfa80600c}},	//   意生, 油食, 境因, 臣氏
  { {0xfa72800c,0xfa710005,0x00000003,0x00000003}},	//   地更, 新梢,   ,
  { {0xf942b009,0xfa8b4001,0xfb657004,0xf918600c}},	//   草坪, 優格, 是缺, 刺客
  { {0xfa6e8007,0xfb51d007,0xf9126004,0xf48de00c}},	//   想持, 承租, 述声, 色高
  { {0xfb71b001,0xf9491001,0xf938a00a,0xfb4ed005}},	//   望的, 量加, 語吹, 郵箱
  { {0xfb61f009,0xfa6ce001,0xfb71f00d,0x00000003}},	// [13d0] 代物, 買東, 晚秋,
  { {0xfa52a001,0xf80db005,0x00000003,0x00000003}},	//   通情, 他依,   ,
  { {0xf945d004,0xf9340008,0xf90ba008,0xf923c001}},	//   不孕, 弘前, 直子, 臭味
  { {0xfa4c0007,0xf84a0001,0xf49d0008,0xf93a2001}},	//   我才, 叫人, 性限, 果出
  { {0xf945d004,0xf9140004,0xf945f004,0xfa684004}},	//   上受, 便地, 及在, 李文
  { {0xf599f00f,0xf91c2008,0xfa896005,0x00000003}},	//   府警, 牧市, 洪救,
  { {0xfa86000f,0xf58d700c,0xf9176005,0x00000003}},	//   早期, 得見, 曹妃,
  { {0xf58d900c,0x00000003,0x00000003,0x00000003}},	//   道花,   ,   ,
  { {0xf82b300f,0xfb78700a,0xf9396005,0xfb6f100c}},	//   援付, 凝縮, 州年, 引玉
  { {0xfb715009,0xfa5c8004,0xfa63000c,0xf929000c}},	//   法犯, 一扶, 合民, 媒合
  { {0xfb7c300f,0xf8339007,0xf8167005,0xf83a900d}},	//   的看, 似乎, 存亡, 判中
  { {0xf8135004,0xf48ee001,0x00000003,0x00000003}},	//   定作, 新郎,   ,
  { {0xfb80d009,0xfa7aa00c,0xf949f005,0x00000003}},	//   万科, 工打, 量平,
  { {0xf58d900b,0xfa7be004,0xf4ab8004,0xfa4de00c}},	//   列車, 慧敏, 成集, 道更
  { {0xfa81c00b,0xfa698004,0xfa602004,0xf92be004}},	//   面接, 小板, 者日, 道北
  { {0xfa678005,0xf830d005,0x00000003,0x00000003}},	//   同探, 拿不,   ,
  { {0xfa87e004,0x00000003,0x00000003,0x00000003}},	// [13e0] 全景,   ,   ,
  { {0xf90e6005,0xf91be00c,0xf599b00c,0xfa80800c}},	//   佳品, 別加, 所講, 連流
  { {0xfa54e00f,0xf5c29004,0x00000003,0x00000003}},	//   生所, 院起,   ,
  { {0xfa62a009,0xfa58c007,0xf4a9e002,0x00000003}},	//   玉林, 稀有, 毒集,
  { {0xf939e006,0xf92c0006,0xf938e00f,0xfa62e006}},	//   一定, 成功, 一律, 效期
  { {0xf5b5100b,0xf5bd900f,0xf93a8007,0xfa63a004}},	//   活躍, 照表, 要分, 下情
  { {0xf82b3004,0xf943d005,0x00000003,0x00000003}},	//   破万, 及合,   ,
  { {0xf5bcd00c,0xf4bd000c,0x00000003,0x00000003}},	//   惠而, 的震,   ,
  { {0xf941f009,0xfa6fe001,0xfa53c005,0xfa65c005}},	//   等原, 防方, 些活, 介活
  { {0xf93ed01c,0xfb58d00c,0x00000003,0x00000003}},	//   商品, 軸線,   ,
  { {0xf90fe006,0xf4ae0009,0xfb667005,0xf91a8002}},	//   女士, 化道, 天窗, 方制
  { {0xf9278007,0xfa4e0005,0xf499200c,0xf842800a}},	//   全店, 唐河, 幹連, 波乱
  { {0xf4b38004,0xf9457008,0xf5a23004,0xf8159004}},	//   余震, 態勢, 有近, 神上
  { {0xfa69000b,0xf91e8009,0xfa5bc004,0xfa5c4004}},	//   規模, 性建, 市清, 的掌
  { {0xfb48d006,0xf91cc007,0xf80bd007,0xfb517004}},	//   家税, 別平, 向下, 地群
  { {0xfa87e009,0xf9126004,0xf92be004,0xf92ae005}},	//   全是, 田家, 道南, 洪工
  { {0xfb57700e,0xf4ab8001,0xfb83d004,0xfa4d4004}},	// [13f0] 費無, 互連, 拉特, 金成
  { {0xf9296001,0xf93f000c,0xf4c1800c,0xf947d005}},	//   梨山, 各別, 安順, 而另
  { {0xf8440009,0xfa6f2004,0xf93e4005,0xf92c000c}},	//   本主, 新概, 它公, 我希
  { {0xfa54e007,0xf9370004,0xf59d5001,0xfa83200c}},	//   生技, 孟加, 送花, 湯旅
  { {0xfb6c1006,0xfa6fe007,0xfa694007,0xf942b001}},	//   染物, 唱歌, 夏日, 有快
  { {0xf934c006,0xfb82d005,0xfa76200c,0xfa88400c}},	//   域名, 奇石, 欺手, 紫斑
  { {0xfa4e200f,0xfb7b9001,0xfa89400a,0xf4b6a00c}},	//   五月, 技系, 八景, 吞食
  { {0xfb5c3006,0xfa64c005,0xf59f9010,0x00000003}},	//   性的, 上情, 約購,
  { {0xf943b001,0xf5a7b004,0xfa6c0008,0xf934e005}},	//   下商, 今起, 年比, 星小
  { {0xfa5dc00f,0xf8155001,0xf945f004,0xfa646008}},	//   情況, 務代, 及周, 拍手
  { {0xf917a005,0xfa5e6005,0xf821300d,0x00000003}},	//   点商, 雅思, 按住,
  { {0xfa5ea004,0xf946f001,0xfa67000c,0x00000003}},	//   病斑, 車出, 車方,
  { {0xf497e009,0xfa730001,0xf9354001,0xf91f2004}},	//   人首, 己想, 教宣, 次向
  { {0xf5b4100f,0xf90e6001,0xf9348001,0xf9378004}},	//   現象, 曲子, 期勉, 期建
  { {0xfa6ec007,0xfa6fe004,0xfa5ec004,0xf9346001}},	//   到手, 右旗, 市扶, 教徒
  { {0xf90aa00e,0xf9212009,0xfa5a8001,0xf930a001}},	//   年式, 院副, 一比, 動土

  { {0xfb4f700f,0xfa582007,0xf4b1c00d,0x00000003}},	// [1400] 地理, 府教, 力雄,
  { {0xf58f7001,0xf917a004,0xfa628001,0xfa7fa004}},	//   字表, 方均, 有比, 面情
  { {0xf911a004,0xf922c001,0xf81d5004,0xf90a4005}},	//   地基, 犯嫌, 者上, 收外
  { {0xf5bb3001,0xfa65a005,0xfa71e00c,0x00000003}},	//   入自, 名民, 精技,
  { {0xf9268006,0xfa726009,0xf4b78004,0xf90b600c}},	//   部分, 栽植, 属部, 具套
  { {0xf4c2c004,0xfa894004,0xf924e004,0x00000003}},	//   先通, 八是, 公德,
  { {0xf9316001,0xfb709004,0xf59d1004,0x00000003}},	//   五常, 志社, 黄豆,
  { {0xfb753006,0xf90a6001,0xfa620005,0x00000003}},	//   期的, 具分, 泉村,
  { {0xfa4b8006,0xfb57500f,0xf93f8006,0xfb75300f}},	//   材料, 她的, 率先, 真的
  { {0xf9108001,0xf93c2004,0x00000003,0x00000003}},	//   報分, 市定,   ,
  { {0xf944d004,0xf94a5004,0xfa698004,0xf48ee00c}},	//   上商, 李建, 谷歌, 曲風
  { {0xf93b200c,0xf921c00c,0x00000003,0x00000003}},	//   時反, 衣店,   ,
  { {0xf5aa300f,0xf8488009,0xfa5f8005,0x00000003}},	//   描述, 在任, 集思,
  { {0xfb883009,0xfa72c001,0xfa63800a,0x00000003}},	//   明理, 能持, 開求,
  { {0xf5b0d009,0xf80c1007,0xf94a5004,0xfa72000c}},	//   新路, 近一, 明基, 報業
  { {0xf9148006,0xf59c7004,0xf4b24008,0x00000003}},	//   社区, 市近, 通量,
  { {0xf5c05007,0xfa5dc001,0xfa866004,0xfa5de004}},	// [1410] 業行, 布拖, 是水, 清清
  { {0xfb68d004,0xf4c2200c,0x00000003,0x00000003}},	//   用百, 丈量,   ,
  { {0xf4c06009,0xfa62600c,0xfb81f00c,0x00000003}},	//   商部, 光棒, 沈積,
  { {0xf5a67009,0xfb74100c,0xfb581005,0xf926800a}},	//   同胞, 力特, 医特, 縮尺
  { {0xfa660004,0xf9437001,0xfa7b0004,0xf832d00c}},	//   位未, 合外, 接投, 款作
  { {0xf90ba006,0xf5bd9008,0xf812f004,0xf9312001}},	//   年增, 加資, 多余, 研判
  { {0xf5a31001,0xfa4ea004,0xf499c00c,0xf91d6010}},	//   手車, 滑油, 急送, 欠如
  { {0xf91ae004,0x00000003,0x00000003,0x00000003}},	//   度小,   ,   ,
  { {0xfb5eb006,0xfa7d0004,0xf5a3900c,0xf9170005}},	//   占用, 以水, 友要, 容城
  { {0xfa524009,0xfa888005,0xf814500d,0x00000003}},	//   四期, 在春, 沙井,
  { {0xf92ac006,0xfa7b6007,0xfb82b001,0xfa4ac002}},	//   酒店, 室書, 築用, 青溪
  { {0xf9324004,0xf493a001,0xf83b900a,0xfa4c200c}},	//   会反, 都非, 室乾, 我每
  { {0xfa556007,0xf9350004,0xf940e005,0xf9288005}},	//   期指, 食市, 内共, 自参
  { {0xf5a27007,0xf835b005,0xf92a800c,0xfa6e2005}},	//   載著, 国乳, 快地, 曲江
  { {0xf83cb009,0xfa73c005,0xf91c6010,0x00000003}},	//   珠三, 能材, 健司,
  { {0xfb4f3009,0xfa77c004,0xf48ee004,0x00000003}},	//   走私, 区抗, 新野,
  { {0xfa70e001,0xf8317005,0xf93ac005,0xf9166002}},	// [1420] 山機, 械信, 言只, 出局
  { {0xf5b97007,0xfb58f004,0xf58c5001,0xf92f800c}},	//   健行, 区特, 間設, 準基
  { {0xf82d1001,0xf90c000c,0xf59d700c,0x00000003}},	//   已下, 家平, 情行,
  { {0xf5a69004,0xf919600c,0xfb76f00c,0x00000003}},	//   王菲, 人兼, 朝的,
  { {0xfa622001,0xf9146004,0xfb6a3001,0x00000003}},	//   合時, 昼夜, 自第,
  { {0xf9266009,0xf81bf004,0xf91bc00c,0x00000003}},	//   周内, 市余, 座小,
  { {0xfa55e009,0xf5a47004,0xfb857005,0xf491a005}},	//   生村, 及要, 上科, 影部
  { {0xfa754007,0x00000003,0x00000003,0x00000003}},	//   治所,   ,   ,
  { {0xf92c0001,0xf8213004,0xf8355001,0xfa508001}},	//   成原, 理交, 系一, 託書
  { {0xf82b7005,0xf59f9005,0x00000003,0x00000003}},	//   段不, 考英,   ,
  { {0xf5c47004,0xf4c5600c,0x00000003,0x00000003}},	//   催芽, 配通,   ,
  { {0xfa5ce001,0xf92da005,0xf5afd005,0x00000003}},	//   時注, 材出, 甲胺,
  { {0xfb751006,0xfb85f004,0xf92fe004,0xf49b8004}},	//   定点, 刊用, 南公, 学高
  { {0xfb84b006,0xfa5ec004,0xf93f8005,0xf92ea005}},	//   之窗, 内成, 了存, 受力
  { {0xf5bad005,0xf4c28005,0x00000003,0x00000003}},	//   坦言, 版集,   ,
  { {0xf5b0100f,0xf9224005,0x00000003,0x00000003}},	//   細胞, 本做,   ,
  { {0xf93c8007,0xf9246004,0x00000003,0x00000003}},	// [1430] 心心, 路全,   ,
  { {0xf939000f,0xfb5a3009,0xf821b004,0xf5ca3008}},	//   回到, 油田, 了便, 縫製
  { {0xf590100b,0xfa864004,0xfa612001,0xf81a1005}},	//   世話, 是收, 者更, 十不
  { {0xf91d6004,0x00000003,0x00000003,0x00000003}},	//   大夫,   ,   ,
  { {0xfa87a008,0xfa69a004,0xf9196004,0xfb80b001}},	//   審決, 小汽, 油大, 超細
  { {0xf916400e,0xfb4f1009,0xf5a65008,0xf8243005}},	//   人前, 新突, 前臨, 把不
  { {0xfa4be006,0xf814f001,0xf5b31004,0x00000003}},	//   成果, 付保, 脱落,
  { {0xf8113007,0xf5ad1009,0xfa77c004,0xfa7c800c}},	//   委任, 育行, 瞻性, 因消
  { {0xf4be4004,0xf92b4005,0xfa4ea005,0xf5b1500a}},	//   内高, 当回, 村活, 簿記
  { {0xf8488009,0xf93b0008,0xf8291004,0xf912600d}},	//   在主, 市吉, 美体, 就座
  { {0xf942400a,0xfa648002,0xf92d2002,0xfa7a2002}},	//   複層, 前才, 我原, 方澳
  { {0xfa682005,0x00000003,0x00000003,0x00000003}},	//   李毅,   ,   ,
  { {0xf80e9007,0xfa4f8001,0xf4b68001,0xfb83d004}},	//   科主, 取書, 增高, 残留
  { {0xf5c3300b,0xfa6a8007,0xfa680008,0xfa6d4004}},	//   公表, 迷思, 不整, 康水
  { {0xf5a93007,0xfb5ed009,0xf9430004,0xfb7a9001}},	//   富貴, 院等, 安公, 言研
  { {0xf9445001,0xf93b000c,0xfb61100d,0x00000003}},	//   光山, 技公, 客票,
  { {0xf821b004,0xfa782004,0xf9430005,0x00000003}},	// [1440] 了使, 核意, 王先,
  { {0xf5c51001,0xfb56100a,0xfa82c00c,0xf846a005}},	//   可解, 人程, 代步, 在供
  { {0xfa82a007,0xf926c005,0xf90ce00c,0xf5a81005}},	//   代性, 在博, 整座, 税要
  { {0xf9286001,0x00000003,0x00000003,0x00000003}},	//   周大,   ,   ,
  { {0xfa67a00f,0xf9112007,0xf9142007,0xf9344001}},	//   行業, 房市, 格分, 定差
  { {0xfb56b00f,0xfb7d5005,0xfa79c005,0x00000003}},	//   示範, 品称, 數濮,
  { {0xfb54500f,0xf944f009,0xfa6b8001,0xfb4ef001}},	//   幼稚, 立在, 件方, 到美
  { {0xf92b600e,0xf93be004,0xfb895005,0xfa5d2005}},	//   子市, 布吉, 式空, 心期
  { {0xf93c600b,0xf947b004,0xf5a13004,0xf92d2008}},	//   門家, 上具, 了警, 少子
  { {0xfa80a00f,0xfa66c007,0xf4aa8001,0xf92d2005}},	//   業流, 行成, 青青, 民子
  { {0xf947d00b,0x00000003,0x00000003,0x00000003}},	//   不具,   ,   ,
  { {0xf4a08008,0xf82f7004,0xf93a2001,0xf4a5200c}},	//   信電, 新了, 果基, 天送
  { {0xf946f004,0xf9432008,0xfb77b001,0xfb53b00a}},	//   同外, 國屋, 思科, 都筑
  { {0xf92c4004,0xf92d800c,0xf596f00c,0x00000003}},	//   少吃, 術報, 願調,
  { {0xf5a89007,0xfa7cc001,0xfa64c001,0xfb741004}},	//   量表, 你把, 名時, 定用
  { {0xf93f000c,0xfa686010,0xfa5a2002,0xf4bda00d}},	//   約大, 富永, 府活, 者透
  { {0xf58f300e,0xf49c6001,0xf5c5f005,0xf920a005}},	// [1450] 動脈, 別選, 是至, 渡区
  { {0xf919800c,0x00000003,0x00000003,0x00000003}},	//   出報,   ,   ,
  { {0xf945000e,0xf93ae009,0xf921400c,0x00000003}},	//   之助, 持力, 業多,
  { {0xf90cc001,0xf919a00c,0x00000003,0x00000003}},	//   宴客, 室借,   ,
  { {0xf93a4007,0xf4a8e007,0xf4c64004,0xf942e005}},	//   府出, 自願, 行高, 予厚
  { {0xf948b00f,0xfa87e006,0xf93f2007,0xf48cc001}},	//   行女, 用本, 組別, 混音
  { {0xf9142004,0xf5b8700c,0xfa85200c,0xfa780005}},	//   能受, 券超, 摩技, 改期
  { {0xfa7a6006,0xf8265004,0xf9477005,0xf5c9d00c}},	//   点新, 把中, 富差, 循著
  { {0xfa5e6007,0xf9360009,0xf5bc9004,0x00000003}},	//   待機, 生子, 以至,
  { {0xf4b28008,0xf943e008,0xf942e004,0xf91e400c}},	//   掛金, 立候, 立合, 照度
  { {0xfa564008,0xf8247005,0xf4b3200a,0xf90c0002}},	//   期演, 合交, 牛革, 場展
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb82f00f,0xf830d004,0xfb6d500c,0x00000003}},	//   先生, 足人, 取率,
  { {0xf58f300f,0xf5a6b008,0xf83a7004,0xf934c008}},	//   店街, 床試, 接会, 軟式
  { {0xfa74c009,0xf48ec00d,0x00000003,0x00000003}},	//   能正, 田里,   ,
  { {0xf90c600c,0x00000003,0x00000003,0x00000003}},	//   柴可,   ,   ,
  { {0xf5a3f001,0x00000003,0x00000003,0x00000003}},	// [1460] 合設,   ,   ,
  { {0xf8431004,0xf839b008,0xf919e004,0xfa756004}},	//   中主, 点以, 点券, 追施
  { {0xf941c004,0xfa608004,0xf5b69004,0xf823d005}},	//   三定, 了您, 区考, 争使
  { {0xf9234007,0xfa79c004,0xf93aa00c,0x00000003}},	//   業典, 区段, 送商,
  { {0xf9234001,0xf9246004,0xfa5de00a,0xf934a005}},	//   祭典, 路器, 如来, 站只
  { {0xf8361007,0xf938c008,0xfa602004,0xf92f4001}},	//   值任, 着型, 者接, 近地
  { {0xfa728009,0xf9206001,0xf93f2004,0xfa6e6005}},	//   地整, 你到, 者受, 犵數
  { {0xf5a47007,0xf9270004,0xf93b6004,0xf49e000c}},	//   上言, 目地, 要引, 控面
  { {0xfa550004,0xf4ae4004,0xf4c78001,0xf934a001}},	//   会根, 南雄, 后里, 料外
  { {0xf8413004,0xf9214004,0xf83e5004,0xfa4f6001}},	//   中供, 中博, 大任, 捕手
  { {0xf8205009,0xf5901001,0xfa672004,0xf91fc00a}},	//   万余, 五街, 位根, 員全
  { {0xf910a007,0xf4c1c001,0xf9162004,0xf928e001}},	//   共分, 先開, 区同, 骨幹
  { {0xfa51e009,0xf58d3001,0xf943400c,0x00000003}},	//   会消, 取者, 手後,
  { {0xf5a9500c,0xf91ea00c,0xfa880005,0x00000003}},	//   低耗, 無分, 表是,
  { {0xfa7c8007,0xfa640001,0xfa574004,0xf80cd00c}},	//   入松, 位消, 期性, 鎖住
  { {0xfb86d00f,0xf9128001,0xfa7b8008,0xfa7f6001}},	//   刊登, 報室, 略本, 胡椒
  { {0xf9282004,0xfa888004,0xf91e6001,0xf815f005}},	// [1470] 利好, 在查, 校各, 属一
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb4ed006,0xfb651009,0xfb4fd007,0xfa76e004}},	//   防火, 利税, 東立, 人指
  { {0xfa8ac006,0xfb4af001,0xfb84500c,0xf93f800a}},	//   未来, 島監, 態生, 桃山
  { {0xfb73f004,0xf9270005,0xf936400c,0xfa5cc00c}},	//   毛竹, 器回, 租套, 考情
  { {0xf9497006,0xf9150006,0xf93a4009,0xf91ba009}},	//   明天, 能否, 壁市, 控告
  { {0xf926c009,0xfa69e004,0xfb899001,0xf940c00a}},	//   在做, 其提, 小社, 茉奈
  { {0xf93ee00f,0xfa6e4006,0xf4b74007,0xfa534001}},	//   概念, 申明, 高音, 料時
  { {0xf597f007,0xf81c5001,0xf590f005,0xfb4a500c}},	//   土耳, 約下, 井街, 更積
  { {0xf81d3007,0xfa5b600c,0x00000003,0x00000003}},	//   它作, 品投,   ,
  { {0xf9204006,0xf93fe001,0xfb4bf00c,0x00000003}},	//   中型, 各島, 練研,
  { {0xf4a2c00e,0xf937a00c,0xfb709005,0xfa78e00c}},	//   本酒, 借券, 南特, 基改
  { {0xfa64c004,0xf5a47004,0xf80cb004,0xf5a7100c}},	//   上清, 予警, 化不, 里自
  { {0xf8377009,0xf91d6001,0xf4ad6004,0xf59f1008}},	//   固体, 你心, 村青, 装自
  { {0xf81ed004,0xf58e500c,0xfb7b3005,0xf5a17005}},	//   商一, 受者, 送科, 隆胸
  { {0xf944800b,0xfa5c4001,0xf843d004,0xf5985005}},	//   前後, 私校, 良作, 甜菜
  { {0xf8253009,0xfa676007,0xfa884005,0x00000003}},	// [1480] 而上, 里斯, 天泰,
  { {0xfa6b2009,0xf5c31004,0xfa7a6004,0x00000003}},	//   年文, 公自, 略思,
  { {0xf8453006,0xf9324004,0xf5bdf001,0xfb7f7008}},	//   路交, 会再, 員認, 射精
  { {0xf843d00e,0xf5973009,0xfb871001,0xf80eb001}},	//   副作, 聘英, 乏的, 林依
  { {0xf8271009,0xf5c8b001,0xf4b64001,0xf9380005}},	//   名交, 膨脹, 舞集, 牟平
  { {0xfa62e006,0xfa678008,0xfa872004,0xf5c7b00a}},	//   程有, 再放, 部提, 全表
  { {0xfb6d3006,0xf4c8800e,0xf9440001,0xf9224001}},	//   外的, 族館, 下定, 業利
  { {0xf9212006,0xf91f200a,0x00000003,0x00000003}},	//   中存, 信子,   ,
  { {0xfa4b0004,0xf91b2001,0xf80c1004,0xf4bfa001}},	//   体思, 入字, 村低, 理食
  { {0xf91a0004,0xf5ab9001,0xf5b79005,0xfa708005}},	//   入各, 長輩, 去解, 地或
  { {0xfa836007,0xfa71200e,0xf946a00a,0x00000003}},	//   可拆, 報提, 克己,
  { {0xf930800e,0xfa65e004,0xf9132005,0x00000003}},	//   何回, 型活, 都商,
  { {0xf8427001,0xf920e004,0xfb4e3001,0xf93b600c}},	//   正代, 波外, 色生, 要展
  { {0xf8149006,0xfa634004,0xf91c6005,0xf48ec00c}},	//   定代, 案提, 大官, 米香
  { {0xf91a000c,0xfa56e00c,0xf5a2d00d,0x00000003}},	//   司公, 記書, 泉路,
  { {0xfa61a00f,0xf93c0005,0x00000003,0x00000003}},	//   又有, 所好,   ,
  { {0xfa61e004,0xfa820008,0xfb72500c,0xf9134005}},	// [1490] 效明, 漢方, 展精, 山峰
  { {0xfb795004,0xfb74f004,0x00000003,0x00000003}},	//   保社, 定登,   ,
  { {0xfa4da006,0xfb5cd004,0xf9138004,0xf5a87001}},	//   字母, 学第, 稽察, 量自
  { {0xfb5bb009,0xf9282004,0xf49ba005,0xfa6ba005}},	//   欧美, 雨季, 学通, 家核
  { {0xf92b800f,0xfa64a005,0xfb7c500c,0xf9368005}},	//   自己, 予治, 求神, 真填
  { {0xfb87100f,0xf49c800c,0xf58f1005,0xf5b79010}},	//   認知, 日都, 金落, 相葉
  { {0xf83e5009,0xfa870004,0xfa50e001,0xf93de005}},	//   大主, 周村, 著想, 内参
  { {0xf48a6007,0xfa830004,0xfa654001,0xf5a6300a}},	//   水里, 中查, 反折, 反論
  { {0xfb5b5004,0xfa5bc004,0x00000003,0x00000003}},	//   交相, 如擅,   ,
  { {0xf58f500b,0xf4a8000e,0xfb51d008,0x00000003}},	//   動車, 士通, 花編,
  { {0xf4a1400e,0xf944e007,0xf48fc008,0xfb6e9004}},	//   衣類, 重市, 乳首, 他物
  { {0xf9164004,0xf919a004,0xfb513004,0xf9290005}},	//   人反, 判刑, 新管, 未做
  { {0xf925600b,0xf91ac007,0x00000003,0x00000003}},	//   港区, 常出,   ,
  { {0xf9214004,0xfb837008,0x00000003,0x00000003}},	//   中做, 率直,   ,
  { {0xf944a00e,0xfb7f9004,0xf830d001,0xf935c001}},	//   始動, 内第, 女主, 記坪
  { {0xf4be6004,0xfb79d010,0x00000003,0x00000003}},	//   内通, 節痛,   ,
  { {0xf91a0006,0xf5b5900f,0xf9414009,0xfa71c001}},	// [14a0] 日内, 都能, 理健, 印書
  { {0xfa84000b,0xfb76f007,0xfb7e3005,0xfa62e005}},	//   本日, 神科, 求社, 等是
  { {0xfa56a00c,0xf4bf400c,0x00000003,0x00000003}},	//   備援, 球都,   ,
  { {0xf59a9004,0xfa8a6005,0xfb7d700c,0x00000003}},	//   持者, 洪波, 考科,
  { {0xfa5ec005,0xf8473005,0xf5a95005,0x00000003}},	//   内提, 利中, 家超,
  { {0xfa630001,0xf81f1001,0xf845300c,0xf9476005}},	//   友有, 情五, 早一, 李光
  { {0xfb7f900e,0xfa83a001,0xfa532008,0xf8333005}},	//   球環, 代收, 留所, 好些
  { {0xf4c24006,0xfb4a6008,0x00000003,0x00000003}},	//   有限, 年程,   ,
  { {0xf945c007,0xf8157004,0xf59ed001,0xf92b8001}},	//   里市, 州三, 心肺, 雪地
  { {0xf9462008,0xf8461005,0x00000003,0x00000003}},	//   不快, 物作,   ,
  { {0xf4be0006,0xf4c86009,0xf9222004,0xf4bde008}},	//   待遇, 小雨, 中含, 心部
  { {0xf92f6006,0xfb7a9007,0xf9276007,0xf9356004}},	//   金山, 一窗, 部展, 也存
  { {0xf58c700c,0xf5a57002,0x00000003,0x00000003}},	//   暖蛋, 行而,   ,
  { {0xfa5be006,0xf90e6006,0xf5aa7008,0x00000003}},	//   市文, 音像, 護衛,
  { {0xf933800a,0x00000003,0x00000003,0x00000003}},	//   尚子,   ,   ,
  { {0xf91b8006,0xfb659004,0xf8179005,0xf93cc005}},	//   大型, 器等, 也便, 雄心
  { {0xf942e006,0xfa848009,0xfa4f6001,0xf821f005}},	// [14b0] 有利, 是推, 取決, 升中
  { {0xf941a004,0xfa6ac00c,0xf59f9005,0x00000003}},	//   率在, 起民, 逃脱,
  { {0xf4bc600f,0xfb59f004,0xf930e004,0xf945e004}},	//   考量, 健的, 北国, 行参
  { {0xf5c8f00f,0xfa63e006,0xf92fc009,0xf9242004}},	//   部落, 及有, 南微, 本出
  { {0xf9334004,0xf830f008,0xfa82200c,0xfa5e8005}},	//   力差, 想以, 正港, 隆昌
  { {0xf92ec006,0xf9184004,0xf928400a,0xf596300c}},	//   村基, 券市, 利帳, 域評
  { {0xf492a00f,0xf8303007,0xf9110004,0xfa6ac002}},	//   能量, 由一, 使它, 海民
  { {0xfb66f008,0xf9246004,0xfa564005,0xfb85100d}},	//   物置, 路在, 速比, 合署
  { {0xfb57d00f,0xf4ada00e,0xfa7b2004,0xf945a001}},	//   書籍, 民館, 以推, 洋大
  { {0xfa75c00f,0xfa63c009,0xf944e004,0xfb7fb00c}},	//   任教, 事教, 之士, 各異
  { {0xf83d7009,0xfb879009,0xf9148004,0xf5ac100c}},	//   悠久, 行第, 社出, 伴著
  { {0xf83c5006,0xf4c66009,0xfa5cc004,0xfa7b6004}},	//   以便, 行通, 布文, 度指
  { {0xf9482001,0xf49d8005,0xf92aa00c,0xfa4d400c}},	//   操場, 加集, 打市, 視情
  { {0xfb5d9004,0xf9304001,0xfa70a00c,0xfa75400a}},	//   度相, 著大, 拿手, 現段
  { {0xf594900f,0xfb571009,0xf8179004,0xf91c0008}},	//   記者, 医用, 也使, 日大
  { {0xf5be3006,0xf91ce00a,0xfa66c00a,0x00000003}},	//   控股, 加希, 題提,
  { {0xf9470007,0xfa66c004,0xfb69300c,0xf946800a}},	// [14c0] 納入, 行提, 全由, 屋台
  { {0xf9358004,0xfa750005,0xfb66f005,0xfa896002}},	//   也做, 好春, 虫等, 木桶
  { {0xfa616004,0xf4a74005,0x00000003,0x00000003}},	//   了活, 在酒,   ,
  { {0xfa51400a,0x00000003,0x00000003,0x00000003}},	//   織改,   ,   ,
  { {0xf59f5009,0xf92fe007,0xf83f7008,0xf944800c}},	//   乃至, 字形, 賢一, 吉島
  { {0xf8413006,0xf8473009,0xfa74c00d,0x00000003}},	//   本上, 毫不, 格提,
  { {0xf839300b,0xf4b02001,0xfa866004,0x00000003}},	//   工事, 動集, 在旅,
  { {0xf9392009,0xf4a0e001,0xf5a63008,0xf8395008}},	//   属地, 口順, 態調, 除依
  { {0xfa760007,0xf9146001,0xf4c1a00c,0xfa66800d}},	//   值查, 精工, 理都, 重振
  { {0xf4ad0001,0xf9160004,0xf91c0005,0xfa73400c}},	//   外送, 都具, 学少, 追思
  { {0xfa61c00f,0xf917600e,0xf9296005,0xfa51600a}},	//   理想, 診察, 互式, 何本
  { {0xf93a8004,0xfa497008,0xfb51900c,0xf933600c}},	//   私分, 習所, 地空, 定土
  { {0xf916200b,0xfb69900e,0xfb57f004,0xfa76e001}},	//   購入, 倒的, 区用, 建教
  { {0xfa6f2009,0xfa5ca001,0xfb87d004,0xf8167001}},	//   新求, 一滴, 夏科, 神仙
  { {0xfa86a001,0xfb839001,0xf932c004,0xf9126005}},	//   宮書, 計研, 静安, 数家
  { {0xf92e600e,0xf92e0004,0xf91aa001,0xf94b2002}},	//   協同, 成好, 春回, 迎到
  { {0xfa7c2009,0xf91d2004,0xfa82200d,0x00000003}},	// [14d0] 查活, 旦大, 京文,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf942e00f,0xf91c8009,0xf5bbd004,0x00000003}},	//   有助, 大做, 以警,
  { {0xf93d2004,0xf93f2005,0x00000003,0x00000003}},	//   市利, 理内,   ,
  { {0xfa6ec009,0xfa4f6004,0xf58c900c,0xf9350005}},	//   防洪, 向海, 園買, 多建
  { {0xf9420001,0xf8393004,0x00000003,0x00000003}},	//   商地, 工之,   ,
  { {0xf912000c,0xf83ef005,0xfa75600c,0x00000003}},	//   使徒, 次作, 治概,
  { {0xfb88b001,0x00000003,0x00000003,0x00000003}},	//   量縮,   ,   ,
  { {0xfb825001,0xfa4ab001,0xf4c46008,0xf914400c}},	//   圈的, 棒棒, 立金, 政庶
  { {0xf4c6400c,0x00000003,0x00000003,0x00000003}},	//   行領,   ,   ,
  { {0xf80c7009,0xfa4e6004,0xf4c4e001,0xfb4d6004}},	//   少了, 他未, 屋部, 年相
  { {0xf5b6f009,0xfa5f6007,0xf9222005,0x00000003}},	//   点行, 的抽, 断取,
  { {0xfa68a001,0xf4996004,0xfb7b900c,0x00000003}},	//   家手, 常青, 一盤,
  { {0xfb5cb001,0xfb58d005,0xf4b2c005,0xfb5ab002}},	//   鳥瞰, 区移, 沙里, 司特
  { {0xfb72b006,0xf9462006,0xfb7d300e,0xfa59a004}},	//   多的, 今天, 要綱, 一指
  { {0xf91ae00f,0xfa68a00e,0xf845b009,0xfb81f001}},	//   常常, 制服, 在今, 理異
  { {0xf828100f,0xf91c0001,0xfa7fc001,0xf5ac1004}},	// [14e0] 配件, 入左, 加書, 架起
  { {0xf49bc007,0xf92f2001,0xfb7d300c,0xfb88f00c}},	//   急難, 我好, 心神, 礎科
  { {0xfb78300f,0xf8425008,0xfb82d00a,0xfb695005}},	//   竟然, 離乳, 例等, 在男
  { {0xfa5f4004,0xfa54200c,0xf4b1e00a,0xfb4f1010}},	//   燃放, 四房, 招集, 干物
  { {0xf9408006,0xf9414009,0xf4bfe004,0xf92cc001}},	//   万多, 理入, 的零, 間大
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf931400c,0xfb7fd005,0xf80d900c,0x00000003}},	//   織出, 者素, 著下,
  { {0xfa4d1007,0xf8175004,0x00000003,0x00000003}},	//   暑期, 榜上,   ,
  { {0xfb785004,0xf8117001,0xf939000c,0xfb50b00c}},	//   原状, 四一, 停受, 已然
  { {0xfb623007,0xf9472008,0xf5bef004,0xf5abb001}},	//   正第, 上司, 大葱, 然能
  { {0xfb5bd006,0xfa7c0004,0xfa820004,0xf4a10001}},	//   学生, 以治, 宣恩, 正通
  { {0xfb4be001,0xf5911005,0xf93a4005,0x00000003}},	//   其申, 何被, 所当,
  { {0xf825900e,0xfb7c3009,0xf83f5008,0xf4b42001}},	//   界一, 的王, 僧侶, 聚酯
  { {0xfa80e004,0xf81e7001,0xf9316005,0xfb6ab010}},	//   中旅, 理介, 何可, 道玄
  { {0xfa842004,0xfb7f1005,0xfa4cf005,0x00000003}},	//   京津, 心社, 策意,
  { {0xf5aef00b,0xfa72e001,0xfa5f2004,0xf4a3600c}},	//   新規, 承旭, 者或, 可順
  { {0xfb49e00f,0xfb83b00f,0xfb683009,0xfb537008}},	// [14f0] 然科, 看的, 士生, 己破
  { {0xfb6f5007,0xf8389004,0xfb85b005,0xf5a3100c}},	//   化系, 出信, 及答, 蛋蛋
  { {0xf81c1001,0xf59a9001,0xfa4d3001,0xfa71c00c}},	//   吃下, 墜落, 救救, 款服
  { {0xfa4e100f,0xfa52e001,0xfa5e2001,0xf5b69004}},	//   我是, 多指, 幅減, 格落
  { {0xfa7f200c,0xf93b800c,0x00000003,0x00000003}},	//   校成, 門別,   ,
  { {0xf814f00f,0xf81b1009,0xf94a000c,0x00000003}},	//   原住, 如今, 小地,
  { {0xfb7e9009,0xf59c500a,0x00000003,0x00000003}},	//   内生, 一話,   ,
  { {0xfb7f500b,0xf90ee006,0xf93c8009,0x00000003}},	//   装置, 地名, 流入,
  { {0xf91f4004,0x00000003,0x00000003,0x00000003}},	//   面小,   ,   ,
  { {0xf940e001,0xfa55400a,0xf4984002,0x00000003}},	//   安和, 定款, 吹鼓,
  { {0xfa4d7004,0xf928a004,0xf4caa001,0xf83a9008}},	//   向投, 在出, 崎駿, 左下
  { {0xf932600f,0xf9424004,0xf9100001,0xf9392004}},	//   招募, 先垂, 地增, 增就
  { {0xf81e700f,0xfb667009,0xfa69e008,0xf5c17001}},	//   理事, 票的, 起時, 馬行
  { {0xfa5e6006,0xfb4d000c,0xf58c3005,0xfb79d00a}},	//   的本, 具申, 墓葬, 磁界
  { {0xf80eb009,0xfb853001,0xfa57400c,0x00000003}},	//   向人, 合環, 租查,
  { {0xf488800d,0x00000003,0x00000003,0x00000003}},	//   制鞋,   ,   ,
  { {0xf90a8005,0xf5c4b00a,0x00000003,0x00000003}},	// [1500] 年反, 本英,   ,
  { {0xfa702008,0xf4b64004,0xf939000c,0xf941800c}},	//   熱意, 高院, 喜帖, 均含
  { {0xf9190009,0xf5a01005,0x00000003,0x00000003}},	//   示出, 率要,   ,
  { {0xf91da00f,0xf91a2009,0xf5a87008,0xfa7be00a}},	//   員合, 入分, 同購, 健次
  { {0xf93c6004,0xfb835005,0xfa4e900c,0xfa4f100c}},	//   流大, 三秦, 他注, 我找
  { {0xfb86500e,0xf92e2005,0xf5a69005,0x00000003}},	//   前編, 成平, 行跟,
  { {0xf4bce001,0x00000003,0x00000003,0x00000003}},	//   的魅,   ,   ,
  { {0xfa892006,0xf81b700c,0x00000003,0x00000003}},	//   表格, 係一,   ,
  { {0xfa75400f,0xfa65c004,0xf9460001,0xfa772005}},	//   系所, 事活, 型基, 方最
  { {0xfb7b1005,0xf597300c,0x00000003,0x00000003}},	//   局班, 真諦,   ,
  { {0xfa71000e,0xf839300a,0xf92e600c,0x00000003}},	//   即決, 工例, 我加,
  { {0xfa644007,0xf8439004,0x00000003,0x00000003}},	//   先採, 括中,   ,
  { {0xf845b006,0xf4b94007,0xfb69300e,0xf5c69001}},	//   在上, 一送, 部統, 用記
  { {0xfa7ac004,0xf58ef008,0xf945e005,0xf938a005}},	//   入成, 金調, 事出, 作回
  { {0xf48fa00f,0xf9318006,0xf599900f,0xf5b8d004}},	//   到高, 四十, 言者, 油路
  { {0xfa5d4006,0xfa830009,0xfb51b00c,0xfa6fe005}},	//   的思, 中日, 味競, 就明
  { {0xf492e008,0xfb508001,0xf90b2005,0xf9122002}},	// [1510] 山陽, 河管, 收大, 到女
  { {0xf930a001,0xf92dc004,0xfb7dd004,0xfa7aa00c}},	//   動原, 店式, 清的, 常接
  { {0xfa860006,0xf820b004,0xfb869004,0xf945a005}},	//   注明, 了修, 行生, 界十
  { {0xf948e005,0xfa5d8005,0xf5957010,0x00000003}},	//   行就, 魅族, 原資,
  { {0xf9226004,0xfa846004,0xfb510005,0x00000003}},	//   口公, 景洪, 平相,
  { {0xf9438005,0x00000003,0x00000003,0x00000003}},	//   吉大,   ,   ,
  { {0xfb851001,0xf90c600c,0x00000003,0x00000003}},	//   融理, 男入,   ,
  { {0xfa4c1009,0xf58c5001,0xf929e00c,0x00000003}},	//   民最, 紓解, 質外,
  { {0xf8467007,0xf4bf4004,0xf9418005,0xf91b2005}},	//   央主, 分集, 万利, 日化
  { {0xfa588007,0xf58c900e,0xf5c8f004,0xf9136004}},	//   作機, 角英, 填表, 能定
  { {0xfa878004,0xfb7a900c,0xfa86600d,0x00000003}},	//   在湖, 送筆, 在担,
  { {0xfa78e006,0xf4982001,0xf9284001,0xfa6c000c}},	//   建活, 吸頂, 義地, 傷患
  { {0xf5a3f009,0xf8297004,0xf80cb005,0x00000003}},	//   羊肉, 意以, 取不,
  { {0xf917e004,0xf48dc004,0x00000003,0x00000003}},	//   点多, 防静,   ,
  { {0xf93f8006,0xfb54500f,0xf49d0009,0xfb60b009}},	//   境影, 社群, 大酒, 模特
  { {0xf9278004,0xf92ae001,0xfa4dd00c,0x00000003}},	//   全宗, 未出, 俗技,
  { {0xf918a005,0xf4ae6005,0xf81d900c,0x00000003}},	// [1520] 出学, 抗逆, 求你,
  { {0xf925a009,0xf4c56007,0xf9232004,0xfa4d3001}},	//   在安, 行開, 中出, 子業
  { {0xfa6a4009,0xfa7c2004,0xf91da005,0x00000003}},	//   康教, 大旅, 渡安,
  { {0xfa4c900f,0xf9446007,0xf4a92004,0xfb53d004}},	//   恐怖, 合大, 在防, 款第
  { {0xf5c37007,0xf4c78004,0xf5b25001,0xfa81e00c}},	//   業製, 名都, 艾芙, 代推
  { {0xf93de009,0xfa54e001,0xfa62e004,0x00000003}},	//   球化, 生最, 立有,
  { {0xfa4c5006,0xfa858009,0xfa4c9009,0xfb53f001}},	//   子成, 是改, 湖泊, 政署
  { {0xfb605004,0xf917e00c,0xf942200c,0xf914400c}},	//   衣着, 司同, 片加, 都快
  { {0xfa55a00f,0xf4b80001,0xf9144001,0xf4958008}},	//   乙方, 原音, 能快, 製鋼
  { {0xfb61f004,0xf9128005,0xf49a2005,0x00000003}},	//   本理, 新巴, 除部,
  { {0xfb539008,0xfa7c2004,0xf4b0e008,0xf9192001}},	//   乾物, 交水, 供養, 工及
  { {0xf58e9008,0xf9242001,0xf812d004,0xfa67000c}},	//   提訴, 本基, 聚乙, 族求
  { {0xfa4db004,0xfa6fa00c,0xf9102005,0xfb5a700c}},	//   得明, 台托, 朱小, 此目
  { {0xf926800b,0xfb817009,0xf9318007,0xfb6f5001}},	//   央区, 爆竹, 講堂, 湖群
  { {0xfa7c2009,0xf9452004,0xf842f001,0xfa55e00c}},	//   以改, 上多, 連任, 托斯
  { {0xf92da009,0xf493000e,0xf92ae007,0xf59eb004}},	//   世博, 避難, 間均, 者近
  { {0xf4abc00e,0xfa5b8004,0xf92e8001,0x00000003}},	// [1530] 子高, 一性, 五名,
  { {0xfa800009,0xfb64d007,0x00000003,0x00000003}},	//   凡是, 助益,   ,
  { {0xf92e4006,0xf8301009,0xfa704005,0xfb77f005}},	//   子女, 就一, 使消, 夜的
  { {0xfb6f700f,0xf8403004,0xfa6f0008,0xfb605004}},	//   準確, 中上, 右折, 止生
  { {0xf8223001,0xfa788001,0xf9250001,0xf4a3a001}},	//   屈一, 常情, 普媒, 本連
  { {0xfb837007,0xfa4d3001,0xfa7ce004,0xf9240004}},	//   始終, 救我, 旧村, 硬度
  { {0xf59ab001,0x00000003,0x00000003,0x00000003}},	//   所表,   ,   ,
  { {0xf59e5007,0xfb7ef009,0xf825300e,0xfa5bc004}},	//   善良, 清算, 車保, 市梅
  { {0xfb4d6006,0xfa68e005,0x00000003,0x00000003}},	//   侵犯, 行慰,   ,
  { {0xf5bad00e,0xfb56b004,0xf9362001,0xfb7ab00a}},	//   誤解, 格申, 生園, 技用
  { {0xf92ec009,0xf4bf6004,0xf9284001,0xf9178001}},	//   化公, 密集, 彩印, 油切
  { {0xf4c8000f,0xf90e8008,0xf91ce004,0xfa54800c}},	//   富邦, 防寒, 靠前, 機手
  { {0xfa898009,0xf5bed009,0xfa64e004,0xf924e004}},	//   在更, 大足, 上文, 可公
  { {0xf928c004,0xf80c9001,0xf935c004,0xf943a005}},	//   在常, 救了, 高坪, 三建
  { {0xf91cc00f,0xfa5c8004,0xfa650004,0xf80ed005}},	//   造型, 一架, 不文, 取中
  { {0xfa7ee00e,0xf940a004,0xf91d8001,0x00000003}},	//   信機, 了孩, 巡守,
  { {0xf92fc004,0xf9210004,0xf49b600c,0xfb7eb00c}},	// [1540] 取国, 管好, 別適, 旅狐
  { {0xf93ea007,0xf92f8001,0xfa82000a,0xf940c005}},	//   分後, 湖基, 中湖, 居地
  { {0xfa81a004,0xf934a008,0xf593d00c,0xfa6cc00c}},	//   患排, 期型, 務講, 場正
  { {0xf829d007,0xfa60000e,0xf5ac300e,0xf948c001}},	//   家作, 文時, 競走, 界地
  { {0xfa79e007,0xf93fc004,0xfa796008,0xf5b15005}},	//   示更, 切忌, 若手, 女足
  { {0xfa69600f,0xf82b300e,0xfa86e009,0xf947c004}},	//   序方, 極上, 用期, 城小
  { {0xfa66e004,0xfa69a004,0xfa6a600c,0x00000003}},	//   量意, 零星, 件截,
  { {0xf4c4600e,0xf949400e,0xfb815004,0xf9118004}},	//   下限, 像度, 三的, 新奥
  { {0xf9202004,0xfb494004,0xf943e005,0xfa7a2005}},	//   中安, 瓶片, 有吸, 来指
  { {0xf5b7f001,0xf9174004,0xf921c001,0xfa5fa005}},	//   出表, 区土, 般市, 元新
  { {0xfa668006,0xf5bcd005,0xfa509005,0x00000003}},	//   前景, 以起, 得房,
  { {0xfa81e006,0xf940400e,0xf8365004,0xf5ac9001}},	//   本情, 理化, 区住, 浴設
  { {0xfb669009,0xf821b009,0xfa59800c,0xf92fe005}},	//   亮相, 合下, 作本, 北公
  { {0xf9454007,0xf9470004,0xfb4f800a,0xf4b6000c}},	//   先報, 名大, 憲章, 料都
  { {0xf933800f,0x00000003,0x00000003,0x00000003}},	//   四季,   ,   ,
  { {0xf9486009,0xf9358004,0xfb5cb005,0x00000003}},	//   意志, 期存, 学目,
  { {0xf92a8004,0xf90c2008,0xf5b7d001,0xfa4ef00c}},	// [1550] 当心, 護婦, 酸菌, 字成
  { {0xf5b35004,0xf823f005,0xfb55000c,0xf5b7d00a}},	//   曾被, 上予, 能符, 腸菌
  { {0xf930e009,0xf92ea004,0xf83df004,0xfa6fc005}},	//   受国, 五小, 管不, 山歌
  { {0xf81ef006,0xf8241009,0xfa87200e,0xfa4ed008}},	//   元以, 不予, 部材, 志村
  { {0xf4a5800a,0xf93ec005,0xf5a5100c,0xf9366005}},	//   修館, 分城, 合課, 留声
  { {0xf5c8f00e,0xfb50000c,0xfa84e005,0xfa5dc005}},	//   自衛, 到真, 助残, 市性
  { {0xfb4a6009,0xfb550004,0xf91e6004,0xf911e008}},	//   年秋, 任王, 大出, 百十
  { {0xf48e6005,0x00000003,0x00000003,0x00000003}},	//   洲金,   ,   ,
  { {0xf8245004,0xf8247004,0xf9338005,0x00000003}},	//   名事, 届一, 料内,
  { {0xf929c004,0xf8427005,0xf942200c,0x00000003}},	//   被判, 港上, 雇員,
  { {0xfa668007,0xf4c56009,0xf91e600a,0x00000003}},	//   才是, 程院, 冠動,
  { {0xfa4c9004,0xfa634004,0xf847500c,0x00000003}},	//   化手, 案材, 物代,
  { {0xf9174006,0xfa4eb001,0xfa5ae001,0xf832900c}},	//   区域, 彗星, 所支, 己人
  { {0xf5949001,0xfb74100c,0xf4a6400d,0x00000003}},	//   高者, 供社, 在逃,
  { {0xfa586009,0xfa5ec009,0xf93b8007,0xfb687004}},	//   作思, 商所, 流化, 在群
  { {0xf91f2006,0xf931c005,0xfa6c800a,0x00000003}},	//   面前, 比平, 痴漢,
  { {0xfa660004,0xfb7d3001,0x00000003,0x00000003}},	// [1560] 及早, 境生,   ,
  { {0xf918c00f,0xf4a1c004,0xfa78e00c,0x00000003}},	//   確度, 中青, 書機,
  { {0xfa70c00c,0xfa6dc005,0x00000003,0x00000003}},	//   房服, 防沙,   ,
  { {0xf5c39001,0xf93c8001,0xfa70a00c,0xf4a3a005}},	//   代買, 心境, 平性, 播音
  { {0xf9464006,0xf946a00c,0xfb76500c,0x00000003}},	//   不利, 態報, 料異,
  { {0xf8101005,0xfb51200c,0xf935a005,0x00000003}},	//   南代, 姿的, 期做,
  { {0xf8253009,0xf5a87007,0xfb5ad001,0xfa5e6004}},	//   同事, 行調, 工研, 的敬
  { {0xf947e006,0xf90aa004,0xf5a1b004,0xf940c001}},	//   再就, 年夏, 拉蒙, 梅山
  { {0xfa4b3004,0xf83b7005,0xf92de00d,0x00000003}},	//   当期, 大上, 或向,
  { {0xf941a007,0xfa80c004,0xf91c2004,0xfa676005}},	//   月光, 代教, 入室, 牌是
  { {0xf4c10004,0xfb74b001,0xf92b2005,0x00000003}},	//   了那, 通盤, 道多,
  { {0xfa6e2004,0xf5b67001,0xf597d001,0xfa5c8001}},	//   年水, 格調, 熟能, 要接
  { {0xfb77d007,0xfb62d001,0xf93b8004,0xf819b005}},	//   租申, 業給, 要受, 品三
  { {0xf93f800f,0xfa52d00f,0xf5b27004,0xfa551005}},	//   心地, 通指, 能行, 生求
  { {0xf930c009,0xf4a94008,0xfa72e005,0xfa52300c}},	//   何媒, 浪速, 好旅, 底油
  { {0xfa888006,0xfa5c400b,0xfa702004,0xfa5ec00c}},	//   在接, 血液, 碰撞, 商技
  { {0xfa73400b,0xfb667004,0xf90b2001,0xf82df005}},	// [1570] 西日, 在理, 場商, 女上
  { {0xf946e005,0xfa7e400c,0x00000003,0x00000003}},	//   前加, 度收,   ,
  { {0xf928a004,0xf9112004,0xfb885005,0x00000003}},	//   在基, 足国, 界精,
  { {0xf82ed00f,0xf9470004,0xf5c07004,0xfa53b00c}},	//   細介, 上建, 炭行, 做比
  { {0xf8401009,0xf92de004,0xfa87000c,0x00000003}},	//   管中, 得十, 物湯,
  { {0xfb51000f,0xf48fc00f,0xf4c4600e,0xf81c3004}},	//   到第, 到通, 再開, 持中
  { {0xfb562007,0xf8245004,0xfb6c1001,0xf490c004}},	//   人看, 名下, 子真, 平遥
  { {0xf93d2004,0xfa782005,0xf58db005,0x00000003}},	//   持国, 固本, 旗袍,
  { {0xf9428007,0xf4b80001,0xf919a005,0x00000003}},	//   均出, 作項, 永外,
  { {0xfa76a004,0xf8225005,0xf910c00d,0xfa4af00d}},	//   容涉, 文交, 灰岩, 道文
  { {0xf59a9001,0xf9468008,0xf4c48004,0xf4b6000a}},	//   所自, 手帳, 王金, 期預
  { {0xf9108004,0xfb859005,0xfa65400c,0x00000003}},	//   防台, 同繁, 手杯,
  { {0xfa7a0004,0xf90a400c,0xfb50600a,0x00000003}},	//   来梅, 其受, 熱狂,
  { {0xfb84b006,0xfa860009,0xfb73b00e,0xfa81c004}},	//   上的, 全意, 通算, 六成
  { {0xfa6d2009,0xfb72f004,0xf9448005,0xf9094005}},	//   柴油, 会秘, 届十, 海合
  { {0xfb6d7001,0xf49ea004,0xf49ee005,0xfb4ec00c}},	//   林玉, 次高, 大防, 女皆
  { {0xf90ee005,0xfb5c300c,0xfa5e200d,0x00000003}},	// [1580] 地前, 接系, 庄浪,
  { {0xfa541001,0xf83dd001,0xfa6a8004,0xf9480005}},	//   供房, 員介, 致意, 名制
  { {0xf934a001,0xfa73c004,0xf9136005,0x00000003}},	//   備受, 格持, 西出,
  { {0xfa577004,0xf82f1005,0xf80ed00a,0x00000003}},	//   期治, 数一, 比企,
  { {0xfa75e007,0xf8253009,0xf93e2007,0xf595700e}},	//   人授, 同下, 情分, 通話
  { {0xf8115007,0xf90de007,0xf48d8001,0x00000003}},	//   供一, 女安, 水都,
  { {0xfb853004,0xf92c600c,0xfb84b00c,0x00000003}},	//   母牛, 我如, 立研,
  { {0xf4916001,0xf925600a,0xf8323005,0xfa850002}},	//   女防, 利市, 好今, 物服
  { {0xf8403004,0xf81f3001,0xf83a9008,0x00000003}},	//   次代, 約人, 選任,
  { {0xf4a64005,0xfa553005,0x00000003,0x00000003}},	//   是零, 沙漠,   ,
  { {0xfb48c009,0xfa87e004,0xf9368008,0xf9404005}},	//   家界, 罪案, 語彙, 文包
  { {0xfa74e001,0xf9278004,0xfb55e005,0xfb61d00c}},	//   精梳, 部受, 好男, 本約
  { {0xfa732009,0xf4a5e001,0xf596300c,0xf932c002}},	//   湿性, 全配, 機返, 何到
  { {0xf5b7d009,0xfa6e0009,0xfa523004,0x00000003}},	//   出自, 年收, 婚恋,
  { {0xfa4fd00f,0xfa5a6009,0x00000003,0x00000003}},	//   南港, 要情,   ,
  { {0xfa66c00f,0xfa5f8004,0xfb55000c,0xfa85000a}},	//   小技, 率有, 放異, 本整
  { {0xfa750004,0xfb4f0001,0xf4a7a00c,0x00000003}},	// [1590] 好日, 平線, 雨風,
  { {0xf4932004,0xfa838005,0x00000003,0x00000003}},	//   国香, 是毛,   ,
  { {0xfa64e004,0xf5bef004,0xf9134001,0xf5ac3001}},	//   上指, 大花, 政大, 水腫
  { {0xf914400f,0xfa882004,0x00000003,0x00000003}},	//   放入, 部正,   ,
  { {0xfa79e007,0xf92fc008,0xfa650005,0xf842d005}},	//   書本, 翔子, 不指, 是低
  { {0xf48ee007,0xfa557001,0xf9144004,0xf4a0e004}},	//   防部, 土教, 落在, 院部
  { {0xf49d0009,0xfa648007,0xfb83700e,0xfa830004}},	//   大青, 有收, 有給, 中接
  { {0xf8261004,0xf8247008,0xf90b6005,0x00000003}},	//   之便, 俊一, 援川,
  { {0xf8307009,0xfa722001,0xfb613004,0x00000003}},	//   即中, 報正, 止目,
  { {0xf91e8006,0xfb78b00f,0xf93fe00f,0xfb584008}},	//   大常, 言版, 球場, 令等
  { {0xf9298006,0xfa67c00f,0xf9276004,0xf921c008}},	//   周年, 敏感, 利因, 波大
  { {0xfb603001,0xfa599004,0xfa4b900c,0x00000003}},	//   短等, 秀旅, 打成,
  { {0xf919a00e,0xfa680001,0xf8397005,0x00000003}},	//   吸器, 量成, 以低,
  { {0xfa4cf008,0xf934000c,0xfa4c5005,0xf945c00d}},	//   成支, 多夫, 子提, 洋工
  { {0xfa571009,0xf5a29001,0xfb50c005,0xf81bd00c}},	//   存放, 計者, 地物, 需使
  { {0xf812d006,0xf9424006,0xf83bd004,0x00000003}},	//   料下, 案局, 度也,
  { {0xfb81500e,0xfb4aa002,0x00000003,0x00000003}},	// [15a0] 琉球, 更省,   ,
  { {0xfb62d009,0xf495600e,0xfa595001,0x00000003}},	//   六章, 抽選, 依政,
  { {0xfb592001,0xfa73c004,0xf5bc1001,0xf93a8004}},	//   懸疑, 房款, 春藤, 要商
  { {0xf5c3b001,0xfb76f00c,0x00000003,0x00000003}},	//   口述, 思的,   ,
  { {0xfb6c1009,0xf9262005,0xfa5c800d,0x00000003}},	//   互相, 良影, 老旧,
  { {0xfa4df006,0xfa543001,0xf48c0004,0xfa71c005}},	//   捐款, 教我, 暴雪, 平水
  { {0xfa780007,0xf940a004,0xf939400a,0x00000003}},	//   人推, 了天, 所市,
  { {0xfa7f4004,0xf5919001,0xf9464001,0xfa78c00c}},	//   大暴, 研製, 而定, 相思
  { {0xf5b0b005,0xfa7a2005,0xfa7d2002,0x00000003}},	//   山脚, 特曼, 朦朧,
  { {0xf59c3001,0xfb582005,0xfa62e002,0x00000003}},	//   的蛋, 油罐, 片格,
  { {0xfa55d004,0xf9368004,0xfa88e004,0xf92f600c}},	//   多收, 料制, 用汽, 金報
  { {0xf5adb009,0xf9486004,0xf9476005,0xf93a000a}},	//   年至, 偏北, 二孩, 十和
  { {0xfa6e4001,0xf92d2004,0xfb809005,0x00000003}},	//   甲村, 策参, 唆犯,
  { {0xf92e6004,0xf9230008,0xf9204005,0xfb55a00c}},	//   唐家, 景品, 口同, 姻的
  { {0xf9200009,0xf9100001,0xf8139004,0xf9312004}},	//   加好, 味全, 留了, 街巷
  { {0xfb63b009,0xf5ba9008,0xf4974004,0xf83ab00c}},	//   公章, 抹茶, 点送, 判代
  { {0xf9482004,0xf91b800a,0xf916600c,0x00000003}},	// [15b0] 嵌入, 大友, 空城,
  { {0xf5a5500b,0xf497c00c,0xfa5b600c,0x00000003}},	//   開設, 人魔, 流汗,
  { {0xf90a2004,0xf9094002,0x00000003,0x00000003}},	//   家姓, 其商,   ,
  { {0xfa5e2008,0xf947c001,0xfa523005,0x00000003}},	//   療施, 籍地, 会昌,
  { {0xf5afd00e,0xf8323004,0xf59f100a,0xf911a005}},	//   新譜, 好上, 境調, 石台
  { {0xfa762007,0xf5a05001,0xf9470005,0x00000003}},	//   殺手, 談談, 同化,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf90e0007,0xfa567009,0xf9458004,0xfa71000c}},	//   女友, 神文, 哈巴, 新探
  { {0xf492000c,0xfa788005,0xfa648005,0x00000003}},	//   報頭, 常清, 糊涂,
  { {0xfa61000b,0xfb5e3009,0x00000003,0x00000003}},	//   清水, 大群,   ,
  { {0xfa4f900b,0xf9324007,0xfa4e1004,0xfa708005}},	//   暖房, 定後, 策提, 地暖
  { {0xf948e007,0xfa82e001,0xf9314005,0xfa6d4005}},	//   歌唱, 代方, 宛城, 直板
  { {0xfa710006,0xfa69c006,0xf910c009,0xfa6f8004}},	//   石油, 海淀, 走在, 地指
  { {0xf5c43001,0xfb67d00c,0x00000003,0x00000003}},	//   種考, 審稿,   ,
  { {0xf93fc007,0xf911a004,0xfa644004,0xf93e6001}},	//   的到, 共北, 晋江, 者多
  { {0xfb6fb00f,0xfb83d004,0xfb51c005,0xf498c005}},	// [15c0] 字第, 等稿, 地相, 寸高
  { {0xf926800f,0xfb51800f,0xf80db007,0xf83bd001}},	//   部商, 新知, 化作, 別代
  { {0xf82af006,0xf9374001,0xf5a51004,0xf4920004}},	//   究中, 夜光, 月至, 西青
  { {0xfb75b007,0xf825f005,0xf8211005,0xf91ec00d}},	//   食生, 克以, 按不, 素在
  { {0xf811f00f,0xf4a74008,0xf5a63001,0xf4b50001}},	//   法令, 八重, 後記, 速送
  { {0xf91f2004,0xf4a14001,0xfb7e100a,0xf5bd300a}},	//   面反, 鮭魚, 境目, 度試
  { {0xf9278007,0xfb713007,0xfb64f008,0xf8173005}},	//   全套, 招牌, 審美, 喜事
  { {0xfa579009,0xfa6cc00c,0x00000003,0x00000003}},	//   期改, 浴池,   ,
  { {0xf92f6009,0x00000003,0x00000003,0x00000003}},	//   底前,   ,   ,
  { {0xfb7db00b,0xf9122009,0xf48f6004,0xfa63c004}},	//   参照, 好安, 岳麓, 恋情
  { {0xfa7f6009,0xfa4fd004,0xfa5d8001,0xf5a5f001}},	//   靠性, 列支, 居所, 屋貸
  { {0xf9284009,0xf495a009,0xf90f6008,0xf8243001}},	//   利害, 好防, 佳子, 型保
  { {0xf58db007,0xf92c2009,0xf4c66004,0xf5c33001}},	//   我自, 村小, 及面, 可考
  { {0xfb5c4006,0xfa6de001,0xf912400c,0xfa51300c}},	//   大理, 場新, 到就, 著海
  { {0xf92ee006,0xf91e6009,0xf917a001,0xfa67c004}},	//   比如, 大基, 出動, 行正
  { {0xf492800e,0xfa866004,0x00000003,0x00000003}},	//   阿部, 温柔,   ,
  { {0xfa65c009,0xf90c2001,0xfa4f7004,0xf9122005}},	// [15d0] 上演, 家共, 金数, 命先
  { {0xf497c00e,0xf91e4004,0xfb7c9005,0xf821f00d}},	//   綺麗, 信元, 品知, 指中
  { {0xf841f006,0xf4c6c001,0xf945c001,0xfa55900a}},	//   第七, 反面, 行局, 候性
  { {0xf5bc7007,0xfa5b7005,0xf91ea00c,0xf942e005}},	//   津貼, 品法, 惠快, 指国
  { {0xfb7db001,0xfb4bc001,0xfb4a2005,0xf826700a}},	//   情節, 直筒, 巴版, 規上
  { {0xfb7a7004,0xf591100c,0x00000003,0x00000003}},	//   送的, 力車,   ,
  { {0xf93cc00f,0xfa898009,0xf9100009,0xfb7a7009}},	//   的心, 在整, 女孩, 老的
  { {0xfa5c300b,0xf9278009,0xf90d6001,0xf49de001}},	//   療機, 用外, 場券, 大連
  { {0xfa4a100e,0xf9228009,0xf91b0008,0xf9310001}},	//   互換, 灯光, 撤去, 望安
  { {0xf927c009,0xf4c3400e,0xf9336004,0xf91e800c}},	//   在天, 有難, 会回, 性出
  { {0xfa517007,0xfa780005,0xf92ec005,0xfa5bd002}},	//   四技, 人您, 取公, 省您
  { {0xfb743001,0xf92e0005,0xf917c005,0x00000003}},	//   際社, 村屯, 画大,
  { {0xf5a51009,0xfb671007,0xf8137001,0xf9348004}},	//   手表, 部科, 供你, 供地
  { {0xfb729009,0xfa718001,0xf91e4004,0xfa7ec005}},	//   站版, 想曲, 次参, 加温
  { {0xf49cc005,0xf915600a,0x00000003,0x00000003}},	//   急防, 涼宮,   ,
  { {0xf942600e,0xf927e001,0xf922a005,0xfa5d7005}},	//   文句, 八分, 形地, 的束
  { {0xf92de009,0xf92e6004,0xf81b3004,0x00000003}},	// [15e0] 或刑, 子山, 言中,
  { {0xf911a001,0xf934a005,0xf90f8005,0xf92a800c}},	//   由化, 写得, 即向, 士報
  { {0xfa620005,0x00000003,0x00000003,0x00000003}},	//   理混,   ,   ,
  { {0xf90f800e,0xfa6ba008,0x00000003,0x00000003}},	//   統合, 護支,   ,
  { {0xf5baf006,0xf91b400f,0xfa760004,0xfa69e001}},	//   交警, 陸地, 好更, 小東
  { {0xfb5ff00b,0xf91fa007,0xf5b9b001,0xf9174004}},	//   次第, 造出, 人買, 容市
  { {0xfa89200f,0xf90ee004,0xf829f005,0xfa800005}},	//   風格, 地反, 晶体, 欠款
  { {0xf9240006,0xf81c5004,0xf8461004,0xfa51500c}},	//   公室, 市也, 用什, 力才
  { {0xf4988007,0xfa579004,0xf58fd004,0xf90b400c}},	//   書香, 土方, 策落, 場勘
  { {0xf5b8b00f,0xfa868004,0xf9378004,0xf93ee001}},	//   特質, 售房, 期出, 終場
  { {0xfa700009,0xfb6d9001,0xf8155004,0xfa59100c}},	//   新民, 林秋, 甘井, 所描
  { {0xfa76e00f,0xf59e300a,0xf4a10002,0x00000003}},	//   人教, 脂製, 迭香,
  { {0xfb62300a,0xf92fe00d,0x00000003,0x00000003}},	//   設用, 受公,   ,
  { {0xf8379006,0xfa89400f,0xfb69f009,0xf93ce005}},	//   死亡, 質感, 挪用, 善内
  { {0xfa5d7006,0xfb6c1009,0xf90c0001,0xfa5c3004}},	//   的期, 子生, 家女, 狂搜
  { {0xfa4bf006,0xfa77a007,0xfa7c8001,0xf8341001}},	//   限期, 司有, 度推, 都五
  { {0xfb887006,0xfa648009,0xfa6fc00c,0xf5c9b00c}},	// [15f0] 税率, 三水, 仰望, 陪著
  { {0xf4956007,0xfa85e004,0xf9438001,0xf5a6900c}},	//   移送, 用明, 葉大, 之谷
  { {0xf924400f,0xf911a004,0xfa652001,0x00000003}},	//   飯店, 共受, 脈曲,
  { {0xf9106009,0xfb71f001,0xf93f6004,0x00000003}},	//   花市, 力站, 者利,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf82b1004,0xf909e008,0xfa642004,0xf5a09005}},	//   家代, 晶子, 益明, 内能
  { {0xfa6ea001,0xf8107001,0x00000003,0x00000003}},	//   女情, 著人,   ,
  { {0xfa5c5007,0xfb877001,0xf5a2900c,0xf9382005}},	//   心所, 里第, 切腹, 川在
  { {0xf945e007,0xf9192001,0xfb763004,0xf93d2005}},	//   同居, 工坊, 神的, 久安
  { {0xfb5cc007,0xfb54200e,0xf928a009,0xf92d4001}},	//   入申, 施策, 注入, 成因
  { {0xfb7cb001,0xf5961005,0x00000003,0x00000003}},	//   考的, 州考,   ,
  { {0xfa862004,0xf4a4a008,0xf48a200d,0x00000003}},	//   表意, 鮮魚, 偷逃,
  { {0xfa52d004,0xf9444004,0xfa595005,0xfa80400c}},	//   做文, 等危, 州段, 無正
  { {0xfa66800b,0xfa840009,0xf48ac004,0xfa5f5005}},	//   後期, 中整, 海金, 的板
  { {0xf59a1004,0x00000003,0x00000003,0x00000003}},	//   要言,   ,   ,
  { {0xf917000c,0xf5a6b00c,0x00000003,0x00000003}},	//   竹崎, 量而,   ,
  { {0xfa82600e,0xf91b8004,0xfb6b9001,0xfb72f005}},	// [1600] 解散, 性安, 質環, 些物
  { {0xf945e00f,0xf49ac00c,0xfa694005,0x00000003}},	//   立刻, 否需, 夏津,
  { {0xf81fb00f,0xf4b1e004,0xfb78100c,0xf92d0005}},	//   了保, 力集, 夜爆, 或市
  { {0xf5b07007,0xf9126004,0xfa856004,0xf948e001}},	//   足跡, 就大, 温情, 行報
  { {0xf934a004,0xf938e00c,0xfb86700a,0xf5be9005}},	//   原告, 一型, 告無, 因被
  { {0xfa5a3007,0xf9472005,0x00000003,0x00000003}},	//   果樹, 量参,   ,
  { {0xf940e007,0xf59e500c,0xfb58a00c,0xf8297005}},	//   有型, 分計, 吹糖, 起事
  { {0xfb6af00e,0xfb550004,0xf9108001,0xfa61a00c}},	//   成美, 好群, 詳加, 分派
  { {0xf91d800e,0xf9364004,0xf90c2001,0xf92da001}},	//   絡先, 務廳, 水化, 金店
  { {0xf944a005,0xf9488005,0xf5b8500a,0x00000003}},	//   告内, 夏利, 活課,
  { {0xf5969001,0xf5bb5001,0xf80eb004,0xf82b900c}},	//   江路, 試者, 金以, 念一
  { {0xf8297006,0xfa74e004,0xfb6ed004,0xfa69e008}},	//   海事, 能模, 近百, 長所
  { {0xf92ec004,0xfa603001,0xfb7eb005,0x00000003}},	//   南川, 情查, 分税,
  { {0xf84a900b,0xfb699009,0xf8141009,0xf91e8005}},	//   自信, 八章, 高不, 性固
  { {0xfa5ef001,0xfa71800c,0x00000003,0x00000003}},	//   商概, 地步,   ,
  { {0xfa88c006,0xf9442004,0xf937a00a,0xfa6c0005}},	//   用房, 不光, 保子, 其新
  { {0xfb661007,0xf496c004,0xf5c31001,0xf9348004}},	// [1610] 物生, 区集, 可要, 期安
  { {0xf924a004,0xf5a89004,0xfa561005,0xf93c2005}},	//   天安, 行能, 折断, 持公
  { {0xf8301001,0xf90f0004,0xf80fd00c,0x00000003}},	//   山一, 育彩, 動企,
  { {0xf92e2009,0xf916a001,0xfa680004,0xfa5ad00c}},	//   列市, 出各, 量提, 一推
  { {0xfa66c00f,0xfb71f009,0xf93fc007,0xfa5a7004}},	//   下水, 会等, 的印, 要清
  { {0xf943200e,0xf93be004,0xfa668008,0x00000003}},	//   資家, 一寸, 前支,
  { {0xf81c3001,0xf92ee001,0xfb69f004,0xf5bb5004}},	//   善事, 抗原, 易等, 泥路
  { {0xfa866004,0xf9420004,0xf83b300c,0xf929600c}},	//   在清, 盆地, 入他, 溪州
  { {0xfa62e009,0xf93c2001,0xf4a9a001,0xf9348005}},	//   型案, 市博, 青銅, 牛女
  { {0xf82b5004,0xfa50900c,0xfa4bb00c,0xf5a4900a}},	//   其以, 比斯, 間投, 養蜂
  { {0xf9152004,0xf9480005,0xf92bc005,0x00000003}},	//   好基, 同履, 薪年,
  { {0xfb695004,0xf91c6004,0xfb667008,0xf59c5005}},	//   冒着, 否在, 天狗, 秀英
  { {0xfb57c00b,0xfa60b004,0xf9446005,0x00000003}},	//   幹線, 分是, 先学,
  { {0xf4b12005,0x00000003,0x00000003,0x00000003}},	//   何部,   ,   ,
  { {0xfa894009,0xf90e000c,0xf830b002,0x00000003}},	//   部新, 敵大, 穿不,
  { {0xf9138004,0x00000003,0x00000003,0x00000003}},	//   西岸,   ,   ,
  { {0xf82db007,0xf92e8004,0xf4b96001,0xf9216001}},	// [1620] 段代, 五倍, 初選, 本名
  { {0xfa68c001,0xf91a6001,0xf91c000d,0x00000003}},	//   家服, 特報, 泥工,
  { {0xfb73f005,0xfa63a00c,0x00000003,0x00000003}},	//   些相, 月推,   ,
  { {0xf9204001,0xf82a1004,0xf947a008,0xfa73400c}},	//   你已, 迎你, 遊具, 報新
  { {0xf9228004,0xfa5e3004,0xf81bf005,0xf922a00c}},	//   本增, 者指, 一使, 止報
  { {0xf5991007,0xf937e00c,0xf837f005,0xf92ac00c}},	//   神話, 作心, 容作, 質大
  { {0xfb4de007,0xfa67e004,0xf9364001,0xfa634004}},	//   酵素, 上水, 務平, 屋所
  { {0xfa760004,0xfa808004,0xf946a005,0xf80b5005}},	//   区残, 造更, 告大, 排中
  { {0xf93ca006,0xf9342009,0xf910a004,0xf908e001}},	//   的品, 多彩, 共商, 制局
  { {0xf49e600e,0xf9272007,0xf941e001,0xfa70a001}},	//   控除, 置地, 有做, 東教
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa55f006,0xfa5bb001,0xf91b200c,0xf491e005}},	//   高温, 最方, 常值, 数都
  { {0xf821b005,0xfa888005,0xf931c010,0x00000003}},	//   呈下, 天更, 隔地,
  { {0xf5a73009,0xf8401001,0xf91a4005,0xfa738005}},	//   富豪, 連上, 否合, 国期
  { {0xfb4fa004,0xf5915008,0xf92da00c,0xfb659005}},	//   台站, 法華, 取勝, 在眉
  { {0xfb5c200f,0xf9288008,0xf93ac004,0xf9376005}},	//   大約, 全室, 要定, 果反
  { {0xfa6dc007,0xf939c00c,0xfa744005,0xf59d300c}},	// [1630] 已拆, 依地, 松治, 的肚
  { {0xfb74f007,0xfa786009,0xf5aed00c,0x00000003}},	//   婚登, 核桃, 新認,
  { {0xf9472004,0xfa7f4004,0x00000003,0x00000003}},	//   名工, 大整,   ,
  { {0xf9456005,0xf90b400c,0xf947e010,0x00000003}},	//   倍多, 起努, 重山,
  { {0xfb6e7004,0xfa7b6001,0xf816b00a,0xfa88600c}},	//   化用, 度教, 期修, 質所
  { {0xf835100f,0x00000003,0x00000003,0x00000003}},	//   命令,   ,   ,
  { {0xf80a5009,0xf4c58001,0xf92c4004,0xf822f00c}},	//   当一, 行降, 近千, 予保
  { {0xf4a78009,0xf4b2e004,0xf93b0001,0xf812f001}},	//   雨雪, 会遇, 喜宴, 站位
  { {0xf81a7006,0xf90f600f,0xf4ac2004,0xfb4ae00a}},	//   十七, 防宣, 毒霸, 水球
  { {0xf92d200e,0xf593f004,0xf5c71004,0xfa650001}},	//   成形, 会被, 在近, 看推
  { {0xf81e3005,0xf935c00c,0x00000003,0x00000003}},	//   市便, 星夜,   ,
  { {0xf9344004,0xf92e4004,0xf58bf004,0xf5a61005}},	//   会可, 成危, 易被, 位被
  { {0xfb72900f,0xf92aa009,0xfa726004,0xf9332004}},	//   做的, 自学, 国歌, 多做
  { {0xfa589004,0xf4a8800c,0xf4aa8005,0xfb7a5005}},	//   作期, 親送, 角逐, 障社
  { {0xfa60f006,0xf93ba007,0xfa80e004,0xfb5f0004}},	//   内新, 要快, 中清, 次生
  { {0xf9132008,0xf4b4a00c,0x00000003,0x00000003}},	//   話帳, 托高,   ,
  { {0xfa89e009,0xf80eb009,0xf9100004,0xfa5e1001}},	// [1640] 太湖, 疑人, 地州, 情故
  { {0xfa764009,0xf948c007,0xfa79c004,0xfb859001}},	//   出意, 里山, 入持, 重生
  { {0xfa7c4001,0xf5a47005,0x00000003,0x00000003}},	//   座教, 越要,   ,
  { {0xf491800b,0xfa4d1004,0xfa5ab005,0x00000003}},	//   放題, 当承, 一株,
  { {0xf83b3009,0xf9480004,0x00000003,0x00000003}},	//   入世, 量少,   ,
  { {0xf945e004,0x00000003,0x00000003,0x00000003}},	//   立医,   ,   ,
  { {0xfa67c001,0x00000003,0x00000003,0x00000003}},	//   額新,   ,   ,
  { {0xfb49200f,0xfb657004,0xf5969001,0xf8203005}},	//   然的, 可移, 祝賀, 内以
  { {0xf8241001,0xf8361001,0xf9424004,0xfb4de005}},	//   事保, 任保, 理年, 乳粉
  { {0xf5a8900e,0xf92a0001,0xfa56b00c,0xf90b800a}},	//   小路, 道光, 保概, 具師
  { {0xfa67e009,0xfa872004,0xf497e004,0xf9092004}},	//   不收, 全提, 基部, 家参
  { {0xf5b89007,0x00000003,0x00000003,0x00000003}},	//   書記,   ,   ,
  { {0xfa828009,0xf943a004,0xf90fa004,0xf820d00c}},	//   是把, 手市, 色学, 閉介
  { {0xfb87d006,0xf92f8006,0xf944400e,0xfa7a0004}},	//   名称, 幕式, 半導, 急情
  { {0xfa876004,0xf9106004,0xf9348005,0xf5c3100c}},	//   在比, 就必, 沙化, 般訪
  { {0xf845b004,0xfa80e001,0xfa65e00c,0xf938600c}},	//   普京, 業旅, 之批, 感念
  { {0xf4be200f,0xfa6b2009,0xf948c004,0xfb7e7005}},	// [1650] 的部, 年教, 里就, 装生
  { {0xfa728004,0xf5aa7001,0xf91e8004,0xf92a8001}},	//   地水, 場行, 性基, 罪宣
  { {0xf938a00e,0xfb630004,0xfa65e005,0xf940000c}},	//   最安, 口登, 今未, 豆子
  { {0xfa4d7001,0xfb4ae00c,0xf921000c,0xf9420005}},	//   向法, 家第, 連忘, 隆台
  { {0xfa88a009,0xf9116004,0xf816f001,0xf9286005}},	//   票查, 数大, 機代, 利共
  { {0xf9184001,0xf4b4a004,0xfa7d4004,0x00000003}},	//   人副, 余部, 大或,
  { {0xfb7d700f,0xf93ee009,0xfa61b007,0xf5a3b004}},	//   突然, 了小, 盆栽, 立者
  { {0xfa6c0004,0xf9208001,0xf91b2005,0x00000003}},	//   巴林, 止契, 入北,
  { {0xfa635001,0xf4a58001,0xfa59b00c,0xf92ce005}},	//   合投, 詩集, 一教, 湖小
  { {0xfa68e009,0xf8211004,0xfa73000c,0x00000003}},	//   行新, 分信, 沾染,
  { {0xfa54f008,0xf49e0001,0xfa61b001,0xf4bba00a}},	//   多治, 性連, 有教, 茂雄
  { {0xf9312009,0xf935a004,0xf9174005,0x00000003}},	//   研室, 料工, 区原,
  { {0xf948e009,0xf92dc009,0xf8249004,0xfa69e001}},	//   同其, 蔓延, 合人, 買時
  { {0xf92aa004,0xfa71e001,0xf91fa005,0x00000003}},	//   士康, 政救, 造基,
  { {0xf9480008,0xfa4f9005,0x00000003,0x00000003}},	//   美品, 受挫,   ,
  { {0xfa69a001,0xf944e004,0xf818b00c,0xf93bc00c}},	//   低潮, 前市, 作休, 最幸
  { {0xfb67d009,0xfb755007,0xf4c74008,0xfb64c004}},	// [1660] 火爆, 真理, 後部, 扯皮
  { {0xfb658008,0xf9378005,0xf9128005,0xf82db002}},	//   天理, 期基, 西天, 念你
  { {0xf4926008,0xfb7ff004,0xfa54f008,0xfa7b400d}},	//   使館, 文繁, 高揚, 交方
  { {0xf8141005,0xf8283005,0xfa87200d,0x00000003}},	//   候也, 行以, 周易,
  { {0xf8473006,0xf81ef004,0xf4aae001,0xfa4d7004}},	//   助中, 分企, 子鍋, 恐惧
  { {0xf93e0001,0xf93ce004,0xfb863001,0xfb4f8001}},	//   善化, 善待, 手稿, 米粒
  { {0xfa6da007,0xfa5c7001,0xf8233004,0xf94a2004}},	//   水河, 求救, 程不, 量就
  { {0xf946000e,0xfb6e7001,0xf92a4001,0xfb6a7001}},	//   養士, 店線, 荒原, 質監
  { {0xf92f800f,0xfa4f9004,0xfa629001,0xf91b2005}},	//   外出, 外方, 月教, 入南
  { {0xf9298004,0xfa533004,0x00000003,0x00000003}},	//   勒市, 晚期,   ,
  { {0xf83e3004,0xfa5df00c,0xf827700a,0xf92f8005}},	//   握住, 市治, 炎上, 金德
  { {0xf9270004,0xf81f9008,0xf90c0001,0xfa71800a}},	//   在增, 文下, 水塔, 週比
  { {0xf91cc001,0xf9136004,0xfa704008,0xf819900a}},	//   以到, 英山, 飲放, 府京
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf81f7004,0x00000003,0x00000003,0x00000003}},	//   理会,   ,   ,
  { {0xfb83d009,0xf5955009,0xfa7a000e,0xfb79b001}},	//   及版, 土豆, 特派, 犀牛
  { {0xf927600c,0xf4a30005,0xf59bd00c,0xfb67b00c}},	// [1670] 全展, 本首, 況良, 炫的
  { {0xf5b0f00e,0xfa7c4001,0xf910a008,0x00000003}},	//   新設, 性情, 調和,
  { {0xfa6f0007,0xf90d000c,0xf5c55005,0xf93ee00c}},	//   音掛, 更別, 目被, 終年
  { {0xfb88b006,0xfa7c2004,0xf93c4001,0xf4b26001}},	//   野生, 大清, 所共, 法都
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf91aa007,0xf90b8004,0xfa81e005,0x00000003}},	//   選出, 年夜, 中比,
  { {0xf818f006,0xf8255009,0xf59eb007,0xf81c3001}},	//   最低, 上也, 市買, 約三
  { {0xf937c00f,0xf83d3009,0x00000003,0x00000003}},	//   作品, 警信,   ,
  { {0xf926e005,0xf92c000c,0x00000003,0x00000003}},	//   在停, 道夫,   ,
  { {0xfa802007,0xf8475004,0xf5b99008,0xf5a7d00a}},	//   校正, 利代, 日規, 過言
  { {0xfb59600f,0xfb658004,0xf9458001,0xf5b39004}},	//   空白, 可登, 合年, 放路
  { {0xf9274007,0xf83d3004,0x00000003,0x00000003}},	//   助客, 学信,   ,
  { {0xfa72c00f,0xf8149007,0xfb85f004,0xf919a008}},	//   東方, 忘了, 型示, 批判
  { {0xf5ab5007,0xf919a004,0xfa657004,0xfa5af004}},	//   強迫, 交回, 届村, 市慈
  { {0xf943a004,0xfa760004,0xf4b6e004,0xf90ec008}},	//   三区, 好整, 州金, 農協
  { {0xf935e007,0xf929e001,0xfa6f6001,0xfa5db005}},	//   察刑, 質化, 飲業, 送水
  { {0xf8403009,0xf4ba4001,0xfb853004,0xf591f001}},	// [1680] 面也, 一餐, 先由, 定計
  { {0xf81ab009,0xfa6d4004,0xf5be3001,0xfa631001}},	//   流会, 年改, 度起, 等業
  { {0xfa65f004,0xf9482001,0x00000003,0x00000003}},	//   名投, 而建,   ,
  { {0xfb851009,0xf9232001,0x00000003,0x00000003}},	//   双版, 業出,   ,
  { {0xf843b009,0xf4c06004,0xf9232001,0xfa601001}},	//   是保, 了首, 祭出, 超殺
  { {0xfa736004,0xfa5a3001,0xf499600c,0xf92dc005}},	//   共新, 所成, 別開, 受同
  { {0xf827301d,0xf59eb004,0xfb725004,0xf823300a}},	//   名人, 各股, 定税, 型二
  { {0xfa7d8004,0xfa613005,0x00000003,0x00000003}},	//   度方, 逆性,   ,
  { {0xf8255006,0xf5ac7009,0xfb562004,0xf912600a}},	//   程中, 水路, 人王, 数制
  { {0xf80f9009,0xf9260009,0xf92ac001,0xfb7a500c}},	//   何一, 在小, 術分, 府相
  { {0xf8237004,0xfa6ec005,0xfa55f00c,0xf911a00c}},	//   守互, 平教, 生民, 音地
  { {0xfa61b00e,0xfa63d001,0x00000003,0x00000003}},	//   有料, 有改,   ,
  { {0xf83a5006,0xf92d8004,0xf9282005,0x00000003}},	//   以保, 体地, 未名,
  { {0xf92d8006,0xf8397007,0xf913c00e,0xf916c005}},	//   当地, 令依, 陽子, 出分
  { {0xfa810007,0xfa74800c,0xf9124005,0x00000003}},	//   庭教, 現書, 能光,
  { {0xf932000f,0xf910c00e,0xfa73c001,0xf92c800a}},	//   法入, 農家, 施打, 外安
  { {0xfa820006,0xfa82e00f,0xfa66d004,0xf827900c}},	// [1690] 本文, 連接, 同投, 序依
  { {0xf91fc007,0xf81f9008,0xf916e001,0xfa7e400c}},	//   無庫, 文例, 遺忘, 座活
  { {0xfa7bc006,0xf9218004,0xf9128001,0xf9136001}},	//   入正, 中增, 山健, 山島
  { {0xfa4e5007,0xfb7c7004,0xf4c4a001,0xf922c001}},	//   沖洗, 一男, 事達, 可完
  { {0xf828100b,0xfa822009,0xfb49e007,0xfb7e5001}},	//   同人, 正是, 究竟, 的累
  { {0xf8403001,0xf834d005,0xfb7a3005,0x00000003}},	//   業上, 百佳, 秀科,
  { {0xf4a1e008,0xfa62d004,0xf932e00c,0xf937600c}},	//   中途, 事案, 乙名, 果再
  { {0xfa776009,0xf9248004,0xfa726008,0xf4ba200c}},	//   出成, 本兼, 社文, 品需
  { {0xfb5e6001,0xfb7d3004,0xf5c8b00c,0x00000003}},	//   大空, 狂犬, 用貸,
  { {0xfb747007,0xfb739009,0xfb59a004,0xfb578005}},	//   原版, 站留, 方略, 方病
  { {0xfa5c7009,0xf824900d,0x00000003,0x00000003}},	//   的明, 反不,   ,
  { {0xf83a5009,0xf9390004,0xfb602005,0x00000003}},	//   以依, 着小, 院畜,
  { {0xf9416006,0xf916e007,0xf931e009,0xf90c2004}},	//   文化, 兼具, 法大, 家山
  { {0xfa828007,0xf5adf009,0xf93fc001,0x00000003}},	//   可有, 年起, 的冰,
  { {0xf9144005,0x00000003,0x00000003,0x00000003}},	//   命周,   ,   ,
  { {0xfa6d2009,0xfa822004,0xfb59200a,0xfa752005}},	//   年活, 京教, 古紙, 圾收
  { {0xfb6b700f,0xf822b006,0xfb7c7007,0xf91fe001}},	// [16a0] 自由, 合会, 送給, 波切
  { {0xf92de004,0xf496c00c,0xf82ff005,0xfb66600c}},	//   他回, 人魅, 地也, 磨砂
  { {0xf5b19009,0xf5c5d007,0xfb5c6008,0xf90dc00c}},	//   平谷, 部行, 接点, 卵形
  { {0xf93ba004,0xf8151004,0xf935c005,0x00000003}},	//   最基, 通便, 尚家,
  { {0xf59c700f,0xf93f8009,0xf9482005,0x00000003}},	//   一起, 心声, 名年,
  { {0xfa850001,0xfa641004,0xfb57c004,0xf5a9b005}},	//   利服, 安曼, 治知, 具行
  { {0xfa5c7004,0x00000003,0x00000003,0x00000003}},	//   心概,   ,   ,
  { {0xf9376007,0xf81d5004,0xf9478004,0xf80f3004}},	//   果凍, 情上, 李克, 法事
  { {0xf8257004,0xf4c84001,0xf5a5100c,0x00000003}},	//   友中, 小雪, 合農,
  { {0xf48f000c,0xfb61400a,0xfb53c005,0x00000003}},	//   害通, 本立, 籽粒,
  { {0xf92dc006,0xf91d4006,0xfb5d6007,0xf9202007}},	//   向全, 学学, 惠的, 業安
  { {0xfa5bd006,0xf5b4900b,0xfb49e00f,0xf93bc001}},	//   一方, 施設, 家生, 一出
  { {0xf4c08007,0xf92c200a,0x00000003,0x00000003}},	//   超音, 排尿,   ,
  { {0xfa615004,0xf934a004,0xf943c001,0xf4abc001}},	//   万株, 定加, 有出, 民里
  { {0xf4a4c009,0xfb63c001,0x00000003,0x00000003}},	//   路面, 微積,   ,
  { {0xf92fa008,0xf910800c,0xf844300a,0x00000003}},	//   何十, 異化, 馬主,
  { {0xf9208006,0xf929a009,0xf5b5b007,0xfa4d7004}},	// [16b0] 中小, 士学, 麻豆, 子怡
  { {0xf93bc009,0xf5a07001,0xf48b6008,0xf92dc005}},	//   品在, 分表, 強風, 化土
  { {0xfa5fd007,0xf9490009,0xf90e8004,0xf946c005}},	//   升服, 同年, 新合, 前形
  { {0xf91c4007,0xf815100c,0x00000003,0x00000003}},	//   艦店, 記作,   ,
  { {0xf92dc007,0xf5a55007,0xf9114004,0xf917c004}},	//   北富, 月起, 咳嗽, 点存
  { {0xf8249008,0xf495c00c,0xf912c00c,0xf923e00c}},	//   龍一, 命週, 現原, 縮式
  { {0xf90c200f,0xf8265006,0xf935c005,0xf9400005}},	//   件地, 及中, 也增, 内学
  { {0xf4a78009,0xfa649009,0xfb64e005,0xf91ee00c}},	//   在首, 月活, 是短, 無定
  { {0xf9410008,0xfb797005,0xf91da005,0xfa7e0002}},	//   安城, 初稿, 性天, 照正
  { {0xfb733004,0xf595b004,0xf90e4004,0xf841300c}},	//   写着, 多起, 女式, 宣作
  { {0xfa569001,0xf93f8004,0xf5c8500a,0xfb827002}},	//   依所, 震安, 骨董, 奈的
  { {0xf944a004,0xf938c00c,0xfb82900c,0xf4c6c00c}},	//   月出, 依凡, 匈牙, 意配
  { {0xfb7e9005,0xf4a8e00c,0xf4b4a002,0x00000003}},	//   了立, 用都, 生里,
  { {0xf93ec004,0x00000003,0x00000003,0x00000003}},	//   了前,   ,   ,
  { {0xf848b00e,0xfa730007,0xf91d6001,0xf947a004}},	//   巨人, 災情, 你吃, 反国
  { {0xf9142006,0xfa4f1001,0xf92a4004,0xfb53400c}},	//   国外, 我放, 青州, 山環
  { {0xfa551006,0xf935001a,0xf5a1b007,0xfa84c004}},	// [16c0] 多方, 站公, 安講, 修期
  { {0xfa82e00e,0xfb753007,0xfb69400e,0xf59d7004}},	//   支所, 期約, 用環, 内行
  { {0xf9446001,0xfb6e9001,0xfb87b004,0xf820b00c}},	//   今夏, 南瀛, 同管, 均依
  { {0xf940a006,0xfa78e009,0xf91ba007,0xf939a004}},	//   涉及, 人死, 大名, 品合
  { {0xfb5b6004,0xf5a4b005,0xf91aa00c,0x00000003}},	//   接用, 名老, 改場,
  { {0xf9450004,0xf80f3001,0xf8111004,0xf5b41001}},	//   上存, 法下, 法享, 鹿谷
  { {0xf925e004,0xf934a005,0x00000003,0x00000003}},	//   可忽, 牛山,   ,
  { {0xf9452009,0xf91cc009,0xfb63400e,0xfa661004}},	//   不存, 大增, 本物, 上推
  { {0xf4898007,0xfa4fb007,0xfa874004,0x00000003}},	//   德里, 林森, 表提,
  { {0xf5c6b00f,0xfa663004,0xfb550001,0xf937400c}},	//   物質, 不推, 都給, 熟度
  { {0xf8255005,0xfb65c00c,0xf4b3600a,0x00000003}},	//   名会, 木紋, 通預,
  { {0xf5a6b00f,0xfa5d7009,0xfa649004,0xfa569004}},	//   看起, 桃源, 烈日, 速推
  { {0xf4bec009,0xf829f00e,0xfa5df005,0xf92d000a}},	//   清醒, 討中, 市活, 策局
  { {0xf48f8006,0xf917600e,0xf928a001,0xfa5eb004}},	//   地震, 智子, 早年, 装材
  { {0xfa6ea009,0xf948c005,0xfa73c005,0xf596f00a}},	//   抵押, 富平, 款是, 識調
  { {0xf93e0001,0xf91c4008,0xfa5c7004,0xf4a36005}},	//   旅充, 照射, 的李, 可逆
  { {0xf58a100f,0xf93e0009,0xfa73e007,0xf9254009}},	// [16d0] 卓越, 市出, 放映, 物局
  { {0xfb6b800f,0xf5a0d00c,0xf5b8300a,0xfb58800c}},	//   間結, 情花, 炸裂, 腺素
  { {0xfa82a004,0xf9480004,0xfa65500c,0x00000003}},	//   断探, 行学, 鍋湯,
  { {0xf814b009,0xf83ad004,0xfb49c005,0xfa882002}},	//   定信, 度低, 婷美, 航服
  { {0xfa5a9009,0xfb5ee009,0xfb6e7001,0xf5b19002}},	//   要文, 面粉, 取用, 台肥
  { {0xfa551007,0x00000003,0x00000003,0x00000003}},	//   生時,   ,   ,
  { {0xf91bc004,0xf4c44001,0x00000003,0x00000003}},	//   大屏, 有防,   ,
  { {0xf91c6006,0xf4a5e009,0xfa4d5001,0x00000003}},	//   健常, 利通, 我成,
  { {0xfa60b006,0xfa6c5004,0xf9326008,0xf928800c}},	//   分支, 年暨, 辛子, 用入
  { {0xf597900b,0xfa790004,0xfa728004,0xf5c8f004}},	//   回路, 以案, 国明, 士表
  { {0xfa5ed009,0xfa4c9009,0xf9274004,0xfb809005}},	//   布活, 科文, 修家, 了物
  { {0xf9134006,0xf9452009,0xf8347009,0xf90de005}},	//   危害, 上做, 派人, 念大
  { {0xfa62d007,0xfb5ac005,0xfb5fe005,0xfa6fe005}},	//   片放, 入科, 映社, 箱操
  { {0xfa70e006,0xf9454009,0xf5a57009,0xf9456001}},	//   平方, 不做, 行行, 律宣
  { {0xfa76a00e,0xf8129004,0xf499a008,0xf4a20005}},	//   主演, 定企, 日銀, 中首
  { {0xfa58b00f,0xf92e600f,0xf5a0d00b,0xf8411006}},	//   一月, 子報, 理解, 那些
  { {0xf92f8007,0xf932c001,0xf820b004,0xfa77a00c}},	// [16e0] 外基, 何地, 粉事, 主控
  { {0xfa4df004,0xf943c004,0xf949e004,0xfa4ed005}},	//   或成, 有固, 每平, 他本
  { {0xf93ca006,0xf5b37009,0xf937e004,0xf8391002}},	//   的十, 格行, 原国, 工三
  { {0xfb7a7006,0xf912600f,0xfa695005,0xf9158005}},	//   作社, 山大, 李洪, 登封
  { {0xfb777009,0xf944c001,0xfa7e8004,0xf9386005}},	//   非物, 始受, 造或, 朝天
  { {0xf9286009,0xf4b48004,0x00000003,0x00000003}},	//   用大, 高附,   ,
  { {0xfb6f9001,0xfa673004,0xfa820005,0xfa4d300c}},	//   受用, 福清, 本指, 民打
  { {0xf92fe009,0xfb5d0004,0xf827f004,0xfa677001}},	//   法必, 加美, 富信, 莎拉
  { {0xf9356001,0xfb630001,0xfa69f002,0x00000003}},	//   感嘆, 業群, 島民,
  { {0xf923e00f,0xf4af0001,0xf925a004,0xf90fa00c}},	//   縮小, 外連, 您光, 色度
  { {0xf929a00b,0xfb556009,0xf499a004,0xf4c06001}},	//   自動, 礼物, 入量, 劇集
  { {0xfa798004,0xf49dc00c,0xfa5f500c,0xfa884005}},	//   群星, 信里, 的拿, 被撞
  { {0xfa53f00f,0xfa7ce004,0xf9286004,0x00000003}},	//   高手, 入数, 利影,
  { {0xf90e4001,0xf9100001,0xf920600c,0xf593300a}},	//   女小, 育常, 因家, 料老
  { {0xf9414004,0xf83e1004,0xf829d00d,0x00000003}},	//   等参, 象一, 号不,
  { {0xf49a4007,0xf82c7004,0xfa619004,0xfb526001}},	//   令部, 年修, 月月, 由管
  { {0xf93f0007,0xf590f001,0xf845d004,0xf4bb2005}},	// [16f0] 善工, 力計, 票上, 要限
  { {0xfb62800f,0xf932a005,0x00000003,0x00000003}},	//   般生, 会心,   ,
  { {0xfb767009,0xfa54500c,0xfa70000c,0xfa7a2005}},	//   星火, 力派, 山所, 来料
  { {0xf93dc005,0xf910800a,0x00000003,0x00000003}},	//   境得, 熱射,   ,
  { {0xf5c6f00b,0xfa51f009,0xf81a1004,0xf80f7008}},	//   用語, 多月, 喜人, 達也
  { {0xfa7cc009,0xfb7af001,0xf4a48004,0xf58e3005}},	//   警支, 所第, 是部, 疑解
  { {0xfa5d5001,0xf4b9c001,0xf4a84004,0xf931000c}},	//   心我, 所通, 紫金, 法化
  { {0xfb5a6008,0x00000003,0x00000003,0x00000003}},	//   改称,   ,   ,
  { {0xfa7b400e,0xfb4d2001,0xf841100c,0xf916e00a}},	//   古書, 破盤, 代保, 費全
  { {0xfa5c300b,0xfb705008,0xf93bc004,0xf90f8005}},	//   時期, 織物, 要利, 翰内
  { {0xfb61000f,0xfb7a7001,0x00000003,0x00000003}},	//   業理, 送範,   ,
  { {0xf947800f,0xf9232007,0xfb55a009,0xf8497008}},	//   規定, 業基, 治病, 全件
  { {0xfb819009,0xf4ae8005,0xf90dc005,0xf922200c}},	//   了相, 列高, 卵巢, 業倫
  { {0xfb6aa009,0xfa623004,0xf590f001,0xf93ec008}},	//   姓的, 等提, 著色, 雅子
  { {0xf81cb001,0xf945600d,0x00000003,0x00000003}},	//   心了, 殊原,   ,
  { {0xf80ff001,0x00000003,0x00000003,0x00000003}},	//   託代,   ,   ,
  { {0xf934a006,0xf489e004,0xfa62f001,0x00000003}},	// [1700] 写字, 其限, 載本,
  { {0xf9338009,0xfb4f4009,0xf944e007,0xf9426008}},	//   定向, 害生, 開取, 文履
  { {0xf915e00f,0xfa573007,0xf59a3004,0xfa4a9004}},	//   活力, 府消, 品要, 戒毒
  { {0xf831d006,0xfb855004,0xfa5a5001,0xf9194005}},	//   地使, 案由, 門投, 挺好
  { {0xf91cc007,0xfa814004,0xf93e0005,0xfa73000c}},	//   度可, 校新, 市固, 精打
  { {0xfa4e7009,0xf5a7b00c,0xfb564005,0x00000003}},	//   子数, 上買, 区税,
  { {0xf948e008,0xf4930004,0xf9258005,0xf937800c}},	//   小口, 精髓, 周先, 府免
  { {0xfb7c7007,0xfb5c4004,0xfa6bd001,0xfa63b005}},	//   終結, 接登, 護業, 三改
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa535009,0xf919200e,0xfb871007,0xf5aff001}},	//   会期, 日午, 隊社, 共行
  { {0xfa4fb004,0xfb68e005,0xfa69b005,0xf947a00c}},	//   算支, 含糖, 式施, 炊具
  { {0xf817b007,0xf5c1d007,0xfb7bd004,0xf59f900c}},	//   作一, 口腔, 持用, 各色
  { {0xfb5fe00b,0xf93ec009,0xf914e005,0xfa70300a}},	//   採用, 元左, 汽大, 農政
  { {0xf9198006,0xfa726001,0xfa856004,0xfb6b4001}},	//   基地, 失控, 枯死, 輪社
  { {0xfb67c004,0xf5a31005,0xf829d00c,0xf8409005}},	//   在物, 万起, 德一, 校以
  { {0xfb7b9007,0xfb82f004,0xf58e5004,0xf821d00a}},	//   一群, 事程, 外街, 沈下
  { {0xfa83a009,0xf4bca009,0xfa65900e,0xf9188004}},	// [1710] 公正, 市青, 界最, 古城
  { {0xfa641001,0xf910c008,0xfb84500a,0xf847d00c}},	//   版業, 西小, 三男, 未予
  { {0xf94b200f,0xf9444001,0xf93ec002,0x00000003}},	//   低到, 倍光, 雄岡,
  { {0xf80ef00f,0xf81eb007,0xf93d0004,0xf840100d}},	//   取代, 的你, 考官, 中予
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf911400e,0xfa627004,0xf5bc700c,0xf5a8b00c}},	//   乳幼, 万方, 入西, 肌腱
  { {0xf82a1004,0xfb594004,0xf8163004,0xf4a0c001}},	//   刷企, 区白, 回了, 夢達
  { {0xfb604009,0xf9206005,0xf5bc7005,0xfa65d005}},	//   中立, 中前, 学自, 行流
  { {0xfa84400c,0xf81e5005,0xf927c005,0x00000003}},	//   溯溪, 理三, 部利,
  { {0xf59eb00f,0xf946a004,0xfb57e001,0x00000003}},	//   考試, 手共, 麻痺,
  { {0xfb668004,0xf8307004,0x00000003,0x00000003}},	//   央空, 就了,   ,
  { {0xf81b5009,0xfa607005,0xf910800c,0xf5a3500c}},	//   市低, 了未, 到店, 見血
  { {0xfa830008,0xf90b000c,0x00000003,0x00000003}},	//   中津, 茶几,   ,
  { {0xfa7ce009,0xf90f2001,0xfa78800c,0x00000003}},	//   入新, 想做, 室服,
  { {0xf5929001,0xf596300c,0xf493a002,0x00000003}},	//   仙草, 枝葉, 命黑,
  { {0xfa4ef005,0xf916200c,0xfb73100a,0xfb7cb00c}},	//   俗易, 幻夜, 換用, 考範
  { {0xfb84f007,0xf90c8009,0xf8253004,0xfa70f002}},	// [1720] 事物, 年可, 背上, 到是
  { {0xf4aa8007,0xfa7a8009,0xfb799001,0xfb7e7004}},	//   含週, 常性, 一理, 的班
  { {0xf90fe009,0xf80db008,0xf918c004,0xf93ea001}},	//   育基, 世保, 方在, 的季
  { {0xf815b007,0xfb871007,0xf948e001,0xf93bc005}},	//   土保, 積移, 後地, 一基
  { {0xf9454009,0xf9292008,0xf815b004,0xf5b19001}},	//   程公, 園前, 期保, 東街
  { {0xfb75700b,0xf4bba00c,0xf5cbb002,0x00000003}},	//   語版, 所遺, 溪谷,
  { {0xfa71300a,0xfa83e005,0xf90dc00a,0x00000003}},	//   報源, 本控, 河合,
  { {0xf9260005,0xf9426005,0x00000003,0x00000003}},	//   在宏, 文工,   ,
  { {0xf811f00f,0xf93fe00b,0xf5a37001,0xfb6d2001}},	//   投信, 指導, 予評, 我真
  { {0xfa63b009,0xf9310009,0xf5b0900e,0xfb7b3008}},	//   三方, 法取, 網走, 封筒
  { {0xf5a6b00e,0xf9464009,0xfa5a9009,0xfa89e005}},	//   小規, 立国, 要指, 享改
  { {0xf4aee00f,0xfb777007,0xfa5d9004,0xf59c1005}},	//   套餐, 真空, 待所, 境行
  { {0xf4bb4007,0xf92ec009,0xfa804007,0xfa80c001}},	//   一連, 北川, 蔡惠, 信房
  { {0xfa868005,0xfa7d4005,0xfa61f00c,0xf5c8300c}},	//   在指, 性比, 計手, 適足
  { {0xfa80e007,0xfa4ed001,0xfa63f005,0xf90f000c}},	//   督教, 得我, 及涉, 地問
  { {0xfa511009,0xfa559007,0xfb662001,0xf91aa004}},	//   字数, 期望, 利生, 来回
  { {0xfb68c009,0xf9266007,0xfa796001,0xf5b25001}},	// [1730] 在相, 用必, 吸汗, 地買
  { {0xf5a47007,0xf83e1008,0xf9248001,0xf9432001}},	//   再行, 信一, 本埼, 築夢
  { {0xfa4bf008,0xfa5d3004,0xfb4a4001,0xfa4e5005}},	//   析機, 漂浮, 酷的, 子洲
  { {0xf91bc006,0xfa7c4004,0xfa816001,0xfa752004}},	//   春季, 大文, 波波, 都来
  { {0xfb4de006,0xfa6cf007,0xfa5e3009,0xf9154009}},	//   平等, 場次, 它是, 都区
  { {0xfa6b1004,0xfa6bd001,0xfb624005,0x00000003}},	//   海投, 谷波, 中物,
  { {0xf80e3006,0xfa4df009,0xf93be00c,0xfa5d3005}},	//   得了, 剖析, 吃又, 者授
  { {0xf8451006,0xfa711009,0xfb7a7001,0xfa6f9004}},	//   硬件, 山村, 作績, 地教
  { {0xf58f7007,0xf9196004,0xfa83e004,0xf93e6004}},	//   受訪, 区平, 本性, 者博
  { {0xf82b300f,0xf82c5009,0xfa54f007,0xf58bf001}},	//   男仕, 海人, 通方, 我而
  { {0xfb65c004,0xf5a4900c,0xf9126005,0xf927c00a}},	//   是社, 事評, 房店, 部助
  { {0xf5a6b005,0xfb4d600a,0xf4b64002,0x00000003}},	//   名解, 段目, 辟邪,
  { {0xfb616008,0xf93f6005,0x00000003,0x00000003}},	//   京王, 万安,   ,
  { {0xfa671004,0xf939c001,0xf922a008,0xfa585005}},	//   上改, 品刊, 港前, 果枝
  { {0xf5a99001,0x00000003,0x00000003,0x00000003}},	//   家講,   ,   ,
  { {0xfa673009,0xf9278009,0xf82eb001,0xfa5b9008}},	//   不改, 用化, 新事, 退治
  { {0xfa5dd004,0xfa60d001,0xf82ef005,0xf4bc800c}},	// [1740] 善投, 昇機, 台不, 球魂
  { {0xf93e800e,0xf920600c,0xfb65a00d,0x00000003}},	//   時台, 代品, 在玉,
  { {0xfa5c5004,0xfb5c6005,0x00000003,0x00000003}},	//   襄樊, 以社,   ,
  { {0xf93e2006,0xf93f2009,0xfa7f2004,0xfb7d700c}},	//   充分, 密市, 照新, 胃科
  { {0xfb55c004,0xf9158008,0xf91ce002,0x00000003}},	//   活率, 麻布, 查地,
  { {0xfb829004,0xfa89c004,0xf9134004,0xf49ac00c}},	//   指点, 身活, 都存, 肥餐
  { {0xfa7fc009,0xf9134004,0x00000003,0x00000003}},	//   面料, 能存,   ,
  { {0xf91de004,0xf90ee004,0xf918c005,0x00000003}},	//   度尼, 汲取, 方周,
  { {0xfa7ac00b,0xf93e0009,0xf4942007,0xfa4af007}},	//   工法, 市基, 白雪, 道教
  { {0xfa860006,0xf4b6e001,0xf94b2001,0xfb614005}},	//   支柱, 官邸, 美地, 京等
  { {0xfa51d00f,0xf90f8009,0xf91ce004,0xf497c001}},	//   愛情, 防御, 性增, 麻麻
  { {0xfa6a7004,0x00000003,0x00000003,0x00000003}},	//   透水,   ,   ,
  { {0xf90ce006,0xf91ba00e,0xf81f9005,0x00000003}},	//   更大, 大前, 症下,
  { {0xfa65f00f,0xfb79f007,0xfb60e001,0xf83e7004}},	//   下方, 所生, 業組, 照以
  { {0xf81d5009,0xfb81f009,0xfa565001,0xf919c004}},	//   病例, 等生, 感柔, 点出
  { {0xf9444005,0xfb83b00d,0x00000003,0x00000003}},	//   等就, 恋的,   ,
  { {0xf83db00a,0x00000003,0x00000003,0x00000003}},	// [1750] 絡事,   ,   ,
  { {0xfb7e7007,0xfa892007,0xfa5f1001,0xf92dc004}},	//   砂石, 部曲, 億日, 取土
  { {0xf59a9007,0xf4c42004,0xf4a0e004,0xfa545004}},	//   一街, 三防, 口集, 定支
  { {0xf90d600e,0xfb4c0004,0xf8381001,0xf591d005}},	//   長年, 兵的, 書一, 研英
  { {0xfa810004,0xf8381004,0x00000003,0x00000003}},	//   中指, 相一,   ,
  { {0xf835f009,0xfb7cd004,0xfa782001,0xf83c1004}},	//   活会, 概算, 油打, 津人
  { {0xf5a15004,0xf930c004,0xfb5a000c,0xfa6bd00a}},	//   宇航, 投向, 入獄, 制格
  { {0xfb634004,0xf8213004,0xf4ba2001,0xf9206004}},	//   中相, 安仁, 要送, 院子
  { {0xf58f7004,0xf8345001,0xf91f0008,0xf5a7b005}},	//   南航, 吾人, 模原, 上起
  { {0xfb5b8009,0xfa733007,0xf932e004,0xfa5dd00c}},	//   大程, 山東, 站同, 各法
  { {0xf935e009,0xf948a001,0xfb59a00c,0x00000003}},	//   期增, 牌女, 春福,
  { {0xf9320009,0xf9496004,0xfb648005,0xf826f00a}},	//   法履, 夏区, 港物, 随一
  { {0xf946e00f,0xfb5c0007,0xfa659005,0x00000003}},	//   額度, 工系, 告投,
  { {0xfa60900f,0xf931e00f,0xf80f7005,0xfb75a010}},	//   三月, 愛商, 策以, 標登
  { {0xfb664001,0xfa645005,0xfa7c2002,0x00000003}},	//   臨終, 把每, 肥日,
  { {0xfa67100f,0xf936600f,0xf9470004,0xf90fa004}},	//   上方, 感受, 上出, 新四
  { {0xf931e00f,0xfa51100b,0xf826d009,0xf836d009}},	// [1760] 通安, 字新, 告人, 点上
  { {0xf5cb500e,0xf49de004,0xf5b95001,0xfa707005}},	//   堪能, 次降, 群聚, 岳池
  { {0xfb6b000f,0xf93ae009,0xfb81d00e,0xf925400e}},	//   太空, 作地, 則第, 復元
  { {0xf5a6b00b,0xfb6fe004,0xfb744001,0xf48bc001}},	//   看護, 列第, 料結, 海面
  { {0xf4a20007,0xf4938009,0xfb510005,0xf5a9d00c}},	//   召集, 国食, 台独, 量能
  { {0xfb62400b,0xfa525007,0xf5b1300c,0x00000003}},	//   本線, 供我, 細解,
  { {0xfa669001,0x00000003,0x00000003,0x00000003}},	//   後感,   ,   ,
  { {0xfb4ca006,0xf91ce001,0xfb819005,0xfb5b200c}},	//   康社, 別報, 指用, 焦的
  { {0xf4a5e00f,0xfa71b009,0xf937800c,0xfb6a4005}},	//   全額, 地改, 借出, 勒盟
  { {0xfb7df006,0xf8105006,0xf8207009,0xf93da005}},	//   清理, 字以, 者使, 的唐
  { {0xfb5d8008,0xf8325001,0xf4b5c001,0xf90c4005}},	//   大物, 施介, 生食, 海医
  { {0xf4b40004,0x00000003,0x00000003,0x00000003}},	//   会部,   ,   ,
  { {0xfa63f004,0xf91e2005,0xfa818005,0x00000003}},	//   安派, 氧吧, 般每,
  { {0xf4bae00e,0xfa886004,0xf938e001,0xf945800c}},	//   療養, 在控, 芝加, 手勢
  { {0xf83db00e,0xf949e004,0xfa5ab005,0xf945600a}},	//   絡下, 税公, 品折, 益子
  { {0xf593f009,0xf59c3001,0xf94a6001,0xfb809005}},	//   定自, 心裏, 意念, 分置
  { {0xf81fd009,0xfb799002,0x00000003,0x00000003}},	// [1770] 率不, 作班,   ,
  { {0xf5bc900f,0xf916a00f,0x00000003,0x00000003}},	//   入追, 人心,   ,
  { {0xf81f900e,0x00000003,0x00000003,0x00000003}},	//   症例,   ,   ,
  { {0xf9122008,0x00000003,0x00000003,0x00000003}},	//   台帳,   ,   ,
  { {0xfb4da007,0xf813f005,0x00000003,0x00000003}},	//   育組, 痛人,   ,
  { {0xfb55c001,0xf5a89004,0x00000003,0x00000003}},	//   治篇, 而至,   ,
  { {0xfa6b1006,0xf9426006,0xf5bd1004,0xf4a86005}},	//   其次, 慈善, 造血, 含金
  { {0xf59cd00e,0xf8453009,0xf5a9d008,0xfb520004}},	//   市街, 良信, 海老, 花炮
  { {0xf4ad4004,0xfa63d005,0x00000003,0x00000003}},	//   化集, 予注,   ,
  { {0xf4c6a004,0xfa765001,0xf5b61008,0xf8499001}},	//   残酷, 登機, 系譜, 表件
  { {0xf8373007,0xfa85000a,0xf946600d,0x00000003}},	//   人保, 本水, 昌府,
  { {0xfa661009,0xfb4f0008,0xf941a00c,0xf490200c}},	//   植株, 琵琶, 光分, 報送
  { {0xf935000b,0xfa5c7006,0xfb6e8004,0xfb793004}},	//   通常, 要性, 北站, 菜用
  { {0xf911a00b,0xfb813004,0xfb85b004,0xf9206005}},	//   新幹, 理知, 行着, 中反
  { {0xfa729004,0xfb57000c,0x00000003,0x00000003}},	//   尽最, 虹積,   ,
  { {0xf911e009,0xf81ef004,0xfb7eb001,0xf92dc005}},	//   共利, 但一, 終究, 化功
  { {0xf947000f,0xfa4fb005,0xf910600c,0xfa697005}},	// [1780] 行動, 取款, 山居, 意查
  { {0xf83ab009,0xfa62d004,0x00000003,0x00000003}},	//   步伐, 下月,   ,
  { {0xfa55500f,0xf9376001,0xf949600c,0x00000003}},	//   感情, 生健, 踏出,
  { {0xfb596009,0xf9340001,0xf9320001,0xf90ce00a}},	//   出申, 記完, 返家, 併協
  { {0xf92e2009,0xf5a4f001,0xf8297001,0xfb84500a}},	//   他媒, 認者, 買下, 光熱
  { {0xf5afb004,0xf930200c,0xfa67d00a,0x00000003}},	//   平街, 南加, 重洲,
  { {0xfa4dd00f,0xf490c00b,0xf947c009,0xf9440004}},	//   受損, 課長, 李小, 上安
  { {0xfa655009,0xf9230009,0xf8461001,0xfa70d004}},	//   双手, 是十, 助作, 育整
  { {0xf944200b,0xf4c78004,0xf8403001,0xf92de004}},	//   不安, 上防, 信你, 或少
  { {0xfa7f400f,0xfa67f00f,0xf943a001,0xf9214001}},	//   客服, 重新, 月八, 督府
  { {0xfa71b006,0xf9244009,0xf93ec004,0xfa86a005}},	//   地方, 氯化, 了再, 修房
  { {0xf5c91009,0xfa73d004,0xfb791001,0xf5c2700a}},	//   木耳, 款支, 門禁, 敬語
  { {0xf4c3800f,0xfa68d007,0xf9136009,0xf8319001}},	//   運送, 美感, 花山, 共五
  { {0xfb6aa008,0xfb5c000c,0xfa68d00c,0x00000003}},	//   質管, 肥瘦, 行曲,
  { {0xf91c0006,0xf92e4006,0xf9096009,0xfb867004}},	//   尤其, 成就, 然存, 告管
  { {0xf843f008,0xfa7a2001,0xf58f5004,0xf4b2c005}},	//   修一, 方想, 隔膜, 供雪
  { {0xfa59b006,0xfa7fe009,0xfa537008,0xf90fc00c}},	// [1790] 品有, 次是, 飛散, 共勉
  { {0xfa81c004,0xfa88000c,0x00000003,0x00000003}},	//   断拓, 雪歌,   ,
  { {0xf91ac007,0xf9310009,0xf58d1001,0xf9494004}},	//   令宣, 南平, 我跟, 族大
  { {0xfa63f009,0xf8231001,0xf9116005,0xf943a005}},	//   上月, 計作, 困大, 手参
  { {0xfa82e004,0xfb82f004,0x00000003,0x00000003}},	//   中控, 文盲,   ,
  { {0xf92aa00f,0xf918e005,0xfa66f00a,0xfb50400c}},	//   結合, 交心, 前条, 械科
  { {0xf49d6009,0xfa4fd005,0xf93a000c,0x00000003}},	//   性首, 比提, 需增,
  { {0xfb628009,0xf924000a,0xf4aca00c,0xf494a00d}},	//   独生, 景子, 某部, 曾都
  { {0xf93f2004,0xf934c008,0xf9250004,0xf9126005}},	//   但它, 備士, 是宣, 好前
  { {0xfa565004,0xf9436008,0xf945200c,0xf4c8000c}},	//   也未, 文年, 不忘, 崎頂
  { {0xf4aee001,0xf5c31005,0xf933000c,0x00000003}},	//   少都, 京街, 做做,
  { {0xfb512006,0xf932a009,0xf940e004,0xf90c2001}},	//   花生, 定市, 了六, 家報
  { {0xfa868006,0xfa661004,0xfa73100c,0xfa84e005}},	//   温暖, 立核, 山河, 本收
  { {0xf8269009,0xf9216005,0xfa5e3005,0x00000003}},	//   族事, 口原, 者教,
  { {0xf93b0005,0xf947000d,0x00000003,0x00000003}},	//   市奉, 里店,   ,
  { {0xf5c8f007,0xf9342004,0xf93f0005,0x00000003}},	//   訪談, 多天, 装店,
  { {0xfa629006,0xf92f6007,0xf943e001,0xf8281004}},	// [17a0] 吉林, 我就, 態分, 里以
  { {0xf943a004,0xf837d001,0xf9110001,0xfb6d2001}},	//   三基, 出他, 想出, 胖的
  { {0xfb79c008,0xfa703004,0xf59a7001,0xf930200c}},	//   仁王, 山概, 最著, 他到
  { {0xf91b4004,0xfb736005,0xf80db005,0xf91e200c}},	//   日全, 会神, 外保, 度到
  { {0xf9442007,0xfb857001,0xf824f004,0xf4958004}},	//   安平, 位神, 告会, 国都
  { {0xf93ba009,0x00000003,0x00000003,0x00000003}},	//   退出,   ,   ,
  { {0xfa8b8004,0xf944e005,0xf90e200c,0x00000003}},	//   株洲, 前参, 馳名,
  { {0xf81a1009,0xfb857004,0xf92c4001,0xfb7e9005}},	//   品住, 祈祷, 黑心, 分界
  { {0xfb839007,0xf939c004,0x00000003,0x00000003}},	//   見的, 要始,   ,
  { {0xf93e0009,0xf4ac0001,0xf934a00c,0x00000003}},	//   内各, 金配, 甚大,
  { {0xf4b7c007,0xf4c3200c,0xfb6dc005,0xfb57600c}},	//   生都, 三連, 或生, 根的
  { {0xf9462006,0xf911400c,0xf93a0005,0x00000003}},	//   配套, 柱子, 省名,
  { {0xf8247004,0xfa63b004,0xfa59b004,0xfa731005}},	//   不低, 光春, 秀文, 都旅
  { {0xfb58600c,0xf918a00c,0xfa5cf00a,0xf949a005}},	//   人短, 吸力, 市浪, 明副
  { {0xfb869009,0xfb632001,0xf92d8004,0xf5ca9004}},	//   前第, 代社, 子学, 火花
  { {0xf9130006,0xf93d2006,0xf59af00e,0xf919a001}},	//   国内, 市天, 往路, 人印
  { {0xfb58e001,0xf4c88005,0xfa6f500d,0x00000003}},	// [17b0] 樹種, 和音, 柳江,
  { {0xfa635006,0xfb75a00e,0xfa898004,0xfb772001}},	//   合法, 候群, 哪怕, 生無
  { {0xf5b81009,0xf91ba004,0xf92f2001,0xf93d2005}},	//   除草, 大反, 研商, 参差
  { {0xf82e1009,0xf9298001,0xf4982005,0x00000003}},	//   想上, 用場, 方金,
  { {0xf93e4004,0xf841f00c,0x00000003,0x00000003}},	//   理先, 索人,   ,
  { {0xfa65d006,0xf5c0b007,0xfa525004,0xfa846004}},	//   前提, 信貸, 会明, 央文
  { {0xfa7c6006,0xf5b7d001,0xf8297004,0xfb754005}},	//   性文, 人著, 量以, 博白
  { {0xfa5cd00f,0xf924e007,0xf93cc007,0xf9120004}},	//   送方, 種原, 送出, 柿子
  { {0xf9402001,0xf948a004,0xf9262004,0xf921c00c}},	//   商協, 完好, 是地, 離別
  { {0xf58af004,0xf90a8004,0xf5c03001,0xfa6df00a}},	//   子行, 混凝, 跡象, 極性
  { {0xfb859004,0xf9292001,0xf49f2001,0xfa886004}},	//   完税, 炫彩, 素面, 被提
  { {0xf9464008,0xf938a008,0x00000003,0x00000003}},	//   不審, 障子,   ,
  { {0xfb588009,0xfa5cf004,0xf58d700c,0xf915e005}},	//   核的, 市洪, 化講, 白峰
  { {0xf9260005,0xf9432005,0xf597700c,0x00000003}},	//   在夏, 程同, 補行,
  { {0xf4c5800c,0xfb83b002,0x00000003,0x00000003}},	//   行遍, 按登,   ,
  { {0xf9206004,0xf943200a,0xfb71000c,0xf93ea00d}},	//   象大, 事免, 粗細, 包土
  { {0xfa79d00b,0xf90d4008,0xf91b600a,0x00000003}},	// [17c0] 日時, 兵士, 武将,
  { {0xfa898009,0xfa631007,0xf93b000e,0x00000003}},	//   在水, 拉斯, 補強,
  { {0xf92a000f,0xf4c80001,0xf4ad200c,0xfa54b00c}},	//   道安, 踏青, 向金, 星歌
  { {0xfb6f8009,0xf9168004,0xfa4d5004,0xf4bf0004}},	//   林火, 人品, 易洽, 的阻
  { {0xf81c1006,0xfb5e0006,0xf92e6009,0xf9454004}},	//   一份, 加盟, 民大, 立公
  { {0xf9460007,0xf945e004,0xfa7c5004,0xfa77f001}},	//   行各, 下基, 左旗, 麻油
  { {0xfa87c009,0xf92de001,0xf8475001,0xf9376004}},	//   革方, 北城, 快一, 生入
  { {0xf93d6004,0xf90fc001,0xf491c008,0xfa687001}},	//   久前, 己和, 濾過, 礎教
  { {0xf847100f,0xf4b8800b,0xfa54f004,0xfa75f00a}},	//   含例, 距離, 食流, 人案
  { {0xf942200f,0xf5a53001,0xf8135004,0xf5975008}},	//   商家, 合議, 望京, 秘話
  { {0xf8257005,0xfb4ca00a,0xf83dd005,0xf911a002}},	//   王中, 職相, 股上, 米其
  { {0xf4c7a00e,0xf92e4009,0xfa60d004,0xfa623004}},	//   慎重, 滑坡, 玉泉, 等材
  { {0xfa617004,0xf9466008,0xfb584004,0xf911600a}},	//   均未, 王国, 空置, 影協
  { {0xf9150006,0xf9478004,0xf93c200c,0xf935a00c}},	//   国大, 削弱, 約合, 領受
  { {0xf4c56007,0xf837d001,0xf93e6001,0xfa4ed004}},	//   下連, 出世, 情定, 黑板
  { {0xf8247009,0xfa753008,0xf8149005,0x00000003}},	//   守信, 能日, 生介,
  { {0xf59c3008,0xfb859001,0xfa52b00c,0xfa6fb00c}},	// [17d0] 寄贈, 富美, 何東, 女演
  { {0xfa50d005,0x00000003,0x00000003,0x00000003}},	//   法投,   ,   ,
  { {0xfa54100a,0x00000003,0x00000003,0x00000003}},	//   弘明,   ,   ,
  { {0xf9374009,0xf5993007,0xfb57e001,0xf82bf004}},	//   生大, 神起, 常看, 水井
  { {0xf927a004,0xfa86a00a,0x00000003,0x00000003}},	//   物古, 館文,   ,
  { {0xf941e00b,0xf812100f,0xfb51000c,0x00000003}},	//   午後, 法人, 印第,
  { {0xf9406001,0x00000003,0x00000003,0x00000003}},	//   理全,   ,   ,
  { {0xfb84f009,0xf8127009,0xfa7a7004,0xf9470005}},	//   不理, 会一, 除本, 上基
  { {0xfb7aa007,0xfb554004,0xfa5ef004,0xfa6a500c}},	//   送皆, 好相, 如水, 援手
  { {0xf8155004,0xf9462005,0xf5a07005,0xf825300c}},	//   多份, 不叫, 了身, 及作
  { {0xfa5cd007,0xf9462008,0xfa589001,0xf9288005}},	//   省油, 不倫, 神方, 虫子
  { {0xfa79d005,0xfa65f005,0xf93f000c,0x00000003}},	//   入流, 名法, 逃出,
  { {0xf9496006,0xfa5f100c,0xf92b000c,0x00000003}},	//   福建, 考方, 親出,
  { {0xfb6f6001,0xf9136004,0xf4b06001,0xf9124004}},	//   化玻, 影家, 捕魚, 施及
  { {0xf8149009,0xf923600a,0xf9248005,0xf939c00c}},	//   生事, 中尾, 斯在, 送安
  { {0xf93bc004,0xfa73b008,0xf9154004,0xf836d00c}},	//   私利, 週水, 都出, 方下
  { {0xfb4ea009,0xfb506007,0xf9154009,0xf5b01001}},	// [17e0] 地等, 新研, 能出, 己要
  { {0xfa55300f,0x00000003,0x00000003,0x00000003}},	//   務業,   ,   ,
  { {0xfb59a006,0xf917e007,0x00000003,0x00000003}},	//   核算, 選名,   ,
  { {0xfa896009,0xf91a6005,0x00000003,0x00000003}},	//   在收, 入多,   ,
  { {0xfa553004,0xf91e6004,0xf80d7004,0xf4b70001}},	//   会承, 信内, 街上, 速連
  { {0xfa878006,0xf9422006,0xf4c62001,0xf81c3004}},	//   天津, 草原, 位雨, 市九
  { {0xf9296009,0xf92ca004,0xf91ec00c,0x00000003}},	//   用其, 金分, 大呼,
  { {0xf8285009,0xfa779005,0xf920000d,0x00000003}},	//   而使, 点情, 趣和,
  { {0xf821f00f,0xf5a8700e,0xfa840004,0xfb65c004}},	//   有保, 家計, 中水, 是精
  { {0xfa66d009,0xfa7a3004,0xfb6c8004,0xf9222002}},	//   同法, 急指, 斑病, 公厘
  { {0xf4c4c004,0xf9336008,0xfa5ed005,0xf94a2005}},	//   之首, 辛口, 密植, 氏家
  { {0xf4980001,0xfb7a200c,0xfa51f002,0x00000003}},	//   人部, 謀生, 厚棉,
  { {0xf5a8b006,0xfa57b00b,0xfb875004,0xf5a13005}},	//   收藏, 作所, 明等, 光耀
  { {0xf9346006,0xfb798009,0xfb7bc001,0xfb5da004}},	//   博客, 秀的, 一空, 性物
  { {0xf9254006,0xf9348004,0xfb62e004,0xf5c53001}},	//   利局, 定形, 是福, 肩膀
  { {0xfb74600e,0xf4b36007,0xfa649004,0xf58f1008}},	//   教習, 聚餐, 先来, 純資
  { {0xf840100f,0xf92fe007,0xf92cc004,0xf9404001}},	// [17f0] 董事, 投市, 向四, 者出
  { {0xfb7b8004,0xfb76c001,0xf594f001,0xf82d1004}},	//   品研, 察第, 感言, 致以
  { {0xf944a00e,0xf8325009,0xfa858004,0xf83a1005}},	//   消去, 能上, 是根, 司中
  { {0xf90a2004,0xf921c001,0xf8401005,0x00000003}},	//   号市, 正字, 患上,
  { {0xf5a4b001,0xf919200c,0xfa67f005,0x00000003}},	//   下街, 此分, 行校,
  { {0xf58f1008,0xf4a46002,0xf917a002,0x00000003}},	//   民課, 亮采, 登堡,
  { {0xfa826004,0x00000003,0x00000003,0x00000003}},	//   是消,   ,   ,
  { {0xf942a009,0xfa6a300a,0x00000003,0x00000003}},	//   三八, 過性,   ,
  { {0xfa751004,0xfa8ae001,0xf9486005,0x00000003}},	//   去掉, 火柴, 量得,
  { {0xfa699006,0xf90a6009,0xfb5ec00e,0xf93a2004}},	//   住房, 家店, 造物, 稀土
  { {0xf924a00c,0x00000003,0x00000003,0x00000003}},	//   犬女,   ,   ,
  { {0xfa7c3004,0xf9310004,0xfb7a6008,0xf49ae00c}},	//   以根, 南岳, 私的, 書都
  { {0xf8467006,0xf5bf1001,0xf8149001,0xf944600a}},	//   用了, 慢行, 生下, 律子
  { {0xf826d001,0xf9206004,0xf9328005,0x00000003}},	//   住一, 次学, 会十,
  { {0xfb75a00c,0xf4bca00c,0xf912600d,0x00000003}},	//   站登, 還送, 好反,
  { {0xfa79d00c,0xfb6c800a,0xfa6eb005,0x00000003}},	//   此成, 準等, 育比,

  { {0xfa5ff007,0xfa6c1004,0xfb5ce008,0xfa547004}},	// [1800] 分成, 海浦, 略称, 速效
  { {0xfb7f200a,0x00000003,0x00000003,0x00000003}},	//   心疾,   ,   ,
  { {0xf81bf007,0xfb750001,0xfa5f5004,0xf4c58001}},	//   送修, 多空, 者昨, 行配
  { {0xf811f001,0xf936c005,0xfb67a00c,0x00000003}},	//   展令, 原微, 早知,
  { {0xf4b1a007,0xfa75700e,0xf93d0008,0xf597f001}},	//   純音, 電所, 各務, 生課
  { {0xfb6e0001,0xfa52f001,0xf93cc004,0xfa683004}},	//   我目, 望未, 的垃, 量排
  { {0xf9392009,0xf5a5d004,0xfb859004,0xf910e004}},	//   一式, 上街, 前生, 地可
  { {0xfa77d007,0xf9124001,0xf933e005,0xf591500d}},	//   主治, 能安, 通八, 展良
  { {0xf597100f,0xf940e009,0xf943a004,0xf5a05008}},	//   果草, 均属, 合全, 昆虫
  { {0xfb811004,0xf4a1e001,0xf9446005,0xfb76c00c}},	//   拉美, 業達, 勉励, 高登
  { {0xfa83e004,0xf4bf6004,0xfa4c3005,0xfa87c005}},	//   中收, 分高, 成材, 火情
  { {0xfb817007,0xf92ca004,0xfa6e900a,0x00000003}},	//   悉的, 姑娘, 懲戒,
  { {0xf9282009,0xfb6d6004,0xf82b500c,0xf4b4200c}},	//   玩忽, 店等, 場供, 定適
  { {0xf9442004,0xfa7c7004,0xf820b001,0xfb74e001}},	//   安岳, 性指, 談作, 高盛
  { {0xfb89b004,0xf5c01008,0x00000003,0x00000003}},	//   低端, 無責,   ,
  { {0xf49a4006,0xf59d5001,0xf827f005,0x00000003}},	//   交部, 的菜, 低一,
  { {0xf941a008,0xfa80300a,0x00000003,0x00000003}},	// [1810] 贈呈, 院機,   ,
  { {0xf83df004,0xfb7e2001,0xf93be001,0xf9198005}},	//   模不, 者皆, 送審, 急反
  { {0xf93da009,0xfb6ae009,0xfa611004,0xfa858008}},	//   的子, 道理, 切成, 可決
  { {0xfb50a007,0xfb85f005,0x00000003,0x00000003}},	//   農田, 立特,   ,
  { {0xfa66f006,0xf4a08004,0xfb78400c,0xfb58600c}},	//   再次, 索道, 府秘, 酸的
  { {0xf5a65005,0x00000003,0x00000003,0x00000003}},	//   告解,   ,   ,
  { {0xf5a05004,0xf83a1001,0x00000003,0x00000003}},	//   率超, 略了,   ,
  { {0xf937800b,0xf91b6009,0xf90c4008,0xfa68f001}},	//   九州, 学分, 家康, 美村
  { {0xf9390006,0xf9382006,0xf4ad4005,0xf9134005}},	//   一名, 舟山, 取集, 能忘
  { {0xfb6e4001,0xf9110004,0xf82b500c,0xfb5e600c}},	//   五等, 想基, 其任, 堡的
  { {0xfa75d007,0xf92ac009,0xf941000e,0xfa832004}},	//   主教, 士兵, 有名, 本推
  { {0xfb49c008,0xf59d5004,0x00000003,0x00000003}},	//   康福, 装行,   ,
  { {0xf4992001,0x00000003,0x00000003,0x00000003}},	//   吸道,   ,   ,
  { {0xf927c004,0xf488e001,0xfa78700c,0xf498c00c}},	//   士分, 島門, 出正, 書針
  { {0xfb6da006,0xfb891009,0xfa7f5009,0xf93e8001}},	//   受益, 像素, 大水, 時地
  { {0xfb77a004,0xf4b58010,0x00000003,0x00000003}},	//   期相, 余韻,   ,
  { {0xf596d00c,0xfa725005,0xfb6fc00a,0xfb895005}},	// [1820] 付諸, 共患, 列目, 明火
  { {0xf9260006,0xf5955004,0xf9212004,0xfa876001}},	//   温州, 原装, 握好, 縮水
  { {0xfa7c1009,0xf91e4009,0xf93f0008,0xfa805001}},	//   学成, 武夷, 昆布, 無患
  { {0xf9474009,0xf93e2004,0xfa805004,0xfb57600c}},	//   把好, 内分, 正意, 人神
  { {0xfb800001,0xfa527004,0xf91a6001,0xf5ab7008}},	//   各直, 定意, 書大, 究費
  { {0xf9318008,0xf9292008,0x00000003,0x00000003}},	//   供元, 角型,   ,
  { {0xfa52f00f,0xf5bfb005,0xf5ad100c,0x00000003}},	//   站服, 次表, 色而,
  { {0xfb61e00f,0xfb660004,0xf8295004,0xfa7b1005}},	//   趣用, 售管, 海三, 急演
  { {0xf910a009,0xf90b6001,0xf5c39005,0x00000003}},	//   澳大, 然出, 中至,
  { {0xf491c007,0xfb772004,0xfa6d7004,0xfb6e2001}},	//   東部, 果等, 段是, 民督
  { {0xf91b4006,0xf9442005,0xfa896005,0xfa5e9002}},	//   日在, 操守, 自提, 待我
  { {0xf9138004,0xf9460001,0xf91c400d,0x00000003}},	//   英德, 行善, 工宿,
  { {0xf945000c,0x00000003,0x00000003,0x00000003}},	//   額分,   ,   ,
  { {0xf9324006,0xf9366007,0xf91ae001,0xfa67f005}},	//   多名, 生化, 盤大, 前慰
  { {0xf935a004,0xf489e00c,0x00000003,0x00000003}},	//   会地, 島金,   ,
  { {0xfb6a6004,0xfa5ef00a,0x00000003,0x00000003}},	//   被申, 元日,   ,
  { {0xf947c009,0xf92da004,0xf49b4001,0xfa579001}},	// [1830] 位地, 易地, 春風, 神木
  { {0xf4bee00b,0xf5b07004,0xfb762004,0xf9336005}},	//   掃除, 地街, 胞的, 多增
  { {0xf9464001,0xf83cb005,0x00000003,0x00000003}},	//   名全, 春佳,   ,
  { {0xf4ae8004,0xf940600c,0x00000003,0x00000003}},	//   他部, 者常,   ,
  { {0xf924a009,0xfa77f001,0xfa781001,0xfb518008}},	//   路公, 役期, 書所, 西線
  { {0xf940e00f,0xfb5c800e,0xf5bf1007,0xf93ca004}},	//   居家, 大級, 客車, 的封
  { {0xf921600a,0x00000003,0x00000003,0x00000003}},	//   信制,   ,   ,
  { {0xfa4f1004,0xf9134001,0xf8203001,0xf80eb004}},	//   列材, 命力, 旅人, 金主
  { {0xfb4f200b,0xf8417009,0xf942e00c,0x00000003}},	//   到着, 中也, 見光,
  { {0xf924c004,0xf91ca008,0xf93c4005,0xf92f8005}},	//   可售, 大喜, 布式, 朔州
  { {0xf5a0b009,0xf4ca000a,0xf844d005,0x00000003}},	//   充足, 与那, 肩上,
  { {0xf925a009,0xfa7c1007,0xf5aad001,0x00000003}},	//   周刊, 急性, 破裂,
  { {0xf9412009,0xf9298004,0xfa645004,0xf920200c}},	//   有小, 用年, 益最, 加味
  { {0xf4984001,0xfa75f004,0xf93b4004,0xf83f9005}},	//   出頭, 函数, 市名, 冠以
  { {0xf93c4001,0xfa713001,0xf588d001,0x00000003}},	//   所報, 由民, 青草,
  { {0xf9462006,0xfa858004,0xf812d005,0xfa77900a}},	//   行分, 在授, 丙二, 点滅
  { {0xfa7f3005,0xf927200a,0xfa69f00c,0x00000003}},	// [1840] 大收, 師免, 護持,
  { {0xf922a00f,0xf4c36001,0xf5c6d004,0x00000003}},	//   離島, 月達, 蕨菜,
  { {0xfa525009,0xfa707007,0xfa6f5007,0xf823f004}},	//   定植, 泳池, 音機, 三份
  { {0xf4a6a007,0xfa6f3008,0xf93b000a,0xfb6ba00c}},	//   宮頸, 防本, 着席, 質細
  { {0xfa71100f,0xf5bf900e,0xf92cc001,0xfa54500c}},	//   花果, 加費, 科博, 忘憂
  { {0xf90f4006,0xf91d000c,0xf5b9b00c,0xf910c005}},	//   台市, 別強, 券表, 西夏
  { {0xfb891001,0x00000003,0x00000003,0x00000003}},	//   跌破,   ,   ,
  { {0xfb77a001,0xfb606004,0xf939e00d,0x00000003}},	//   初生, 口税, 初就,
  { {0xf949000e,0xfa77f004,0xf9468005,0xf5c0d00c}},	//   美子, 容搜, 反差, 溢著
  { {0xf928c009,0x00000003,0x00000003,0x00000003}},	//   被列,   ,   ,
  { {0xfa5bf004,0xfa4d3001,0xf916c00c,0x00000003}},	//   市沙, 成正, 出商,
  { {0xfb686001,0xfa7d5004,0xf5a97008,0x00000003}},	//   全符, 性演, 競艇,
  { {0xf59bf007,0xfa4eb009,0xf9172004,0xfa5cb001}},	//   所能, 金来, 容局, 的概
  { {0xfb49e006,0xfb684009,0xfb6fc009,0xf5971004}},	//   究生, 用管, 答疑, 果肉
  { {0xf91dc00e,0xf9244009,0xf916e00e,0xf59e3001}},	//   冠婚, 售假, 電化, 抄表
  { {0xf49ea007,0xf90ca009,0xf9326004,0xf9396001}},	//   採集, 海国, 多小, 果可
  { {0xf48c4004,0xf92d8005,0x00000003,0x00000003}},	// [1850] 年部, 少取,   ,
  { {0xfa5ef001,0xf93ca004,0xf92ea00a,0xf941e00a}},	//   商時, 禁区, 科区, 隆史
  { {0xfa6f1007,0xfa603001,0xfb77e001,0xf9424001}},	//   防潮, 充斥, 惜的, 采度
  { {0xfa793005,0xf914000c,0xf4a02002,0x00000003}},	//   空浸, 飽受, 正重,
  { {0xf94a000f,0xf9262007,0xf5c93005,0xfb52400d}},	//   住地, 輩子, 株距, 好秋
  { {0xf909e004,0xfb7b4008,0xfb802001,0xf4b6600c}},	//   架子, 療福, 者群, 初開
  { {0xfa753007,0xf8405004,0x00000003,0x00000003}},	//   能接, 口不,   ,
  { {0xf9454007,0xfa561004,0xfa79d001,0xf4b4200c}},	//   名媛, 募捐, 憤怒, 力霸
  { {0xfb7e0001,0xfa5a900c,0xf915400c,0xf5a4100c}},	//   萄糖, 府施, 能基, 車袋
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf5aef004,0xfb7fc004,0xfa653005,0x00000003}},	//   械行, 璃瓶, 和残,
  { {0xf488a00b,0xfa882009,0xf9472004,0x00000003}},	//   究開, 迫感, 植基,
  { {0xfa4e501e,0xf49e200c,0xfa5f7002,0x00000003}},	//   民武, 校送, 姆指,
  { {0xfa545008,0xf9406004,0xf8257005,0xfb881005}},	//   務提, 理在, 程代, 萎病
  { {0xfa5bb007,0xfa70d008,0xf90fa001,0xfb57c004}},	//   要推, 便所, 新力, 霸王
  { {0xf93b600e,0xf93e6001,0xfa882008,0xfa7e5005}},	//   市小, 市值, 快感, 性性
  { {0xf926400a,0xfb7a000c,0xf90ea00a,0x00000003}},	// [1860] 修大, 所熟, 色展,
  { {0xf90e6009,0xfa87a009,0xfb63a004,0xf917c004}},	//   乳品, 在推, 京短, 固化
  { {0xf5b5f00f,0xf48f800f,0xfa555001,0xfb614005}},	//   登記, 味道, 定放, 次由
  { {0xf84a3006,0xfa739009,0xf4c64009,0xfa539007}},	//   身份, 拼搏, 降雨, 香料
  { {0xf8391008,0x00000003,0x00000003,0x00000003}},	//   竹中,   ,   ,
  { {0xfa643004,0xfa645004,0xf916e004,0x00000003}},	//   不把, 等数, 系在,
  { {0xf919c009,0xf58c5008,0xfb576005,0xf92de005}},	//   查封, 化計, 出科, 受城
  { {0xf59e5006,0xf5c5d007,0xfa727007,0xf93aa004}},	//   的路, 全行, 社教, 局外
  { {0xf9404001,0xfa753001,0xfa733001,0xf949200c}},	//   者基, 能急, 英格, 慎引
  { {0xfa6e700f,0xfa705004,0xf933200c,0xfb4f600c}},	//   農村, 新投, 些可, 冰的
  { {0xf90b4009,0xf9130004,0xfa761004,0xf59ef004}},	//   家学, 国居, 好水, 理考
  { {0xfa7f7009,0xfa6d1001,0xf848b005,0x00000003}},	//   造性, 買海, 表以,
  { {0xf845b005,0xfa623005,0x00000003,0x00000003}},	//   周下, 理段,   ,
  { {0xf831900b,0xf9204004,0xfb5e0005,0xfa4eb005}},	//   新人, 加就, 加生, 化景
  { {0xf4b94001,0xf926a004,0xfa6f9001,0xf93ec004}},	//   作風, 周四, 己有, 的巡
  { {0xf8347009,0xf92e8004,0xf93e4004,0xf5965010}},	//   幼保, 徐家, 理合, 孝行
  { {0xf9118006,0xfa83f00a,0xfa68300c,0x00000003}},	// [1870] 平台, 修所, 行春,
  { {0xfa535004,0xfb764005,0x00000003,0x00000003}},	//   会感, 写申,   ,
  { {0xf944a004,0xf93a200c,0xfa53700c,0xf920600d}},	//   案室, 停出, 力梭, 播和
  { {0xf92e200f,0xf848d006,0xfb488006,0xf911c001}},	//   南市, 在使, 奶粉, 報復
  { {0xfa88c001,0xf9268005,0x00000003,0x00000003}},	//   親情, 用假,   ,
  { {0xf948400c,0xf81cd005,0xfa603005,0xf4c20002}},	//   族委, 禁使, 者死, 合需
  { {0xfb7a8004,0xf25f101f,0x00000003,0x00000003}},	//   郁的, 信ｑ,   ,
  { {0xfb6f400f,0xf9128007,0xfb70a001,0xfa799005}},	//   金石, 政全, 動生, 出数
  { {0xf8427009,0xf5b9900e,0xfa59d004,0xf4c4800c}},	//   口中, 工要, 喜悦, 再重
  { {0xfa70f004,0xfb5dc001,0xf9206001,0xfa817004}},	//   乳油, 度社, 業前, 正成
  { {0xfa539009,0xf58df001,0xf93d400c,0x00000003}},	//   定成, 著要, 約四,
  { {0xf917200f,0xf936400e,0xf9152009,0xf9432004}},	//   確定, 仙台, 百家, 程完
  { {0xfa4eb009,0xfa849007,0xfa84d001,0xf81e5005}},	//   化是, 縮減, 冬新, 内供
  { {0xf926a004,0xfa83d004,0xf927c001,0xfb64c00a}},	//   利店, 解更, 部彩, 敬称
  { {0xf91c0007,0xf9304001,0xf92e400c,0xfb55a008}},	//   群島, 塗層, 成報, 電球
  { {0xfb65c007,0xfb85200c,0xfb5b600a,0x00000003}},	//   種種, 先申, 給率,
  { {0xf9342004,0x00000003,0x00000003,0x00000003}},	// [1880] 楚天,   ,   ,
  { {0xfb6aa004,0x00000003,0x00000003,0x00000003}},	//   材等,   ,   ,
  { {0xf93fa009,0xf9188009,0xf945e004,0xf9398004}},	//   万名, 缺口, 始建, 流合
  { {0xf838100c,0x00000003,0x00000003,0x00000003}},	//   諸位,   ,   ,
  { {0xfa7bf001,0xfa517001,0xf5b2b005,0xf4b30005}},	//   入次, 織沿, 命老, 定高
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa5df00c,0x00000003,0x00000003,0x00000003}},	//   項情,   ,   ,
  { {0xfb72600a,0x00000003,0x00000003,0x00000003}},	//   何百,   ,   ,
  { {0xf919a006,0xf8241007,0xfa6dd004,0xfb5d400c}},	//   出具, 下保, 育文, 你省
  { {0xf93f4006,0xfa823004,0xf5b3d004,0xf5b9900c}},	//   垃圾, 中推, 西至, 券自
  { {0xf9130007,0xfb64a008,0xfa55b001,0x00000003}},	//   製商, 央線, 妙方,
  { {0xfa6b3004,0xf499800c,0xf93a2005,0x00000003}},	//   海林, 幹麻, 持城,
  { {0xfa75f004,0xf5a0b00c,0xfa73d005,0xfa789010}},	//   好收, 商設, 放慢, 電柱
  { {0xf4ab400e,0xf4bce009,0xf4b68001,0xfb5b8005}},	//   冒頭, 市首, 星雨, 大看
  { {0xf92f8005,0xfa4fb00c,0x00000003,0x00000003}},	//   斗在, 金援,   ,
  { {0xfb85e004,0xf917c001,0xf9228001,0xfa4eb008}},	//   下空, 刻度, 口客, 演技
  { {0xfa63900a,0x00000003,0x00000003,0x00000003}},	// [1890] 吉澤,   ,   ,
  { {0xf8309005,0xfa843005,0x00000003,0x00000003}},	//   害信, 本改,   ,
  { {0xf5aab008,0xf918e00c,0xf927e00c,0x00000003}},	//   長補, 胺基, 質又,
  { {0xfa77f009,0xf9452004,0xf9340001,0x00000003}},	//   人未, 再分, 記後,
  { {0xfa64b009,0xf82c5007,0xfa889004,0xf927400a}},	//   案查, 買人, 在治, 修制
  { {0xf9252007,0xfb4d8001,0xf90de004,0xf945200c}},	//   可加, 年社, 段学, 而安
  { {0xf940e007,0xfa645009,0xf93c8008,0xf9358008}},	//   三名, 等新, 封入, 教大
  { {0xf91be001,0xf5c03001,0xf914000a,0xfb4fe005}},	//   室報, 素色, 牽引, 育示
  { {0xfa559007,0xf9112008,0xf84b1008,0xfa72d001}},	//   真愛, 台形, 未使, 穿搭
  { {0xf93e000f,0xfb540001,0x00000003,0x00000003}},	//   項商, 格範,   ,
  { {0xf8253004,0xf8435004,0xf93b2004,0xf8187010}},	//   上保, 中使, 持原, 帝京
  { {0xf9376004,0xfa57d005,0xfb5ce00c,0xf498800a}},	//   塞北, 作概, 別由, 層階
  { {0xfa5d900f,0xfa60f00f,0xf5a23009,0xfa7ad007}},	//   的我, 載明, 合考, 常方
  { {0xfa68b006,0xf830d004,0x00000003,0x00000003}},	//   明星, 使一,   ,
  { {0xf9422006,0xfa6dd008,0xf9470001,0xf812d005}},	//   版局, 水深, 重度, 写上
  { {0xfa6e7005,0xfa887005,0xf935e00c,0xfb6b600c}},	//   即每, 士提, 期州, 自申
  { {0xf5c5f00b,0xf911c009,0xf92fe005,0xf94ae005}},	// [18a0] 用規, 由器, 化平, 税函
  { {0xf812d009,0xf5c6f004,0xf845f001,0xfa7f7005}},	//   教事, 虫草, 詩作, 性水
  { {0xfa8b8001,0x00000003,0x00000003,0x00000003}},	//   自慰,   ,   ,
  { {0xfa73f004,0xf9410004,0xfa5a9001,0xf5b0700a}},	//   施投, 有前, 要教, 己資
  { {0xf8401007,0xfb686001,0xfa4e5005,0xf4b12002}},	//   面保, 浩然, 成数, 盛里
  { {0xfa683004,0x00000003,0x00000003,0x00000003}},	//   行来,   ,   ,
  { {0xf5ac500e,0xf9242004,0xf5b4f001,0xf598300c}},	//   康診, 公建, 登載, 娜芙
  { {0xfa869009,0xf9342008,0xf5af1005,0xf93c400a}},	//   在教, 誘導, 甲苯, 茂原
  { {0xfa799006,0x00000003,0x00000003,0x00000003}},	//   出新,   ,   ,
  { {0xfa5b500e,0x00000003,0x00000003,0x00000003}},	//   療所,   ,   ,
  { {0xfb596004,0xf8113004,0xf4a04008,0xfa63500c}},	//   人眼, 得侵, 無難, 友服
  { {0xf5af1009,0xf8255004,0xf921800a,0x00000003}},	//   新老, 不依, 次創,
  { {0xf81b9009,0xf821b001,0x00000003,0x00000003}},	//   局交, 先上,   ,
  { {0xf93c200f,0xf93ca009,0xfa7b9001,0x00000003}},	//   組合, 的威, 度招,
  { {0xf91e000f,0xf919a007,0xf9208001,0xf9136004}},	//   婦女, 人地, 你家, 格型
  { {0xfa68f00b,0xfa76f009,0xfb742001,0xfa7df001}},	//   家族, 示教, 務生, 牧業
  { {0xf5a3d00c,0xf824300d,0x00000003,0x00000003}},	// [18b0] 效良, 越不,   ,
  { {0xfb61e00e,0xf82fb009,0xf838d004,0xf9190020}},	//   公的, 新会, 出以, 出券
  { {0xf9310007,0xfa889009,0xfb4ac001,0xf849f00c}},	//   北平, 天水, 究目, 含人
  { {0xfb6a0004,0x00000003,0x00000003,0x00000003}},	//   怪物,   ,   ,
  { {0xfb86c009,0xfb7e0007,0xfa65b001,0xfa807008}},	//   告知, 情的, 手握, 難所
  { {0xfa68f006,0xf820d004,0xf9436008,0xf9352001}},	//   扶持, 率作, 草加, 記原
  { {0xf80c9001,0x00000003,0x00000003,0x00000003}},	//   袖上,   ,   ,
  { {0xfa529009,0xfa811007,0x00000003,0x00000003}},	//   投放, 業指,   ,
  { {0xfa527009,0xfa643007,0xf4a6a004,0xf4928005}},	//   会所, 及服, 目都, 国野
  { {0xf9464005,0xfa4c9005,0xfa4f100c,0x00000003}},	//   名在, 毒液, 近想,
  { {0xfa66500f,0xf833500e,0xfa4a7009,0xf9226007}},	//   希望, 政令, 易所, 本府
  { {0xf9170004,0xfa83100a,0xf947400c,0xfa5cd005}},	//   点名, 中治, 小宇, 遂溪
  { {0xfb7da00b,0xfa781004,0xfa4f5001,0xf5c7500c}},	//   装着, 人注, 套措, 種茶
  { {0xf4b2e00a,0xf5c3b00a,0xfa51900c,0xf4c82010}},	//   務開, 業許, 盛時, 二鳥
  { {0xfb60600b,0xfa83f004,0xf4b4c004,0xf8329004}},	//   季節, 患整, 生野, 由交
  { {0xf8477009,0xf4b3a008,0xf5a65002,0x00000003}},	//   利信, 通達, 告董,
  { {0xf812d006,0xf4a94004,0xfb68c00d,0x00000003}},	// [18c0] 留下, 薪金, 株的,
  { {0xf5aa7005,0xf9218005,0xfa71f002,0x00000003}},	//   件被, 口向, 替我,
  { {0xfa51d008,0xfa5b300c,0x00000003,0x00000003}},	//   通案, 垂涎,   ,
  { {0xfa7f5006,0xfa66d009,0xf4afc00e,0xf9242004}},	//   性收, 前正, 洗面, 目内
  { {0xf90c4004,0xfb56a001,0xf5a4b00c,0xf90d400c}},	//   家巷, 治研, 下著, 場出
  { {0xf8361007,0xf82fd009,0xfa831009,0xf947c005}},	//   兼任, 地保, 本溪, 税完
  { {0xf81b3009,0xf83f3009,0xf5a4d004,0xfa7a7004}},	//   市二, 章中, 名考, 方海
  { {0xf9472004,0xfb7da004,0xfa5f3004,0xfa63d005}},	//   同在, 寄生, 情暖, 下沙
  { {0xf945200b,0xfb700007,0xf91a800a,0xf5b33005}},	//   興味, 違約, 奥州, 松苗
  { {0xfb7da007,0xfb864001,0xf9420005,0xfb7fc005}},	//   範生, 刊第, 分就, 分生
  { {0xf8455004,0xf92f4001,0xfa79d001,0xfa663004}},	//   利企, 字字, 役政, 程款
  { {0xf8103008,0xf5911001,0xf9442005,0xf5a01005}},	//   北信, 著走, 名合, 文萃
  { {0xfa79500b,0xf938e001,0x00000003,0x00000003}},	//   交換, 作冒,   ,
  { {0xfb61200f,0xf58e100a,0x00000003,0x00000003}},	//   連線, 子製,   ,
  { {0xfa811009,0xf817d004,0x00000003,0x00000003}},	//   中教, 州中,   ,
  { {0xf83e9009,0xf5c1d005,0xfa573005,0xf945a005}},	//   大使, 代身, 停泊, 反土
  { {0xf9456004,0xfa4d7008,0xfa69d005,0xf9132002}},	// [18d0] 上增, 子校, 税港, 呼啊
  { {0xf8245007,0xf4c1c00c,0x00000003,0x00000003}},	//   配上, 拉高,   ,
  { {0xf9458005,0xf91be005,0xf8265010,0x00000003}},	//   不增, 交地, 越中,
  { {0xf9184001,0xf4b7e001,0xfa80b004,0x00000003}},	//   示唯, 聞連, 解情,
  { {0xf935e006,0xf5a5b005,0xfa4f5002,0x00000003}},	//   速增, 同考, 民海,
  { {0xf82af004,0xfa5bb004,0xfb758005,0xfb75000c}},	//   康体, 最根, 備焦, 生突
  { {0xf82a5007,0xfa68f005,0xf4b0a005,0xfb664005}},	//   場上, 同段, 志都, 用燃
  { {0xf4be800f,0xf5aa7007,0xfa5f700c,0x00000003}},	//   分開, 家自, 心深,
  { {0xfa88b009,0xf9382004,0xf5a99004,0x00000003}},	//   在改, 星地, 野蛮,
  { {0xf9450001,0x00000003,0x00000003,0x00000003}},	//   同合,   ,   ,
  { {0xf4c00008,0xf9444005,0x00000003,0x00000003}},	//   文頂, 安危,   ,
  { {0xf9368005,0xf59b500a,0x00000003,0x00000003}},	//   存度, 脂血,   ,
  { {0xf592300c,0xf942200d,0x00000003,0x00000003}},	//   定而, 密山,   ,
  { {0xf918c008,0xf9172004,0xfa64d001,0xfa5bd00a}},	//   古市, 点小, 開朗, 一樹
  { {0xf80d9009,0xfb594001,0xfa6dd004,0xf910a001}},	//   成以, 人精, 育指, 議受
  { {0xf49ce004,0xf92e6001,0x00000003,0x00000003}},	//   旧金, 近大,   ,
  { {0xf93a8006,0xfa741006,0xf5a21009,0xfa78f009}},	// [18e0] 所得, 沿海, 合要, 容是
  { {0xf594100f,0xfa72b006,0xf93fe004,0xf9262005}},	//   摘要, 追求, 了回, 目大
  { {0xf910c008,0xf932a004,0xf926c004,0xfa867001}},	//   共存, 定参, 早在, 部旅
  { {0xfb83e006,0xf910e00f,0xf9390001,0xf5a5100c}},	//   有相, 農場, 言後, 先詳
  { {0xfb7d2006,0xf916e001,0xfb648005,0xfa7a100c}},	//   市物, 刻字, 京社, 工折
  { {0xf4c5c008,0xfb606008,0x00000003,0x00000003}},	//   上達, 校給,   ,
  { {0xfb75c00d,0x00000003,0x00000003,0x00000003}},	//   軟神,   ,   ,
  { {0xf8395006,0xfa81100f,0xf910e001,0x00000003}},	//   日下, 本月, 細微,
  { {0xf8497004,0xf911a004,0xf91a400c,0xfa80d00a}},	//   叫中, 就全, 司因, 採決
  { {0xf911a007,0xfa791004,0xf9240004,0xf917200c}},	//   花店, 人根, 可向, 主可
  { {0xfa529001,0xfa655008,0xf4918004,0xfb52e005}},	//   力成, 型本, 百里, 乱社
  { {0xf92a800f,0xfb746004,0xfa787004,0xf90a400c}},	//   訪客, 定第, 方投, 場安
  { {0xf9136007,0xfb664008,0xfa613004,0xfb52a00c}},	//   東地, 復習, 按每, 仿犯
  { {0xfa75f001,0xf93fc008,0xfa5e100c,0xf84a9005}},	//   人消, 複式, 充情, 航信
  { {0xfb6e4001,0xfa585005,0x00000003,0x00000003}},	//   磐石, 增氧,   ,
  { {0xf839b006,0x00000003,0x00000003,0x00000003}},	//   方人,   ,   ,
  { {0xf4ca0006,0xf927a009,0xf5a57001,0xf83cd004}},	// [18f0] 透露, 旨在, 富而, 性也
  { {0xfa539004,0x00000003,0x00000003,0x00000003}},	//   定提,   ,   ,
  { {0xfa5c9004,0xf5a65005,0xf81af00c,0x00000003}},	//   要活, 手能, 送保,
  { {0xf81af006,0xf91b800e,0xf92ea004,0xf935e005}},	//   老保, 相場, 奔小, 原土
  { {0xfa82f009,0xf49e600e,0xfb884001,0xf920c00a}},	//   六次, 遠隔, 嫌移, 勢志
  { {0xfb892004,0xf920e00c,0x00000003,0x00000003}},	//   藏管, 員宿,   ,
  { {0xf9302007,0xf93ca007,0xfa5cb009,0xfa889004}},	//   他地, 要出, 要方, 在活
  { {0xf91e2009,0xfb52c007,0xf947e001,0x00000003}},	//   度地, 羽球, 前報,
  { {0xfa783006,0xfa6c3004,0xfb864004,0xfb5fa010}},	//   基本, 年未, 弊端, 素系
  { {0xfa673004,0xf58c0001,0xf92f0005,0xfa62f00c}},	//   再来, 抑菌, 北向, 安息
  { {0xf80f5009,0xfa7b7008,0xfa88b00d,0x00000003}},	//   或以, 左折, 在方,
  { {0xfb826006,0xf90b4001,0xf922800a,0x00000003}},	//   烈的, 制室, 面台,
  { {0xf80e9009,0x00000003,0x00000003,0x00000003}},	//   少人,   ,   ,
  { {0xfb634004,0xfa8af004,0xf929c004,0x00000003}},	//   口簿, 未改, 自北,
  { {0xf5be5007,0xf8417004,0xf5acf00c,0xfa78f005}},	//   員考, 本低, 具足, 示活
  { {0xfb840004,0xf93a0004,0xf499e008,0xf929e001}},	//   嘉禾, 持嵌, 相馬, 迪化
  { {0xf935a005,0xf4c30005,0xf4a50005,0x00000003}},	// [1900] 定影, 屋里, 物配,
  { {0xfa633005,0xfa4cf005,0xf9132002,0xfa7cd002}},	//   切慰, 提是, 呼喊, 珠手
  { {0xfa79100f,0xfa5cb007,0xfb85e004,0xfa63b00a}},	//   示方, 的漂, 立登, 光接
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa633006,0xf9188007,0xf490100c,0xf91ae00c}},	//   片新, 特展, 山銀, 春園
  { {0xf90fa001,0xf90a8001,0xfa7c9005,0xf82a5005}},	//   由合, 起初, 度注, 起付
  { {0xf4c7a004,0xfb7e2004,0xf9210004,0xf9150005}},	//   小食, 市相, 波在, 松地
  { {0xf9390004,0xf91de008,0xfa6e300c,0x00000003}},	//   一反, 員同, 場更,
  { {0xf934e00f,0xf9390009,0xfa731004,0xfa563005}},	//   察局, 一倍, 款捐, 生投
  { {0xfa729001,0xfb612004,0xfa82f001,0xf92d800c}},	//   報日, 本等, 業性, 救委
  { {0xf80f7004,0xfa57d005,0xf92a000c,0x00000003}},	//   尖人, 功放, 質全,
  { {0xfb7f8009,0xf8387004,0xfa6ed001,0xfa6b5001}},	//   万立, 区代, 女教, 渴望
  { {0xf9136006,0xf8177009,0xf9454001,0xf93ae001}},	//   放在, 生人, 型可, 最夯
  { {0xfa525007,0xf93b6009,0xfa4f9004,0xf90e0001}},	//   供民, 所学, 五期, 併入
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb7ea005,0xf5c37005,0xf93e000d,0x00000003}},	// [1910] 了王, 解脱, 如出,
  { {0xfa7f1001,0x00000003,0x00000003,0x00000003}},	//   信我,   ,   ,
  { {0xfa7df004,0x00000003,0x00000003,0x00000003}},	//   握手,   ,   ,
  { {0xf90de001,0xf8143005,0xfb4f000a,0x00000003}},	//   年地, 付一, 育玩,
  { {0xfa7ab006,0xfa757007,0xfb7f0005,0x00000003}},	//   核查, 刻意, 布相,
  { {0xf4a1c007,0xf92be007,0xf928a004,0xfb64c005}},	//   公頃, 打字, 部出, 般由
  { {0xf5be3008,0xfb5c6005,0xf933a00c,0xf5c4500c}},	//   性試, 大秘, 料備, 種超
  { {0xfb7b0004,0xf923600c,0xf941e00c,0xf5c2b00c}},	//   市玉, 副分, 月反, 業負
  { {0xf8287004,0xf91a0001,0xf598d001,0xfa4db004}},	//   其上, 常可, 所行, 金湖
  { {0xf4992006,0xf910600f,0xf5a0d009,0xfa803004}},	//   方面, 到底, 等行, 播有
  { {0xf5c3d004,0xf912a001,0xf90c4005,0x00000003}},	//   中起, 報出, 水在,
  { {0xf9432009,0xf5c97007,0xf92ba001,0x00000003}},	//   立完, 親近, 子分,
  { {0xfb61e007,0xf4c5e004,0x00000003,0x00000003}},	//   索系, 上首,   ,
  { {0xfa587004,0xf5c33004,0xfa661001,0xfa84f00a}},	//   果期, 正落, 行旅, 副業
  { {0xf836b005,0xf5955005,0x00000003,0x00000003}},	//   固了, 定落,   ,
  { {0xf931800c,0xfb6de005,0xf812b005,0xf92c800c}},	//   些心, 受税, 晚了, 民升
  { {0xf4c3000f,0xfa72b006,0xf4b0a007,0xf49f600c}},	// [1920] 合金, 国最, 法鼓, 員違
  { {0xfa60d009,0xfa833004,0xf4b76005,0xfb56c00c}},	//   了本, 中方, 保食, 她看
  { {0xf9298009,0xf5b11004,0xfb87a001,0xf489d00c}},	//   横向, 新解, 額申, 收黑
  { {0xf93bc009,0xf84af008,0x00000003,0x00000003}},	//   秀区, 浪人,   ,
  { {0xf93ea007,0xf9162004,0xfb5a8005,0xfa5cf005}},	//   的口, 国年, 吸系, 市未
  { {0xf93a000a,0x00000003,0x00000003,0x00000003}},	//   老名,   ,   ,
  { {0xf4c1a004,0xfa89d001,0xf930000c,0xf93a4005}},	//   商都, 身攻, 展均, 持刀
  { {0xfa5e9001,0xf845b008,0xf83c3005,0xf91ca00c}},	//   的波, 部上, 入任, 大夜
  { {0xf912600e,0xf945c001,0xf91b200c,0xfa62f00c}},	//   尿器, 後壁, 別字, 升格
  { {0xfa68f00e,0xfb818004,0xfb720004,0xf4ca600a}},	//   小池, 万物, 法知, 低電
  { {0xfb838008,0xfa50d00c,0xf92a600c,0x00000003}},	//   贈答, 法法, 道小,
  { {0xf81e700f,0xf5b61006,0xf5979004,0xf81c500d}},	//   者保, 出行, 回良, 吃住
  { {0xf911a00b,0xf82fb001,0xf93b4005,0xf9242005}},	//   英字, 報上, 市反, 目必
  { {0xf90a6009,0xf83b9004,0xf5afd00c,0x00000003}},	//   家宗, 来京, 害自,
  { {0xf93aa001,0x00000003,0x00000003,0x00000003}},	//   要忘,   ,   ,
  { {0xfa57b001,0xf812100a,0x00000003,0x00000003}},	//   作最, 通二,   ,
  { {0xfa7b9007,0xf9488009,0xf831d004,0xf929c004}},	// [1930] 知本, 福彩, 百一, 自受
  { {0xf5a33008,0xf9168005,0xf921c00d,0x00000003}},	//   例規, 去向, 京十,
  { {0xf9290005,0xf92da00c,0x00000003,0x00000003}},	//   在幼, 我得,   ,
  { {0xf837d004,0xfa5fb005,0xfa51d00c,0x00000003}},	//   方会, 了思, 動正,
  { {0xfa7e7009,0xfa643001,0xf5934004,0xfa715004}},	//   大改, 事機, 料要, 新浦
  { {0xfb620004,0xfa741001,0xfb88c004,0x00000003}},	//   硬的, 能比, 行申,
  { {0xf934e005,0x00000003,0x00000003,0x00000003}},	//   棚室,   ,   ,
  { {0xf832b008,0xf919c005,0xf490b005,0x00000003}},	//   陽一, 古墓, 地部,
  { {0xf941a001,0xf8113004,0xf4a1e00c,0xf9482010}},	//   光商, 比以, 代風, 重債
  { {0xf5ca5007,0xfa4dd00c,0xf938000c,0xf828700c}},	//   紫色, 他感, 察報, 收下
  { {0xf5c5b004,0xfa6d3001,0xfa7cf004,0xfb4ba008}},	//   修路, 場接, 梧桐, 直結
  { {0xfb59c004,0xf9444005,0x00000003,0x00000003}},	//   点示, 立土,   ,
  { {0xfa733009,0xf8295004,0xf9256001,0x00000003}},	//   好氛, 低俗, 森北,
  { {0xf4bb800f,0xf90c200f,0xf925a007,0xfa5ed007}},	//   送達, 究報, 物分, 終極
  { {0xfb586007,0xf4b6c004,0x00000003,0x00000003}},	//   典範, 瑞金,   ,
  { {0xfa683007,0xf4b86004,0xfa689002,0x00000003}},	//   行日, 宜通, 李朝,
  { {0xf4bd6009,0x00000003,0x00000003,0x00000003}},	// [1940] 装配,   ,   ,
  { {0xf5a07004,0xf940e004,0xfa6c300c,0xf80cb00a}},	//   了被, 肉型, 島海, 民会
  { {0xf5ba5009,0xfb73600e,0xf48d100c,0xf923000a}},	//   瘦肉, 膚科, 具防, 湯布
  { {0xf590200f,0xf90b600b,0xfb736004,0xfb65c005}},	//   委託, 護師, 定生, 在王
  { {0xf933c001,0xfb5b8004,0xfa763005,0xf9170005}},	//   備忘, 性粉, 格日, 点前
  { {0xf9266007,0xf847d004,0xf845f005,0x00000003}},	//   修工, 在修, 在低,
  { {0xf81d5004,0xf93a2001,0x00000003,0x00000003}},	//   内上, 送小,   ,
  { {0xfb822004,0xf4917001,0xfa77500a,0x00000003}},	//   理状, 避震, 建機,
  { {0xf5c5d00a,0x00000003,0x00000003,0x00000003}},	//   全貌,   ,   ,
  { {0xf81d500f,0xf8157004,0xfa795010,0x00000003}},	//   故事, 食供, 童手,
  { {0xfb88e004,0xfa4fd00a,0xf935400a,0xf8147005}},	//   美瑞, 北支, 弘子, 江之
  { {0xf920e00e,0xfb6fe005,0xfb4bc00a,0xf4c5a00a}},	//   形外, 字索, 康維, 損金
  { {0xf8159009,0xfb79a00a,0xf58fa005,0x00000003}},	//   属事, 品版, 得良,
  { {0xf946a008,0xf9236001,0xfa701004,0xf9118001}},	//   二回, 代史, 困惑, 平地
  { {0xf9334007,0xf82e1005,0xf825b00d,0x00000003}},	//   仙境, 足不, 屋交,
  { {0xf9412004,0xf5bf1004,0xfa731004,0xf8243001}},	//   商大, 大起, 好教, 額上
  { {0xfb72600f,0xf923c007,0xfb80200a,0xfa87b002}},	// [1950] 仕精, 亭地, 超特, 在木
  { {0xf5b7f006,0xf83df009,0xf4b22001,0xf837d001}},	//   人身, 控中, 定開, 治人
  { {0xfa7e5008,0xfa6a3004,0xf58ee005,0xf83eb005}},	//   大活, 年消, 南軟, 性使
  { {0xf917c006,0x00000003,0x00000003,0x00000003}},	//   典型,   ,   ,
  { {0xf83c300c,0x00000003,0x00000003,0x00000003}},	//   入主,   ,   ,
  { {0xf9118009,0xfb71400e,0xfa5bd004,0xf8243004}},	//   彰大, 洗練, 一根, 上二
  { {0xfa7e700f,0xf5916005,0xfb50800c,0x00000003}},	//   大方, 引路, 欲申,
  { {0xf937a006,0xf8245008,0xf9446005,0xfb844005}},	//   果品, 不二, 不前, 不立
  { {0xf4c68005,0xf827300a,0xf4abe005,0xfa899005}},	//   同金, 才以, 道首, 部更
  { {0xf58ae007,0xf80f1004,0xf5bf7008,0xfa845001}},	//   成行, 取信, 控訴, 港溪
  { {0xfa6e700c,0x00000003,0x00000003,0x00000003}},	//   敲打,   ,   ,
  { {0xf82e9004,0xf90b4005,0xf5c1f00c,0xf5beb005}},	//   新三, 兵安, 劣質, 欠薪
  { {0xf9166005,0x00000003,0x00000003,0x00000003}},	//   任徐,   ,   ,
  { {0xfb68e00a,0xf91ca010,0x00000003,0x00000003}},	//   器疾, 大府,   ,
  { {0xfa70f004,0xf931001e,0xf914e00c,0x00000003}},	//   女方, 孕套, 現女,
  { {0xfa5ff007,0xfb83c004,0xf80eb001,0xf92f0005}},	//   但我, 三相, 救人, 法先
  { {0xfa89b009,0xf93c6009,0xf9168004,0xfa70f004}},	// [1960] 八次, 市属, 区参, 台港
  { {0xf9334004,0xfa579001,0x00000003,0x00000003}},	//   余元, 依民,   ,
  { {0xf924e009,0xf8255007,0xf4c1200a,0xf5ca500c}},	//   京地, 行上, 光量, 質設
  { {0xf83d300f,0xf9126004,0xfa4dd001,0x00000003}},	//   你一, 影大, 結書,
  { {0xf5ca5001,0x00000003,0x00000003,0x00000003}},	//   貫課,   ,   ,
  { {0xf833f00f,0xf8313004,0xf5b51004,0xfa5bf00a}},	//   現代, 便了, 幼苗, 考案
  { {0xf92e0005,0xfa78300c,0xfa65f005,0x00000003}},	//   取当, 登房, 酌情,
  { {0xf932e00f,0xf8335006,0xfa653007,0xf82f5004}},	//   動報, 格上, 事本, 液中
  { {0xf8277009,0xf943a009,0xf914e004,0xfa65300c}},	//   和中, 烈士, 系及, 和朋
  { {0xfa64b004,0xf91c4004,0xfa7c3005,0xfa61900c}},	//   位概, 入区, 入来, 月消
  { {0xfa53f009,0xf91e8004,0xf8159005,0xfb4dc00c}},	//   站搜, 次分, 属下, 更細
  { {0xfa5cb001,0xfb554001,0xf9452001,0xfb604005}},	//   境旅, 能確, 配商, 席王
  { {0xf83d9004,0xf91da004,0xf80db004,0xfa839001}},	//   大亮, 大副, 子主, 揮手
  { {0xf9170001,0xf922c005,0xf910a005,0xfa6bb005}},	//   出多, 宣判, 数器, 更易
  { {0xf933400b,0xf9392001,0xf9132004,0xf5b21001}},	//   務局, 一夏, 使大, 械製
  { {0xfa575007,0xfb750004,0xf90c6001,0xf912a005}},	//   感性, 通相, 陷入, 能小
  { {0xfb60200f,0xfb59c004,0xfb772001,0x00000003}},	// [1970] 次索, 炸物, 記白,
  { {0xfb624008,0xf9316005,0xfb520005,0x00000003}},	//   播磨, 些品, 款秀,
  { {0xfb688004,0xfa70d004,0xfa80900c,0xf927c002}},	//   用知, 育水, 校查, 注在
  { {0xf595c007,0xf4c90005,0x00000003,0x00000003}},	//   高質, 二零,   ,
  { {0xf80bd00b,0xf94a600b,0xfb840007,0xf9206007}},	//   子供, 導入, 友站, 因其
  { {0xf5a65004,0xf59eb008,0xfa7f3004,0xf94a000c}},	//   始至, 市職, 次成, 式地
  { {0xfa5ff006,0xf939c009,0xf91ac009,0xf9140009}},	//   分析, 宝山, 接向, 湿地
  { {0xfb602006,0xf844500e,0xf93d4009,0xf4bc2001}},	//   中等, 修了, 持平, 要連
  { {0xf92f2005,0x00000003,0x00000003,0x00000003}},	//   受当,   ,   ,
  { {0xfa889005,0x00000003,0x00000003,0x00000003}},	//   被拒,   ,   ,
  { {0xf8267009,0xf90a6008,0xf82d3005,0x00000003}},	//   小事, 長候, 液位,
  { {0xfb51e004,0xfa713004,0xfa59b004,0xfa5c9001}},	//   地社, 石板, 秀教, 要死
  { {0xfb6ee009,0xf912c004,0xf90dc004,0xf822900c}},	//   抗生, 共出, 年已, 築世
  { {0xfb49400c,0xfb606005,0xf4ae200c,0x00000003}},	//   其理, 口美, 科連,
  { {0xfa88500f,0xf80ab007,0xf4b12007,0xf9184007}},	//   全校, 媒互, 底部, 示可
  { {0xf9126009,0xf9464009,0xf934a005,0xfa6ef00a}},	//   承受, 越冬, 力弱, 想文
  { {0xf4a1e007,0xfa753005,0x00000003,0x00000003}},	// [1980] 連鎖, 好改,   ,
  { {0xfa4db004,0xf92da004,0xf9312001,0xf5a0d005}},	//   子来, 当家, 法全, 内英
  { {0xfa73700f,0xfa77b009,0xfb7c2008,0xf917c008}},	//   西方, 点指, 市線, 治医
  { {0xfb860004,0xf5932004,0xf911e004,0xfb7f600c}},	//   下相, 供良, 新国, 境申
  { {0xfb862007,0xfb820004,0xfb67a005,0xfa70100c}},	//   認罪, 安盟, 在火, 影技
  { {0xf4ac000f,0xf911c006,0xfb748004,0xf80f1004}},	//   金額, 石家, 沙糖, 演了
  { {0xfa7c7006,0xf940e004,0xf4994008,0xfb862001}},	//   性教, 三倍, 交際, 刊目
  { {0xf92de004,0xf4c86008,0xf4a86001,0xf9104005}},	//   取向, 美香, 風靡, 足客
  { {0xf93ee00f,0xfb62600b,0xf925a004,0xfb8aa004}},	//   分局, 設置, 全光, 明社
  { {0xfb854009,0xf945200c,0xf918800c,0xf491b00a}},	//   二等, 事可, 券分, 勾配
  { {0xf90a000f,0xf938e004,0xfb6c2004,0xfa509002}},	//   整合, 保大, 笑着, 引我
  { {0xf4c48006,0xf944600f,0xf90ba001,0xfa62300c}},	//   消除, 認同, 靴子, 築材
  { {0xf4b0a00b,0xfa68f005,0xfb802005,0xf4c6a005}},	//   北陸, 家意, 病知, 行非
  { {0xfa679008,0xfa5ed004,0xf4a74004,0xf928a004}},	//   二本, 境日, 士透, 部基
  { {0xfa77700b,0xf911600c,0xf81dd00a,0xf947a00a}},	//   電波, 到另, 包丁, 車台
  { {0xf818d004,0xf9458004,0xf5ba500c,0x00000003}},	//   局之, 案卷, 室表,
  { {0xfa6c700e,0xfa59d004,0xfa581005,0xf81c7005}},	// [1990] 職活, 繁昌, 察新, 持信
  { {0xf92a400c,0x00000003,0x00000003,0x00000003}},	//   道前,   ,   ,
  { {0xf4c3a00f,0xf9482006,0xf81c1009,0xfa69d009}},	//   事項, 美元, 品中, 延期
  { {0xf9470009,0xf93b4008,0xfa693004,0xf945e005}},	//   同努, 市再, 行更, 告在
  { {0xf9472009,0xf93d0005,0xf4c8600c,0x00000003}},	//   小幅, 品国, 界都,
  { {0xf8389004,0xf5c1d005,0xf816300c,0xf8323005}},	//   除一, 中耕, 保事, 施三
  { {0xf93ec004,0xfb7aa004,0xf4a82001,0xf925200c}},	//   心健, 着火, 部連, 可因
  { {0xfb874009,0xf9348001,0xf491f001,0xf4a06005}},	//   不相, 感光, 耳鳴, 波金
  { {0xf597a001,0xf90f6004,0xfb61a005,0xfa77300c}},	//   作規, 足当, 京福, 格更
  { {0xf4a10009,0xf927c009,0xf4c7800a,0x00000003}},	//   中遇, 迫切, 行錯,
  { {0xf930c001,0xf93dc004,0xf93c2001,0xf93f200a}},	//   動契, 求大, 頂多, 七尾
  { {0xfa62d007,0xfa5f5007,0xf81a5004,0xf58d6008}},	//   指派, 約書, 持企, 金術
  { {0xf5970001,0xfb690002,0x00000003,0x00000003}},	//   生衣, 椒粉,   ,
  { {0xf830900f,0xfb80200f,0xf9226009,0xfa62f001}},	//   政事, 理研, 中可, 洋洋
  { {0xfb550005,0x00000003,0x00000003,0x00000003}},	//   款申,   ,   ,
  { {0xf936600f,0xf92f6008,0xf9176005,0xfa693002}},	//   務報, 策室, 区少, 其情
  { {0xf846f004,0xfa83f004,0xf5a3f00c,0x00000003}},	// [19a0] 含三, 目概, 型記,
  { {0xf5c77004,0xf83d9004,0xf82fd004,0xf90fe001}},	//   在街, 大修, 由之, 議定
  { {0xf5a7b008,0xf5c5b008,0x00000003,0x00000003}},	//   背負, 飯能,   ,
  { {0xfa84d006,0xfa5ef004,0xf91a2001,0xfb6cc005}},	//   是本, 但最, 別分, 化美
  { {0xf93d6004,0xf5b9300c,0x00000003,0x00000003}},	//   市六, 方解,   ,
  { {0xfb6ba00b,0xf819f009,0xfa787001,0xf943c004}},	//   循環, 品位, 典故, 告合
  { {0xfa651009,0xfa65f004,0xfa55f004,0xfa87f004}},	//   同有, 前排, 星村, 火指
  { {0xfb8aa004,0xfb4e0008,0xfb7f6001,0xf934a001}},	//   城社, 女王, 的疾, 識分
  { {0xf9312009,0xfb744004,0xf9258004,0xf4c60008}},	//   林地, 定目, 用先, 車部
  { {0xf5a1d004,0xf9134001,0xf820100c,0xf933000c}},	//   版行, 話報, 均係, 展場
  { {0xf49a900b,0xf93f0004,0xfa53900d,0x00000003}},	//   群馬, 密局, 写清,
  { {0xf59c3001,0xfa7c9008,0xf825d001,0xf922e00c}},	//   膀胱, 若松, 龍井, 湯品
  { {0xfb60a00f,0xf90b000b,0xfb55e006,0xfb5b6004}},	//   員登, 整備, 追究, 大等
  { {0xf5a5d001,0xf933a00a,0xf4a06005,0xfa84d00c}},	//   半自, 教則, 止非, 目救
  { {0xf919e001,0xf837b004,0xf9418004,0xfb65c00c}},	//   凹凸, 出五, 文在, 可穿
  { {0xf928c007,0xf9156001,0xfb7e4001,0xfa679005}},	//   豪宅, 格審, 蹄疫, 告捷
  { {0xf82fd001,0xfb7b600c,0xf492b010,0x00000003}},	// [19b0] 由下, 流研, 東電,
  { {0xfb58200e,0xf9458004,0xfb76a008,0xf9192001}},	//   容疑, 案号, 機置, 此商
  { {0xf916a001,0xf82cd00c,0xf81dd00c,0xf93f000d}},	//   人吃, 伴你, 的井, 梅列
  { {0xfb566006,0xfb726005,0xf5c3f005,0xfa88100d}},	//   医生, 力生, 浮躁, 只手
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf911600c,0xfa83b005,0xf844d00c,0x00000003}},	//   承商, 是思, 種作,
  { {0xf8245009,0xfa62900c,0xf844f005,0xfa66d005}},	//   再上, 案情, 温低, 牌排
  { {0xfa7e9005,0xfa6b100a,0x00000003,0x00000003}},	//   性改, 破滅,   ,
  { {0xfb548007,0xf4c50001,0xf92de004,0xf5b07001}},	//   眼神, 合音, 宗局, 穿越
  { {0xf933c006,0xf82a5004,0x00000003,0x00000003}},	//   四大, 水事,   ,
  { {0xfb788004,0xfb79e002,0x00000003,0x00000003}},	//   州特, 送程,   ,
  { {0xf933c009,0xf92e4004,0xfb7d2001,0xf49f0004}},	//   盛大, 策引, 約率, 院里
  { {0xfb56e00b,0xfa64300a,0x00000003,0x00000003}},	//   活用, 之江,   ,
  { {0xf4917006,0xf831500c,0xf825700c,0xf918a00c}},	//   共青, 印信, 同住, 基座
  { {0xf930e001,0xf4bf2001,0xf9122004,0xf92c8004}},	//   展委, 心都, 称呼, 荒山
  { {0xf935a007,0xf498b001,0xf934c004,0xfa707005}},	//   聞名, 司高, 速反, 新林
  { {0xf5c2d007,0xf910a005,0xf813d00a,0xf9194010}},	// [19c0] 業試, 数在, 香保, 津和
  { {0xfb574009,0xfa5f5007,0xfb4f8007,0xfa73b004}},	//   区生, 心想, 色素, 宿松
  { {0xfa71d005,0xf92c8002,0x00000003,0x00000003}},	//   使村, 子展,   ,
  { {0xf843d007,0xf81b1001,0xfa7fb008,0xf932200c}},	//   可作, 求下, 造改, 動判
  { {0xf58fa004,0xf917c004,0xf5c5f001,0xfa663005}},	//   受表, 核安, 風行, 免或
  { {0xfa651005,0x00000003,0x00000003,0x00000003}},	//   再担,   ,   ,
  { {0xf8111001,0xfb51a004,0xf492d00c,0xf5bb900c}},	//   盛事, 石灰, 函送, 此能
  { {0xf83a300c,0x00000003,0x00000003,0x00000003}},	//   司代,   ,   ,
  { {0xf9260001,0xf93d4005,0xfb662005,0xfa899005}},	//   種形, 仁地, 修管, 票收
  { {0xf8317007,0xf93ca004,0xfa577004,0xf948400a}},	//   放下, 心内, 果明, 小化
  { {0xf927a004,0xfa64f00c,0xf9452005,0x00000003}},	//   用全, 下注, 同及,
  { {0xf940c009,0xf9216001,0x00000003,0x00000003}},	//   万州, 坡地,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa87900e,0xfa505001,0xf9164004,0xf5b9f004}},	//   適性, 字查, 格基, 童装
  { {0xfb7f8008,0xf93bc001,0xfa4ad001,0xf915600c}},	//   均等, 秀出, 術指, 值可
  { {0xf815b007,0xf83ab008,0x00000003,0x00000003}},	//   教人, 古代,   ,
  { {0xf815b005,0xf92ba002,0x00000003,0x00000003}},	// [19d0] 留人, 溪地,   ,
  { {0xf5a47001,0xf5b4d008,0xf91ba005,0x00000003}},	//   前行, 放課, 以口,
  { {0xf92e4008,0xf93c4004,0xf5914001,0xfb64c00c}},	//   提唱, 考前, 際認, 可置
  { {0xf4a1a001,0xf9480001,0xfa50d00c,0xf5ba300c}},	//   冬送, 後座, 北松, 室自
  { {0xf91c0005,0xfb63e00c,0x00000003,0x00000003}},	//   春座, 第章,   ,
  { {0xf4c1c008,0xfa7e7004,0xfb848008,0xfa86b010}},	//   安通, 性活, 脈瘤, 館料
  { {0xf9300005,0x00000003,0x00000003,0x00000003}},	//   化危,   ,   ,
  { {0xf9096007,0xf82a5007,0xfa5bb00e,0xf838f001}},	//   家分, 水下, 要旨, 常保
  { {0xf8115001,0xf9108015,0xf9228004,0x00000003}},	//   些什, 平凡, 面地,
  { {0xf92b800c,0xfa7e9005,0xf9446005,0x00000003}},	//   娓娓, 性方, 植前,
  { {0xf4b1a007,0xf917a005,0xf92ec002,0xfb8b0002}},	//   魔鬼, 改写, 向她, 碎石
  { {0xf80c7001,0xf93e0004,0xf4b3a004,0xfb80c005}},	//   成五, 故居, 静静, 三秋
  { {0xf940400f,0xfa661004,0xf8147004,0xfa711005}},	//   商取, 上注, 生争, 台播
  { {0xf9444006,0xf5bc3006,0xfa67d001,0xfa6af001}},	//   下属, 大豆, 住我, 家業
  { {0xf9124004,0xfa663005,0xf949e005,0xfa60d005}},	//   台山, 不注, 式已, 穆斯
  { {0xfa621009,0xfb4b6008,0xf5b7f00c,0x00000003}},	//   分数, 起用, 書規,
  { {0xfb5d6009,0xfa70b007,0xf92e4001,0xf93e2005}},	// [19e0] 大火, 失望, 策展, 内商
  { {0xf92f800e,0xfb83200c,0xfa7f9005,0xf5a55002}},	//   金具, 片由, 造活, 牌行
  { {0xfb7e0009,0xf93b2001,0xf8111001,0xfb72e001}},	//   病病, 一席, 四下, 站牌
  { {0xf81bf004,0x00000003,0x00000003,0x00000003}},	//   心介,   ,   ,
  { {0xf930400f,0xfa5b100b,0xfb80e007,0xf5a45005}},	//   志工, 一括, 有看, 告要
  { {0xf8273004,0xfb7f8001,0xf93bc001,0xf9280001}},	//   住了, 心田, 求必, 疫力
  { {0xf59dc005,0xfb7d6005,0x00000003,0x00000003}},	//   充血, 者立,   ,
  { {0xf93ea004,0xf920e00c,0xf92e800c,0xf4bf2002}},	//   心大, 止受, 著力, 范逸
  { {0xfb544010,0x00000003,0x00000003,0x00000003}},	//   政状,   ,   ,
  { {0xfa661006,0xf5bdd004,0xf489f008,0x00000003}},	//   行情, 学能, 長門,
  { {0xfa4fd001,0xf92d6008,0xfa797001,0x00000003}},	//   受支, 成度, 接手,
  { {0xf932200a,0x00000003,0x00000003,0x00000003}},	//   通免,   ,   ,
  { {0xf9410004,0xf9230008,0xf93e8004,0xfa7f3004}},	//   三夏, 可哀, 幅回, 次提
  { {0xfb6a4004,0xfb750001,0xf4b22005,0xf9124005}},	//   青神, 食療, 供食, 台就
  { {0xf4b9a00c,0xf5b1300c,0xf4c2200c,0x00000003}},	//   一震, 新象, 葉金,
  { {0xf5a0b007,0xf9466004,0xfa4f5001,0x00000003}},	//   梅花, 福安, 近海,
  { {0xf4a82001,0xfb87400c,0xf4c8800c,0xf80bf005}},	// [19f0] 物飼, 今社, 同音, 向不
  { {0xf9458004,0xf9156004,0xf9130004,0xfb6e2001}},	//   不属, 主品, 白内, 街的
  { {0xfb4c4007,0xfa54b001,0xf81bf001,0xf5a17005}},	//   浴用, 定採, 心事, 均被
  { {0xf9290009,0xf92c4004,0xfa59f005,0xf93d000c}},	//   自定, 排好, 一朝, 吃力
  { {0xf912c005,0xfa77f00c,0xfb82c005,0xf939e00c}},	//   共基, 司服, 眉睫, 芝山
  { {0xfb5ea00b,0xf832b006,0xfb61e00e,0xf9438001}},	//   無理, 社保, 散策, 合優
  { {0xf490b006,0xf58e6001,0x00000003,0x00000003}},	//   阿里, 取自,   ,
  { {0xf492b001,0xf9274005,0xf8201005,0x00000003}},	//   宿飯, 在媒, 指企,
  { {0xf829900f,0xf92bc004,0xf8443001,0xfb5f0001}},	//   長介, 体外, 目了, 章置
  { {0xfa6f9007,0xf9124001,0xf491d001,0x00000003}},	//   冰淇, 地地, 東風,
  { {0xf814700c,0xfb6c200c,0x00000003,0x00000003}},	//   生三, 青社,   ,
  { {0xfa527004,0xf81b7004,0x00000003,0x00000003}},	//   会最, 言信,   ,
  { {0xf8435007,0xfa635004,0xf9462001,0x00000003}},	//   業使, 等次, 行商,
  { {0xf5bd3006,0xf5b21001,0xfa649005,0xfa7e100d}},	//   大街, 新育, 位最, 你感
  { {0xfa85b005,0xfa827005,0xf927a005,0xfb742005}},	//   在把, 正正, 用器, 高税
  { {0xfb710004,0xf9382008,0xfa7a9001,0xfb84000a}},	//   俗称, 回大, 春期, 下線
  { {0xf939600c,0xf942800c,0x00000003,0x00000003}},	// [1a00] 所各, 等字,   ,
  { {0xf92ec006,0xfa7e3004,0xf83f5004,0xf910800c}},	//   五十, 学数, 院一, 政及
  { {0xf9146007,0xf4c3c005,0xf927c005,0x00000003}},	//   落差, 立集, 表填,
  { {0xfa7c3007,0xfb6f0001,0xf82bd004,0xf935e004}},	//   入日, 塔的, 年体, 期回
  { {0xf935e001,0xfb6e6001,0xfb7f6001,0xf595e001}},	//   真回, 糖糖, 者物, 記表
  { {0xf91a0004,0xf598c00c,0xfa5db00c,0x00000003}},	//   方国, 一葉, 的染,
  { {0xf940a00f,0xf94b0004,0xf9390005,0xfb4d400c}},	//   順利, 明地, 初学, 場空
  { {0xf93fe00f,0xf5944001,0xfa61d001,0x00000003}},	//   的家, 力調, 升息,
  { {0xfb62a007,0xfb828004,0xf8297004,0xf9372004}},	//   既然, 合症, 家万, 察学
  { {0xfb83200f,0xf93d4008,0xf9444004,0xfb6b800c}},	//   看看, 病床, 立功, 舒眠
  { {0xf8157009,0xf59dc001,0xf49e5005,0x00000003}},	//   回事, 考評, 淡黄,
  { {0xf5b01009,0xf813d00e,0xfb504004,0xf8365010}},	//   即表, 際交, 抱着, 去作
  { {0xfa71f00f,0xf9312009,0xf9366004,0xf4a0100c}},	//   東森, 南山, 余家, 你都
  { {0xf81c5009,0xf8309001,0xf5c67001,0xfb69a005}},	//   威信, 到他, 踩街, 冒的
  { {0xf4ba6004,0xfa7ff008,0xf830f004,0xf941400c}},	//   秀青, 管支, 阿什, 商履
  { {0xf5aeb008,0xfa55d00c,0xf9126005,0x00000003}},	//   台車, 土機, 影吧,
  { {0xf93aa004,0xfa62100c,0xf836d005,0xf4c0c00a}},	// [1a10] 激化, 分新, 改之, 理院
  { {0xfa55d007,0xf92f0001,0xfb6e4008,0xfa547005}},	//   真機, 受刑, 子申, 速消
  { {0xfa68d00f,0xf93a0009,0xf80e1004,0xf82fd004}},	//   歌曲, 作座, 向中, 峰会
  { {0xfb6f8008,0x00000003,0x00000003,0x00000003}},	//   外為,   ,   ,
  { {0xf91c4007,0xf92f0009,0xf5a69001,0xfa733004}},	//   入出, 向国, 始買, 能指
  { {0xf5b0b00f,0xfa59f004,0xf5a6100c,0xfa4b1002}},	//   印表, 一枝, 益良, 析技
  { {0xf58fc009,0xfb59200c,0x00000003,0x00000003}},	//   法考, 役監,   ,
  { {0xf9404001,0xfa7e9001,0xfa80b00c,0x00000003}},	//   分店, 無情, 無恥,
  { {0xfa5c3009,0xfb86c009,0xf80e9001,0xfa58b00c}},	//   市朝, 行科, 近人, 輝映
  { {0xf821500e,0xfa6c1001,0xf9354001,0xf90c6005}},	//   分以, 場比, 站加, 家庵
  { {0xf82c9009,0xf9462004,0xfa673004,0xfb4fe00c}},	//   巴中, 再受, 再接, 地瓜
  { {0xf93d8006,0xfa63b004,0xfa565004,0xfb6ee00c}},	//   参加, 合早, 官正, 南生
  { {0xf8487008,0x00000003,0x00000003,0x00000003}},	//   用交,   ,   ,
  { {0xf910e006,0xf83b700f,0xf5a3d007,0xf9424007}},	//   新公, 給付, 事記, 商場
  { {0xf59f0007,0xf9266008,0xfb85200c,0xf9410005}},	//   者評, 宮古, 不甘, 内具
  { {0xf9462001,0xfb5d2004,0xf91f6004,0xfa7a9005}},	//   名優, 学素, 面允, 查期
  { {0xf9358001,0xfa7c3008,0xf5a39001,0x00000003}},	// [1a20] 感官, 警戒, 開胃,
  { {0xfb58200f,0xfa4a5005,0xfa5e100c,0x00000003}},	//   幸福, 互感, 項指,
  { {0xf90a6004,0xfb748005,0x00000003,0x00000003}},	//   件外, 料研,   ,
  { {0xfa74d005,0x00000003,0x00000003,0x00000003}},	//   活有,   ,   ,
  { {0xf83db004,0xfb682001,0xf83bd00c,0xfb56600c}},	//   性修, 火線, 性低, 蒼白
  { {0xfb5a000f,0xf94b0004,0xf9310001,0xfa803005}},	//   司第, 城地, 店地, 中把
  { {0xf8395004,0xfa72b001,0xf4c5a001,0xfa4f9004}},	//   入上, 松江, 行量, 金扶
  { {0xfa695006,0xf9208001,0xfb7d200c,0xf93ce005}},	//   藏此, 業問, 久等, 求取
  { {0xfb874006,0xf9468002,0x00000003,0x00000003}},	//   意的, 事到,   ,
  { {0xf8243007,0xfa771004,0xf946c004,0xfa611008}},	//   籍介, 容描, 届大, 資法
  { {0xf5c2f001,0xf82d900a,0x00000003,0x00000003}},	//   本著, 該企,   ,
  { {0xf92ca004,0xf9396001,0xfa861005,0x00000003}},	//   子列, 言堂, 用激,
  { {0xf9466007,0xf91f6004,0xf82fb004,0xfb84000a}},	//   半形, 加学, 就下, 下級
  { {0xfa693009,0xf91ae004,0xf59bc004,0xf9334001}},	//   行整, 交巡, 持自, 望可
  { {0xf917e00f,0xf93c0009,0xfb6f0009,0xfa7c300a}},	//   登入, 品公, 村社, 健治
  { {0xfb5b8004,0xfa721001,0xf5996004,0xfb824001}},	//   性等, 異想, 血脂, 醉科
  { {0xfa811007,0xf58b4009,0xf91f8008,0xfb6a8001}},	// [1a30] 業教, 鼓舞, 加古, 雪紡
  { {0xf9374004,0xf4c7800c,0xf90c2005,0xf9138010}},	//   高平, 宏通, 更全, 影場
  { {0xfa7e3004,0x00000003,0x00000003,0x00000003}},	//   学新,   ,   ,
  { {0xfb64c00e,0xf92e2004,0xf935a001,0xfa7e3008}},	//   天王, 受市, 定報, 武新
  { {0xf941400e,0xf90dc008,0xfa83d004,0x00000003}},	//   商工, 年史, 目最,
  { {0xf846d009,0xf9278008,0xf4c2a00c,0xfa4cf00c}},	//   在保, 器外, 指選, 提振
  { {0xf92f8006,0xf59ac007,0xf494d001,0xfa789005}},	//   近年, 一貫, 放音, 核情
  { {0xf934e004,0xfa7a900c,0xf5c13005,0xf4a6000c}},	//   盛宴, 勤業, 校花, 用需
  { {0xf5bf7004,0xfa6e9005,0xf9274005,0x00000003}},	//   索要, 地消, 目年,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf830900c,0xf92b800c,0xfb65600a,0xf9490005}},	//   到世, 未到, 物療, 行具
  { {0xf5ba300f,0xfb5e8007,0xf9352007,0xfa827004}},	//   知識, 凡的, 站客, 京朝
  { {0xf81ab004,0xfa859001,0xfa6db001,0xf923c005}},	//   十万, 普普, 更深, 中到
  { {0xfa677001,0xfa68d005,0xf9234005,0xf4b8e00c}},	//   意指, 件明, 售合, 所配
  { {0xfb85200e,0xf80ad009,0xf9394008,0xf9434004}},	//   上級, 子上, 着心, 立城
  { {0xfa721004,0xfb748004,0xfa799001,0xf941000c}},	//   好效, 期等, 盤滑, 故其
  { {0xf497f001,0xfb64a004,0xfa5c500c,0xf9156005}},	// [1a40] 人陪, 天等, 刀械, 施尿
  { {0xf849d005,0x00000003,0x00000003,0x00000003}},	//   士以,   ,   ,
  { {0xf927c007,0xf58f8007,0xf5956009,0xf819b007}},	//   全彩, 動行, 定能, 果你
  { {0xfa71700b,0xfb612001,0xfa681005,0x00000003}},	//   社案, 業秘, 和智,
  { {0xfa7d3007,0xfa5f3009,0xf846d004,0xfb76a004}},	//   你所, 者未, 在依, 料破
  { {0xfb7a8007,0xf9390001,0xf4a11001,0x00000003}},	//   府社, 作協, 口高,
  { {0xf4b66008,0xfa777010,0x00000003,0x00000003}},	//   語集, 空洞,   ,
  { {0xf5c8100f,0xfb616004,0x00000003,0x00000003}},	//   自行, 正科,   ,
  { {0xfa4fb008,0xf80d7004,0xf5c1300a,0xf5a4d00c}},	//   化放, 得下, 校英, 納者
  { {0xf5aa5001,0xfb50c001,0xfb538001,0xf496500c}},	//   更認, 河系, 綿綿, 空降
  { {0xf943800f,0xf4947008,0xfa61100c,0xfa781010}},	//   橋市, 乾電, 草植, 司氏
  { {0xf59c600b,0xf92f800f,0xf4c5c001,0xfa6b9008}},	//   退職, 違反, 名間, 張所
  { {0xf83b9004,0xf915e00c,0xf847900c,0xf93d8005}},	//   照上, 出光, 岩人, 者反
  { {0xf942a006,0xf92a400d,0x00000003,0x00000003}},	//   合力, 道免,   ,
  { {0xfa4d7004,0xf948e002,0x00000003,0x00000003}},	//   少林, 二到,   ,
  { {0xfa59d001,0xf494b004,0xf911a005,0xf92aa005}},	//   品手, 尼黑, 山在, 当包
  { {0xf5b05001,0xfa673005,0x00000003,0x00000003}},	// [1a50] 泳衣, 行或,   ,
  { {0xf9232008,0xfa88900c,0xf939a00c,0x00000003}},	//   頭固, 全查, 果季,
  { {0xf82dd009,0xf9358004,0xfb50e008,0xf944a008}},	//   署了, 博山, 台目, 床心
  { {0xfa645001,0xf90aa00c,0xf90e6005,0xfa8b300c}},	//   安慰, 場小, 足市, 輪替
  { {0xf93f0004,0xf59ae004,0xf83f3001,0xf949400c}},	//   元建, 言表, 逢低, 小工
  { {0xfa51300b,0xf91dc00f,0xf92f400e,0xfb6de001}},	//   答日, 校友, 字列, 受美
  { {0xf93b000f,0xf596a007,0xf933a004,0x00000003}},	//   作家, 束販, 供大,
  { {0xfa6dd006,0xfa763009,0xf91e2007,0xf9342001}},	//   育教, 任期, 試報, 仙子
  { {0xf594c001,0xf93a6004,0x00000003,0x00000003}},	//   愛買, 持市,   ,
  { {0xfa6a1009,0xfb6fa00e,0xf921c008,0x00000003}},	//   家提, 首相, 形大,
  { {0xf913c006,0xfb552004,0xfa7b7005,0x00000003}},	//   礼品, 国知, 大把,
  { {0xfa52d001,0xfa4d1001,0xf925a00c,0xfa4ed00c}},	//   料洋, 黑斑, 利分, 化業
  { {0xf82c7006,0xf8415004,0xf80c9004,0xfa6dd002}},	//   男人, 中保, 策上, 泵浦
  { {0xf5b3b004,0xfb7f4004,0xfb52c004,0x00000003}},	//   格言, 理率, 疱疹,
  { {0xf9450006,0xf5972008,0x00000003,0x00000003}},	//   又好, 官能,   ,
  { {0xfb7cc006,0xf941600e,0xfa66d004,0xfa621004}},	//   元的, 理容, 前扣, 商海
  { {0xf81cf006,0xfa4df007,0xfb776004,0xf58ac001}},	// [1a60] 千万, 化成, 生知, 間者
  { {0xfa833007,0xfa563007,0xf940c004,0xf4c62004}},	//   業改, 生法, 涉嫌, 降雪
  { {0xf5b7f004,0xf9474001,0xf91ba00d,0x00000003}},	//   空航, 題庫, 武定,
  { {0xf9258009,0xf9474001,0xf939e00c,0x00000003}},	//   用合, 行庫, 要名,
  { {0xfb634004,0xf4bd800c,0xf8241010,0x00000003}},	//   路站, 球道, 俊介,
  { {0xfa5ad001,0xfa59b004,0xfa897005,0xfb7c0005}},	//   送愛, 送消, 被扣, 言簿
  { {0xfa75100b,0xfb584004,0xf936c001,0xfa653004}},	//   能性, 人犯, 真可, 程是
  { {0xf91be001,0xf5b33008,0xf8433005,0xf492700c}},	//   接埠, 績評, 旭人, 細長
  { {0xf944c00b,0xfb680009,0xf80d7008,0x00000003}},	//   例外, 在短, 字上,
  { {0xf92be007,0xf9288010,0xf9450002,0x00000003}},	//   科名, 器別, 見天,
  { {0xfa4d7007,0xfa61b008,0xf8459004,0x00000003}},	//   洗手, 光文, 周三,
  { {0xfa703001,0xf8485004,0xfb778001,0xfa555004}},	//   到某, 太低, 悟空, 瑞拉
  { {0xf819b001,0xf82f9004,0xf829b001,0xf4c4400c}},	//   壁上, 彰了, 起伏, 蛋食
  { {0xf5c6d00e,0xfb51a004,0xfa5f5004,0xf4a3900c}},	//   復路, 新特, 者注, 可高
  { {0xf945e004,0xfa661004,0xf59b800c,0x00000003}},	//   始出, 行清, 要著,
  { {0xf848900b,0xf9142009,0xf913a004,0xfb59c00c}},	//   物件, 使其, 都属, 令狐
  { {0xfa63f006,0x00000003,0x00000003,0x00000003}},	// [1a70] 又是,   ,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf90c8009,0xfa63d004,0xfa87d001,0xfb51e005}},	//   堵塞, 告有, 哪有, 己独
  { {0xf90aa009,0x00000003,0x00000003,0x00000003}},	//   海域,   ,   ,
  { {0xf9466006,0xfa869004,0xf4903001,0xf489f001}},	//   友好, 在沙, 田間, 護送
  { {0xf4a1700b,0xf8451001,0xfa7ab00c,0x00000003}},	//   員長, 可代, 選方,
  { {0xf4bc4001,0xf83e5005,0xf945400c,0x00000003}},	//   的里, 卡丁, 額定,
  { {0xf9310009,0xf820300a,0x00000003,0x00000003}},	//   受害, 故人,   ,
  { {0xf49e5001,0xf9468004,0xfa7a7005,0xf944800a}},	//   大麻, 福克, 特新, 等兵
  { {0xf90b400b,0xfb5c2004,0xfa4e5001,0xf5904001}},	//   強化, 入群, 純手, 耕耘
  { {0xf593000f,0xf5982007,0xf9398005,0xfb7a200c}},	//   務行, 生議, 所分, 持美
  { {0xf941800c,0x00000003,0x00000003,0x00000003}},	//   等分,   ,   ,
  { {0xf93a0007,0xfa68d004,0xfb494004,0x00000003}},	//   一夜, 富液, 收率,
  { {0xfa669006,0xf91ea007,0xf9192004,0xf9414001}},	//   二期, 照常, 略合, 集入
  { {0xf9262005,0x00000003,0x00000003,0x00000003}},	//   在品,   ,   ,
  { {0xf93e0006,0xf9308007,0xf810f001,0xfa6a1001}},	//   的外, 且可, 供下, 小海
  { {0xf4a15009,0xfa80900c,0x00000003,0x00000003}},	// [1a80] 京郊, 班服,   ,
  { {0xfb864009,0xfb7ca00c,0x00000003,0x00000003}},	//   型社, 要確,   ,
  { {0xf5954009,0xfb5d0001,0xf824100a,0x00000003}},	//   定西, 牧科, 俊之,
  { {0xfa833001,0xf911400d,0x00000003,0x00000003}},	//   業方, 曾先,   ,
  { {0xfa601006,0xf909a004,0xfb83000c,0x00000003}},	//   商投, 其停, 下看,
  { {0xf909c001,0xfb84400d,0xfb59800d,0xf92d0010}},	//   具名, 及税, 古生, 駐屯
  { {0xf92b8009,0xfa4b3007,0xf5be3001,0xf916800c}},	//   少先, 源所, 無言, 示品
  { {0xf90fe00f,0xf935c001,0xfb77000c,0xf934e00c}},	//   報名, 紙尿, 付現, 四場
  { {0xf8215009,0xf9412004,0xfa839004,0xfa6ff004}},	//   商人, 分学, 欣慰, 育改
  { {0xf911600f,0xf9466009,0xf5a18001,0xfa83900c}},	//   印度, 行定, 指自, 正新
  { {0xfa55b004,0xf9412001,0x00000003,0x00000003}},	//   定新, 集大,   ,
  { {0xf939e001,0xf926600a,0xf596a010,0x00000003}},	//   保其, 器包, 語講,
  { {0xf91c4009,0xfa7dd007,0x00000003,0x00000003}},	//   入基, 度施,   ,
  { {0xf9448004,0xf92f4005,0x00000003,0x00000003}},	//   合医, 算得,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa695004,0xfb828005,0xfa4b1005,0xfa8a500c}},	//   意性, 合率, 提意, 航業
  { {0xf936e009,0xf9122004,0xfa657004,0xf90e800c}},	// [1a90] 神州, 国先, 把提, 女心
  { {0xf5b37006,0xf923c004,0xfa60300c,0x00000003}},	//   白菜, 中印, 情活,
  { {0xfa75f001,0xfa841004,0xf4ae8001,0xf928e004}},	//   主招, 冬春, 取適, 周国
  { {0xf814f004,0xf58bc010,0x00000003,0x00000003}},	//   定以, 村證,   ,
  { {0xf59ea00f,0xf8181001,0x00000003,0x00000003}},	//   分行, 初五,   ,
  { {0xf9334004,0xfb7f8005,0xf9256005,0xf9404005}},	//   站如, 庄社, 彩内, 情出
  { {0xfb842009,0xf9260001,0xf9266001,0xf5a10001}},	//   上看, 湯地, 置入, 者職
  { {0xf947400e,0xf4989001,0xfa737004,0xf926e00a}},	//   小劇, 室配, 由海, 士吉
  { {0xf848b001,0xf9112005,0xfa51100c,0xf59ac00c}},	//   表主, 己当, 林東, 言自
  { {0xf5a72007,0x00000003,0x00000003,0x00000003}},	//   車貸,   ,   ,
  { {0xfa709005,0xf80a500c,0xfa605005,0x00000003}},	//   共清, 園休, 者根,
  { {0xf58b0004,0xf5a24008,0xf843300c,0xfa80300d}},	//   排表, 須賀, 可促, 院感
  { {0xf4a9300f,0xf9456009,0x00000003,0x00000003}},	//   注音, 不宜,   ,
  { {0xf5980006,0xf4bb200f,0xf4ad8009,0xf91fc001}},	//   生育, 流道, 滑雪, 勢分
  { {0xf90b600b,0xfa7ef001,0x00000003,0x00000003}},	//   護士, 加斯,   ,
  { {0xf9190009,0xf5a26001,0x00000003,0x00000003}},	//   方公, 合者,   ,
  { {0xf4967007,0xf81d3009,0xf5b95001,0xf928400a}},	// [1aa0] 固頂, 装上, 步行, 在員
  { {0xf940600e,0xfb87e009,0xf931a004,0xf4bc8002}},	//   症候, 税税, 供必, 元送
  { {0xfa679004,0x00000003,0x00000003,0x00000003}},	//   融洽,   ,   ,
  { {0xf939c001,0xf8259004,0xfb64e00d,0x00000003}},	//   府宣, 程信, 枯竭,
  { {0xfa6b9007,0xf81fd008,0xf9260004,0xfa66300c}},	//   奶油, 文住, 部小, 型房
  { {0xfa671004,0xfa6f900c,0x00000003,0x00000003}},	//   行比, 深沉,   ,
  { {0xfa6fd006,0xfa769007,0xf845d005,0xfb4e000c}},	//   育活, 治法, 温保, 直直
  { {0xf5b8300b,0xfa683007,0xf4a7b009,0xfa82d009}},	//   古車, 同書, 在部, 是怎
  { {0xfa783007,0xf829500e,0xf823700c,0x00000003}},	//   人潮, 小人, 型一,
  { {0xf8487006,0x00000003,0x00000003,0x00000003}},	//   身体,   ,   ,
  { {0xfa4cd004,0xf5a5e008,0xfa751004,0xfa82b004}},	//   取意, 和装, 格比, 波海
  { {0xf9204009,0xf83f900e,0xfa577004,0xfa773004}},	//   六安, 次世, 九期, 人思
  { {0xf90b4001,0xf92f6004,0xf947c001,0xf4c7a008}},	//   強取, 村地, 羊奶, 美里
  { {0xfa7a1004,0xf9354001,0xf4a6900c,0xf5af3005}},	//   入情, 食商, 巨集, 新考
  { {0xf92e0004,0xfa5bf005,0xfa6b3005,0xf5a02005}},	//   向公, 威斯, 然性, 豆角
  { {0xfb5c0006,0xfa58f007,0xfa4dd001,0xfa53b00c}},	//   日照, 舞曲, 店所, 妙招
  { {0xf913a00f,0xfa85d00c,0x00000003,0x00000003}},	// [1ab0] 格式, 推手,   ,
  { {0xf838d004,0xf5c73001,0xf5ae7001,0xfa58900c}},	//   出任, 奮起, 段落, 非政
  { {0xf492f00f,0xf81ef007,0xf4a7d00c,0x00000003}},	//   政院, 了什, 縫隙,
  { {0xfa7f1004,0xf945800c,0xfb63e00c,0xf93f000a}},	//   面掌, 事員, 可真, 的別
  { {0xf91ce004,0xf91fa004,0xfa4d700c,0x00000003}},	//   以家, 院内, 救法,
  { {0xf92cc006,0xf8269009,0xf81af004,0xf5bab004}},	//   体健, 量上, 品作, 学行
  { {0xfb754007,0xf90f8001,0xf91aa008,0xf918c004}},	//   生病, 到商, 浦和, 特快
  { {0xf9472004,0xfb810001,0x00000003,0x00000003}},	//   名医, 商管,   ,
  { {0xfa657004,0xfb70e001,0xfb868004,0xfa569004}},	//   半成, 受災, 夏秋, 感慨
  { {0xf9212006,0xf4c4e006,0xf917800f,0xf5b7f009}},	//   公安, 事部, 容分, 人被
  { {0xf9176006,0xf59e6009,0xf90a8001,0xfb6fc001}},	//   添加, 的良, 場前, 湖社
  { {0xfa82b004,0xf5af1008,0xf4aca00c,0xf4af8005}},	//   伯明, 右衛, 或重, 投降
  { {0xfa4eb00a,0xfa717005,0xf5c7500c,0x00000003}},	//   五所, 由投, 肩負,
  { {0xfa5ed009,0xf9206008,0xfa7a9005,0xf4a4d005}},	//   了明, 管弦, 交本, 售金
  { {0xf5b77008,0xf8259005,0xfb83a00c,0xfb52c00c}},	//   費財, 上体, 光盤, 共空
  { {0xf5aa800e,0xfa57d001,0xf9142004,0xfa64f001}},	//   競輪, 保投, 国太, 月施
  { {0xfa82b00a,0x00000003,0x00000003,0x00000003}},	// [1ac0] 解性,   ,   ,
  { {0xf5a48005,0x00000003,0x00000003,0x00000003}},	//   尊老,   ,   ,
  { {0xfa6d3009,0xf9138001,0x00000003,0x00000003}},	//   刷新, 格名,   ,
  { {0xf93ae007,0xf9490005,0xf90ea005,0x00000003}},	//   府地, 富康, 数及,
  { {0xf81ef006,0xfa5b3004,0xf93fe004,0xf926a005}},	//   的交, 市昌, 的延, 物受
  { {0xf93a200b,0xfa81900e,0xf9346001,0xfa7fb001}},	//   一回, 難易, 些已, 遠方
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa58500c,0xf930200c,0x00000003,0x00000003}},	//   川湯, 法四,   ,
  { {0xfb65e007,0xf9456005,0xf5c4f005,0xfa75b00c}},	//   縮短, 再婚, 利而, 白河
  { {0xfa88900b,0xf5a50001,0xfa54b004,0xfa50300a}},	//   全日, 名者, 四海, 北条
  { {0xf5adb009,0xf9232004,0xf90a0005,0xf492500c}},	//   已超, 可参, 更合, 派集
  { {0xf84a7009,0xf8337007,0xfa799009,0xfb4c8001}},	//   只代, 政人, 查明, 年犯
  { {0xf81f7006,0xf9102001,0xf9140005,0x00000003}},	//   商会, 台塑, 白塔,
  { {0xfa60f009,0xfa5ef009,0xfb76c00c,0x00000003}},	//   分散, 分流, 原種,
  { {0xf9392001,0xfa7d500a,0x00000003,0x00000003}},	//   作外, 大怪,   ,
  { {0xfb83c001,0xfa88b001,0x00000003,0x00000003}},	//   克的, 表查,   ,
  { {0xfa7c5004,0x00000003,0x00000003,0x00000003}},	// [1ad0] 大沙,   ,   ,
  { {0xf4ad800e,0xf8269004,0xf80e900c,0xfb69c00c}},	//   化通, 及信, 紗作, 質研
  { {0xf923800f,0xf90fa009,0xf921a00e,0xfa6e1004}},	//   口味, 防大, 院大, 平昌
  { {0xf81df00b,0xf8163007,0xf9192001,0xf92a4004}},	//   求人, 依下, 室分, 浪公
  { {0xfa68d004,0xfa6ed00d,0x00000003,0x00000003}},	//   明村, 地掌,   ,
  { {0xf93a4004,0xfb598001,0xf9430005,0x00000003}},	//   威市, 油系, 月回,
  { {0xfb6da00e,0xfa83d004,0xf9416004,0xf9220005}},	//   視線, 可怜, 胆固, 散在
  { {0xf93c400f,0xf9478001,0xf9450008,0xfa4df004}},	//   市府, 今已, 冊定, 化提
  { {0xf92ba00f,0xfb4e2007,0xfa567004,0xf90b4001}},	//   子商, 想看, 官渡, 水力
  { {0xf82e700b,0xfa7ab001,0xf9260004,0xf4911005}},	//   郵便, 室業, 港台, 田面
  { {0xf928a004,0xf91be004,0xf9184005,0xf5aa400a}},	//   全出, 大品, 丹徒, 年草
  { {0xf5c8100c,0x00000003,0x00000003,0x00000003}},	//   周董,   ,   ,
  { {0xf90e000b,0xf920800e,0xfa81f004,0xfa84f00c}},	//   申告, 面倒, 断法, 催收
  { {0xfb4e0008,0xf8335004,0xf9118004,0x00000003}},	//   侵略, 好保, 弱化,
  { {0xfa57d007,0xfb5a0001,0xf9108008,0xf5956004}},	//   作時, 入組, 印字, 定追
  { {0xf92a000f,0xfa7b5009,0xf8111007,0xf5b61001}},	//   自助, 大案, 際事, 人見
  { {0xf495100c,0x00000003,0x00000003,0x00000003}},	// [1ae0] 任里,   ,   ,
  { {0xfa659004,0xf845b001,0xf491100c,0x00000003}},	//   双柏, 用介, 山金,
  { {0xfa5f3001,0xf9104001,0xf82ad00c,0x00000003}},	//   布施, 育幼, 康休,
  { {0xfb850009,0xf4a7100e,0xf82df005,0x00000003}},	//   免的, 用金, 米之,
  { {0xf913a004,0x00000003,0x00000003,0x00000003}},	//   格小,   ,   ,
  { {0xfa697006,0xfa4c9004,0xfa4c3004,0xf938800c}},	//   海洋, 勒泰, 提成, 夜夜
  { {0xfb64a009,0xf58ca00a,0x00000003,0x00000003}},	//   京礼, 預託,   ,
  { {0xfa535008,0xfa4fd001,0xf90a6005,0xf945e00c}},	//   多機, 託業, 家列, 構基
  { {0xf92aa006,0xf84a7001,0x00000003,0x00000003}},	//   体内, 陪你,   ,
  { {0xfb4da00f,0xfa82d009,0xfb5b6009,0xf8303004}},	//   色的, 可操, 旧版, 地体
  { {0xf9312006,0xf92e400e,0xf4949008,0xfa5b300c}},	//   字号, 暖化, 白馬, 技正
  { {0xf91e000f,0xfb68e009,0xfa56100c,0x00000003}},	//   無名, 在社, 高斯,
  { {0xfa61b00b,0xfb79c009,0xf917800a,0xfa8a100c}},	//   了承, 要立, 去勢, 庫沿
  { {0xfb67a009,0xf82a3009,0xfb820004,0xfb77e004}},	//   浩特, 税信, 分由, 膜的
  { {0xfa55d00c,0xfa50100c,0xf839b00c,0xf5ab000c}},	//   土星, 林惠, 知一, 野花
  { {0xf5bc3009,0xfb59c007,0xf91a8004,0xfb58000d}},	//   大胆, 方特, 否完, 竹生
  { {0xf4abb006,0xf845b009,0xf83a7005,0xfa6c500c}},	// [1af0] 提高, 用事, 急保, 然水
  { {0xfa7d3005,0xf91f8005,0x00000003,0x00000003}},	//   入整, 次受,   ,
  { {0xfb78c00f,0xf813f007,0xf5af2009,0xfa66300e}},	//   保管, 四人, 新要, 立派
  { {0xf5a5a001,0xf9226004,0xfa653001,0xf949c00c}},	//   忍耐, 断壮, 配指, 乎可
  { {0xfa831009,0xfa58f007,0xfb6c4009,0xf823f009}},	//   代替, 初次, 子科, 益事
  { {0xfb850008,0xfb48e008,0xfb87c005,0x00000003}},	//   計簿, 陶磁, 告破,
  { {0xf8281009,0xf81c5008,0xf4c6a005,0xfb51a005}},	//   界人, 各不, 前郭, 新点
  { {0xfa709007,0xfa5c5008,0xf929e001,0xf946e005}},	//   熱情, 市機, 質優, 偏小
  { {0xfa84f001,0xf8281004,0xf9382005,0xfa6b300c}},	//   可搭, 税企, 初字, 場指
  { {0xfb5f2001,0xf4a61005,0xf5b47005,0x00000003}},	//   章第, 修造, 国良,
  { {0xf925a007,0xf92de00e,0xf5b49001,0xfa54b001}},	//   物商, 金利, 似詞, 力新
  { {0xf49e7001,0xf917e005,0xf923c005,0xf814900d}},	//   性麻, 建外, 灯夜, 付了
  { {0xf93a6007,0xf91f0008,0xf908a005,0xfa715005}},	//   所引, 無停, 其前, 西沙
  { {0xf82fb004,0xfb7be004,0xfa6e300a,0x00000003}},	//   山之, 着社, 仲條,
  { {0xf818d007,0xf93f4008,0xfa6c9004,0xf925e005}},	//   往下, 充填, 年本, 您再
  { {0xf5a7e00b,0xf9226001,0xf946a005,0x00000003}},	//   免許, 業可, 型地,
  { {0xfb4ce009,0xf9392005,0xf5b0d002,0x00000003}},	// [1b00] 育等, 回其, 平躺,
  { {0xf82e1009,0xfb82e004,0xf925a008,0xf4af7001}},	//   至今, 争端, 全安, 化遺
  { {0xf9330008,0xf830d004,0xf934c004,0xfa5b9001}},	//   備前, 唱会, 定学, 所查
  { {0xf49d7006,0xf58fe00f,0xf923a004,0xf5a8a008}},	//   大部, 魔術, 口就, 明菜
  { {0xfa7e3008,0xf926c001,0xf910c00c,0x00000003}},	//   信時, 快又, 音大,
  { {0xfa71d006,0xf944800e,0xf93f0009,0xfb4b8001}},	//   便民, 不問, 了十, 具紫
  { {0xf910a00f,0xf92ca009,0xf80b9009,0xf490b001}},	//   防制, 体大, 近三, 地風
  { {0xf936a009,0xfa631009,0xf92ca004,0xf9490002}},	//   增多, 有本, 当大, 富德
  { {0xfb4ee00f,0xf5a44006,0xfb7f4007,0xf48bd004}},	//   地籍, 棉花, 框的, 件都
  { {0xfa83d007,0xf4a0f007,0xf9240004,0xf9134004}},	//   可惜, 業項, 可少, 失地
  { {0xfb75c001,0xfb73c004,0xfb7bc005,0x00000003}},	//   機生, 蒙牛, 要物,
  { {0xf80b7009,0xf91c2004,0xf92ec004,0xf4ad700c}},	//   析了, 性心, 金建, 取高
  { {0xfa5eb005,0xfa73b005,0xf4a7900d,0xfa60f010}},	//   刃模, 白斑, 天麻, 蘇我
  { {0xf91c8009,0xf82ed004,0x00000003,0x00000003}},	//   日国, 述介,   ,
  { {0xf5924009,0xf845b00e,0xfa5b9008,0xfa50900c}},	//   定行, 用下, 血性, 井村
  { {0xf5c81004,0x00000003,0x00000003,0x00000003}},	//   物能,   ,   ,
  { {0xfa6b7005,0xf83cf00c,0x00000003,0x00000003}},	// [1b10] 年思, 遠低,   ,
  { {0xf81df007,0xf809f004,0xfb64000c,0x00000003}},	//   係人, 体事, 搬移,
  { {0xf809f006,0xf9094009,0xfa797007,0xf9346007}},	//   当事, 件内, 空格, 高市
  { {0xf946a009,0xf8223004,0xf9144008,0xfa6e5004}},	//   双向, 予一, 房具, 防暑
  { {0xfa72500f,0xf92f2009,0xfb846001,0x00000003}},	//   到新, 比分, 合照,
  { {0xf93e000d,0x00000003,0x00000003,0x00000003}},	//   雅居,   ,   ,
  { {0xfb6c8006,0xfb51e001,0xfa765004,0xf9366004}},	//   金的, 地現, 建明, 静地
  { {0xfa59f009,0xf81ad009,0xfb526007,0xfb5a800a}},	//   一思, 私保, 能看, 童生
  { {0xfb50a009,0xf81e7004,0xf82a7005,0xf93f800a}},	//   新用, 各中, 家世, 文冊
  { {0xf918200e,0xf91b4001,0xf5a9e001,0xfa61f00d}},	//   逸品, 此建, 買要, 有思
  { {0xf599a00c,0xf929600c,0xfa7c1005,0xfb4b2005}},	//   作設, 奪回, 扦插, 水率
  { {0xf5c6b001,0xf8429004,0xf93fe00c,0xf947a002}},	//   助自, 播中, 待大, 夏娜
  { {0xf5b63007,0xf81e9009,0xf9352007,0xf4a87001}},	//   殺菌, 理不, 真心, 自送
  { {0xf944e007,0xf918e004,0xfb64e001,0xf4ae900c}},	//   手套, 油公, 種生, 受高
  { {0xf9368005,0x00000003,0x00000003,0x00000003}},	//   官学,   ,   ,
  { {0xf919800e,0xf5ac4009,0xfb6c2001,0xf9466004}},	//   容室, 年被, 園社, 行多
  { {0xf81ed007,0xf9312004,0xfa701005,0x00000003}},	// [1b20] 心人, 得其, 液浸,
  { {0xf939e00c,0x00000003,0x00000003,0x00000003}},	//   紀初,   ,   ,
  { {0xf924c006,0xfa5d1010,0x00000003,0x00000003}},	//   本地, 老朽,   ,
  { {0xf93be004,0xfa645005,0xfb4b000c,0xfb6b0005}},	//   血吸, 及敏, 整片, 浪特
  { {0xf9246009,0xfb536007,0xfb590007,0xf947e001}},	//   是外, 格紋, 此的, 位家
  { {0xf93d6006,0xf8355007,0xf845d004,0xf489f005}},	//   持共, 任一, 天保, 家非
  { {0xf81d3004,0xfa783001,0xf8331004,0x00000003}},	//   内予, 書時, 白了,
  { {0xf93b0001,0xfa6d900c,0xfb6da005,0x00000003}},	//   一可, 直想, 金穗,
  { {0xf9498005,0xf48a300c,0x00000003,0x00000003}},	//   像出, 海集,   ,
  { {0xfb6dc006,0xfb51800f,0xfb7bc004,0xfb694001}},	//   化生, 新移, 品用, 末端
  { {0xfa5d5008,0xfb5fa001,0xfa5fd005,0x00000003}},	//   市本, 遠眺, 元收,
  { {0xf81c500f,0xfb63e004,0xf9264005,0xfa787005}},	//   各位, 可生, 在它, 改投
  { {0xf91b000b,0xf5b2c007,0xf4ba0009,0xfa5a1001}},	//   以外, 施要, 裁量, 一棟
  { {0xf4aa9008,0xf919a005,0xfa6fb00c,0x00000003}},	//   八雲, 区康, 己手,
  { {0xf82e1009,0xfa663004,0xf9478005,0x00000003}},	//   至上, 行文, 坊印,
  { {0xf946a007,0xf92da008,0xfb86400c,0xfa79900c}},	//   規名, 少在, 型精, 接服
  { {0xf90b4009,0xf92da009,0xf809f004,0x00000003}},	// [1b30] 件大, 民在, 当下,
  { {0xf921c00e,0xf944c004,0xf80c5008,0xfa81100a}},	//   庭園, 案建, 間中, 中標
  { {0xfb81e004,0xf922a004,0x00000003,0x00000003}},	//   了眼, 播客,   ,
  { {0xfa643009,0xf9452007,0xfa74300a,0x00000003}},	//   之星, 前分, 房新,
  { {0xf842f006,0xf5c4f001,0xf845b008,0xfb65c005}},	//   是什, 物誌, 用例, 票等
  { {0xf80cf004,0xf925c00a,0xfa79d005,0xfa4b500c}},	//   向作, 全個, 出援, 源概
  { {0xf8211007,0xf8121004,0xfa6c1001,0xf9380005}},	//   了你, 四会, 場演, 孝南
  { {0xf5b06001,0xf821f00c,0xf943e00c,0x00000003}},	//   鹿草, 悉依, 月可,
  { {0xf9262009,0xf9302007,0xfa753004,0xf8107004}},	//   在十, 湖地, 任李, 列主
  { {0xf8427008,0xfb626005,0xfb67c00a,0x00000003}},	//   中京, 中端, 被爆,
  { {0xf90c200b,0xfb4c8004,0xfa607004,0xf93e0005}},	//   職員, 冷空, 理温, 装商
  { {0xfa783004,0xfa54b005,0xfa6bb002,0xfb80e002}},	//   容提, 也明, 伴我, 升生
  { {0xfb828006,0xfb4b8009,0xfa5c3004,0xf92fe005}},	//   案的, 其相, 市思, 何内
  { {0xf81d9004,0x00000003,0x00000003,0x00000003}},	//   十件,   ,   ,
  { {0xf820b006,0xfb84c004,0xf5a0e004,0xf9492008}},	//   理中, 告片, 商解, 小僧
  { {0xfa82d009,0xf9368009,0xf930a004,0xf5bff008}},	//   是明, 生在, 井子, 信設
  { {0xfa68f001,0xf930a005,0x00000003,0x00000003}},	// [1b40] 件所, 底子,   ,
  { {0xf4bac009,0xf82fd004,0xf938a001,0xf931e008}},	//   持高, 害他, 果子, 衛官
  { {0xf4aaf001,0xfb51c004,0x00000003,0x00000003}},	//   太麻, 脱硫,   ,
  { {0xfa7e3007,0xf8259009,0xf9420008,0xf5a30008}},	//   你我, 立信, 三回, 下請
  { {0xf4a9f004,0xfa4c300c,0xf5c4500c,0xfa7c9002}},	//   未雨, 休時, 般調, 並注
  { {0xf82d1001,0xfb676001,0xfb76800d,0xf83bd002}},	//   整人, 物素, 料瓶, 知你
  { {0xf918800f,0xfa813004,0xf4a2300d,0x00000003}},	//   券商, 中招, 中雨,
  { {0xf9414006,0xfb5ea007,0xfa687004,0xfa797004}},	//   密度, 大社, 二房, 以明
  { {0xf94a200f,0xf59f8009,0xf5b1c007,0xfb70e001}},	//   住家, 元至, 想買, 法研
  { {0xfb6a200b,0xf9282004,0xfa869005,0x00000003}},	//   措置, 在宣, 部指,
  { {0xf9282007,0xfa5d3004,0xf59d400c,0xf4c6c00d}},	//   木宣, 病有, 者葉, 行限
  { {0xfb56c006,0xfb4d600e,0xf83d9001,0xf9122004}},	//   旺留, 極端, 你了, 国合
  { {0xf83b9004,0xf93d4001,0xf5c99008,0xfa6d1004}},	//   大二, 市可, 未評, 破性
  { {0xfb67a009,0xf5952009,0xf5a50009,0xfa57b001}},	//   士的, 生考, 看被, 府所
  { {0xfa7a3009,0xfa709001,0xfa84b004,0xf8237004}},	//   肥料, 報指, 是普, 立企
  { {0xf9476007,0xf9348004,0xf594a004,0xf5b6f00c}},	//   量商, 沙坪, 牛花, 人記
  { {0xf4b3b00e,0xf90a8004,0xfb6ca004,0xf5b2400a}},	// [1b50] 標高, 海宝, 耐火, 由衣
  { {0xf81e900f,0xfb684009,0xf81bf009,0xf934600c}},	//   理位, 利申, 流中, 生合
  { {0xfb544009,0xf928a004,0xf939e004,0xf910a00c}},	//   施用, 全基, 要反, 到快
  { {0xf8287004,0xf5bab005,0xf9476005,0x00000003}},	//   零下, 入近, 行利,
  { {0xfa815006,0xf90ec009,0xf48eb008,0xfa7d3005}},	//   次数, 史志, 飲酒, 学模
  { {0xf4c4a00f,0xfa79d005,0xfb4b000c,0x00000003}},	//   重量, 室提, 致理,
  { {0xfb5d6004,0xfb7f0008,0xfa7b5005,0x00000003}},	//   因病, 密着, 以普,
  { {0xf82e3007,0xf934a001,0xf919e005,0xf82a300c}},	//   敵人, 供其, 接参, 更事
  { {0xf8105004,0xf92e2004,0xfa887004,0xfb534005}},	//   得人, 或引, 物新, 花石
  { {0xf944600f,0xfb54c002,0x00000003,0x00000003}},	//   認後, 社精,   ,
  { {0xf4c8c00f,0xf590c00e,0xf9364009,0xfa70b004}},	//   美食, 南西, 回升, 共文
  { {0xfb518007,0xfa817008,0x00000003,0x00000003}},	//   新登, 難民,   ,
  { {0xf90ae009,0xfa683007,0xf5a1c001,0xfb69e001}},	//   年元, 重整, 月見, 疫系
  { {0xf49e7001,0xfa85b004,0xfa7af001,0xf849d005}},	//   性鼻, 是房, 軸承, 被任
  { {0xf8257006,0xf918c001,0xfa67f004,0xf9106001}},	//   操作, 人座, 城概, 平口
  { {0xfb51e007,0xf9264004,0xfb488001,0xfa6f7005}},	//   社福, 在境, 然看, 石村
  { {0xf5964006,0xf5a50007,0xfa53300e,0xfa73b004}},	// [1b60] 教育, 友自, 通機, 脱水
  { {0xf842f006,0xfa841004,0xf5922001,0xfa4cf001}},	//   是一, 冬日, 多見, 契機
  { {0xf826f006,0xfa513009,0xfa659004,0xf93aa001}},	//   届人, 南新, 先水, 往取
  { {0xf909a009,0xf58f8005,0xf58ca002,0x00000003}},	//   海城, 投行, 取而,
  { {0xf4bf6001,0xfa70300c,0xf81cf005,0x00000003}},	//   的都, 印成, 心会,
  { {0xf9448006,0xf90fe006,0xf92e2004,0xfa7c5005}},	//   很大, 石化, 外媒, 以房
  { {0xfa6f5006,0xf8271007,0xfb710001,0xf48bf00c}},	//   防止, 籍人, 展策, 敷面
  { {0xfa5f900f,0xf91be009,0xf9444008,0xf9126008}},	//   的想, 除其, 下回, 便器
  { {0xf91de004,0xf9182005,0x00000003,0x00000003}},	//   校名, 点回,   ,
  { {0xfa7b1004,0xf92f6001,0xf8385001,0xf91d2005}},	//   入比, 字庫, 層介, 造品
  { {0xf9294004,0xf5ba700c,0x00000003,0x00000003}},	//   木地, 盤設,   ,
  { {0xfa76b00c,0x00000003,0x00000003,0x00000003}},	//   出旅,   ,   ,
  { {0xfb7f0007,0xfa65f005,0xfb81e00c,0xf9280005}},	//   各系, 姊洪, 有甚, 自始
  { {0xf821b007,0xf9310004,0xf940200a,0x00000003}},	//   順便, 引外, 集委,
  { {0xf9350001,0xf91fa005,0xfa85b005,0xf9118002}},	//   真品, 信在, 是承, 花展
  { {0xf919a009,0xf4bec001,0xf5c0d001,0xf9392001}},	//   入式, 商銀, 探訪, 衝刺
  { {0xf92b6009,0xf922a004,0xf823f004,0xfb7c2001}},	// [1b70] 限内, 中宣, 合中, 所申
  { {0xf945c006,0xf91ce004,0xfb6ec001,0xf912a005}},	//   二十, 以延, 取第, 就容
  { {0xf944e006,0xf933c009,0xfb4fe008,0xf4ad9004}},	//   合国, 力学, 共立, 取通
  { {0xfa5bb006,0xfa66f00e,0xf5a32007,0xf822f00c}},	//   要注, 告書, 看見, 律介
  { {0xf913e007,0xfa645004,0xf4c88001,0xf5b74004}},	//   調味, 安新, 後都, 方要
  { {0xfa7af006,0xf91ce009,0xfa821004,0xfa5c5001}},	//   此次, 接影, 中未, 技新
  { {0xfa7c5004,0xfb4b6001,0xfa61100c,0xf924c00c}},	//   以承, 場線, 分次, 崩塌
  { {0xfb7c0009,0xf5b32004,0xf9296005,0xfa87b005}},	//   着眼, 花落, 器制, 在注
  { {0xf4a13009,0xf8247005,0xfb680005,0xf81e3005}},	//   遭遇, 名不, 在班, 必会
  { {0xf945600e,0xf9354009,0xf9126007,0xfa505004}},	//   上回, 乘坐, 落後, 策扶
  { {0xf90d2004,0xfa753001,0xf938200a,0xf9234005}},	//   整容, 能治, 土台, 是包
  { {0xf8331009,0xf49d7001,0xfa82f001,0xf4a91001}},	//   稿信, 大雨, 患治, 用音
  { {0xf8377001,0xf9284004,0xf9468005,0xf4b27002}},	//   任你, 天台, 事地, 尚需
  { {0xfa625006,0xf935e009,0xfa5bf004,0xf8315005}},	//   框架, 速回, 堂教, 台信
  { {0xf5914007,0xf9314004,0x00000003,0x00000003}},	//   力行, 研基,   ,
  { {0xfb5f200f,0xfb80a009,0xfb858005,0xfa71100c}},	//   面積, 三等, 屋管, 想改
  { {0xf918a009,0xf93c600c,0x00000003,0x00000003}},	// [1b80] 区学, 考問,   ,
  { {0xf5b30007,0xfb85400c,0xf91fe00a,0xf916c005}},	//   政解, 半生, 形劇, 智勇
  { {0xf822f007,0x00000003,0x00000003,0x00000003}},	//   律事,   ,   ,
  { {0xfa62f008,0xf934e005,0xfa71100c,0x00000003}},	//   三本, 也十, 東星,
  { {0xfa6a1007,0xf8273004,0xfa663004,0x00000003}},	//   究成, 前主, 行指,
  { {0xf947a004,0xf9220005,0xfb4cc00c,0x00000003}},	//   意做, 止建, 職社,
  { {0xfa55f00e,0xf49d900a,0xfa65f005,0xf5b6000c}},	//   機材, 性部, 手来, 都買
  { {0xf9314004,0xf5b60001,0xfb60c008,0xf59ce00c}},	//   南康, 能買, 難病, 善者
  { {0xf937400f,0xfb514007,0xf9444001,0x00000003}},	//   星座, 印章, 又因,
  { {0xf9180001,0xfa743004,0xf81c3001,0xfb86a00a}},	//   典小, 格指, 的介, 完熟
  { {0xf93a8009,0xfb8ac004,0xfa72d001,0xfa55d00a}},	//   所列, 明礼, 穿梭, 速機
  { {0xf9218008,0xf93a2005,0xfa529005,0xf924a005}},	//   公序, 作健, 供投, 本已
  { {0xfb85a004,0xfb61a005,0x00000003,0x00000003}},	//   界私, 独秀,   ,
  { {0xf93ee006,0xf8319009,0xfa78d001,0xfa733001}},	//   的大, 数人, 出日, 能教
  { {0xf8409009,0xf9144008,0xfa71f005,0xf91fa00c}},	//   次以, 爽快, 地施, 次庫
  { {0xf93ac009,0xf813d020,0xfb810008,0xfb69600d}},	//   裁定, 供人, 皆無, 末班
  { {0xf81ff00e,0xf4985007,0xfb5fc009,0xf90fa004}},	// [1b90] 均一, 改道, 止的, 史学
  { {0xf5950004,0xfa7f7005,0xf91aa00d,0x00000003}},	//   生要, 院概, 相匹,
  { {0xfb81400f,0xf49eb00a,0x00000003,0x00000003}},	//   理系, 造部,   ,
  { {0xf4b43009,0xfb556004,0xfa495004,0xfa6d900c}},	//   存量, 好社, 排意, 援格
  { {0xf9096009,0xfa59f00c,0xf91f0005,0xf92bc005}},	//   家商, 品服, 大困, 当取
  { {0xf4b69004,0xfb86c004,0xfa61d00c,0x00000003}},	//   土部, 籍管, 三思,
  { {0xfa80d004,0xf824300c,0xf82ef00c,0x00000003}},	//   股改, 再予, 新住,
  { {0xf8283009,0x00000003,0x00000003,0x00000003}},	//   明了,   ,   ,
  { {0xfb4ca001,0xf5bb700c,0xfa4b700c,0x00000003}},	//   年祭, 度記, 成旅,
  { {0xfa673006,0xf91d8007,0xf9448009,0xf9446009}},	//   前来, 加分, 及市, 安康
  { {0xfb76800f,0xf8269004,0xfb57c001,0xf92ce001}},	//   神秘, 名中, 系系, 術出
  { {0xf5b1c007,0xfa5b700e,0xf4ae5005,0x00000003}},	//   想起, 療時, 妖魔,
  { {0xfa89f009,0xf9460004,0xf818b004,0xf9478005}},	//   未注, 位外, 局三, 名国
  { {0xf92c800f,0xfb60a007,0xf818b004,0xf5acc001}},	//   園地, 季的, 所上, 水解
  { {0xfa6e5007,0xf91d0001,0xf4c4a001,0xfa823005}},	//   防救, 別具, 額送, 中注
  { {0xfb660004,0xf934c001,0xfb5f2005,0xf4b2f00c}},	//   在福, 定度, 加索, 多采
  { {0xfa5cb009,0xfb57e005,0xfb58c010,0x00000003}},	// [1ba0] 要根, 核程, 交省,
  { {0xf489f00e,0xfa711004,0xf812f004,0xf925800c}},	//   制限, 想方, 料不, 助各
  { {0xf919c00f,0xf92b400e,0xf90ec001,0x00000003}},	//   人家, 道府, 極地,
  { {0xfa719009,0xf9302001,0xfa687004,0xf919a005}},	//   石柱, 動分, 量或, 入小
  { {0xfa7b5004,0xfb6aa008,0xf924e00a,0xfa70f00a}},	//   寸液, 自給, 測地, 至急
  { {0xf91de009,0xf92fe001,0xf9270004,0xf4c1e00a}},	//   大宣, 何必, 部属, 文面
  { {0xf8251005,0x00000003,0x00000003,0x00000003}},	//   届会,   ,   ,
  { {0xf93fc004,0xf9196004,0xfb4bc00c,0xf82f5005}},	//   万像, 日凌, 奶精, 洲中
  { {0xf8277009,0xfa859004,0xf943600a,0xf825500c}},	//   同中, 在消, 安婦, 後事
  { {0xfb6dc004,0xf491f001,0xf9392008,0xf4b65005}},	//   向用, 尿道, 需品, 州集
  { {0xfa611007,0xf9486009,0xf5cb700c,0x00000003}},	//   分校, 同国, 質農,
  { {0xf939e007,0xfb658009,0xf92d4004,0xfb5b0004}},	//   依其, 斯特, 村子, 略研
  { {0xf5c11009,0x00000003,0x00000003,0x00000003}},	//   院路,   ,   ,
  { {0xfb83600a,0xf599e00c,0x00000003,0x00000003}},	//   友美, 送請,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf913a00e,0xfa867009,0xf835f004,0xf80ab004}},	// [1bb0] 帽子, 物排, 出上, 成今
  { {0xf947c009,0xfa6ff001,0xf5c2b004,0xf820300a}},	//   二季, 地機, 良行, 雅人
  { {0xf915c004,0xf83ad00c,0xfa617005,0x00000003}},	//   值卡, 令你, 理核,
  { {0xf4b8900e,0xf93f8004,0xf58d8005,0x00000003}},	//   回避, 文告, 套袋,
  { {0xf91c8009,0xf91ec007,0xf4ba9004,0xfb526005}},	//   学士, 次定, 作都, 沿用
  { {0xf934200c,0x00000003,0x00000003,0x00000003}},	//   通可,   ,   ,
  { {0xf9260001,0xf5a70005,0xf912200a,0xf58ac00c}},	//   港地, 背街, 追及, 間超
  { {0xfb842009,0xf929000a,0x00000003,0x00000003}},	//   不等, 剪定,   ,
  { {0xf4bea006,0xfb7ae007,0xf947400e,0xfb5aa005}},	//   分配, 作環, 再建, 接生
  { {0xf927c009,0xf9300007,0xfa887001,0xf4add001}},	//   全天, 林口, 快打, 村風
  { {0xfa4d900e,0xfb818008,0xfb79e00c,0xfb50400c}},	//   成日, 粉症, 作無, 東省
  { {0xf8255004,0x00000003,0x00000003,0x00000003}},	//   同位,   ,   ,
  { {0xf4b19006,0xf913a009,0x00000003,0x00000003}},	//   法院, 款利,   ,
  { {0xf48d1007,0xf939a008,0xfa55900c,0x00000003}},	//   陷阱, 節分, 定曲,
  { {0xf8415007,0xf9380004,0xf91c0004,0xf9172008}},	//   業保, 作内, 查大, 鷹市
  { {0xfa763006,0xf81d7001,0xfa4fb004,0x00000003}},	//   任感, 約作, 金水,
  { {0xfb636004,0xfa5ef001,0x00000003,0x00000003}},	// [1bc0] 中精, 了所,   ,
  { {0xfa89d009,0xfa6c3004,0xfa675004,0xfa809005}},	//   被查, 家数, 量清, 客提
  { {0xf92e600f,0xfa607009,0xfa653008,0xf92d4005}},	//   限制, 文摘, 立支, 志先
  { {0xf8215007,0xf90d0004,0xfb7dc004,0xfa71700d}},	//   集人, 年座, 担着, 柳河
  { {0xfa86f009,0xfb848001,0xf4b4f001,0xf92da00c}},	//   含有, 合系, 記通, 近全
  { {0xf91f0006,0xfb86800e,0xf915e004,0xf5a80004}},	//   大地, 規程, 出安, 名茶
  { {0xf92cc004,0xfa4f1001,0x00000003,0x00000003}},	//   当履, 法拉,   ,
  { {0xfb6fe00e,0xfa821007,0xfa4d9007,0xf8315004}},	//   演習, 索書, 著手, 放三
  { {0xf944600f,0xf4c20004,0xf9350005,0x00000003}},	//   有到, 等非, 候可,
  { {0xfb66c00f,0xfb6dc007,0xf9452001,0xfb4b000c}},	//   央社, 取生, 下可, 暴篇
  { {0xf4bfc009,0xfb5ec001,0xf9150008,0xf4a3d005}},	//   切配, 性社, 稽古, 是食
  { {0xf493b009,0xfa681007,0xf935c007,0xfa867008}},	//   国金, 牌查, 識庫, 全滅
  { {0xfa7d3006,0xfa625006,0xf4a9b008,0xf946800d}},	//   学校, 安排, 邪魔, 王平
  { {0xf58b200d,0x00000003,0x00000003,0x00000003}},	//   青路,   ,   ,
  { {0xf8245007,0xf9188008,0xfb660008,0xfa79b001}},	//   授信, 主宰, 天神, 查所
  { {0xfa79b007,0xfa801005,0xf911800c,0x00000003}},	//   知所, 中消, 東協,
  { {0xfb558006,0xf5b3e00b,0xf913800e,0xf814d005}},	// [1bd0] 值班, 好評, 寿司, 会令
  { {0xfa4c3006,0xf4b5f001,0xf93b2001,0xfa78b005}},	//   排放, 生金, 送回, 核指
  { {0xfb79c00f,0xf9292009,0xf9412004,0xf911e001}},	//   私立, 在已, 分左, 音場
  { {0xfb5ae005,0x00000003,0x00000003,0x00000003}},	//   核相,   ,   ,
  { {0xf80df007,0xfb5dc004,0x00000003,0x00000003}},	//   外休, 大班,   ,
  { {0xf840500c,0xfa69500c,0xfa5c100c,0xfa683002}},	//   代一, 然教, 球手, 行步
  { {0xfa681006,0xfa5c5005,0xf945400c,0x00000003}},	//   行性, 市星, 月到,
  { {0xfb4a4005,0xf947a00c,0x00000003,0x00000003}},	//   刷的, 夏夜,   ,
  { {0xfb524006,0xf93ce009,0xf8175001,0xf5a4600c}},	//   款的, 的必, 作介, 先試
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf940a009,0xf5a60004,0xfa879004,0xf9220001}},	//   理公, 上被, 全或, 般商
  { {0xf933a007,0xf4997008,0xf5c4f004,0xf5c2d00a}},	//   務分, 出雲, 物行, 副腎
  { {0xf93a0009,0xfb572004,0xf9432001,0xf90d8001}},	//   作大, 幻灯, 構名, 育心
  { {0xf59d2007,0xfa899007,0xf9446001,0xf80ab004}},	//   超越, 部水, 安德, 成上
  { {0xf913a005,0xf915200c,0xfa64d00c,0x00000003}},	//   款助, 製出, 見未,
  { {0xf90b600b,0xf9416007,0xf4979004,0xf91ea004}},	//   究室, 有心, 出青, 因在
  { {0xfa755004,0xf597a008,0xf912a005,0x00000003}},	// [1be0] 能方, 語表, 好十,
  { {0xfa79d009,0xfa4f9009,0xf826f004,0xf9256004}},	//   出更, 金收, 位交, 是健
  { {0xf9172005,0x00000003,0x00000003,0x00000003}},	//   系公,   ,   ,
  { {0xf847f001,0xf819100c,0x00000003,0x00000003}},	//   八仙, 依人,   ,
  { {0xfa54b00c,0x00000003,0x00000003,0x00000003}},	//   際海,   ,   ,
  { {0xf82e1009,0xf5a7e007,0xfb74e001,0xf9108001}},	//   育保, 行負, 原美, 話分
  { {0xf9432007,0xf913800e,0xf595c004,0xf58dc00c}},	//   見反, 都府, 高薪, 南行
  { {0xf9310001,0xf8175004,0xfa677001,0xfb574005}},	//   何取, 作事, 意料, 去皮
  { {0xf92ce00f,0xf9444009,0xfa777009,0xfa733001}},	//   化局, 越城, 阻止, 菱格
  { {0xfb860001,0xf9284001,0xf917e00a,0xf9272005}},	//   上火, 巨匠, 岸和, 温季
  { {0xfa7a5004,0x00000003,0x00000003,0x00000003}},	//   否按,   ,   ,
  { {0xfa89b00c,0x00000003,0x00000003,0x00000003}},	//   自拔,   ,   ,
  { {0xfb586007,0xf909e001,0xfb6ea004,0xf92d0008}},	//   基督, 具奏, 向登, 外品
  { {0xf946a00f,0xf921800b,0xf93be004,0x00000003}},	//   看到, 公式, 流公,
  { {0xfa719008,0xf92be001,0xfa587001,0xf947800d}},	//   共演, 冒出, 思潮, 及危
  { {0xf5adc008,0xf80bd00c,0x00000003,0x00000003}},	//   水色, 我上,   ,
  { {0xf80cb009,0xf5c1f001,0xf94b0005,0x00000003}},	// [1bf0] 插件, 代詩, 李冰,
  { {0xfa86900f,0xfb7b0009,0xfb566001,0xf914a004}},	//   表情, 言献, 值精, 好宣
  { {0xfa6c3004,0xfa4dd00c,0x00000003,0x00000003}},	//   家新, 店最,   ,
  { {0xf598e00f,0xfa735009,0xf923a001,0xf933c005}},	//   銀行, 山海, 良多, 博得
  { {0xfa877009,0xf82c5007,0xf942e004,0x00000003}},	//   摩擦, 迷人, 光彩,
  { {0xfb5ea006,0xf93f4004,0xf91fa001,0xf932c004}},	//   大精, 分分, 夢境, 定各
  { {0xf9404009,0xf917a005,0xf5a2000c,0xfa741005}},	//   装卸, 任大, 商議, 好未
  { {0xfb570005,0xf91d400a,0x00000003,0x00000003}},	//   添置, 遠心,   ,
  { {0xf92b4009,0xf8465004,0x00000003,0x00000003}},	//   耐心, 售人,   ,
  { {0xf923a004,0xf93c8001,0xf90aa004,0xfa71f005}},	//   中已, 布布, 收公, 至整
  { {0xfa68300b,0xf5948001,0xfa5bf005,0xf938000c}},	//   小林, 四色, 哀悼, 機報
  { {0xfa5e7009,0xf9306004,0xf82b7004,0xfa6a1004}},	//   理手, 他却, 家以, 究提
  { {0xfa613004,0xfb894001,0xf5b36004,0xf4b4d001}},	//   内水, 小知, 洱茶, 高高
  { {0xfb56a009,0xf495f001,0xfa57b004,0xf910e00c}},	//   改版, 命長, 期房, 報喜
  { {0xf9448005,0xfa7c900c,0xfa6f300c,0x00000003}},	//   守学, 性招, 菲斯,
  { {0xfa65f001,0xf928e00d,0x00000003,0x00000003}},	//   牌故, 迫在,   ,

  { {0xfb7b2004,0xfa5bd008,0x00000003,0x00000003}},	// [1c00] 持生, 秀樹,   ,
  { {0xf93a8007,0xf91b0004,0xfa5b9001,0xfa5e300c}},	//   所受, 左市, 所接, 充教
  { {0xf5a44007,0xfa729004,0xfa639001,0xfa6d500c}},	//   不見, 共性, 等接, 具收
  { {0xf92ee007,0xfb4e4001,0xf9234004,0xf8351004}},	//   五千, 女福, 是充, 活不
  { {0xfa5af001,0xfa7b5004,0xf4c0a001,0xf9404005}},	//   堂月, 大消, 指通, 隆化
  { {0xf4c4c00f,0xfb68a004,0xf817500c,0xf5b0a005}},	//   再送, 周点, 作下, 地被
  { {0xfa88d004,0x00000003,0x00000003,0x00000003}},	//   邪教,   ,   ,
  { {0xf920a001,0xf4c1800c,0xfb78400c,0xfa64f00c}},	//   業品, 三采, 生父, 見注
  { {0xfa6f700c,0x00000003,0x00000003,0x00000003}},	//   石斑,   ,   ,
  { {0xf597c00b,0xf9194001,0xf918c004,0xf5bde004}},	//   機能, 丸子, 建大, 次行
  { {0xfa507007,0xfa4bb009,0xf93ea001,0xfb59a00c}},	//   塗抹, 子文, 者回, 勤科
  { {0xf919e004,0xfa705001,0xf9438004,0x00000003}},	//   以充, 抱持, 立市,
  { {0xf81f9009,0xfa7e1009,0xf943e005,0xfa6ef00c}},	//   片上, 章搜, 合公, 女愛
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa4b9009,0xfb7ba007,0xf59ac00c,0xf81bd005}},	//   少有, 懂的, 作課, 心三
  { {0xfa4b900f,0xf926a007,0xf9186001,0xfa579004}},	//   民有, 用力, 常吃, 果最
  { {0xf82bb004,0xf5ba2008,0xf91ec00c,0x00000003}},	// [1c10] 年休, 特製, 離合,
  { {0xf915c009,0xf4a57007,0xfa5c1007,0xf5b32004}},	//   好地, 憩逃, 送本, 花芽
  { {0xf93dc004,0xf92ce001,0xfa63500c,0xfa71900c}},	//   庄子, 術基, 效法, 由林
  { {0xfa5b9004,0xfb4a0004,0xf824d00c,0xf5a1c00a}},	//   所急, 整版, 先使, 有識
  { {0xfa637004,0xf932a001,0xf90ca005,0x00000003}},	//   友意, 教合, 起好,
  { {0xfa855006,0xf4ae900b,0xfa717001,0xf59da005}},	//   物流, 外部, 由法, 的耐
  { {0xf942c00c,0xf918e005,0xf5c3b00c,0xf5bae005}},	//   先做, 出基, 宮肌, 工返
  { {0xf81a3001,0xfb790004,0xf92c4004,0xfa75500a}},	//   一休, 保知, 道可, 任技
  { {0xf925a00f,0xf919c009,0xf5998007,0xf5a68007}},	//   利商, 健品, 府路, 手足
  { {0xf4c3000a,0xf825300a,0x00000003,0x00000003}},	//   例題, 奈佳,   ,
  { {0xf8307001,0xf93e0001,0xf923e001,0xf917e005}},	//   到五, 的取, 遭到, 人外
  { {0xf80eb001,0xf80f7004,0xf9262001,0xf91ce004}},	//   且一, 受他, 可報, 大唐
  { {0xf917a00f,0xf8329009,0xfb68a001,0xf92f2005}},	//   書刊, 山人, 全空, 法吊
  { {0xf937e009,0xfb830007,0xfa773004,0xf944600c}},	//   也已, 杉磯, 格水, 有印
  { {0xf8489006,0xfa65900f,0xfa5d3001,0xfa5ff004}},	//   用人, 益投, 情案, 澄海
  { {0xf4bfb00b,0xfb67000c,0x00000003,0x00000003}},	//   病院, 皮細,   ,
  { {0xf947c009,0xf837b007,0xfb752001,0xfb85400c}},	// [1c20] 夏回, 書介, 食的, 不甚
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf59ae007,0xf5956001,0xf938c001,0xf826d001}},	//   一輩, 定製, 果園, 益人
  { {0xf592a009,0xf4a5d004,0xf815b00a,0x00000003}},	//   香蕉, 售面, 償保,
  { {0xf93da007,0xf5a12005,0x00000003,0x00000003}},	//   情小, 病致,   ,
  { {0xf8373006,0xfa617009,0xfb89a004,0xfa5ed004}},	//   活中, 等情, 明灯, 的武
  { {0xfa86500b,0xf8299004,0xf80bf005,0x00000003}},	//   助成, 起不, 民住,
  { {0xf810300f,0xf4c9e007,0xfa6f3004,0xf9380004}},	//   取件, 族音, 乳期, 作必
  { {0xfa4d7009,0xf90f2001,0xfb52a001,0xf9130001}},	//   策文, 械式, 由系, 社子
  { {0xfb4f600f,0xfa679004,0xfb784004,0xfb87c00a}},	//   到的, 把新, 生状, 前申
  { {0xfb816004,0xfa5cd001,0xfa547008,0xf947200c}},	//   理特, 的悄, 高濃, 後取
  { {0xf9312007,0xf8175005,0xf8329005,0x00000003}},	//   北報, 作例, 能低,
  { {0xf93ca009,0xf92d8001,0xf846f004,0xfa73700c}},	//   往年, 街友, 部也, 西根
  { {0xf80eb00f,0xfb79c00f,0xf5c81004,0xf4905004}},	//   著作, 要看, 利能, 米面
  { {0xfa651005,0xf5abc00a,0x00000003,0x00000003}},	//   下浮, 直角,   ,
  { {0xfa61f006,0xf9394009,0xf923000e,0xf81cb004}},	//   三星, 一品, 短大, 十以
  { {0xf9468004,0xf91bc004,0xf492b00a,0x00000003}},	// [1c30] 意安, 照前, 白銀,
  { {0xf5b34007,0x00000003,0x00000003,0x00000003}},	//   眼袋,   ,   ,
  { {0xf9254006,0xf90f000f,0xfa653009,0xf4ca0004}},	//   是大, 色彩, 下旬, 意防
  { {0xfa67300b,0xf59e8008,0xfb7e4001,0xf4b25005}},	//   前日, 境負, 約用, 定配
  { {0xf5c2200b,0xfa735007,0xfa7af004,0xfb69e004}},	//   中身, 濱海, 略投, 紫竹
  { {0xfa555001,0xfa765005,0xf814d00c,0xfb52400c}},	//   食指, 人明, 生住, 都等
  { {0xf930800f,0xf81c5004,0xf5b54004,0xf9468005}},	//   字典, 善不, 幼虫, 名公
  { {0xf80e5006,0xfa711009,0xf819300c,0x00000003}},	//   比上, 平板, 勝任,
  { {0xf9418004,0xf827700c,0x00000003,0x00000003}},	//   等商, 配使,   ,
  { {0xfa6c1001,0x00000003,0x00000003,0x00000003}},	//   水林,   ,   ,
  { {0xf9362007,0xfb618004,0xf910c005,0xf90ee005}},	//   期徒, 院管, 彰全, 泰和
  { {0xfa4b9004,0xf9210001,0xf83d7005,0xfa5df00d}},	//   体投, 無尾, 学任, 的汗
  { {0xf946e004,0xf5a66005,0x00000003,0x00000003}},	//   届奥, 夏草,   ,
  { {0xfa65b001,0xf90be001,0xf8191001,0xfa637005}},	//   二技, 起加, 需一, 片更
  { {0xfa5d5004,0xf91d8005,0xfa8b9005,0xf92fc002}},	//   病残, 信守, 歪曲, 聖彼
  { {0xfa80b008,0x00000003,0x00000003,0x00000003}},	//   短所,   ,   ,
  { {0xf92dc009,0xfa663004,0xf5990004,0xf80cd004}},	// [1c40] 子建, 上浮, 增至, 当人
  { {0xf59e4008,0xfb6ae001,0xf844100d,0x00000003}},	//   時購, 材積, 般以,
  { {0xf90f400e,0xfa4a9004,0xfa86d00d,0x00000003}},	//   地元, 排毒, 在朝,
  { {0xf823100f,0xf9462009,0xf924a008,0xfb634004}},	//   手上, 前列, 本史, 良的
  { {0xfa665009,0xf9328004,0xf9476005,0xfa85d005}},	//   上旬, 多品, 同公, 在掌
  { {0xf8235006,0xf83b3007,0xfb518004,0x00000003}},	//   之一, 此主, 即申,
  { {0xf80d5005,0x00000003,0x00000003,0x00000003}},	//   得三,   ,   ,
  { {0xfa629004,0xf925e001,0xf9272001,0x00000003}},	//   先教, 全名, 央地,
  { {0xf91f2006,0xf91fa004,0xf93dc008,0xf82bb004}},	//   性地, 卡套, 療健, 起中
  { {0xf4a81004,0x00000003,0x00000003,0x00000003}},	//   用面,   ,   ,
  { {0xfa5f9009,0xf4b67004,0xfb880001,0xfa74d00c}},	//   者本, 摘除, 界知, 活泉
  { {0xf5bf400c,0xf5a9000c,0x00000003,0x00000003}},	//   性荷, 美耐,   ,
  { {0xf92de001,0xf9188004,0xfa54f00c,0x00000003}},	//   化契, 赤城, 原意,
  { {0xf9360004,0xf9128004,0xf837b001,0xf82bb004}},	//   保先, 山医, 書下, 海中
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb4d2007,0xf4a2d001,0xfa63b004,0xf90cc004}},	//   水系, 可降, 屋拆, 海平
  { {0xf823f006,0xf92be00e,0xf9430001,0xf90a600c}},	// [1c50] 届三, 金型, 均已, 制填
  { {0xfb668009,0xf93b6008,0x00000003,0x00000003}},	//   用率, 一員,   ,
  { {0xf8241004,0xf935a004,0xfb804001,0xfb872005}},	//   告不, 多台, 采的, 小病
  { {0xfa79300f,0xf9126009,0xfa4eb00c,0xf90d800c}},	//   人房, 使全, 我接, 水命
  { {0xf8201007,0xf93b8004,0xfb7e0001,0xf9204001}},	//   待人, 市品, 終特, 造地
  { {0xf58fc00c,0xf4c5a00c,0x00000003,0x00000003}},	//   展考, 界頂,   ,
  { {0xf9250004,0xfa825004,0xf8383001,0xf495f00a}},	//   京家, 口是, 盤下, 活魚
  { {0xf9382006,0xf48ef00f,0xf836700f,0xfa6b1005}},	//   土地, 育部, 人一, 卷材
  { {0xf4bad00b,0xf5ad8008,0xf81e7004,0xf9382004}},	//   一部, 併設, 善中, 期地
  { {0xf9284006,0xf81f5007,0xf94a0007,0xf931e001}},	//   天地, 商付, 城堡, 五峰
  { {0xf93ac007,0xf4c2d007,0xf599e005,0xfb6b4005}},	//   局全, 有部, 一脚, 排第
  { {0xf914800f,0xf58d6008,0xf82c9008,0xf91b8004}},	//   都可, 洗車, 浴中, 警官
  { {0xfb84a001,0xf9148001,0xf846f004,0xf48f7005}},	//   合特, 能可, 被上, 新集
  { {0xfa543009,0xf927400c,0xf92cc005,0x00000003}},	//   站提, 八名, 金存,
  { {0xf92dc006,0xf5a62004,0xf939200c,0x00000003}},	//   当年, 植被, 衝出,
  { {0xf9234004,0xf9350005,0x00000003,0x00000003}},	//   目合, 料公,   ,
  { {0xfb80e00f,0xf830b005,0xf4aaf00c,0xf4c6600a}},	// [1c60] 必究, 山会, 火鶴, 龍馬
  { {0xf81f9007,0x00000003,0x00000003,0x00000003}},	//   理作,   ,   ,
  { {0xf93ea004,0xf9196008,0xf846b005,0x00000003}},	//   市台, 日和, 用会,
  { {0xf495b004,0xf9366004,0xf91c6005,0x00000003}},	//   国音, 域外, 度外,
  { {0xfa4b7009,0xf8243004,0x00000003,0x00000003}},	//   成情, 三乱,   ,
  { {0xfa6bb001,0xfa62d005,0x00000003,0x00000003}},	//   混搭, 肉注,   ,
  { {0xf8253004,0xf5b9c00c,0xf91a6005,0x00000003}},	//   牌上, 司表, 常巡,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9392009,0xf5b32001,0xf9402004,0xfb79c00c}},	//   作取, 山農, 病医, 初申
  { {0xfa765004,0xf9242004,0xfb89800c,0xf5c1800a}},	//   人李, 普宅, 像空, 絡致
  { {0xf92f6009,0xf5ae0001,0xfb7e2004,0xfb658005}},	//   志在, 場買, 病率, 剩的
  { {0xf93f800f,0xf935e001,0xf947e00c,0xf8349005}},	//   者可, 神像, 反共, 格也
  { {0xfb658006,0xf4ba900f,0xf4b41004,0xf916e001}},	//   物的, 品集, 多部, 殺商
  { {0xf58cc007,0xf9320009,0x00000003,0x00000003}},	//   他認, 引入,   ,
  { {0xf938200b,0xf93f8004,0xf932e004,0xf90f8005}},	//   保全, 七台, 定分, 串口
  { {0xfa501009,0xf4be3007,0xf9120009,0xf80ef009}},	// [1c70] 化新, 時都, 由公, 金使
  { {0xfb788009,0xf921a008,0xfa895001,0xfa89100c}},	//   菜生, 硬式, 陪我, 含早
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa61f009,0xf5ba8007,0xf4aa5004,0xfa70100c}},	//   三期, 除臭, 麒麟, 東明
  { {0xf8263009,0xfb636007,0xf81ad001,0xf595800c}},	//   告中, 業社, 流作, 速記
  { {0xfb6e2007,0xfa5d9001,0xf5b34001,0xf9402005}},	//   字的, 心法, 眼見, 率市
  { {0xf5a8c009,0xfa887004,0xfb7f200c,0x00000003}},	//   家行, 利新, 約登,
  { {0xf48a7009,0xfa7b7004,0xf92b8001,0xfb7fe001}},	//   年里, 交房, 成商, 集結
  { {0xf8225007,0xf92e000e,0xfb65e008,0xf934e00c}},	//   篇主, 耗品, 在籍, 感小
  { {0xf80f5004,0xfb540004,0xf9138001,0xfa4c3004}},	//   化以, 国研, 宿券, 村最
  { {0xf590c00e,0xf4a83009,0xfb5de004,0xf4b3700d}},	//   北西, 用鼠, 性炭, 料附
  { {0xf5950007,0xfa7f3009,0xf838b004,0xfa79d004}},	//   付補, 管材, 交一, 出整
  { {0xf947c00f,0xf59f0009,0xf82ef005,0x00000003}},	//   不到, 分裂, 走不,
  { {0xf9234004,0xf92c6004,0xfa87b001,0x00000003}},	//   是必, 村千, 部推,
  { {0xf938200f,0xf947c006,0xfa7ad004,0xfa4d7001}},	//   速到, 福州, 度明, 策指
  { {0xfb642006,0xfb764007,0xf4a73009,0xf9438001}},	//   公示, 生研, 用道, 下心
  { {0xfa71b00f,0xfa5c700f,0xf4b55004,0xf9176008}},	// [1c80] 新書, 掃描, 会都, 点心
  { {0xf91cc004,0xf4b81001,0xf4c6f00c,0x00000003}},	//   奥地, 果香, 上麻,
  { {0xfa513009,0xfa557004,0xf4c77004,0xf83cf00d}},	//   北新, 会想, 位都, 素不
  { {0xf80af006,0xf90a6008,0xfa68f005,0xfb528005}},	//   体会, 陶器, 件最, 咽炎
  { {0xf90fc005,0xf841f005,0xfb5ba00c,0x00000003}},	//   新宝, 止任, 除疲,
  { {0xf59e2001,0xf5a3200a,0x00000003,0x00000003}},	//   約訪, 懇話,   ,
  { {0xf81f5009,0xf920e004,0xfb874004,0xf82d1008}},	//   商丘, 口密, 名特, 直人
  { {0xf912600b,0xf9256009,0xf8241004,0xf8481001}},	//   印刷, 修剪, 告位, 哪位
  { {0xf93f400f,0xf937a009,0xfa557005,0xf92a200c}},	//   商務, 官兵, 熟料, 間和
  { {0xfa789004,0x00000003,0x00000003,0x00000003}},	//   古族,   ,   ,
  { {0xf932c004,0xf8397008,0xf9456001,0xfb5d0004}},	//   会内, 健二, 名勝, 造福
  { {0xfa7fb001,0xf9212004,0xfa88d001,0xf5a0c005}},	//   惠方, 揭密, 顫抖, 了路
  { {0xf935c009,0xf944e004,0xf9314005,0xf9246005}},	//   写出, 位内, 列号, 是化
  { {0xfa4fb004,0xf914a00c,0xf81c100a,0x00000003}},	//   外承, 落客, 雄三,
  { {0xf9206009,0xfa4ed007,0xfb5f400c,0xfb59400c}},	//   断完, 織概, 珠珠, 示現
  { {0xfb602008,0xf5b76001,0xf92ba001,0xf933c001}},	//   加申, 固耐, 太地, 定底
  { {0xf58b4007,0xf823d001,0xfa79900c,0x00000003}},	// [1c90] 子賀, 型了, 改此,
  { {0xfa4e5009,0xfb6fe004,0xf935e001,0xf90ac00c}},	//   列情, 孕的, 願審, 起向
  { {0xf4c65007,0xfa4e100c,0x00000003,0x00000003}},	//   服部, 他打,   ,
  { {0xf822d006,0xf9300004,0xf814f004,0xf9484004}},	//   合作, 何勇, 定任, 每套
  { {0xf5992001,0xf919e005,0xfb882005,0xf92e600c}},	//   所言, 以待, 同特, 塔克
  { {0xfa4a3004,0xf830300c,0x00000003,0x00000003}},	//   恒星, 東一,   ,
  { {0xf93da00c,0xfa803005,0xfa65300c,0xf90dc00d}},	//   掃墓, 次扣, 行授, 巴山
  { {0xf90ee006,0xf91b6008,0xf5976005,0xfa861005}},	//   新城, 日差, 州航, 晨最
  { {0xf4b5f00f,0xf81e3004,0xfa88d00d,0x00000003}},	//   回頂, 待会, 在沿,
  { {0xf93e4007,0xfa679004,0xf83bb008,0xf842f005}},	//   商圈, 疏浚, 貧乏, 班信
  { {0xf93e4006,0xf9340001,0xfa6a9008,0xf944a005}},	//   内存, 岛屿, 年明, 先出
  { {0xf592c007,0xf5a3e001,0xf93f4005,0xfb502005}},	//   動足, 越計, 但必, 育社
  { {0xf9314007,0xfb7c0004,0xf83cb00c,0xf924a005}},	//   林家, 一社, 因下, 寮婚
  { {0xfa5fd007,0xfa727004,0xfa73b004,0xfa653004}},	//   的海, 就此, 板房, 配料
  { {0xfa707007,0xf8311004,0xf9474004,0xf4c81008}},	//   音波, 走中, 越好, 量限
  { {0xf847f001,0xf81d700c,0xfb6aa002,0x00000003}},	//   自今, 組作, 抓狂,
  { {0xf93f2009,0xfa87d004,0xfb6fe00a,0xf5cb500c}},	// [1ca0] 居全, 温湿, 動療, 自足
  { {0xf946c00e,0xf830f008,0xf91ca00c,0xf5abc00a}},	//   二子, 板一, 你又, 究調
  { {0xf5a2e00f,0xfa6d500c,0xf947200a,0x00000003}},	//   下載, 場改, 界全,
  { {0xf81af00f,0xfa611009,0xf4b15001,0xf911e005}},	//   時事, 有明, 力配, 数国
  { {0xf90aa007,0xf80f3004,0xf5b8e001,0xf8121005}},	//   然可, 引下, 諸葛, 会介
  { {0xf941c006,0xf5a1c009,0xf9484009,0xfa6e1001}},	//   合同, 三聚, 行区, 想把
  { {0xf8243007,0xf922a004,0xfa72f008,0xf4c9b00c}},	//   位介, 代大, 阿波, 住都
  { {0xfa6c7001,0xf9430005,0x00000003,0x00000003}},	//   買書, 万台,   ,
  { {0xf8203006,0xf934c009,0xfb824007,0xf80f1007}},	//   担任, 会大, 商直, 疑似
  { {0xfa655004,0xfa6c7004,0xfa7f1001,0xf595000c}},	//   上期, 年普, 採果, 湘菜
  { {0xf93b2001,0xf92cc004,0x00000003,0x00000003}},	//   作場, 易大,   ,
  { {0xf9376007,0xfb7f8004,0xfb812001,0xf9098001}},	//   高山, 包皮, 玉美, 買後
  { {0xfb83e002,0x00000003,0x00000003,0x00000003}},	//   月累,   ,   ,
  { {0xf8207009,0xfa639009,0xf9412005,0xfa4f1005}},	//   内使, 慈溪, 三品, 得法
  { {0xfa715001,0xfb78c005,0xfa78d005,0x00000003}},	//   到校, 州白, 方早,
  { {0xfb7e0008,0xf596e00c,0xf831d005,0xf90c800a}},	//   球用, 域設, 松一, 護岸
  { {0xf5bb6007,0xf4c37007,0xfa82500a,0xfb534005}},	// [1cb0] 大葉, 屋頂, 中森, 尿系
  { {0xf933000e,0xf5c1e001,0xf48c9008,0xf4963005}},	//   何年, 業評, 直面, 区配
  { {0xf5ba2009,0xfa7a3008,0xfa6d5005,0xf92c8005}},	//   古自, 容液, 史意, 排就
  { {0xf8121006,0xf946c00c,0xfa6ad005,0xf9262005}},	//   会事, 刊室, 康村, 表式
  { {0xf5a40007,0xf90e4008,0xfa683005,0x00000003}},	//   上載, 創出, 富春,
  { {0xfa627001,0xf493500a,0xf80a1010,0x00000003}},	//   版情, 西電, 易事,
  { {0xf840100f,0xf9464004,0xf837d005,0x00000003}},	//   監事, 行存, 特供,
  { {0xf93b000f,0xf92f0009,0x00000003,0x00000003}},	//   品原, 外宣,   ,
  { {0xfa6d7004,0xf9476001,0xf846700c,0xf909600c}},	//   年房, 行彩, 良伴, 陶宛
  { {0xf90fc005,0xf594e00a,0xf9354010,0x00000003}},	//   平外, 折衝, 域包,
  { {0xfb644008,0xf92ae00c,0xf9376005,0x00000003}},	//   修羅, 自出, 高就,
  { {0xf5b0e009,0xf9444004,0xfb854008,0xfa65d001}},	//   乳腺, 三台, 程第, 籍法
  { {0xf911a00f,0xf5c16007,0xfa5c5004,0xf926200a}},	//   想到, 般行, 持正, 灯台
  { {0xf9106005,0xf93f4005,0xf5c1e005,0xfa755002}},	//   便及, 内含, 硬脂, 格推
  { {0xf93d0001,0xf924e004,0xf5b24005,0x00000003}},	//   必先, 独具, 就象,
  { {0xfa675006,0xf4971009,0xf93a400c,0xf8367005}},	//   配方, 匹配, 持局, 格便
  { {0xfa6d7009,0xfb6ac001,0xf497500c,0xf58bc00c}},	// [1cc0] 冷水, 打的, 人食, 向車
  { {0xfb7e4006,0xfa63f007,0xf825500e,0xfb5fa001}},	//   市社, 有房, 開中, 你知
  { {0xf8121005,0xfb71c005,0xf922c005,0xf91a200c}},	//   会之, 何管, 口学, 她已
  { {0xf819300f,0xf925c007,0xf919c009,0xf938a008}},	//   一一, 審定, 特区, 溝口
  { {0xf939c007,0xf9302007,0xf947400d,0x00000003}},	//   所定, 投分, 免出,
  { {0xfa543009,0xf4b1500c,0xf9260005,0x00000003}},	//   多普, 力重, 表名,
  { {0xfa5b5004,0xfa859008,0xf93d0001,0xf8095005}},	//   市明, 灯油, 的勇, 倒一
  { {0xf80f5009,0xfb68a004,0xfb6ea001,0xf92de005}},	//   法不, 全示, 鑑登, 子吸
  { {0xf8297001,0xf9428001,0xf8131005,0xf83b300c}},	//   小丸, 版商, 定供, 瘦了
  { {0xf8287006,0xfb834001,0xf9364004,0xf8155004}},	//   行使, 安眠, 察北, 束了
  { {0xfb7ca004,0xfa6f9005,0x00000003,0x00000003}},	//   心病, 声清,   ,
  { {0xf8159006,0xf9312001,0xf8265001,0xf92cc004}},	//   余人, 受報, 同作, 寒冷
  { {0xf909c00f,0xf920400e,0xf847f004,0xf5a22005}},	//   冷凍, 解像, 自上, 等近
  { {0xf93e400f,0xf946c008,0xfa5ef00c,0xf93ea00a}},	//   商合, 例年, 必敗, 療制
  { {0xfa7ab007,0xf9232004,0xf49b5008,0xfb7d400d}},	//   知我, 京外, 大須, 十米
  { {0xf9446004,0xf911a005,0xf595a00c,0xfb61400a}},	//   名同, 影在, 領著, 頭線
  { {0xfa86900f,0xfa4f5009,0xfb88200c,0x00000003}},	// [1cd0] 風情, 策性, 野的,
  { {0xf8121004,0xf943600a,0xf826d005,0x00000003}},	//   会下, 下品, 半以,
  { {0xf93d6007,0xf9174005,0xf5a8000d,0x00000003}},	//   送到, 点品, 行警,
  { {0xf8221007,0xf932a004,0x00000003,0x00000003}},	//   月一, 留守,   ,
  { {0xfa6e3005,0xf92d6005,0xf91c000d,0x00000003}},	//   平明, 某大, 以弥,
  { {0xf5a4a00f,0xfb6a6004,0xf80a1004,0xfb806004}},	//   手術, 体私, 染事, 理用
  { {0xf59ba00f,0xf5bf6009,0x00000003,0x00000003}},	//   品質, 既要,   ,
  { {0xf9302006,0xfa65f001,0xfa821001,0xf5aa2001}},	//   外地, 反毒, 業未, 買者
  { {0xfa7d3007,0xf5aea00c,0x00000003,0x00000003}},	//   加持, 育評,   ,
  { {0xf916a007,0x00000003,0x00000003,0x00000003}},	//   任委,   ,   ,
  { {0xf590e004,0xf9376005,0x00000003,0x00000003}},	//   受能, 孟建,   ,
  { {0xf9486009,0xf932e00e,0xf931c001,0xfb588004}},	//   小在, 講師, 且已, 寸的
  { {0xfa7d3009,0xf4c43001,0xf91e0004,0xfa4db005}},	//   入水, 友通, 大峡, 刑或
  { {0xfb65c006,0xfa75f009,0xfb81c004,0xf9454004}},	//   全程, 国海, 了百, 同同
  { {0xf9416001,0xfa5f7008,0xf4b1300c,0x00000003}},	//   有它, 約款, 毛額,
  { {0xf931e001,0xfa501005,0xf813d00a,0xf83fd00c}},	//   力分, 取数, 弘之, 蔡佩
  { {0xf9406007,0xf9448005,0x00000003,0x00000003}},	// [1ce0] 商周, 及参,   ,
  { {0xf93ac006,0xf5a48007,0xfa649004,0xfa54f004}},	//   局在, 反而, 友提, 土所
  { {0xf91ca004,0xfb4b0001,0xfa52b004,0x00000003}},	//   因及, 念版, 留有,
  { {0xfa71d006,0xf944800e,0xf93ba001,0x00000003}},	//   地板, 上品, 時必,
  { {0xf9400006,0xf937600e,0xf92ba00e,0xfa729008}},	//   的年, 回全, 拒否, 熱性
  { {0xf4bd700f,0xf823d001,0xfb84a004,0xfa7cb008}},	//   宅配, 先修, 合点, 大江
  { {0xf4b3f00f,0xf5bc4007,0xfa63d008,0xf8441004}},	//   通部, 急診, 吉永, 括以
  { {0xf9102006,0xfb4d400e,0xf49e1004,0xfb742008}},	//   走向, 水特, 加非, 愛相
  { {0xf92f2006,0xfa6b9004,0xfb7ba008,0xf49c300a}},	//   化学, 慷慨, 流用, 急電
  { {0xfb5a4007,0xf8117009,0xfa5d7009,0xf9368004}},	//   日盛, 法中, 清明, 余年
  { {0xf8237007,0xfa693008,0xf5b30001,0xf9476001}},	//   看一, 小澤, 施者, 而可
  { {0xf90aa009,0xf9414009,0xf83d7004,0xf928400c}},	//   家利, 有十, 映了, 含原
  { {0xf80bf007,0xf599c00e,0xf92f4005,0x00000003}},	//   舒丹, 要請, 化古,
  { {0xf81e9004,0xfa4d9001,0xf4ac9005,0xf9212005}},	//   各代, 袖毛, 向集, 敬告
  { {0xfb67c00a,0xfa4ff00c,0xf92ca00c,0x00000003}},	//   全物, 取液, 民力,
  { {0xfb86a001,0x00000003,0x00000003,0x00000003}},	//   反第,   ,   ,
  { {0xfa53b001,0xfb58a00a,0xfb68200a,0x00000003}},	// [1cf0] 供此, 古着, 未納,
  { {0xfa775007,0xf931e007,0xf9446004,0xf936a00c}},	//   人感, 底座, 名和, 官室
  { {0xf923c007,0xfb7f8004,0xfb79e004,0x00000003}},	//   業地, 千米, 宜章,
  { {0xf4b6f009,0xfa88b00e,0xfa77b005,0xfa67100c}},	//   生院, 部改, 出比, 重控
  { {0xf58ca009,0xf9106009,0xf5c1a009,0xf93e6004}},	//   化行, 寿光, 敬老, 善公
  { {0xf81c5009,0xf944e004,0xfa61500c,0xf83ef00c}},	//   七一, 位必, 分日, 員作
  { {0xf9382004,0x00000003,0x00000003,0x00000003}},	//   保在,   ,   ,
  { {0xfa54f007,0xf5a9000c,0xfa4ed005,0xf91ca002}},	//   定查, 行買, 金方, 你先
  { {0xfb4c8007,0xfb71000c,0xf5b62010,0x00000003}},	//   海綿, 愛玉, 示請,
  { {0xf9164001,0xf90f6001,0xfb77e00c,0xf8131005}},	//   出式, 育宣, 機米, 留住
  { {0xf4c4f00e,0xf5c50004,0xf94b2004,0xfa5cf001}},	//   下部, 利行, 明家, 要施
  { {0xf4a4f00b,0xf918a00e,0xf8229004,0xfb50e00c}},	//   種類, 容師, 予了, 己生
  { {0xf5b2400f,0xf91fe009,0xfb792001,0xf91f0004}},	//   異議, 客商, 停火, 大声
  { {0xfb596001,0xf5bb4001,0xf9358004,0xfa663004}},	//   培管, 急迫, 生力, 行教
  { {0xfa88f004,0xf90b0001,0xf592c00c,0xf935a005}},	//   在施, 張先, 動詳, 多困
  { {0xf5aa000c,0x00000003,0x00000003,0x00000003}},	//   磷脂,   ,   ,
  { {0xf921c006,0xf499500f,0xf9138004,0xfa82300c}},	// [1d00] 代化, 人都, 朱家, 業注
  { {0xf9218004,0xf5b06005,0x00000003,0x00000003}},	//   冬小, 由考,   ,
  { {0xf933e009,0xfa73f009,0xfa743001,0xf9418002}},	//   会化, 国投, 格教, 效合
  { {0xfa5ef009,0x00000003,0x00000003,0x00000003}},	//   了最,   ,   ,
  { {0xfa82f00b,0xf9460007,0xfb5f2007,0xf9382001}},	//   公演, 位化, 管科, 作劇
  { {0xf59ca006,0xfa765001,0xfa697005,0xf940400d}},	//   的老, 任我, 起手, 分列
  { {0xf93d0009,0xfa7ab001,0xf58dc00c,0xf5a44005}},	//   求在, 摸摸, 北行, 程跟
  { {0xfa65d004,0xfa587001,0xfa631008,0xf92a2001}},	//   反恐, 增添, 洋服, 術名
  { {0xf93f6007,0xf9130004,0xf4add00c,0xf9360005}},	//   婆婆, 西峡, 他食, 保合
  { {0xf93c2001,0xf90fe004,0xf927a005,0xfb72000c}},	//   吃完, 由同, 暨全, 法翻
  { {0xfa795007,0xf82f9004,0xf59fa004,0xf4a77005}},	//   工服, 山三, 待解, 全隔
  { {0xf93b6004,0xf841b004,0xf9162001,0xf9168005}},	//   一卡, 京一, 出名, 示威
  { {0xf4c6100b,0xf4adb007,0xf8459004,0xf5b12002}},	//   上部, 林里, 用三, 政考
  { {0xfa837009,0xfa669004,0xf59ee005,0xf93cc002}},	//   本本, 意把, 商要, 它分
  { {0xf9460006,0xf93b8009,0xfa675004,0xfa53f001}},	//   届全, 市十, 上汽, 牛津
  { {0xfb874004,0xfb74a00c,0x00000003,0x00000003}},	//   名点, 香火,   ,
  { {0xf9462006,0xfa501004,0xfb68e004,0xf5b1400c}},	// [1d10] 告公, 取新, 在百, 異象
  { {0xfa5cf006,0xf81a1006,0xfb684007,0xfa88900e}},	//   老板, 退休, 助申, 部活
  { {0xf4bd7009,0xf4ae7008,0xf5b04004,0xfa72900c}},	//   的速, 演題, 由裁, 冰水
  { {0xf929c004,0xf820d004,0xf949a00c,0xf9468005}},	//   只得, 理代, 怎可, 程就
  { {0xf92f6004,0xf920000a,0xf4b5f005,0xf59f0005}},	//   林外, 校庭, 辞退, 集萃
  { {0xfb85e001,0xf92be00c,0xfa5d3005,0xfa5df00c}},	//   克群, 向後, 善晚, 桃木
  { {0xf9108005,0xfb71e00c,0x00000003,0x00000003}},	//   台套, 四篇,   ,
  { {0xfb59a001,0xf5aea001,0xfb6b2005,0x00000003}},	//   人異, 侵襲, 排目,
  { {0xfb814006,0xfa621009,0xf93ae004,0xfa605004}},	//   理登, 指正, 求合, 片清
  { {0xf931200f,0xfb5e8007,0xf90f0004,0xf5afe001}},	//   店家, 信片, 声名, 想著
  { {0xf932e009,0xf93c6004,0xfa5c5001,0xfb4a4001}},	//   料和, 一地, 各服, 場等
  { {0xf918e001,0xf90b8001,0xf947c00c,0x00000003}},	//   人入, 迷宮, 炎夏,
  { {0xf8235007,0xf93d0007,0xf93c6008,0x00000003}},	//   有你, 的假, 布十,
  { {0xf8319007,0xf9460009,0xf92c800c,0xfb882005}},	//   到任, 前夕, 倒地, 同点
  { {0xf916000e,0xf4bb3008,0xf92bc004,0xf836d005}},	//   電力, 時過, 金安, 区万
  { {0xfa60f009,0xfa825004,0xfa579001,0xfa553005}},	//   三明, 本思, 生書, 察情
  { {0xfa4c7008,0xf91d6005,0xf839900c,0x00000003}},	// [1d20] 成比, 度健, 日住,
  { {0xfa83f001,0xf4caf00c,0xfb85c00c,0x00000003}},	//   種族, 慎防, 棋盤,
  { {0xfa513004,0xf93de00c,0x00000003,0x00000003}},	//   受新, 者心,   ,
  { {0xf4a71004,0xfa819001,0xfa86d008,0x00000003}},	//   森防, 潭民, 薩摩,
  { {0xf5b3200c,0xf92a200c,0x00000003,0x00000003}},	//   山色, 間完,   ,
  { {0xfb7c2009,0xf93cc001,0xfa799004,0xf48b9005}},	//   送短, 時取, 根治, 年食
  { {0xf5c94008,0xf93a4001,0xfb598004,0xfb59c00c}},	//   全話, 最划, 油画, 蒸煮
  { {0xfa625001,0xf81a300c,0xf92e800d,0x00000003}},	//   篇日, 要係, 休工,
  { {0xf918c006,0xfb60800f,0xf91d8009,0xf5c82009}},	//   人大, 業福, 学出, 航行
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfa715006,0xf8337001,0xf48c700c,0xf81d7005}},	//   承担, 能依, 海陸, 病不
  { {0xf4c0d008,0xf4a6b004,0xfa4bb001,0xf83a900d}},	//   但馬, 温馨, 金月, 入也
  { {0xf81b9006,0xf9456004,0xf92ba004,0xf4b6300c}},	//   十五, 坊子, 近半, 教音
  { {0xf819b006,0xf9164001,0xfb75a004,0xfa4cf00c}},	//   企事, 出小, 沙特, 化流
  { {0xf943400f,0xfa685009,0xf5c20007,0x00000003}},	//   見問, 行改, 連身,
  { {0xf846b009,0xf935a009,0xf91d0008,0x00000003}},	//   助他, 多地, 大冒,
  { {0xf909e006,0xf5b66007,0xfa6e3005,0xf5c5a005}},	// [1d30] 海市, 出血, 兵活, 在草
  { {0xfb68c007,0xfb864004,0xfb72e004,0xfb71c004}},	//   自理, 名用, 展状, 牛的
  { {0xfb4be006,0xf912e004,0xfa4d9001,0xf90ae005}},	//   段的, 山国, 我比, 具回
  { {0xf93b2009,0xf9264009,0xfa541008,0xfb846001}},	//   作年, 是其, 備機, 友生
  { {0xf928e009,0xf9204007,0xfb852004,0xf9404004}},	//   用国, 遠地, 事犯, 内出
  { {0xf933e004,0xfa57f001,0xf92ba005,0x00000003}},	//   会取, 依林, 民告,
  { {0xfb83800a,0x00000003,0x00000003,0x00000003}},	//   煉瓦,   ,   ,
  { {0xf92d0004,0xf930e001,0xf4b6f004,0xfa7f500c}},	//   向原, 四合, 生面, 信投
  { {0xf83d1004,0xfb67c004,0xf5ba600c,0xf9236005}},	//   性体, 早点, 典試, 是切
  { {0xfb89000f,0xfb59a00e,0xf9442004,0xfb532005}},	//   行男, 健福, 月季, 国率
  { {0xf9380007,0xf83a9004,0xfa7bd001,0xf926400d}},	//   原味, 学上, 度感, 在千
  { {0xf91ce009,0xf932e007,0xf8409007,0xfa79b001}},	//   以其, 供全, 信人, 令我
  { {0xf4bed001,0xf49a3001,0xf90d2004,0xf4a41001}},	//   商門, 工通, 年健, 置頂
  { {0xf5b7e00f,0xfa759007,0xf9376004,0xf92d800d}},	//   常見, 登時, 生医, 誓就
  { {0xf90be008,0x00000003,0x00000003,0x00000003}},	//   起因,   ,   ,
  { {0xf93ea006,0xf5a80008,0xfb756001,0xfa6af001}},	//   市地, 導要, 生率, 競業
  { {0xf90c8001,0x00000003,0x00000003,0x00000003}},	// [1d40] 場可,   ,   ,
  { {0xf8259007,0xf946a00c,0xfb87200c,0x00000003}},	//   看你, 看地, 裏的,
  { {0xfb748006,0xfb872001,0xfa569008,0x00000003}},	//   教研, 名移, 存性,
  { {0xfa5e5001,0xf920a005,0xfa6f300a,0xf59ce00c}},	//   情愛, 代居, 進本, 頂著
  { {0xfa58f001,0xf827b004,0xf49a100a,0xfb52600c}},	//   依此, 意保, 書院, 東無
  { {0xfb55a005,0x00000003,0x00000003,0x00000003}},	//   阻燃,   ,   ,
  { {0xfa815005,0xf594800c,0x00000003,0x00000003}},	//   管新, 紙質,   ,
  { {0xf93da006,0xf944e009,0xf92ac007,0xf92e6001}},	//   超市, 位居, 成屋, 南分
  { {0xf4ac1009,0xf4afd001,0xf9408005,0xf8361005}},	//   道部, 他都, 崇川, 活作
  { {0xfa7a9007,0xf59ec009,0xf591a004,0xfb5ec004}},	//   以我, 的股, 何解, 大礼
  { {0xf9310006,0xf9330007,0xf8319001,0xf5c58001}},	//   四届, 四周, 到主, 種自
  { {0xf5a8000f,0xfa5cd007,0xfa7d9001,0xfa5d9008}},	//   再買, 境教, 坦承, 訂正
  { {0xf919a006,0xf81a9007,0xfb79a007,0xfb840001}},	//   津市, 持久, 要等, 有精
  { {0xf5a4c007,0xfa501007,0xfb61e00e,0xfa66d001}},	//   前言, 動情, 般的, 刊日
  { {0xf4bd9001,0xf947200c,0x00000003,0x00000003}},	//   必需, 界周,   ,
  { {0xfb662007,0xf91a8004,0xf5954001,0xf94b000c}},	//   可由, 学安, 生者, 乎已
  { {0xf81cb009,0xf81dd001,0xf91c2001,0xf9484004}},	// [1d50] 持以, 千五, 座充, 行出
  { {0xf839f009,0xf93fa004,0xf8245008,0xfb868005}},	//   以了, 理土, 降下, 菌生
  { {0xfb4a000b,0xf49e1004,0xf9374004,0xf92d4005}},	//   究科, 学防, 星大, 他内
  { {0xf9354006,0xf93de009,0xf91b4004,0xf9474005}},	//   域内, 心在, 度内, 小写
  { {0xfa87f006,0xf947e007,0xf5bc0005,0xf90be00c}},	//   在本, 服地, 学苑, 援引
  { {0xfa645005,0xf5a32005,0xfa765005,0x00000003}},	//   上明, 切花, 格方,
  { {0xfa7e5001,0xf925c004,0xf929400c,0x00000003}},	//   你打, 用双, 您到,
  { {0xfa64700b,0xf93dc00c,0xf948000a,0xfa67b010}},	//   不明, 時履, 杏子, 福江
  { {0xf5c4800f,0xfa6cd00c,0xf9464002,0x00000003}},	//   可自, 育消, 才庫,
  { {0xf8185006,0xf9418007,0xfa837005,0x00000003}},	//   作会, 安分, 中抽,
  { {0xfa6a3004,0xf940400c,0xfa82b005,0xfb74c005}},	//   敏捷, 分南, 客新, 料用
  { {0xf92e4006,0xf941c006,0xf93d4005,0x00000003}},	//   取得, 等多, 内安,
  { {0xf4c57004,0xfa829008,0xf944800c,0xf4977005}},	//   昌黎, 測機, 事園, 油集
  { {0xf83a9001,0xf8447010,0x00000003,0x00000003}},	//   書人, 擬似,   ,
  { {0xfb6b000f,0xf930e010,0x00000003,0x00000003}},	//   質特, 引委,   ,
  { {0xf4c09009,0xf935c004,0xfb4fc004,0xf91d800c}},	//   率高, 晚年, 防知, 御守
  { {0xfa88700b,0xf9302001,0xf4aaf00c,0xf48c3005}},	// [1d60] 全性, 動商, 源里, 零陵
  { {0xf932c004,0xf917a001,0xf92dc004,0xfb73e001}},	//   力引, 書坊, 街小, 際知
  { {0xfa5ad006,0xf59ac001,0xfb72c008,0xfa57700c}},	//   要思, 作農, 備等, 記新
  { {0xfa6db009,0xf923c004,0xfa7fb001,0x00000003}},	//   色情, 播影, 校推,
  { {0xfa59d001,0xf82d1004,0xfa6cf004,0xf8133005}},	//   朝東, 署下, 致性, 候一
  { {0xf831d007,0xf48d9009,0xf93bc001,0xf948e004}},	//   報修, 年都, 心合, 李子
  { {0xf4a6b00e,0xf5a56007,0xfa86d004,0xf58ac00c}},	//   天風, 律解, 在思, 冒著
  { {0xf9412006,0xf938e00a,0xfa57900a,0x00000003}},	//   三十, 紀後, 肝機,
  { {0xf4b3d008,0xfb4a8001,0xf9216005,0xfa57b00a}},	//   愛顧, 長笛, 冬前, 州支
  { {0xfa56700c,0x00000003,0x00000003,0x00000003}},	//   食推,   ,   ,
  { {0xfa71d00f,0xfa50900f,0xfa5d5004,0xfa619004}},	//   地政, 套房, 如本, 等文
  { {0xfb75e007,0xfb6d8004,0xfb51c004,0xf91da005}},	//   原生, 洗牌, 由用, 学常
  { {0xf80c9005,0xf5b1e00a,0x00000003,0x00000003}},	//   他介, 印西,   ,
  { {0xf4c7d00e,0xf497f00c,0x00000003,0x00000003}},	//   小金, 司配,   ,
  { {0xfa717007,0xf93a0004,0xfa82d001,0xf92d6005}},	//   山林, 初具, 正日, 志及
  { {0xf90b0006,0xf826b004,0xf92ec001,0xfb568005}},	//   年内, 名代, 金基, 人翁
  { {0xfa877004,0xf823f005,0x00000003,0x00000003}},	// [1d70] 用林, 刊上,   ,
  { {0xf91d4009,0xf9220004,0xf9100005,0xf912c005}},	//   度大, 止出, 欲出, 英尺
  { {0xfa633006,0xf4c4f007,0xfa75f009,0xfa61d001}},	//   指数, 下雨, 携手, 合服
  { {0xf916c009,0xfa875009,0xfa673004,0xf925e004}},	//   人必, 用法, 上房, 岩土
  { {0xfb872004,0xf9444001,0x00000003,0x00000003}},	//   名登, 玉女,   ,
  { {0xf5c7a004,0xf4b9d001,0xfa55d004,0xf4bf7005}},	//   在被, 送養, 香椿, 了香
  { {0xf5be2009,0xfa625004,0xfa709004,0xf9464010}},	//   学英, 宇春, 西昌, 才師
  { {0xf93ae006,0xf9454009,0xf91ce001,0xfa6c5008}},	//   流域, 行安, 給客, 長澤
  { {0xfa5ab001,0xfb714005,0x00000003,0x00000003}},	//   裁減, 得直,   ,
  { {0xf5b9400f,0xf49d5004,0xfa8ab00a,0x00000003}},	//   空調, 大雪, 被扶,
  { {0xf4c8d004,0xf83e9005,0xfa50100c,0x00000003}},	//   行防, 占世, 比比,
  { {0xf80c9009,0xf80e9009,0xf9202009,0xfa569004}},	//   他事, 休人, 渡口, 思明
  { {0xf4ba700e,0xfa5ef001,0xf9286001,0xfa7b7004}},	//   要項, 境改, 夫子, 相抵
  { {0xfa54d007,0xf9354001,0x00000003,0x00000003}},	//   願望, 回合,   ,
  { {0xfb596004,0x00000003,0x00000003,0x00000003}},	//   区石,   ,   ,
  { {0xfb7be00f,0xf9114008,0xf83eb005,0xf91e2005}},	//   品種, 百合, 信会, 座大
  { {0xf927c009,0xf90d2004,0xf93a000c,0xf5a30002}},	// [1d80] 利建, 年入, 私問, 見請
  { {0xf830f009,0xf4ca5001,0xf92dc004,0xfa84d001}},	//   新中, 奏鳴, 子区, 縮機
  { {0xf917e00f,0xf943800f,0xf910a007,0xf90aa001}},	//   人化, 載入, 房型, 其可
  { {0xf9120009,0xf5a62001,0xf942e005,0xf930c00a}},	//   新平, 名訪, 合土, 達員
  { {0xfb5a6001,0x00000003,0x00000003,0x00000003}},	//   券給,   ,   ,
  { {0xf9316009,0xfa53900c,0x00000003,0x00000003}},	//   法公, 務情,   ,
  { {0xfa675009,0xfa73b001,0xf932c00c,0xf839500a}},	//   不承, 西施, 力展, 嚥下
  { {0xf93c4006,0xf49d3001,0xf9158004,0xfb492004}},	//   品加, 你需, 施好, 状的
  { {0xf49a100f,0xf8307009,0xf4b79004,0xf9346001}},	//   書面, 使之, 保金, 通宣
  { {0xf9266004,0xfb7fa004,0xf8217005,0xf4ad9005}},	//   是年, 的甲, 但人, 店里
  { {0xf5abe008,0xf9254001,0x00000003,0x00000003}},	//   家製, 種動,   ,
  { {0xfb658006,0xfb58e009,0xf92f6009,0xf922c001}},	//   利的, 出示, 得在, 代工
  { {0xfb6d4009,0xf920e004,0xfa5c7004,0xfb77c004}},	//   道社, 劣商, 十次, 宜秀
  { {0xf90d0006,0xf83c7009,0xf9464001,0xfa7af008}},	//   年大, 入使, 才快, 略法
  { {0xf847b004,0xfa627005,0xfa50300a,0x00000003}},	//   物主, 切接, 論新,
  { {0xf80bd004,0xfa88b00c,0xfa59300a,0x00000003}},	//   互交, 周書, 着求,
  { {0xf93ba006,0xfa637009,0xfb584005,0x00000003}},	// [1d90] 十字, 事求, 示灯,
  { {0xfb77c008,0xfa4f7008,0xf92ea008,0xfa591001}},	//   府省, 志摩, 筑区, 詞曲
  { {0xf8121004,0xfa4f1005,0xfb79a00d,0x00000003}},	//   定上, 化模, 夜班,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf59fa007,0xf58ca004,0xfa6c3004,0xf90bc00c}},	//   遇見, 取行, 究新, 具可
  { {0xf942c001,0xf92ac004,0xfb674005,0xfb558005}},	//   屋合, 磐安, 含税, 好礼
  { {0xf90b200f,0xf92f200b,0xfa53d008,0xf91c0001}},	//   暴力, 演劇, 剛性, 大千
  { {0xf8307004,0xf5a5600c,0xfa55900c,0x00000003}},	//   使下, 埋設, 感愛,
  { {0xfa4bf00f,0xf9444007,0xf933a001,0xf9244008}},	//   結果, 三地, 務商, 可動
  { {0xf8327009,0xf92f8004,0xf8467004,0xf9348005}},	//   施不, 休年, 修人, 通卡
  { {0xf91fa009,0xfa5ed008,0xf92bc004,0xfb652004}},	//   面包, 境活, 成多, 是管
  { {0xf93e000f,0xf9136004,0xf924c004,0xf8277004}},	//   必備, 寿区, 支公, 行修
  { {0xf5c22004,0xf49f3005,0xfa82700c,0xf91a6005}},	//   中被, 信道, 斯拉, 泥土
  { {0xf4bf5004,0xf5b94005,0xf92d4005,0xfa7ad005}},	//   者部, 区落, 得合, 核方
  { {0xf5a8000e,0xf9330008,0xfa617008,0xfa61b00c}},	//   再起, 動具, 密接, 先把
  { {0xfb5b6009,0xf944a008,0xf59dc001,0xfa5f3005}},	//   学理, 不十, 的舒, 分情
  { {0xf91d8009,0xf8339004,0xfb542004,0x00000003}},	// [1da0] 学基, 格低, 白糖,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf82f1009,0xfb5bc005,0xfa50100c,0x00000003}},	//   地一, 以管, 投旅,
  { {0xf921000e,0xfa685001,0xfa633001,0xf58d0002}},	//   絡帳, 其效, 指新, 源良
  { {0xf9474001,0xf4b7f004,0xf9444001,0xf8267004}},	//   再出, 搜集, 見回, 里也
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf58dc005,0xf91fe005,0xfa4f3005,0xf5c2000c}},	//   受行, 正安, 法手, 連貫
  { {0xf9432009,0xf8403001,0xf4935004,0x00000003}},	//   三季, 員代, 眼里,
  { {0xf58f400f,0xf4a69009,0xf93e8007,0xfa507009}},	//   笑話, 在香, 市已, 抗日
  { {0xfa4b9004,0xfb524001,0xfb7d2008,0xf9102005}},	//   成文, 東監, 漁獲, 新当
  { {0xfa815007,0xf9476001,0xf9368005,0xfb6e400d}},	//   連江, 行審, 生巨, 休管
  { {0xfb534004,0x00000003,0x00000003,0x00000003}},	//   格等,   ,   ,
  { {0xf9404004,0xf83f9001,0xfb7c8001,0xf9454005}},	//   内基, 因人, 療癒, 同富
  { {0xf81c5006,0xfb664004,0xf80d9004,0xf5b32005}},	//   品信, 普知, 源交, 山育
  { {0xf9414001,0xfb4b8001,0xf9468005,0xf58d8005}},	//   分層, 酷炫, 上宣, 子警
  { {0xf92d800f,0xfa71d009,0xfb5ea010,0x00000003}},	//   字型, 地承, 泡盛,
  { {0xfa7b5009,0xfa6dd009,0xfa7db004,0xf93ac001}},	// [1db0] 入您, 抵扣, 大本, 所助
  { {0xf93d6004,0xf81eb004,0x00000003,0x00000003}},	//   元增, 商住,   ,
  { {0xfb58000f,0xf492d004,0xf93f4001,0xf91ea008}},	//   出物, 便面, 分商, 次官
  { {0xf5c7c007,0xfa4bb008,0xfb844004,0xf80a7001}},	//   骨質, 唐揚, 立生, 道一
  { {0xf81c1006,0xf8121007,0xfa805004,0xf93de001}},	//   的三, 引人, 加新, 千字
  { {0xfb4da009,0xf917e004,0xf947200c,0xf9302005}},	//   防病, 人取, 額基, 首台
  { {0xf92d8004,0xfa7b5004,0xf5c14001,0x00000003}},	//   或多, 日早, 札記,
  { {0xfa647004,0xfb60e004,0xf93b000c,0x00000003}},	//   按新, 衣甘, 府家,
  { {0xf81a3009,0xfa60b004,0x00000003,0x00000003}},	//   品企, 理播,   ,
  { {0xfa65500e,0x00000003,0x00000003,0x00000003}},	//   運搬,   ,   ,
  { {0xf827d009,0xf58c2004,0xf942400a,0xf4a0b010}},	//   量也, 休老, 計局, 胡麻
  { {0xf834900e,0xf92d4001,0xf8409004,0x00000003}},	//   施中, 他必, 次主,
  { {0xf8437006,0xf8257007,0xf5c5a008,0x00000003}},	//   支付, 下你, 推計,
  { {0xf91a6006,0xf93d000e,0xf9376005,0xf5a3200c}},	//   点地, 附則, 初定, 橋行
  { {0xf5b88005,0xf92d800a,0xfa7f5002,0x00000003}},	//   交融, 滑化, 巢氏,
  { {0xfa7d9004,0xfa599001,0xf93c8004,0xf943800a}},	//   大潮, 所指, 持学, 安室
  { {0xfb564001,0xf823b004,0xf5c80001,0xfa619001}},	// [1dc0] 傻瓜, 按以, 未見, 等指
  { {0xf5b02006,0xfa7a3001,0xf929800c,0xf93d800c}},	//   就要, 入教, 火宣, 約原
  { {0xf9230006,0xf4c3100e,0xfb89c004,0xf911800c}},	//   正常, 立開, 税目, 艾克
  { {0xfa55f00c,0xf5c8600c,0x00000003,0x00000003}},	//   定更, 自言,   ,
  { {0xfa89700c,0xf93fa005,0xf833f00c,0xf90d6010}},	//   全收, 文同, 派代, 念公
  { {0xf916c009,0xf5bc400e,0xf93be001,0xf9304001}},	//   人居, 健診, 境安, 店別
  { {0xfa781006,0x00000003,0x00000003,0x00000003}},	//   主板,   ,   ,
  { {0xfa5e9006,0xf910a004,0xfb862004,0xf4c9b00c}},	//   参数, 平大, 行理, 式都
  { {0xfa78d007,0xf4b69008,0xf5a42008,0xf9484004}},	//   確性, 真館, 納車, 行基
  { {0xf8185006,0xfa56b008,0xf8237008,0xf83ff008}},	//   原件, 務整, 杉並, 無修
  { {0xf929c004,0x00000003,0x00000003,0x00000003}},	//   当先,   ,   ,
  { {0xfa63700f,0xf5b28007,0xf8317004,0xfa611004}},	//   看所, 社記, 便会, 率提
  { {0xf911e004,0xfa5cf005,0xfb6a6002,0x00000003}},	//   山公, 老房, 庫署,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf947a006,0xf927e009,0xf59fa007,0xfa6bb001}},	//   上地, 用公, 的色, 年暑
  { {0xf81a3007,0xfb4fa004,0xf594800a,0xfa657005}},	//   送一, 佳答, 供述, 程正
  { {0xf58d6006,0xfa55d007,0xf920a004,0xfa809004}},	// [1dd0] 体育, 神明, 次区, 次来
  { {0xf9248007,0xf9158004,0x00000003,0x00000003}},	//   義守, 格可,   ,
  { {0xfb570006,0xf9382001,0xf91a2004,0xfa76d005}},	//   方税, 速地, 除在, 出指
  { {0xf9468004,0xfa5f5008,0xf58e8001,0xfb75c004}},	//   之声, 准教, 子買, 州美
  { {0xfb6fc004,0xf4adb001,0xf930c005,0xfb590005}},	//   套班, 間長, 供合, 出相
  { {0xfa56100e,0xf92f2004,0xf822d005,0x00000003}},	//   保有, 裕安, 先保,
  { {0xf5c72007,0xfa4e7004,0xf91de008,0xf49c9004}},	//   臨近, 列文, 大口, 来都
  { {0xf90ec00c,0xfb84400c,0xf4b5f00c,0x00000003}},	//   異同, 越美, 食餐,
  { {0xf90b2009,0xf9446007,0xf946e001,0xf9394008}},	//   年均, 重型, 偏偏, 凝固
  { {0xfb594006,0xfb74e009,0xfa6ad004,0x00000003}},	//   日益, 乙烯, 猴桃,
  { {0xf941600f,0xfa81f005,0x00000003,0x00000003}},	//   載必, 冬梅,   ,
  { {0xf4ab700a,0x00000003,0x00000003,0x00000003}},	//   習院,   ,   ,
  { {0xfa735001,0xfa72b008,0xfb5ce00c,0xfb80000d}},	//   東東, 西本, 接由, 内瓦
  { {0xf930000f,0xfa53b004,0xf58fc00c,0xfa70700c}},	//   評分, 会投, 店設, 政有
  { {0xf92f000d,0x00000003,0x00000003,0x00000003}},	//   向好,   ,   ,
  { {0xf5ab2001,0xf5914001,0xfa65d00c,0xf828d005}},	//   低腰, 換行, 位投, 族中
  { {0xfb552005,0x00000003,0x00000003,0x00000003}},	// [1de0] 国祥,   ,   ,
  { {0xfb6c0004,0xfa6bb005,0xf4a4f00c,0xfb808005}},	//   向税, 年村, 磯釣, 者社
  { {0xfa55d001,0xf929c004,0xf92e400d,0x00000003}},	//   教書, 身健, 宗商,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf938c009,0xf9320001,0xf9180004,0xfb5da005}},	//   局及, 四四, 除合, 大灯
  { {0xfa87b005,0x00000003,0x00000003,0x00000003}},	//   周恩,   ,   ,
  { {0xfb6cc00f,0xf92a0005,0xf927a00a,0xf93fa005}},	//   外籍, 剪彩, 庫僅, 文和
  { {0xfa561009,0xf91a6008,0xfb51a004,0xf918e005}},	//   原材, 室利, 就用, 人履
  { {0xfa6e5002,0x00000003,0x00000003,0x00000003}},	//   平技,   ,   ,
  { {0xfb576006,0xf597c008,0xf48af00c,0x00000003}},	//   容的, 機製, 更順,
  { {0xf92e8004,0xfb782001,0xfb58c005,0xfa6a3005}},	//   或利, 食男, 令禁, 水杉
  { {0xf9456007,0xf945e004,0xfb7d0004,0xf92be00a}},	//   計報, 二元, 薄熙, 体全
  { {0xf8167001,0xf942c004,0xf92be005,0xfb83e00a}},	//   保住, 合川, 当全, 賊版
  { {0xf5c7c004,0xf5c88008,0xfa717005,0xfa5c1002}},	//   紫薇, 適職, 彰武, 送測
  { {0xfb4d0001,0x00000003,0x00000003,0x00000003}},	//   直系,   ,   ,
  { {0xf80bd004,0x00000003,0x00000003,0x00000003}},	//   民不,   ,   ,
  { {0xfa6b300c,0xfa4df005,0xfb60200a,0xfb7ec005}},	// [1df0] 低海, 向是, 模索, 求状
  { {0xf5a52006,0xf92ec001,0x00000003,0x00000003}},	//   之路, 我建,   ,
  { {0xfb61e008,0xfa64900c,0xf93d8010,0x00000003}},	//   括的, 名氏, 漁場,
  { {0xfb6ac007,0xf4a05004,0xfb57c004,0xf819f00d}},	//   划算, 口配, 核等, 果交
  { {0xfb664001,0xf8323004,0xfa58b001,0xf81c7001}},	//   助科, 国三, 府民, 考一
  { {0xfa71b005,0xf8303005,0x00000003,0x00000003}},	//   新核, 河中,   ,
  { {0xf59f8001,0xfa565004,0xf5948001,0xfa7a9005}},	//   心走, 站新, 講話, 典活
  { {0xfb508009,0x00000003,0x00000003,0x00000003}},	//   花的,   ,   ,
  { {0xf5a72004,0xf90ce001,0xf5aee00c,0x00000003}},	//   行街, 起共, 印行,
  { {0xfa805001,0xfa719001,0x00000003,0x00000003}},	//   代最, 到日,   ,
  { {0xf4b4b00f,0xf841b009,0xf4a51001,0xf9162004}},	//   機配, 院令, 修道, 出反
  { {0xf92f6006,0xfa4fb001,0xfa80b001,0xfb80200c}},	//   或建, 且我, 校方, 商研
  { {0xfb6c800f,0xfa747009,0xfa883005,0x00000003}},	//   我的, 好本, 身感,
  { {0xf4b6900c,0x00000003,0x00000003,0x00000003}},	//   依需,   ,   ,
  { {0xf91c0004,0x00000003,0x00000003,0x00000003}},	//   来大,   ,   ,
  { {0xf9188009,0xfb4c0008,0xf4a23001,0xf9230004}},	//   移地, 併症, 業風, 港元
  { {0xfb638010,0x00000003,0x00000003,0x00000003}},	// [1e00] 督署,   ,   ,
  { {0xfa577006,0xf9480004,0xfb63000d,0x00000003}},	//   高新, 位年, 是私,
  { {0xf912e00e,0xf8111004,0xf4987001,0xf9144005}},	//   西口, 力上, 空頭, 湾大
  { {0xfa66d007,0xfa7e3007,0xf8173005,0xf8391005}},	//   反正, 管流, 作三, 方中
  { {0xf4bc9009,0xf91d200a,0xf8325010,0x00000003}},	//   的退, 遠征, 陽介,
  { {0xf597a001,0xf5ba2001,0xf91a2005,0x00000003}},	//   借貸, 役課, 方平,
  { {0xf59bc00e,0xfa827004,0xfa605005,0xfa6e900c}},	//   品表, 中旬, 分或, 音時
  { {0xf59aa007,0xfa4c100c,0xf80b900c,0xf91ca00d}},	//   要記, 習書, 間互, 学天
  { {0xf93e400f,0xf81db007,0xf58fc008,0xf9430004}},	//   集合, 者一, 化製, 奇台
  { {0xf93b0004,0xf93e6004,0xf82e7004,0xf9478005}},	//   求及, 病初, 育体, 量存
  { {0xfa63f00f,0xfb7f4007,0xf92da007,0xfa5d1001}},	//   消息, 理站, 道地, 品格
  { {0xf93aa006,0xfa689004,0xf48ff005,0xf4aa300c}},	//   十分, 夏普, 地食, 身都
  { {0xf48ed001,0xf8317005,0x00000003,0x00000003}},	//   女香, 百事,   ,
  { {0xf80d9001,0xf825b00d,0x00000003,0x00000003}},	//   某人, 介交,   ,
  { {0xf90b8006,0xfa803007,0xfb628001,0xf5b40008}},	//   水土, 你想, 代管, 能評
  { {0xf4c7d001,0xfa585005,0xfb63600c,0x00000003}},	//   低階, 搜搜, 業現,
  { {0xf4abf007,0xfa7c300c,0xf92a8005,0xf80df005}},	// [1e10] 村里, 入活, 姓心, 少中
  { {0xf93d4007,0xf9280008,0x00000003,0x00000003}},	//   要到, 全席,   ,
  { {0xf90ec00f,0xf4bdb00f,0xf5b34004,0xfb6ca004}},	//   平均, 的鼓, 就走, 易管
  { {0xf5c9600a,0xfa65700d,0x00000003,0x00000003}},	//   輪舞, 不感,   ,
  { {0xf4c5b00e,0x00000003,0x00000003,0x00000003}},	//   後退,   ,   ,
  { {0xfa693001,0xfa60b008,0xfa607004,0xfa54d00c}},	//   低投, 光案, 者承, 紙杯
  { {0xf836f00f,0xf9422006,0xf924e00e,0xfa851009}},	//   方位, 案序, 本家, 目投
  { {0xf944a009,0xfa7f9009,0xf9392008,0x00000003}},	//   不允, 客流, 血小,
  { {0xfb7e0007,0xf90e6005,0xfa65b00c,0xf937800d}},	//   的策, 育子, 認成, 付制
  { {0xfb80400f,0xfb55e009,0xf4acb004,0xfa52d004}},	//   片的, 出炉, 化配, 定情
  { {0xf48a5004,0xfb860001,0xf830900c,0xf90c2005}},	//   海高, 行組, 山丘, 年取
  { {0xf4a2d001,0xfb4e4001,0xfa6f5004,0xf9424004}},	//   可配, 味美, 平村, 有子
  { {0xf9166006,0xf82eb007,0xfa83d007,0xfb52a004}},	//   妻子, 到上, 種植, 山特
  { {0xf81d700f,0xfb59a00f,0xf4aed00a,0xfb7a800c}},	//   居住, 改登, 得金, 流站
  { {0xf92f4005,0xf916e005,0x00000003,0x00000003}},	//   法同, 特克,   ,
  { {0xfa55900c,0xf920200c,0xfa73300c,0xf92be00d}},	//   多東, 客多, 東河, 体器
  { {0xf4a3d009,0xf90fc004,0xf5c4a008,0xf9416001}},	// [1e20] 普陀, 乳化, 天草, 有吃
  { {0xf90b8009,0xfb7f4007,0xfb7a800c,0x00000003}},	//   水域, 考績, 局研,
  { {0xf944600f,0xf912e009,0xf9304004,0xfb6e4001}},	//   玉山, 英寸, 林大, 粗糙
  { {0xfb4c6007,0xfb7b0001,0xfa61900a,0x00000003}},	//   長登, 作競, 先案,
  { {0xfb562001,0xfa5f3005,0xfb78c005,0x00000003}},	//   白痴, 分清, 秀等,
  { {0xf8131006,0xfa7f9009,0xf5a68007,0xfb84a001}},	//   会会, 泡沫, 福袋, 先確
  { {0xf4beb007,0xfb666008,0xfb7e4001,0xf93d6001}},	//   的造, 器病, 約編, 送地
  { {0xf8253004,0xf80b1004,0xf5ba8005,0x00000003}},	//   位会, 易会, 交路,
  { {0xf9432009,0xf9346009,0xfa56500a,0xfa607005}},	//   圈子, 食安, 回折, 密或
  { {0xf9138007,0xf9432007,0xf92e2004,0xfb860001}},	//   房出, 月子, 向客, 行約
  { {0xf4a23009,0xf8437004,0xf93b8004,0xf90b0005}},	//   面都, 皮下, 言学, 年居
  { {0xf9184009,0xfb632004,0xf93ea002,0x00000003}},	//   方当, 解社, 如到,
  { {0xf92dc004,0xf49b300a,0xf829f005,0x00000003}},	//   子出, 券進, 起七,
  { {0xf5aa2001,0x00000003,0x00000003,0x00000003}},	//   買超,   ,   ,
  { {0xf492700f,0xf93c400f,0xf91aa00c,0xf91f6005}},	//   沿革, 球城, 入回, 靠大
  { {0xf93ce004,0xf920e004,0xf9476005,0x00000003}},	//   千分, 口分, 行天,
  { {0xf8299001,0x00000003,0x00000003,0x00000003}},	// [1e30] 家供,   ,   ,
  { {0xf9182005,0xf944800d,0xf914800d,0x00000003}},	//   治好, 免名, 款基,
  { {0xfa5bd007,0xf80a1008,0xfa85d008,0xf9408004}},	//   心有, 卓上, 央本, 超女
  { {0xfa54f004,0xf932a004,0xf929a00a,0xfa74300c}},	//   力更, 多吃, 身大, 都未
  { {0xfb552004,0xf91e4008,0xf91fa004,0xf4c87005}},	//   治税, 造園, 面内, 昌都
  { {0xfa82700c,0xfb542005,0xf90c6005,0xfa60f00d}},	//   口業, 抽穗, 更公, 了探
  { {0xf5b4a004,0xf5990004,0xf9232005,0xf935400c}},	//   羽衣, 言行, 京化, 機分
  { {0xfa777007,0xf9478004,0xf94b6001,0xfb4a4004}},	//   人我, 上已, 低年, 卷的
  { {0xf80c3009,0xfb4a4009,0xfb67c009,0xf8325004}},	//   向企, 捷的, 虫病, 白下
  { {0xfa6c7008,0xf5b6e005,0x00000003,0x00000003}},	//   極星, 容貌,   ,
  { {0xf92d4009,0xf9288004,0xfa81900c,0xf5ba000c}},	//   向当, 洪市, 口成, 日者
  { {0xf90ea008,0xf4975005,0xf908800a,0xf8309005}},	//   進協, 区非, 延床, 房上
  { {0xf9394009,0xfa6ff004,0xfb824008,0xfa67300d}},	//   一封, 地感, 資系, 行洪
  { {0xf4a2d00f,0xfa717007,0xf934a009,0xfa60d004}},	//   可重, 平東, 高密, 遇期
  { {0xfa6eb00f,0xf920e009,0xf4a19007,0xf911c00c}},	//   新手, 院在, 難道, 到幸
  { {0xf5ac400c,0xfa693005,0xf944800a,0xfb75400c}},	//   側肩, 制情, 朋子, 記疑
  { {0xf9462005,0xf914e005,0xf58da00a,0x00000003}},	// [1e40] 富商, 能卡, 術職,
  { {0xf917c009,0xf908a007,0xfb6ec004,0xf829900c}},	//   区北, 家型, 斑竹, 其保
  { {0xf5b06007,0x00000003,0x00000003,0x00000003}},	//   音設,   ,   ,
  { {0xf90fc004,0xfb7ca00c,0xf8351005,0x00000003}},	//   就完, 局破, 治不,
  { {0xfb6f0007,0xfa86f005,0xfb66800c,0x00000003}},	//   比的, 在期, 彩糖,
  { {0xf839d001,0xf91bc004,0xfa7ef004,0xf921c004}},	//   典修, 旧城, 渡期, 面入
  { {0xfa635001,0xfb6e0004,0xfb836005,0xfa6a500c}},	//   下所, 受着, 宋秀, 護指
  { {0xfb57800f,0xfa507004,0xfa7b5004,0xf5b2400c}},	//   特約, 南日, 武清, 到花
  { {0xfb738004,0xf59ec00c,0x00000003,0x00000003}},	//   定科, 的象,   ,
  { {0xf8343006,0xf4903001,0xf826500a,0xf924600c}},	//   稿件, 躲避, 告代, 種分
  { {0xfa85d007,0xf4975008,0xf8243004,0xf92f8004}},	//   可放, 区霞, 泊位, 策出
  { {0xf491f007,0xf8277004,0xf4c27004,0xfa6b9004}},	//   地都, 住会, 合集, 海港
  { {0xf9182006,0xfa775004,0xf931c001,0xfa77700d}},	//   方向, 示期, 達地, 螺栓
  { {0xf91cc004,0xfa4b5001,0xfa7f5005,0xfa6a3010}},	//   梧州, 道感, 象法, 場案
  { {0xfa6f9006,0xf9214007,0xf927c004,0xf915e004}},	//   就有, 員山, 物出, 都地
  { {0xf915e004,0xf4b1b008,0xfb52400c,0x00000003}},	//   能地, 隔週, 地環,
  { {0xf846d00f,0xfb83c001,0xfb56e004,0xfb57000c}},	// [1e50] 部保, 手的, 油税, 出線
  { {0xf93c6009,0xfb51400c,0xf942e00d,0x00000003}},	//   一声, 地無, 合功,
  { {0xf919800f,0xfa84d007,0xf930e007,0xfa60d004}},	//   工局, 京東, 際合, 万村
  { {0xfa595004,0xf848d004,0xf82ab001,0xf92ac00a}},	//   一概, 全使, 具保, 子安
  { {0xf8123009,0xf9450009,0xfa59f007,0xfa88d001}},	//   尚不, 届四, 要怎, 木板
  { {0xf92d4007,0xf90de004,0xfb874001,0xf927c004}},	//   化分, 巴德, 氏症, 用微
  { {0xfa4e3004,0xfa507005,0xf945200a,0xfb7d000c}},	//   算清, 字方, 手助, 送精
  { {0xf923600f,0xf4b27009,0xf82d5009,0xf92e4001}},	//   可分, 定量, 致使, 南庄
  { {0xf9474004,0xf822f005,0xf5aee00c,0xf5b24002}},	//   前建, 案保, 梵谷, 到英
  { {0xfb5ea004,0xf5a9800a,0xfa557005,0x00000003}},	//   大疾, 像診, 高排,
  { {0xf9256004,0xfa5c5004,0x00000003,0x00000003}},	//   亮化, 如期,   ,
  { {0xfa60300f,0xf84ad001,0x00000003,0x00000003}},	//   分比, 雪人,   ,
  { {0xf5c86004,0xf93c8001,0xf947e005,0xfa709002}},	//   全警, 持度, 昌大, 石渠
  { {0xfb5f0001,0xfa55f004,0xf59f600c,0x00000003}},	//   員生, 定整, 理講,
  { {0xfa737001,0xf9296004,0x00000003,0x00000003}},	//   山段, 木家,   ,
  { {0xf8399004,0xf940e004,0xf5c64005,0x00000003}},	//   入低, 者地, 用考,
  { {0xf844d00e,0xf919a001,0xfa7f5004,0xf92a6005}},	// [1e60] 物上, 役役, 碧水, 巫山
  { {0xf92f0008,0xf4b7f00d,0x00000003,0x00000003}},	//   逗子, 属院,   ,
  { {0xfa841001,0xfa583004,0xf835f00a,0x00000003}},	//   可成, 星海, 智之,
  { {0xfb850006,0xf93fa007,0xf8391004,0xf90ec005}},	//   前的, 理原, 交了, 已得
  { {0xfa6f3009,0xf90f2009,0xf4a15004,0xfa555004}},	//   女星, 新市, 佣金, 察文
  { {0xfa63f007,0xfa697001,0xf9144005,0xf8133005}},	//   手指, 買手, 松工, 氛中
  { {0xfa79d009,0xfa621004,0xf928c004,0xf5bb2004}},	//   出水, 三村, 用寿, 相色
  { {0xf92e6007,0xf82b5004,0xf9184001,0xfa7b5004}},	//   北分, 件交, 治平, 津港
  { {0xfb56a00b,0xf5ac8004,0xf499d001,0xfa6e1005}},	//   診療, 年路, 方選, 段来
  { {0xfb85800f,0xf9130001,0xfb826005,0x00000003}},	//   認真, 傾倒, 文登,
  { {0xfa58f00f,0xf935c009,0xfb594004,0xf9300001}},	//   作法, 定具, 入等, 投射
  { {0xfa817009,0xfb7a4004,0xf93d6005,0x00000003}},	//   中期, 持着, 善土,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xfb856001,0xfa4f700c,0x00000003,0x00000003}},	//   和美, 達悟,   ,
  { {0xfa86d004,0x00000003,0x00000003,0x00000003}},	//   早早,   ,   ,
  { {0xfa657009,0xf9336004,0xfb8b0001,0xf81e7005}},	//   立正, 仙居, 明異, 内保
  { {0xf946a001,0x00000003,0x00000003,0x00000003}},	// [1e70] 事家,   ,   ,
  { {0xfa4cb009,0xfa80f004,0xf92c800c,0xf948800a}},	//   金沙, 止或, 策安, 野党
  { {0xf936e008,0xf8091005,0xfb6d0005,0xfa52300d}},	//   肝心, 互之, 他突, 孕方
  { {0xf83f1006,0xf92be009,0xf941c001,0xf9116004}},	//   形之, 当在, 合後, 地大
  { {0xfa589004,0xf917c005,0xf81a100c,0x00000003}},	//   果桑, 区受, 府交,
  { {0xf93a4006,0xfa5c7007,0xfa5e9008,0x00000003}},	//   品市, 所收, 将棋,
  { {0xf91de006,0xfb804004,0xf92d8004,0x00000003}},	//   左右, 内空, 源大,
  { {0xf909e004,0xf5a3400c,0xf4bc700c,0xf4b0b00c}},	//   海参, 型認, 庄里, 店都
  { {0xf937c00f,0xfa5b9009,0xf4a85009,0xf8255001}},	//   生命, 市概, 物防, 額保
  { {0xf938a006,0xf9368009,0xf4ab1008,0x00000003}},	//   搞好, 高学, 角部,
  { {0xf5ad8004,0xf93a2008,0xf592e002,0x00000003}},	//   欲言, 要品, 站行,
  { {0xf92d2009,0xf920a009,0xf819700e,0xf5a30001}},	//   取各, 次出, 補修, 予補
  { {0xf9484001,0x00000003,0x00000003,0x00000003}},	//   式取,   ,   ,
  { {0xf91da007,0xfa787004,0xf910a001,0x00000003}},	//   章分, 区正, 女座,
  { {0xf82ad00a,0xfa87d005,0x00000003,0x00000003}},	//   島中, 被指,   ,
  { {0xf919e004,0xfa81d005,0x00000003,0x00000003}},	//   人年, 正或,   ,
  { {0xfb712009,0xf4c5d008,0xfa53f004,0xf58a8005}},	// [1e80] 法用, 下電, 定或, 体考
  { {0xf5c96001,0xf9482004,0xf48a7004,0xf58a8005}},	//   全買, 城内, 海通, 当考
  { {0xf820f004,0xf5bb8008,0xf83f1001,0xfb81200c}},	//   光二, 左衛, 形下, 有疏
  { {0xfa6f1007,0xf4921009,0xf83bb001,0xfa841004}},	//   地所, 影院, 給作, 般来
  { {0xf948e006,0xf929c009,0xfb7ee004,0xfb7cc00c}},	//   夏季, 体合, 必答, 係研
  { {0xf5940004,0x00000003,0x00000003,0x00000003}},	//   高行,   ,   ,
  { {0xf941e004,0xf8259001,0x00000003,0x00000003}},	//   合城, 而一,   ,
  { {0xf5c68004,0xfb6c8004,0xf921400c,0xf4c8f002}},	//   全覆, 民留, 般型, 野餐
  { {0xfb77200b,0xf5b4e005,0xfa661002,0x00000003}},	//   回答, 国象, 牌指,
  { {0xfb76800f,0xfb82400a,0xf90b400c,0xf4b1d005}},	//   祝福, 切符, 更勝, 魔防
  { {0xfb7c400f,0xfb80600e,0xf4a2b008,0xfb86200c}},	//   企管, 紅白, 波長, 才算
  { {0xf59d6007,0xf8277007,0xf8267009,0xf91b2004}},	//   情請, 明事, 行保, 来取
  { {0xf5ab600f,0xf8323001,0x00000003,0x00000003}},	//   長袖, 深信,   ,
  { {0xf92e4001,0xf5ab0001,0xfa735001,0x00000003}},	//   受各, 美育, 都愛,
  { {0xf9402004,0xf9230005,0xfa603005,0xf5a7600a}},	//   装出, 本外, 装方, 車購
  { {0xf49cf001,0xfa81b00a,0x00000003,0x00000003}},	//   苦難, 設提,   ,
  { {0xf941e007,0xf922c009,0xf9334008,0xfa581001}},	// [1e90] 先前, 断加, 備品, 原液
  { {0xf826d006,0xfa677001,0xf5c9c005,0xfb72000c}},	//   及以, 植栽, 沫若, 法移
  { {0xf919a009,0xfa781004,0xfb884001,0xf915c00c}},	//   区号, 常明, 行空, 命危
  { {0xfb7da004,0xf91e4001,0xf934000c,0xfa84500a}},	//   心研, 湧入, 定庫, 本政
  { {0xf59d4004,0xf4ba7001,0x00000003,0x00000003}},	//   市路, 果都,   ,
  { {0xfa673007,0xf4b8d004,0xf490b001,0xf5aac008}},	//   凌晨, 回音, 調配, 騎西
  { {0xfa5a9001,0xf4a61005,0xfa5c500c,0x00000003}},	//   果想, 器需, 嫁渡,
  { {0xf4a8d00e,0xf924000e,0xf90c0009,0xf80e9001}},	//   優遇, 息子, 然地, 黑人
  { {0xfa7c9008,0xfa517004,0xf5c8400c,0xf80b9010}},	//   健施, 北戴, 物詳, 限付
  { {0xf926200b,0xf5a6c005,0x00000003,0x00000003}},	//   部品, 踏踏,   ,
  { {0xfa5f5004,0xfa579004,0xfa80d001,0xf836d001}},	//   善款, 川成, 扣情, 船上
  { {0xf80d7007,0xfa649001,0xf9232004,0xf927200c}},	//   店介, 型打, 班室, 士名
  { {0xf90a8004,0xf4acb001,0xf93c4008,0x00000003}},	//   件在, 湖里, 要員,
  { {0xfa673009,0xf9446001,0xfb72a004,0xf91d4008}},	//   式框, 名後, 教版, 造元
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9372009,0xf4c4f009,0xfb636001,0xfb5b2001}},	//   作先, 越高, 副理, 司申
  { {0xfa6ed00b,0xfa7cb016,0xf5b0a001,0xfb4b0005}},	// [1ea0] 農林, 擦拭, 由談, 号科
  { {0xfa6f7007,0xfa77d008,0xf5b02005,0xf9110005}},	//   課業, 爺湖, 山要, 拳出
  { {0xf9406004,0xf91da004,0xf9254005,0xfa5cf00c}},	//   了外, 次安, 天元, 的昆
  { {0xfb770004,0xf5c62004,0xf821f004,0xf9498004}},	//   初的, 用要, 等也, 量出
  { {0xfb89200e,0xf82b1009,0xfa6b3004,0xf935a002}},	//   小牧, 年了, 税新, 瑞城
  { {0xfa623007,0xf9468001,0xfa4e3005,0xfa5f7010}},	//   有我, 見到, 他投, 資手
  { {0xf4c4d001,0xf825f005,0xf944400c,0x00000003}},	//   前送, 不俗, 重安,
  { {0xf8335009,0xf90cc00c,0x00000003,0x00000003}},	//   使人, 海味,   ,
  { {0xfa59300f,0xf4c53001,0x00000003,0x00000003}},	//   需求, 認領,   ,
  { {0xf80f7006,0xf4adb007,0xfa88f005,0xf8277005}},	//   他人, 科部, 在汽, 明下
  { {0xfa81700f,0xf916c009,0xfa723004,0xfa5ef00c}},	//   業機, 区商, 函授, 心悸
  { {0xfb80e007,0xf9386004,0xfb844005,0xf937400c}},	//   居然, 属医, 嘉玲, 灘地
  { {0xf9310006,0xf92f6001,0xf5ba6004,0xf920c008}},	//   五大, 南南, 油茶, 面化
  { {0xf92de009,0xf9428005,0xf4af9002,0xfb5aa00d}},	//   民公, 安北, 何需, 永登
  { {0xfa879009,0xf809b004,0x00000003,0x00000003}},	//   周末, 倒了,   ,
  { {0xf9434006,0xf9142004,0xf927a004,0xfa797001}},	//   三峡, 份全, 器在, 書林
  { {0xf9448009,0xfb68000e,0xf9346004,0xf9186004}},	// [1eb0] 名城, 自立, 折射, 活就
  { {0xf4999005,0xfa819005,0xfa54f005,0x00000003}},	//   以退, 口提, 速掀,
  { {0xfa79500f,0xfa5f100e,0xf9356008,0xfa583005}},	//   書法, 了時, 備員, 原新
  { {0xfa533001,0xfa5eb00c,0x00000003,0x00000003}},	//   站流, 超棒,   ,
  { {0xfb5ae004,0xf91c4001,0xf8383001,0xf9250001}},	//   交管, 別出, 常一, 斯加
  { {0xfa4e7007,0xf940c004,0xf9416008,0xfb610005}},	//   成收, 文域, 皇太, 狭窄
  { {0xf8165005,0x00000003,0x00000003,0x00000003}},	//   州万,   ,   ,
  { {0xf9110006,0xf9184001,0xfa6e1001,0xf915c001}},	//   新形, 出庭, 女歌, 都已
  { {0xfb56800e,0xf915c001,0xf8113005,0xfa835005}},	//   医科, 能已, 供住, 本普
  { {0xf4b4d008,0xfa737004,0xfb4b2001,0xfa5a100c}},	//   備部, 款或, 直笛, 品描
  { {0xfa601007,0xfa555004,0xf944c001,0xf5c5000c}},	//   宅急, 察指, 鍋底, 助行
  { {0xf8393007,0xf9446004,0xfa697001,0xf9284008}},	//   確使, 下子, 小書, 部員
  { {0xf936c015,0xfa56d001,0xf939e004,0xf9184004}},	//   存出, 存方, 果大, 点子
  { {0xf945800c,0xf4c7500c,0x00000003,0x00000003}},	//   行名, 車都,   ,
  { {0xf9456009,0xf9428007,0xf920c009,0xf4ad1004}},	//   同城, 安南, 次常, 村食
  { {0xf4979001,0xfa4c9005,0xfa65300a,0x00000003}},	//   刺青, 伐林, 開港,
  { {0xf912400f,0xfa777007,0xfa895004,0x00000003}},	// [1ec0] 報員, 建民, 莫斯,
  { {0xf9424007,0xf90a8001,0xfa87b005,0xf911a005}},	//   談判, 件周, 利来, 女家
  { {0xf824f004,0x00000003,0x00000003,0x00000003}},	//   王世,   ,   ,
  { {0xfb720007,0xf5af6004,0xf93da005,0xfb86a00a}},	//   法登, 新装, 内小, 車無
  { {0xfa7ef007,0xfa5df009,0xf4c5f001,0xf93ec00c}},	//   波拉, 的抗, 額達, 約占
  { {0xf5a4c001,0xf9152001,0xfa5d5008,0xfa66d00d}},	//   尊者, 死前, 病態, 手架
  { {0xf932e001,0x00000003,0x00000003,0x00000003}},	//   料後,   ,   ,
  { {0xfb50a006,0xf5c82007,0xfa701004,0xfb800004}},	//   花爆, 雨衣, 地村, 指着
  { {0xf8277008,0xf9316004,0xf90ba005,0x00000003}},	//   城下, 洛市, 德公,
  { {0xf945c007,0xf90ce001,0xf936a005,0x00000003}},	//   介入, 海山, 付工,
  { {0xfa647007,0xf93d4001,0xfa869001,0xf491100a}},	//   看我, 品危, 臨指, 台頭
  { {0xf841900e,0xf92f0008,0xfb898004,0xf4a51004}},	//   本一, 救命, 族特, 是造
  { {0xf829900a,0xfb6ca002,0x00000003,0x00000003}},	//   執事, 我爆,   ,
  { {0xf4a5d004,0xf9108004,0xf58da001,0xf4ca100c}},	//   在里, 地化, 塑身, 量防
  { {0xf9286006,0xf8479008,0xfa4cb005,0xf910c00a}},	//   温家, 義人, 民晚, 露宴
  { {0xf9186006,0xfa87b001,0xf8159004,0xf811f005}},	//   核心, 快拆, 星会, 会三
  { {0xf948600e,0x00000003,0x00000003,0x00000003}},	// [1ed0] 泌尿,   ,   ,
  { {0xfa6e3001,0xf947e00c,0x00000003,0x00000003}},	//   育機, 遍台,   ,
  { {0xf921c007,0xf9240009,0xf945a004,0xf82fd005}},	//   業園, 浮市, 程学, 彰会
  { {0xf939c007,0xfb4aa001,0xfb80c00c,0xfa72d00c}},	//   所博, 起生, 光玉, 由書
  { {0xf926e009,0xf91a2008,0xfa647008,0xfa81b00c}},	//   利彩, 誤字, 養所, 正比
  { {0xf9184006,0xf9278006,0xfa53d009,0xf80e5001}},	//   出席, 在外, 定比, 五下
  { {0xfa6c7009,0xf933a004,0xf48b1004,0xf490b001}},	//   巴斯, 些大, 水集, 鹿野
  { {0xfa73f001,0xfa799005,0xf9136005,0xfa7b700c}},	//   現正, 区数, 国初, 照效
  { {0xfb4aa001,0xf910a00c,0xfb76800c,0xf946e00c}},	//   海生, 到八, 感疫, 車入
  { {0xf81f5006,0xf9244004,0xf92d800c,0xfa65300d}},	//   装修, 可引, 析工, 行案
  { {0xf9204006,0xfa88b00f,0xfb532004,0xfb68e005}},	//   正式, 全方, 板管, 您精
  { {0xf9194001,0xf595a001,0xfa641001,0xfb884001}},	//   別安, 存託, 構思, 行確
  { {0xfb5ec009,0xf59f0001,0xf92f4001,0xfb4f0002}},	//   性疾, 充裕, 法完, 卵磷
  { {0xf5a0c009,0xf827b001,0xf921400c,0xf82cf005}},	//   了良, 而你, 第安, 防事
  { {0xfa669009,0xf925a001,0xfa739008,0xf8337001}},	//   不止, 彩四, 政書, 施作
  { {0xf920c009,0xf945a001,0xf8257005,0x00000003}},	//   面取, 行小, 再保,
  { {0xfb7ee004,0x00000003,0x00000003,0x00000003}},	// [1ee0] 境空,   ,   ,
  { {0xf93ea00e,0xf810f001,0xf93ac004,0xfa527004}},	//   椅子, 些事, 停地, 通概
  { {0xf922c009,0xf946c008,0xfa6d3005,0x00000003}},	//   路局, 希子, 号新,
  { {0xfa793006,0xf8151009,0xf80f3004,0xf9470005}},	//   此文, 教中, 井下, 福布
  { {0xf90e2006,0xf80f3007,0xfa5f5005,0xf921a005}},	//   年年, 底下, 分文, 断向
  { {0xf8461004,0xf5b1a00c,0xf935200a,0x00000003}},	//   在什, 深表, 煙席,
  { {0xfb6fe009,0xfb7e4004,0xf5b0e005,0x00000003}},	//   化石, 市百, 使老,
  { {0xf8215004,0xfb55e004,0xfb73a005,0xfb58800a}},	//   了交, 刻理, 力素, 書留
  { {0xfa7fd00b,0xf90b8007,0xfa503001,0xf9340004}},	//   解消, 家出, 動指, 料原
  { {0xfa5db00f,0xf8263009,0xfa83f009,0xf910c00c}},	//   者所, 富余, 是民, 到天
  { {0xf5b5a004,0xf4bcb00c,0x00000003,0x00000003}},	//   治超, 送電,   ,
  { {0xf939600f,0xfb80e006,0xf91fe009,0xf491300c}},	//   一千, 必然, 信公, 便順
  { {0xf91a4007,0xf92e600e,0xfa59f009,0xfb4c4004}},	//   別忘, 準化, 要明, 康知
  { {0xf80d9004,0xf4add00c,0xf941600c,0xfb6be005}},	//   他会, 受重, 有千, 金立
  { {0xf9216008,0xf826d004,0xf496300c,0x00000003}},	//   無印, 量低, 主食,
  { {0xfb5e800e,0xfb7e6005,0x00000003,0x00000003}},	//   加算, 超生,   ,
  { {0xfb828006,0xfa8a1009,0xfb6c8009,0xfa85f004}},	// [1ef0] 效率, 八方, 青田, 在明
  { {0xfa7a9004,0xf5bec00c,0xf939a00a,0xfa809005}},	//   以民, 員講, 所存, 次接
  { {0xf5ac0007,0xf5c26001,0xf4af9008,0xfb5e8005}},	//   場評, 客製, 引退, 次理
  { {0xf91b2007,0xf9422004,0xfa5ab001,0xf81df004}},	//   除役, 哈市, 所推, 清了
  { {0xf80d100f,0xf4a05008,0xf59f600a,0x00000003}},	//   我也, 中里, 文脈,
  { {0xf92c4009,0xf92d4004,0xf5ad2001,0xfb508001}},	//   向市, 取分, 史誌, 已由
  { {0xf81c3004,0xf8481004,0xfb770005,0x00000003}},	//   寄予, 罪事, 保率,
  { {0xfa615007,0xfb568001,0xf922c008,0xfa621004}},	//   集殺, 人私, 探偵, 月最
  { {0xf48e7007,0xf93f4004,0xfa637001,0xfa7eb008}},	//   石門, 了包, 事時, 無沙
  { {0xf9110009,0xfb74e004,0xf936400c,0xf9194002}},	//   由原, 丙烯, 妙地, 方因
  { {0xf4c3b00e,0xfa669009,0xf8289004,0xfb58600a}},	//   三鷹, 立新, 家上, 孤立
  { {0xf9188009,0xfa6d500c,0xf83ef005,0x00000003}},	//   此前, 側板, 院下,
  { {0xf9220006,0xf8289004,0xfb820001,0xf93ce005}},	//   中外, 其二, 消炎, 千兆
  { {0xf5a84008,0xf49e300a,0xfb6ea005,0x00000003}},	//   導者, 次頁, 民特,
  { {0xf924400c,0xf5aee00c,0xf4af1005,0x00000003}},	//   可展, 已自, 村都,
  { {0xfa89b00b,0xfa87d004,0x00000003,0x00000003}},	//   風水, 在普,   ,
  { {0xf5b9200e,0xf9108001,0xf90be001,0xf946a005}},	// [1f00] 区西, 地取, 然已, 及学
  { {0xfa4dd00f,0xf5b08007,0xf826f005,0xf4bff00a}},	//   科普, 唱者, 伊人, 分限
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf825d009,0xf5bf8005,0x00000003,0x00000003}},	//   立以, 止血,   ,
  { {0xf490900b,0xf9222001,0xf92e6004,0xfa597004}},	//   統領, 京劇, 南商, 技情
  { {0xfb7e400f,0xfb848004,0xf915e004,0x00000003}},	//   各種, 不畏, 好家,
  { {0xfb554006,0xfa7b7004,0xfb68e001,0xf596e00c}},	//   国特, 学文, 部社, 保者
  { {0xf939c007,0xfa78b00c,0xf58b400c,0xf914000d}},	//   所做, 空污, 道菜, 礼包
  { {0xfa799006,0xf92c8004,0xfb57000c,0x00000003}},	//   区新, 村内, 方美,
  { {0xf9408006,0xfa53f00d,0x00000003,0x00000003}},	//   分利, 料搜,   ,
  { {0xfb62e00f,0xf5aaa009,0xf941a009,0xfa835004}},	//   正確, 更要, 理好, 售有
  { {0xf83b900e,0xf58d8007,0xf8159001,0xfb6de008}},	//   日中, 染色, 仙人, 金物
  { {0xf49d3007,0xfa5b7004,0xf90fe001,0xfb778004}},	//   加送, 市最, 濱崎, 生特
  { {0xfa7f700f,0xf91ca004,0xfb7ea004,0xf93ea00c}},	//   因此, 日平, 理税, 各加
  { {0xf92f000f,0xf81a100f,0xf90f8004,0xfa88d004}},	//   協商, 要一, 哲学, 在房
  { {0xf4b41001,0x00000003,0x00000003,0x00000003}},	//   娘配,   ,   ,
  { {0xf90f6004,0xf81ff00c,0x00000003,0x00000003}},	// [1f10] 地居, 假一,   ,
  { {0xf93ce007,0xfb5d8009,0xfb588001,0xf93f8001}},	//   心力, 警示, 券理, 情可
  { {0xf8461006,0xf90c4007,0xf824100e,0xf91aa001}},	//   在一, 奶奶, 廊下, 券基
  { {0xf490b001,0x00000003,0x00000003,0x00000003}},	//   腰部,   ,   ,
  { {0xf947e004,0xf90ea001,0xf93aa001,0xf5a28005}},	//   双学, 想吃, 所含, 光裕
  { {0xf931e009,0xf4ba900c,0xf8101005,0xfb73e002}},	//   会又, 府都, 怕了, 香瓜
  { {0xfa605006,0xf59bc001,0xfa659005,0xf9418005}},	//   篇文, 求者, 倍感, 安商
  { {0xfa807004,0xf8445005,0xf839100c,0xfb6c000c}},	//   中明, 亮了, 出使, 向美
  { {0xfa611004,0xfa7a7005,0xfa555005,0x00000003}},	//   争激, 奥星, 站模,
  { {0xf80f5004,0xf92ea004,0xf5bf8005,0x00000003}},	//   取任, 村入, 巡航,
  { {0xf8367004,0xf9296005,0xfa5c5005,0x00000003}},	//   示一, 在延, 布最,
  { {0xf9498001,0xfa79300c,0xf49d700a,0x00000003}},	//   量基, 司某, 忠雄,
  { {0xfa4c7009,0xfa609009,0xf4b99001,0x00000003}},	//   提拔, 理是, 朝陽,
  { {0xf4b37001,0x00000003,0x00000003,0x00000003}},	//   四面,   ,   ,
  { {0xf91ac009,0xfb7e0001,0xf5942001,0xfb80e00c}},	//   学前, 的糖, 銘言, 宇科
  { {0xf91b2009,0xfa88d004,0xfa799004,0xfa54d005}},	//   以全, 在承, 容来, 力扶
  { {0xf840d006,0xfa53b007,0xfb6f0007,0xfa659001}},	// [1f20] 牡丹, 務指, 南科, 植村
  { {0xf4c79009,0xf9464001,0xf944800a,0x00000003}},	//   界面, 前夫, 安堵,
  { {0xf942800c,0xf59ae005,0x00000003,0x00000003}},	//   卉展, 着良,   ,
  { {0xfa743004,0xfa7cd00a,0xfb4ec005,0xfa669002}},	//   尽早, 性期, 械等, 及污
  { {0xfa86f00f,0xf92ac007,0xfa681004,0xf8351004}},	//   八月, 成型, 式投, 系不
  { {0xf5ca4004,0xfa85f005,0xf82b3005,0x00000003}},	//   溪路, 在李, 段上,
  { {0xf92e8004,0xf92c8001,0xfa825005,0xfa4cf005}},	//   村大, 間加, 中普, 打死
  { {0xfa5c900b,0xf946e001,0xfb512001,0xf91e2001}},	//   療法, 埋場, 穿的, 負向
  { {0xf8117009,0xf5a7c005,0xfb5f000c,0x00000003}},	//   展中, 税行, 胡瓜,
  { {0xf8407004,0xf922e001,0xfa727005,0x00000003}},	//   肢体, 辣妹, 房或,
  { {0xf80d9004,0xf5a1e001,0xf912e004,0xfb71c00c}},	//   志不, 指責, 款增, 柔細
  { {0xf93b4007,0xf90ba007,0xfa551001,0xf9266004}},	//   一口, 家常, 原汁, 在包
  { {0xfa89b00e,0xf9134007,0xf91b0004,0xf92f4001}},	//   自演, 西哥, 以太, 店取
  { {0xf82e100f,0xfb6e0008,0xf9434001,0xf80d9004}},	//   音下, 南紀, 有口, 析人
  { {0xfa5b3007,0xfa681005,0xfa6f900c,0xf91de00c}},	//   一波, 前收, 山有, 給女
  { {0xf92d8005,0xf5a94002,0x00000003,0x00000003}},	//   或博, 小肥,   ,
  { {0xfa859009,0xfa615001,0xf92de008,0xf93a200c}},	// [1f30] 用有, 有求, 聖子, 府入
  { {0xfa80d00e,0xf91d4004,0xf4929001,0xf823f005}},	//   短時, 大外, 腿部, 把上
  { {0xfa6f3006,0xfa53f00e,0xf9118004,0xfa4df004}},	//   地概, 婚準, 地履, 疑是
  { {0xf945000f,0xf90de00f,0xfa713001,0x00000003}},	//   積分, 場地, 宿旅,
  { {0xf80cd001,0xfa8ab004,0xf4b89004,0xf4b65005}},	//   民作, 被收, 障金, 九里
  { {0xfb74e004,0xf4b67001,0xf941e00c,0xfa5a3005}},	//   会知, 租部, 拉孚, 最易
  { {0xfa67d006,0xf9366009,0xfa53b004,0xf944c004}},	//   掌握, 初始, 会法, 立志
  { {0xfb804001,0xf90c6001,0xfb75a001,0xfb87000c}},	//   切的, 奶嘴, 教系, 位知
  { {0xf909e004,0xfa599001,0xf498b004,0xf4a6f00c}},	//   刷屏, 所教, 根部, 潮音
  { {0xfa61900f,0xfb67200e,0xf9192007,0xf5a90001}},	//   等教, 八王, 方形, 歌迷
  { {0xfa6c7001,0xf8437004,0xfa64d004,0xf59cc00c}},	//   家暴, 普之, 殊情, 的胃
  { {0xf8289012,0xf8429009,0xfa895004,0xf9456004}},	//   件事, 景下, 坪村, 越少
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf93a0007,0xfa5cd001,0xf8319005,0xf926a005}},	//   府大, 要拿, 台以, 革取
  { {0xfb69000c,0xfa7fd005,0xf833d005,0xfb6bc00c}},	//   質牛, 造板, 都体, 金玉
  { {0xfa579008,0xfb748005,0x00000003,0x00000003}},	//   盟書, 感等,   ,
  { {0xfa841007,0xf838d004,0xf941c004,0xfb750005}},	// [1f40] 可憐, 建交, 理平, 域私
  { {0xf4b49009,0x00000003,0x00000003,0x00000003}},	//   会造,   ,   ,
  { {0xf9164007,0xfa62d001,0xf4b9100a,0x00000003}},	//   出問, 案招, 技量,
  { {0xf90d000f,0xf937a007,0xfb822007,0xfa87d008}},	//   菲律, 生宿, 祈福, 天板
  { {0xfb616006,0xfa54300c,0xf5b5e00c,0x00000003}},	//   探索, 候我, 活講,
  { {0xf924600e,0xf926e009,0xfa4dd001,0xf93c2001}},	//   微妙, 用土, 我推, 要宣
  { {0xf948a00f,0xf92bc009,0xf8373009,0xf9458007}},	//   而已, 民同, 系中, 行前
  { {0xf934a00f,0xfb7f4009,0xf845f009,0xf5b2e004}},	//   記分, 密的, 用住, 国考
  { {0xf9374004,0xf8353008,0xf9120005,0xf92c600c}},	//   作弊, 白人, 份合, 間客
  { {0xf90a600f,0xf5988006,0xf925c004,0xfa637008}},	//   強力, 思路, 修公, 個所
  { {0xfa793007,0xf9394004,0x00000003,0x00000003}},	//   略有, 潜在,   ,
  { {0xf924e00f,0xf9384009,0xf924000a,0x00000003}},	//   本島, 土家, 本健,
  { {0xfa6c9004,0xf80c9001,0xf8139005,0xfb85e00c}},	//   海湾, 間信, 候了, 袋空
  { {0xfb66000f,0xf9214001,0xf938000c,0xfa80700d}},	//   可申, 員報, 吟唱, 席李
  { {0xfa791007,0xf48f9009,0xfa86b009,0xfb666001}},	//   常感, 新高, 物或, 目睹
  { {0xfa5c1007,0xf83a7004,0xf9126004,0xf9218001}},	//   品業, 入保, 国同, 患子
  { {0xfa55f002,0x00000003,0x00000003,0x00000003}},	// [1f50] 也打,   ,   ,
  { {0xfa881009,0xfa79b009,0xfa845007,0xfa527002}},	//   恩施, 来最, 置框, 望民
  { {0xf91bc00b,0xf920e009,0xf4b6b004,0xf81c1005}},	//   工学, 中包, 非食, 千上
  { {0xf49ff00e,0xf93d0004,0xf4b29005,0xf93fa00c}},	//   那須, 流平, 四道, 片型
  { {0xfa6e3004,0xf90ce005,0xfa84100c,0xfb5e600c}},	//   女明, 巴彦, 是打, 次約
  { {0xf9400009,0xf934a004,0xfa4f5005,0xfa73500c}},	//   万千, 生同, 化日, 宿日
  { {0xf597e009,0xf917a004,0xf92e6001,0xfb7ee00c}},	//   作考, 主大, 駐地, 必翔
  { {0xfb6e2009,0xfa657001,0xf5c34008,0xfa4f300c}},	//   算的, 上我, 口調, 林投
  { {0xf912400f,0xfa819005,0xfb87800c,0xfb850002}},	//   深度, 次整, 誌目, 重約
  { {0xf92ce007,0xfb6ba00e,0xfb76c005,0xf92c800c}},	//   我做, 汐留, 州生, 源委
  { {0xf9372004,0xfb78a001,0xf94b2004,0xf90c600c}},	//   作合, 思維, 李家, 致可
  { {0xfb806004,0xfb88c001,0xf93ac00c,0xfa54500a}},	//   文站, 癌細, 時先, 高梁
  { {0xf91ee009,0xfb6da004,0xfa7b7004,0xf938a001}},	//   因公, 体状, 学指, 技嘉
  { {0xfa80d006,0xfb5aa007,0xf5afe004,0xf49b1001}},	//   正文, 書特, 地膜, 常都
  { {0xfb5da005,0x00000003,0x00000003,0x00000003}},	//   学相,   ,   ,
  { {0xf824d006,0xf58c4006,0xf909c001,0xf9416005}},	//   上了, 道路, 長城, 了健
  { {0xf90b8004,0x00000003,0x00000003,0x00000003}},	// [1f60] 家基,   ,   ,
  { {0xf824f006,0x00000003,0x00000003,0x00000003}},	//   不了,   ,   ,
  { {0xf916e004,0xfa87d004,0x00000003,0x00000003}},	//   任在, 士指,   ,
  { {0xf9466009,0xf59e6001,0xfa6d1001,0xf92cc00a}},	//   富多, 療育, 致死, 排卵
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf81c3007,0xf9442001,0xf90c2001,0xf93d4004}},	//   要你, 合加, 張力, 要地
  { {0xf4bcd00f,0xf91b0009,0xf5bcc007,0xfa7ad004}},	//   寄送, 接引, 遠見, 接提
  { {0xf4ba9004,0xfa507008,0xfa567008,0xf80bf00a}},	//   丁香, 北日, 高次, 子保
  { {0xf491700f,0xf4bef001,0xf4903001,0xfb792002}},	//   害防, 分送, 陰道, 最省
  { {0xfa6df00f,0xf9414007,0xf91fc004,0xf8455004}},	//   飲料, 三千, 代先, 是交
  { {0xf833900c,0xfa7e9005,0xf4b4700c,0xfb80600d}},	//   值一, 大房, 際音, 内相
  { {0xf9090001,0xf4c81001,0xf931e005,0xf8447005}},	//   其境, 問道, 会先, 可他
  { {0xf845b004,0xf815b00d,0x00000003,0x00000003}},	//   器下, 属不,   ,
  { {0xf9440001,0xfb520001,0xf8227004,0x00000003}},	//   位先, 共累, 率以,
  { {0xf83bd009,0xfa7b5001,0xf919000a,0x00000003}},	//   大一, 陸海, 古商,
  { {0xf945a00b,0xf9382001,0xfb626005,0x00000003}},	//   程度, 神岡, 扭矩,
  { {0xf4c4d001,0xf49c5008,0xfb6c6010,0x00000003}},	// [1f70] 下雪, 日選, 道維,
  { {0xfa60500f,0xf9244001,0xf80bb005,0xf93f0005}},	//   劇情, 般常, 析会, 的妻
  { {0xf9450004,0xf811f004,0xf916e004,0xf945a004}},	//   合平, 定予, 智力, 立学
  { {0xfb4d0009,0xf943600c,0xf5a9600a,0x00000003}},	//   更登, 克夏, 海賊,
  { {0xf82d100f,0xf4a47004,0xf9486005,0xf933e005}},	//   仲介, 本都, 富典, 晚在
  { {0xfb874009,0xf9180004,0xf9202001,0xf90c0002}},	//   上百, 建在, 正前, 其地
  { {0xf9352004,0xf929e004,0xfa849004,0xfa81d005}},	//   也包, 当及, 路是, 京求
  { {0xfa859001,0x00000003,0x00000003,0x00000003}},	//   全效,   ,   ,
  { {0xf5aa4007,0xf934c008,0xf80c7004,0xfa5ff004}},	//   長者, 務士, 化上, 黄海
  { {0xf4ac100a,0x00000003,0x00000003,0x00000003}},	//   道館,   ,   ,
  { {0xfb6e0005,0x00000003,0x00000003,0x00000003}},	//   科班,   ,   ,
  { {0xfb5e8009,0xfb7d4004,0xf4c55004,0xfb868005}},	//   卡的, 内玉, 屋面, 不竭
  { {0xfb78a006,0xf9472007,0xfa78f004,0xfb874001}},	//   局版, 融入, 出改, 量約
  { {0xf816b004,0xf4bf1008,0xf5be2004,0xfb84a005}},	//   江中, 球選, 象要, 刊的
  { {0xfb868008,0xf5b54004,0xf4bbf004,0xf921e004}},	//   像等, 医行, 市香, 本内
  { {0xf93cc00c,0xfb81600a,0x00000003,0x00000003}},	//   約市, 資用,   ,
  { {0xfb72c007,0xf943c001,0x00000003,0x00000003}},	// [1f80] 際研, 隊合,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9342005,0xfa77900d,0x00000003,0x00000003}},	//   定利, 典案,   ,
  { {0xf9234006,0xf9294006,0xf8231004,0xf91ac004}},	//   第八, 部地, 型事, 学反
  { {0xf497500f,0xf91a8004,0xf4a2f001,0x00000003}},	//   基金, 常大, 是需,
  { {0xfa675004,0xfb886005,0x00000003,0x00000003}},	//   同是, 行相,   ,
  { {0xf92d2006,0xf829f008,0xf916e005,0xf93fc005}},	//   金属, 然体, 任周, 理向
  { {0xfa639009,0xfa5f3004,0xf93ba005,0xf933800a}},	//   等活, 内未, 市元, 通園
  { {0xfa877007,0xf9134001,0xf5b5e00a,0x00000003}},	//   雨林, 報地, 活衛,
  { {0xfb6d6009,0xf9096001,0xfa61f00c,0xf597000c}},	//   盗版, 庶務, 了想, 弟象
  { {0xf8243006,0xf93ba007,0xf91c4001,0xfa4ad001}},	//   合信, 所出, 大宇, 寓教
  { {0xfa63b006,0xf5b62009,0xfb612007,0xf943a004}},	//   等方, 区行, 短篇, 等出
  { {0xf9340009,0xf58fe005,0xf92ac00a,0x00000003}},	//   会全, 五角, 享年,
  { {0xf817d005,0x00000003,0x00000003,0x00000003}},	//   属中,   ,   ,
  { {0xf9236006,0xf917e001,0xfb7ba004,0x00000003}},	//   普及, 嘻嘻, 狂的,
  { {0xf946a006,0xfa86d009,0xf938c004,0xf934c001}},	// [1f90] 之家, 被授, 属国, 食小
  { {0xfa69300f,0xf58ba008,0xf5ac000a,0xfa66100c}},	//   完整, 唐辛, 件該, 額未
  { {0xf93fa00e,0xf4b8b001,0x00000003,0x00000003}},	//   文後, 非都,   ,
  { {0xfa795007,0xfb4f0001,0xfa4b7001,0xf4a7f00c}},	//   陸投, 甲種, 道我, 含高
  { {0xfa72d00d,0x00000003,0x00000003,0x00000003}},	//   深松,   ,   ,
  { {0xf498d007,0xf915e001,0xfa83b005,0xfb65e00c}},	//   腹部, 人又, 劣汰, 周美
  { {0xfa831006,0xf8221001,0xf947c00c,0x00000003}},	//   可持, 合企, 哎呀,
  { {0xf4a4f00c,0x00000003,0x00000003,0x00000003}},	//   種非,   ,   ,
  { {0xf9432009,0xf919c004,0xfa727004,0xf4a51004}},	//   合当, 入品, 好明, 是靠
  { {0xfa54900f,0xf841700e,0xfa4f7004,0xfa885001}},	//   生態, 解体, 北湖, 火機
  { {0xfa78d004,0xf93b0004,0xf933e005,0xfb846005}},	//   出活, 流向, 会太, 再立
  { {0xfa56700b,0xf92f400f,0xfb4a4008,0xf5a1000c}},	//   高校, 協定, 茶碗, 分負
  { {0xf923e00e,0xfa643007,0xfa66b004,0x00000003}},	//   本大, 脊椎, 王新,
  { {0xf934a007,0xfa7e9004,0xf9100005,0xfb7d000c}},	//   厚度, 大拿, 石墨, 裂縫
  { {0xf9248006,0xf93f600f,0xfa5f1009,0xfa743005}},	//   是在, 故宮, 燃油, 汽摩
  { {0xf58f200f,0xf9088006,0xf944a009,0xf4bd9007}},	//   黑色, 件及, 上千, 的黑
  { {0xf818f004,0xf90d2004,0xf9186001,0xfa7a700a}},	// [1fa0] 局不, 年奥, 活報, 相澤
  { {0xf845b004,0xfb4f4001,0xfa6dd004,0xfa54f005}},	//   剩余, 味生, 曲折, 料是
  { {0xf9394009,0xf8235001,0xf599000a,0x00000003}},	//   宝典, 見一, 一躍,
  { {0xf9144007,0xfb50c004,0xfb500004,0x00000003}},	//   社大, 害群, 由税,
  { {0xf58f0005,0xfa73300a,0xf4bd5010,0xf80f5010}},	//   北苑, 阿武, 久里, 裕二
  { {0xf58c000f,0xf4ba1008,0xfa7f5004,0xfb4ba00c}},	//   間表, 停電, 面最, 其精
  { {0xf91b2006,0xfa53d00c,0x00000003,0x00000003}},	//   以在, 講活,   ,
  { {0xfb6da004,0xfa745005,0x00000003,0x00000003}},	//   少用, 好普,   ,
  { {0xfb6da006,0xfa5af001,0xfa80700c,0x00000003}},	//   民用, 要感, 代時,
  { {0xf5ba600b,0xf5a4e001,0xfa62b001,0xf9294001}},	//   特許, 籍者, 草湖, 質借
  { {0xf8319001,0xfa737004,0xfb7d2004,0xf9454005}},	//   印主, 落果, 送礼, 前存
  { {0xfa5c500a,0x00000003,0x00000003,0x00000003}},	//   品条,   ,   ,
  { {0xf5c2800b,0xfa665004,0xfb5fa004,0xf9458004}},	//   本語, 前推, 因特, 行反
  { {0xfb6ac006,0xf92d2004,0xf944200c,0x00000003}},	//   染病, 金州, 手做,
  { {0xfa7d5009,0xf5a5800d,0x00000003,0x00000003}},	//   学性, 不辞,   ,
  { {0xfa5bf008,0xfa517005,0xfa5b3002,0x00000003}},	//   心構, 受援, 送我,
  { {0xf9414006,0xf9226005,0x00000003,0x00000003}},	// [1fb0] 了大, 是合,   ,
  { {0xf4b9100e,0xfb544004,0xfa5f5005,0xfa62d002}},	//   一騎, 国用, 内注, 先曝
  { {0xfb6ba004,0xf90b4001,0xf91bc004,0xf92f4004}},	//   体研, 援多, 欧式, 湖大
  { {0xf4ac9008,0xf91a4004,0xf844f004,0xf942200d}},	//   子達, 方共, 路信, 覆地
  { {0xf9266004,0xfa775004,0xfa52f005,0xfa75100c}},	//   在充, 示感, 定指, 追殺
  { {0xfb58e007,0xf9428004,0xf8165004,0xf826d004}},	//   人知, 予充, 保不, 名信
  { {0xf921e004,0x00000003,0x00000003,0x00000003}},	//   口受,   ,   ,
  { {0xfb4cc007,0xfb768001,0xfb6f200c,0xf81a9005}},	//   具精, 生用, 法益, 送了
  { {0xf9354009,0x00000003,0x00000003,0x00000003}},	//   料加,   ,   ,
  { {0xf923e00e,0xf82a5004,0xf812d005,0x00000003}},	//   中島, 明人, 静下,
  { {0xf92e400f,0xf8329009,0xfa6f3004,0xfb618001}},	//   化南, 好一, 洲杯, 面管
  { {0xf9250001,0xfa4ed00c,0xfb81a00d,0x00000003}},	//   物名, 我改, 沉痛,
  { {0xf9408009,0xf828b00e,0xf93a4005,0xfa5cd00c}},	//   但在, 小中, 品参, 私政
  { {0xf935600f,0xf913a004,0xf9106001,0xf83f900c}},	//   察官, 使国, 疲弱, 加任
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf93bc001,0xfb696004,0xfb53c00c,0xfa54f00c}},	//   所幸, 火箭, 政白, 紙業
  { {0xf824b009,0xf9456004,0x00000003,0x00000003}},	// [1fc0] 名企, 前做,   ,
  { {0xfa62d005,0xf921e00c,0xf919000c,0xf499500a}},	//   例有, 本幅, 殺出, 相違
  { {0xfb552009,0xf58f6007,0xf5990001,0x00000003}},	//   国移, 著自, 初試,
  { {0xf92c8009,0xfa859001,0xf9462005,0xfb81800a}},	//   村居, 部消, 位器, 理簿
  { {0xfb656009,0xfa591008,0xf9366005,0xf4aff005}},	//   售票, 秀明, 期外, 法集
  { {0xf9266009,0xf81b3009,0xf5a46008,0xfb640005}},	//   在内, 求不, 草花, 可笑
  { {0xf4bad008,0xfa6f1004,0xf90f4004,0xf929a008}},	//   品通, 地最, 泰市, 頒布
  { {0xfa4d9004,0xfa81f004,0x00000003,0x00000003}},	//   成活, 般情,   ,
  { {0xf90ce00f,0xfa7a5009,0xf4909001,0xfa817010}},	//   海報, 日晚, 到首, 代打
  { {0xf9358001,0xf93c000c,0x00000003,0x00000003}},	//   記引, 的守,   ,
  { {0xf93b8009,0xf925a004,0xf82b7001,0xf9304005}},	//   一座, 目公, 究主, 北坦
  { {0xf92da007,0xf80e5007,0xfa5b3004,0xf8319004}},	//   成出, 織介, 品提, 放不
  { {0xfb4ba008,0xf8149005,0x00000003,0x00000003}},	//   刷物, 束之,   ,
  { {0xf9400006,0xfa74300f,0xfb53a009,0xf9170004}},	//   万元, 飼料, 款物, 区多
  { {0xfb7d0006,0xf4c63001,0xfa625004,0x00000003}},	//   老百, 事都, 分水,
  { {0xfb6f8001,0x00000003,0x00000003,0x00000003}},	//   純真,   ,   ,
  { {0xfa877001,0xf942e004,0xfa7f7004,0xfa65500c}},	// [1fd0] 助校, 拉利, 次比, 下波
  { {0xfb81c001,0x00000003,0x00000003,0x00000003}},	//   先看,   ,   ,
  { {0xf5a6000a,0xfa7a100a,0x00000003,0x00000003}},	//   再評, 別清,   ,
  { {0xfa583009,0xf944e007,0xf940a009,0xf9470004}},	//   保温, 型化, 安吉, 福娃
  { {0xf8321006,0xf923c009,0xfa4d3004,0xf59b6001}},	//   由中, 口号, 向成, 狂賀
  { {0xf818f007,0xfa60b004,0x00000003,0x00000003}},	//   局位, 文搜,   ,
  { {0xfb7fa00a,0xf928800d,0x00000003,0x00000003}},	//   玄米, 在入,   ,
  { {0xf94b4006,0xfa5c5007,0xf8187004,0xf49cb004}},	//   明年, 射手, 保中, 大食
  { {0xfb7ea001,0xf944e004,0xfb7ce004,0xf5a6c00c}},	//   心照, 王志, 的翅, 手買
  { {0xfa6f5001,0xf5b6200c,0xf8395005,0x00000003}},	//   平滑, 主菜, 知之,
  { {0xf4b8b007,0xf5b1200c,0x00000003,0x00000003}},	//   作金, 東莞,   ,
  { {0xf920e004,0xf9202001,0xfb5ba008,0xf9338001}},	//   中充, 正反, 武線, 站分
  { {0xfb59000e,0xfb4a4004,0xf836b004,0xfa571010}},	//   点灯, 件研, 容上, 謝料
  { {0xf92c6004,0xf92ec00c,0xfa4ed00c,0xfa87b00c}},	//   他又, 我出, 我方, 用早
  { {0xf935c008,0xf8155004,0xf90be00c,0xf5a8e005}},	//   弘器, 料信, 其已, 式解
  { {0xfb7ae001,0xf4acb004,0xf832d004,0xf5c8400c}},	//   係版, 向高, 政中, 雨跡
  { {0xf924a007,0xf836f004,0xfa4b3001,0xf9382005}},	// [1fe0] 宮博, 去世, 駐所, 朝外
  { {0xf9414009,0xfb694005,0xf808f005,0x00000003}},	//   三元, 在田, 插上,
  { {0xfa5d3004,0xf4b29001,0xf9326008,0xfa66700a}},	//   内消, 定送, 線局, 上波
  { {0xf9286006,0xfb7fe004,0xf934600a,0xf948e00c}},	//   在大, 的状, 秘境, 誌報
  { {0xf927c007,0xf91b4001,0xf592c008,0xf9448005}},	//   利基, 室出, 煙草, 予大
  { {0xf9216006,0xfb868001,0xf8113001,0xf92dc00a}},	//   模具, 事異, 五人, 字小
  { {0xf5b1a00f,0xf923e007,0xf934a007,0xfa7cb004}},	//   現行, 業家, 高分, 大悟
  { {0xfa50b001,0xf81d5004,0xf8415004,0xfa85100c}},	//   奔波, 求中, 波中, 可正
  { {0xfa64f006,0xf91e600f,0xfb62c00e,0xf5bea007}},	//   合格, 性別, 中無, 素質
  { {0xf9126001,0xf58be001,0xf8381005,0xf8133005}},	//   碰到, 間自, 出修, 料企
  { {0x00000003,0x00000003,0x00000003,0x00000003}},	//     ,   ,   ,
  { {0xf9122007,0xf915e004,0xf4999001,0xf8225005}},	//   由客, 人先, 殺防, 光体
  { {0xf93d200f,0xf920e009,0xfb818001,0xf598e008}},	//   品味, 口商, 拉的, 非課
  { {0xf833b004,0xf921e004,0xf5bd400c,0xfa60700c}},	//   放中, 郭勒, 因考, 拇指
  { {0xfb7bc009,0xf919c00e,0xf9164001,0xfa5d7001}},	//   心版, 日市, 刻停, 情歌
  { {0xf9242006,0xfa4e3006,0xf81c7004,0xfb54a005}},	//   京奥, 答案, 的住, 款相
  { {0xfa829009,0xf59e400e,0xfa7e7004,0xf4929001}},	// [1ff0] 本村, 組表, 学水, 政革
  { {0xfa653004,0xf593e004,0x00000003,0x00000003}},	//   前教, 香菜,   ,
  { {0xf4a15009,0xf91b000e,0x00000003,0x00000003}},	//   院院, 除去,   ,
  { {0xf944a006,0xfa861009,0xfb780009,0xf93b6004}},	//   及各, 在所, 宜的, 址大
  { {0xf592c007,0xfa4db007,0xfa6e3004,0xfb55e005}},	//   引述, 糖果, 育期, 出等
  { {0xf816f001,0xf93b6004,0xfa6bf005,0xf9170005}},	//   生代, 着大, 晴朗, 船名
  { {0xf945a009,0xf9230008,0xf5a04001,0xf5a90001}},	//   事大, 本化, 理自, 行職
  { {0xfb6da006,0xf90d2004,0xf5c7c008,0xfb7f400c}},	//   当然, 援建, 被覆, 爆爆
  { {0xf9376001,0xfb70000a,0xf934200a,0x00000003}},	//   期別, 動範, 妙子,
  { {0xfb8b0004,0xf5b00004,0xf8287005,0x00000003}},	//   明翰, 椰菜, 架下,
  { {0xf90a2004,0xfb776001,0xfa62900a,0xf9428002}},	//   年又, 生登, 片方, 片出
  { {0xfb86c009,0xf92ac004,0xf4ac9001,0xfa767001}},	//   嫌疑, 未入, 毒防, 示所
  { {0xf9114004,0xf93c2004,0xf90ea001,0xfa5cd005}},	//   由当, 的及, 育協, 它文
  { {0xf90da006,0xfb6f6001,0xfb72800c,0xf9446005}},	//   水平, 他知, 多省, 授学
  { {0xfb85e008,0xfb76c001,0xf919c004,0xfa653004}},	//   告編, 存空, 相差, 行消
  { {0xfa4d3004,0xf93fc001,0xf92da005,0xfa62d005}},	//   化情, 理刑, 成固, 泉港

  };

static const uint32 kCjkDeltaBiSizeOne = 33;       // One-langprob count
extern const uint32 kCjkDeltaBiIndSize = 33;       // Largest subscript
static const uint32 kCjkDeltaBiInd[kCjkDeltaBiIndSize] = {
  // [0000]
  0x00000000, 0x00001d2d, 0x00001d1c, 0x00000000,
  0x0000052d, 0x00000524, 0x00000542, 0x00001d37,
  0x0000022d, 0x00000537, 0x00000224, 0x00000242,
  0x00001d24, 0x0000051c, 0x00000237, 0x00001d42,
  // [0010]
  0x0000021c, 0x0200053f, 0x05001d40, 0x00000515,
  0x0000020f, 0x05001d35, 0x05001d3f, 0x05001d3e,
  0x00001d15, 0x1d00053f, 0x1d00054b, 0x1d000240,
  0x02001d4b, 0x05001d4b, 0x1d000535, 0x00001d0f,
  // [0020]
  0x05001d36, };

// COMPILE_ASSERT(33 <= (1 << 12), k_indirectbits_too_small);


extern const CLD2TableSummary kCjkDeltaBi_obj = {
  kCjkDeltaBi,
  kCjkDeltaBiInd,
  kCjkDeltaBiSizeOne,
  kCjkDeltaBiSize,
  kCjkDeltaBiKeyMask,
  kCjkDeltaBiBuildDate,
  kCjkDeltaBiRecognizedLangScripts,
};

}       // End namespace CLD2

// End of generated tables

