/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.IntComplementSet;
import net.sf.saxon.expr.sort.IntEmptySet;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntSet;

public class IntUniversalSet
implements IntSet {
    private static IntUniversalSet THE_INSTANCE = new IntUniversalSet();

    public static IntUniversalSet getInstance() {
        return THE_INSTANCE;
    }

    private IntUniversalSet() {
    }

    public IntSet copy() {
        return this;
    }

    public IntSet mutableCopy() {
        return new IntComplementSet(new IntHashSet());
    }

    public void clear() {
        throw new UnsupportedOperationException("IntUniversalSet is immutable");
    }

    public int size() {
        return Integer.MAX_VALUE;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean contains(int value) {
        return true;
    }

    public boolean remove(int value) {
        throw new UnsupportedOperationException("IntUniversalSet is immutable");
    }

    public boolean add(int value) {
        throw new UnsupportedOperationException("IntUniversalSet is immutable");
    }

    public IntIterator iterator() {
        throw new UnsupportedOperationException("Cannot enumerate an infinite set");
    }

    public IntSet union(IntSet other) {
        return this;
    }

    public IntSet intersect(IntSet other) {
        return other.copy();
    }

    public IntSet except(IntSet other) {
        if (other instanceof IntUniversalSet) {
            return IntEmptySet.getInstance();
        }
        return new IntComplementSet(other.copy());
    }

    public boolean containsAll(IntSet other) {
        return true;
    }
}

