# Generated by default/object.tt
package Paws::SESv2::AccountDetails;
  use Moose;
  has AdditionalContactEmailAddresses => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ContactLanguage => (is => 'ro', isa => 'Str');
  has MailType => (is => 'ro', isa => 'Str');
  has ReviewDetails => (is => 'ro', isa => 'Paws::SESv2::ReviewDetails');
  has UseCaseDescription => (is => 'ro', isa => 'Str');
  has WebsiteURL => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::AccountDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::AccountDetails object:

  $service_obj->Method(Att1 => { AdditionalContactEmailAddresses => $value, ..., WebsiteURL => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::AccountDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AdditionalContactEmailAddresses

=head1 DESCRIPTION

An object that contains information about your account details.

=head1 ATTRIBUTES


=head2 AdditionalContactEmailAddresses => ArrayRef[Str|Undef]

Additional email addresses where updates are sent about your account
review process.


=head2 ContactLanguage => Str

The language you would prefer for the case. The contact language can be
one of C<ENGLISH> or C<JAPANESE>.


=head2 MailType => Str

The type of email your account is sending. The mail type can be one of
the following:

=over

=item *

C<MARKETING> E<ndash> Most of your sending traffic is to keep your
customers informed of your latest offering.

=item *

C<TRANSACTIONAL> E<ndash> Most of your sending traffic is to
communicate during a transaction with a customer.

=back



=head2 ReviewDetails => L<Paws::SESv2::ReviewDetails>

Information about the review of the latest details you submitted.


=head2 UseCaseDescription => Str

A description of the types of email that you plan to send.


=head2 WebsiteURL => Str

The URL of your website. This information helps us better understand
the type of content that you plan to send.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

