# Generated by default/object.tt
package Paws::Route53::HostedZoneOwner;
  use Moose;
  has OwningAccount => (is => 'ro', isa => 'Str');
  has OwningService => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53::HostedZoneOwner

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53::HostedZoneOwner object:

  $service_obj->Method(Att1 => { OwningAccount => $value, ..., OwningService => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53::HostedZoneOwner object:

  $result = $service_obj->Method(...);
  $result->Att1->OwningAccount

=head1 DESCRIPTION

A complex type that identifies a hosted zone that a specified Amazon
VPC is associated with and the owner of the hosted zone. If there is a
value for C<OwningAccount>, there is no value for C<OwningService>, and
vice versa.

=head1 ATTRIBUTES


=head2 OwningAccount => Str

If the hosted zone was created by an AWS account, or was created by an
AWS service that creates hosted zones using the current account,
C<OwningAccount> contains the account ID of that account. For example,
when you use AWS Cloud Map to create a hosted zone, Cloud Map creates
the hosted zone using the current AWS account.


=head2 OwningService => Str

If an AWS service uses its own account to create a hosted zone and
associate the specified VPC with that hosted zone, C<OwningService>
contains an abbreviation that identifies the service. For example, if
Amazon Elastic File System (Amazon EFS) created a hosted zone and
associated a VPC with the hosted zone, the value of C<OwningService> is
C<efs.amazonaws.com>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

