package Geo::SpatialDB::Entity;
$Geo::SpatialDB::Entity::VERSION = '0.000_001'; # TRIAL

$Geo::SpatialDB::Entity::VERSION = '0.000001';use Moo 2;
use namespace::clean;

# ABSTRACT: A logical thing found on a map (as opposed to the physical features that form it)

has id   => ( is => 'rw' );
has type => ( is => 'rw' );
has tags => ( is => 'rw' );

sub TO_JSON {
	my $self= shift;
	my %data= %$self;
	for (keys %data) {
		delete $data{$_}
			if $_ =~ /^[^a-z]/
			or !defined $data{$_}
			or (ref $data{$_} eq 'HASH' && !keys %{ $data{$_} });
	}
	\%data;
}

sub tag {
	my ($self, $key)= @_;
	return $self->{tags}{$key};
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Geo::SpatialDB::Entity - A logical thing found on a map (as opposed to the physical features that form it)

=head1 VERSION

version 0.000_001

=head1 AUTHOR

Michael Conrad <mike@nrdvana.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Michael Conrad.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
