# Generated by default/object.tt
package Paws::LookoutMetrics::TimeSeries;
  use Moose;
  has DimensionList => (is => 'ro', isa => 'ArrayRef[Paws::LookoutMetrics::DimensionNameValue]', required => 1);
  has MetricValueList => (is => 'ro', isa => 'ArrayRef[Num]', required => 1);
  has TimeSeriesId => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::TimeSeries

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::TimeSeries object:

  $service_obj->Method(Att1 => { DimensionList => $value, ..., TimeSeriesId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::TimeSeries object:

  $result = $service_obj->Method(...);
  $result->Att1->DimensionList

=head1 DESCRIPTION

Details about a metric. A metric is an aggregation of the values of a
measure for a dimension value, such as I<availability> in the
I<us-east-1> Region.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DimensionList => ArrayRef[L<Paws::LookoutMetrics::DimensionNameValue>]

The dimensions of the metric.


=head2 B<REQUIRED> MetricValueList => ArrayRef[Num]

The values for the metric.


=head2 B<REQUIRED> TimeSeriesId => Str

The ID of the metric.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

