
package Paws::ElastiCache::CreateCacheSecurityGroup;
  use Moose;
  has CacheSecurityGroupName => (is => 'ro', isa => 'Str', required => 1);
  has Description => (is => 'ro', isa => 'Str', required => 1);
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::ElastiCache::Tag]');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'CreateCacheSecurityGroup');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::ElastiCache::CreateCacheSecurityGroupResult');
  class_has _result_key => (isa => 'Str', is => 'ro', default => 'CreateCacheSecurityGroupResult');
1;

### main pod documentation begin ###

=head1 NAME

Paws::ElastiCache::CreateCacheSecurityGroup - Arguments for method CreateCacheSecurityGroup on L<Paws::ElastiCache>

=head1 DESCRIPTION

This class represents the parameters used for calling the method CreateCacheSecurityGroup on the
L<Amazon ElastiCache|Paws::ElastiCache> service. Use the attributes of this class
as arguments to method CreateCacheSecurityGroup.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to CreateCacheSecurityGroup.

=head1 SYNOPSIS

    my $elasticache = Paws->service('ElastiCache');
   # CreateCacheSecurityGroup
   # Creates an ElastiCache security group. ElastiCache security groups are only
   # for clusters not running in an AWS VPC.
    my $CreateCacheSecurityGroupResult = $elasticache->CreateCacheSecurityGroup(
      'CacheSecurityGroupName' => 'my-cache-sec-grp',
      'Description'            => 'Example ElastiCache security group.'
    );


Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/elasticache/CreateCacheSecurityGroup>

=head1 ATTRIBUTES


=head2 B<REQUIRED> CacheSecurityGroupName => Str

A name for the cache security group. This value is stored as a
lowercase string.

Constraints: Must contain no more than 255 alphanumeric characters.
Cannot be the word "Default".

Example: C<mysecuritygroup>



=head2 B<REQUIRED> Description => Str

A description for the cache security group.



=head2 Tags => ArrayRef[L<Paws::ElastiCache::Tag>]

A list of tags to be added to this resource. A tag is a key-value pair.
A tag key must be accompanied by a tag value, although null is
accepted.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method CreateCacheSecurityGroup in L<Paws::ElastiCache>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

