/*    MessageFormat.xs
 *
 *    $Id: MessageFormat.xs,v 1.4 2001/07/22 03:47:36 mrperl Exp $
 *
 *    Copyright (c) 2000 Brian Stell and James
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/picu_util.h"
#include  "picu/Locale.h"
#include  "picu/MessageFormat.h"
#include  "unicode/datefmt.h"
#include  "unicode/msgfmt.h"
#include  "unicode/smpdtfmt.h"
#include  "unicode/timezone.h"

char *MessageFormat_class_string = "ICU::MessageFormat"; 

static int debugLevel = 0;

/*
 * Note: constant_iv returns a integer (not double)
 */
static IV
constant_iv(char *name, int arg)
{
    errno = 0;
    switch (*name) {
#if 0
add more cases as needed
    case 'A':
        break;
#endif
    case 'k':
        if (!(*(name+1))) {
            goto not_there;
        }
        switch (*(name+1)) {
            case 'M':
                if (strEQ(name, "kMaxFormat"))
                    return MessageFormat::kMaxFormat;
                break;
        }
        break;
    }
    errno = EINVAL;
    return 0;

/* if a value should be defined but is not */
not_there:
    errno = ENOENT;
    return 0;
}

typedef enum MessageFormat::EFormatNumber MessageFormat__EFormatNumber;

MODULE = ICU::MessageFormat    PACKAGE = ICU::MessageFormat  

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

IV
constant_iv(name,arg)
        char *name
        int   arg

int
MessageFormat::MessageFormat(...)
    PREINIT:
	UnicodeString pattern;
	UErrorCode status = U_ZERO_ERROR;
	SV *sv_status = NULL;
    CODE:
        MessageFormat::MessageFormat(pattern, status);
	RETVAL = 1;
    OUTPUT:
        RETVAL

void
MessageFormat::DESTROY()
    CODE:
        DEBUG100("MessageFormat::DESTROY()");
	delete THIS;
        DEBUG100("MessageFormat::DESTROY()");

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::MessageFormat::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL


