#!/usr/bin/perl

package eBay::API::XML::DataType::PaginatedItemArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PaginatedItemArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::PaginatedItemArrayType

=head1 DESCRIPTION

Contains a paginated list of items.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::PaginatedItemArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemArrayType;
use eBay::API::XML::DataType::PaginationResultType;


my @gaProperties = ( [ 'ItemArray', 'ns:ItemArrayType', ''
	     ,'eBay::API::XML::DataType::ItemArrayType', '1' ]
	, [ 'PaginationResult', 'ns:PaginationResultType', ''
	     ,'eBay::API::XML::DataType::PaginationResultType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setItemArray()

Contains a list of Item types.

#    Argument: 'ns:ItemArrayType'

=cut

sub setItemArray {
  my $self = shift;
  $self->{'ItemArray'} = shift
}

=head2 getItemArray()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           BestOfferList
           LostList
           WatchList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           UnsoldList
           BidList
           DeletedFromUnsoldList

#    Returns: 'ns:ItemArrayType'

=cut

sub getItemArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemArray'
		,'eBay::API::XML::DataType::ItemArrayType');
}


=head2 setPaginationResult()

Provides information about the list, including number of pages and number
of entries.

#    Argument: 'ns:PaginationResultType'

=cut

sub setPaginationResult {
  my $self = shift;
  $self->{'PaginationResult'} = shift
}

=head2 getPaginationResult()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WatchList
           WonList
           DeletedFromLostList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: ActiveList
           ScheduledList
           SoldList
           UnsoldList
           BidList
           DeletedFromSoldList
           DeletedFromUnsoldList

#    Returns: 'ns:PaginationResultType'

=cut

sub getPaginationResult {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaginationResult'
		,'eBay::API::XML::DataType::PaginationResultType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
