#!/usr/bin/perl
# $File: //member/autrijus/Lingua-ZH-TaBE/t/1-basic.t $ $Author: autrijus $
# $Revision: #11 $ $Change: 9666 $ $DateTime: 2004/01/11 12:36:44 $

use Test;

BEGIN { plan tests => 14 }

require Lingua::ZH::TaBE;
ok($Lingua::ZH::TaBE::VERSION) if $Lingua::ZH::TaBE::VERSION or 1;

my $tabe = Lingua::ZH::TaBE->new;

ok(ref($tabe), 'Lingua::ZH::TaBE', 'blessing TaBE object');

my $tsi = $tabe->Tsi("");

ok( "$tsi", "", 'Tsi stringification' );

ok(
    join(',', $tsi->yins),
    ",",
    'PossibleTsiYin()',
);

ok(
    $tsi->yins->[0] * 1,
    8216,
    'yins() overload',
);

my $chu = $tabe->Chu("DAWCѡC");
ok(
    join(",", $chu->chunks),
    "D,A,WC,C",
    'PossibleTsiYin()',
);

my $chunk = $chu->chunks->[0];
ok(
    join(",", $chunk->tsis),
    "D,,",
    'Segmentation',
);

ok(
    $tabe->Chu("DiDAD`DC")
	->chunks->[2]	    # D`D
	->tsis->[0]	    # D`
	->zhis->[1]	    # `
	->yins->[0]	    # 
	->zuyins->[0],	    # 
    "",
    'tsis->zhis',
);


# ۰_
my @words = $tabe->split(
    "ڭ̦bqBzT,۫H䤤̴oHp@,".
    "LQrXӤF."
);

ok(
    join(",", @words),
    ",ڭ,b,q,,Bz,,T,,۫H,䤤,,oH,,p,@,L,Q,,r,,X,F",
    'split($string)'
);

# _
@words = $tabe->split(
    "ڭ̦bqBzT,۫H䤤̴oHp@,".
    "LQrXӤF.", "Complex"
);

ok(
    join(",", @words),
    ",ڭ,b,q,,Bz,,T,,۫H,䤤,,oH,,p,@,L,Q,,r,,X,ӤF",
    'split($string, "Complex")'
);

# fV_
@words = $tabe->split(
    "ڭ̦bqBzT,۫H䤤̴oHp@,".
    "LQrXӤF.", "Backward"
);

ok(
    join(",", @words),
    ",ڭ,b,q,,Bz,,T,,۫H,䤤,,oH,,p,@,L,Q,,r,,X,ӤF",
    'split($string, "Backward")'
);

# iμƦrΤrإ Zhi 
ok(
    $tabe->Zhi(42056),
    $tabe->Zhi('H'),
    "Zhi() dualvar"
);

#  "~" Pr
ok(
    join(",", $tabe->Zhi('~')->yins->[0]->zhis),
    "M,~,,,k,,,,,X,,v,F,,,c,թ,C,ھ,r,,Z,,_,A,T,,,,g,_,F,p,F,,u,",
    "Zhi->yins->zhis()"
);

ok(
    $tabe->ZuYin('')->zhi->yins->[0]->zhis->[0],
    '',
    "Yin->zhis"
);

1;
