#!/usr/bin/perl 
use X11::Xforms;
#-*-perl-*-
# Autogenerated by fd2pl from fdesign file /root/xgrep.c
#
#

$editskel="vi -geometry 80x42 +%s %s";

$xgrep = undef;
$ResultBrowser = undef;
$SearchButton  = undef;
$SearchMessage = undef;
$pattern = "";

sub create_form_xgrep {
  $obj = undef;
  $xgrep = fl_bgn_form(FL_NO_BOX, 535, 220);
  $obj = fl_add_box(FL_FLAT_BOX, 0, 0, 535, 220, "");
    fl_set_object_lsize($obj, FL_NORMAL_SIZE);
  $obj = fl_add_browser(FL_HOLD_BROWSER, 6, 6, 522, 177, "");
    fl_set_object_gravity($obj, FL_NorthWest, FL_SouthEast);
    $ResultBrowser = $obj;
    fl_set_object_lsize($obj, FL_NORMAL_SIZE);
    fl_set_object_callback($obj, "dummy", 0);
    fl_set_browser_dblclick_callback($obj, "execute_result", 0);
    fl_set_browser_fontsize($obj, FL_NORMAL_SIZE);
    fl_set_browser_fontstyle($obj, FL_FIXED_STYLE);
    fl_set_object_color($obj, FL_WHITE, FL_RED);
  $obj = fl_add_button(FL_NORMAL_BUTTON, 5, 186, 125, 30, "Search");  
    $SearchButton = $obj;
    fl_set_object_resize($obj, FL_RESIZE_NONE);
    fl_set_object_gravity($obj, FL_SouthWest,FL_ForgetGravity );
    fl_set_object_lsize($obj, FL_NORMAL_SIZE);
    fl_set_object_callback($obj, "execute_search", 0);
  $obj = fl_add_button(FL_NORMAL_BUTTON, 135, 186, 125, 30, "Exit");
    fl_set_object_resize($obj, FL_RESIZE_NONE);
    fl_set_object_gravity($obj, FL_SouthWest, FL_ForgetGravity);
  $obj = fl_add_text(FL_NORMAL_TEXT, 265, 186, 265, 30, " ");
    fl_set_object_lsize($obj, FL_NORMAL_SIZE);
    $SearchMessage = $obj;
  fl_end_form();
}

sub create_the_forms {
  create_form_xgrep();
}

sub execute_search {
  fl_deactivate_form($xgrep); 

  my($args) = fl_show_input("Enter the grep arguments", $pattern);
  if ($args ne "")
  {
       $pattern = $args;
       populate_browser($args);
  }

  fl_activate_form($xgrep);
}

sub populate_browser {

  my($args) = @_;

  if ($args ne "")
  {
    fl_set_object_label($SearchMessage, "Status: Searching ...");
    fl_clear_browser($ResultBrowser);
    fl_freeze_form($xgrep);
    open(GREP, "cat /dev/null | grep -n $args |");

    $results = 0;
    while(<GREP>) {
      chop;
      fl_add_browser_line($ResultBrowser, $_);
      $results++;
    }
    close GREP;
    fl_unfreeze_form($xgrep);
    fl_set_object_label($SearchMessage, "Status: $results occurences found");
  }
}

sub dummy {
}

sub execute_result {

  my($obj, $parm) = @_;

  ($file, $line, $text) = split(/:/,fl_get_browser_line($obj, fl_get_browser($obj)));

  if (-f $file) {
		$command = sprintf("$editskel", $line, $file);
                exec("$command\n") if(!fork());
  }
}

$SIG{CHLD} = 'IGNORE';
close(STDIN);
$pattern = "@ARGV";
@ARGV=undef;
fl_initialize('ProcCntl');

#
# How to use edit key maps to make Delete and Backspace work!!
#
$keymap = X11::Xforms::FLEditKeymap::new;
$keymap->del_prev_char(8);
$keymap->del_next_char(127);
fl_set_input_editkeymap($keymap);

create_the_forms();
populate_browser($pattern);
fl_show_form($xgrep, FL_PLACE_FREE, FL_FULLBORDER, "XGrep");
fl_do_forms();
exit 0;
    
