#!perl -T
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More tests => 5;
use Encode::Wechsler;
use Data::Dumper;

my $wechsler = Encode::Wechsler->new( pad => 1 );

is $wechsler->decode( 'xq4_27deee6' ), 
".........
..**.....
.**.****.
..******.
...****..
.........
", 'pad 1 - xq4_27deee6 decoded correctly';

$wechsler = Encode::Wechsler->new( pad => 2 );
is $wechsler->decode( 'xs31_0ca178b96z69d1d96' ), 
".............
.............
.....**.**...
....*.*.*.*..
...*..*...*..
...**..***...
.............
...*****.....
..*.....*....
..*.*.*.*....
...**.**.....
.............
.............
", 'pad 2 - xs31_0ca178b96z69d1d96 decoded correctly';

$wechsler = Encode::Wechsler->new( pad => 3 );
is $wechsler->decode( 'xp30_w33z8kqrqk8zzzx33' ), 
".............
.............
.............
.....**......
.....**......
.............
.............
.............
......*......
.....***.....
....*...*....
...*.***.*...
....*****....
.............
.............
.............
.............
.............
.............
.............
.............
.............
.............
......**.....
......**.....
.............
.............
.............
.............
", 'pad 3 - xp30_w33z8kqrqk8zzzx33 decoded correctly';

$wechsler = Encode::Wechsler->new( pad => 4 );
is $wechsler->decode( 'xp2_31a08zy0123cko' ), 
"..................
..................
..................
..................
....**............
....*.*...........
..................
......*.*.........
..................
........*.*.......
.........**.......
...........**.....
...........*.*....
............**....
..................
..................
..................
..................
", 'pad 4 - xp2_31a08zy0123cko decoded correctly';

is $wechsler->decode( 'xp30_ccx8k2s3yagzy3103yaheha4xcczyk1' ), 
"..........................................
..........................................
..........................................
..........................................
.............*............................
...........*.*............................
....**....*.*.............................
....**...*..*.............................
..........*.*...............*.............
...........*.*..............*.*...........
.............*...............*.*..........
.............................*..*...**....
.............................*.*....**....
............................*.*...........
............................*.............
..........................................
..........................................
..........................................
..........................................
..........................................
..........................................
", 'pad 4 - xp30_ccx8k2s3yagzy3103yaheha4xcczyk1 decoded correctly';
