package Dancer2::Plugin::Polite;

use strict;
use warnings;

use Dancer2::Plugin;

 
plugin_keywords 'add_smileys';
 
has smiley => (
    is => 'ro',
    default => sub {
        $_[0]->config->{smiley} || ':-)'
    }
);
 
sub BUILD {
    my $plugin = shift;
 
    $plugin->app->add_hook( Dancer2::Core::Hook->new(
        name => 'after',
        code => sub { $_[0]->content( $_[0]->content . " ... please?" ) }
    ));
 
    $plugin->app->add_route(
        method => 'get',
        regexp => '/goodbye',
        code   => sub {
            my $app = shift;
            'farewell, ' . $app->request->params->{name};
        },
    );
 
}
 
sub add_smileys {
    my( $plugin, $text ) = @_;
 
    $text =~ s/ (?<= \. ) / $plugin->smiley /xeg;
 
    return $text;
}
 
1; 

