/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ArrowAndParticipant
extends Arrow
implements InGroupable {
    private final Arrow arrow;
    private final ParticipantBox participantBox;

    public ArrowAndParticipant(StringBounder stringBounder, Arrow arrow, ParticipantBox participantBox) {
        super(arrow.getStartingY(), arrow.getSkin(), arrow.getArrowComponent(), arrow.getUrl());
        this.arrow = arrow;
        this.participantBox = participantBox;
        arrow.setPaddingArrowHead(participantBox.getPreferredWidth(stringBounder) / 2.0);
    }

    public void setMaxX(double d) {
        super.setMaxX(d);
        this.arrow.setMaxX(d);
    }

    public final double getArrowOnlyWidth(StringBounder stringBounder) {
        return this.arrow.getPreferredWidth(stringBounder) + this.participantBox.getPreferredWidth(stringBounder) / 2.0;
    }

    public double getArrowYEndLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYEndLevel(stringBounder);
    }

    public double getArrowYStartLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYStartLevel(stringBounder);
    }

    public int getDirection(StringBounder stringBounder) {
        return this.arrow.getDirection(stringBounder);
    }

    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition notePosition) {
        return this.arrow.getParticipantAt(stringBounder, notePosition);
    }

    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        double d2;
        double d3 = this.participantBox.getStartingX();
        double d4 = this.arrow.getStartingX(uGraphic.getStringBounder());
        if (d4 < d3) {
            this.arrow.drawInternalU(uGraphic, d, context2D);
        } else {
            d2 = this.participantBox.getPreferredWidth(uGraphic.getStringBounder());
            this.arrow.drawInternalU(uGraphic.apply(new UTranslate(d2 / 2.0, 0.0)), d, context2D);
        }
        d2 = this.arrow.getPreferredHeight(uGraphic.getStringBounder());
        double d5 = this.participantBox.getHeadHeight(uGraphic.getStringBounder());
        double d6 = 0.0;
        if (d2 > d5) {
            d6 = d2 - d5;
        }
        this.participantBox.drawParticipantHead(uGraphic.apply(new UTranslate(d3, this.getStartingY() + d6)));
    }

    private double getDiff(UGraphic uGraphic) {
        double d = this.arrow.getPreferredHeight(uGraphic.getStringBounder());
        double d2 = this.participantBox.getHeadHeight(uGraphic.getStringBounder());
        double d3 = d - d2;
        return d3;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return Math.max(this.arrow.getPreferredHeight(stringBounder), this.participantBox.getHeadHeight(stringBounder));
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.arrow.getPreferredWidth(stringBounder) + this.participantBox.getPreferredWidth(stringBounder) / 2.0;
    }

    public double getActualWidth(StringBounder stringBounder) {
        return this.arrow.getActualWidth(stringBounder) + this.participantBox.getPreferredWidth(stringBounder) / 2.0;
    }

    public double getStartingX(StringBounder stringBounder) {
        return this.arrow.getStartingX(stringBounder);
    }

    public double getMaxX(StringBounder stringBounder) {
        return this.arrow.getMaxX(stringBounder);
    }

    public double getMinX(StringBounder stringBounder) {
        return this.arrow.getMinX(stringBounder);
    }

    public String toString(StringBounder stringBounder) {
        return this.arrow.toString(stringBounder);
    }
}

